/**
 * Flexbox Container
 * Nested Switcher
 * 
 * @package Flexbox Container
 * @since 1.2.0
 */

'use strict';

window.alpusFlexbox = window.alpusFlexbox || {};

(function ($) {

    $(window).on('elementor/frontend/init', function () {
        if (elementorFrontend && elementorModules.frontend) {
            class AlpusSwitcher extends elementorModules.frontend.handlers.Base {
                onInit() {
                    if (elementorFrontend.isEditMode()) {
                        this.findElement(".e-con").each((function () {
                            if (!jQuery(this).parent().hasClass('switcher-content')) {
                                jQuery(this).wrap('<div class="switcher-content"></div>')
                            }
                        }));

                        var ids = [this.findElement('.switcher-switch:first-child span').attr('data-target'), this.findElement('.switcher-switch:last-child span').attr('data-target')];

                        $(this.findElement('.switcher-content')[0]).addClass('active');
                        $(this.findElement('.switcher-content')[0]).attr('data-id', ids[0]);
                        if ($(this.findElement('.switcher-content')).length > 1) {
                            $(this.findElement('.switcher-content')[1]).attr('data-id', ids[1]);
                        }
                    }

                    this.onStart();

                    elementorModules.frontend.handlers.Base.prototype.onInit.apply(this, arguments);
                }
                onStart() {
                    this.findElement('.switcher-switch span').on('click', function () {
                        var $this = $(this),
                            id = $this.attr('data-target');
                        $this.parent().addClass('active').siblings().removeClass('active');
                        $this.closest('.alpus-nested-switcher-wrapper').find('.switcher-contents [data-id="' + id + '"]').addClass('active').siblings().removeClass('active');
                    })
                    this.findElement('.switcher-toggle').on('click', function () {
                        $(this).siblings('.switcher-switch:not(.active)').find('span').trigger('click');
                    })
                }
                onEditSettingsChange(propertyName, value) {
                    if ('activeItemIndex' === propertyName) {
                        this.changeActiveTab(value, false);
                    }
                }
                changeActiveTab(index) {
                    if (index == 1) {
                        this.findElement('.switcher-switch:first-child').find('span').trigger('click');
                    } else {
                        this.findElement('.switcher-switch:last-child').find('span').trigger('click');
                    }
                }
            }
            alpusFlexbox.SwitcherHandler = AlpusSwitcher;
            elementorFrontend.elementsHandler.attachHandler('alpus-nested-switcher', AlpusSwitcher);
        }
    })
})(jQuery);