<?php
$soleil_slider_sc = soleil_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $soleil_slider_sc ) && strpos( $soleil_slider_sc, '[' ) !== false && strpos( $soleil_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( soleil_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$soleil_anchor_icon = soleil_get_theme_option( 'front_page_title_anchor_icon' );
		$soleil_anchor_text = soleil_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $soleil_anchor_icon ) || ! empty( $soleil_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $soleil_anchor_icon ) ? ' icon="' . esc_attr( $soleil_anchor_icon ) . '"' : '' )
									. ( ! empty( $soleil_anchor_text ) ? ' title="' . esc_attr( $soleil_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $soleil_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$soleil_scheme = soleil_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $soleil_scheme ) && ! soleil_is_inherit( $soleil_scheme ) ) {
			echo ' scheme_' . esc_attr( $soleil_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( soleil_get_theme_option( 'front_page_title_paddings' ) );
		if ( soleil_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$soleil_css      = '';
		$soleil_bg_image = soleil_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $soleil_bg_image ) ) {
			$soleil_css .= 'background-image: url(' . esc_url( soleil_get_attachment_url( $soleil_bg_image ) ) . ');';
		}
		if ( ! empty( $soleil_css ) ) {
			echo ' style="' . esc_attr( $soleil_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$soleil_anchor_icon = soleil_get_theme_option( 'front_page_title_anchor_icon' );
		$soleil_anchor_text = soleil_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $soleil_anchor_icon ) || ! empty( $soleil_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $soleil_anchor_icon ) ? ' icon="' . esc_attr( $soleil_anchor_icon ) . '"' : '' )
									. ( ! empty( $soleil_anchor_text ) ? ' title="' . esc_attr( $soleil_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( soleil_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' soleil-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$soleil_css      = '';
			$soleil_bg_mask  = soleil_get_theme_option( 'front_page_title_bg_mask' );
			$soleil_bg_color_type = soleil_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $soleil_bg_color_type ) {
				$soleil_bg_color = soleil_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $soleil_bg_color_type ) {
				$soleil_bg_color = soleil_get_scheme_color( 'bg_color', $soleil_scheme );
			} else {
				$soleil_bg_color = '';
			}
			if ( ! empty( $soleil_bg_color ) && $soleil_bg_mask > 0 ) {
				$soleil_css .= 'background-color: ' . esc_attr(
					1 == $soleil_bg_mask ? $soleil_bg_color : soleil_hex2rgba( $soleil_bg_color, $soleil_bg_mask )
				) . ';';
			}
			if ( ! empty( $soleil_css ) ) {
				echo ' style="' . esc_attr( $soleil_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$soleil_caption = soleil_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $soleil_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $soleil_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $soleil_caption, 'soleil_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$soleil_description = soleil_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $soleil_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $soleil_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $soleil_description ), 'soleil_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( soleil_get_theme_option( 'front_page_title_button1_link' ) != '' || soleil_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						soleil_show_layout( soleil_customizer_partial_refresh_front_page_title_button1_link() );
						soleil_show_layout( soleil_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
