<?php

/**
 * Custom icons for this theme.
 *
 * @package WordPress
 * @subpackage Twenty_Twenty
 * @since Twenty Twenty 1.0
 */

namespace Togo;

/**
 * SVG ICONS CLASS
 * Retrieve the SVG code for the specified icon. Based on a solution in Twenty Nineteen.
 */
class Icon
{

        /**
         * Store the code for all SVGs in an array.
         *
         * @since 1.0.0
         *
         * @return string
         */
        public static $icons = array(
                'academic-hat' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.2173 3.49965C12.7963 2.83345 11.2038 2.83345 9.7828 3.49965L3.0916 6.63664C1.63613 7.31899 1.63614 9.68105 3.0916 10.3634L9.78272 13.5003C11.2037 14.1665 12.7962 14.1665 14.2172 13.5003L20.9084 10.3634C22.3639 9.68101 22.3639 7.31895 20.9084 6.63659L14.2173 3.49965Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M22 8.5V13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5 11.5V16.6254C5 19.5429 9.69412 21 12 21C14.3059 21 19 19.5429 19 16.6254V11.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'accessibility' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 9.5L12 10.2778M12 10.2778L16 9.5M12 10.2778V12.6111M12 12.6111L10.4 16.5M12 12.6111L13.6 16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 7.25L12 7.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'activity' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 12H18.0379C17.8273 12 17.722 12 17.6329 12.0418C17.5542 12.0786 17.4849 12.1384 17.4315 12.2154C17.371 12.3026 17.3397 12.4203 17.2772 12.6557L15.4597 19.5011C15.2274 20.3762 15.1112 20.8137 14.9362 20.9271C14.785 21.0251 14.6012 21.0242 14.4507 20.9249C14.2764 20.81 14.1631 20.3714 13.9365 19.4943L10.0635 4.50569C9.8369 3.62855 9.72358 3.18999 9.54933 3.07506C9.39878 2.97576 9.21501 2.97494 9.06381 3.07289C8.88882 3.18626 8.77265 3.62381 8.5403 4.4989L6.72278 11.3443C6.66027 11.5797 6.62901 11.6974 6.5685 11.7846C6.51508 11.8616 6.44576 11.9214 6.3671 11.9582C6.27801 12 6.17269 12 5.96205 12H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'activity-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17 12H15L13 17L11 7L9 12H7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'add-queue' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 9V19.4C3 19.9601 3 20.2399 3.10899 20.4538C3.20487 20.642 3.35774 20.7952 3.5459 20.8911C3.7596 21 4.0395 21 4.59846 21H15.0001M14 13V10M14 10V7M14 10H11M14 10H17M7 13.8002V6.2002C7 5.08009 7 4.51962 7.21799 4.0918C7.40973 3.71547 7.71547 3.40973 8.0918 3.21799C8.51962 3 9.08009 3 10.2002 3H17.8002C18.9203 3 19.4801 3 19.9079 3.21799C20.2842 3.40973 20.5905 3.71547 20.7822 4.0918C21.0002 4.51962 21.0002 5.07969 21.0002 6.19978L21.0002 13.7998C21.0002 14.9199 21.0002 15.48 20.7822 15.9078C20.5905 16.2841 20.2842 16.5905 19.9079 16.7822C19.4805 17 18.9215 17 17.8036 17H10.1969C9.07899 17 8.5192 17 8.0918 16.7822C7.71547 16.5905 7.40973 16.2842 7.21799 15.9079C7 15.4801 7 14.9203 7 13.8002Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'aeroplane' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.1338 6.99174L17.5302 3.5953C18.324 2.80157 19.611 2.80157 20.4047 3.5953C21.1984 4.38903 21.1984 5.67603 20.4047 6.46976L17.0083 9.8662L18.8459 19.0105C19.0815 20.1813 16.8122 21.8105 16.2084 20.2616L13.5175 13.357L10.0246 16.8498C10.1959 18.8912 10.2321 19.5692 8.80122 21L6.62615 17.3738L3 15.1988C4.43086 13.7679 5.10878 13.8041 7.15018 13.9754L10.643 10.4825L3.73938 7.79163C2.18953 7.18827 3.81809 4.91835 4.98946 5.15405L14.1338 6.99174Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'airplay' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.632 16.5112C12.4159 16.2272 12.3079 16.0852 12.1774 16.0338C12.063 15.9887 11.937 15.9887 11.8226 16.0338C11.6921 16.0852 11.5841 16.2272 11.368 16.5112L9.00531 19.6172C8.66857 20.0598 8.50019 20.2812 8.5 20.4675C8.49983 20.6295 8.56987 20.7827 8.69027 20.8838C8.8287 21 9.09823 21 9.63729 21H14.3627C14.9018 21 15.1713 21 15.3097 20.8838C15.4301 20.7827 15.5002 20.6295 15.5 20.4675C15.4998 20.2812 15.3314 20.0598 14.9947 19.6172L12.632 16.5112Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17.4 18H18C19.6569 18 21 16.6569 21 15V6C21 4.34315 19.6569 3 18 3H6C4.34315 3 3 4.34315 3 6V15C3 16.6569 4.34315 18 6 18H6.6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'airpods' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 18V8C10 6.067 8.433 4.5 6.5 4.5C4.567 4.5 3 6.067 3 8C3 9.933 4.567 11.5 6.5 11.5C6.77423 11.4936 7 11.7141 7 11.9884V18C7 18.8284 7.67157 19.5 8.5 19.5C9.32843 19.5 10 18.8284 10 18Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 18V8C14 6.067 15.567 4.5 17.5 4.5C19.433 4.5 21 6.067 21 8C21 9.933 19.433 11.5 17.5 11.5C17.2258 11.4936 17 11.7141 17 11.9884V18C17 18.8284 16.3284 19.5 15.5 19.5C14.6716 19.5 14 18.8284 14 18Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'alarm' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 5.23139L6.15 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21.0001 5.23139L17.8501 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="13" r="8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8.5V13.5L15 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'alarm-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 5.23139L6.15 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21.0001 5.23139L17.8501 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="13" r="8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 13.3225L11.3786 14.898C11.505 15.0425 11.733 15.0319 11.8454 14.8762L14.6449 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'alarm-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 5.23139L6.15 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21.0001 5.23139L17.8501 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="13" r="8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 13H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'alarm-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 5.23139L6.15 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21.0001 5.23139L17.8501 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="13" r="8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 13H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 10.5L12 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'alarm-snooze' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 5.23139L6.15 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21.0001 5.23139L17.8501 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="13" r="8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.75 11H13.25L10.75 15H13.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'alarm-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 5.23139L6.15 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21.0001 5.23139L17.8501 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="13" r="8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 11L14 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 11L10 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'align-bottom' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 14V6C10 5.06812 10 4.60218 9.84776 4.23463C9.64477 3.74458 9.25542 3.35523 8.76537 3.15224C8.39782 3 7.93188 3 7 3C6.06812 3 5.60218 3 5.23463 3.15224C4.74458 3.35523 4.35523 3.74458 4.15224 4.23463C4 4.60218 4 5.06812 4 6V14C4 14.9319 4 15.3978 4.15224 15.7654C4.35523 16.2554 4.74458 16.6448 5.23463 16.8478C5.60218 17 6.06812 17 7 17C7.93188 17 8.39782 17 8.76537 16.8478C9.25542 16.6448 9.64477 16.2554 9.84776 15.7654C10 15.3978 10 14.9319 10 14Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20 14V10C20 9.06812 20 8.60218 19.8478 8.23463C19.6448 7.74458 19.2554 7.35523 18.7654 7.15224C18.3978 7 17.9319 7 17 7C16.0681 7 15.6022 7 15.2346 7.15224C14.7446 7.35523 14.3552 7.74458 14.1522 8.23463C14 8.60218 14 9.06812 14 10V14C14 14.9319 14 15.3978 14.1522 15.7654C14.3552 16.2554 14.7446 16.6448 15.2346 16.8478C15.6022 17 16.0681 17 17 17C17.9319 17 18.3978 17 18.7654 16.8478C19.2554 16.6448 19.6448 16.2554 19.8478 15.7654C20 15.3978 20 14.9319 20 14Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 21H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'align-horizontal' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 21L12 20M12 3V4M12 14H8C7.06812 14 6.60218 14 6.23463 14.1522C5.74458 14.3552 5.35523 14.7446 5.15224 15.2346C5 15.6022 5 16.0681 5 17C5 17.9319 5 18.3978 5.15224 18.7654C5.35523 19.2554 5.74458 19.6448 6.23463 19.8478C6.60218 20 7.06812 20 8 20H12M12 14H16C16.9319 14 17.3978 14 17.7654 14.1522C18.2554 14.3552 18.6448 14.7446 18.8478 15.2346C19 15.6022 19 16.0681 19 17C19 17.9319 19 18.3978 18.8478 18.7654C18.6448 19.2554 18.2554 19.6448 17.7654 19.8478C17.3978 20 16.9319 20 16 20H12M12 14V11.25V10M12 10H14C14.9319 10 15.3978 10 15.7654 9.84776C16.2554 9.64477 16.6448 9.25542 16.8478 8.76537C17 8.39782 17 7.93188 17 7C17 6.06812 17 5.60217 16.8478 5.23463C16.6448 4.74458 16.2554 4.35523 15.7654 4.15224C15.3978 4 14.9319 4 14 4L12 4M12 10H10C9.06812 10 8.60218 10 8.23463 9.84776C7.74458 9.64477 7.35523 9.25542 7.15224 8.76537C7 8.39782 7 7.93188 7 7C7 6.06812 7 5.60218 7.15224 5.23463C7.35523 4.74458 7.74458 4.35523 8.23463 4.15224C8.60218 4 9.06812 4 10 4L12 4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'align-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 14L10 14C9.06812 14 8.60218 14 8.23463 14.1522C7.74458 14.3552 7.35523 14.7446 7.15224 15.2346C7 15.6022 7 16.0681 7 17C7 17.9319 7 18.3978 7.15224 18.7654C7.35523 19.2554 7.74458 19.6448 8.23463 19.8478C8.60218 20 9.06812 20 10 20L18 20C18.9319 20 19.3978 20 19.7654 19.8478C20.2554 19.6448 20.6448 19.2554 20.8478 18.7654C21 18.3978 21 17.9319 21 17C21 16.0681 21 15.6022 20.8478 15.2346C20.6448 14.7446 20.2554 14.3552 19.7654 14.1522C19.3978 14 18.9319 14 18 14Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 4L10 4C9.06812 4 8.60218 4 8.23463 4.15224C7.74458 4.35523 7.35523 4.74458 7.15224 5.23463C7 5.60218 7 6.06812 7 7C7 7.93188 7 8.39782 7.15224 8.76537C7.35523 9.25542 7.74458 9.64477 8.23463 9.84776C8.60218 10 9.06812 10 10 10H14C14.9319 10 15.3978 10 15.7654 9.84776C16.2554 9.64477 16.6448 9.25542 16.8478 8.76537C17 8.39782 17 7.93188 17 7C17 6.06812 17 5.60218 16.8478 5.23463C16.6448 4.74458 16.2554 4.35523 15.7654 4.15224C15.3978 4 14.9319 4 14 4Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 21L3 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'align-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 14L6 14C5.06812 14 4.60218 14 4.23463 14.1522C3.74458 14.3552 3.35523 14.7446 3.15224 15.2346C3 15.6022 3 16.0681 3 17C3 17.9319 3 18.3978 3.15224 18.7654C3.35523 19.2554 3.74458 19.6448 4.23463 19.8478C4.60218 20 5.06812 20 6 20L14 20C14.9319 20 15.3978 20 15.7654 19.8478C16.2554 19.6448 16.6448 19.2554 16.8478 18.7654C17 18.3978 17 17.9319 17 17C17 16.0681 17 15.6022 16.8478 15.2346C16.6448 14.7446 16.2554 14.3552 15.7654 14.1522C15.3978 14 14.9319 14 14 14Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 4L10 4C9.06812 4 8.60218 4 8.23463 4.15224C7.74458 4.35523 7.35523 4.74458 7.15224 5.23463C7 5.60218 7 6.06812 7 7C7 7.93188 7 8.39782 7.15224 8.76537C7.35523 9.25542 7.74458 9.64477 8.23463 9.84776C8.60218 10 9.06812 10 10 10H14C14.9319 10 15.3978 10 15.7654 9.84776C16.2554 9.64477 16.6448 9.25542 16.8478 8.76537C17 8.39782 17 7.93188 17 7C17 6.06812 17 5.60218 16.8478 5.23463C16.6448 4.74458 16.2554 4.35523 15.7654 4.15224C15.3978 4 14.9319 4 14 4Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 21L21 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'align-top' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 18V10C10 9.06812 10 8.60218 9.84776 8.23463C9.64477 7.74458 9.25542 7.35523 8.76537 7.15224C8.39782 7 7.93188 7 7 7C6.06812 7 5.60218 7 5.23463 7.15224C4.74458 7.35523 4.35523 7.74458 4.15224 8.23463C4 8.60218 4 9.06812 4 10V18C4 18.9319 4 19.3978 4.15224 19.7654C4.35523 20.2554 4.74458 20.6448 5.23463 20.8478C5.60218 21 6.06812 21 7 21C7.93188 21 8.39782 21 8.76537 20.8478C9.25542 20.6448 9.64477 20.2554 9.84776 19.7654C10 19.3978 10 18.9319 10 18Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20 14V10C20 9.06812 20 8.60218 19.8478 8.23463C19.6448 7.74458 19.2554 7.35523 18.7654 7.15224C18.3978 7 17.9319 7 17 7C16.0681 7 15.6022 7 15.2346 7.15224C14.7446 7.35523 14.3552 7.74458 14.1522 8.23463C14 8.60218 14 9.06812 14 10V14C14 14.9319 14 15.3978 14.1522 15.7654C14.3552 16.2554 14.7446 16.6448 15.2346 16.8478C15.6022 17 16.0681 17 17 17C17.9319 17 18.3978 17 18.7654 16.8478C19.2554 16.6448 19.6448 16.2554 19.8478 15.7654C20 15.3978 20 14.9319 20 14Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 3H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'align-vertical' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12L4 12M21 12H20M10 12V8C10 7.06812 10 6.60218 9.84776 6.23463C9.64477 5.74458 9.25542 5.35523 8.76537 5.15224C8.39782 5 7.93188 5 7 5C6.06812 5 5.60217 5 5.23463 5.15224C4.74458 5.35523 4.35523 5.74458 4.15224 6.23463C4 6.60218 4 7.06812 4 8L4 12M10 12V16C10 16.9319 10 17.3978 9.84776 17.7654C9.64477 18.2554 9.25542 18.6448 8.76537 18.8478C8.39782 19 7.93188 19 7 19C6.06812 19 5.60218 19 5.23463 18.8478C4.74458 18.6448 4.35523 18.2554 4.15224 17.7654C4 17.3978 4 16.9319 4 16L4 12M10 12L14 12M14 12V14C14 14.9319 14 15.3978 14.1522 15.7654C14.3552 16.2554 14.7446 16.6448 15.2346 16.8478C15.6022 17 16.0681 17 17 17C17.9319 17 18.3978 17 18.7654 16.8478C19.2554 16.6448 19.6448 16.2554 19.8478 15.7654C20 15.3978 20 14.9319 20 14V12M14 12V10C14 9.06812 14 8.60218 14.1522 8.23463C14.3552 7.74458 14.7446 7.35523 15.2346 7.15224C15.6022 7 16.0681 7 17 7C17.9319 7 18.3978 7 18.7654 7.15224C19.2554 7.35523 19.6448 7.74458 19.8478 8.23463C20 8.60218 20 9.06812 20 10V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'alt' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 5.25H8.625L15.375 18.75H21M14.25 5.25H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'anchor' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5 12H3C3 16.9706 7.02945 21 12 21C16.9706 21 21 16.9706 21 12H19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 7V21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 7C13.1046 7 14 6.10457 14 5C14 3.89543 13.1046 3 12 3C10.8954 3 10 3.89543 10 5C10 6.10457 10.8954 7 12 7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'aperture' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.0791 8.3999L19.2451 17.3459" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.9209 8.3999H20.2529" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.8418 12L13.0078 3.05396" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.92088 15.6001L4.75488 6.65405" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.0791 15.6001H3.74707" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.1582 12L10.9922 20.946" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'api' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.49992 13L6.99992 11.5L12.4999 17L10.9999 18.5C10.2499 19.25 7.49992 20.5 5.49992 18.5C3.49992 16.5 4.74992 13.7501 5.49992 13Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 21L5.5 18.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18.5 11L17 12.5L11.5 6.99996L13 5.49996C13.75 4.74991 16.5 3.49991 18.5 5.49996C20.5 7.49996 19.25 10.2499 18.5 11Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5 8L10.5 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 3L18.5 5.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 11.5L14 13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'ar' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.50008 20.8859C6.03745 20.742 5.05293 20.4169 4.3181 19.6821C3.58327 18.9472 3.25813 17.9627 3.11426 16.5001M7.50008 3.11426C6.03745 3.25813 5.05293 3.58327 4.3181 4.3181C3.58327 5.05293 3.25813 6.03745 3.11426 7.50008M16.5001 3.11426C17.9627 3.25813 18.9472 3.58327 19.6821 4.3181C20.4169 5.05293 20.742 6.03745 20.8859 7.50008M16.5001 20.8859C17.9627 20.742 18.9472 20.4169 19.6821 19.6821C20.4169 18.9472 20.742 17.9627 20.8859 16.5001" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 10L12 12M8 10V14L12 16M8 10L12 8L16 10M12 12L16 10M12 12V16M16 10V14L12 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'archive' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.5 11.5H13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20 8V19C20 20.1046 19.1046 21 18 21H6C4.89543 21 4 20.1046 4 19V8M21 8V5C21 3.89543 20.1046 3 19 3H5C3.89543 3 3 3.89543 3 5V8H21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-diagonal-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.92871 12.7071L12.7069 4.92896M12.7069 4.92896L12.7069 9.8787M12.7069 4.92896L7.75714 4.92896" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.0711 11.293L11.293 19.0711M11.293 19.0711L16.2427 19.0711M11.293 19.0711L11.293 14.1214" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-diagonal-two' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.293 4.92896L19.0711 12.7071M19.0711 12.7071L14.1214 12.7071M19.0711 12.7071L19.0711 7.75738" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.7069 19.0711L4.92871 11.293M4.92871 11.293L4.92871 16.2427M4.92871 11.293L9.87846 11.293" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-down' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 4.5L12 19.5M12 19.5L6 13.875M12 19.5L18 13.875" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-down-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 7.5V16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.5 13L12 16.5L8.5 13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-down-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17.5 6.5L6.5 17.5M6.5 17.5H15.5M6.5 17.5V8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-down-left-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.1823 8.81787L8.81836 15.1818" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.7681 15.1819L8.81836 15.1819L8.81836 10.2322" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-down-left-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.1823 8.81787L8.81836 15.1818" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.7681 15.1819L8.81836 15.1819L8.81836 10.2322" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-down-left-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.1823 8.81787L8.81836 15.1818" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.7681 15.1819L8.81836 15.1819L8.81836 10.2322" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-down-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.5 6.5L17.5 17.5M17.5 17.5H8.5M17.5 17.5V8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-down-right-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.81836 8.81787L15.1823 15.1818" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.1822 10.2322L15.1822 15.1819L10.2324 15.1819" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-down-right-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.81836 8.81787L15.1823 15.1818" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.1822 10.2322L15.1822 15.1819L10.2324 15.1819" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-down-right-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.81836 8.81787L15.1823 15.1818" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.1822 10.2322L15.1822 15.1819L10.2324 15.1819" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-down-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 7.5V16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.5 13L12 16.5L8.5 13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-down-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 7.5V16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.5 13L12 16.5L8.5 13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19.5 12H4.5M4.5 12L10.125 6M4.5 12L10.125 18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-left-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.5 12L7.5 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11 15.5L7.5 12L11 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-left-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.5 7.5L17.5 7.5M17.5 7.5L14 11M17.5 7.5L14 4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17.5 16.5L6.5 16.5M6.5 16.5L10 20M6.5 16.5L10 13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-left-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.5 12L7.5 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11 15.5L7.5 12L11 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-left-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.5 12L7.5 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11 15.5L7.5 12L11 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-long-down' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 18L12 22M12 22L16 18M12 22V2" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-long-down-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11 19H5M5 19V13M5 19L19 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-long-down-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19 13V19M19 19H13M19 19L5 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-long-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6 8L2 12M2 12L6 16M2 12H22" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-long-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 8L22 12M22 12L18 16M22 12H2" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-long-up' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 6L12 2M12 2L16 6M12 2V22" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-long-up-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5 11V5M5 5H11M5 5L19 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-long-up-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13 5H19M19 5V11M19 5L5 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.5 12H19.5M19.5 12L13.875 6M19.5 12L13.875 18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-right-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.5 12L16.5 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13 8.5L16.5 12L13 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-right-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.5 12L16.5 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13 8.5L16.5 12L13 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-right-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.5 12L16.5 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13 8.5L16.5 12L13 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-up' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 19.5L12 4.5M12 4.5L6 10.125M12 4.5L18 10.125" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-up-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 16.5L12 7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.5 11L12 7.5L15.5 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-up-down' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.5 17.5V6.5M7.5 6.5L11 10M7.5 6.5L4 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.5 6.5V17.5M16.5 17.5L20 14M16.5 17.5L13 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-up-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17.5 17.5L6.5 6.5M6.5 6.5H15.5M6.5 6.5V15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-up-left-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.1823 15.1821L8.81836 8.81812" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.81836 13.7679L8.81836 8.81812L13.7681 8.81812" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-up-left-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.1823 15.1821L8.81836 8.81812" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.81836 13.7679L8.81836 8.81812L13.7681 8.81812" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-up-left-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.1818 15.1821L8.81787 8.81812" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.81787 13.7679L8.81787 8.81812L13.7676 8.81812" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-up-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.5 17.5L17.5 6.5M17.5 6.5H8.5M17.5 6.5V15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-up-right-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.81787 15.1818L15.1818 8.81787" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.2324 8.81787L15.1822 8.81787L15.1822 13.7676" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-up-right-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.81787 15.1818L15.1818 8.81787" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.2324 8.81787L15.1822 8.81787L15.1822 13.7676" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-up-right-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.81787 15.1818L15.1818 8.81787" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.2324 8.81787L15.1822 8.81787L15.1822 13.7676" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-up-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 16.5L12 7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.5 11L12 7.5L15.5 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'arrow-up-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 16.5L12 7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.5 11L12 7.5L15.5 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'asterisk-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8.5V15.5M9 13.75L15 10.25M9 10.25L15 13.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'asterisk-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8.5V15.5M9 13.75L15 10.25M9 10.25L15 13.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'asterisk-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8.5V15.5M9 13.75L15 10.25M9 10.25L15 13.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'asterisk-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8.5V15.5M9 13.75L15 10.25M9 10.25L15 13.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'asterisk-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8.5V15.5M9 13.75L15 10.25M9 10.25L15 13.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'at' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16 11.9956V7.99755M16 11.9956C16 6.83884 8 6.83909 8 11.9956C8 17.1632 16 17.1055 16 11.9956ZM16 11.9956C16 16.9959 21 16.9959 21 11.9956C21 7.02746 16.9706 3 12 3C7.02944 3 3 7.02746 3 11.9956C3 16.9637 7.02944 20.9912 12 20.9912C13.6745 21.0749 15.9379 20.57 17.7759 19.1598" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'atom' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.4068 8.5932C20.0061 13.1925 22.2092 18.4462 20.3277 20.3277C18.4462 22.2092 13.1925 20.0061 8.5932 15.4068C3.99392 10.8075 1.79075 5.55379 3.67227 3.67227C5.55379 1.79075 10.8075 3.99392 15.4068 8.5932Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.59352 8.5932C3.99424 13.1925 1.79106 18.4462 3.67259 20.3277C5.55411 22.2093 10.8078 20.0061 15.4071 15.4068C20.0064 10.8075 22.2096 5.5538 20.328 3.67227C18.4465 1.79075 13.1928 3.99393 8.59352 8.5932Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.75 12H12.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'bank' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 8.94059V18M17 8.94059V18M7 8.94059V18M12.4472 3.10627L20.2111 7.01386C21.155 7.48888 20.8192 8.92079 19.7639 8.92079H4.23607C3.18084 8.92079 2.84503 7.48889 3.78885 7.01386L11.5528 3.10627C11.8343 2.96458 12.1657 2.96458 12.4472 3.10627ZM19.5 21H4.50001C3.67158 21 3 20.3284 3 19.5C3 18.6716 3.67158 18 4.50001 18H19.5C20.3284 18 21 18.6716 21 19.5C21 20.3284 20.3284 21 19.5 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'baseball' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.80371 9.80396C8.82609 10.744 11.5008 15.3767 9.80371 20.1963" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.196 14.1963C15.1737 13.2562 12.4989 8.62347 14.196 3.80396" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'battery-charging' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.5 7H18C18.5523 7 19 7.4477 19 8V16C19 16.5523 18.5523 17 18 17H14.5M7.5 7H4C3.44771 7 3 7.4477 3 8V16C3 16.5523 3.44771 17 4 17H7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 11V13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.001 7L8.5 12.0006H13.502L11 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'battery-charging-four' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 7H4C3.44771 7 3 7.4477 3 8V16C3 16.5523 3.44771 17 4 17H18C18.5523 17 19 16.5523 19 16V8C19 7.4477 18.5523 7 18 7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 11V13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6.5 10V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5 10V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.5 12V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'battery-charging-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 7H4C3.44771 7 3 7.4477 3 8V16C3 16.5523 3.44771 17 4 17H18C18.5523 17 19 16.5523 19 16V8C19 7.4477 18.5523 7 18 7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 11V13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6.5 10V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'battery-charging-three' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 7H4C3.44771 7 3 7.4477 3 8V16C3 16.5523 3.44771 17 4 17H18C18.5523 17 19 16.5523 19 16V8C19 7.4477 18.5523 7 18 7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 11V13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6.5 10V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5 10V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',

                'battery-charging-two' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 7H4C3.44771 7 3 7.4477 3 8V16C3 16.5523 3.44771 17 4 17H18C18.5523 17 19 16.5523 19 16V8C19 7.4477 18.5523 7 18 7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 11V13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6.5 10V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'battery-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 7H4C3.44771 7 3 7.4477 3 8V16C3 16.5523 3.44771 17 4 17H18C18.5523 17 19 16.5523 19 16V8C19 7.4477 18.5523 7 18 7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 11V13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.25977 12.2418L10.2937 13.4235C10.3886 13.5319 10.5595 13.5239 10.6438 13.4072L12.7434 10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'battery-empty' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 7H4C3.44771 7 3 7.4477 3 8V16C3 16.5523 3.44771 17 4 17H18C18.5523 17 19 16.5523 19 16V8C19 7.4477 18.5523 7 18 7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 11V13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'battery-full' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 7H4C3.44771 7 3 7.4477 3 8V16C3 16.5523 3.44771 17 4 17H18C18.5523 17 19 16.5523 19 16V8C19 7.4477 18.5523 7 18 7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 11V13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6.5 10V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5 10V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.5 10V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'battery-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 7H4C3.44771 7 3 7.4477 3 8V16C3 16.5523 3.44771 17 4 17H18C18.5523 17 19 16.5523 19 16V8C19 7.4477 18.5523 7 18 7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 12H13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 11V13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'battery-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 7H4C3.44771 7 3 7.4477 3 8V16C3 16.5523 3.44771 17 4 17H18C18.5523 17 19 16.5523 19 16V8C19 7.4477 18.5523 7 18 7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 12H13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11 10L11 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 11V13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'battery-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 7H4C3.44771 7 3 7.4477 3 8V16C3 16.5523 3.44771 17 4 17H18C18.5523 17 19 16.5523 19 16V8C19 7.4477 18.5523 7 18 7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10.5L12.5 13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5 10.5L9.5 13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 11V13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bell' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18.831 10.2561C18.831 6.55462 16.3704 3 12.0179 3C7.6654 3 5.20478 6.55462 5.20478 10.2561C5.20478 11.7576 4.21699 12.9104 3.3872 14.1148C-0.34292 20.0861 24.1939 19.8178 20.6486 14.1149C19.8188 12.9104 18.831 11.7576 18.831 10.2561Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.64307 18.3676C9.27183 19.9207 10.0714 21 12.0002 21C13.9289 21 14.7285 19.9207 15.3573 18.3676" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bell-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18.831 10.2561C18.831 6.55462 16.3704 3 12.0179 3C7.6654 3 5.20478 6.55462 5.20478 10.2561C5.20478 11.7576 4.21699 12.9104 3.3872 14.1148C-0.34292 20.0861 24.1939 19.8178 20.6486 14.1149C19.8188 12.9104 18.831 11.7576 18.831 10.2561Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.64307 18.3676C9.27183 19.9207 10.0714 21 12.0002 21C13.9289 21 14.7285 19.9207 15.3573 18.3676" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.6001 10.3225L10.9787 11.898C11.1051 12.0425 11.3331 12.0319 11.4455 11.8762L14.245 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bell-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18.831 10.2561C18.831 6.55462 16.3704 3 12.0179 3C7.6654 3 5.20478 6.55462 5.20478 10.2561C5.20478 11.7576 4.21699 12.9104 3.3872 14.1148C-0.34292 20.0861 24.1939 19.8178 20.6486 14.1149C19.8188 12.9104 18.831 11.7576 18.831 10.2561Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.64258 18.3676C9.27134 19.9207 10.0709 21 11.9997 21C13.9284 21 14.728 19.9207 15.3568 18.3676" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bell-on' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18.831 10.2561C18.831 6.55462 16.3704 3 12.0179 3C7.6654 3 5.20478 6.55462 5.20478 10.2561C5.20478 11.7576 4.21699 12.9104 3.3872 14.1148C-0.34292 20.0861 24.1939 19.8178 20.6486 14.1149C19.8188 12.9104 18.831 11.7576 18.831 10.2561Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 12C13.1046 12 14 11.1046 14 10C14 8.89543 13.1046 8 12 8C10.8954 8 10 8.89543 10 10C10 11.1046 10.8954 12 12 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.64258 18.3676C9.27134 19.9207 10.0709 21 11.9997 21C13.9284 21 14.728 19.9207 15.3568 18.3676" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bell-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18.831 10.2561C18.831 6.55462 16.3704 3 12.0179 3C7.6654 3 5.20478 6.55462 5.20478 10.2561C5.20478 11.7576 4.21699 12.9104 3.3872 14.1148C-0.34292 20.0861 24.1939 19.8178 20.6486 14.1149C19.8188 12.9104 18.831 11.7576 18.831 10.2561Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.64258 18.3676C9.27134 19.9207 10.0709 21 11.9997 21C13.9284 21 14.728 19.9207 15.3568 18.3676" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 7.5L12 12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bell-slash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.64258 18.3677C9.27134 19.9208 10.0709 21.0001 11.9997 21.0001C13.9284 21.0001 14.728 19.9208 15.3568 18.3677" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17.7656 6.2344L21 3M17.7656 6.2344C18.465 7.42278 18.831 8.8285 18.831 10.2561C18.831 11.7576 19.8188 12.9104 20.6486 14.1149C23.1266 18.1009 11.8859 19.432 6.1667 17.8333M17.7656 6.2344L6.1667 17.8333M3 21L6.1667 17.8333M14.6595 3.5C13.8788 3.17956 12.9961 3 12.0179 3C7.6654 3 5.20478 6.55462 5.20478 10.2561C5.20478 11.7576 4.21699 12.9104 3.3872 14.1148C2.9139 14.8725 2.8957 15.5297 3.2175 16.0881" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bell-snooze' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18.831 10.2561C18.831 6.55462 16.3704 3 12.0179 3C7.6654 3 5.20478 6.55462 5.20478 10.2561C5.20478 11.7576 4.21699 12.9104 3.3872 14.1148C-0.34292 20.0861 24.1939 19.8178 20.6486 14.1149C19.8188 12.9104 18.831 11.7576 18.831 10.2561Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.64258 18.3676C9.27134 19.9207 10.0709 21 11.9997 21C13.9284 21 14.728 19.9207 15.3568 18.3676" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.75 8H13.25L10.75 12H13.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bell-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18.831 10.2561C18.831 6.55462 16.3704 3 12.0179 3C7.6654 3 5.20478 6.55462 5.20478 10.2561C5.20478 11.7576 4.21699 12.9104 3.3872 14.1148C-0.34292 20.0861 24.1939 19.8178 20.6486 14.1149C19.8188 12.9104 18.831 11.7576 18.831 10.2561Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.64258 18.3676C9.27134 19.9207 10.0709 21 11.9997 21C13.9284 21 14.728 19.9207 15.3568 18.3676" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 8L14 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 8L10 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bitcoin' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.27273 5.25V3M9.27273 5.25H8.18182M9.27273 5.25H13.6364M13.6364 5.25V3M13.6364 5.25C15.4438 5.25 16.9091 6.76104 16.9091 8.625C16.9091 10.489 15.4438 12 13.6364 12M9.27273 21V18.75M9.27273 18.75H8.18182M9.27273 18.75H13.6364M13.6364 21V18.75M13.6364 18.75H14.7273C16.5348 18.75 18 17.239 18 15.375C18 13.511 16.5347 12 14.7273 12H13.6364M6 5.25H8.18182M8.18182 5.25V12M13.6364 12H8.18182M6 18.75H8.18182M8.18182 18.75L8.18182 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bitcoin-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 8V6M12 18V16M9 12H13C14.1046 12 15 11.1046 15 10C15 8.89543 14.1046 8 13 8H9V12ZM9 12H14C15.1046 12 16 12.8954 16 14C16 15.1046 15.1046 16 14 16H9V12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bitcoin-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8V6M12 18V16M9 12H13C14.1046 12 15 11.1046 15 10C15 8.89543 14.1046 8 13 8H9V12ZM9 12H14C15.1046 12 16 12.8954 16 14C16 15.1046 15.1046 16 14 16H9V12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bitcoin-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8V6M12 18V16M9 12H13C14.1046 12 15 11.1046 15 10C15 8.89543 14.1046 8 13 8H9V12ZM9 12H14C15.1046 12 16 12.8954 16 14C16 15.1046 15.1046 16 14 16H9V12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bitcoin-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8V6M12 18V16M9 12H13C14.1046 12 15 11.1046 15 10C15 8.89543 14.1046 8 13 8H9V12ZM9 12H14C15.1046 12 16 12.8954 16 14C16 15.1046 15.1046 16 14 16H9V12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bitcoin-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8V6M12 18V16M9 12H13C14.1046 12 15 11.1046 15 10C15 8.89543 14.1046 8 13 8H9V12ZM9 12H14C15.1046 12 16 12.8954 16 14C16 15.1046 15.1046 16 14 16H9V12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bluetooth' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.5 7.67757L17.0405 16.2359C17.2818 16.4319 17.4025 16.5298 17.448 16.6468C17.488 16.7495 17.4896 16.8619 17.4524 16.9655C17.41 17.0835 17.292 17.1844 17.056 17.386L13.4864 20.4369C13.0537 20.8068 12.8374 20.9917 12.6532 20.9995C12.4933 21.0063 12.3392 20.9422 12.237 20.8264C12.1193 20.693 12.1193 20.4181 12.1193 19.8683V4.13168C12.1193 3.58188 12.1193 3.30697 12.237 3.17361C12.3392 3.05777 12.4933 2.99369 12.6532 3.00049C12.8374 3.00833 13.0537 3.19325 13.4864 3.56308L17.0893 6.64242C17.315 6.83527 17.4278 6.9317 17.4707 7.04548C17.5084 7.14547 17.5098 7.25437 17.4747 7.3552C17.4348 7.46993 17.3245 7.56891 17.1039 7.76686L6.5 17.283" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'boat' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.79969 17.1935L4.2023 13.8505C4.02831 12.8769 4.5921 11.9223 5.52874 11.6046L5.69969 11.5466M5.69969 11.5466L11.3573 9.62784C11.7739 9.48655 12.2255 9.48655 12.6421 9.62784L18.2997 11.5466M5.69969 11.5466V7.74713C5.69969 6.64257 6.59513 5.74713 7.69969 5.74713H10.1997M18.2997 11.5466L18.4706 11.6046C19.4073 11.9223 19.9711 12.8769 19.7971 13.8505L19.1997 17.1935M18.2997 11.5466V7.74713C18.2997 6.64256 17.4043 5.74713 16.2997 5.74713H13.7997M10.1997 5.74713H13.7997M10.1997 5.74713V4.8C10.1997 3.80589 11.0056 3 11.9997 3C12.9938 3 13.7997 3.80589 13.7997 4.8V5.74713" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 20.3984C3.6465 21.0562 5.22182 21.2414 6.72515 20.6148C7.75718 20.1846 9.06079 20.1737 10.116 20.5434C11.3068 20.9605 12.6932 20.9605 13.884 20.5434C14.9392 20.1737 16.2428 20.1846 17.2749 20.6148C18.7782 21.2414 20.3535 21.0562 21 20.3984" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'book' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.9999 20.25C4.9999 20.6642 5.33568 21 5.7499 21H16.4019C17.565 21 17.9999 20.6348 17.9999 19.4V17.9549M4.9999 20.25C4.9999 19.0074 6.00726 18 7.2499 18H17.4019C17.6281 18 17.8267 17.9862 17.9999 17.9549M4.9999 20.25V6.2002C4.9999 5.06408 4.92789 3.81097 6.09169 3.21799C6.51952 3 7.07999 3 8.20009 3H17.4001C18.6353 3 18.9999 3.43658 18.9999 4.6001V16.4001C18.9999 17.3948 18.7176 17.8251 17.9999 17.9549" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'book-open' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.0004 9.7998V19.9998M12.0004 9.7998C12.0004 8.09569 12.1078 6.21639 10.3622 5.32698C9.72047 5 8.8802 5 7.20004 5H4.60004C3.36437 5 3.00043 5.4366 3.00043 6.6001V15.4001C3.00043 15.9678 2.96466 16.5947 3.54633 16.8911C3.76003 17 4.03944 17 4.5984 17H7.43116C9.80824 17 10.6911 18.0363 12.0004 19.9998M12.0004 9.7998C12.0004 8.09608 11.8928 6.21629 13.6381 5.32698C14.2799 5 15.1201 5 16.8002 5H19.4002C20.6356 5 21.0004 5.43643 21.0004 6.6001V15.4001C21.0004 15.967 21.0358 16.5951 20.4547 16.8911C20.241 17 19.9614 17 19.4025 17H16.5698C14.1922 17 13.3098 18.0356 12.0004 19.9998" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bookmark' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.52722 20.8411C6.86106 21.2736 6 20.7723 6 19.9521V3.94163C6 3.42158 6.33579 3 6.75 3H17.25C17.6642 3 18 3.42158 18 3.94163V19.9521C18 20.7723 17.1389 21.2736 16.4728 20.8411L12.5272 18.2799C12.2043 18.0702 11.7957 18.0702 11.4728 18.2799L7.52722 20.8411Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bookmark-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.52722 20.8411C6.86106 21.2736 6 20.7723 6 19.9521V3.94163C6 3.42158 6.33579 3 6.75 3H17.25C17.6642 3 18 3.42158 18 3.94163V19.9521C18 20.7723 17.1389 21.2736 16.4728 20.8411L12.5272 18.2799C12.2043 18.0702 11.7957 18.0702 11.4728 18.2799L7.52722 20.8411Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.7002 9.82245L11.0788 11.398C11.2052 11.5425 11.4332 11.5319 11.5456 11.3762L14.3451 7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bookmark-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.52722 20.8411C6.86106 21.2736 6 20.7723 6 19.9521V3.94163C6 3.42158 6.33579 3 6.75 3H17.25C17.6642 3 18 3.42158 18 3.94163V19.9521C18 20.7723 17.1389 21.2736 16.4728 20.8411L12.5272 18.2799C12.2043 18.0702 11.7957 18.0702 11.4728 18.2799L7.52722 20.8411Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 9.5H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bookmark-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.52722 20.8411C6.86106 21.2736 6 20.7723 6 19.9521V3.94163C6 3.42158 6.33579 3 6.75 3H17.25C17.6642 3 18 3.42158 18 3.94163V19.9521C18 20.7723 17.1389 21.2736 16.4728 20.8411L12.5272 18.2799C12.2043 18.0702 11.7957 18.0702 11.4728 18.2799L7.52722 20.8411Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 9.5H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 7L12 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bookmark-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.52722 20.8411C6.86106 21.2736 6 20.7723 6 19.9521V3.94163C6 3.42158 6.33579 3 6.75 3H17.25C17.6642 3 18 3.42158 18 3.94163V19.9521C18 20.7723 17.1389 21.2736 16.4728 20.8411L12.5272 18.2799C12.2043 18.0702 11.7957 18.0702 11.4728 18.2799L7.52722 20.8411Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 7.5L14 11.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 7.5L10 11.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bounding-box' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5 17V7M5 17C3.89543 17 3 17.8954 3 19C3 20.1046 3.89543 21 5 21C6.10457 21 7 20.1046 7 19M5 17C6.10457 17 7 17.8954 7 19M5 7C6.10457 7 7 6.10457 7 5M5 7C3.89543 7 3 6.10457 3 5C3 3.89543 3.89543 3 5 3C6.10457 3 7 3.89543 7 5M7 5H17M17 5C17 6.10457 17.8954 7 19 7M17 5C17 3.89543 17.8954 3 19 3C20.1046 3 21 3.89543 21 5C21 6.10457 20.1046 7 19 7M19 7V17M19 17C17.8954 17 17 17.8954 17 19M19 17C20.1046 17 21 17.8954 21 19C21 20.1046 20.1046 21 19 21C17.8954 21 17 20.1046 17 19M7 19H17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'bowl' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.0165 21C15.5718 21 16.022 20.5522 16.0221 20C16.0222 19.8437 16.0222 19.6886 16.0223 19.5509C16.0224 19.2433 16.1864 18.9871 16.4554 18.8355C16.653 18.7241 16.8459 18.6056 17.0338 18.4803C17.5251 18.1527 17.9823 17.7785 18.399 17.364C19.8143 15.9564 20.763 14.0847 20.9945 11.9981C21.0554 11.4492 20.5994 11 20.044 11H3.95595C3.40063 11 2.94457 11.4492 3.00547 11.9981C3.23696 14.0847 4.18566 15.9564 5.60101 17.364C6.02156 17.7823 6.48334 18.1595 6.97976 18.4893C7.12805 18.5878 7.27944 18.6821 7.43376 18.772C7.7645 18.9646 7.98374 19.3092 7.98244 19.6904L7.9814 19.9966C7.97951 20.5502 8.43024 21 8.9869 21H15.0165Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 5V7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18 5V7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 3V7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'box' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 21L20.1314 16.7916C20.4469 16.6283 20.6047 16.5467 20.7198 16.4264C20.8217 16.32 20.899 16.1924 20.9464 16.0526C21 15.8945 21 15.7167 21 15.3611C21 13.6519 21 10.0684 21 7.53273M12 21L3.86859 16.7916C3.55308 16.6283 3.39532 16.5467 3.28016 16.4264C3.17831 16.32 3.10095 16.1924 3.05357 16.0526C3 15.8945 3 15.7159 3 15.3587V7.53273M12 21C12 21 12 15.4766 12 11.9374M21 7.53273C17.4853 9.25286 15.5147 10.2173 12 11.9374M21 7.53273C18.2435 6.10609 15.487 4.67946 12.7304 3.25282C12.4632 3.11451 12.3296 3.04536 12.1888 3.0181C12.0641 2.99397 11.9359 2.99397 11.8112 3.0181C11.6704 3.04536 11.5365 3.11468 11.2686 3.25332L3 7.53273M3 7.53273C6 9.00095 9 10.4692 12 11.9374" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-chrome' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 21C16.9706 21 21 16.9706 21 12C21 7.02944 16.9706 3 12 3C7.02944 3 3 7.02944 3 12C3 16.9706 7.02944 21 12 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.0004 15.5999C13.9886 15.5999 15.6004 13.9881 15.6004 11.9999C15.6004 10.0117 13.9886 8.3999 12.0004 8.3999C10.0122 8.3999 8.40039 10.0117 8.40039 11.9999C8.40039 13.9881 10.0122 15.5999 12.0004 15.5999Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.253 8.3999H12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4.75488 6.65405L8.88588 13.8001" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.9922 20.946L15.1142 13.8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-dribbble' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21.0004 11.9999C19.6871 11.9999 16.0644 11.5046 12.8223 12.9283C9.30035 14.475 6.74992 16.8741 5.63867 18.3662" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.625 3.6543C10.0337 4.95431 13.1072 8.26446 14.25 11.5502C15.3929 14.8358 15.8165 18.8758 16.0773 20.0258" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.06934 10.8748C4.76934 10.9773 9.26974 11.0698 12.1498 9.83976C15.0298 8.60977 17.5081 6.34761 18.3581 5.63013" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 21C16.9706 21 21 16.9706 21 12C21 7.02944 16.9706 3 12 3C7.02944 3 3 7.02944 3 12C3 16.9706 7.02944 21 12 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-facebook' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.5 10V14H9.5V21H13.5V14H16.5L17.5 10H13.5V8C13.5 7.45533 13.9553 7 14.5 7H17.5V3H14.5C11.7767 3 9.5 5.27667 9.5 8V10H6.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-figma' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6 6C6 5.20435 6.31607 4.44129 6.87868 3.87868C7.44129 3.31607 8.20435 3 9 3H12V9H9C8.20435 9 7.44129 8.68393 6.87868 8.12132C6.31607 7.55871 6 6.79565 6 6Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 3H15C15.394 3 15.7841 3.0776 16.148 3.22836C16.512 3.37913 16.8427 3.6001 17.1213 3.87868C17.3999 4.15726 17.6209 4.48797 17.7716 4.85195C17.9224 5.21593 18 5.60603 18 6C18 6.39397 17.9224 6.78407 17.7716 7.14805C17.6209 7.51203 17.3999 7.84274 17.1213 8.12132C16.8427 8.3999 16.512 8.62087 16.148 8.77164C15.7841 8.9224 15.394 9 15 9H12V3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 12C12 11.606 12.0776 11.2159 12.2284 10.8519C12.3791 10.488 12.6001 10.1573 12.8787 9.87868C13.1573 9.6001 13.488 9.37913 13.8519 9.22836C14.2159 9.0776 14.606 9 15 9C15.394 9 15.7841 9.0776 16.148 9.22836C16.512 9.37913 16.8427 9.6001 17.1213 9.87868C17.3999 10.1573 17.6209 10.488 17.7716 10.8519C17.9224 11.2159 18 11.606 18 12C18 12.394 17.9224 12.7841 17.7716 13.148C17.6209 13.512 17.3999 13.8427 17.1213 14.1213C16.8427 14.3999 16.512 14.6209 16.148 14.7716C15.7841 14.9224 15.394 15 15 15C14.606 15 14.2159 14.9224 13.8519 14.7716C13.488 14.6209 13.1573 14.3999 12.8787 14.1213C12.6001 13.8427 12.3791 13.512 12.2284 13.148C12.0776 12.7841 12 12.394 12 12V12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 18C6 17.2044 6.31607 16.4413 6.87868 15.8787C7.44129 15.3161 8.20435 15 9 15H12V18C12 18.7956 11.6839 19.5587 11.1213 20.1213C10.5587 20.6839 9.79565 21 9 21C8.20435 21 7.44129 20.6839 6.87868 20.1213C6.31607 19.5587 6 18.7956 6 18Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 12C6 11.2044 6.31607 10.4413 6.87868 9.87868C7.44129 9.31607 8.20435 9 9 9H12V15H9C8.20435 15 7.44129 14.6839 6.87868 14.1213C6.31607 13.5587 6 12.7956 6 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-framer' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.5 3L18.5 15.6H5.5V9.3H18.5V3H5.5Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 15.6001V21.0001L5.5 15.6001H12Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-github' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.1722 15.2987C16.3741 15.0494 17.4646 14.6172 18.3123 13.9827C19.7601 12.899 20.5 11.2254 20.5 9.57192C20.5 8.41196 20.0593 7.329 19.2964 6.41176C18.8713 5.90064 20.1148 2.5396 19.01 3.05321C17.9053 3.56682 16.2854 4.25113 15.4363 4.00023C14.5273 3.73161 13.5366 3.58403 12.5 3.58403C11.5996 3.58403 10.734 3.69536 9.9263 3.90064C8.7523 4.19903 7.62955 3.53758 6.5 3.05321C5.37043 2.56884 5.9868 6.06067 5.6513 6.47548C4.92059 7.37895 4.5 8.43866 4.5 9.57192C4.5 11.2254 5.39543 12.899 6.84315 13.9827C7.80755 14.7044 9.017 15.1645 10.3701 15.3912" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.3699 15.3914C9.79063 16.0277 9.50098 16.6318 9.50098 17.204C9.50098 17.7761 9.50098 18.6726 9.50098 21.0001" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.1719 15.2986C15.7208 16.0175 15.9952 16.6631 15.9952 17.2352C15.9952 17.8073 15.9952 18.6935 15.9952 20.9999" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.5 15.6675C3.94943 15.7223 4.28277 15.9286 4.5 16.2862C4.82585 16.8225 6.0371 18.8124 7.41255 18.8124C8.32955 18.8124 9.02575 18.8124 9.5012 18.8124" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-gitlab' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.9813 21L21 13.7076L18.4979 3L15.4831 9.49675H8.9966L5.50755 3L3 13.7076L11.9813 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-google' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.839 10.38H12.183V13.71H17.2477C17.1556 14.52 16.6031 15.78 15.406 16.59C14.6693 17.13 13.5643 17.49 12.183 17.49C9.10409 17.49 6.65793 14.918 6.65793 11.91C6.65793 8.98727 9.243 6.42 12.183 6.42C13.9326 6.42 15.0376 7.14 15.7743 7.77L18.3527 5.25C16.7873 3.9 14.6693 3 12.183 3C8.59171 3 5.46083 4.98 3.98747 7.95C2.67084 10.5236 2.67084 13.4764 3.98747 16.05C5.46083 19.02 8.59171 21 12.183 21C14.6693 21 16.7873 20.19 18.2606 18.84C20.6615 16.7405 21.3561 13.4127 20.839 10.38Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-instagram' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.5 3H7.5C5.01472 3 3 5.01472 3 7.5V16.5C3 18.9853 5.01472 21 7.5 21H16.5C18.9853 21 21 18.9853 21 16.5V7.5C21 5.01472 18.9853 3 16.5 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.4621 11.4866C15.5701 12.2148 15.4457 12.9585 15.1067 13.612C14.7676 14.2654 14.2311 14.7953 13.5736 15.1263C12.916 15.4573 12.1708 15.5725 11.444 15.4555C10.7171 15.3386 10.0457 14.9954 9.52513 14.4749C9.00457 13.9543 8.66141 13.2829 8.54446 12.556C8.4275 11.8292 8.5427 11.084 8.87368 10.4264C9.20466 9.76886 9.73456 9.23238 10.388 8.89332C11.0415 8.55426 11.7852 8.42988 12.5134 8.53786C13.2562 8.64801 13.9439 8.99414 14.4749 9.52513C15.0059 10.0561 15.352 10.7438 15.4621 11.4866Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17 6.5H17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-linkedin' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.5 3H7.5C5.01472 3 3 5.01472 3 7.5V16.5C3 18.9853 5.01472 21 7.5 21H16.5C18.9853 21 21 18.9853 21 16.5V7.5C21 5.01472 18.9853 3 16.5 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 16.375V10.75M12 16.375V13.5M12 13.5V10.75M12 13.5C12 12.2124 13.222 11.5 14.4 11.5C16 11.5 16 12.875 16 14.375V16.375" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 7.625L8 8.125" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-pinterest' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.45184 13.1792C6.34389 10.9181 7.85171 6.51186 12.9237 7.23221C18.5102 8.02564 17.5048 16.7095 12.8469 16.3703C11.373 16.263 10.8157 15.0416 10.6702 13.7937M10.6702 13.7937C10.5599 12.8477 10.6863 11.8865 10.8294 11.3841C11.0736 10.5269 11.4784 10.6435 11.1826 11.7773C11.0386 12.3291 10.863 13.0218 10.6702 13.7937ZM10.6702 13.7937C10.1558 15.8536 9.51973 18.4784 9.0394 20.5017" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-pocket' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.8 3H19.2C19.6774 3 20.1352 3.19901 20.4728 3.55324C20.8104 3.90748 21 4.38792 21 4.88889V11.5556C21 14.0604 20.0518 16.4626 18.364 18.2338C16.6761 20.005 14.3869 21 12 21C10.8181 21 9.64778 20.7557 8.55585 20.2811C7.46392 19.8065 6.47177 19.1108 5.63604 18.2338C3.94821 16.4626 3 14.0604 3 11.5556V4.88889C3 4.38792 3.18964 3.90748 3.52721 3.55324C3.86477 3.19901 4.32261 3 4.8 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 10.25L12 13.25L15 10.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-slack' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.25 3.27002C13.35 3.27002 12.54 3.99002 12.54 4.98002V9.12002C12.54 10.02 13.26 10.83 14.25 10.83C15.15 10.83 15.96 10.11 15.96 9.12002V4.89002C15.96 3.99002 15.24 3.27002 14.25 3.27002Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17.9399 10.7401H19.3799C20.1899 10.7401 20.8199 10.1101 20.8199 9.30011C20.8199 8.49011 20.1899 7.86011 19.3799 7.86011C18.5699 7.86011 17.9399 8.49011 17.9399 9.30011V10.7401Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 9.48002C3 10.38 3.72 11.19 4.71 11.19H8.85C9.75 11.19 10.56 10.47 10.56 9.48002C10.56 8.58002 9.84 7.77002 8.85 7.77002H4.71C3.72 7.86002 3 8.58002 3 9.48002Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.5602 4.44C10.5602 3.63 9.93018 3 9.12018 3C8.31018 3 7.68018 3.63 7.68018 4.44C7.68018 5.25 8.31018 5.88 9.12018 5.88H10.5602V4.44Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.6602 20.82C10.5602 20.82 11.3702 20.1 11.3702 19.11V14.97C11.3702 14.07 10.6502 13.26 9.6602 13.26C8.7602 13.26 7.9502 13.98 7.9502 14.97V19.11C8.0402 20.01 8.7602 20.82 9.6602 20.82Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6.06018 13.26H4.62018C3.81018 13.26 3.18018 13.89 3.18018 14.7C3.18018 15.51 3.81018 16.14 4.62018 16.14C5.43018 16.14 6.06018 15.51 6.06018 14.7V13.26Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.9999 14.5201C20.9999 13.6201 20.2799 12.8101 19.2899 12.8101H15.1499C14.2499 12.8101 13.4399 13.5301 13.4399 14.5201C13.4399 15.4201 14.1599 16.2301 15.1499 16.2301H19.2899C20.1899 16.2301 20.9999 15.4201 20.9999 14.5201Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.4399 18.1201V19.5601C13.4399 20.3701 14.0699 21.0001 14.8799 21.0001C15.6899 21.0001 16.3199 20.3701 16.3199 19.5601C16.3199 18.7501 15.6899 18.1201 14.8799 18.1201H13.4399Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-spotify' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6.5 9.28399C10.133 7.88399 14.2706 8.38399 17.5 10.584" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.81152 12.3839C10.5363 11.3839 13.5638 11.6839 15.8849 13.3839" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.72021 15.384C10.7386 14.584 12.9587 14.884 14.7753 16.084" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-threads' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.76955 8.51523C12.001 6.70293 15.2136 7.66883 15.5931 10.65C15.9957 13.8126 15.1921 16.32 12.0736 16.32C9.1778 16.32 9.2669 13.8 9.2669 13.8C9.2669 11.1 13.8556 10.74 16.5287 12.09C21.4292 15.24 17.8652 21 12.5191 21C8.09027 21 4.5 18.75 4.5 12C4.5 5.25 8.09027 3 12.5191 3C15.6447 3 18.4635 4.62625 19.5 7.87876" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-trello' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 7H7V16H10V7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17 7H14V12H17V7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.5 3H7.5C5.01472 3 3 5.01472 3 7.5V16.5C3 18.9853 5.01472 21 7.5 21H16.5C18.9853 21 21 18.9853 21 16.5V7.5C21 5.01472 18.9853 3 16.5 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-twitch' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.5556 11.1V7.5M20 3H4V17.4H8.44444V21L12 17.4H16.4444L20 13.8V3ZM11.1111 11.1V7.5V11.1Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-twitter' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 4.85004C20.1 5.29326 19.218 5.47326 18.3 5.74552C17.2911 4.6013 15.7953 4.53798 14.358 5.07889C12.4268 5.80566 12 7.52863 12 9.36363C9.0795 9.43871 6.4785 8.10181 4.8 5.74552C4.8 5.74552 1.0362 12.4689 8.4 15.6953C6.7152 16.8233 5.0349 17.584 3 17.5044C5.9772 19.1352 9.2217 19.696 12.0306 18.8765C16.66 17.5249 19.3896 13.1539 19.3638 8.479C19.3638 8.25378 20.7228 5.97256 21 4.85004Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19 4L13.0697 10.9303M5 20L10.9303 13.0697M10.9303 13.0697L16.725 19.6568C16.9155 19.8734 17.2084 20 17.5186 20H18.9928C19.8294 20 20.3 19.1493 19.7864 18.5654L13.0697 10.9303M10.9303 13.0697L4.21364 5.43461C3.70001 4.85074 4.17062 4 5.00724 4H6.4814C6.79165 4 7.08452 4.12664 7.275 4.34316L13.0697 10.9303" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brand-youtube' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.5 9.90776V14.0923C10.5 14.3174 10.6847 14.5 10.9125 14.5C10.9934 14.5 11.0725 14.4765 11.1399 14.4324L14.3149 12.3582C14.505 12.234 14.5572 11.9811 14.4316 11.7932C14.4016 11.7483 14.3628 11.7097 14.3176 11.6797L11.1426 9.5694C10.9536 9.44378 10.6973 9.49339 10.5702 9.68029C10.5244 9.74755 10.5 9.82675 10.5 9.90776Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2 12C2 8.70017 2 7.05025 3.46447 6.02513C4.92893 5 7.28595 5 12 5C16.714 5 19.0711 5 20.5355 6.02513C22 7.05025 22 8.70017 22 12C22 15.2998 22 16.9497 20.5355 17.9749C19.0711 19 16.714 19 12 19C7.28595 19 4.92893 19 3.46447 17.9749C2 16.9497 2 15.2998 2 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'briefcase' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.308 20.9999H15.692C19.4025 20.9999 20.067 19.5509 20.2609 17.7869L20.9531 10.5869C21.2023 8.39085 20.5562 6.59985 16.615 6.59985H7.385C3.44378 6.59985 2.79768 8.39085 3.04689 10.5869L3.73914 17.7869C3.93297 19.5509 4.59753 20.9999 8.308 20.9999Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.30811 6.6V5.88C8.30811 4.287 8.30811 3 11.2617 3H12.7385C15.6921 3 15.6921 4.287 15.6921 5.88V6.6" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.81164 13.3312C7.51024 13.0799 5.25161 12.2948 3.2334 11" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.2334 13.3312C16.5348 13.0799 18.7934 12.2948 20.8116 11" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="13.5" r="2" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brightness-high' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12H6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5 5L7.12132 7.12132" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.0002 5L16.8789 7.12132" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5 19L7.12132 16.8787" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.0002 19L16.8789 16.8787" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 3V6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 21V18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18 12H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'brightness-low' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5 5L5.70711 5.70711" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.0001 5L18.293 5.70711" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5 19.0001L5.70711 18.293" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.0001 19.0001L18.293 18.293" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 3L12 4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 21V20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20 12H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'calendar' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 6.63604 4.31802 5.31802C5.63604 4 7.75736 4 12 4C16.2426 4 18.364 4 19.682 5.31802C21 6.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.5 5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.5 5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.25 8H20.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'calendar-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 6.63604 4.31802 5.31802C5.63604 4 7.75736 4 12 4C16.2426 4 18.364 4 19.682 5.31802C21 6.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.5 5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.5 5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.25 8H20.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.2583 14.2418L11.2923 15.4235C11.3871 15.5319 11.5581 15.5239 11.6424 15.4072L13.742 12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'calendar-down' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 6.63604 4.31802 5.31802C5.63604 4 7.75736 4 12 4C16.2426 4 18.364 4 19.682 5.31802C21 6.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.5 5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.5 5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.25 8H20.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.0033 11.5001L12 16.7798" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 14.8466L12 17.5L9.5 14.8466" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'calendar-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 6.63604 4.31802 5.31802C5.63604 4 7.75736 4 12 4C16.2426 4 18.364 4 19.682 5.31802C21 6.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.5 5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.5 5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.25 8H20.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 14H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'calendar-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 6.63604 4.31802 5.31802C5.63604 4 7.75736 4 12 4C16.2426 4 18.364 4 19.682 5.31802C21 6.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.5 5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.5 5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.25 8H20.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 14H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 12L12 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'calendar-slash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.31802 19.682C5.63604 21 7.75736 21 12 21C16.2426 21 18.364 21 19.682 19.682C21 18.364 21 16.2426 21 12C21 7.75736 21 6.63604 19.682 5.31802C19.512 5.14801 19.3286 4.99994 19.129 4.87096M4.31802 19.682L3 21M4.31802 19.682L16 8M7.5 4.11418C6.03737 4.25805 5.05285 4.58319 4.31802 5.31802C3 6.63604 3 7.75736 3 12C3 13.3743 3 14.5261 3.0448 15.5M7.5 4.11418V5M7.5 4.11418V3M7.5 4.11418C9.72915 3.89491 12.0071 3.97747 14.2459 4.00972M19.129 4.87096L21 3M19.129 4.87096L16 8M16 8H20.75M3.25 8H10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'calendar-up' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 6.63604 4.31802 5.31802C5.63604 4 7.75736 4 12 4C16.2426 4 18.364 4 19.682 5.31802C21 6.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.5 5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.5 5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.25 8H20.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.0033 17.4999L12 12.2202" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 14.1534L12 11.5L9.5 14.1534" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'calendar-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 6.63604 4.31802 5.31802C5.63604 4 7.75736 4 12 4C16.2426 4 18.364 4 19.682 5.31802C21 6.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.5 5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.5 5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.25 8H20.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.5 12.5L13.5 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.5 12.5L10.5 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'camera' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5207 20.4142C20.8276 20.0391 21 19.5304 21 18.9999V6.99994C21 6.46951 20.8276 5.9608 20.5207 5.58573C20.2138 5.21065 19.7976 4.99994 19.3636 4.99994H10.383C8.65903 4.99994 8.32516 3.26869 6.82693 3.02573C6.56257 2.98286 6.28937 2.99994 6.02233 2.99994C5.06948 2.99994 4.59305 2.99994 4.21846 3.15896C3.74138 3.3615 3.36155 3.74132 3.15902 4.2184C3 4.59299 3 5.06942 3 6.02227V18.9999C3 19.5304 3.1724 20.0391 3.47928 20.4142C3.78616 20.7892 4.20237 20.9999 4.63636 20.9999H19.3636C19.7976 20.9999 20.2138 20.7892 20.5207 20.4142Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 3H19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.5 17C15.7091 17 17.5 15.2091 17.5 13C17.5 10.7909 15.7091 9 13.5 9C11.2909 9 9.5 10.7909 9.5 13C9.5 15.2091 11.2909 17 13.5 17Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'camera-slash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16 2.99994H17.5M3 20.9999L3.5283 20.4716M21 2.99994L19 4.99994M3.5283 20.4716C3.82973 20.8107 4.22507 20.9999 4.63636 20.9999H19.3636C19.7976 20.9999 20.2138 20.7892 20.5207 20.4142C20.8276 20.0391 21 19.5304 21 18.9999V6.99994C21 6.46951 20.8276 5.9608 20.5207 5.58573C20.2138 5.21065 19.7976 4.99994 19.3636 4.99994H19M3.5283 20.4716L9.71192 14.288M9.71192 14.288C10.2481 15.8652 11.7415 16.9999 13.5 16.9999C15.7091 16.9999 17.5 15.2091 17.5 12.9999C17.5 11.2415 16.3653 9.748 14.7881 9.21186M9.71192 14.288L14.7881 9.21186M14.7881 9.21186L19 4.99994M14.6915 4.99994H10.383C8.65903 4.99994 8.32516 3.26869 6.82693 3.02573C6.56257 2.98286 6.28937 2.99994 6.02233 2.99994C5.06948 2.99994 4.59305 2.99994 4.21846 3.15896C3.74138 3.3615 3.36155 3.74132 3.15902 4.2184C3 4.59299 3 5.06942 3 6.02227V12.5111V15.7555" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'campfire' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.42188 20.7055L18.5776 15.9172" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18.5781 20.7055L5.42236 15.9172" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.3854 11.5681C15.6692 13.2899 13.9754 14.5 12 14.5C9.37665 14.5 7.25 12.3659 7.25 9.73333C7.25 7.10078 8.24778 6.02435 9.80769 3.5C12.7308 4.78329 12.7308 8.63333 12.7308 8.63333C12.7308 8.63333 13.6908 6.77678 15.6538 5.88333C16.2833 7.74225 17.1319 9.7732 16.3854 11.5681Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cart' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.5 21C17.3284 21 18 20.3284 18 19.5C18 18.6716 17.3284 18 16.5 18C15.6716 18 15 18.6716 15 19.5C15 20.3284 15.6716 21 16.5 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.5 21C9.32843 21 10 20.3284 10 19.5C10 18.6716 9.32843 18 8.5 18C7.67157 18 7 18.6716 7 19.5C7 20.3284 7.67157 21 8.5 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.70907 5.4H18.9241C20.3017 5.4 21.2968 6.67056 20.9194 7.94783L19.2649 13.5478C19.011 14.4072 18.1965 15 17.2696 15H8.11164C7.18469 15 6.37021 14.4072 6.11631 13.5478L3.70907 5.4ZM3.70907 5.4L3 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cart-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11 10.2418L12.034 11.4235C12.1288 11.5319 12.2998 11.5239 12.3841 11.4072L14.4837 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.5 21C17.3284 21 18 20.3284 18 19.5C18 18.6716 17.3284 18 16.5 18C15.6716 18 15 18.6716 15 19.5C15 20.3284 15.6716 21 16.5 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.5 21C9.32843 21 10 20.3284 10 19.5C10 18.6716 9.32843 18 8.5 18C7.67157 18 7 18.6716 7 19.5C7 20.3284 7.67157 21 8.5 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.70907 5.4H18.9241C20.3017 5.4 21.2968 6.67056 20.9194 7.94783L19.2649 13.5478C19.011 14.4072 18.1965 15 17.2696 15H8.11164C7.18469 15 6.37021 14.4072 6.11631 13.5478L3.70907 5.4ZM3.70907 5.4L3 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cart-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.5 21C17.3284 21 18 20.3284 18 19.5C18 18.6716 17.3284 18 16.5 18C15.6716 18 15 18.6716 15 19.5C15 20.3284 15.6716 21 16.5 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.5 21C9.32843 21 10 20.3284 10 19.5C10 18.6716 9.32843 18 8.5 18C7.67157 18 7 18.6716 7 19.5C7 20.3284 7.67157 21 8.5 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.70907 5.4H18.9241C20.3017 5.4 21.2968 6.67056 20.9194 7.94783L19.2649 13.5478C19.011 14.4072 18.1965 15 17.2696 15H8.11164C7.18469 15 6.37021 14.4072 6.11631 13.5478L3.70907 5.4ZM3.70907 5.4L3 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.5 10H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cart-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.5 10H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5 8L12.5 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.5 21C17.3284 21 18 20.3284 18 19.5C18 18.6716 17.3284 18 16.5 18C15.6716 18 15 18.6716 15 19.5C15 20.3284 15.6716 21 16.5 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.5 21C9.32843 21 10 20.3284 10 19.5C10 18.6716 9.32843 18 8.5 18C7.67157 18 7 18.6716 7 19.5C7 20.3284 7.67157 21 8.5 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.70907 5.4H18.9241C20.3017 5.4 21.2968 6.67056 20.9194 7.94783L19.2649 13.5478C19.011 14.4072 18.1965 15 17.2696 15H8.11164C7.18469 15 6.37021 14.4072 6.11631 13.5478L3.70907 5.4ZM3.70907 5.4L3 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cart-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11 8.5L14 11.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 8.5L11 11.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.5 21C17.3284 21 18 20.3284 18 19.5C18 18.6716 17.3284 18 16.5 18C15.6716 18 15 18.6716 15 19.5C15 20.3284 15.6716 21 16.5 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.5 21C9.32843 21 10 20.3284 10 19.5C10 18.6716 9.32843 18 8.5 18C7.67157 18 7 18.6716 7 19.5C7 20.3284 7.67157 21 8.5 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.70907 5.4H18.9241C20.3017 5.4 21.2968 6.67056 20.9194 7.94783L19.2649 13.5478C19.011 14.4072 18.1965 15 17.2696 15H8.11164C7.18469 15 6.37021 14.4072 6.11631 13.5478L3.70907 5.4ZM3.70907 5.4L3 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cast-screen' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 8.0283C3 7.07192 3 6.59373 3.10805 6.2021C3.3889 5.1842 4.1842 4.3889 5.2021 4.10805C5.59373 4 6.07192 4 7.0283 4H16.2C17.8802 4 18.7202 4 19.362 4.32698C19.9265 4.6146 20.3854 5.07354 20.673 5.63803C21 6.27976 21 7.11984 21 8.8V15.2C21 16.8802 21 17.7202 20.673 18.362C20.3854 18.9265 19.9265 19.3854 19.362 19.673C18.7202 20 17.8802 20 16.2 20H14.147" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11 20C11 15.5817 7.4183 12 3 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 20.0035L3.35355 19.6499" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7 20C7 17.7908 5.20914 16 3 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'center-focus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.50008 20.8859C6.03745 20.742 5.05293 20.4169 4.3181 19.6821C3.58327 18.9472 3.25813 17.9627 3.11426 16.5001M7.50008 3.11426C6.03745 3.25813 5.05293 3.58327 4.3181 4.3181C3.58327 5.05293 3.25813 6.03745 3.11426 7.50008M16.5001 3.11426C17.9627 3.25813 18.9472 3.58327 19.6821 4.3181C20.4169 5.05293 20.742 6.03745 20.8859 7.50008M16.5001 20.8859C17.9627 20.742 18.9472 20.4169 19.6821 19.6821C20.4169 18.9472 20.742 17.9627 20.8859 16.5001" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 12C15 10.3431 13.6569 9 12 9C10.3431 9 9 10.3431 9 12C9 13.6569 10.3431 15 12 15C13.6569 15 15 13.6569 15 12Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="1" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chart-bar' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17 21V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 21V9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7 21V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chart-bar-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 8V21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 3V21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 12L6 21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chart-bar-two' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 9.42857V5C15 3.89543 14.1046 3 13 3H11C9.89543 3 9 3.89543 9 5V13.2857M15 9.42857V21M15 9.42857H19C20.1046 9.42857 21 10.324 21 11.4286V19C21 20.1046 20.1046 21 19 21H15M15 21H9M9 21V13.2857M9 21H5C3.89543 21 3 20.1046 3 19V15.2857C3 14.1811 3.89543 13.2857 5 13.2857H9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chart-bubble' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 8.86328C21 10.244 19.8807 11.3633 18.5 11.3633C17.1193 11.3633 16 10.244 16 8.86328C16 7.48257 17.1193 6.36328 18.5 6.36328C19.8807 6.36328 21 7.48257 21 8.86328Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13 8C13 10.7614 10.7614 13 8 13C5.23858 13 3 10.7614 3 8C3 5.23858 5.23858 3 8 3C10.7614 3 13 5.23858 13 8Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18.9688 17.5C18.9688 19.433 17.4017 21 15.4688 21C13.5358 21 11.9688 19.433 11.9688 17.5C11.9688 15.567 13.5358 14 15.4688 14C17.4017 14 18.9688 15.567 18.9688 17.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chart-graph' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 3V21H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.7996 7.80005L13.7996 13.7999L10.7996 10.7998L6.59961 14.9998" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chart-line' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 16.5L9 10L13 16L21 6.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chart-pie' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 21C16.9706 21 21 16.9706 21 12H12V3C7.02944 3 3 7.02944 3 12C3 16.9706 7.02944 21 12 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chart-pie-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 12C21 16.9706 16.9706 21 12 21M21 12C21 7.02944 16.9706 3 12 3M21 12H12M12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3M12 21V12M12 3V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chart-pie-two' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 3C7.02944 3 3 7.02944 3 12C3 16.9706 7.02944 21 12 21C14.4853 21 16.7353 19.9926 18.364 18.364M12 3C16.9706 3 21 7.02944 21 12C21 14.4853 19.9926 16.7353 18.364 18.364M12 3V12L18.364 18.364" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chat' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 21C16.9706 21 21 16.9706 21 12C21 7.02944 16.9706 3 12 3C7.02944 3 3 7.02944 3 12C3 13.4397 3.33805 14.8005 3.93911 16.0072C4.39285 16.9182 3.76327 18.1473 3.52336 19.044C3.29066 19.9137 4.08631 20.7093 4.95601 20.4766C5.85267 20.2367 7.0818 19.6071 7.99278 20.0609C9.19953 20.6619 10.5603 21 12 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chat-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 12.3225L10.8786 13.898C11.005 14.0425 11.233 14.0319 11.3454 13.8762L14.1449 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 21C16.9706 21 21 16.9706 21 12C21 7.02944 16.9706 3 12 3C7.02944 3 3 7.02944 3 12C3 13.4397 3.33805 14.8005 3.93911 16.0072C4.39285 16.9182 3.76327 18.1473 3.52336 19.044C3.29066 19.9137 4.08631 20.7093 4.95601 20.4766C5.85267 20.2367 7.0818 19.6071 7.99278 20.0609C9.19953 20.6619 10.5603 21 12 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chat-dots' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 12.75V12.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 12.75V12.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 12.75V12.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 21C16.9706 21 21 16.9706 21 12C21 7.02944 16.9706 3 12 3C7.02944 3 3 7.02944 3 12C3 13.4397 3.33805 14.8005 3.93911 16.0072C4.39285 16.9182 3.76327 18.1473 3.52336 19.044C3.29066 19.9137 4.08631 20.7093 4.95601 20.4766C5.85267 20.2367 7.0818 19.6071 7.99278 20.0609C9.19953 20.6619 10.5603 21 12 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chat-messages' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.99986 12.0002C5.8355 11.3722 6.87434 11 8.00008 11C10.761 11 12.9992 13.2386 12.9992 16C12.9992 17.1256 12.6273 18.1643 11.9997 19M4.99986 12.0002C3.78606 12.9124 3.00098 14.3645 3.00098 16C3.00098 16.5165 3.07929 17.0148 3.22468 17.4835C3.49742 18.3627 3.30052 19.3428 3.12637 20.2668C3.0606 20.6158 3.37552 20.8998 3.71802 20.806C4.56558 20.574 5.40939 20.376 6.27495 20.6943C6.81267 20.892 7.39377 21 8.00008 21C9.63561 21 11.0877 20.2144 11.9997 19M4.99986 12.0002C4.99986 7.31488 7.87509 3 12.9992 3C17.4171 3 20.9985 6.58172 20.9985 11C20.9985 11.9473 20.8339 12.8562 20.5316 13.6996C20.0563 15.026 20.5685 16.8017 20.869 18.2677C20.9403 18.6155 20.6245 18.8996 20.2855 18.7938C18.9734 18.3842 17.4332 17.808 16.2003 18.3277C14.8661 18.8902 13.4641 19 11.9997 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chat-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 12H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 21C16.9706 21 21 16.9706 21 12C21 7.02944 16.9706 3 12 3C7.02944 3 3 7.02944 3 12C3 13.4397 3.33805 14.8005 3.93911 16.0072C4.39285 16.9182 3.76327 18.1473 3.52336 19.044C3.29066 19.9137 4.08631 20.7093 4.95601 20.4766C5.85267 20.2367 7.0818 19.6071 7.99278 20.0609C9.19953 20.6619 10.5603 21 12 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chat-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 12H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 9.5L12 14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 21C16.9706 21 21 16.9706 21 12C21 7.02944 16.9706 3 12 3C7.02944 3 3 7.02944 3 12C3 13.4397 3.33805 14.8005 3.93911 16.0072C4.39285 16.9182 3.76327 18.1473 3.52336 19.044C3.29066 19.9137 4.08631 20.7093 4.95601 20.4766C5.85267 20.2367 7.0818 19.6071 7.99278 20.0609C9.19953 20.6619 10.5603 21 12 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chat-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 10L14 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 10L10 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 21C16.9706 21 21 16.9706 21 12C21 7.02944 16.9706 3 12 3C7.02944 3 3 7.02944 3 12C3 13.4397 3.33805 14.8005 3.93911 16.0072C4.39285 16.9182 3.76327 18.1473 3.52336 19.044C3.29066 19.9137 4.08631 20.7093 4.95601 20.4766C5.85267 20.2367 7.0818 19.6071 7.99278 20.0609C9.19953 20.6619 10.5603 21 12 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6 13.6261L7.60619 15.3478C8.49194 16.2972 8.93481 16.772 9.43113 16.9218C9.86704 17.0534 10.3305 17.0181 10.7459 16.8217C11.2189 16.598 11.5985 16.0606 12.3579 14.9859L18 7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'check-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.66602 12.6334L10.1718 14.3543C10.5952 14.8382 11.3587 14.8025 11.7351 14.2813L15.3327 9.30005" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'check-circle-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.80614L12.5616 12.7451C12.8883 13.1063 13.4772 13.0797 13.7676 12.6906L21 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'check-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.66699 12.6334L10.1728 14.3543C10.5962 14.8382 11.3596 14.8025 11.7361 14.2813L15.3337 9.30005" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'check-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.66699 12.6334L10.1728 14.3543C10.5962 14.8382 11.3596 14.8025 11.7361 14.2813L15.3337 9.30005" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'check-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.66699 12.6334L10.1728 14.3543C10.5962 14.8382 11.3596 14.8025 11.7361 14.2813L15.3337 9.30005" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'check-square-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.80614L12.5616 12.7451C12.8883 13.1063 13.4772 13.0797 13.7676 12.6906L21 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'check-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.66602 12.6334L10.1718 14.3543C10.5952 14.8382 11.3587 14.8025 11.7351 14.2813L15.3327 9.30005" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-double-down' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6 6L12 12L18 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 12L12 18L18 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-double-down-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.25781 9.25732L6.25781 17.7426H14.7431" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.2578 5.25732L10.2578 13.7426H18.7431" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-double-down-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.25781 17.7426L17.7431 17.7426V9.25732" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.25781 13.7426L13.7431 13.7426V5.25732" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-double-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 6L6 12L12 18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18 6L12 12L18 18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-double-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 18L18 12L12 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 18L12 12L6 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-double-up' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 12L12 6L6 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18 18L12 12L6 18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-double-up-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.7421 6.25732L6.25684 6.25732L6.25684 14.7426" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18.7431 10.2573L10.2578 10.2573L10.2578 18.7426" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-double-up-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17.7431 14.7426V6.25732H9.25781" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.7431 18.7426V10.2573H5.25781" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-down' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6 9L12 15L18 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-down-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.5 10.75L12 14.25L8.5 10.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-down-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.87891 7.63599V16.1213H16.3642" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-down-left-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.9497 13.9497L10 13.9497L10 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-down-left-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.9497 13.9497L10 13.9497L10 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-down-left-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.9497 13.9497L10 13.9497L10 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-down-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.1215 7.63599V16.1213H7.63623" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-down-right-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.9497 9L13.9497 13.9497L9 13.9497" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-down-right-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.9497 9L13.9497 13.9497L9 13.9497" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-down-right-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.9497 9L13.9497 13.9497L9 13.9497" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-down-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.5 10.75L12 14.25L8.5 10.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-down-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.5 10.75L12 14.25L8.5 10.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 6L9 12L15 18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-left-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.25 15.5L9.75 12L13.25 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-left-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.25 15.5L9.75 12L13.25 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-left-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.25 15.5L9.75 12L13.25 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 18L15 12L9 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-right-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.75 8.5L14.25 12L10.75 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-right-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.75 8.5L14.25 12L10.75 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-right-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.75 8.5L14.25 12L10.75 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-up' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 15L12 9L6 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-up-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.5 13.25L12 9.75L15.5 13.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-up-down' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 16L12 20L16 16M8 8L12 4L16 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-up-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.87891 16.3639V7.87866H16.3642" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-up-left-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 14.9497L10 10L14.9497 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-up-left-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 14.9497L10 10L14.9497 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-up-left-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 14.9497L10 10L14.9497 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-up-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.1215 16.3639V7.87866H7.63623" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-up-right-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 10L13.9497 10L13.9497 14.9497" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-up-right-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 10L13.9497 10L13.9497 14.9497" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-up-right-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 10L13.9497 10L13.9497 14.9497" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-up-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.5 13.25L12 9.75L15.5 13.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chevron-up-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.5 13.25L12 9.75L15.5 13.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'chip' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17 3H7C6.44772 3 6 3.44772 6 4V20C6 20.5523 6.44772 21 7 21H17C17.5523 21 18 20.5523 18 20V4C18 3.44772 17.5523 3 17 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 6H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 10H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 14H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 18H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 6H18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 10H18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 14H18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 18H18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'circle-dashed' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" stroke-dasharray="3.5 3.5"/>
</svg>',
                'circle-half' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 21C16.9706 21 21 16.9706 21 12C21 7.02944 16.9706 3 12 3M12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3M12 21V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'circle-half-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 17C14.7614 17 17 14.7614 17 12C17 9.23858 14.7614 7 12 7V17Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'circle-notch' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.71664 4C4.90752 5.53042 3 8.51937 3 11.956C3 16.9509 7.02944 21 12 21C16.9706 21 21 16.9509 21 11.956C21 8.51937 19.0925 5.53042 16.2834 4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'click' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.91949 6.95645L5.44968 5.47278M14.7585 6.95645L16.2283 5.47278M5.44968 16.353L6.91949 14.8693M10.839 4.97822V3M4.95975 10.9129L3 10.9129M16.8753 16.8364L20.6886 15.3302C21.1039 15.1662 21.1038 14.5729 20.6884 14.409L11.5241 10.7941C11.1264 10.6372 10.734 11.0333 10.8894 11.4348L14.4706 20.6854C14.6329 21.1047 15.2207 21.1049 15.3832 20.6857L16.8753 16.8364Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clipboard' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 5C9 3.89543 9.89543 3 11 3H13C14.1046 3 15 3.89543 15 5V7H9V5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 5H7C5.89543 5 5 5.89543 5 7V19C5 20.1046 5.89543 21 7 21H17C18.1046 21 19 20.1046 19 19V7C19 5.89543 18.1046 5 17 5H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 6V12L16 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-eight' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 6V12L8 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-eleven' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 6V12L9.5 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-five' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 6V12L14.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-four' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 6V12L16 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-hand' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.1465 3V12L18.1465 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 6V12L16 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-nine' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 6V12H7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 6V12L16 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 6V12L14.5 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-seven' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 6V12L9.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-six' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 6V16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 6V12L16 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-ten' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 6V12L8 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-three' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 6V12H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-twelve' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 6V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-two' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 6V12L16 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'clock-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 6V12L16 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cloud' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.2778 17.497C23.9561 14.3426 20.064 10.1132 16.0223 10.1132C13.1753 -0.969193 -3.5256 8.19719 3.8752 16.5505" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cloud-download' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.9661 11.1362L11.9619 19.1362" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.8254 17.0001C24.32 13.8396 20.3006 9.27056 16.1199 9.27056C13.2966 -1.73221 -3.26454 7.36831 4.07436 15.6616" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.1443 16.8181L11.9623 20L8.78027 16.8181" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cloud-lightning' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19.8254 17.0001C24.32 13.8396 20.3006 9.27056 16.1199 9.27056C13.2966 -1.73221 -3.26454 7.36831 4.07436 15.6616" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.501 11L9 16.0006H14.002L11.5 21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cloud-rain' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.0042 19L12 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.0042 21L16 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.0042 17L8 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.8254 17.0001C24.32 13.8396 20.3006 9.27056 16.1199 9.27056C13.2966 -1.73221 -3.26454 7.36831 4.07436 15.6616" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cloud-slash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2.875 21L5.66775 18.2072M20.875 3L15.3429 8.53207M15.3429 8.53207C15.6165 9.06812 15.846 9.67684 16.0223 10.3632C20.064 10.3632 23.9561 14.5926 20.2778 17.747C19.3682 18.527 18.0331 18.75 16.8722 18.75H8.0263C7.19904 18.75 6.39396 18.5602 5.66775 18.2072M15.3429 8.53207L5.66775 18.2072M3.23981 16C-1.30719 9.54224 7.7282 3.00031 12.9994 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cloud-snow' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.0042 17.5L12 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.0042 15.5L16 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.0042 15.5L8 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.0042 21L12 20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.0042 19L16 18.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.0042 19L8 18.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.8249 17.0001C24.3195 13.8396 20.3001 9.27056 16.1194 9.27056C13.2961 -1.73221 -3.26503 7.36831 4.07387 15.6616" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cloud-upload' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.9661 20L11.9619 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.8249 17.0001C24.3195 13.8396 20.3001 9.27056 16.1194 9.27056C13.2961 -1.73221 -3.26503 7.36831 4.07387 15.6616" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.1443 14.3182L11.9623 11.1362L8.78027 14.3182" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cocktail' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 14.25L19.7768 4.62469C20.3058 3.96993 19.835 3 18.9882 3H5.01184C4.165 3 3.69419 3.96993 4.22321 4.62469L12 14.25ZM12 14.25V21M6.54632 7.5H17.4537M7.32902 21H16.671" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'code' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17.0894 7.97388L17.3196 8.20413C19.109 9.9935 20.0037 10.8882 20.0037 12C20.0037 13.1117 19.109 14.0064 17.3196 15.7958L17.0894 16.026" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.8763 5L10.125 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6.91089 7.97388L6.68063 8.20413C4.89127 9.9935 3.99658 10.8882 3.99658 12C3.99658 13.1117 4.89127 14.0064 6.68063 15.7958L6.91089 16.026" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'code-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.9082 9.69946L15.0398 9.83104C16.0623 10.8535 16.5735 11.3648 16.5735 12.0001C16.5735 12.6354 16.0623 13.1466 15.0398 14.1691L14.9082 14.3007" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.0723 8L10.9287 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.09207 9.69946L8.9605 9.83104C7.93801 10.8535 7.42676 11.3648 7.42676 12.0001C7.42676 12.6354 7.93801 13.1466 8.9605 14.1691L9.09207 14.3007" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'code-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.9082 9.69946L15.0398 9.83104C16.0623 10.8535 16.5735 11.3648 16.5735 12.0001C16.5735 12.6354 16.0623 13.1466 15.0398 14.1691L14.9082 14.3007" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.0723 8L10.9287 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.09207 9.69946L8.9605 9.83104C7.93801 10.8535 7.42676 11.3648 7.42676 12.0001C7.42676 12.6354 7.93801 13.1466 8.9605 14.1691L9.09207 14.3007" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'code-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.9082 9.69946L15.0398 9.83104C16.0623 10.8535 16.5735 11.3648 16.5735 12.0001C16.5735 12.6354 16.0623 13.1466 15.0398 14.1691L14.9082 14.3007" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.0723 8L10.9287 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.09207 9.69946L8.9605 9.83104C7.93801 10.8535 7.42676 11.3648 7.42676 12.0001C7.42676 12.6354 7.93801 13.1466 8.9605 14.1691L9.09207 14.3007" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'code-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.9082 9.69946L15.0398 9.83104C16.0623 10.8535 16.5735 11.3648 16.5735 12.0001C16.5735 12.6354 16.0623 13.1466 15.0398 14.1691L14.9082 14.3007" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.0723 8L10.9287 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.09207 9.69946L8.9605 9.83104C7.93801 10.8535 7.42676 11.3648 7.42676 12.0001C7.42676 12.6354 7.93801 13.1466 8.9605 14.1691L9.09207 14.3007" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'code-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.9082 9.69946L15.0398 9.83104C16.0623 10.8535 16.5735 11.3648 16.5735 12.0001C16.5735 12.6354 16.0623 13.1466 15.0398 14.1691L14.9082 14.3007" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.0723 8L10.9287 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.09207 9.69946L8.9605 9.83104C7.93801 10.8535 7.42676 11.3648 7.42676 12.0001C7.42676 12.6354 7.93801 13.1466 8.9605 14.1691L9.09207 14.3007" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'coffee' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 10H19.5C20.8807 10 22 11.1193 22 12.5C22 13.8807 20.8807 15 19.5 15H18M18 10C18 9.47075 17.6394 9 17.0767 9H4.92285C4.41305 9 4 9.41305 4 9.92285V17.0002C4 19.2094 5.79086 21.0002 8 21.0002H14C16.2091 21.0002 18 19.2094 18 17.0002V15M18 10V15M16 3L14 6M13 3L11 6M10 3L8 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cog' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.11 3.9005C10.1611 3.38929 10.5912 3 11.105 3H12.895C13.4088 3 13.8389 3.38929 13.89 3.9005L13.9233 4.23269C14.712 4.42735 15.4547 4.739 16.1318 5.1482L16.3908 4.93631C16.7884 4.61099 17.3678 4.63989 17.7311 5.00316L18.9969 6.2689C19.3601 6.63218 19.389 7.21163 19.0637 7.60925L18.8518 7.86823C19.261 8.54533 19.5727 9.28799 19.7673 10.0767L20.0995 10.1099C20.6107 10.1611 21 10.5912 21 11.105V12.895C21 13.4088 20.6107 13.8389 20.0995 13.89L19.7673 13.9233C19.5727 14.712 19.261 15.4547 18.8518 16.1318L19.0637 16.3908C19.389 16.7884 19.3601 17.3679 18.9968 17.7311L17.7311 18.9969C17.3678 19.3601 16.7884 19.389 16.3908 19.0637L16.1318 18.8518C15.4547 19.261 14.712 19.5727 13.9233 19.7673L13.89 20.0995C13.8389 20.6107 13.4088 21 12.895 21H11.105C10.5912 21 10.1611 20.6107 10.11 20.0995L10.0767 19.7673C9.28799 19.5727 8.54533 19.261 7.86822 18.8518L7.60929 19.0637C7.21167 19.389 6.63222 19.3601 6.26894 18.9968L5.00321 17.7311C4.63993 17.3678 4.61103 16.7884 4.93636 16.3907L5.1482 16.1318C4.73901 15.4547 4.42735 14.712 4.23269 13.9233L3.9005 13.89C3.38929 13.8389 3 13.4088 3 12.895V11.105C3 10.5912 3.38929 10.1611 3.9005 10.11L4.23269 10.0767C4.42734 9.28799 4.73899 8.54533 5.14818 7.86822L4.93632 7.60929C4.611 7.21167 4.6399 6.63222 5.00317 6.26894L6.26891 5.00321C6.63219 4.63993 7.21164 4.61103 7.60926 4.93636L7.86818 5.1482C8.5453 4.73901 9.28797 4.42735 10.0767 4.23269L10.11 3.9005Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="1" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="2.5" cy="2.5" r="2.5" transform="matrix(1 0 0 -1 9.5 14.5)" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="1" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cog-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="2.5" cy="2.5" r="2.5" transform="matrix(1 0 0 -1 9.5 14.5)" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="1" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cog-two' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="2.5" cy="2.5" r="2.5" transform="matrix(1 0 0 -1 9.5 14.5)" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="1" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cog-three' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.39978 18.2354C10.0535 19.1901 12.0188 19.4489 13.8633 18.9546C15.7078 18.4604 17.2804 17.2537 18.2352 15.6C19.1899 13.9463 19.4487 11.981 18.9544 10.1365C18.4602 8.29199 17.2535 6.71937 15.5998 5.76459M8.39978 18.2354C6.74605 17.2806 5.53935 15.708 5.04511 13.8635C4.55088 12.019 4.80962 10.0537 5.7644 8.39998M8.39978 18.2354L7.49978 19.7942M15.5998 5.76459C13.9461 4.80982 11.9808 4.55108 10.1363 5.04531C8.29179 5.53954 6.71918 6.74625 5.7644 8.39998M15.5998 5.76459L16.4998 4.20575M5.7644 8.39998L4.20555 7.49998M14.4998 13.5L19.794 16.5M11.9999 20.9997L11.999 19.2013M11.9999 8.99997L11.9996 3.00024M16.4996 19.7941L15.6012 18.2362M7.5 4.20588L8.3984 5.7638M20.9996 11.9999L19.2012 12.0008M3 12.0001L4.7984 11.9992M19.7939 7.50024L18.2359 8.39865M9.49976 13.5L4.20568 16.4998" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="2.5" cy="2.5" r="2.5" transform="matrix(1 0 0 -1 9.5 14.5)" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="1" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'columns' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17.5 3C18.0523 3 18.5 3.44772 18.5 4L18.5 20C18.5 20.5523 18.0523 21 17.5 21H14.5C13.9477 21 13.5 20.5523 13.5 20L13.5 4C13.5 3.44772 13.9477 3 14.5 3L17.5 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 3C10.0523 3 10.5 3.44772 10.5 4L10.5 20C10.5 20.5523 10.0523 21 9.5 21H6.5C5.94772 21 5.5 20.5523 5.5 20L5.5 4C5.5 3.44772 5.94772 3 6.5 3L9.5 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'command' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.0115 5.97707V18.0229C15.0115 20.6679 18.3283 21.9765 20.1524 20.1524C21.9765 18.3283 20.6679 15.0115 18.0229 15.0115H5.97707C3.33209 15.0115 2.02355 18.3283 3.84765 20.1524C5.67175 21.9765 8.98854 20.6679 8.98854 18.0229V5.97707C8.98854 3.33209 5.67175 2.02355 3.84765 3.84765C2.02355 5.67175 3.33209 8.98854 5.97707 8.98854H18.0229C20.6679 8.98854 21.9765 5.67175 20.1524 3.84765C18.3283 2.02355 15.0115 3.33209 15.0115 5.97707Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'compass' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 15L10.5 10.5L15 9L13.5 13.5L9 15Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'components' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.8501 6.15L12.0001 3L15.1501 6.15L12.0001 9.3L8.8501 6.15Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.7002 12.45L17.8502 9.30005L21.0002 12.45L17.8502 15.6L14.7002 12.45Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.8501 17.85L12.0001 14.7L15.1501 17.85L12.0001 21L8.8501 17.85Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12.0001L6.15 8.8501L9.3 12.0001L6.15 15.1501L3 12.0001Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'confetti' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.67484 20.9712C3.27882 21.1083 2.89666 20.7335 3.02545 20.3344L5.61521 9.20981C5.73568 8.8365 6.21525 8.73459 6.47686 9.0267L14.2333 16.5707C14.4758 16.8414 14.3643 17.2719 14.0211 17.3906L3.67484 20.9712Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.8936 9.2757L13.2998 6.66083C14.5831 5.26623 14.7435 4.04595 13.781 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 5.25V4.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20 4.5V4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20 13.5V13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18 18.5V18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.7812 12.4135L16.1875 9.79865C17.7917 8.0554 19.3958 8.0554 21 9.79865" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'config' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 5H18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.75 3V7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13 5H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7 12H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.75 10V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 12H11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 19H18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.75 17V21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13 19H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'config-vertical' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5 3L5 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 10.25L7 10.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5 11L5 21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 17L12 21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 13.25L14 13.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 3L12 13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19 3L19 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17 10.25L21 10.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19 11L19 21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'contactless' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17.4601 21C18.7801 18.24 19.5001 15.24 19.5001 12C19.5001 8.76 18.7801 5.64 17.4601 3M13.1399 18.9601C14.0999 16.8001 14.6999 14.4001 14.6999 12.0001C14.6999 9.60012 14.0999 7.08012 13.1399 4.92012M8.82012 16.9199C9.54012 15.3599 9.90012 13.6799 9.90012 11.9999C9.90012 10.3199 9.54012 8.51988 8.82012 7.07988M4.5 14.7601C4.86 13.9201 5.1 12.9601 5.1 12.0001C5.1 11.0401 4.86 9.96012 4.5 9.12012" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'contactless-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 9.98975C8.14748 10.6361 8.22538 11.309 8.22538 12.0001C8.22538 12.6912 8.14748 13.3641 8 14.0105M10.9754 8.42041C11.3003 9.55751 11.4744 10.7583 11.4744 11.9998C11.4744 13.2412 11.3003 14.442 10.9754 15.5792M14.2244 6.85938C14.7382 8.48113 15.0154 10.2082 15.0154 12C15.0154 13.7918 14.7382 15.5188 14.2244 17.1406" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'controller' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.5 11.5V14.5M6 13L9 13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8.34753C14.0054 8.34753 15.7006 6.45953 17.7863 7.13497C20.0499 7.86802 21.6069 10.5479 21.4943 16.6265C21.4716 17.8513 21.1577 19.2049 19.9475 19.7334C17.1513 20.9544 15.551 17.405 12.9489 17.405H11.0511C8.44646 17.405 6.83819 20.9498 4.05252 19.7334C2.84228 19.2049 2.52843 17.8513 2.50573 16.6265C2.39311 10.5479 3.95013 7.86802 6.21369 7.13498C8.29941 6.45952 9.99459 8.34753 12 8.34753Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 3.78247L12 8.12372" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.8745 13H17.8745" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cookie' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.0028 21C16.8593 21 20.8177 17.1545 20.9991 12.3424C21.0049 12.1889 20.8383 12.0919 20.7011 12.1609C18.225 13.4077 16.6954 12.0843 16.9437 10.3073C16.964 10.1618 16.837 10.0296 16.6916 10.0499C14.5209 10.3534 13.6064 9.03577 13.9481 7.24638C13.9725 7.11854 13.8764 6.99606 13.7467 6.98455C11.7041 6.80316 11.5354 4.44423 11.8857 3.29509C11.9291 3.15283 11.8272 2.99487 11.6786 3.00013C6.85665 3.17081 3 7.13362 3 11.9972C3 16.9693 7.03069 21 12.0028 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 16.3536L15.3536 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 17.3536L10.3536 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 8.35355L8.35355 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7 13.3536L7.35355 13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 12.3536L12.3536 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'copy' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.8287 12.861C21 12.4476 21 11.9234 21 10.875C21 9.82663 21 9.30245 20.8287 8.88896C20.6004 8.33765 20.1624 7.89963 19.611 7.67127C19.1976 7.5 18.6734 7.5 17.625 7.5H11.1C9.83988 7.5 9.20982 7.5 8.72852 7.74524C8.30516 7.96095 7.96095 8.30516 7.74524 8.72852C7.5 9.20982 7.5 9.83988 7.5 11.1V17.625C7.5 18.6734 7.5 19.1976 7.67127 19.611C7.89963 20.1624 8.33765 20.6004 8.88896 20.8287C9.30245 21 9.82663 21 10.875 21C11.9234 21 12.4476 21 12.861 20.8287M20.8287 12.861C20.6004 13.4124 20.1624 13.8504 19.611 14.0787C19.1976 14.25 18.6734 14.25 17.625 14.25C16.5766 14.25 16.0524 14.25 15.639 14.4213C15.0876 14.6496 14.6496 15.0876 14.4213 15.639C14.25 16.0524 14.25 16.5766 14.25 17.625C14.25 18.6734 14.25 19.1976 14.0787 19.611C13.8504 20.1624 13.4124 20.6004 12.861 20.8287M20.8287 12.861C19.7364 16.6288 16.8253 19.5963 13.0793 20.7609L12.861 20.8287M16.5 7.5L16.5 6.6C16.5 5.33988 16.5 4.70982 16.2548 4.22852C16.039 3.80516 15.6948 3.46095 15.2715 3.24524C14.7902 3 14.1601 3 12.9 3H6.6C5.33988 3 4.70982 3 4.22852 3.24524C3.80516 3.46095 3.46095 3.80516 3.24524 4.22852C3 4.70982 3 5.33988 3 6.6V12.9C3 14.1601 3 14.7902 3.24524 15.2715C3.46095 15.6948 3.80516 16.039 4.22852 16.2548C4.70982 16.5 5.3401 16.5 6.60066 16.5H7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'copyleft' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.75 9C10.2303 8.40081 10.82 8 11.75 8C15.9215 8 15.9215 16 11.75 16C10.82 16 10.2303 15.5992 9.75 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'copyright' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.0002 9C13.5199 8.40081 12.9302 8 12.0002 8C7.82871 8 7.82871 16 12.0002 16C12.9302 16 13.5199 15.5992 14.0002 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'copyright-slash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 21L5.63604 18.364M21 3L18.364 5.63604M18.364 5.63604C19.9926 7.26472 21 9.51472 21 12C21 16.9706 16.9706 21 12 21C9.51472 21 7.26472 19.9926 5.63604 18.364M18.364 5.63604L5.63604 18.364M3.6152 15.277C3.21802 14.2615 3 13.1562 3 12C3 7.02944 7.02944 3 12 3C13.1562 3 14.2615 3.21802 15.277 3.6152" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.9997 9C13.5195 8.40081 12.9297 8 11.9997 8C7.82822 8 7.82822 16 11.9997 16C12.9297 16 13.5195 15.5992 13.9997 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'corner-down-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5 13.9728L15 13.9728C17.2091 13.9728 19 12.1819 19 9.97277V5M5 13.9728L9.78038 8.94555M5 13.9728L9.78038 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'corner-down-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19 13.9728L9 13.9728C6.79086 13.9728 5 12.1819 5 9.97277V5M19 13.9728L14.2196 8.94555M19 13.9728L14.2196 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'corner-left-down' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.0272 19L10.0272 9C10.0272 6.79086 11.8181 5 14.0272 5H19M10.0272 19L15.0545 14.2196M10.0272 19L5 14.2196" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'corner-left-up' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.0272 5L10.0272 15C10.0272 17.2091 11.8181 19 14.0272 19H19M10.0272 5L15.0545 9.78038M10.0272 5L5 9.78038" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'corner-right-down' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.9728 19L13.9728 9C13.9728 6.79086 12.1819 5 9.97277 5L5 5M13.9728 19L8.94555 14.2196M13.9728 19L19 14.2196" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'corner-right-up' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.9728 5L13.9728 15C13.9728 17.2091 12.1819 19 9.97277 19H5M13.9728 5L8.94555 9.78038M13.9728 5L19 9.78038" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'corner-up-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5 10.0272L15 10.0272C17.2091 10.0272 19 11.8181 19 14.0272V19M5 10.0272L9.78038 15.0545M5 10.0272L9.78038 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'corner-up-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19 10.0272L9 10.0272C6.79086 10.0272 5 11.8181 5 14.0272V19M19 10.0272L14.2196 15.0545M19 10.0272L14.2196 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'credit-card' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 9V8.2002C3 7.08009 3 6.51962 3.21799 6.0918C3.40973 5.71547 3.71547 5.40973 4.0918 5.21799C4.51962 5 5.08009 5 6.2002 5H17.8002C18.9203 5 19.4796 5 19.9074 5.21799C20.2837 5.40973 20.5905 5.71547 20.7822 6.0918C21 6.5192 21 7.07899 21 8.19691V9M3 9H21M3 9V15.8002C3 16.9203 3 17.4801 3.21799 17.9079C3.40973 18.2842 3.71547 18.5905 4.0918 18.7822C4.5192 19 5.07899 19 6.19691 19H17.8031C18.921 19 19.48 19 19.9074 18.7822C20.2837 18.5905 20.5905 18.2842 20.7822 17.9079C21 17.4805 21 16.9215 21 15.8036V9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 15H10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'credit-card-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 9V8.2002C3 7.08009 3 6.51962 3.21799 6.0918C3.40973 5.71547 3.71547 5.40973 4.0918 5.21799C4.51962 5 5.08009 5 6.2002 5H12.5M3 9H12.5M3 9V15.8002C3 16.9203 3 17.4801 3.21799 17.9079C3.40973 18.2842 3.71547 18.5905 4.0918 18.7822C4.5192 19 5.07899 19 6.19691 19H17.8031C18.921 19 19.48 19 19.9074 18.7822C20.2837 18.5905 20.5905 18.2842 20.7822 17.9079C21 17.4805 21 16.9215 21 15.8036V11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 7.32245L17.484 8.89803C17.6201 9.04251 17.8655 9.03186 17.9865 8.87622L21 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 15H10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'credit-card-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 9V11V15.8002C3 16.9203 3 17.4801 3.21799 17.9079C3.40973 18.2842 3.71547 18.5905 4.0918 18.7822C4.5192 19 5.07899 19 6.19691 19H17.8031C18.921 19 19.48 19 19.9074 18.7822C20.2837 18.5905 20.5905 18.2842 20.7822 17.9079C21 17.4805 21 16.9215 21 15.8036V11M3 9V8.2002C3 7.08009 3 6.51962 3.21799 6.0918C3.40973 5.71547 3.71547 5.40973 4.0918 5.21799C4.51962 5 5.08009 5 6.2002 5H12.5M3 9H12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 15H10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.5 7.5H20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'credit-card-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 9V11V15.8002C3 16.9203 3 17.4801 3.21799 17.9079C3.40973 18.2842 3.71547 18.5905 4.0918 18.7822C4.5192 19 5.07899 19 6.19691 19H17.8031C18.921 19 19.48 19 19.9074 18.7822C20.2837 18.5905 20.5905 18.2842 20.7822 17.9079C21 17.4805 21 16.9215 21 15.8036V11M3 9V8.2002C3 7.08009 3 6.51962 3.21799 6.0918C3.40973 5.71547 3.71547 5.40973 4.0918 5.21799C4.51962 5 5.08009 5 6.2002 5H12.5M3 9H12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 15H10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.5 7.5H20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18 5L18 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'credit-card-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 9V8.2002C3 7.08009 3 6.51962 3.21799 6.0918C3.40973 5.71547 3.71547 5.40973 4.0918 5.21799C4.51962 5 5.08009 5 6.2002 5H12.5M3 9H12.5M3 9V15.8002C3 16.9203 3 17.4801 3.21799 17.9079C3.40973 18.2842 3.71547 18.5905 4.0918 18.7822C4.5192 19 5.07899 19 6.19691 19H17.8031C18.921 19 19.48 19 19.9074 18.7822C20.2837 18.5905 20.5905 18.2842 20.7822 17.9079C21 17.4805 21 16.9215 21 15.8036V11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 15H10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.5 5L20.5 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 5L16.5 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'croissant' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.803 9.99722L9.75 7.689C9.48 7.032 9.12 6.6 8.4 6.6M8.4 6.6H5.25C3.711 6.6 3 7.05 3 8.85C3.07546 10.4644 3.82664 12.1164 4.91457 13.3116M8.4 6.6C8.4 5.205 8.616 3 6.6 3C4.8 3 4.35 5.02859 4.35 6.67559M14 13.2097L16.311 14.25C16.968 14.52 17.4 14.88 17.4 15.6M17.4 15.6V18.75C17.4 20.289 16.95 21 15.15 21C13.5356 20.9245 11.8862 20.176 10.6911 19.0881M17.4 15.6C18.795 15.6 21 15.3839 21 17.3999C21 19.1999 18.9714 19.6499 17.3244 19.6499M5.34001 12.9991L10.551 10.1101C12.252 9.16507 14.862 11.7121 13.89 13.4491L10.992 18.6781C9.12001 22.0441 1.91101 14.9071 5.34001 12.9991Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'crop' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.59961 3V12.6C6.59961 14.2802 6.59961 15.1202 6.92659 15.762C7.21421 16.3265 7.67315 16.7854 8.23764 17.073C8.87937 17.4 9.71945 17.4 11.3996 17.4H20.9996" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.2002 6.6001H12.6002C14.2804 6.6001 15.1204 6.6001 15.7622 6.92708C16.3267 7.2147 16.7856 7.67364 17.0732 8.23813C17.4002 8.87986 17.4002 9.71994 17.4002 11.4001V14.8001" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6.6 6.6001H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17.4004 20.9999V17.3999" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'crosshair' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 12H18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 12H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 6V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 21V18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'cupcake' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.99992 14L5.80367 19.6263C5.948 20.6366 6.30756 21 7.38524 21H9.99996M4.99992 14H8.99996M4.99992 14C3.69683 13.3956 3 11.7637 3 10.3335C3 8.79807 4.02938 7.48314 5.49019 6.93701C5.80292 6.8201 5.99996 6.51809 5.99996 6.2085C5.99996 4.94284 7.11925 3.9165 8.49996 3.9165C9.16787 3.9165 9.80969 4.23873 10.4414 3.85059C11.3159 3.31321 12.368 3 13.5 3C16.5375 3 19 5.25723 19 8.04167C19 9.29823 21 9.63609 21 11.2502C21 12.5275 20.2877 13.6908 19 14M19 14H15M19 14L18.1961 19.6276C18.0438 20.6933 17.6349 21 16.6147 21H14M15 14H8.99996M15 14L14 21M8.99996 14L9.99996 21M9.99996 21H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'danger' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 19V18.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 5L12 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'danger-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 7.62671V13.1267" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 16.3733V15.8733" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'danger-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 7.62671V13.1267" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 16.3733V15.8733" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'danger-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 7.62671V13.1267" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 16.3733V15.8733" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'danger-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 7.62671V13.1267" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 16.3733V15.8733" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'danger-triangle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.98054 10.7615C8.60706 5.58716 9.92033 3 12 3C14.0797 3 15.3929 5.58716 18.0195 10.7615L18.3467 11.4063C20.5294 15.7061 21.6207 17.856 20.6344 19.428C19.648 21 17.2078 21 12.3273 21H11.6727C6.7922 21 4.35195 21 3.36563 19.428C2.37931 17.856 3.47062 15.7061 5.65325 11.4063L5.98054 10.7615Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8.5V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 17.2466V16.7466" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'danger-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 7.62671V13.1267" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 16.3733V15.8733" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'database' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 3C7.58172 3 4 4.28939 4 5.87993C4 10.04 20 10.04 20 5.87993C20 4.28939 16.4183 3 12 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20 11.75C20 16.4167 4 16.4167 4 11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4 6V18.1654C4 21.9449 20 21.9449 20 18.1654V6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'daze-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 12L10 10.5L8 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 12L14 10.5L16 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 16.25L14.6667 15.25L13.3333 16.25L12 15.25L10.6667 16.25L9.33333 15.25L8 16.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'daze-ghost' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 12L10 10.5L8 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 12L14 10.5L16 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 16.25L14.6667 15.25L13.3333 16.25L12 15.25L10.6667 16.25L9.33333 15.25L8 16.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 18.5615V12.0443C3 7.04928 7.02944 3 12 3C16.9706 3 21 7.04928 21 12.0443V18.5615C21 19.7226 20.0334 21.08 19 20.5608C18.1647 20.1411 16.777 20.0402 16 20.5608C15.1259 21.1464 13.8741 21.1464 13 20.5608C12.1148 19.9678 11.3511 19.9906 10.5 20.5608C9.6259 21.1464 8.3741 21.1464 7.5 20.5608C6.723 20.0402 5.83525 20.1411 5 20.5608C3.9666 21.08 3 19.7226 3 18.5615Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'daze-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 12L10 10.5L8 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 12L14 10.5L16 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 16.25L14.6667 15.25L13.3333 16.25L12 15.25L10.6667 16.25L9.33333 15.25L8 16.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'delete' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.5 10L17.5 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17.5 10L13.5 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.5953 18.5H9.29784C8.77618 18.5 8.27516 18.2962 7.90164 17.932L2.5519 12.716C2.14937 12.3235 2.14937 11.6765 2.5519 11.284L7.90164 6.068C8.27516 5.70382 8.77618 5.5 9.29784 5.5H19.5953C20.545 5.5 21.8175 6.04117 21.8175 7.125V16.875C21.8175 17.9588 20.545 18.5 19.5953 18.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'desktop' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 20H12M15 20H12M12 20V17M12 17H19C20.1046 17 21 16.1046 21 15V6C21 4.89543 20.1046 4 19 4H5C3.89543 4 3 4.89543 3 6V15C3 16.1046 3.89543 17 5 17H12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dice-five' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.25 8H7.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.25 16H7.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.25 8H15.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.25 16H15.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.25 12H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dice-four' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.25 8H7.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.25 16H7.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.25 8H15.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.25 16H15.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dice-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.75 12L12.25 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dice-six' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.25 12H7.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.25 8H7.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.25 16H7.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.25 12H15.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.25 8H15.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.25 16H15.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dice-three' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.25 8H7.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.25 12H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.25 16H15.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dice-two' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.25 8H7.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.25 16H15.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dislike' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.4599 13.8947H4.92748C2.38126 13.8947 5.69116 3 7.51474 3H20.0363C20.5685 3 21 3.42414 21 3.94737V13.3323C21 13.679 20.8074 13.998 20.4978 14.164C18.4361 15.2695 16.0167 16.1758 14.8204 18.2929L13.5396 20.5593C13.3859 20.8313 13.0942 21 12.7777 21C9.59775 21 10.5411 16.3702 10.9733 14.5292C11.0495 14.2046 10.7987 13.8947 10.4599 13.8947Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'divide' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 5.74356V5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 18.9999V18.2563" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dollar' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17 5H12M12 5H9.5C7.567 5 6 6.567 6 8.5C6 10.433 7.567 12 9.5 12H12M12 5V3M12 5V12M12 12H14.5C16.433 12 18 13.567 18 15.5C18 17.433 16.433 19 14.5 19H12M12 12V19M12 19H6M12 19V21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dollar-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.3333 7.72222H12M12 7.72222H10.3333C9.04467 7.72222 8 8.67984 8 9.86111C8 11.0424 9.04467 12 10.3333 12H12M12 7.72222V6.5M12 7.72222V12M12 12H13.6667C14.9553 12 16 12.9576 16 14.1389C16 15.3202 14.9553 16.2778 13.6667 16.2778H12M12 12V16.2778M12 16.2778H8M12 16.2778V17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dollar-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.3333 7.72222H12M12 7.72222H10.3333C9.04467 7.72222 8 8.67984 8 9.86111C8 11.0424 9.04467 12 10.3333 12H12M12 7.72222V6.5M12 7.72222V12M12 12H13.6667C14.9553 12 16 12.9576 16 14.1389C16 15.3202 14.9553 16.2778 13.6667 16.2778H12M12 12V16.2778M12 16.2778H8M12 16.2778V17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dollar-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.3333 7.72222H12M12 7.72222H10.3333C9.04467 7.72222 8 8.67984 8 9.86111C8 11.0424 9.04467 12 10.3333 12H12M12 7.72222V6.5M12 7.72222V12M12 12H13.6667C14.9553 12 16 12.9576 16 14.1389C16 15.3202 14.9553 16.2778 13.6667 16.2778H12M12 12V16.2778M12 16.2778H8M12 16.2778V17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dollar-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.3333 7.72222H12M12 7.72222H10.3333C9.04467 7.72222 8 8.67984 8 9.86111C8 11.0424 9.04467 12 10.3333 12H12M12 7.72222V6.5M12 7.72222V12M12 12H13.6667C14.9553 12 16 12.9576 16 14.1389C16 15.3202 14.9553 16.2778 13.6667 16.2778H12M12 12V16.2778M12 16.2778H8M12 16.2778V17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dollar-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.3333 7.72222H12M12 7.72222H10.3333C9.04467 7.72222 8 8.67984 8 9.86111C8 11.0424 9.04467 12 10.3333 12H12M12 7.72222V6.5M12 7.72222V12M12 12H13.6667C14.9553 12 16 12.9576 16 14.1389C16 15.3202 14.9553 16.2778 13.6667 16.2778H12M12 12V16.2778M12 16.2778H8M12 16.2778V17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dots' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dots-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dots-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dots-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dots-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dots-vertical' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.25 12H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.25 8H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.25 16H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dots-vertical-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.25 12H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.25 8H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.25 16H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dots-vertical-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.25 12H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.25 8H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.25 16H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dots-vertical-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.25 12H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.25 8H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.25 16H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dots-vertical-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.25 12H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.25 8H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.25 16H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dots-vertical-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.25 12H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.25 8H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.25 16H11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'dots-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 12.25V11.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'download' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4 16.0042V17C4 18.6569 5.34315 20 7 20H17C18.6569 20 20 18.6569 20 17V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 4.5V15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.5 12L12 15.5L8.5 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'drop' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.4952 3C16.0754 6.55956 21.8401 10.6022 19.4268 16.3974C18.2752 19.1629 15.4916 21 12.4999 21C9.5082 21 6.72455 19.1629 5.57297 16.3974C3.16141 10.6063 8.9195 6.56138 12.4952 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'earth' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.0002 3.0481C12.6522 3.34099 12.3387 3.68664 12.0719 4.08265C10.5291 6.3729 11.135 9.48019 13.4253 11.023C13.6061 11.1448 13.792 11.2532 13.9818 11.3484C16.0002 12.3612 16.7708 10.9962 17.8637 11.7323C18.5725 12.2099 18.7601 13.1716 18.2826 13.8805C17.7821 14.6234 17.0002 15 17.1355 16.2168C17.2118 16.9036 17.6338 17.4954 18.1805 18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4 9.28003C5.08188 9.54331 6.083 10.1678 6.80601 11.1259C7.57668 12.1472 7.89615 13.3684 7.79785 14.5504C7.74578 15.1764 8.15405 15.8083 8.6794 16.1526C8.93324 16.319 9.16323 16.5312 9.35655 16.7874C10.2126 17.9218 10.0418 19.511 9 20.4407" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'edit' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4 21H20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.66611 13.1873C5.23958 13.6144 5 14.1934 5 14.797V18H8.2226C8.82681 18 9.40626 17.7599 9.83341 17.3325L19.3333 7.82715C20.2222 6.93768 20.2222 5.49598 19.3333 4.60651L18.3948 3.66751C17.5051 2.77726 16.062 2.77753 15.1726 3.66813L5.66611 13.1873Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'edit-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.53289 11.1498C9.19166 11.4915 9 11.9547 9 12.4376V15H11.5781C12.0614 15 12.525 14.8079 12.8667 14.466L20.4666 6.86172C21.1778 6.15014 21.1778 4.99678 20.4666 4.28521L19.7159 3.53401C19.0041 2.82181 17.8496 2.82202 17.1381 3.5345L9.53289 11.1498Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'egg' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 21C16.0041 21 19.25 17.7765 19.25 13.8C19.25 9.82355 16.0041 3 12 3C7.99594 3 4.75 9.82355 4.75 13.8C4.75 17.7765 7.99594 21 12 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'eight' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.875 12C11.875 12 15 12.625 15 14.5C15 16.375 13.6009 17 11.875 17C10.1491 17 8.75 16.375 8.75 14.5C8.75 12.625 11.875 12 11.875 12ZM11.875 12C11.875 12 15 11.375 15 9.5C15 7.625 13.6009 7 11.875 7C10.1491 7 8.75 7.625 8.75 9.5C8.75 11.375 11.875 12 11.875 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'eight-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 12C12 12 14.5 12.5 14.5 14C14.5 15.5 13.3807 16 12 16C10.6193 16 9.5 15.5 9.5 14C9.5 12.5 12 12 12 12ZM12 12C12 12 14.5 11.5 14.5 10C14.5 8.5 13.3807 8 12 8C10.6193 8 9.5 8.5 9.5 10C9.5 11.5 12 12 12 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'eight-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 12C12 12 14.5 12.5 14.5 14C14.5 15.5 13.3807 16 12 16C10.6193 16 9.5 15.5 9.5 14C9.5 12.5 12 12 12 12ZM12 12C12 12 14.5 11.5 14.5 10C14.5 8.5 13.3807 8 12 8C10.6193 8 9.5 8.5 9.5 10C9.5 11.5 12 12 12 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'eight-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 12C12 12 14.5 12.5 14.5 14C14.5 15.5 13.3807 16 12 16C10.6193 16 9.5 15.5 9.5 14C9.5 12.5 12 12 12 12ZM12 12C12 12 14.5 11.5 14.5 10C14.5 8.5 13.3807 8 12 8C10.6193 8 9.5 8.5 9.5 10C9.5 11.5 12 12 12 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'eight-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 12C12 12 14.5 12.5 14.5 14C14.5 15.5 13.3807 16 12 16C10.6193 16 9.5 15.5 9.5 14C9.5 12.5 12 12 12 12ZM12 12C12 12 14.5 11.5 14.5 10C14.5 8.5 13.3807 8 12 8C10.6193 8 9.5 8.5 9.5 10C9.5 11.5 12 12 12 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'eight-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 12C12 12 14.5 12.5 14.5 14C14.5 15.5 13.3807 16 12 16C10.6193 16 9.5 15.5 9.5 14C9.5 12.5 12 12 12 12ZM12 12C12 12 14.5 11.5 14.5 10C14.5 8.5 13.3807 8 12 8C10.6193 8 9.5 8.5 9.5 10C9.5 11.5 12 12 12 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'eight-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 12C12 12 14.5 12.5 14.5 14C14.5 15.5 13.3807 16 12 16C10.6193 16 9.5 15.5 9.5 14C9.5 12.5 12 12 12 12ZM12 12C12 12 14.5 11.5 14.5 10C14.5 8.5 13.3807 8 12 8C10.6193 8 9.5 8.5 9.5 10C9.5 11.5 12 12 12 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'elevator' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 8.29412H16.5C17.6046 8.29412 18.5 9.18955 18.5 10.2941V19C18.5 20.1046 17.6046 21 16.5 21H12M12 8.29412H7.5C6.39543 8.29412 5.5 9.18955 5.5 10.2941V19C5.5 20.1046 6.39543 21 7.5 21H12M12 8.29412V21M7.125 4.58824L8.75 3L10.375 4.58824M13.625 3L15.25 4.58824L16.875 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'envelope' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2 12C2 8.22876 2 6.34315 3.46447 5.17157C4.92893 4 7.28595 4 12 4C16.714 4 19.0711 4 20.5355 5.17157C22 6.34315 22 8.22876 22 12C22 15.7712 22 17.6569 20.5355 18.8284C19.0711 20 16.714 20 12 20C7.28595 20 4.92893 20 3.46447 18.8284C2 17.6569 2 15.7712 2 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.6662 5.31006L15.8407 9.79897C14.0041 11.3295 13.0857 12.0948 11.9996 12.0948C10.9134 12.0948 9.99512 11.3295 8.15848 9.79897L3.33301 5.31006" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'euro' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 10H7.1192M7.1192 10H4M7.1192 10C7.67008 5.74573 10.1303 4 14.5 4C16.918 4 18.7513 4.53456 20 5.73295M7.1192 10C7.03973 10.6137 7 11.2796 7 12C7 12.7204 7.03973 13.3863 7.1192 14M14 14H7.1192M7.1192 14H4M7.1192 14C7.67008 18.2543 10.1303 20 14.5 20C16.918 20 18.7513 19.4654 20 18.2671" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'euro-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 12C12 12 9.86683 12 8.5 12M8.5 12C7.91421 12 7 12 7 12M8.5 12C8.5 14 10.0652 16 12.25 16C13.459 16 14.3757 15.7327 15 15.1335M8.5 12C8.5 10 9.75 8 12.25 8C13.459 8 14.3757 8.26728 15 8.86647" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'euro-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 12C12 12 9.86683 12 8.5 12M8.5 12C7.91421 12 7 12 7 12M8.5 12C8.5 14 10.0652 16 12.25 16C13.459 16 14.3757 15.7327 15 15.1335M8.5 12C8.5 10 9.75 8 12.25 8C13.459 8 14.3757 8.26728 15 8.86647" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'euro-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 12C12 12 9.86683 12 8.5 12M8.5 12C7.91421 12 7 12 7 12M8.5 12C8.5 14 10.0652 16 12.25 16C13.459 16 14.3757 15.7327 15 15.1335M8.5 12C8.5 10 9.75 8 12.25 8C13.459 8 14.3757 8.26728 15 8.86647" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'euro-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 12C12 12 9.86683 12 8.5 12M8.5 12C7.91421 12 7 12 7 12M8.5 12C8.5 14 10.0652 16 12.25 16C13.459 16 14.3757 15.7327 15 15.1335M8.5 12C8.5 10 9.75 8 12.25 8C13.459 8 14.3757 8.26728 15 8.86647" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'euro-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 12C12 12 9.86683 12 8.5 12M8.5 12C7.91421 12 7 12 7 12M8.5 12C8.5 14 10.0652 16 12.25 16C13.459 16 14.3757 15.7327 15 15.1335M8.5 12C8.5 10 9.75 8 12.25 8C13.459 8 14.3757 8.26728 15 8.86647" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'exclude' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.4 15.6H6C4.34315 15.6 3 14.2569 3 12.6V6C3 4.34314 4.34315 3 6 3H12.6C14.2569 3 15.6 4.34315 15.6 6V8.4M8.4 15.6V18C8.4 19.6569 9.74314 21 11.4 21H18C19.6569 21 21 19.6569 21 18V11.4C21 9.74315 19.6569 8.4 18 8.4H15.6M8.4 15.6V13.8M8.4 15.6H10.2M15.6 8.4H13.8M15.6 8.4V10.2M8.4 10.2C8.4 9.20589 9.20589 8.4 10.2 8.4M15.6 13.8C15.6 14.7941 14.7941 15.6 13.8 15.6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'external-link' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 3.00659C7.05423 3.03864 5.41028 3.22572 4.31802 4.31799C3 5.63601 3 7.75733 3 12C3 16.2426 3 18.3639 4.31802 19.6819C5.63604 21 7.75736 21 12 21C16.2426 21 18.364 21 19.682 19.6819C20.7432 18.6208 20.95 17.0389 20.9902 14.2483" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 3H14.25M21 3V9.75M21 3L12.75 11.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'eye' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2.54961 13.4056C2.2778 13.0326 2.1419 12.8462 2.04835 12.4854C1.98388 12.2367 1.98388 11.7633 2.04835 11.5146C2.1419 11.1538 2.2778 10.9674 2.54961 10.5944C4.03902 8.55068 7.30262 5 12 5C16.6974 5 19.961 8.55068 21.4504 10.5944C21.7222 10.9674 21.8581 11.1538 21.9516 11.5146C22.0161 11.7633 22.0161 12.2367 21.9516 12.4854C21.8581 12.8462 21.7222 13.0326 21.4504 13.4056C19.961 15.4493 16.6974 19 12 19C7.30262 19 4.03902 15.4493 2.54961 13.4056Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 14C13.1046 14 14 13.1046 14 12C14 10.8954 13.1046 10 12 10C10.8954 10 10 10.8954 10 12C10 13.1046 10.8954 14 12 14Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'eye-slash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17.357 6.643L21 3M17.357 6.643C19.2348 7.84324 20.619 9.45359 21.4504 10.5944C21.7222 10.9674 21.8581 11.1538 21.9516 11.5146C22.0161 11.7633 22.0161 12.2367 21.9516 12.4854C21.8581 12.8462 21.7222 13.0326 21.4504 13.4056C19.961 15.4493 16.6974 19 12 19C9.92469 19 8.12923 18.3069 6.64299 17.357M17.357 6.643L13.4142 10.5858M2.99998 21L6.64299 17.357M6.64299 17.357L10.5858 13.4142M3.86085 15C3.33198 14.4297 2.8935 13.8775 2.54961 13.4056C2.2778 13.0326 2.1419 12.8462 2.04835 12.4854C1.98388 12.2367 1.98388 11.7633 2.04835 11.5146C2.1419 11.1538 2.2778 10.9674 2.54961 10.5944C4.03902 8.55068 7.30262 5 12 5C12.5904 5 13.1582 5.05609 13.7026 5.15824M13.4142 10.5858C13.7761 10.9477 14 11.4477 14 12C14 13.1046 13.1045 14 12 14C11.4477 14 10.9477 13.7761 10.5858 13.4142M13.4142 10.5858L10.5858 13.4142" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'face-id' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11 13.75H12V9.75M16 9.5V8M9 16.5C10.5 18 13.5 18 15 16.5M8 9.5V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.50008 20.8859C6.03745 20.742 5.05293 20.4169 4.3181 19.6821C3.58327 18.9472 3.25813 17.9627 3.11426 16.5001M7.50008 3.11426C6.03745 3.25813 5.05293 3.58327 4.3181 4.3181C3.58327 5.05293 3.25813 6.03745 3.11426 7.50008M16.5001 3.11426C17.9627 3.25813 18.9472 3.58327 19.6821 4.3181C20.4169 5.05293 20.742 6.03745 20.8859 7.50008M16.5001 20.8859C17.9627 20.742 18.9472 20.4169 19.6821 19.6821C20.4169 18.9472 20.742 17.9627 20.8859 16.5001" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fat-arrow-down' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.48325 13.1048C4.05358 13.1048 3.8384 13.6496 4.14222 13.9682L11.659 20.8518C11.8473 21.0494 12.1527 21.0494 12.341 20.8518L19.8578 13.9682C20.1616 13.6496 19.9464 13.1048 19.5167 13.1048H15.6806C15.4142 13.1048 15.1983 12.8783 15.1983 12.5989V3.50582C15.1983 3.22646 14.9824 3 14.716 3L9.28399 3C9.01763 3 8.8017 3.22646 8.8017 3.50582L8.80171 12.5989C8.80171 12.8783 8.58578 13.1048 8.31942 13.1048H4.48325Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fat-arrow-down-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.9318 18.9625C16.247 19.2777 15.8697 19.9891 15.413 20L5.66015 20C5.07907 20 4.78853 20 4.56659 19.8869C4.37136 19.7875 4.21264 19.6287 4.11317 19.4335C4.00008 19.2116 4.00008 18.921 4.00007 18.34L4 8.58702C4.01088 8.13034 4.72234 7.75303 5.03757 8.06826L7.75206 10.8474C7.94747 11.0428 8.27203 11.0351 8.47698 10.8301L15.1482 4.15892C15.3531 3.95397 15.6777 3.94624 15.8731 4.14165L19.8584 8.12688C20.0538 8.32229 20.046 8.64686 19.8411 8.85181L13.1699 15.523C12.9649 15.728 12.9572 16.0525 13.1526 16.2479L15.9318 18.9625Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fat-arrow-down-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.0682 18.9625C7.75297 19.2777 8.13028 19.9891 8.58696 20L18.3398 20C18.9209 20 19.2115 20 19.4334 19.8869C19.6286 19.7875 19.7874 19.6287 19.8868 19.4335C19.9999 19.2116 19.9999 18.921 19.9999 18.34L20 8.58702C19.9891 8.13034 19.2777 7.75303 18.9624 8.06826L16.2479 10.8474C16.0525 11.0428 15.728 11.0351 15.523 10.8301L8.85181 4.15892C8.64686 3.95397 8.32229 3.94624 8.12688 4.14165L4.14165 8.12688C3.94624 8.32229 3.95397 8.64686 4.15892 8.85181L10.8301 15.523C11.0351 15.728 11.0428 16.0525 10.8474 16.2479L8.0682 18.9625Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fat-arrow-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.8952 4.48325C10.8952 4.05358 10.3504 3.8384 10.0318 4.14222L3.14815 11.659C2.95062 11.8473 2.95062 12.1527 3.14815 12.341L10.0318 19.8578C10.3504 20.1616 10.8952 19.9464 10.8952 19.5167V15.6806C10.8952 15.4142 11.1217 15.1983 11.4011 15.1983H20.4942C20.7735 15.1983 21 14.9824 21 14.716V9.28399C21 9.01763 20.7735 8.80171 20.4942 8.80171H11.4011C11.1217 8.80171 10.8952 8.58578 10.8952 8.31942V4.48325Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fat-arrow-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.1048 4.48325C13.1048 4.05358 13.6496 3.8384 13.9682 4.14222L20.8518 11.659C21.0494 11.8473 21.0494 12.1527 20.8518 12.341L13.9682 19.8578C13.6496 20.1616 13.1048 19.9464 13.1048 19.5167V15.6806C13.1048 15.4142 12.8783 15.1983 12.5989 15.1983H3.50582C3.22646 15.1983 3 14.9824 3 14.716V9.28399C3 9.01763 3.22646 8.80171 3.50582 8.80171H12.5989C12.8783 8.80171 13.1048 8.58578 13.1048 8.31942V4.48325Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fat-arrow-up' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.48325 10.8952C4.05358 10.8952 3.8384 10.3504 4.14222 10.0318L11.659 3.14815C11.8473 2.95062 12.1527 2.95062 12.341 3.14815L19.8578 10.0318C20.1616 10.3504 19.9464 10.8952 19.5167 10.8952H15.6806C15.4142 10.8952 15.1983 11.1217 15.1983 11.4011V20.4942C15.1983 20.7735 14.9824 21 14.716 21H9.28399C9.01763 21 8.80171 20.7735 8.80171 20.4942L8.80171 11.4011C8.80171 11.1217 8.58578 10.8952 8.31942 10.8952H4.48325Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fat-arrow-up-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.9318 5.03753C16.247 4.7223 15.8697 4.01091 15.413 4.00003L5.66015 4C5.07907 4 4.78853 4 4.56659 4.11308C4.37136 4.21255 4.21264 4.37128 4.11317 4.5665C4.00008 4.78844 4.00008 5.07898 4.00007 5.66006L4 15.413C4.01088 15.8697 4.72234 16.247 5.03757 15.9318L7.75206 13.1526C7.94747 12.9572 8.27203 12.9649 8.47698 13.1699L15.1482 19.8411C15.3531 20.046 15.6777 20.0538 15.8731 19.8584L19.8584 15.8731C20.0538 15.6777 20.046 15.3532 19.8411 15.1482L13.1699 8.47699C12.9649 8.27204 12.9572 7.94748 13.1526 7.75207L15.9318 5.03753Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fat-arrow-up-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.0682 5.03753C7.75297 4.7223 8.13028 4.01091 8.58696 4.00003L18.3398 4C18.9209 4 19.2115 4 19.4334 4.11308C19.6286 4.21255 19.7874 4.37128 19.8868 4.5665C19.9999 4.78844 19.9999 5.07898 19.9999 5.66006L20 15.413C19.9891 15.8697 19.2777 16.247 18.9624 15.9318L16.2479 13.1526C16.0525 12.9572 15.728 12.9649 15.523 13.1699L8.85181 19.8411C8.64686 20.046 8.32229 20.0538 8.12688 19.8584L4.14165 15.8731C3.94624 15.6777 3.95397 15.3532 4.15892 15.1482L10.8301 8.47699C11.0351 8.27204 11.0428 7.94748 10.8474 7.75207L8.0682 5.03753Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fat-corner-down-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M21 4.07713C18.7981 6.8879 16.8428 8.48287 15.134 8.86202C13.4252 9.24118 11.7983 9.29845 10.2532 9.03388V4L3 12.214L10.2532 20V15.2155C13.11 15.1919 15.5387 14.1201 17.5393 12C19.5399 9.87991 20.6934 7.23896 21 4.07713Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fat-corner-down-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M3 4.07713C5.20189 6.8879 7.15724 8.48287 8.86602 8.86202C10.5748 9.24118 12.2017 9.29845 13.7468 9.03388V4L21 12.214L13.7468 20V15.2155C10.89 15.1919 8.46129 14.1201 6.46072 12C4.46011 9.87991 3.30658 7.23896 3 4.07713Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fat-corner-left-down' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M19.9229 3C17.1121 5.20189 15.5171 7.15724 15.138 8.86602C14.7588 10.5748 14.7016 12.2017 14.9661 13.7468H20L11.786 21L4 13.7468H8.78447C8.80809 10.89 9.87991 8.46129 12 6.46073C14.1201 4.46012 16.761 3.30659 19.9229 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fat-corner-left-up' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M19.9229 21C17.1121 18.7981 15.5171 16.8428 15.138 15.134C14.7588 13.4252 14.7016 11.7983 14.9661 10.2532L20 10.2532L11.786 3L4 10.2532L8.78447 10.2532C8.80809 13.11 9.87991 15.5387 12 17.5393C14.1201 19.5399 16.761 20.6934 19.9229 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fat-corner-right-down' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M4.07713 3C6.88791 5.20189 8.48287 7.15724 8.86202 8.86602C9.24118 10.5748 9.29845 12.2017 9.03388 13.7468H4L12.214 21L20 13.7468H15.2155C15.1919 10.89 14.1201 8.46129 12 6.46073C9.87991 4.46012 7.23896 3.30659 4.07713 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fat-corner-right-up' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M4.07713 21C6.88791 18.7981 8.48287 16.8428 8.86202 15.134C9.24118 13.4252 9.29845 11.7983 9.03388 10.2532L4 10.2532L12.214 3L20 10.2532L15.2155 10.2532C15.1919 13.11 14.1201 15.5387 12 17.5393C9.87991 19.5399 7.23896 20.6934 4.07713 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fat-corner-up-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M21 19.9229C18.7981 17.1121 16.8428 15.5171 15.134 15.138C13.4252 14.7588 11.7983 14.7016 10.2532 14.9661V20L3 11.786L10.2532 4V8.78447C13.11 8.80809 15.5387 9.87991 17.5393 12C19.5399 14.1201 20.6934 16.761 21 19.9229Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fat-corner-up-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M3 19.9229C5.20189 17.1121 7.15724 15.5171 8.86602 15.138C10.5748 14.7588 12.2017 14.7016 13.7468 14.9661V20L21 11.786L13.7468 4V8.78447C10.89 8.80809 8.46129 9.87991 6.46072 12C4.46011 14.1201 3.30658 16.761 3 19.9229Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'female' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 15C15.3137 15 18 12.3137 18 9C18 5.68629 15.3137 3 12 3C8.68629 3 6 5.68629 6 9C6 12.3137 8.68629 15 12 15ZM12 15V21M10 19H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'file' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.72796 3H7.5C6.25736 3 5.25 4.00736 5.25 5.25V18.75C5.25 19.9926 6.25736 21 7.5 21H16.5C17.7426 21 18.75 19.9926 18.75 18.75V12M9.72796 3C10.9706 3 12 4.00736 12 5.25V7.5C12 8.74264 13.0074 9.75 14.25 9.75H16.5C17.7426 9.75 18.75 10.7574 18.75 12M9.72796 3C13.4179 3 18.75 8.3597 18.75 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'file-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.72796 3H7.5C6.25736 3 5.25 4.00736 5.25 5.25V18.75C5.25 19.9926 6.25736 21 7.5 21H16.5C17.7426 21 18.75 19.9926 18.75 18.75V12M9.72796 3C10.9706 3 12 4.00736 12 5.25V7.5C12 8.74264 13.0074 9.75 14.25 9.75H16.5C17.7426 9.75 18.75 10.7574 18.75 12M9.72796 3C13.4179 3 18.75 8.3597 18.75 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 16.2418L11.0388 17.4235C11.1341 17.5319 11.3058 17.5239 11.3905 17.4072L13.5 14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'file-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 16H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.72796 3H7.5C6.25736 3 5.25 4.00736 5.25 5.25V18.75C5.25 19.9926 6.25736 21 7.5 21H16.5C17.7426 21 18.75 19.9926 18.75 18.75V12M9.72796 3C10.9706 3 12 4.00736 12 5.25V7.5C12 8.74264 13.0074 9.75 14.25 9.75H16.5C17.7426 9.75 18.75 10.7574 18.75 12M9.72796 3C13.4179 3 18.75 8.3597 18.75 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'file-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 15.5H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 13.5L12 17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.72796 3H7.5C6.25736 3 5.25 4.00736 5.25 5.25V18.75C5.25 19.9926 6.25736 21 7.5 21H16.5C17.7426 21 18.75 19.9926 18.75 18.75V12M9.72796 3C10.9706 3 12 4.00736 12 5.25V7.5C12 8.74264 13.0074 9.75 14.25 9.75H16.5C17.7426 9.75 18.75 10.7574 18.75 12M9.72796 3C13.4179 3 18.75 8.3597 18.75 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'file-text' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.47796 3H7.25C6.00736 3 5 4.00736 5 5.25V18.75C5 19.9926 6.00736 21 7.25 21H16.25C17.4926 21 18.5 19.9926 18.5 18.75V12M9.47796 3C10.7206 3 11.75 4.00736 11.75 5.25V7.5C11.75 8.74264 12.7574 9.75 14 9.75H16.25C17.4926 9.75 18.5 10.7574 18.5 12M9.47796 3C13.1679 3 18.5 8.3597 18.5 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 16.5H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 13.5H13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'file-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.5 14.5L13.3284 17.3284" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.3284 14.5L10.5 17.3284" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.72796 3H7.5C6.25736 3 5.25 4.00736 5.25 5.25V18.75C5.25 19.9926 6.25736 21 7.5 21H16.5C17.7426 21 18.75 19.9926 18.75 18.75V12M9.72796 3C10.9706 3 12 4.00736 12 5.25V7.5C12 8.74264 13.0074 9.75 14.25 9.75H16.5C17.7426 9.75 18.75 10.7574 18.75 12M9.72796 3C13.4179 3 18.75 8.3597 18.75 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'film' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.40088 3.46802V20.532" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.4009 3.46802V20.532" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.40084 7.4729H3.48584" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.40086 12H3.02686" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.40113 16.4729H3.43213" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.9008 7.4729H16.9858" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.9009 12H16.5269" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.4728 12H6.57275" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.9011 16.4729H16.9321" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'filter' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.5 7H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7 12H17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 17H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'filter-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.046 17.6763V13.7583C10.046 13.2035 10.046 12.9261 9.99596 12.6588C9.95155 12.4216 9.878 12.1908 9.77699 11.9716C9.66317 11.7246 9.50269 11.4983 9.18174 11.0458L5.93453 6.4672C5.36882 5.66954 5.08596 5.27071 5.09907 4.93838C5.11048 4.64902 5.24968 4.37964 5.4791 4.20294C5.7426 4 6.23155 4 7.20945 4H16.7901C17.768 4 18.2569 4 18.5204 4.20294C18.7498 4.37964 18.889 4.64902 18.9004 4.93838C18.9135 5.27071 18.6307 5.66954 18.065 6.4672L14.8178 11.0458C14.4968 11.4983 14.3363 11.7246 14.2225 11.9716C14.1215 12.1908 14.048 12.4216 14.0035 12.6588C13.9535 12.9261 13.9535 13.2035 13.9535 13.7583V19.63M10.046 17.6763C11.7002 16.9443 13.9535 17.3804 13.9535 19.63M10.046 17.6763C10.0132 19.9109 12.3079 20.4675 13.9535 19.63" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'filter-tune' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 8.5L21 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 8.5C3 9.60457 3.89543 10.5 5 10.5C6.10457 10.5 7 9.60457 7 8.5C7 7.39543 6.10457 6.5 5 6.5C3.89543 6.5 3 7.39543 3 8.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 15.5H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17 15.5C17 16.6046 17.8954 17.5 19 17.5C20.1046 17.5 21 16.6046 21 15.5C21 14.3954 20.1046 13.5 19 13.5C17.8954 13.5 17 14.3954 17 15.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'fire' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19.2703 16.2024C18.0927 19.0199 15.3079 21 12.0599 21C7.74661 21 4.25 17.5078 4.25 13.2C4.25 8.89218 5.89054 7.13076 8.45533 3C13.2614 5.09993 13.2614 11.4 13.2614 11.4C13.2614 11.4 14.8399 8.36201 18.0675 6.9C19.1024 9.94186 20.4978 13.2652 19.2703 16.2024Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 18C9.23858 18 7 15.7614 7 13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'five' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.375 7C11.875 7.625 8.75 7 8.75 7V10.5656L12.2226 10.5656C13.7567 10.5656 15 11.63 15 12.9428V14.342C15 17.8644 8.75 17.9076 8.75 14.342" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'five-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 8C12 8.5 9.5 8 9.5 8V10.8525L12.278 10.8525C13.5054 10.8525 14.5 11.704 14.5 12.7543V13.8736C14.5 16.6915 9.5 16.7261 9.5 13.8736" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'five-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 8C12 8.5 9.5 8 9.5 8V10.8525L12.278 10.8525C13.5054 10.8525 14.5 11.704 14.5 12.7543V13.8736C14.5 16.6915 9.5 16.7261 9.5 13.8736" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'five-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 8C12 8.5 9.5 8 9.5 8V10.8525L12.278 10.8525C13.5054 10.8525 14.5 11.704 14.5 12.7543V13.8736C14.5 16.6915 9.5 16.7261 9.5 13.8736" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'five-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 8C12 8.5 9.5 8 9.5 8V10.8525L12.278 10.8525C13.5054 10.8525 14.5 11.704 14.5 12.7543V13.8736C14.5 16.6915 9.5 16.7261 9.5 13.8736" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'five-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 8C12 8.5 9.5 8 9.5 8V10.8525L12.278 10.8525C13.5054 10.8525 14.5 11.704 14.5 12.7543V13.8736C14.5 16.6915 9.5 16.7261 9.5 13.8736" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'five-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 8C12 8.5 9.5 8 9.5 8V10.8525L12.278 10.8525C13.5054 10.8525 14.5 11.704 14.5 12.7543V13.8736C14.5 16.6915 9.5 16.7261 9.5 13.8736" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'flag' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4 21V15.6871M4 15.6871C9.81818 11.1377 14.1818 20.2363 20 15.6869V4.31347C14.1818 8.86284 9.81818 -0.236103 4 4.31327V15.6871Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'flag-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.75 14L18.53 9.95937C19.49 9.67786 19.49 8.32214 18.53 8.04063L4.75 4M4.75 14V4M4.75 14V21M4.75 4V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'flask' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.89417 3.5V11.5L6.23481 15.4649C5.30208 16.7304 3.43947 18.7409 5.28645 20.0868C5.85354 20.5 6.90072 20.5 8.99508 20.5H15.0049C17.0993 20.5 18.1465 20.5 18.7136 20.0868C20.5605 18.7409 18.6979 16.7304 17.7652 15.4649L14.1058 11.5V3.5M9.89417 3.5H14.1058M9.89417 3.5H8.84125M14.1058 3.5H15.1588" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'folder' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 6C3 4.89543 3.89543 4 5 4H6.74477C7.23147 4 7.70148 4.17748 8.06671 4.49917L10.3392 6.50083C10.7045 6.82252 11.1745 7 11.6612 7H18.9999C20.1045 7 20.9999 7.89543 20.9999 9V18C20.9999 19.1046 20.1045 20 18.9999 20H5C3.89543 20 3 19.1046 3 18V6Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'folder-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 6C3 4.89543 3.89543 4 5 4H6.74477C7.23147 4 7.70148 4.17748 8.06671 4.49917L10.3392 6.50083C10.7045 6.82252 11.1745 7 11.6612 7H18.9999C20.1045 7 20.9999 7.89543 20.9999 9V18C20.9999 19.1046 20.1045 20 18.9999 20H5C3.89543 20 3 19.1046 3 18V6Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.2583 13.2418L11.2923 14.4235C11.3871 14.5319 11.5581 14.5239 11.6424 14.4072L13.742 11.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'folder-heart' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 6C3 4.89543 3.89543 4 5 4H6.74477C7.23147 4 7.70148 4.17748 8.06671 4.49917L10.3392 6.50083C10.7045 6.82252 11.1745 7 11.6612 7H18.9999C20.1045 7 20.9999 7.89543 20.9999 9V18C20.9999 19.1046 20.1045 20 18.9999 20H5C3.89543 20 3 19.1046 3 18V6Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.61914 12.024C8.61914 13.9961 11.9999 16.25 11.9999 16.25C11.9999 16.25 15.3808 13.9961 15.3808 12.024C15.3808 10.1447 12.8294 9.5696 11.9999 11.2263C11.1863 9.60118 8.61914 10.1727 8.61914 12.024Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'folder-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 6C3 4.89543 3.89543 4 5 4H6.74477C7.23147 4 7.70148 4.17748 8.06671 4.49917L10.3392 6.50083C10.7045 6.82252 11.1745 7 11.6612 7H18.9999C20.1045 7 20.9999 7.89543 20.9999 9V18C20.9999 19.1046 20.1045 20 18.9999 20H5C3.89543 20 3 19.1046 3 18V6Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 13H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'folder-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.6612 7H18.9999C20.1045 7 20.9999 7.89543 20.9999 9V18C20.9999 19.1046 20.1045 20 18.9999 20H5C3.89543 20 3 19.1046 3 18V7M11.6612 7C11.1745 7 10.7045 6.82252 10.3392 6.50083L8.06671 4.49917C7.70148 4.17748 7.23147 4 6.74477 4H5C3.89543 4 3 4.89543 3 6V7M11.6612 7H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'folder-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 6C3 4.89543 3.89543 4 5 4H6.74477C7.23147 4 7.70148 4.17748 8.06671 4.49917L10.3392 6.50083C10.7045 6.82252 11.1745 7 11.6612 7H18.9999C20.1045 7 20.9999 7.89543 20.9999 9V18C20.9999 19.1046 20.1045 20 18.9999 20H5C3.89543 20 3 19.1046 3 18V6Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 13.25H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 11.25L12 15.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'folder-slash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 21L4.17677 19.8232M21 3L17 7.00001M17 7.00001H19C20.1046 7.00001 21 7.89544 21 9.00001V18C21 19.1046 20.1046 20 19 20H5.00006C4.70657 20 4.42785 19.9368 4.17677 19.8232M17 7.00001L4.17677 19.8232M3 16.5L3.00006 6.00001C3.00006 4.89544 3.89549 4.00001 5.00006 4.00001H6.74483C7.23154 4.00001 7.70154 4.17748 8.06677 4.49918L10.3393 6.50083C10.7045 6.82253 11.1745 7.00001 11.6612 7.00001H13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'folder-two' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18.9999 7H11.6612C11.1745 7 10.7045 6.82252 10.3392 6.50083L8.06671 4.49917M18.9999 7C20.1045 7 20.9999 7.89543 20.9999 9V18C20.9999 19.1046 20.1045 20 18.9999 20H5C3.89543 20 3 19.1046 3 18V6C3 4.89543 3.89543 4 5 4H6.74477C7.23147 4 7.70148 4.17748 8.06671 4.49917M18.9999 7C18.9999 5.61883 17.8803 4.49917 16.4991 4.49917H8.06671" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'folder-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 6C3 4.89543 3.89543 4 5 4H6.74477C7.23147 4 7.70148 4.17748 8.06671 4.49917L10.3392 6.50083C10.7045 6.82252 11.1745 7 11.6612 7H18.9999C20.1045 7 20.9999 7.89543 20.9999 9V18C20.9999 19.1046 20.1045 20 18.9999 20H5C3.89543 20 3 19.1046 3 18V6Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.5 12L13.3284 14.8284" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.3284 12L10.5 14.8284" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'forward' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.98451 9.41851C11.3282 10.5146 12 11.0626 12 12C12 12.9374 11.3282 13.4854 9.98451 14.5815C9.61359 14.8841 9.2457 15.169 8.90764 15.4064C8.61106 15.6146 8.27517 15.83 7.92742 16.0415C6.58691 16.8567 5.91666 17.2643 5.31552 16.813C4.71438 16.3617 4.65974 15.4171 4.55048 13.5277C4.51958 12.9934 4.5 12.4696 4.5 12C4.5 11.5304 4.51958 11.0066 4.55048 10.4723C4.65974 8.58294 4.71438 7.63826 5.31552 7.187C5.91666 6.73574 6.58691 7.14332 7.92742 7.95849C8.27517 8.16996 8.61106 8.38539 8.90764 8.59365C9.2457 8.83104 9.61359 9.11592 9.98451 9.41851Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17.4845 9.41851C18.8282 10.5146 19.5 11.0626 19.5 12C19.5 12.9374 18.8282 13.4854 17.4845 14.5815C17.1136 14.8841 16.7457 15.169 16.4076 15.4064C16.1111 15.6146 15.7752 15.83 15.4274 16.0415C14.0869 16.8567 13.4167 17.2643 12.8155 16.813C12.2144 16.3617 12.1597 15.4171 12.0505 13.5277C12.0196 12.9934 12 12.4696 12 12C12 11.5304 12.0196 11.0066 12.0505 10.4723C12.1597 8.58294 12.2144 7.63826 12.8155 7.187C13.4167 6.73574 14.0869 7.14332 15.4274 7.95849C15.7752 8.16996 16.1111 8.38539 16.4076 8.59365C16.7457 8.83104 17.1136 9.11592 17.4845 9.41851Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'forward-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.2423 10.7093C10.9141 11.2573 11.25 11.5313 11.25 12C11.25 12.4687 10.9141 12.7427 10.2423 13.2907C10.0568 13.442 9.87285 13.5845 9.70382 13.7032C9.55553 13.8073 9.38759 13.915 9.21371 14.0208C8.54346 14.4283 8.20833 14.6321 7.90776 14.4065C7.60719 14.1809 7.57987 13.7085 7.52524 12.7638C7.50979 12.4967 7.5 12.2348 7.5 12C7.5 11.7652 7.50979 11.5033 7.52524 11.2362C7.57987 10.2915 7.60719 9.81913 7.90776 9.5935C8.20833 9.36787 8.54346 9.57166 9.21371 9.97924C9.38759 10.085 9.55553 10.1927 9.70382 10.2968C9.87285 10.4155 10.0568 10.558 10.2423 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.9923 10.7093C16.6641 11.2573 17 11.5313 17 12C17 12.4687 16.6641 12.7427 15.9923 13.2907C15.8068 13.442 15.6229 13.5845 15.4538 13.7032C15.3055 13.8073 15.1376 13.915 14.9637 14.0208C14.2935 14.4283 13.9583 14.6321 13.6578 14.4065C13.3572 14.1809 13.3299 13.7085 13.2752 12.7638C13.2598 12.4967 13.25 12.2348 13.25 12C13.25 11.7652 13.2598 11.5033 13.2752 11.2362C13.3299 10.2915 13.3572 9.81913 13.6578 9.5935C13.9583 9.36787 14.2935 9.57166 14.9637 9.97924C15.1376 10.085 15.3055 10.1927 15.4538 10.2968C15.6229 10.4155 15.8068 10.558 15.9923 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'forward-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.2423 10.7093C10.9141 11.2573 11.25 11.5313 11.25 12C11.25 12.4687 10.9141 12.7427 10.2423 13.2907C10.0568 13.442 9.87285 13.5845 9.70382 13.7032C9.55553 13.8073 9.38759 13.915 9.21371 14.0208C8.54346 14.4283 8.20833 14.6321 7.90776 14.4065C7.60719 14.1809 7.57987 13.7085 7.52524 12.7638C7.50979 12.4967 7.5 12.2348 7.5 12C7.5 11.7652 7.50979 11.5033 7.52524 11.2362C7.57987 10.2915 7.60719 9.81913 7.90776 9.5935C8.20833 9.36787 8.54346 9.57166 9.21371 9.97924C9.38759 10.085 9.55553 10.1927 9.70382 10.2968C9.87285 10.4155 10.0568 10.558 10.2423 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.9923 10.7093C16.6641 11.2573 17 11.5313 17 12C17 12.4687 16.6641 12.7427 15.9923 13.2907C15.8068 13.442 15.6229 13.5845 15.4538 13.7032C15.3055 13.8073 15.1376 13.915 14.9637 14.0208C14.2935 14.4283 13.9583 14.6321 13.6578 14.4065C13.3572 14.1809 13.3299 13.7085 13.2752 12.7638C13.2598 12.4967 13.25 12.2348 13.25 12C13.25 11.7652 13.2598 11.5033 13.2752 11.2362C13.3299 10.2915 13.3572 9.81913 13.6578 9.5935C13.9583 9.36787 14.2935 9.57166 14.9637 9.97924C15.1376 10.085 15.3055 10.1927 15.4538 10.2968C15.6229 10.4155 15.8068 10.558 15.9923 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'forward-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.2423 10.7093C10.9141 11.2573 11.25 11.5313 11.25 12C11.25 12.4687 10.9141 12.7427 10.2423 13.2907C10.0568 13.442 9.87285 13.5845 9.70382 13.7032C9.55553 13.8073 9.38759 13.915 9.21371 14.0208C8.54346 14.4283 8.20833 14.6321 7.90776 14.4065C7.60719 14.1809 7.57987 13.7085 7.52524 12.7638C7.50979 12.4967 7.5 12.2348 7.5 12C7.5 11.7652 7.50979 11.5033 7.52524 11.2362C7.57987 10.2915 7.60719 9.81913 7.90776 9.5935C8.20833 9.36787 8.54346 9.57166 9.21371 9.97924C9.38759 10.085 9.55553 10.1927 9.70382 10.2968C9.87285 10.4155 10.0568 10.558 10.2423 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.9923 10.7093C16.6641 11.2573 17 11.5313 17 12C17 12.4687 16.6641 12.7427 15.9923 13.2907C15.8068 13.442 15.6229 13.5845 15.4538 13.7032C15.3055 13.8073 15.1376 13.915 14.9637 14.0208C14.2935 14.4283 13.9583 14.6321 13.6578 14.4065C13.3572 14.1809 13.3299 13.7085 13.2752 12.7638C13.2598 12.4967 13.25 12.2348 13.25 12C13.25 11.7652 13.2598 11.5033 13.2752 11.2362C13.3299 10.2915 13.3572 9.81913 13.6578 9.5935C13.9583 9.36787 14.2935 9.57166 14.9637 9.97924C15.1376 10.085 15.3055 10.1927 15.4538 10.2968C15.6229 10.4155 15.8068 10.558 15.9923 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'forward-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.2423 10.7093C10.9141 11.2573 11.25 11.5313 11.25 12C11.25 12.4687 10.9141 12.7427 10.2423 13.2907C10.0568 13.442 9.87285 13.5845 9.70382 13.7032C9.55553 13.8073 9.38759 13.915 9.21371 14.0208C8.54346 14.4283 8.20833 14.6321 7.90776 14.4065C7.60719 14.1809 7.57987 13.7085 7.52524 12.7638C7.50979 12.4967 7.5 12.2348 7.5 12C7.5 11.7652 7.50979 11.5033 7.52524 11.2362C7.57987 10.2915 7.60719 9.81913 7.90776 9.5935C8.20833 9.36787 8.54346 9.57166 9.21371 9.97924C9.38759 10.085 9.55553 10.1927 9.70382 10.2968C9.87285 10.4155 10.0568 10.558 10.2423 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.9923 10.7093C16.6641 11.2573 17 11.5313 17 12C17 12.4687 16.6641 12.7427 15.9923 13.2907C15.8068 13.442 15.6229 13.5845 15.4538 13.7032C15.3055 13.8073 15.1376 13.915 14.9637 14.0208C14.2935 14.4283 13.9583 14.6321 13.6578 14.4065C13.3572 14.1809 13.3299 13.7085 13.2752 12.7638C13.2598 12.4967 13.25 12.2348 13.25 12C13.25 11.7652 13.2598 11.5033 13.2752 11.2362C13.3299 10.2915 13.3572 9.81913 13.6578 9.5935C13.9583 9.36787 14.2935 9.57166 14.9637 9.97924C15.1376 10.085 15.3055 10.1927 15.4538 10.2968C15.6229 10.4155 15.8068 10.558 15.9923 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'forward-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.2423 10.7093C10.9141 11.2573 11.25 11.5313 11.25 12C11.25 12.4687 10.9141 12.7427 10.2423 13.2907C10.0568 13.442 9.87285 13.5845 9.70382 13.7032C9.55553 13.8073 9.38759 13.915 9.21371 14.0208C8.54346 14.4283 8.20833 14.6321 7.90776 14.4065C7.60719 14.1809 7.57987 13.7085 7.52524 12.7638C7.50979 12.4967 7.5 12.2348 7.5 12C7.5 11.7652 7.50979 11.5033 7.52524 11.2362C7.57987 10.2915 7.60719 9.81913 7.90776 9.5935C8.20833 9.36787 8.54346 9.57166 9.21371 9.97924C9.38759 10.085 9.55553 10.1927 9.70382 10.2968C9.87285 10.4155 10.0568 10.558 10.2423 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.9923 10.7093C16.6641 11.2573 17 11.5313 17 12C17 12.4687 16.6641 12.7427 15.9923 13.2907C15.8068 13.442 15.6229 13.5845 15.4538 13.7032C15.3055 13.8073 15.1376 13.915 14.9637 14.0208C14.2935 14.4283 13.9583 14.6321 13.6578 14.4065C13.3572 14.1809 13.3299 13.7085 13.2752 12.7638C13.2598 12.4967 13.25 12.2348 13.25 12C13.25 11.7652 13.2598 11.5033 13.2752 11.2362C13.3299 10.2915 13.3572 9.81913 13.6578 9.5935C13.9583 9.36787 14.2935 9.57166 14.9637 9.97924C15.1376 10.085 15.3055 10.1927 15.4538 10.2968C15.6229 10.4155 15.8068 10.558 15.9923 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'four' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.9167 7C11.875 10.75 8.75 13.875 8.75 13.875H15M13.4375 17V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'four-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5833 8C11.75 11 9.25 13.5 9.25 13.5H14.25M13 16V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'four-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.5833 8C11.75 11 9.25 13.5 9.25 13.5H14.25M13 16V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'four-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.5833 8C11.75 11 9.25 13.5 9.25 13.5H14.25M13 16V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'four-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.5833 8C11.75 11 9.25 13.5 9.25 13.5H14.25M13 16V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'four-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5833 8C11.75 11 9.25 13.5 9.25 13.5H14.25M13 16V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'four-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5833 8C11.75 11 9.25 13.5 9.25 13.5H14.25M13 16V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'frame' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 6.6H3M21 17.4H3M6.6 3V21M17.4 3V21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'funny-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.69868 10.6456L8.59473 10.1565" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.5893 9.60602L13.4854 9.11694" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.5 15.5706C9.75834 15.8859 11.186 15.8861 12.6225 15.5012C14.0591 15.1163 15.2953 14.4023 16.2274 13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5879 15.6374L13.0659 16.6112C13.4272 17.3473 14.3128 17.6568 15.054 17.3059C15.8102 16.9479 16.1273 16.0405 15.7587 15.2894L15.2994 14.3538" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'funny-ghost' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.69868 10.6456L8.59473 10.1565" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.5893 9.60602L13.4854 9.11694" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.5 15.5706C9.75834 15.8859 11.186 15.8861 12.6225 15.5012C14.0591 15.1163 15.2953 14.4023 16.2274 13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5879 15.6374L13.0659 16.6112C13.4272 17.3473 14.3128 17.6568 15.054 17.3059C15.8102 16.9479 16.1273 16.0405 15.7587 15.2894L15.2994 14.3538" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 18.5615V12.0443C3 7.04928 7.02944 3 12 3C16.9706 3 21 7.04928 21 12.0443V18.5615C21 19.7226 20.0334 21.08 19 20.5608C18.1647 20.1411 16.777 20.0402 16 20.5608C15.1259 21.1464 13.8741 21.1464 13 20.5608C12.1148 19.9678 11.3511 19.9906 10.5 20.5608C9.6259 21.1464 8.3741 21.1464 7.5 20.5608C6.723 20.0402 5.83525 20.1411 5 20.5608C3.9666 21.08 3 19.7226 3 18.5615Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'funny-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.69868 10.6456L8.59473 10.1565" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.5893 9.60602L13.4854 9.11694" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.5 15.5706C9.75834 15.8859 11.186 15.8861 12.6225 15.5012C14.0591 15.1163 15.2953 14.4023 16.2274 13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5879 15.6374L13.0659 16.6112C13.4272 17.3473 14.3128 17.6568 15.054 17.3059C15.8102 16.9479 16.1273 16.0405 15.7587 15.2894L15.2994 14.3538" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'gift' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 21V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.0003 7H7.95031C5.18011 7 5.01053 3 7.95031 3C11.1003 3 12.0003 7 12.0003 7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 7H16.05C18.9459 7 18.9459 3 16.05 3C12.9 3 12 7 12 7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20 12V19C20 20.1046 19.1046 21 18 21H6C4.89543 21 4 20.1046 4 19V12M21 12V9C21 7.89543 20.1046 7 19 7H5C3.89543 7 3 7.89543 3 9V12H21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'git-branch' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6 15C7.65685 15 9 16.3431 9 18C9 19.6569 7.65685 21 6 21C4.34315 21 3 19.6569 3 18C3 16.3431 4.34315 15 6 15Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18 9C16.3431 9 15 7.65685 15 6C15 4.34315 16.3431 3 18 3C19.6569 3 21 4.34315 21 6C21 7.65685 19.6569 9 18 9ZM18 9C18 13.9706 13.9706 18 9 18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 15L6 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'git-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 12C14 13.1046 13.1046 14 12 14C10.8954 14 10 13.1046 10 12M14 12C14 10.8954 13.1046 10 12 10C10.8954 10 10 10.8954 10 12M14 12H17M10 12H7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'git-commit' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 15C13.6569 15 15 13.6569 15 12C15 10.3431 13.6569 9 12 9C10.3431 9 9 10.3431 9 12C9 13.6569 10.3431 15 12 15Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12H9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 12H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'git-diff' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 21C19.6569 21 21 19.6569 21 18C21 16.3431 19.6569 15 18 15C16.3431 15 15 16.3431 15 18C15 19.6569 16.3431 21 18 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18 15L18 7.5C18 6.39543 17.1046 5.5 16 5.5H13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 8L12 5.5L14.5 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 3C4.34315 3 3 4.34315 3 6C3 7.65685 4.34315 9 6 9C7.65685 9 9 7.65685 9 6C9 4.34315 7.65685 3 6 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 9L6 16.5C6 17.6046 6.89543 18.5 8 18.5H10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 16L12 18.5L9.5 21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'git-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 12C14 13.1046 13.1046 14 12 14C10.8954 14 10 13.1046 10 12M14 12C14 10.8954 13.1046 10 12 10C10.8954 10 10 10.8954 10 12M14 12H17M10 12H7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'git-merge' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6 9C7.65685 9 9 7.65685 9 6C9 4.34315 7.65685 3 6 3C4.34315 3 3 4.34315 3 6C3 7.65685 4.34315 9 6 9Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 18C15 19.6569 16.3431 21 18 21C19.6569 21 21 19.6569 21 18C21 16.3431 19.6569 15 18 15C16.3431 15 15 16.3431 15 18ZM15 18C10.0294 18 6 13.9706 6 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 9L6 21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'git-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 12C14 13.1046 13.1046 14 12 14C10.8954 14 10 13.1046 10 12M14 12C14 10.8954 13.1046 10 12 10C10.8954 10 10 10.8954 10 12M14 12H17M10 12H7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'git-pull-request' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6 9C7.65685 9 9 7.65685 9 6C9 4.34315 7.65685 3 6 3C4.34315 3 3 4.34315 3 6C3 7.65685 4.34315 9 6 9Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18 21C19.6569 21 21 19.6569 21 18C21 16.3431 19.6569 15 18 15C16.3431 15 15 16.3431 15 18C15 19.6569 16.3431 21 18 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 9V21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18 15L18 7.5C18 6.39543 17.1046 5.5 16 5.5L13.5 5.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 8L12 5.5L14.5 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'git-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 12C14 13.1046 13.1046 14 12 14C10.8954 14 10 13.1046 10 12M14 12C14 10.8954 13.1046 10 12 10C10.8954 10 10 10.8954 10 12M14 12H17M10 12H7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'git-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 12C14 13.1046 13.1046 14 12 14C10.8954 14 10 13.1046 10 12M14 12C14 10.8954 13.1046 10 12 10C10.8954 10 10 10.8954 10 12M14 12H17M10 12H7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'globe' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 21C16.9706 21 21 16.9706 21 12C21 7.02944 16.9706 3 12 3M12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3M12 21C14.7614 21 15.9413 15.837 15.9413 12C15.9413 8.16303 14.7614 3 12 3M12 21C9.23858 21 8.05895 15.8369 8.05895 12C8.05895 8.16307 9.23858 3 12 3M3.49988 8.99998C10.1388 8.99998 13.861 8.99998 20.4999 8.99998M3.49988 15C10.1388 15 13.861 15 20.4999 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'grid' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 6.75C3 4.98223 3 4.09835 3.54917 3.54917C4.09835 3 4.98223 3 6.75 3C8.51777 3 9.40165 3 9.95083 3.54917C10.5 4.09835 10.5 4.98223 10.5 6.75C10.5 8.51777 10.5 9.40165 9.95083 9.95083C9.40165 10.5 8.51777 10.5 6.75 10.5C4.98223 10.5 4.09835 10.5 3.54917 9.95083C3 9.40165 3 8.51777 3 6.75Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 17.2571C3 15.4893 3 14.6054 3.54917 14.0563C4.09835 13.5071 4.98223 13.5071 6.75 13.5071C8.51777 13.5071 9.40165 13.5071 9.95083 14.0563C10.5 14.6054 10.5 15.4893 10.5 17.2571C10.5 19.0248 10.5 19.9087 9.95083 20.4579C9.40165 21.0071 8.51777 21.0071 6.75 21.0071C4.98223 21.0071 4.09835 21.0071 3.54917 20.4579C3 19.9087 3 19.0248 3 17.2571Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.5 6.75C13.5 4.98223 13.5 4.09835 14.0492 3.54917C14.5983 3 15.4822 3 17.25 3C19.0178 3 19.9017 3 20.4508 3.54917C21 4.09835 21 4.98223 21 6.75C21 8.51777 21 9.40165 20.4508 9.95083C19.9017 10.5 19.0178 10.5 17.25 10.5C15.4822 10.5 14.5983 10.5 14.0492 9.95083C13.5 9.40165 13.5 8.51777 13.5 6.75Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.5 17.2571C13.5 15.4893 13.5 14.6054 14.0492 14.0563C14.5983 13.5071 15.4822 13.5071 17.25 13.5071C19.0178 13.5071 19.9017 13.5071 20.4508 14.0563C21 14.6054 21 15.4893 21 17.2571C21 19.0248 21 19.9087 20.4508 20.4579C19.9017 21.0071 19.0178 21.0071 17.25 21.0071C15.4822 21.0071 14.5983 21.0071 14.0492 20.4579C13.5 19.9087 13.5 19.0248 13.5 17.2571Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'grid-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.90625 3.02893V20.9711M15.0938 3.02893V20.9711M3.02893 15.0938H20.9711M3.02893 8.90625H20.9711M12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'hard-drive' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.25 13C9.08333 13 14.9167 13 20.75 13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.45 4.11L3.28752 11.9567C3.09671 12.6491 3 13.364 3 14.0822V19C3 19.5304 3.21071 20.0391 3.58579 20.4142C3.96086 20.7893 4.46957 21 5 21H19C19.5304 21 20.0391 20.7893 20.4142 20.4142C20.7893 20.0391 21 19.5304 21 19V14.0822C21 13.364 20.9033 12.6491 20.7125 11.9567L18.55 4.11C18.3844 3.77679 18.1292 3.49637 17.813 3.30028C17.4967 3.10419 17.1321 3.0002 16.76 3H7.24C6.86792 3.0002 6.50326 3.10419 6.18704 3.30028C5.87083 3.49637 5.61558 3.77679 5.45 4.11Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17 17H18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13 17H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'hash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.69712 4L6.67822 21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17.0541 4L14.0352 21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 8.78125H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 16.2188H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'hash-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.9045 8L9.46826 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.4045 8L12.9683 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.2819 10.25H7.71826" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.2819 13.75H7.71826" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'hash-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.9045 8L9.46826 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.4045 8L12.9683 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.2819 10.25H7.71826" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.2819 13.75H7.71826" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'hash-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.9045 8L9.46826 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.4045 8L12.9683 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.2819 10.25H7.71826" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.2819 13.75H7.71826" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'hash-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.9045 8L9.46826 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.4045 8L12.9683 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.2819 10.25H7.71826" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.2819 13.75H7.71826" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'hash-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.9045 8L9.46826 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.4045 8L12.9683 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.2819 10.25H7.71826" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.2819 13.75H7.71826" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'heading' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.25 4.5V19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.75 4.5V19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.25 12H16.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'heading-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.75 4.5V19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.25 4.5V19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.75 12H13.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17.2383 11.4917L19.6253 9V19.4917" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'heading-three' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.75 4.5V19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.25 4.5V19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.75 12H13.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 9.5H21L17.5 14C19.5 14 21 15 21 17C21 19.7393 17.5915 20.2006 16 18.45" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'heading-two' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16 11.9194C16 8.69355 21 8.69354 21 11.9194C21 14.7694 16 16.886 16 19.4194H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.75 4.5V19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.25 4.5V19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.75 12H13.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'headphones' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 17V12C21 7.02944 16.9706 3 12 3C7.02944 3 3 7.02944 3 12V17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 14.9578C16 14.447 16 14.1915 16.0586 13.9887C16.1942 13.5196 16.5482 13.1637 16.9888 13.0537C18.2613 12.7358 18.5191 13.9185 19.4319 14.2857C19.4549 14.295 19.478 14.3045 19.501 14.3141C20.4931 14.7309 20.9985 15.7924 20.996 16.8684L20.9951 17.2245C20.9929 18.1751 20.4868 19.06 19.6426 19.4968C18.7043 19.9822 18.3913 21.2489 17.0278 20.9568C16.591 20.8632 16.2308 20.5284 16.0777 20.0737C16 19.843 16 19.5414 16 18.9381V14.9578Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.9999 19.0422C7.9999 19.553 7.9999 19.8085 7.94127 20.0113C7.8057 20.4804 7.45171 20.8363 7.01108 20.9463C5.73862 21.2642 5.48083 20.0815 4.56799 19.7143C4.54739 19.706 4.52677 19.6975 4.50613 19.6889C3.50793 19.2714 3.0014 18.2082 3.00392 17.132L3.00477 16.768C3.00698 15.8216 3.51261 14.9402 4.35734 14.5032C5.2956 14.0178 5.60856 12.7511 6.97205 13.0432C7.40887 13.1368 7.7691 13.4716 7.9222 13.9263C7.9999 14.157 7.9999 14.4586 7.9999 15.0619V19.0422Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'heart' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.75 3.5C5.12665 3.5 3 5.75956 3 8.54688C3 14.125 12 20.5 12 20.5C12 20.5 21 14.125 21 8.54688C21 5.09375 18.8734 3.5 16.25 3.5C14.39 3.5 12.7796 4.63593 12 6.2905C11.2204 4.63593 9.61003 3.5 7.75 3.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'heart-broken' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.75 3.5C5.12665 3.5 3 5.75956 3 8.54688C3 14.125 12 20.5 12 20.5C12 20.5 21 14.125 21 8.54688C21 5.09375 18.8734 3.5 16.25 3.5C14.39 3.5 12.7796 4.63593 12 6.2905C11.2204 4.63593 9.61003 3.5 7.75 3.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.1499 6L10.1499 9.99995L14.1499 11L12.1499 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'heart-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.75 3.5C5.12665 3.5 3 5.75956 3 8.54688C3 14.125 12 20.5 12 20.5C12 20.5 21 14.125 21 8.54688C21 5.09375 18.8734 3.5 16.25 3.5C14.39 3.5 12.7796 4.63593 12 6.2905C11.2204 4.63593 9.61003 3.5 7.75 3.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.25 12.4918L11.2888 13.6735C11.3841 13.7819 11.5558 13.7739 11.6405 13.6572L13.75 10.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'heart-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.291 9.5C9.30726 9.5 8.50977 10.2975 8.50977 11.2812C8.50977 13.25 11.8848 15.5 11.8848 15.5C11.8848 15.5 15.2598 13.25 15.2598 11.2812C15.2598 10.0625 14.4623 9.5 13.4785 9.5C12.781 9.5 12.1771 9.90092 11.8848 10.4849C11.5924 9.90092 10.9885 9.5 10.291 9.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'heart-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.291 9.5C9.30726 9.5 8.50977 10.2975 8.50977 11.2812C8.50977 13.25 11.8848 15.5 11.8848 15.5C11.8848 15.5 15.2598 13.25 15.2598 11.2812C15.2598 10.0625 14.4623 9.5 13.4785 9.5C12.781 9.5 12.1771 9.90092 11.8848 10.4849C11.5924 9.90092 10.9885 9.5 10.291 9.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'heart-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.75 3.5C5.12665 3.5 3 5.75956 3 8.54688C3 14.125 12 20.5 12 20.5C12 20.5 21 14.125 21 8.54688C21 5.09375 18.8734 3.5 16.25 3.5C14.39 3.5 12.7796 4.63593 12 6.2905C11.2204 4.63593 9.61003 3.5 7.75 3.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 12H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'heart-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.291 9.5C9.30726 9.5 8.50977 10.2975 8.50977 11.2812C8.50977 13.25 11.8848 15.5 11.8848 15.5C11.8848 15.5 15.2598 13.25 15.2598 11.2812C15.2598 10.0625 14.4623 9.5 13.4785 9.5C12.781 9.5 12.1771 9.90092 11.8848 10.4849C11.5924 9.90092 10.9885 9.5 10.291 9.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'heart-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.291 9.5C9.30726 9.5 8.50977 10.2975 8.50977 11.2812C8.50977 13.25 11.8848 15.5 11.8848 15.5C11.8848 15.5 15.2598 13.25 15.2598 11.2812C15.2598 10.0625 14.4623 9.5 13.4785 9.5C12.781 9.5 12.1771 9.90092 11.8848 10.4849C11.5924 9.90092 10.9885 9.5 10.291 9.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'heart-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.291 9.5C9.30726 9.5 8.50977 10.2975 8.50977 11.2812C8.50977 13.25 11.8848 15.5 11.8848 15.5C11.8848 15.5 15.2598 13.25 15.2598 11.2812C15.2598 10.0625 14.4623 9.5 13.4785 9.5C12.781 9.5 12.1771 9.90092 11.8848 10.4849C11.5924 9.90092 10.9885 9.5 10.291 9.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'heart-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.291 9.5C9.30726 9.5 8.50977 10.2975 8.50977 11.2812C8.50977 13.25 11.8848 15.5 11.8848 15.5C11.8848 15.5 15.2598 13.25 15.2598 11.2812C15.2598 10.0625 14.4623 9.5 13.4785 9.5C12.781 9.5 12.1771 9.90092 11.8848 10.4849C11.5924 9.90092 10.9885 9.5 10.291 9.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'heart-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.75 3.5C5.12665 3.5 3 5.75956 3 8.54688C3 14.125 12 20.5 12 20.5C12 20.5 21 14.125 21 8.54688C21 5.09375 18.8734 3.5 16.25 3.5C14.39 3.5 12.7796 4.63593 12 6.2905C11.2204 4.63593 9.61003 3.5 7.75 3.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.5 11L13.3284 13.8284" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.3284 11L10.5 13.8284" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'home' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.13333 21C4.95513 21 4 20.0195 4 18.8101V10.0078C4 9.34256 4.29459 8.71336 4.80065 8.29777L10.6673 3.47989C11.4464 2.84004 12.5535 2.84004 13.3327 3.47989L19.1993 8.29777C19.7054 8.71336 20 9.34256 20 10.0078V18.8101C20 20.0195 19.0449 21 17.8667 21H6.13333Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 21V15.5C9.5 14.3954 10.3954 13.5 11.5 13.5H12.5C13.6046 13.5 14.5 14.3954 14.5 15.5V21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'home-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.68018 13.3225L11.0588 14.898C11.1852 15.0425 11.4132 15.0319 11.5256 14.8762L14.3251 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6.13333 21C4.95513 21 4 20.0195 4 18.8101V10.0078C4 9.34256 4.29459 8.71336 4.80065 8.29777L10.6673 3.47989C11.4464 2.84004 12.5535 2.84004 13.3327 3.47989L19.1993 8.29777C19.7054 8.71336 20 9.34256 20 10.0078V18.8101C20 20.0195 19.0449 21 17.8667 21H6.13333Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'home-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 13.5H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6.13333 21C4.95513 21 4 20.0195 4 18.8101V10.0078C4 9.34256 4.29459 8.71336 4.80065 8.29777L10.6673 3.47989C11.4464 2.84004 12.5535 2.84004 13.3327 3.47989L19.1993 8.29777C19.7054 8.71336 20 9.34256 20 10.0078V18.8101C20 20.0195 19.0449 21 17.8667 21H6.13333Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'home-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 13.5H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 11L12 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6.13333 21C4.95513 21 4 20.0195 4 18.8101V10.0078C4 9.34256 4.29459 8.71336 4.80065 8.29777L10.6673 3.47989C11.4464 2.84004 12.5535 2.84004 13.3327 3.47989L19.1993 8.29777C19.7054 8.71336 20 9.34256 20 10.0078V18.8101C20 20.0195 19.0449 21 17.8667 21H6.13333Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'home-smile' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.13333 21C4.95513 21 4 20.0195 4 18.8101V10.0078C4 9.34256 4.29459 8.71336 4.80065 8.29777L10.6673 3.47989C11.4464 2.84004 12.5535 2.84004 13.3327 3.47989L19.1993 8.29777C19.7054 8.71336 20 9.34256 20 10.0078V18.8101C20 20.0195 19.0449 21 17.8667 21H6.13333Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 16C9.85038 16.6303 10.8846 17 12 17C13.1154 17 14.1496 16.6303 15 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 11.5V11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 11.5V11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'home-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 11.5L14 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 11.5L10 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6.13333 21C4.95513 21 4 20.0195 4 18.8101V10.0078C4 9.34256 4.29459 8.71336 4.80065 8.29777L10.6673 3.47989C11.4464 2.84004 12.5535 2.84004 13.3327 3.47989L19.1993 8.29777C19.7054 8.71336 20 9.34256 20 10.0078V18.8101C20 20.0195 19.0449 21 17.8667 21H6.13333Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'image' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.5 8C6.5 9.10457 7.39543 10 8.5 10C9.60457 10 10.5 9.10457 10.5 8C10.5 6.89543 9.60457 6 8.5 6C7.39543 6 6.5 6.89543 6.5 8Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.9271 9.98991C14.3159 9.08234 8.61589 13.9903 8.99978 20.5001" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 13.0656C5.77936 12.6808 8.27485 14.0245 9.62356 16.1659" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'image-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7 9C7 10.1046 7.89543 11 9 11C10.1046 11 11 10.1046 11 9C11 7.89543 10.1046 7 9 7C7.89543 7 7 7.89543 7 9Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.7183 10.0794C14.3382 9.32936 8.8678 13.9859 9.00243 20.2242" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.20117 13.0407C5.89949 12.7462 8.30763 14.0762 9.62374 16.1659" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'image-rectangle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6 9C6 10.1046 6.89543 11 8 11C9.10457 11 10 10.1046 10 9C10 7.89543 9.10457 7 8 7C6.89543 7 6 7.89543 6 9Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21.9271 8.98967C15.3159 8.08209 9.61589 12.9901 9.99978 19.4999" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2 13.0657C4.77936 12.6809 8.85134 14.3587 10.2001 16.5001" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2 12C2 8.22876 2 6.34315 3.46447 5.17157C4.92893 4 7.28595 4 12 4C16.714 4 19.0711 4 20.5355 5.17157C22 6.34315 22 8.22876 22 12C22 15.7712 22 17.6569 20.5355 18.8284C19.0711 20 16.714 20 12 20C7.28595 20 4.92893 20 3.46447 18.8284C2 17.6569 2 15.7712 2 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'inbox' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.25 13H6.92963C7.59834 13 8.2228 13.3342 8.59373 13.8906L9.40627 15.1094C9.7772 15.6658 10.4017 16 11.0704 16H12.9296C13.5983 16 14.2228 15.6658 14.5937 15.1094L15.4063 13.8906C15.7772 13.3342 16.4017 13 17.0704 13H20.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.45 4.11L3.28752 11.9567C3.09671 12.6491 3 13.364 3 14.0822V19C3 19.5304 3.21071 20.0391 3.58579 20.4142C3.96086 20.7893 4.46957 21 5 21H19C19.5304 21 20.0391 20.7893 20.4142 20.4142C20.7893 20.0391 21 19.5304 21 19V14.0822C21 13.364 20.9033 12.6491 20.7125 11.9567L18.55 4.11C18.3844 3.77679 18.1292 3.49637 17.813 3.30028C17.4967 3.10419 17.1321 3.0002 16.76 3H7.24C6.86792 3.0002 6.50326 3.10419 6.18704 3.30028C5.87083 3.49637 5.61558 3.77679 5.45 4.11Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'inbox-archive' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.25 13H6.92963C7.59834 13 8.2228 13.3342 8.59373 13.8906L9.40627 15.1094C9.7772 15.6658 10.4017 16 11.0704 16H12.9296C13.5983 16 14.2228 15.6658 14.5937 15.1094L15.4063 13.8906C15.7772 13.3342 16.4017 13 17.0704 13H20.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.45 4.11L3.28752 11.9567C3.09671 12.6491 3 13.364 3 14.0822V19C3 19.5304 3.21071 20.0391 3.58579 20.4142C3.96086 20.7893 4.46957 21 5 21H19C19.5304 21 20.0391 20.7893 20.4142 20.4142C20.7893 20.0391 21 19.5304 21 19V14.0822C21 13.364 20.9033 12.6491 20.7125 11.9567L18.55 4.11C18.3844 3.77679 18.1292 3.49637 17.813 3.30028C17.4967 3.10419 17.1321 3.0002 16.76 3H7.24C6.86792 3.0002 6.50326 3.10419 6.18704 3.30028C5.87083 3.49637 5.61558 3.77679 5.45 4.11Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 9.5H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.5 6.5H13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'inbox-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.25 13H6.92963C7.59834 13 8.2228 13.3342 8.59373 13.8906L9.40627 15.1094C9.7772 15.6658 10.4017 16 11.0704 16H12.9296C13.5983 16 14.2228 15.6658 14.5937 15.1094L15.4063 13.8906C15.7772 13.3342 16.4017 13 17.0704 13H20.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.45 4.11L3.28752 11.9567C3.09671 12.6491 3 13.364 3 14.0822V19C3 19.5304 3.21071 20.0391 3.58579 20.4142C3.96086 20.7893 4.46957 21 5 21H19C19.5304 21 20.0391 20.7893 20.4142 20.4142C20.7893 20.0391 21 19.5304 21 19V14.0822C21 13.364 20.9033 12.6491 20.7125 11.9567L18.55 4.11C18.3844 3.77679 18.1292 3.49637 17.813 3.30028C17.4967 3.10419 17.1321 3.0002 16.76 3H7.24C6.86792 3.0002 6.50326 3.10419 6.18704 3.30028C5.87083 3.49637 5.61558 3.77679 5.45 4.11Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.2998 8.74184L11.3338 9.92352C11.4286 10.0319 11.5996 10.0239 11.6839 9.90717L13.7835 7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'inbox-down' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.25 13H6.92963C7.59834 13 8.2228 13.3342 8.59373 13.8906L9.40627 15.1094C9.7772 15.6658 10.4017 16 11.0704 16H12.9296C13.5983 16 14.2228 15.6658 14.5937 15.1094L15.4063 13.8906C15.7772 13.3342 16.4017 13 17.0704 13H20.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.45 4.11L3.28752 11.9567C3.09671 12.6491 3 13.364 3 14.0822V19C3 19.5304 3.21071 20.0391 3.58579 20.4142C3.96086 20.7893 4.46957 21 5 21H19C19.5304 21 20.0391 20.7893 20.4142 20.4142C20.7893 20.0391 21 19.5304 21 19V14.0822C21 13.364 20.9033 12.6491 20.7125 11.9567L18.55 4.11C18.3844 3.77679 18.1292 3.49637 17.813 3.30028C17.4967 3.10419 17.1321 3.0002 16.76 3H7.24C6.86792 3.0002 6.50326 3.10419 6.18704 3.30028C5.87083 3.49637 5.61558 3.77679 5.45 4.11Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.0033 6L12 11.2797" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 9.34644L12 11.9999L9.5 9.34644" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'inbox-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.25 13H6.92963C7.59834 13 8.2228 13.3342 8.59373 13.8906L9.40627 15.1094C9.7772 15.6658 10.4017 16 11.0704 16H12.9296C13.5983 16 14.2228 15.6658 14.5937 15.1094L15.4063 13.8906C15.7772 13.3342 16.4017 13 17.0704 13H20.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.45 4.11L3.28752 11.9567C3.09671 12.6491 3 13.364 3 14.0822V19C3 19.5304 3.21071 20.0391 3.58579 20.4142C3.96086 20.7893 4.46957 21 5 21H19C19.5304 21 20.0391 20.7893 20.4142 20.4142C20.7893 20.0391 21 19.5304 21 19V14.0822C21 13.364 20.9033 12.6491 20.7125 11.9567L18.55 4.11C18.3844 3.77679 18.1292 3.49637 17.813 3.30028C17.4967 3.10419 17.1321 3.0002 16.76 3H7.24C6.86792 3.0002 6.50326 3.10419 6.18704 3.30028C5.87083 3.49637 5.61558 3.77679 5.45 4.11Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 8.5H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'inbox-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.25 13H6.92963C7.59834 13 8.2228 13.3342 8.59373 13.8906L9.40627 15.1094C9.7772 15.6658 10.4017 16 11.0704 16H12.9296C13.5983 16 14.2228 15.6658 14.5937 15.1094L15.4063 13.8906C15.7772 13.3342 16.4017 13 17.0704 13H20.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.45 4.11L3.28752 11.9567C3.09671 12.6491 3 13.364 3 14.0822V19C3 19.5304 3.21071 20.0391 3.58579 20.4142C3.96086 20.7893 4.46957 21 5 21H19C19.5304 21 20.0391 20.7893 20.4142 20.4142C20.7893 20.0391 21 19.5304 21 19V14.0822C21 13.364 20.9033 12.6491 20.7125 11.9567L18.55 4.11C18.3844 3.77679 18.1292 3.49637 17.813 3.30028C17.4967 3.10419 17.1321 3.0002 16.76 3H7.24C6.86792 3.0002 6.50326 3.10419 6.18704 3.30028C5.87083 3.49637 5.61558 3.77679 5.45 4.11Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 8.5H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 6.5L12 10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'inbox-up' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.25 13H6.92963C7.59834 13 8.2228 13.3342 8.59373 13.8906L9.40627 15.1094C9.7772 15.6658 10.4017 16 11.0704 16H12.9296C13.5983 16 14.2228 15.6658 14.5937 15.1094L15.4063 13.8906C15.7772 13.3342 16.4017 13 17.0704 13H20.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.45 4.11L3.28752 11.9567C3.09671 12.6491 3 13.364 3 14.0822V19C3 19.5304 3.21071 20.0391 3.58579 20.4142C3.96086 20.7893 4.46957 21 5 21H19C19.5304 21 20.0391 20.7893 20.4142 20.4142C20.7893 20.0391 21 19.5304 21 19V14.0822C21 13.364 20.9033 12.6491 20.7125 11.9567L18.55 4.11C18.3844 3.77679 18.1292 3.49637 17.813 3.30028C17.4967 3.10419 17.1321 3.0002 16.76 3H7.24C6.86792 3.0002 6.50326 3.10419 6.18704 3.30028C5.87083 3.49637 5.61558 3.77679 5.45 4.11Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.0033 11.9999L12 6.72021" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 8.65345L12 6L9.5 8.65345" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'inbox-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.25 13H6.92963C7.59834 13 8.2228 13.3342 8.59373 13.8906L9.40627 15.1094C9.7772 15.6658 10.4017 16 11.0704 16H12.9296C13.5983 16 14.2228 15.6658 14.5937 15.1094L15.4063 13.8906C15.7772 13.3342 16.4017 13 17.0704 13H20.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.45 4.11L3.28752 11.9567C3.09671 12.6491 3 13.364 3 14.0822V19C3 19.5304 3.21071 20.0391 3.58579 20.4142C3.96086 20.7893 4.46957 21 5 21H19C19.5304 21 20.0391 20.7893 20.4142 20.4142C20.7893 20.0391 21 19.5304 21 19V14.0822C21 13.364 20.9033 12.6491 20.7125 11.9567L18.55 4.11C18.3844 3.77679 18.1292 3.49637 17.813 3.30028C17.4967 3.10419 17.1321 3.0002 16.76 3H7.24C6.86792 3.0002 6.50326 3.10419 6.18704 3.30028C5.87083 3.49637 5.61558 3.77679 5.45 4.11Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.5 7L13.5 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.5 7L10.5 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'incognito' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 17.5C21 19.433 19.433 21 17.5 21C15.567 21 14 19.433 14 17.5C14 15.567 15.567 14 17.5 14C19.433 14 21 15.567 21 17.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 10.4119H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5 10.223L5.6138 7.62339C6.15947 5.31231 6.43231 4.15678 7.24609 3.48402C7.79089 3.03363 8.05624 3.55703 8.84718 3.95225C9.85149 4.45407 11.0242 4.05473 12.0327 3.56126C13.0411 3.06779 15.0062 2.80668 16.0687 3.16946C17.0454 3.50293 17.0525 3.93109 17.4602 4.87914C18.1926 6.58205 18.574 8.41865 19 10.223" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 17.5C10 19.433 8.433 21 6.5 21C4.567 21 3 19.433 3 17.5C3 15.567 4.567 14 6.5 14C8.433 14 10 15.567 10 17.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 16.294L10.6584 15.9455C11.5029 15.4983 12.4971 15.4983 13.3416 15.9455L14 16.294" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'indifferent-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 15.5C10 15.5 10.8846 15.5 12 15.5C13.1154 15.5 14 15.5 15 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'indifferent-ghost' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 15.5C10 15.5 10.8846 15.5 12 15.5C13.1154 15.5 14 15.5 15 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 18.5615V12.0443C3 7.04928 7.02944 3 12 3C16.9706 3 21 7.04928 21 12.0443V18.5615C21 19.7226 20.0334 21.08 19 20.5608C18.1647 20.1411 16.777 20.0402 16 20.5608C15.1259 21.1464 13.8741 21.1464 13 20.5608C12.1148 19.9678 11.3511 19.9906 10.5 20.5608C9.6259 21.1464 8.3741 21.1464 7.5 20.5608C6.723 20.0402 5.83525 20.1411 5 20.5608C3.9666 21.08 3 19.7226 3 18.5615Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'indifferent-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 15.5C10 15.5 10.8846 15.5 12 15.5C13.1154 15.5 14 15.5 15 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'infinity' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 9.41721C14.8383 8.57524 15.7933 8 17 8C19.2091 8 21 9.79086 21 12C21 14.2091 19.2091 16 17 16C12.5 16 11.5 8 7 8C4.79086 8 3 9.79086 3 12C3 14.2091 4.79086 16 7 16C8.20668 16 9.16169 15.4248 10 14.5828" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'info' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 19.5V9.5H11.5M11.5 19.5H12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 5.5V5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'info-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 16V11H11.5M11.5 16H12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8.5V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'info-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 16V11H11.5M11.5 16H12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8.5V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'info-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 16V11H11.5M11.5 16H12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8.5V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'info-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 16V11H11.5M11.5 16H12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8.5V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'info-triangle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 17V12H11.5M11.5 17H12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 9.5V9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.98054 10.7615C8.60706 5.58716 9.92033 3 12 3C14.0797 3 15.3929 5.58716 18.0195 10.7615L18.3467 11.4063C20.5294 15.7061 21.6207 17.856 20.6344 19.428C19.648 21 17.2078 21 12.3273 21H11.6727C6.7922 21 4.35195 21 3.36563 19.428C2.37931 17.856 3.47062 15.7061 5.65325 11.4063L5.98054 10.7615Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'info-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 16V11H11.5M11.5 16H12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8.5V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'intersect' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.4 15.6H10.8C12.4802 15.6 13.3202 15.6 13.962 15.273C14.5265 14.9854 14.9854 14.5265 15.273 13.962C15.6 13.3202 15.6 12.4802 15.6 10.8V8.4M8.4 15.6V16.5M8.4 15.6V13.2C8.4 11.5198 8.4 10.6798 8.72698 10.038C9.0146 9.47354 9.47354 9.0146 10.038 8.72698C10.6798 8.4 11.5198 8.4 13.2 8.4H15.6M8.4 15.6H7.5M15.6 8.4H16.5M15.6 8.4V7.5M8.4 19.65V21H10.2M15.6 21H13.8M19.2 21H21V19.2M21 13.8V15.6M21 10.2V8.4H19.65M15.6 4.35V3H13.8M8.4 3H10.2M4.8 3H3V4.8M3 10.2V8.4M3 13.8V15.6H4.35" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'key' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.3623 9.06477L16.6815 10.384C17.677 11.3795 18.0272 9.54574 19.416 9.31476C19.8824 9.23718 20.2927 9.07854 20.4692 8.56312C20.6256 8.10647 20.4479 7.67815 19.895 7.12523L18.5002 5.73047" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.5 21C9.98528 21 12 18.9853 12 16.5C12 14.0147 9.98528 12 7.5 12C5.01472 12 3 14.0147 3 16.5C3 18.9853 5.01472 21 7.5 21Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11 13L21 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'keyboard' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2 11C2 8.17157 2 6.75736 2.87868 5.87868C3.75736 5 5.17157 5 8 5H16C18.8284 5 20.2426 5 21.1213 5.87868C22 6.75736 22 8.17157 22 11V13C22 15.8284 22 17.2426 21.1213 18.1213C20.2426 19 18.8284 19 16 19H8C5.17157 19 3.75736 19 2.87868 18.1213C2 17.2426 2 15.8284 2 13V11Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7 16H17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5 9H8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11 9H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17 9H19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5 12H7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 12H13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 12H19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'keyboard-brightness-high' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 17H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 17H6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8L12 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18 17H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.1211 12.7207L18.5785 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.45746 12.7207L5 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'keyboard-brightness-low' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 17H16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 17H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 9L12 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18 12.2071L18.7071 11.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.70711 12.2071L5 11.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20 17H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'label' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.9804 20.1944L3.68188 12.8959C3.31214 12.5261 3.10149 12.0265 3.09488 11.5037L3.00008 4.01504C2.99295 3.45157 3.45156 2.99295 4.01504 3.00008L11.5037 3.09488C12.0265 3.10149 12.5261 3.31214 12.8959 3.68188L20.1944 10.9804C20.8675 11.6535 21.3858 12.939 20.6177 13.7072L13.7072 20.6177C12.939 21.3858 11.6535 20.8675 10.9804 20.1944Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.01863 7.55232L7.31152 6.84521" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'label' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 21V12M12 21H8.99999M12 21H15M12 12H18L15.4867 4.29775C15.1939 3.51715 14.4477 3 13.614 3H10.386C9.55231 3 8.80607 3.51715 8.51334 4.29775L6 12H12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'layers-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 16L21 12L12 8L3 12L12 16Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'layers-three' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 12L12 16L3.00001 12M21 16L12 20L3 16M21 8L12 12L3.00001 8L12 4L21 8Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'layers-two' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 14.0002L12 18.0002L3 14.0002M21 10.0002L12 14.0002L3 10.0002L12 6.00024L21 10.0002Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'layout' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 10L9 20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 9.5H3.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'leaf' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.97257 18.0281C13.5983 22.6036 19.6988 16.5029 18.9363 5.06449C7.49793 4.30191 1.39764 10.4026 5.97257 18.0281ZM5.97257 18.0281L4 20M5.97257 18.0281L10.1006 13.8994" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'leaves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 12.0705V20M12 11.9291C12 7.57652 15.5381 4.04305 19.919 4C19.9724 4.36984 20 4.74792 20 5.13238C20 9.48492 16.4619 13.0184 12.081 13.0614C12.0276 12.6916 12 12.3135 12 11.9291ZM12 11.9291C12 7.57652 8.46195 4.04305 4.08096 4C4.02761 4.36984 4 4.74792 4 5.13238C4 9.48492 7.53805 13.0184 11.919 13.0614C11.9724 12.6916 12 12.3135 12 11.9291Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-a' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.25 13.6667L11.75 7L9.25 13.6667M14.25 13.6667L15.5 17M14.25 13.6667H9.25M8 17L9.25 13.6667" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-a-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 12.8333L12 7.5L10 12.8333M14 12.8333L15 15.5M14 12.8333H10M9 15.5L10 12.8333" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-a-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 12.8333L12 7.5L10 12.8333M14 12.8333L15 15.5M14 12.8333H10M9 15.5L10 12.8333" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-a-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 12.8333L12 7.5L10 12.8333M14 12.8333L15 15.5M14 12.8333H10M9 15.5L10 12.8333" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-a-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 12.8333L12 7.5L10 12.8333M14 12.8333L15 15.5M14 12.8333H10M9 15.5L10 12.8333" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-a-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 12.8333L12 7.5L10 12.8333M14 12.8333L15 15.5M14 12.8333H10M9 15.5L10 12.8333" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-a-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 12.8333L12 7.5L10 12.8333M14 12.8333L15 15.5M14 12.8333H10M9 15.5L10 12.8333" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-b' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 12V7H13.5889C16.3285 7 16.7131 11.0721 14.1581 12M9 12V17H13.5889C16.3285 17 16.7131 12.9279 14.1581 12M9 12H14.1581" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-b-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 12V8H13.1711C15.3628 8 15.6704 11.2576 13.6265 12M9.5 12V16H13.1711C15.3628 16 15.6704 12.7424 13.6265 12M9.5 12H13.6265" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-b-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 12V8H13.1711C15.3628 8 15.6704 11.2576 13.6265 12M9.5 12V16H13.1711C15.3628 16 15.6704 12.7424 13.6265 12M9.5 12H13.6265" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-b-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 12V8H13.1711C15.3628 8 15.6704 11.2576 13.6265 12M9.5 12V16H13.1711C15.3628 16 15.6704 12.7424 13.6265 12M9.5 12H13.6265" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-b-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 12V8H13.1711C15.3628 8 15.6704 11.2576 13.6265 12M9.5 12V16H13.1711C15.3628 16 15.6704 12.7424 13.6265 12M9.5 12H13.6265" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-b-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 12V8H13.1711C15.3628 8 15.6704 11.2576 13.6265 12M9.5 12V16H13.1711C15.3628 16 15.6704 12.7424 13.6265 12M9.5 12H13.6265" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-b-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 12V8H13.1711C15.3628 8 15.6704 11.2576 13.6265 12M9.5 12V16H13.1711C15.3628 16 15.6704 12.7424 13.6265 12M9.5 12H13.6265" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-c' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.5 9.5V9.1875C15.5 7.97938 14.5206 7 13.3125 7H10.5C9.11929 7 8 8.11929 8 9.5V14.5C8 15.8807 9.11929 17 10.5 17H13.3125C14.5206 17 15.5 16.0206 15.5 14.8125V14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-c-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 10V9.75C15 8.7835 14.2165 8 13.25 8H11C9.89543 8 9 8.89543 9 10V14C9 15.1046 9.89543 16 11 16H13.25C14.2165 16 15 15.2165 15 14.25V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-c-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 10V9.75C15 8.7835 14.2165 8 13.25 8H11C9.89543 8 9 8.89543 9 10V14C9 15.1046 9.89543 16 11 16H13.25C14.2165 16 15 15.2165 15 14.25V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-c-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 10V9.75C15 8.7835 14.2165 8 13.25 8H11C9.89543 8 9 8.89543 9 10V14C9 15.1046 9.89543 16 11 16H13.25C14.2165 16 15 15.2165 15 14.25V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-c-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 10V9.75C15 8.7835 14.2165 8 13.25 8H11C9.89543 8 9 8.89543 9 10V14C9 15.1046 9.89543 16 11 16H13.25C14.2165 16 15 15.2165 15 14.25V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-c-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 10V9.75C15 8.7835 14.2165 8 13.25 8H11C9.89543 8 9 8.89543 9 10V14C9 15.1046 9.89543 16 11 16H13.25C14.2165 16 15 15.2165 15 14.25V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-c-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 10V9.75C15 8.7835 14.2165 8 13.25 8H11C9.89543 8 9 8.89543 9 10V14C9 15.1046 9.89543 16 11 16H13.25C14.2165 16 15 15.2165 15 14.25V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-d' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 16.375V7.625C8 7.27982 8.27982 7 8.625 7H11.125C13.5412 7 15.5 8.95875 15.5 11.375V12.625C15.5 15.0412 13.5412 17 11.125 17H8.625C8.27982 17 8 16.7202 8 16.375Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-d-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 15.5V8.5C9.5 8.22386 9.72386 8 10 8H12C13.933 8 15.5 9.567 15.5 11.5V12.5C15.5 14.433 13.933 16 12 16H10C9.72386 16 9.5 15.7761 9.5 15.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-d-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 15.5V8.5C9.5 8.22386 9.72386 8 10 8H12C13.933 8 15.5 9.567 15.5 11.5V12.5C15.5 14.433 13.933 16 12 16H10C9.72386 16 9.5 15.7761 9.5 15.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-d-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 15.5V8.5C9.5 8.22386 9.72386 8 10 8H12C13.933 8 15.5 9.567 15.5 11.5V12.5C15.5 14.433 13.933 16 12 16H10C9.72386 16 9.5 15.7761 9.5 15.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-d-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 15.5V8.5C9.5 8.22386 9.72386 8 10 8H12C13.933 8 15.5 9.567 15.5 11.5V12.5C15.5 14.433 13.933 16 12 16H10C9.72386 16 9.5 15.7761 9.5 15.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-d-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 15.5V8.5C9.5 8.22386 9.72386 8 10 8H12C13.933 8 15.5 9.567 15.5 11.5V12.5C15.5 14.433 13.933 16 12 16H10C9.72386 16 9.5 15.7761 9.5 15.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-d-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 15.5V8.5C9.5 8.22386 9.72386 8 10 8H12C13.933 8 15.5 9.567 15.5 11.5V12.5C15.5 14.433 13.933 16 12 16H10C9.72386 16 9.5 15.7761 9.5 15.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-e' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.25 7H9V12M15.25 17H9V12M9 12H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-e-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 8H9.5V12M14.5 16H9.5V12M9.5 12H13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-e-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.5 8H9.5V12M14.5 16H9.5V12M9.5 12H13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-e-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.5 8H9.5V12M14.5 16H9.5V12M9.5 12H13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-e-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.5 8H9.5V12M14.5 16H9.5V12M9.5 12H13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-e-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.5 8H9.5V12M14.5 16H9.5V12M9.5 12H13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-e-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.5 8H9.5V12M14.5 16H9.5V12M9.5 12H13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-f' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.5 7H9.25V12M9.25 12V17M9.25 12H14.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-f-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.75 8H9.75V12M9.75 12V16M9.75 12H13.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-f-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.75 8H9.75V12M9.75 12V16M9.75 12H13.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-f-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.75 8H9.75V12M9.75 12V16M9.75 12H13.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-f-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.75 8H9.75V12M9.75 12V16M9.75 12H13.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-f-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.75 8H9.75V12M9.75 12V16M9.75 12H13.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-f-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.75 8H9.75V12M9.75 12V16M9.75 12H13.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-g' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.1667 12H14.625C14.9702 12 15.25 12.2798 15.25 12.625V16.375C15.25 16.7202 14.9702 17 14.625 17H10.875C9.83947 17 9 16.1605 9 15.125V8.875C9 7.83947 9.83947 7 10.875 7H13.375C14.4105 7 15.25 7.83947 15.25 8.875" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-g-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.8333 12H14C14.2761 12 14.5 12.2239 14.5 12.5V15.5C14.5 15.7761 14.2761 16 14 16H11C10.1716 16 9.5 15.3284 9.5 14.5V9.5C9.5 8.67157 10.1716 8 11 8H13C13.8284 8 14.5 8.67157 14.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-g-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.8333 12H14C14.2761 12 14.5 12.2239 14.5 12.5V15.5C14.5 15.7761 14.2761 16 14 16H11C10.1716 16 9.5 15.3284 9.5 14.5V9.5C9.5 8.67157 10.1716 8 11 8H13C13.8284 8 14.5 8.67157 14.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-g-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.8333 12H14C14.2761 12 14.5 12.2239 14.5 12.5V15.5C14.5 15.7761 14.2761 16 14 16H11C10.1716 16 9.5 15.3284 9.5 14.5V9.5C9.5 8.67157 10.1716 8 11 8H13C13.8284 8 14.5 8.67157 14.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-g-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.8333 12H14C14.2761 12 14.5 12.2239 14.5 12.5V15.5C14.5 15.7761 14.2761 16 14 16H11C10.1716 16 9.5 15.3284 9.5 14.5V9.5C9.5 8.67157 10.1716 8 11 8H13C13.8284 8 14.5 8.67157 14.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-g-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.8333 12H14C14.2761 12 14.5 12.2239 14.5 12.5V15.5C14.5 15.7761 14.2761 16 14 16H11C10.1716 16 9.5 15.3284 9.5 14.5V9.5C9.5 8.67157 10.1716 8 11 8H13C13.8284 8 14.5 8.67157 14.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-g-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.8333 12H14C14.2761 12 14.5 12.2239 14.5 12.5V15.5C14.5 15.7761 14.2761 16 14 16H11C10.1716 16 9.5 15.3284 9.5 14.5V9.5C9.5 8.67157 10.1716 8 11 8H13C13.8284 8 14.5 8.67157 14.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-h' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 7V12M9 12V17M9 12H15.25M15.25 7V12M15.25 12V17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-h-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 8V12M9.5 12V16M9.5 12H14.5M14.5 8V12M14.5 12V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-h-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 8V12M9.5 12V16M9.5 12H14.5M14.5 8V12M14.5 12V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-h-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 8V12M9.5 12V16M9.5 12H14.5M14.5 8V12M14.5 12V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-h-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 8V12M9.5 12V16M9.5 12H14.5M14.5 8V12M14.5 12V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-h-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 8V12M9.5 12V16M9.5 12H14.5M14.5 8V12M14.5 12V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-h-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 8V12M9.5 12V16M9.5 12H14.5M14.5 8V12M14.5 12V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-i' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 7H12.125M12.125 7H15.25M12.125 7V17M15.25 17H12.125M12.125 17H9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-i-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 8H12M12 8H14.5M12 8V16M14.5 16H12M12 16H9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-i-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 8H12M12 8H14.5M12 8V16M14.5 16H12M12 16H9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-i-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 8H12M12 8H14.5M12 8V16M14.5 16H12M12 16H9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-i-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 8H12M12 8H14.5M12 8V16M14.5 16H12M12 16H9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-i-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 8H12M12 8H14.5M12 8V16M14.5 16H12M12 16H9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-i-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 8H12M12 8H14.5M12 8V16M14.5 16H12M12 16H9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-j' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.25 7V14.5C15.25 15.8807 14.1307 17 12.75 17H11.5C10.1193 17 9 15.8807 9 14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-j-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.25 8V14C14.25 15.1046 13.3546 16 12.25 16H11.25C10.1454 16 9.25 15.1046 9.25 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-j-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.25 8V14C14.25 15.1046 13.3546 16 12.25 16H11.25C10.1454 16 9.25 15.1046 9.25 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-j-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.25 8V14C14.25 15.1046 13.3546 16 12.25 16H11.25C10.1454 16 9.25 15.1046 9.25 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-j-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.25 8V14C14.25 15.1046 13.3546 16 12.25 16H11.25C10.1454 16 9.25 15.1046 9.25 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-j-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.25 8V14C14.25 15.1046 13.3546 16 12.25 16H11.25C10.1454 16 9.25 15.1046 9.25 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-j-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.25 8V14C14.25 15.1046 13.3546 16 12.25 16H11.25C10.1454 16 9.25 15.1046 9.25 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-k' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 7V12M9 12V17M9 12H9.625M9.625 12L15.25 17M9.625 12L15.25 7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-k-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.75 8V12M9.75 12V16M9.75 12H10.25M10.25 12L14.75 16M10.25 12L14.75 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-k-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.75 8V12M9.75 12V16M9.75 12H10.25M10.25 12L14.75 16M10.25 12L14.75 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-k-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.75 8V12M9.75 12V16M9.75 12H10.25M10.25 12L14.75 16M10.25 12L14.75 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-k-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.75 8V12M9.75 12V16M9.75 12H10.25M10.25 12L14.75 16M10.25 12L14.75 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-k-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.75 8V12M9.75 12V16M9.75 12H10.25M10.25 12L14.75 16M10.25 12L14.75 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-k-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.75 8V12M9.75 12V16M9.75 12H10.25M10.25 12L14.75 16M10.25 12L14.75 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-l' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 7V16.5H16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-l-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 8V15.5H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-l-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 8V15.5H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-l-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 8V15.5H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-l-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 8V15.5H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-l-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 8V15.5H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-l-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 8V15.5H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-m' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 17V7L11.75 12L15.5 7V17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-m-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 16V8L12 12L15 8V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-m-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 16V8L12 12L15 8V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-m-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 16V8L12 12L15 8V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-m-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 16V8L12 12L15 8V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-m-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 16V8L12 12L15 8V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-m-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 16V8L12 12L15 8V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-n' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 17V7L15.5 17V7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-n-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 16V8L15 16V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-n-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 16V8L15 16V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-n-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 16V8L15 16V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-n-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 16V8L15 16V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-n-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 16V8L15 16V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-n-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 16V8L15 16V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-o' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 14.5V9.5C8 8.11929 9.11929 7 10.5 7H13C14.3807 7 15.5 8.11929 15.5 9.5V14.5C15.5 15.8807 14.3807 17 13 17H10.5C9.11929 17 8 15.8807 8 14.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-o-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 14V10C9 8.89543 9.89543 8 11 8H13C14.1046 8 15 8.89543 15 10V14C15 15.1046 14.1046 16 13 16H11C9.89543 16 9 15.1046 9 14Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-o-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 14V10C9 8.89543 9.89543 8 11 8H13C14.1046 8 15 8.89543 15 10V14C15 15.1046 14.1046 16 13 16H11C9.89543 16 9 15.1046 9 14Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-o-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 14V10C9 8.89543 9.89543 8 11 8H13C14.1046 8 15 8.89543 15 10V14C15 15.1046 14.1046 16 13 16H11C9.89543 16 9 15.1046 9 14Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-o-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 14V10C9 8.89543 9.89543 8 11 8H13C14.1046 8 15 8.89543 15 10V14C15 15.1046 14.1046 16 13 16H11C9.89543 16 9 15.1046 9 14Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-o-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 14V10C9 8.89543 9.89543 8 11 8H13C14.1046 8 15 8.89543 15 10V14C15 15.1046 14.1046 16 13 16H11C9.89543 16 9 15.1046 9 14Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-o-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 14V10C9 8.89543 9.89543 8 11 8H13C14.1046 8 15 8.89543 15 10V14C15 15.1046 14.1046 16 13 16H11C9.89543 16 9 15.1046 9 14Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-p' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 12V7.625C9 7.27982 9.27982 7 9.625 7H13.375C14.4105 7 15.25 7.83947 15.25 8.875V10.125C15.25 11.1605 14.4105 12 13.375 12H9ZM9 12V17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-p-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.75 12V8.5C9.75 8.22386 9.97386 8 10.25 8H13.25C14.0784 8 14.75 8.67157 14.75 9.5V10.5C14.75 11.3284 14.0784 12 13.25 12H9.75ZM9.75 12V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-p-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.75 12V8.5C9.75 8.22386 9.97386 8 10.25 8H13.25C14.0784 8 14.75 8.67157 14.75 9.5V10.5C14.75 11.3284 14.0784 12 13.25 12H9.75ZM9.75 12V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-p-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.75 12V8.5C9.75 8.22386 9.97386 8 10.25 8H13.25C14.0784 8 14.75 8.67157 14.75 9.5V10.5C14.75 11.3284 14.0784 12 13.25 12H9.75ZM9.75 12V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-p-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.75 12V8.5C9.75 8.22386 9.97386 8 10.25 8H13.25C14.0784 8 14.75 8.67157 14.75 9.5V10.5C14.75 11.3284 14.0784 12 13.25 12H9.75ZM9.75 12V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-p-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.75 12V8.5C9.75 8.22386 9.97386 8 10.25 8H13.25C14.0784 8 14.75 8.67157 14.75 9.5V10.5C14.75 11.3284 14.0784 12 13.25 12H9.75ZM9.75 12V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-p-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.75 12V8.5C9.75 8.22386 9.97386 8 10.25 8H13.25C14.0784 8 14.75 8.67157 14.75 9.5V10.5C14.75 11.3284 14.0784 12 13.25 12H9.75ZM9.75 12V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-q' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.3846 16.8824V9.47059C15.3846 8.10612 14.2825 7 12.9231 7H10.4615C9.10207 7 8 8.10612 8 9.47059V14.4118C8 15.7762 9.10207 16.8824 10.4615 16.8824H15.3846ZM15.3846 16.8824L12.9231 14.4118M15.3846 16.8824L16 17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-q-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 16V10C15 8.89543 14.1046 8 13 8H11C9.89543 8 9 8.89543 9 10V14C9 15.1046 9.89543 16 11 16H15ZM15 16L13 14M15 16L15.5 16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-q-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 16V10C15 8.89543 14.1046 8 13 8H11C9.89543 8 9 8.89543 9 10V14C9 15.1046 9.89543 16 11 16H15ZM15 16L13 14M15 16L15.5 16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-q-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 16V10C15 8.89543 14.1046 8 13 8H11C9.89543 8 9 8.89543 9 10V14C9 15.1046 9.89543 16 11 16H15ZM15 16L13 14M15 16L15.5 16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-q-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 16V10C15 8.89543 14.1046 8 13 8H11C9.89543 8 9 8.89543 9 10V14C9 15.1046 9.89543 16 11 16H15ZM15 16L13 14M15 16L15.5 16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-q-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 16V10C15 8.89543 14.1046 8 13 8H11C9.89543 8 9 8.89543 9 10V14C9 15.1046 9.89543 16 11 16H15ZM15 16L13 14M15 16L15.5 16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-q-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 16V10C15 8.89543 14.1046 8 13 8H11C9.89543 8 9 8.89543 9 10V14C9 15.1046 9.89543 16 11 16H15ZM15 16L13 14M15 16L15.5 16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-r' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 12V7.625C9 7.27982 9.27982 7 9.625 7H13.375C14.4105 7 15.25 7.83947 15.25 8.875V10.125C15.25 11.1605 14.4105 12 13.375 12H11.1875M9 12V17M9 12H11.1875M11.1875 12L14.9375 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-r-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.75 12V8.5C9.75 8.22386 9.97386 8 10.25 8H13.25C14.0784 8 14.75 8.67157 14.75 9.5V10.5C14.75 11.3284 14.0784 12 13.25 12H11.5M9.75 12V16M9.75 12H11.5M11.5 12L14.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-r-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.75 12V8.5C9.75 8.22386 9.97386 8 10.25 8H13.25C14.0784 8 14.75 8.67157 14.75 9.5V10.5C14.75 11.3284 14.0784 12 13.25 12H11.5M9.75 12V16M9.75 12H11.5M11.5 12L14.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-r-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.75 12V8.5C9.75 8.22386 9.97386 8 10.25 8H13.25C14.0784 8 14.75 8.67157 14.75 9.5V10.5C14.75 11.3284 14.0784 12 13.25 12H11.5M9.75 12V16M9.75 12H11.5M11.5 12L14.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-r-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.75 12V8.5C9.75 8.22386 9.97386 8 10.25 8H13.25C14.0784 8 14.75 8.67157 14.75 9.5V10.5C14.75 11.3284 14.0784 12 13.25 12H11.5M9.75 12V16M9.75 12H11.5M11.5 12L14.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-r-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.75 12V8.5C9.75 8.22386 9.97386 8 10.25 8H13.25C14.0784 8 14.75 8.67157 14.75 9.5V10.5C14.75 11.3284 14.0784 12 13.25 12H11.5M9.75 12V16M9.75 12H11.5M11.5 12L14.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-r-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.75 12V8.5C9.75 8.22386 9.97386 8 10.25 8H13.25C14.0784 8 14.75 8.67157 14.75 9.5V10.5C14.75 11.3284 14.0784 12 13.25 12H11.5M9.75 12V16M9.75 12H11.5M11.5 12L14.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-s' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.25 8.5625V8.25C15.25 7.55964 14.6904 7 14 7H10.25C9.55964 7 9 7.55964 9 8.25V9.48056C9 10.2473 9.46678 10.9367 10.1786 11.2215L14.0714 12.7785C14.7832 13.0633 15.25 13.7527 15.25 14.5194V15.75C15.25 16.4404 14.6904 17 14 17H10.25C9.55964 17 9 16.4404 9 15.75V15.4375" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-s-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 9.25V9C14.5 8.44772 14.0523 8 13.5 8H10.5C9.94772 8 9.5 8.44772 9.5 9V9.98445C9.5 10.5978 9.87343 11.1494 10.4429 11.3772L13.5571 12.6228C14.1266 12.8506 14.5 13.4022 14.5 14.0155V15C14.5 15.5523 14.0523 16 13.5 16H10.5C9.94772 16 9.5 15.5523 9.5 15V14.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-s-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.5 9.25V9C14.5 8.44772 14.0523 8 13.5 8H10.5C9.94772 8 9.5 8.44772 9.5 9V9.98445C9.5 10.5978 9.87343 11.1494 10.4429 11.3772L13.5571 12.6228C14.1266 12.8506 14.5 13.4022 14.5 14.0155V15C14.5 15.5523 14.0523 16 13.5 16H10.5C9.94772 16 9.5 15.5523 9.5 15V14.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-s-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.5 9.25V9C14.5 8.44772 14.0523 8 13.5 8H10.5C9.94772 8 9.5 8.44772 9.5 9V9.98445C9.5 10.5978 9.87343 11.1494 10.4429 11.3772L13.5571 12.6228C14.1266 12.8506 14.5 13.4022 14.5 14.0155V15C14.5 15.5523 14.0523 16 13.5 16H10.5C9.94772 16 9.5 15.5523 9.5 15V14.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-s-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.5 9.25V9C14.5 8.44772 14.0523 8 13.5 8H10.5C9.94772 8 9.5 8.44772 9.5 9V9.98445C9.5 10.5978 9.87343 11.1494 10.4429 11.3772L13.5571 12.6228C14.1266 12.8506 14.5 13.4022 14.5 14.0155V15C14.5 15.5523 14.0523 16 13.5 16H10.5C9.94772 16 9.5 15.5523 9.5 15V14.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-s-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.5 9.25V9C14.5 8.44772 14.0523 8 13.5 8H10.5C9.94772 8 9.5 8.44772 9.5 9V9.98445C9.5 10.5978 9.87343 11.1494 10.4429 11.3772L13.5571 12.6228C14.1266 12.8506 14.5 13.4022 14.5 14.0155V15C14.5 15.5523 14.0523 16 13.5 16H10.5C9.94772 16 9.5 15.5523 9.5 15V14.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-s-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.5 9.25V9C14.5 8.44772 14.0523 8 13.5 8H10.5C9.94772 8 9.5 8.44772 9.5 9V9.98445C9.5 10.5978 9.87343 11.1494 10.4429 11.3772L13.5571 12.6228C14.1266 12.8506 14.5 13.4022 14.5 14.0155V15C14.5 15.5523 14.0523 16 13.5 16H10.5C9.94772 16 9.5 15.5523 9.5 15V14.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-t' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 7H11.75M11.75 7H15.5M11.75 7V17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-t-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 8.25H12M12 8.25H15M12 8.25V16.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-t-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.25H12M12 8.25H15M12 8.25V16.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-t-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.25H12M12 8.25H15M12 8.25V16.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-t-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.25H12M12 8.25H15M12 8.25V16.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-t-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.25H12M12 8.25H15M12 8.25V16.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-t-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.25H12M12 8.25H15M12 8.25V16.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-u' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 7V14.5C8 15.8807 9.11929 17 10.5 17H13C14.3807 17 15.5 15.8807 15.5 14.5V7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-u-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 8V14C9 15.1046 9.89543 16 11 16H13C14.1046 16 15 15.1046 15 14V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-u-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8V14C9 15.1046 9.89543 16 11 16H13C14.1046 16 15 15.1046 15 14V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-u-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8V14C9 15.1046 9.89543 16 11 16H13C14.1046 16 15 15.1046 15 14V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-u-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8V14C9 15.1046 9.89543 16 11 16H13C14.1046 16 15 15.1046 15 14V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-u-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8V14C9 15.1046 9.89543 16 11 16H13C14.1046 16 15 15.1046 15 14V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-u-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8V14C9 15.1046 9.89543 16 11 16H13C14.1046 16 15 15.1046 15 14V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-v' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 7L11.75 17L15.5 7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-v-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 8.25L12 16.25L15 8.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-v-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.25L12 16.25L15 8.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-v-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.25L12 16.25L15 8.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-v-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.25L12 16.25L15 8.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-v-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.25L12 16.25L15 8.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-v-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.25L12 16.25L15 8.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-w' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 7V17L11.75 12L15.5 17V7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-w-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 8V16L12 12L15 16V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-w-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8V16L12 12L15 16V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-w-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8V16L12 12L15 16V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-w-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8V16L12 12L15 16V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-w-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8V16L12 12L15 16V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-w-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8V16L12 12L15 16V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 7L15.5 17M8 17L15.5 7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-x-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 8L15 16M9 16L15 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-x-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8L15 16M9 16L15 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-x-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8L15 16M9 16L15 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-x-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8L15 16M9 16L15 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-x-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8L15 16M9 16L15 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-x-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8L15 16M9 16L15 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-y' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 7L11.75 12M15.5 7L11.75 12M11.75 12V17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-y-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 8.25L12 12.25M15 8.25L12 12.25M12 12.25V16.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-y-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.25L12 12.25M15 8.25L12 12.25M12 12.25V16.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-y-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.25L12 12.25M15 8.25L12 12.25M12 12.25V16.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-y-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.25L12 12.25M15 8.25L12 12.25M12 12.25V16.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-y-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.25L12 12.25M15 8.25L12 12.25M12 12.25V16.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-y-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8.25L12 12.25M15 8.25L12 12.25M12 12.25V16.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-z' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 7H15.5L8 17H15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-z-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 8H15L9 16H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-z-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8H15L9 16H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-z-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8H15L9 16H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-z-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8H15L9 16H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-z-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8H15L9 16H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'letter-z-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 8H15L9 16H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'lightning' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.7479 3.57181C12.8067 3.06921 12.2161 2.79505 11.9129 3.18416L4.11084 13.197C3.8534 13.5274 4.07308 14.029 4.47521 14.029H11.4627C11.748 14.029 11.9687 14.2964 11.9334 14.5992L11.2521 20.4282C11.1933 20.9308 11.7839 21.205 12.0871 20.8158L19.8892 10.803C20.1466 10.4726 19.9269 9.971 19.5248 9.971H12.5373C12.252 9.971 12.0313 9.70359 12.0666 9.40084L12.7479 3.57181Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'lightning-slash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 21L9.971 14.029M21 3L14.029 9.97101M9.971 14.029H11.4628C11.748 14.029 11.9688 14.2964 11.9334 14.5992L11.2521 20.4282C11.1933 20.9308 11.7839 21.205 12.0871 20.8158L19.8892 10.803C20.1466 10.4726 19.927 9.97101 19.5248 9.97101H14.029M9.971 14.029L14.029 9.97101M5.5 14.029H4.47525C4.07311 14.029 3.85344 13.5274 4.11088 13.197L11.913 3.18417C12.2162 2.79505 12.8067 3.06922 12.748 3.57182L12.2889 7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'like' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.5401 10.1053H20.0725C22.6187 10.1053 19.3088 21 17.4853 21H4.96368C4.43146 21 4 20.5759 4 20.0526V10.6677C4 10.321 4.19263 10.002 4.50222 9.83597C6.56386 8.73047 8.98325 7.82418 10.1796 5.70706L11.4604 3.44073C11.6141 3.16871 11.9058 3 12.2223 3C15.4023 3 14.4589 7.62979 14.0267 9.47076C13.9505 9.79538 14.2013 10.1053 14.5401 10.1053Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'line-chart-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 10L12.5 13.5L10.5 11.5L8 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'line-chart-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 10L12.5 13.5L10.5 11.5L8 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'line-chart-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 10L12.5 13.5L10.5 11.5L8 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'line-chart-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 10L12.5 13.5L10.5 11.5L8 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'line-chart-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 10L12.5 13.5L10.5 11.5L8 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'link' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.9883 13L19.8903 9.09801C21.327 7.66132 21.375 5.38003 19.9975 4.00253C18.62 2.62504 16.3387 2.67302 14.902 4.10969L11 8.01167" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13 15.9617L9.10836 19.8428C7.67553 21.2718 5.46884 21.4569 4.0264 19.9494C2.58401 18.4419 2.70043 16.3101 4.13327 14.8811L8.02491 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 15L15 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'link-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.9355 8.32412L15.3164 3.93944C16.592 2.66272 18.6883 2.69084 19.9986 4.00226C21.3089 5.31365 21.337 7.41178 20.0614 8.68848L16.2579 12.4952" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.74211 11.5046L3.93863 15.3114C2.663 16.5882 2.69113 18.6862 4.00138 19.9977C5.31167 21.3091 7.40793 21.3372 8.68357 20.0605L13.0645 15.6758" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.9984 13.0105C9.68693 11.699 9.65882 9.60096 10.9355 8.32422" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.0635 10.9268C14.3749 12.2382 14.403 14.3363 13.1263 15.613" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'link-two' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 15.5L17.4 15.5C19.3883 15.5 21 13.933 21 12C21 10.067 19.3882 8.50003 17.4 8.5L14 8.50002" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 15.5L6.60333 15.4926C4.61637 15.4899 2.95572 14.0673 3.0009 11.9914C3.04611 9.91551 4.60705 8.49728 6.59401 8.5L9.99068 8.50739" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.75732 12H16.2426" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'list' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 6.5H20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 12H20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 17.5H20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4 6.5H5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4 12H5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4 17.5H5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'list-number' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11 17.5H21M11 12H21M11 6.5H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.5 15.4549V15.2811C3.5 14.5045 4.17157 13.8749 5 13.8749H5.04054C5.84658 13.8749 6.50021 14.4875 6.50021 15.2431C6.50021 15.5721 6.3862 15.8923 6.17568 16.1554L3.5 19.5L6.5 19.4998M3.5 5.43749L5.5 4.5V10.1249" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'location' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.5599 20.8207C12.2247 21.0598 11.7753 21.0598 11.4401 20.8207C6.61138 17.3773 1.48557 10.2971 6.6667 5.18128C8.08118 3.78463 9.99963 3 12 3C14.0004 3 15.9188 3.78463 17.3333 5.18128C22.5144 10.2971 17.3886 17.3773 12.5599 20.8207Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 12C13.1046 12 14 11.1046 14 10C14 8.89543 13.1046 8 12 8C10.8954 8 10 8.89543 10 10C10 11.1046 10.8954 12 12 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'location-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.5599 20.8207C12.2247 21.0598 11.7753 21.0598 11.4401 20.8207C6.61138 17.3773 1.48557 10.2971 6.6667 5.18128C8.08118 3.78463 9.99963 3 12 3C14.0004 3 15.9188 3.78463 17.3333 5.18128C22.5144 10.2971 17.3886 17.3773 12.5599 20.8207Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.6001 10.3225L10.9787 11.898C11.1051 12.0425 11.3331 12.0319 11.4455 11.8762L14.245 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'location-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.5599 20.8207C12.2247 21.0598 11.7753 21.0598 11.4401 20.8207C6.61138 17.3773 1.48557 10.2971 6.6667 5.18128C8.08118 3.78463 9.99963 3 12 3C14.0004 3 15.9188 3.78463 17.3333 5.18128C22.5144 10.2971 17.3886 17.3773 12.5599 20.8207Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'location-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.5599 20.8207C12.2247 21.0598 11.7753 21.0598 11.4401 20.8207C6.61138 17.3773 1.48557 10.2971 6.6667 5.18128C8.08118 3.78463 9.99963 3 12 3C14.0004 3 15.9188 3.78463 17.3333 5.18128C22.5144 10.2971 17.3886 17.3773 12.5599 20.8207Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 7.5L12 12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'location-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.5599 20.8207C12.2247 21.0598 11.7753 21.0598 11.4401 20.8207C6.61138 17.3773 1.48557 10.2971 6.6667 5.18128C8.08118 3.78463 9.99963 3 12 3C14.0004 3 15.9188 3.78463 17.3333 5.18128C22.5144 10.2971 17.3886 17.3773 12.5599 20.8207Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 8L14 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 8L10 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'lock' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 10V8C8 5.23857 9.2386 3 12 3C14.7614 3 16 5.23857 16 8V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.5 17.8005V13.2005C3.5 12.0804 3.5 11.5203 3.71799 11.0925C3.90973 10.7162 4.21569 10.4102 4.59202 10.2185C5.01984 10.0005 5.57989 10.0005 6.7 10.0005H17.3C18.4201 10.0005 18.9802 10.0005 19.408 10.2185C19.7843 10.4102 20.0903 10.7162 20.282 11.0925C20.5 11.5203 20.5 12.0804 20.5 13.2005V17.8005C20.5 18.9206 20.5 19.4806 20.282 19.9085C20.0903 20.2848 19.7843 20.5908 19.408 20.7825C18.9802 21.0005 18.4201 21.0005 17.3 21.0005H6.7C5.5799 21.0005 5.01984 21.0005 4.59202 20.7825C4.21569 20.5908 3.90973 20.2848 3.71799 19.9085C3.5 19.4806 3.5 18.9206 3.5 17.8005Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'lock-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.0042 10.9465V8.92508C14.0042 6.28385 9.99576 6.43386 9.99576 8.92508V10.9465M9.00212 10.9465H14.9979C15.5513 10.9465 16 11.399 16 11.9572V14.9893C16 15.5475 15.5513 16 14.9979 16H9.00212C8.44867 16 8 15.5475 8 14.9893V11.9572C8 11.399 8.44867 10.9465 9.00212 10.9465Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'lock-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.0042 10.9465V8.92508C14.0042 6.28385 9.99576 6.43386 9.99576 8.92508V10.9465M9.00212 10.9465H14.9979C15.5513 10.9465 16 11.399 16 11.9572V14.9893C16 15.5475 15.5513 16 14.9979 16H9.00212C8.44867 16 8 15.5475 8 14.9893V11.9572C8 11.399 8.44867 10.9465 9.00212 10.9465Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'lock-keyhole' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 10V8C8 5.23857 9.2386 3 12 3C14.7614 3 16 5.23857 16 8V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.5 17.8005V13.2005C3.5 12.0804 3.5 11.5203 3.71799 11.0925C3.90973 10.7162 4.21569 10.4102 4.59202 10.2185C5.01984 10.0005 5.57989 10.0005 6.7 10.0005H17.3C18.4201 10.0005 18.9802 10.0005 19.408 10.2185C19.7843 10.4102 20.0903 10.7162 20.282 11.0925C20.5 11.5203 20.5 12.0804 20.5 13.2005V17.8005C20.5 18.9206 20.5 19.4806 20.282 19.9085C20.0903 20.2848 19.7843 20.5908 19.408 20.7825C18.9802 21.0005 18.4201 21.0005 17.3 21.0005H6.7C5.5799 21.0005 5.01984 21.0005 4.59202 20.7825C4.21569 20.5908 3.90973 20.2848 3.71799 19.9085C3.5 19.4806 3.5 18.9206 3.5 17.8005Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 14.0005V17.0005" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'lock-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.0042 10.9465V8.92508C14.0042 6.28385 9.99576 6.43386 9.99576 8.92508V10.9465M9.00212 10.9465H14.9979C15.5513 10.9465 16 11.399 16 11.9572V14.9893C16 15.5475 15.5513 16 14.9979 16H9.00212C8.44867 16 8 15.5475 8 14.9893V11.9572C8 11.399 8.44867 10.9465 9.00212 10.9465Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'lock-open' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 10V8C8 5.23857 9.2386 3 12 3C14.0943 3 15.3127 4.28767 15.7792 6.11449" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.5 17.8005V13.2005C3.5 12.0804 3.5 11.5203 3.71799 11.0925C3.90973 10.7162 4.21569 10.4102 4.59202 10.2185C5.01984 10.0005 5.5799 10.0005 6.7 10.0005H17.3C18.4201 10.0005 18.9802 10.0005 19.408 10.2185C19.7843 10.4102 20.0903 10.7162 20.282 11.0925C20.5 11.5203 20.5 12.0804 20.5 13.2005V17.8005C20.5 18.9206 20.5 19.4806 20.282 19.9085C20.0903 20.2848 19.7843 20.5908 19.408 20.7825C18.9802 21.0005 18.4201 21.0005 17.3 21.0005H6.7C5.5799 21.0005 5.01984 21.0005 4.59202 20.7825C4.21569 20.5908 3.90973 20.2848 3.71799 19.9085C3.5 19.4806 3.5 18.9206 3.5 17.8005Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'lock-open-password' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 10V8C8 5.23857 9.2386 3 12 3C14.0943 3 15.3127 4.28767 15.7792 6.11449" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.5 17.8005V13.2005C3.5 12.0804 3.5 11.5203 3.71799 11.0925C3.90973 10.7162 4.21569 10.4102 4.59202 10.2185C5.01984 10.0005 5.5799 10.0005 6.7 10.0005H17.3C18.4201 10.0005 18.9802 10.0005 19.408 10.2185C19.7843 10.4102 20.0903 10.7162 20.282 11.0925C20.5 11.5203 20.5 12.0804 20.5 13.2005V17.8005C20.5 18.9206 20.5 19.4806 20.282 19.9085C20.0903 20.2848 19.7843 20.5908 19.408 20.7825C18.9802 21.0005 18.4201 21.0005 17.3 21.0005H6.7C5.5799 21.0005 5.01984 21.0005 4.59202 20.7825C4.21569 20.5908 3.90973 20.2848 3.71799 19.9085C3.5 19.4806 3.5 18.9206 3.5 17.8005Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 15.75V15.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 15.75V15.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 15.75V15.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'lock-password' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 10V8C8 5.23857 9.2386 3 12 3C14.7614 3 16 5.23857 16 8V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.5 17.8005V13.2005C3.5 12.0804 3.5 11.5203 3.71799 11.0925C3.90973 10.7162 4.21569 10.4102 4.59202 10.2185C5.01984 10.0005 5.57989 10.0005 6.7 10.0005H17.3C18.4201 10.0005 18.9802 10.0005 19.408 10.2185C19.7843 10.4102 20.0903 10.7162 20.282 11.0925C20.5 11.5203 20.5 12.0804 20.5 13.2005V17.8005C20.5 18.9206 20.5 19.4806 20.282 19.9085C20.0903 20.2848 19.7843 20.5908 19.408 20.7825C18.9802 21.0005 18.4201 21.0005 17.3 21.0005H6.7C5.5799 21.0005 5.01984 21.0005 4.59202 20.7825C4.21569 20.5908 3.90973 20.2848 3.71799 19.9085C3.5 19.4806 3.5 18.9206 3.5 17.8005Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 15.75V15.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 15.75V15.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 15.75V15.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'lock-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.0042 10.9465V8.92508C14.0042 6.28385 9.99576 6.43386 9.99576 8.92508V10.9465M9.00212 10.9465H14.9979C15.5513 10.9465 16 11.399 16 11.9572V14.9893C16 15.5475 15.5513 16 14.9979 16H9.00212C8.44867 16 8 15.5475 8 14.9893V11.9572C8 11.399 8.44867 10.9465 9.00212 10.9465Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'lock-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.0042 10.9465V8.92508C14.0042 6.28385 9.99576 6.43386 9.99576 8.92508V10.9465M9.00212 10.9465H14.9979C15.5513 10.9465 16 11.399 16 11.9572V14.9893C16 15.5475 15.5513 16 14.9979 16H9.00212C8.44867 16 8 15.5475 8 14.9893V11.9572C8 11.399 8.44867 10.9465 9.00212 10.9465Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'login' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.4958 21H6.5C5.39543 21 4.5 19.8487 4.5 18.4286V5.57143C4.5 4.15127 5.39543 3 6.5 3H13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13 15.5L9.5 12L13 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.5 11.9958H9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'logout' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.4958 21H6.5C5.39543 21 4.5 19.8487 4.5 18.4286V5.57143C4.5 4.15127 5.39543 3 6.5 3H13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 15.5L19.5 12L16 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 11.9958H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'magnet' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 7.5V12C3 16.9706 7.02944 21 12 21C16.9706 21 21 16.9706 21 12V7.5M3 7.5V5C3 3.89543 3.89543 3 5 3H6.625C7.72957 3 8.625 3.89543 8.625 5V7.5M3 7.5H8.625M8.625 7.5V12C8.625 13.864 10.136 15.375 12 15.375C13.864 15.375 15.375 13.864 15.375 12V7.5M15.375 7.5V5C15.375 3.89543 16.2704 3 17.375 3H19C20.1046 3 21 3.89543 21 5V7.5M15.375 7.5H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'male' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.2323 9.74707C13.1474 8.66733 11.6516 8 10 8C6.68629 8 4 10.6863 4 14C4 17.3137 6.68629 20 10 20C13.3137 20 16 17.3137 16 14C16 12.3379 15.3242 10.8337 14.2323 9.74707ZM14.2323 9.74707L20 4M20 4H16M20 4V8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'map' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 8.59281C3 7.06611 3 6.30276 3.39264 5.85754C3.53204 5.69947 3.70147 5.57294 3.89029 5.48591C5.30646 4.83316 7.1618 6.55172 8.6591 6.49875C8.85714 6.49174 9.05401 6.46443 9.24685 6.4172C11.4307 5.88236 12.7985 3.33791 15.0451 3.02621C16.3323 2.8476 17.7448 3.62544 18.9487 4.04119C19.9387 4.38311 20.4337 4.55406 20.7169 4.96107C21 5.36807 21 5.90868 21 6.98991V15.4115C21 16.9382 21 17.7015 20.6074 18.1468C20.468 18.3048 20.2985 18.4313 20.1097 18.5184C18.6935 19.1711 16.8382 17.4526 15.3409 17.5055C15.1429 17.5125 14.946 17.5399 14.7532 17.5871C12.5693 18.1219 11.2015 20.6664 8.95493 20.9781C7.67358 21.1559 4.1077 20.2285 3.28314 19.0432C3 18.6362 3 18.0956 3 17.0144V8.59281Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 6.54126V20.7963" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 3.18115V17.4362" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'mask' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.7 8.76923L10.8751 7.25271C11.6096 7.03748 12.3904 7.03748 13.1249 7.25271L18.3 8.76923M5.7 8.76923V7.35C5.7 6.60442 5.09558 6 4.35 6C3.60442 6 3 6.60441 3 7.35V9.53846C3 10.643 3.89543 11.5385 5 11.5385H5.7M5.7 8.76923V11.5385M18.3 8.76923V11.5385M18.3 8.76923V7.35C18.3 6.60441 18.9044 6 19.65 6C20.3956 6 21 6.60442 21 7.35V9.53846C21 10.643 20.1046 11.5385 19 11.5385H18.3M18.3 11.5385V11.7C18.3 15.1794 15.4794 18 12 18C8.52061 18 5.7 15.1794 5.7 11.7V11.5385" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'math' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.42857 18.3659H9.42857M15 8.70732H21M15 4.31707H21M3 6.5122H6.42857M6.42857 6.5122H9.85714M6.42857 6.5122V3M6.42857 6.5122V10.0244M15.6002 21L18.0247 18.5163M18.0247 18.5163L20.4489 16.033M18.0247 18.5163L15.6002 16.0327M18.0247 18.5163L20.4489 20.9997" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'math-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7 15.625H10.5M13.75 10.125H17.25M13.75 7.625H17.25M6.75 8.875H8.75M8.75 8.875H10.75M8.75 8.875V6.875M8.75 8.875V10.875M14.1001 17.125L15.5144 15.7107M15.5144 15.7107L16.9285 14.2966M15.5144 15.7107L14.1001 14.2964M15.5144 15.7107L16.9285 17.1248" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'maximize' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.00977 9.74999C3.05012 6.96048 3.25704 5.37898 4.31801 4.31801C5.37898 3.25704 6.96048 3.05012 9.74999 3.00977" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.00977 14.2598C3.05012 17.0493 3.25704 18.6308 4.31801 19.6917C5.37898 20.7527 6.96048 20.9596 9.74999 21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 9.74999C20.9596 6.96048 20.7527 5.37898 19.6917 4.31801C18.6308 3.25704 17.0493 3.05012 14.2598 3.00977" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 14.2598C20.9596 17.0493 20.7527 18.6308 19.6917 19.6917C18.6308 20.7527 17.0493 20.9596 14.2598 21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'maximize-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 4H20V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 20H4V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20 4L14 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4 20L10 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'menu' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.5 6.5H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4.5 12H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4.5 17.5H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'message' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.46447 16.8284C2 15.6569 2 14.7712 2 11C2 7.22876 2 5.34315 3.46447 4.17157C4.92893 3 7.28595 3 12 3C16.714 3 19.0711 3 20.5355 4.17157C22 5.34315 22 7.22876 22 11C22 14.7712 22 15.6569 20.5355 16.8284C19.0711 18 16.714 18 12 18C9.49052 18 8.19973 19.7375 6 21V17.7883C4.90606 17.6255 4.10096 17.3376 3.46447 16.8284Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'message-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.7002 10.8225L11.0788 12.398C11.2052 12.5425 11.4332 12.5319 11.5456 12.3762L14.3451 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.46447 16.8284C2 15.6569 2 14.7712 2 11C2 7.22876 2 5.34315 3.46447 4.17157C4.92893 3 7.28595 3 12 3C16.714 3 19.0711 3 20.5355 4.17157C22 5.34315 22 7.22876 22 11C22 14.7712 22 15.6569 20.5355 16.8284C19.0711 18 16.714 18 12 18C9.49052 18 8.19973 19.7375 6 21V17.7883C4.90606 17.6255 4.10096 17.3376 3.46447 16.8284Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'message-dots' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 11V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 11V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 11V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.46447 16.8284C2 15.6569 2 14.7712 2 11C2 7.22876 2 5.34315 3.46447 4.17157C4.92893 3 7.28595 3 12 3C16.714 3 19.0711 3 20.5355 4.17157C22 5.34315 22 7.22876 22 11C22 14.7712 22 15.6569 20.5355 16.8284C19.0711 18 16.714 18 12 18C9.49052 18 8.19973 19.7375 6 21V17.7883C4.90606 17.6255 4.10096 17.3376 3.46447 16.8284Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'message-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.46447 16.8284C2 15.6569 2 14.7712 2 11C2 7.22876 2 5.34315 3.46447 4.17157C4.92893 3 7.28595 3 12 3C16.714 3 19.0711 3 20.5355 4.17157C22 5.34315 22 7.22876 22 11C22 14.7712 22 15.6569 20.5355 16.8284C19.0711 18 16.714 18 12 18C9.49052 18 8.19973 19.7375 6 21V17.7883C4.90606 17.6255 4.10096 17.3376 3.46447 16.8284Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10.5H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'message-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 10.5H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8L12 13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.46447 16.8284C2 15.6569 2 14.7712 2 11C2 7.22876 2 5.34315 3.46447 4.17157C4.92893 3 7.28595 3 12 3C16.714 3 19.0711 3 20.5355 4.17157C22 5.34315 22 7.22876 22 11C22 14.7712 22 15.6569 20.5355 16.8284C19.0711 18 16.714 18 12 18C9.49052 18 8.19973 19.7375 6 21V17.7883C4.90606 17.6255 4.10096 17.3376 3.46447 16.8284Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'message-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 8.5L14 12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 8.5L10 12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.46447 16.8284C2 15.6569 2 14.7712 2 11C2 7.22876 2 5.34315 3.46447 4.17157C4.92893 3 7.28595 3 12 3C16.714 3 19.0711 3 20.5355 4.17157C22 5.34315 22 7.22876 22 11C22 14.7712 22 15.6569 20.5355 16.8284C19.0711 18 16.714 18 12 18C9.49052 18 8.19973 19.7375 6 21V17.7883C4.90606 17.6255 4.10096 17.3376 3.46447 16.8284Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'microphone' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16 6.42857C16 4.53502 14.2091 3 12 3C9.79086 3 8 4.53502 8 6.42857V11.5714C8 13.465 9.79086 15 12 15C14.2091 15 16 13.465 16 11.5714V6.42857Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5 11C5 14.866 8.134 18 12 18C15.866 18 19 14.866 19 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 18V21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 21H16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'microphone-slash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 18V21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 21H16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 11.5714V6.42857C8 4.53502 9.79086 3 12 3C13.3086 3 14.4704 3.5386 15.2002 4.37127M5 11C5 12.0463 5.22955 13.039 5.64103 13.9304M19 11C19 14.866 15.866 18 12 18C10.3217 18 8.7813 17.4094 7.57542 16.4246M3 21L7.57542 16.4246M21 3L16 8M16 8V11.5714C16 13.465 14.2091 15 12 15C11.1229 15 10.3117 14.758 9.65233 14.3477M16 8L9.65233 14.3477M9.65233 14.3477L7.57542 16.4246" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'minimize' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.74999 3.00977C9.70963 5.79928 9.50272 7.38077 8.44175 8.44175C7.38077 9.50272 5.79928 9.70963 3.00977 9.74999" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.74999 21C9.70963 18.2105 9.50272 16.629 8.44175 15.568C7.38077 14.507 5.79928 14.3001 3.00977 14.2598" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.2598 3.00977C14.3001 5.79928 14.507 7.38077 15.568 8.44175C16.629 9.50272 18.2105 9.70963 21 9.74999" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.2598 21C14.3001 18.2105 14.507 16.629 15.568 15.568C16.629 14.507 18.2105 14.3001 21 14.2598" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'minimize-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20 10H14V4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4 14H10V20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20 4L14 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 14L4 20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6 12H18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'minus-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.5 12H15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'minus-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.5 12H15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'minus-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.5 12H15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'minus-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.5 12H15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'minus-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.5 12H15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'mobile' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.2857 3H7.71429C6.76751 3 6 3.80589 6 4.8V19.2C6 20.1941 6.76751 21 7.71429 21H16.2857C17.2325 21 18 20.1941 18 19.2V4.8C18 3.80589 17.2325 3 16.2857 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.5 6H13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'mobile-signal-five' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 21V20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 21L21 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 21L12 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.5 21L16.5 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.5 21L7.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'mobile-signal-four' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 21V20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 21L12 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.5 21L16.5 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.5 21L7.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'mobile-signal-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 21V20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'mobile-signal-three' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 21V20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 21L12 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.5 21L7.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'mobile-signal-two' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 21V20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.5 21L7.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'moon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 12.808C20.4992 18.1548 15.1513 21.9483 9.89256 20.7915C-0.0763974 18.5985 1.14983 3.90821 11.1116 3C6.39428 9.29614 14.618 17.4619 21 12.808Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'mountain' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.0056 15.2654L15.1235 12.1259M15.1235 12.1259L15.374 11.7546C16.1011 10.6767 17.6814 10.806 18.2355 11.9888L20.8315 17.5302C21.3666 18.6724 20.5619 20 19.3344 20H4.66556C3.44173 20 2.63686 18.6797 3.16476 17.5381L8.97288 4.97806C9.58216 3.66049 11.4021 3.678 11.9876 5.00706L15.1235 12.1259Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'mouse-pointer' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.8661 12.8661L18.4942 10.454C19.4363 10.0502 19.38 8.69609 18.4076 8.37197L5.4691 4.05913C4.59769 3.76866 3.76866 4.59769 4.05913 5.4691L8.37197 18.4076C8.69609 19.38 10.0502 19.4363 10.454 18.4942L12.8661 12.8661ZM12.8661 12.8661L20 20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'move' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.7 9.3L3 12M3 12L5.7 14.7M3 12H21M9.3 5.7L12 3M12 3L14.7 5.7M12 3V21M14.7 18.3L12 21M12 21L9.3 18.3M18.3 9.3L21 12M21 12L18.3 14.7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'move-diagonal' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13 5H19M19 5V11M19 5L5 19M11 19H5M5 19V13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'move-diagonal-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5 11V5M5 5H11M5 5L19 19M19 13V19M19 19H13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'move-horizontal' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 8L22 12M22 12L18 16M22 12H2M6 8L2 12M2 12L6 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'move-vertical' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 18L12 22M12 22L16 18M12 22V2M8 6L12 2M12 2L16 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'music' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.625 17.6506C8.625 19.2243 7.3658 20.5 5.8125 20.5C4.2592 20.5 3 19.2243 3 17.6506C3 16.077 4.2592 14.8013 5.8125 14.8013C7.3658 14.8013 8.625 16.077 8.625 17.6506ZM8.625 17.6506V5.46129C8.625 4.94142 9.01901 4.50723 9.5338 4.45982L19.9088 3.50427C20.4946 3.45032 21 3.91412 21 4.50574V16.5109M21 16.5109C21 18.0845 19.7408 19.3603 18.1875 19.3603C16.6342 19.3603 15.375 18.0845 15.375 16.5109C15.375 14.9372 16.6342 13.6615 18.1875 13.6615C19.7408 13.6615 21 14.9372 21 16.5109Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'music-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5 14.5V8.6C12.5 8.26863 12.7686 8 13.1 8H14.5M12.5 14.5C12.5 15.3284 11.8284 16 11 16C10.1716 16 9.5 15.3284 9.5 14.5C9.5 13.6716 10.1716 13 11 13C11.8284 13 12.5 13.6716 12.5 14.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'music-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5 14.5V8.6C12.5 8.26863 12.7686 8 13.1 8H14.5M12.5 14.5C12.5 15.3284 11.8284 16 11 16C10.1716 16 9.5 15.3284 9.5 14.5C9.5 13.6716 10.1716 13 11 13C11.8284 13 12.5 13.6716 12.5 14.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'music-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5 14.5V8.6C12.5 8.26863 12.7686 8 13.1 8H14.5M12.5 14.5C12.5 15.3284 11.8284 16 11 16C10.1716 16 9.5 15.3284 9.5 14.5C9.5 13.6716 10.1716 13 11 13C11.8284 13 12.5 13.6716 12.5 14.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'music-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5 14.5V8.6C12.5 8.26863 12.7686 8 13.1 8H14.5M12.5 14.5C12.5 15.3284 11.8284 16 11 16C10.1716 16 9.5 15.3284 9.5 14.5C9.5 13.6716 10.1716 13 11 13C11.8284 13 12.5 13.6716 12.5 14.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'music-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.5 14.5V8.6C12.5 8.26863 12.7686 8 13.1 8H14.5M12.5 14.5C12.5 15.3284 11.8284 16 11 16C10.1716 16 9.5 15.3284 9.5 14.5C9.5 13.6716 10.1716 13 11 13C11.8284 13 12.5 13.6716 12.5 14.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'myna' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.25 10.3466L3.95529 9.68726L5.36588 8.36867C7.58471 6.07698 11.168 6.07698 13.3693 8.36867L17.5968 12.3205C17.7186 12.4343 17.7186 12.6275 17.5968 12.7413L8.92682 20.8459" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'navigation' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.5398 3.33273C11.7102 2.88909 12.2898 2.88909 12.4602 3.33273L18.96 20.2494C19.1381 20.7128 18.6882 21.1663 18.2749 20.9399L12.2248 17.6249C12.0835 17.5474 11.9165 17.5474 11.7752 17.6249L5.72509 20.9399C5.31185 21.1663 4.86194 20.7128 5.04002 20.2494L11.5398 3.33273Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'navigation-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.41392 12.0861C2.91626 11.9617 2.84896 11.282 3.31255 11.0624L20.2178 3.05466C20.6817 2.83491 21.1651 3.31834 20.9453 3.78225L12.9376 20.6875C12.718 21.151 12.0383 21.0837 11.9139 20.5861L10.2934 14.1041C10.2445 13.9084 10.0916 13.7555 9.8959 13.7066L3.41392 12.0861Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'nine' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 17H11.25C13.3211 17 15 15.3211 15 13.25V10.125M15 10.125C15 8.39911 13.6009 7 11.875 7C10.1491 7 8.75 8.39911 8.75 10.125C8.75 11.8509 10.1491 12.625 11.875 12.625C13.6009 12.625 15 11.8509 15 10.125Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'nine-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.5 16H11.5C13.1569 16 14.5 14.6569 14.5 13V10.5M14.5 10.5C14.5 9.11929 13.3807 8 12 8C10.6193 8 9.5 9.11929 9.5 10.5C9.5 11.8807 10.6193 12.5 12 12.5C13.3807 12.5 14.5 11.8807 14.5 10.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'nine-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.5 16H11.5C13.1569 16 14.5 14.6569 14.5 13V10.5M14.5 10.5C14.5 9.11929 13.3807 8 12 8C10.6193 8 9.5 9.11929 9.5 10.5C9.5 11.8807 10.6193 12.5 12 12.5C13.3807 12.5 14.5 11.8807 14.5 10.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'nine-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.5 16H11.5C13.1569 16 14.5 14.6569 14.5 13V10.5M14.5 10.5C14.5 9.11929 13.3807 8 12 8C10.6193 8 9.5 9.11929 9.5 10.5C9.5 11.8807 10.6193 12.5 12 12.5C13.3807 12.5 14.5 11.8807 14.5 10.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'nine-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.5 16H11.5C13.1569 16 14.5 14.6569 14.5 13V10.5M14.5 10.5C14.5 9.11929 13.3807 8 12 8C10.6193 8 9.5 9.11929 9.5 10.5C9.5 11.8807 10.6193 12.5 12 12.5C13.3807 12.5 14.5 11.8807 14.5 10.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'nine-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.5 16H11.5C13.1569 16 14.5 14.6569 14.5 13V10.5M14.5 10.5C14.5 9.11929 13.3807 8 12 8C10.6193 8 9.5 9.11929 9.5 10.5C9.5 11.8807 10.6193 12.5 12 12.5C13.3807 12.5 14.5 11.8807 14.5 10.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'nine-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.5 16H11.5C13.1569 16 14.5 14.6569 14.5 13V10.5M14.5 10.5C14.5 9.11929 13.3807 8 12 8C10.6193 8 9.5 9.11929 9.5 10.5C9.5 11.8807 10.6193 12.5 12 12.5C13.3807 12.5 14.5 11.8807 14.5 10.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'notification' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="18.25" cy="5.75" r="2.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.4375 17V7L9 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'one-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.75 16V8L10 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'one-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.75 16V8L10 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'one-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.75 16V8L10 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'one-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.75 16V8L10 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'one-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.75 16V8L10 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'one-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.75 16V8L10 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'option' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 7H8.0941C8.42444 7 8.58892 7 8.73733 7.0474C8.86867 7.08934 8.99021 7.15798 9.09375 7.24902C9.21075 7.3519 9.29586 7.49359 9.46582 7.77686L14.5337 16.2232C14.7036 16.5065 14.7887 16.6479 14.9057 16.7508C15.0092 16.8419 15.1304 16.9107 15.2617 16.9526C15.41 17 15.5764 17 15.9062 17H21.0003M15 7H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'package' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 21L20.1314 16.7916C20.4469 16.6283 20.6047 16.5467 20.7198 16.4264C20.8217 16.32 20.899 16.1924 20.9464 16.0526C21 15.8945 21 15.7167 21 15.3611C21 13.6519 21 10.0684 21 7.53273M12 21L3.86859 16.7916C3.55308 16.6283 3.39532 16.5467 3.28016 16.4264C3.17831 16.32 3.10095 16.1924 3.05357 16.0526C3 15.8945 3 15.7159 3 15.3587V7.53273M12 21C12 21 12 15.4766 12 11.9374M21 7.53273C17.4853 9.25286 15.5147 10.2173 12 11.9374M21 7.53273C19.2426 6.62321 18.2574 6.11328 16.5 5.20376M3 7.53273L11.2686 3.25332C11.5365 3.11468 11.6704 3.04536 11.8112 3.0181C11.9359 2.99397 12.0641 2.99397 12.1888 3.0181C12.3296 3.04536 12.4632 3.11451 12.7304 3.25282C13.6662 3.73713 15.3093 4.58749 16.5 5.20376M3 7.53273C3 7.53273 5.74264 8.875 7.5 9.73506M12 11.9374C10.2426 11.0773 9.25736 10.5951 7.5 9.73506M7.5 9.73506C11.0147 7.96548 12.9853 6.97334 16.5 5.20376M7.5 9.73506C7.5 10.5951 7.5 11.0773 7.5 11.9374" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'paint' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.5 5.5H17.5C18.6046 5.5 19.5 5.89543 19.5 7V9C19.5 10.1046 18.6046 11 17.5 11H10.5C9.94772 11 9.5 11.4477 9.5 12V20C9.5 20.5523 9.94772 21 10.5 21H11.5M16.5 5.5V4C16.5 3.44772 16.0523 3 15.5 3H5.5C4.94772 3 4.5 3.44772 4.5 4V7C4.5 7.55228 4.94772 8 5.5 8H15.5C16.0523 8 16.5 7.55228 16.5 7V5.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'panel-bottom' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.5 15H20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'panel-bottom-close' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.5 15H20.5M15 8L12 11L9 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'panel-bottom-inactive' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 15H15M19 15H20.5M3.5 15H5M9 15H10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'panel-bottom-open' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.5 15H20.5M9 10L12 7L15 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'panel-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 3.5V20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'panel-left-close' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 3.5V20.5M16 15L13 12L16 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'panel-left-inactive' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 14V15M9 19V20.5M9 3.5V5M9 9V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'panel-left-open' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 3.5V20.5M14 9L17 12L14 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'panel-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 3.5V20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'panel-right-close' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 3.5V20.5M8 9L11 12L8 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'panel-right-inactive' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 14V15M15 19V20.5M15 3.5V5M15 9V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'panel-right-open' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 3.5V20.5M10 15L7 12L10 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'panel-top' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.5 9H20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'panel-top-close' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.5 9H20.5M9 16L12 13L15 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'panel-top-inactive' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14 9H15M19 9H20.5M3.5 9H5M9 9H10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'panel-top-open' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.5 9H20.5M15 14L12 17L9 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'paperclip' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.8457 10.2236L9.58427 4.69459C15.013 -0.543074 23.8299 7.53743 18.1803 12.9882L11.0681 19.8501C7.38436 23.4042 1.40147 17.921 5.23508 14.2223L12.245 7.45911C14.1838 5.58852 17.3327 8.47441 15.315 10.4211L9.49218 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'parking' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.5 15V12.6M10.5 12.6C10.8793 12.6 11.8654 12.6 12.7756 12.6C15.0748 12.6 15.0748 9 12.7756 9H10.5V12.6Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'password' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.5 9L10.5 15M10.5 9L13.5 15M9.75 12H14.25M6.75 9.00006L3.75 15.0001M3.75 9.00006L6.75 15.0001M3 12.0001H7.5M20.25 9.00006L17.25 15.0001M17.25 9.00006L20.25 15.0001M16.5 12.0001H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'path' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.12132 15.8787C7.57843 15.3358 6.82843 15 6 15C4.34315 15 3 16.3431 3 18C3 19.6569 4.34315 21 6 21C7.65685 21 9 19.6569 9 18C9 17.1716 8.66421 16.4216 8.12132 15.8787ZM8.12132 15.8787L15.8787 8.12132M15.8787 8.12132C16.4216 8.66421 17.1716 9 18 9C19.6569 9 21 7.65685 21 6C21 4.34315 19.6569 3 18 3C16.3431 3 15 4.34315 15 6C15 6.82843 15.3358 7.57843 15.8787 8.12132ZM15.8787 8.12132L15.8828 8.11719" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'pause' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 6.5H8C7.44772 6.5 7 6.94772 7 7.5V17.5C7 18.0523 7.44772 18.5 8 18.5H9C9.55228 18.5 10 18.0523 10 17.5V7.5C10 6.94772 9.55228 6.5 9 6.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.5 6.5H14.5C13.9477 6.5 13.5 6.94772 13.5 7.5V17.5C13.5 18.0523 13.9477 18.5 14.5 18.5H15.5C16.0523 18.5 16.5 18.0523 16.5 17.5V7.5C16.5 6.94772 16.0523 6.5 15.5 6.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'pause-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 9V15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 9V15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'pause-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 9V15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 9V15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'pause-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 9V15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 9V15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'pause-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 9V15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 9V15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'pause-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 9V15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 9V15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'pen' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.62966 7.62966L10.6357 10.6357M3.04172 4.34067L5.65812 13.4981C6.43598 16.2206 8.59094 18.0976 11.4224 18.0976C11.846 18.0976 12.2696 18.0465 12.6864 17.9501C13.0783 17.8595 13.4984 17.9486 13.7828 18.233L16.2421 20.6922C16.6524 21.1026 17.3177 21.1026 17.7281 20.6922L20.6922 17.7281C21.1026 17.3177 21.1026 16.6524 20.6922 16.2421L18.2368 13.7866C17.953 13.5029 17.8637 13.084 17.9528 12.6927C18.0473 12.2778 18.0976 11.8526 18.0976 11.4224C18.0976 8.59094 16.2206 6.43598 13.4981 5.65812L4.34067 3.04172C3.54806 2.81525 2.81525 3.54805 3.04172 4.34067Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'pencil' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.80087 20.199C8.28823 20.7119 7.59279 21 6.86764 21H3V17.1564C3 16.432 3.28753 15.7373 3.79944 15.2248M8.80087 20.199L3.79944 15.2248M8.80087 20.199L18.7742 10.2212M3.79944 15.2248L13.7826 5.22963M13.7826 5.22963L15.2088 3.80175C16.2762 2.73304 18.0081 2.73271 19.076 3.80102L20.2023 4.92782C21.2692 5.99518 21.2692 7.72521 20.2023 8.79258L18.7742 10.2212M13.7826 5.22963L18.7742 10.2212" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'percentage' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19 5L5 19M17.5 20C19.1667 20 20 19.1429 20 17C20 14.8571 19.1667 14 17.5 14C15.8333 14 15 14.8571 15 17C15 19.1429 15.8333 20 17.5 20ZM6.5 10C8.16667 10 9 9.14286 9 7C9 4.85714 8.16667 4 6.5 4C4.83333 4 4 4.85714 4 7C4 9.14286 4.83333 10 6.5 10Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'percentage-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.85355 9.85355L9.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5035 14.5035L14.1499 14.1499" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 14.5L14.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'percentage-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.85355 9.85355L9.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5035 14.5035L14.1499 14.1499" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 14.5L14.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'percentage-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.85355 9.85355L9.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5035 14.5035L14.1499 14.1499" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 14.5L14.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'percentage-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.85355 9.85355L9.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5035 14.5035L14.1499 14.1499" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 14.5L14.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'percentage-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.85355 9.85355L9.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5035 14.5035L14.1499 14.1499" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 14.5L14.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'pin' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 21L7.63072 16.3688M7.63489 16.3645C7.3722 16.1025 5.89858 14.6285 4.85508 13.5847C3.90112 12.6304 4.86107 10.5879 6.16529 10.5056C7.34328 10.4313 10.0698 10.8582 10.9765 9.95138L13.4664 7.46124C14.0843 6.84324 13.6922 5.46085 13.6516 4.69857C13.5942 3.68269 15.2097 2.42781 16.0666 3.28484L20.7143 7.93299C21.574 8.79055 20.3148 10.402 19.3007 10.3482C18.5385 10.3076 17.1562 9.91551 16.5383 10.5335L14.0484 13.0237C13.1419 13.9303 13.5686 16.6562 13.4943 17.8341C13.4119 19.1386 11.3688 20.0988 10.4147 19.1446C9.37118 18.101 7.89757 16.6272 7.63489 16.3645Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'pizza' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.23394 16.9248C6.99498 14.3988 8.36958 12.1005 10.235 10.235C12.1005 8.36958 14.3988 6.99498 16.9248 6.23394M7.58072 7.58072C9.6425 5.51893 12.1531 3.9696 14.9104 3.05025C15.4472 2.87128 16.0137 3.18733 16.1763 3.72926L20.9546 19.6572C21.1931 20.452 20.452 21.1931 19.6572 20.9546L3.72926 16.1763C3.18733 16.0137 2.87128 15.4472 3.05025 14.9104C3.9696 12.1531 5.51893 9.6425 7.58072 7.58072Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11 15L11.3536 15.3536" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 11L15.3536 11.3536" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 16L16.3536 16.3536" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'planet' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.7215 17.7767C9.00169 18.853 10.6455 19.5 12.4383 19.5C16.5227 19.5 19.8336 16.1421 19.8336 12C19.8336 11.4665 19.7787 10.946 19.6743 10.4441M7.7215 17.7767C6.08525 16.401 5.04304 14.3239 5.04304 12C5.04304 7.85786 8.35403 4.5 12.4383 4.5C15.9966 4.5 18.9679 7.04862 19.6743 10.4441M7.7215 17.7767C9.52922 17.3576 11.6798 16.4839 13.8489 15.2138C16.3729 13.736 18.4259 12.0117 19.6743 10.4441M7.7215 17.7767C5.47594 18.2973 3.75946 18.1165 3.19377 17.1229C2.6111 16.0993 3.37556 14.4346 5.04291 12.6647M19.6743 10.4441C20.8315 8.99101 21.2974 7.67255 20.8062 6.80976C20.3081 5.93485 18.9179 5.69005 17.06 5.99933" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'play' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.5814 9.40221C16.1938 10.7175 17 11.3752 17 12.5C17 13.6248 16.1938 14.2825 14.5814 15.5978C14.1363 15.9609 13.6948 16.3028 13.2892 16.5876C12.9333 16.8375 12.5302 17.096 12.1129 17.3498C10.5043 18.328 9.69999 18.8171 8.97862 18.2756C8.25725 17.7341 8.19169 16.6005 8.06057 14.3332C8.02349 13.6921 8 13.0635 8 12.5C8 11.9365 8.02349 11.308 8.06057 10.6668C8.19169 8.39953 8.25725 7.26591 8.97862 6.7244C9.69999 6.18288 10.5043 6.67198 12.1129 7.65019C12.5302 7.90395 12.9333 8.16246 13.2892 8.41238C13.6948 8.69725 14.1363 9.03911 14.5814 9.40221Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'play-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.2423 10.7093C13.9141 11.2573 14.25 11.5313 14.25 12C14.25 12.4687 13.9141 12.7427 13.2423 13.2907C13.0568 13.442 12.8729 13.5845 12.7038 13.7032C12.5555 13.8073 12.3876 13.915 12.2137 14.0208C11.5435 14.4283 11.2083 14.6321 10.9078 14.4065C10.6072 14.1809 10.5799 13.7085 10.5252 12.7638C10.5098 12.4967 10.5 12.2348 10.5 12C10.5 11.7652 10.5098 11.5033 10.5252 11.2362C10.5799 10.2915 10.6072 9.81913 10.9078 9.5935C11.2083 9.36787 11.5435 9.57166 12.2137 9.97924C12.3876 10.085 12.5555 10.1927 12.7038 10.2968C12.8729 10.4155 13.0568 10.558 13.2423 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'play-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.2423 10.7093C13.9141 11.2573 14.25 11.5313 14.25 12C14.25 12.4687 13.9141 12.7427 13.2423 13.2907C13.0568 13.442 12.8729 13.5845 12.7038 13.7032C12.5555 13.8073 12.3876 13.915 12.2137 14.0208C11.5435 14.4283 11.2083 14.6321 10.9078 14.4065C10.6072 14.1809 10.5799 13.7085 10.5252 12.7638C10.5098 12.4967 10.5 12.2348 10.5 12C10.5 11.7652 10.5098 11.5033 10.5252 11.2362C10.5799 10.2915 10.6072 9.81913 10.9078 9.5935C11.2083 9.36787 11.5435 9.57166 12.2137 9.97924C12.3876 10.085 12.5555 10.1927 12.7038 10.2968C12.8729 10.4155 13.0568 10.558 13.2423 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'play-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.2423 10.7093C13.9141 11.2573 14.25 11.5313 14.25 12C14.25 12.4687 13.9141 12.7427 13.2423 13.2907C13.0568 13.442 12.8729 13.5845 12.7038 13.7032C12.5555 13.8073 12.3876 13.915 12.2137 14.0208C11.5435 14.4283 11.2083 14.6321 10.9078 14.4065C10.6072 14.1809 10.5799 13.7085 10.5252 12.7638C10.5098 12.4967 10.5 12.2348 10.5 12C10.5 11.7652 10.5098 11.5033 10.5252 11.2362C10.5799 10.2915 10.6072 9.81913 10.9078 9.5935C11.2083 9.36787 11.5435 9.57166 12.2137 9.97924C12.3876 10.085 12.5555 10.1927 12.7038 10.2968C12.8729 10.4155 13.0568 10.558 13.2423 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'play-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.2423 10.7093C13.9141 11.2573 14.25 11.5313 14.25 12C14.25 12.4687 13.9141 12.7427 13.2423 13.2907C13.0568 13.442 12.8729 13.5845 12.7038 13.7032C12.5555 13.8073 12.3876 13.915 12.2137 14.0208C11.5435 14.4283 11.2083 14.6321 10.9078 14.4065C10.6072 14.1809 10.5799 13.7085 10.5252 12.7638C10.5098 12.4967 10.5 12.2348 10.5 12C10.5 11.7652 10.5098 11.5033 10.5252 11.2362C10.5799 10.2915 10.6072 9.81913 10.9078 9.5935C11.2083 9.36787 11.5435 9.57166 12.2137 9.97924C12.3876 10.085 12.5555 10.1927 12.7038 10.2968C12.8729 10.4155 13.0568 10.558 13.2423 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'play-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.2423 10.7093C13.9141 11.2573 14.25 11.5313 14.25 12C14.25 12.4687 13.9141 12.7427 13.2423 13.2907C13.0568 13.442 12.8729 13.5845 12.7038 13.7032C12.5555 13.8073 12.3876 13.915 12.2137 14.0208C11.5435 14.4283 11.2083 14.6321 10.9078 14.4065C10.6072 14.1809 10.5799 13.7085 10.5252 12.7638C10.5098 12.4967 10.5 12.2348 10.5 12C10.5 11.7652 10.5098 11.5033 10.5252 11.2362C10.5799 10.2915 10.6072 9.81913 10.9078 9.5935C11.2083 9.36787 11.5435 9.57166 12.2137 9.97924C12.3876 10.085 12.5555 10.1927 12.7038 10.2968C12.8729 10.4155 13.0568 10.558 13.2423 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 12L12 12M12 12L6 12.0001M12 12L12 6M12 12L12 18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'plus-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.5 12L12 12M12 12L8.5 12M12 12L12 8.5M12 12L12 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'plus-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.5 12L12 12M12 12L8.5 12M12 12L12 8.5M12 12L12 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'plus-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.5 12L12 12M12 12L8.5 12M12 12L12 8.5M12 12L12 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'plus-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.5 12L12 12M12 12L8.5 12M12 12L12 8.5M12 12L12 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'plus-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.5 12L12 12M12 12L8.5 12M12 12L12 8.5M12 12L12 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'pokeball' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 14C13.1046 14 14 13.1046 14 12C14 10.8954 13.1046 10 12 10C10.8954 10 10 10.8954 10 12C10 13.1046 10.8954 14 12 14Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 12L21 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12L10 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'power' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17.9531 5.25C19.8215 6.89913 21 9.31195 21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 9.31195 4.17846 6.89913 6.04691 5.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 3V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'presentation' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 4H21M19.1 4V13.7778C19.1 14.2493 18.9104 14.7015 18.5728 15.0349C18.2352 15.3683 17.7774 15.5556 17.3 15.5556H6.7C6.22261 15.5556 5.76477 15.3683 5.42721 15.0349C5.08964 14.7015 4.9 14.2493 4.9 13.7778V4M7.5 20L12 15.5556L16.5 20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'printer' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19 10V5C19 4.44771 18.5523 4 18 4H6C5.4477 4 5 4.44771 5 5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20 10H4C3.44772 10 3 10.4477 3 11V19C3 19.5523 3.44772 20 4 20H20C20.5523 20 21 19.5523 21 19V11C21 10.4477 20.5523 10 20 10Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17.5 20V17C17.5 16.4477 17.0523 16 16.5 16H11C10.4477 16 10 16.4477 10 17V20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 13H8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'puzzle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19.4 12C19.9601 12 20.2401 12 20.454 11.891C20.6422 11.7951 20.7951 11.6422 20.891 11.454C21 11.2401 21 10.9601 21 10.4V8.2C21 7.63995 21 7.35992 20.891 7.14601C20.7951 6.95785 20.6422 6.80487 20.454 6.70899C20.2401 6.6 19.9601 6.6 19.4 6.6H17.85C17.3529 6.6 16.95 6.19706 16.95 5.7C16.95 4.20883 15.7412 3 14.25 3C12.7588 3 11.55 4.20883 11.55 5.7C11.55 6.19706 11.1471 6.6 10.65 6.6H9.1C8.53995 6.6 8.25992 6.6 8.04601 6.70899C7.85785 6.80487 7.70487 6.95785 7.60899 7.14601C7.5 7.35992 7.5 7.63995 7.5 8.2V10.4C7.5 10.9601 7.5 11.2401 7.39101 11.454C7.29513 11.6422 7.14215 11.7951 6.95399 11.891C6.74008 12 6.46005 12 5.9 12H5.7C4.20883 12 3 13.2088 3 14.7C3 16.1912 4.20883 17.4 5.7 17.4H5.9C6.46005 17.4 6.74008 17.4 6.95399 17.509C7.14215 17.6049 7.29513 17.7578 7.39101 17.946C7.5 18.1599 7.5 18.4399 7.5 19V19.4C7.5 19.9601 7.5 20.2401 7.60899 20.454C7.70487 20.6422 7.85785 20.7951 8.04601 20.891C8.25992 21 8.53995 21 9.1 21H19.4C19.9601 21 20.2401 21 20.454 20.891C20.6422 20.7951 20.7951 20.6422 20.891 20.454C21 20.2401 21 19.9601 21 19.4V19C21 18.4399 21 18.1599 20.891 17.946C20.7951 17.7578 20.6422 17.6049 20.454 17.509C20.2401 17.4 19.9601 17.4 19.4 17.4H19.2C17.7088 17.4 16.5 16.1912 16.5 14.7C16.5 13.2088 17.7088 12 19.2 12H19.4Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'question' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 21V20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 17.5C12 12.4004 17 13.6753 17 8.57582C17 1.80798 7 1.80804 7 8.57588" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'question-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 13.4961C12 11.4927 14 11.9935 14 9.99017C14 7.33137 10 7.33139 10 9.99019" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 15.9966V15.4966" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'question-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 13.4961C12 11.4927 14 11.9935 14 9.99017C14 7.33137 10 7.33139 10 9.99019" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 15.9966V15.4966" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'question-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 13.4961C12 11.4927 14 11.9935 14 9.99017C14 7.33137 10 7.33139 10 9.99019" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 15.9966V15.4966" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'question-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 13.4961C12 11.4927 14 11.9935 14 9.99017C14 7.33137 10 7.33139 10 9.99019" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 15.9966V15.4966" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'question-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 13.4961C12 11.4927 14 11.9935 14 9.99017C14 7.33137 10 7.33139 10 9.99019" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 15.9966V15.4966" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'radio' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 13.5C12.8284 13.5 13.5 12.8284 13.5 12C13.5 11.1716 12.8284 10.5 12 10.5C11.1716 10.5 10.5 11.1716 10.5 12C10.5 12.8284 11.1716 13.5 12 13.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.55123 15.7049C8.05946 15.2186 7.66934 14.641 7.40317 14.0053C7.137 13.3696 7 12.6881 7 11.9999C7 11.3117 7.137 10.6303 7.40317 9.99456C7.66934 9.35883 8.05946 8.78127 8.55123 8.29492" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18.0703 5.5C19.8111 7.22409 20.789 9.56214 20.789 12C20.789 14.4379 19.8111 16.7759 18.0703 18.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.2402 8.29492C15.732 8.78127 16.1221 9.35883 16.3883 9.99456C16.6545 10.6303 16.7915 11.3117 16.7915 11.9999C16.7915 12.6881 16.6545 13.3696 16.3883 14.0053C16.1221 14.641 15.732 15.2186 15.2402 15.7049" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.5117 18.5C3.7709 16.7759 2.79297 14.4379 2.79297 12C2.79297 9.56214 3.7709 7.22409 5.5117 5.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rainbow' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 17.5V15.5C3 10.5294 7.02944 6.5 12 6.5C16.9706 6.5 21 10.5294 21 15.5V17.5M6 17.5V15.5C6 12.1863 8.68629 9.5 12 9.5C15.3137 9.5 18 12.1863 18 15.5V17.5M9 17.5V15.5C9 13.8431 10.3431 12.5 12 12.5C13.6569 12.5 15 13.8431 15 15.5V17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'reception-bell' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 19H21M12 8V5M12 8H10C7.23858 8 5 10.2386 5 13V16H19V13C19 10.2386 16.7614 8 14 8H12ZM12 5H10M12 5H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'record' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 12.5C21 14.433 19.433 16 17.5 16C15.567 16 14 14.433 14 12.5C14 10.567 15.567 9 17.5 9C19.433 9 21 10.567 21 12.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 12.5C10 14.433 8.433 16 6.5 16C4.567 16 3 14.433 3 12.5C3 10.567 4.567 9 6.5 9C8.433 9 10 10.567 10 12.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6.5 16H17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rectangle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2 12C2 8.22876 2 6.34315 3.46447 5.17157C4.92893 4 7.28595 4 12 4C16.714 4 19.0711 4 20.5355 5.17157C22 6.34315 22 8.22876 22 12C22 15.7712 22 17.6569 20.5355 18.8284C19.0711 20 16.714 20 12 20C7.28595 20 4.92893 20 3.46447 18.8284C2 17.6569 2 15.7712 2 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rectangle-vertical' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 2C15.7712 2 17.6569 2 18.8284 3.46447C20 4.92893 20 7.28595 20 12C20 16.714 20 19.0711 18.8284 20.5355C17.6569 22 15.7712 22 12 22C8.22876 22 6.34315 22 5.17157 20.5355C4 19.0711 4 16.714 4 12C4 7.28595 4 4.92893 5.17157 3.46447C6.34315 2 8.22876 2 12 2Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'redo' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18.3639 18.364C16.7353 19.9927 14.4853 21 12 21C7.02945 21 3 16.9706 3 12C3 7.02945 7.02945 3 12 3C16.0579 3 18.5176 5.7045 21 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 4.5V8.5H17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'refresh' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5 8C19.1077 4.82137 15.6774 3 11.9777 3C7.29934 3 3.45266 6.55201 3 11.1" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.4893 8.3999H20.459C20.758 8.3999 21.0004 8.15814 21.0004 7.8599V3.8999" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.5 15.9999C4.89224 19.1785 8.32256 20.9999 12.0223 20.9999C16.7006 20.9999 20.5473 17.4479 20.9999 12.8999" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.51112 15.6001H3.54133C3.24236 15.6001 3 15.8418 3 16.1401V20.1001" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'refresh-alt' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.5 8C4.89231 4.82137 8.32259 3 12.0223 3C16.7007 3 20.5473 6.55201 21 11.1" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.51112 8.3999H3.54133C3.24234 8.3999 3 8.15814 3 7.8599V3.8999" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.4999 15.9999C19.1077 19.1785 15.6774 20.9999 11.9777 20.9999C7.29937 20.9999 3.45265 17.4479 3 12.8999" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.4893 15.6001H20.459C20.758 15.6001 21.0004 15.8418 21.0004 16.1401V20.1001" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'repeat' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17 3L21 6L17 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12V10C3 8.93913 3.42143 7.92172 4.17157 7.17157C4.92172 6.42143 5.93913 6 7 6H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7 21L3 18L7 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 12V14C21 15.0609 20.5786 16.0783 19.8284 16.8284C19.0783 17.5786 18.0609 18 17 18H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rewind' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.51549 9.41851C5.17183 10.5146 4.5 11.0626 4.5 12C4.5 12.9374 5.17183 13.4854 6.51549 14.5815C6.88641 14.8841 7.2543 15.169 7.59236 15.4064C7.88894 15.6146 8.22483 15.83 8.57258 16.0415C9.91309 16.8567 10.5833 17.2643 11.1845 16.813C11.7856 16.3617 11.8403 15.4171 11.9495 13.5277C11.9804 12.9934 12 12.4696 12 12C12 11.5304 11.9804 11.0066 11.9495 10.4723C11.8403 8.58294 11.7856 7.63826 11.1845 7.187C10.5833 6.73574 9.91309 7.14332 8.57258 7.95849C8.22483 8.16996 7.88894 8.38539 7.59236 8.59365C7.2543 8.83104 6.88641 9.11592 6.51549 9.41851Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.0155 9.41851C12.6718 10.5146 12 11.0626 12 12C12 12.9374 12.6718 13.4854 14.0155 14.5815C14.3864 14.8841 14.7543 15.169 15.0924 15.4064C15.3889 15.6146 15.7248 15.83 16.0726 16.0415C17.4131 16.8567 18.0833 17.2643 18.6845 16.813C19.2856 16.3617 19.3403 15.4171 19.4495 13.5277C19.4804 12.9934 19.5 12.4696 19.5 12C19.5 11.5304 19.4804 11.0066 19.4495 10.4723C19.3403 8.58294 19.2856 7.63826 18.6845 7.187C18.0833 6.73574 17.4131 7.14332 16.0726 7.95849C15.7248 8.16996 15.3889 8.38539 15.0924 8.59365C14.7543 8.83104 14.3864 9.11592 14.0155 9.41851Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rewind-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.00774 10.7093C7.33591 11.2573 7 11.5313 7 12C7 12.4687 7.33591 12.7427 8.00774 13.2907C8.1932 13.442 8.37715 13.5845 8.54618 13.7032C8.69447 13.8073 8.86241 13.915 9.03629 14.0208C9.70654 14.4283 10.0417 14.6321 10.3422 14.4065C10.6428 14.1809 10.6701 13.7085 10.7248 12.7638C10.7402 12.4967 10.75 12.2348 10.75 12C10.75 11.7652 10.7402 11.5033 10.7248 11.2362C10.6701 10.2915 10.6428 9.81913 10.3422 9.5935C10.0417 9.36787 9.70654 9.57166 9.03629 9.97924C8.86241 10.085 8.69447 10.1927 8.54618 10.2968C8.37715 10.4155 8.1932 10.558 8.00774 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.7577 10.7093C13.0859 11.2573 12.75 11.5313 12.75 12C12.75 12.4687 13.0859 12.7427 13.7577 13.2907C13.9432 13.442 14.1271 13.5845 14.2962 13.7032C14.4445 13.8073 14.6124 13.915 14.7863 14.0208C15.4565 14.4283 15.7917 14.6321 16.0922 14.4065C16.3928 14.1809 16.4201 13.7085 16.4748 12.7638C16.4902 12.4967 16.5 12.2348 16.5 12C16.5 11.7652 16.4902 11.5033 16.4748 11.2362C16.4201 10.2915 16.3928 9.81913 16.0922 9.5935C15.7917 9.36787 15.4565 9.57166 14.7863 9.97924C14.6124 10.085 14.4445 10.1927 14.2962 10.2968C14.1272 10.4155 13.9432 10.558 13.7577 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rewind-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.00774 10.7093C7.33591 11.2573 7 11.5313 7 12C7 12.4687 7.33591 12.7427 8.00774 13.2907C8.1932 13.442 8.37715 13.5845 8.54618 13.7032C8.69447 13.8073 8.86241 13.915 9.03629 14.0208C9.70654 14.4283 10.0417 14.6321 10.3422 14.4065C10.6428 14.1809 10.6701 13.7085 10.7248 12.7638C10.7402 12.4967 10.75 12.2348 10.75 12C10.75 11.7652 10.7402 11.5033 10.7248 11.2362C10.6701 10.2915 10.6428 9.81913 10.3422 9.5935C10.0417 9.36787 9.70654 9.57166 9.03629 9.97924C8.86241 10.085 8.69447 10.1927 8.54618 10.2968C8.37715 10.4155 8.1932 10.558 8.00774 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.7577 10.7093C13.0859 11.2573 12.75 11.5313 12.75 12C12.75 12.4687 13.0859 12.7427 13.7577 13.2907C13.9432 13.442 14.1271 13.5845 14.2962 13.7032C14.4445 13.8073 14.6124 13.915 14.7863 14.0208C15.4565 14.4283 15.7917 14.6321 16.0922 14.4065C16.3928 14.1809 16.4201 13.7085 16.4748 12.7638C16.4902 12.4967 16.5 12.2348 16.5 12C16.5 11.7652 16.4902 11.5033 16.4748 11.2362C16.4201 10.2915 16.3928 9.81913 16.0922 9.5935C15.7917 9.36787 15.4565 9.57166 14.7863 9.97924C14.6124 10.085 14.4445 10.1927 14.2962 10.2968C14.1272 10.4155 13.9432 10.558 13.7577 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rewind-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.00774 10.7093C7.33591 11.2573 7 11.5313 7 12C7 12.4687 7.33591 12.7427 8.00774 13.2907C8.1932 13.442 8.37715 13.5845 8.54618 13.7032C8.69447 13.8073 8.86241 13.915 9.03629 14.0208C9.70654 14.4283 10.0417 14.6321 10.3422 14.4065C10.6428 14.1809 10.6701 13.7085 10.7248 12.7638C10.7402 12.4967 10.75 12.2348 10.75 12C10.75 11.7652 10.7402 11.5033 10.7248 11.2362C10.6701 10.2915 10.6428 9.81913 10.3422 9.5935C10.0417 9.36787 9.70654 9.57166 9.03629 9.97924C8.86241 10.085 8.69447 10.1927 8.54618 10.2968C8.37715 10.4155 8.1932 10.558 8.00774 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.7577 10.7093C13.0859 11.2573 12.75 11.5313 12.75 12C12.75 12.4687 13.0859 12.7427 13.7577 13.2907C13.9432 13.442 14.1271 13.5845 14.2962 13.7032C14.4445 13.8073 14.6124 13.915 14.7863 14.0208C15.4565 14.4283 15.7917 14.6321 16.0922 14.4065C16.3928 14.1809 16.4201 13.7085 16.4748 12.7638C16.4902 12.4967 16.5 12.2348 16.5 12C16.5 11.7652 16.4902 11.5033 16.4748 11.2362C16.4201 10.2915 16.3928 9.81913 16.0922 9.5935C15.7917 9.36787 15.4565 9.57166 14.7863 9.97924C14.6124 10.085 14.4445 10.1927 14.2962 10.2968C14.1272 10.4155 13.9432 10.558 13.7577 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rewind-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.00774 10.7093C7.33591 11.2573 7 11.5313 7 12C7 12.4687 7.33591 12.7427 8.00774 13.2907C8.1932 13.442 8.37715 13.5845 8.54618 13.7032C8.69447 13.8073 8.86241 13.915 9.03629 14.0208C9.70654 14.4283 10.0417 14.6321 10.3422 14.4065C10.6428 14.1809 10.6701 13.7085 10.7248 12.7638C10.7402 12.4967 10.75 12.2348 10.75 12C10.75 11.7652 10.7402 11.5033 10.7248 11.2362C10.6701 10.2915 10.6428 9.81913 10.3422 9.5935C10.0417 9.36787 9.70654 9.57166 9.03629 9.97924C8.86241 10.085 8.69447 10.1927 8.54618 10.2968C8.37715 10.4155 8.1932 10.558 8.00774 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.7577 10.7093C13.0859 11.2573 12.75 11.5313 12.75 12C12.75 12.4687 13.0859 12.7427 13.7577 13.2907C13.9432 13.442 14.1271 13.5845 14.2962 13.7032C14.4445 13.8073 14.6124 13.915 14.7863 14.0208C15.4565 14.4283 15.7917 14.6321 16.0922 14.4065C16.3928 14.1809 16.4201 13.7085 16.4748 12.7638C16.4902 12.4967 16.5 12.2348 16.5 12C16.5 11.7652 16.4902 11.5033 16.4748 11.2362C16.4201 10.2915 16.3928 9.81913 16.0922 9.5935C15.7917 9.36787 15.4565 9.57166 14.7863 9.97924C14.6124 10.085 14.4445 10.1927 14.2962 10.2968C14.1272 10.4155 13.9432 10.558 13.7577 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rewind-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.00774 10.7093C7.33591 11.2573 7 11.5313 7 12C7 12.4687 7.33591 12.7427 8.00774 13.2907C8.1932 13.442 8.37715 13.5845 8.54618 13.7032C8.69447 13.8073 8.86241 13.915 9.03629 14.0208C9.70654 14.4283 10.0417 14.6321 10.3422 14.4065C10.6428 14.1809 10.6701 13.7085 10.7248 12.7638C10.7402 12.4967 10.75 12.2348 10.75 12C10.75 11.7652 10.7402 11.5033 10.7248 11.2362C10.6701 10.2915 10.6428 9.81913 10.3422 9.5935C10.0417 9.36787 9.70654 9.57166 9.03629 9.97924C8.86241 10.085 8.69447 10.1927 8.54618 10.2968C8.37715 10.4155 8.1932 10.558 8.00774 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.7577 10.7093C13.0859 11.2573 12.75 11.5313 12.75 12C12.75 12.4687 13.0859 12.7427 13.7577 13.2907C13.9432 13.442 14.1271 13.5845 14.2962 13.7032C14.4445 13.8073 14.6124 13.915 14.7863 14.0208C15.4565 14.4283 15.7917 14.6321 16.0922 14.4065C16.3928 14.1809 16.4201 13.7085 16.4748 12.7638C16.4902 12.4967 16.5 12.2348 16.5 12C16.5 11.7652 16.4902 11.5033 16.4748 11.2362C16.4201 10.2915 16.3928 9.81913 16.0922 9.5935C15.7917 9.36787 15.4565 9.57166 14.7863 9.97924C14.6124 10.085 14.4445 10.1927 14.2962 10.2968C14.1272 10.4155 13.9432 10.558 13.7577 10.7093Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rhombus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.219 11.3399L11.1794 3.41506C11.5956 2.86165 12.4044 2.86165 12.8206 3.41506L18.781 11.3399C19.073 11.7282 19.073 12.2718 18.781 12.6601L12.8206 20.5849C12.4044 21.1384 11.5956 21.1384 11.1794 20.5849L5.219 12.6601C4.927 12.2718 4.927 11.7282 5.219 11.3399Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'ribbon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 9C18 12.3137 15.3137 15 12 15C8.68629 15 6 12.3137 6 9C6 5.68629 8.68629 3 12 3C15.3137 3 18 5.68629 18 9Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8 13.4722L7 19.9112C7 20.7212 8.78231 21.248 9.44721 20.8857L11.5528 19.7387C11.8343 19.5853 12.1657 19.5853 12.4472 19.7387L14.5528 20.8857C15.2177 21.248 17 20.7212 17 19.9112L16 13.4722" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'room-service' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 6.16667V4M12 6.16667C16.4183 6.16667 20 9.74839 20 14.1667V17H4V14.1667C4 9.74839 7.58172 6.16667 12 6.16667Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 20H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rows' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 6.5C3 5.94772 3.44772 5.5 4 5.5H20C20.5523 5.5 21 5.94772 21 6.5V9.5C21 10.0523 20.5523 10.5 20 10.5H4C3.44772 10.5 3 10.0523 3 9.5V6.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 14.5C3 13.9477 3.44772 13.5 4 13.5H20C20.5523 13.5 21 13.9477 21 14.5V17.5C21 18.0523 20.5523 18.5 20 18.5H4C3.44772 18.5 3 18.0523 3 17.5V14.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rss' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6 11.25C7.79021 11.25 9.5071 11.9612 10.773 13.227C12.0388 14.4929 12.75 16.2098 12.75 18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 6C9.1826 6 12.2348 7.26428 14.4853 9.51472C16.7357 11.7652 18 14.8174 18 18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6.5 17.8536L6.85355 17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'ruler' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.91359 12.0003L8.19617 14.2829M8.95671 8.95671L11.2393 11.2393M11.9998 5.91359L14.2824 8.19617M4.54335 13.3693L13.3693 4.54335C14.2216 3.6911 14.6481 3.26498 15.1395 3.10533C15.5717 2.96489 16.0372 2.96489 16.4694 3.10533C16.9605 3.26489 17.3862 3.69062 18.2375 4.5419L19.4563 5.76072C20.3086 6.61296 20.7352 7.04009 20.8948 7.53146C21.0353 7.96368 21.035 8.42833 20.8945 8.86056C20.7349 9.35193 20.3089 9.77839 19.4566 10.6306L10.6306 19.4566C9.77839 20.3088 9.35193 20.7349 8.86056 20.8945C8.42833 21.035 7.96368 21.0353 7.53146 20.8948C7.04009 20.7352 6.61296 20.3086 5.76072 19.4563L4.5419 18.2375C3.69062 17.3862 3.26489 16.9605 3.10533 16.4694C2.96489 16.0372 2.96489 15.5717 3.10533 15.1395C3.26498 14.6481 3.6911 14.2216 4.54335 13.3693Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rupee' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.5 3.5H17.5M6.5 8.22222H17.5M14.2917 20.5L6.5 12.9444H9.25C15.3614 12.9444 15.3614 3.5 9.25 3.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rupee-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 7.5H15M9 10.2778H15M13.25 17.5L9 13.0556H10.5C13.8335 13.0556 13.8335 7.5 10.5 7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rupee-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 7.5H15M9 10.2778H15M13.25 17.5L9 13.0556H10.5C13.8335 13.0556 13.8335 7.5 10.5 7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rupee-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 7.5H15M9 10.2778H15M13.25 17.5L9 13.0556H10.5C13.8335 13.0556 13.8335 7.5 10.5 7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rupee-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 7.5H15M9 10.2778H15M13.25 17.5L9 13.0556H10.5C13.8335 13.0556 13.8335 7.5 10.5 7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'rupee-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 7.5H15M9 10.2778H15M13.25 17.5L9 13.0556H10.5C13.8335 13.0556 13.8335 7.5 10.5 7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'sad-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 16C9.85038 15.3697 10.8846 15 12 15C13.1154 15 14.1496 15.3697 15 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'sad-ghost' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 16C9.85038 15.3697 10.8846 15 12 15C13.1154 15 14.1496 15.3697 15 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 18.5615V12.0443C3 7.04928 7.02944 3 12 3C16.9706 3 21 7.04928 21 12.0443V18.5615C21 19.7226 20.0334 21.08 19 20.5608C18.1647 20.1411 16.777 20.0402 16 20.5608C15.1259 21.1464 13.8741 21.1464 13 20.5608C12.1148 19.9678 11.3511 19.9906 10.5 20.5608C9.6259 21.1464 8.3741 21.1464 7.5 20.5608C6.723 20.0402 5.83525 20.1411 5 20.5608C3.9666 21.08 3 19.7226 3 18.5615Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'sad-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 16C9.85038 15.3697 10.8846 15 12 15C13.1154 15 14.1496 15.3697 15 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'save' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.25 21V16.2353C16.25 15.3581 15.5365 14.6471 14.6562 14.6471H9.34375C8.46355 14.6471 7.75 15.3581 7.75 16.2353V21M16.25 3.28531V5.64706C16.25 6.52422 15.5365 7.23529 14.6562 7.23529H9.34375C8.46355 7.23529 7.75 6.52422 7.75 5.64706V3M16.25 3.28531C15.8393 3.09906 15.3896 3 14.9297 3H7.75M16.25 3.28531C16.5942 3.44141 16.911 3.65875 17.1836 3.93037L19.5664 6.30493C20.1642 6.90063 20.5 7.70858 20.5 8.55103V17.8235C20.5 19.5778 19.0729 21 17.3125 21H6.6875C4.92709 21 3.5 19.5778 3.5 17.8235V6.17647C3.5 4.42215 4.92709 3 6.6875 3H7.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'scan' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.11426 7.5C3.25813 6.03737 3.58327 5.05285 4.3181 4.31802C5.63612 3 7.75744 3 12.0001 3C16.2427 3 18.364 3 19.6821 4.31802C20.4169 5.05285 20.742 6.03737 20.8859 7.5M20.8859 16.5C20.742 17.9626 20.4169 18.9472 19.6821 19.682C18.364 21 16.2427 21 12.0001 21C7.75744 21 5.63612 21 4.3181 19.682C3.58327 18.9472 3.25813 17.9626 3.11426 16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12H3.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.75 12H12.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.25 12H7.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.25 12H16.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 12H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'scissors' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.7895 12L7 8.85484M21 5.95161L7 15.1452M8 6.91935C8 8.25553 6.88071 9.33871 5.5 9.33871C4.11929 9.33871 3 8.25553 3 6.91935C3 5.58318 4.11929 4.5 5.5 4.5C6.88071 4.5 8 5.58318 8 6.91935ZM8 17.0806C8 15.7445 6.88071 14.6613 5.5 14.6613C4.11929 14.6613 3 15.7445 3 17.0806C3 18.4168 4.11929 19.5 5.5 19.5C6.88071 19.5 8 18.4168 8 17.0806Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21.0002 18.0484L14.9341 14.0649" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'sea-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 5.91836L4.76393 5.03106C6.17157 4.32298 7.82843 4.32298 9.23607 5.03106L9.76393 5.29658C11.1716 6.00466 12.8284 6.00466 14.2361 5.29658L14.7639 5.03106C16.1716 4.32298 17.8284 4.32298 19.2361 5.03106L21 5.91836M3 10.4456L4.76393 9.55827C6.17157 8.8502 7.82843 8.8502 9.23607 9.55827L9.76393 9.8238C11.1716 10.5319 12.8284 10.5319 14.2361 9.8238L14.7639 9.55827C16.1716 8.8502 17.8284 8.8502 19.2361 9.55827L21 10.4456M3 14.9728L4.76393 14.0855C6.17157 13.3774 7.82843 13.3774 9.23607 14.0855L9.76393 14.351C11.1716 15.0591 12.8284 15.0591 14.2361 14.351L14.7639 14.0855C16.1716 13.3774 17.8284 13.3774 19.2361 14.0855L21 14.9728M3 19.5L4.76393 18.6127C6.17157 17.9046 7.82843 17.9046 9.23607 18.6127L9.76393 18.8782C11.1716 19.5863 12.8284 19.5863 14.2361 18.8782L14.7639 18.6127C16.1716 17.9046 17.8284 17.9046 19.2361 18.6127L21 19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'search' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.893 16.9199L19.9731 20M19.0843 11.5811C19.0843 15.768 15.7015 19.1622 11.5287 19.1622C7.35588 19.1622 3.97314 15.768 3.97314 11.5811C3.97314 7.39418 7.35588 4 11.5287 4C15.7015 4 19.0843 7.39418 19.0843 11.5811Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'search-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.893 16.9199L19.9731 20M19.0843 11.5811C19.0843 15.768 15.7015 19.1622 11.5287 19.1622C7.35588 19.1622 3.97314 15.768 3.97314 11.5811C3.97314 7.39418 7.35588 4 11.5287 4C15.7015 4 19.0843 7.39418 19.0843 11.5811Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.7998 11.9918L10.8338 13.1735C10.9286 13.2819 11.0996 13.2739 11.1839 13.1572L13.2835 10.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'search-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.8562 13.8497C14.4747 13.2295 14.8571 12.3737 14.8571 11.4286C14.8571 9.53502 13.3221 8 11.4286 8C9.53502 8 8 9.53502 8 11.4286C8 13.3221 9.53502 14.8571 11.4286 14.8571C12.377 14.8571 13.2355 14.4721 13.8562 13.8497ZM13.8562 13.8497L16 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'search-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.8562 13.8497C14.4747 13.2295 14.8571 12.3737 14.8571 11.4286C14.8571 9.53502 13.3221 8 11.4286 8C9.53502 8 8 9.53502 8 11.4286C8 13.3221 9.53502 14.8571 11.4286 14.8571C12.377 14.8571 13.2355 14.4721 13.8562 13.8497ZM13.8562 13.8497L16 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'search-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.893 16.9199L19.9731 20M19.0843 11.5811C19.0843 15.768 15.7015 19.1622 11.5287 19.1622C7.35588 19.1622 3.97314 15.768 3.97314 11.5811C3.97314 7.39418 7.35588 4 11.5287 4C15.7015 4 19.0843 7.39418 19.0843 11.5811Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 11.75H13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'search-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.8562 13.8497C14.4747 13.2295 14.8571 12.3737 14.8571 11.4286C14.8571 9.53502 13.3221 8 11.4286 8C9.53502 8 8 9.53502 8 11.4286C8 13.3221 9.53502 14.8571 11.4286 14.8571C12.377 14.8571 13.2355 14.4721 13.8562 13.8497ZM13.8562 13.8497L16 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'search-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.893 16.9199L19.9731 20M19.0843 11.5811C19.0843 15.768 15.7015 19.1622 11.5287 19.1622C7.35588 19.1622 3.97314 15.768 3.97314 11.5811C3.97314 7.39418 7.35588 4 11.5287 4C15.7015 4 19.0843 7.39418 19.0843 11.5811Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 11.5H13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.5 9.5L11.5 13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'search-slash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.8928 16.9199C18.2473 15.5497 19.0841 13.6635 19.0841 11.5811C19.0841 9.71928 18.4152 8.01421 17.3054 6.69463M16.8928 16.9199C15.5239 18.3046 13.626 19.1622 11.5285 19.1622C9.6638 19.1622 7.95685 18.4844 6.63905 17.361M16.8928 16.9199L19.973 20M17.3054 6.69463L21 3M17.3054 6.69463L6.63905 17.361M3 21L6.63905 17.361M4.73494 14.9028C4.24687 13.8997 3.97296 12.7725 3.97296 11.5811C3.97296 7.39418 7.3557 4 11.5285 4C12.7089 4 13.8261 4.2716 14.8213 4.75591" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'search-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.8562 13.8497C14.4747 13.2295 14.8571 12.3737 14.8571 11.4286C14.8571 9.53502 13.3221 8 11.4286 8C9.53502 8 8 9.53502 8 11.4286C8 13.3221 9.53502 14.8571 11.4286 14.8571C12.377 14.8571 13.2355 14.4721 13.8562 13.8497ZM13.8562 13.8497L16 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'search-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.8562 13.8497C14.4747 13.2295 14.8571 12.3737 14.8571 11.4286C14.8571 9.53502 13.3221 8 11.4286 8C9.53502 8 8 9.53502 8 11.4286C8 13.3221 9.53502 14.8571 11.4286 14.8571C12.377 14.8571 13.2355 14.4721 13.8562 13.8497ZM13.8562 13.8497L16 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'search-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.893 16.9199L19.9731 20M19.0843 11.5811C19.0843 15.768 15.7015 19.1622 11.5287 19.1622C7.35588 19.1622 3.97314 15.768 3.97314 11.5811C3.97314 7.39418 7.35588 4 11.5287 4C15.7015 4 19.0843 7.39418 19.0843 11.5811Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.25 10.25L13.0784 13.0784" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.0784 10.25L10.25 13.0784" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'select-multiple' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 9V19.4C3 19.9601 3 20.2399 3.10899 20.4538C3.20487 20.642 3.35774 20.7952 3.5459 20.8911C3.7596 21 4.0395 21 4.59846 21H15.0001M7 13.8002V6.2002C7 5.08009 7 4.51962 7.21799 4.0918C7.40973 3.71547 7.71547 3.40973 8.0918 3.21799C8.51962 3 9.08009 3 10.2002 3H17.8002C18.9203 3 19.4801 3 19.9079 3.21799C20.2842 3.40973 20.5905 3.71547 20.7822 4.0918C21.0002 4.51962 21.0002 5.07969 21.0002 6.19978L21.0002 13.7998C21.0002 14.9199 21.0002 15.48 20.7822 15.9078C20.5905 16.2841 20.2842 16.5905 19.9079 16.7822C19.4805 17 18.9215 17 17.8036 17H10.1969C9.07899 17 8.5192 17 8.0918 16.7822C7.71547 16.5905 7.40973 16.2842 7.21799 15.9079C7 15.4801 7 14.9203 7 13.8002Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.6001 10.3225L12.9787 11.898C13.1051 12.0425 13.3331 12.0319 13.4455 11.8762L16.245 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'send' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.2876 3.03105C20.7105 2.88304 21.117 3.28954 20.9689 3.71243L15.0436 20.6419C14.8836 21.099 14.247 21.125 14.0503 20.6824L10.8314 13.44C10.7777 13.3191 10.6809 13.2223 10.5599 13.1686L3.31758 9.94974C2.87501 9.75305 2.90099 9.11636 3.35811 8.95636L20.2876 3.03105Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 10L11 13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'servers' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 5.7C3 5.03726 3.44772 4.5 4 4.5H20C20.5523 4.5 21 5.03726 21 5.7V9.3C21 9.96274 20.5523 10.5 20 10.5H4C3.44772 10.5 3 9.96274 3 9.3V5.7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 7.5H8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 16.5H8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 14.7C3 14.0373 3.44772 13.5 4 13.5H20C20.5523 13.5 21 14.0373 21 14.7V18.3C21 18.9627 20.5523 19.5 20 19.5H4C3.44772 19.5 3 18.9627 3 18.3V14.7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'seven' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.5 17C10.5 13.25 15.5 7 15.5 7C15.5 7 11.75 7.625 9.25 7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'seven-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.75 16C10.75 13 14.75 8 14.75 8C14.75 8 11.75 8.5 9.75 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'seven-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.75 16C10.75 13 14.75 8 14.75 8C14.75 8 11.75 8.5 9.75 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'seven-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.75 16C10.75 13 14.75 8 14.75 8C14.75 8 11.75 8.5 9.75 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'seven-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.75 16C10.75 13 14.75 8 14.75 8C14.75 8 11.75 8.5 9.75 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'seven-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.75 16C10.75 13 14.75 8 14.75 8C14.75 8 11.75 8.5 9.75 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'seven-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.75 16C10.75 13 14.75 8 14.75 8C14.75 8 11.75 8.5 9.75 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'share' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 12C9.5 13.3807 8.38072 14.5 7 14.5C5.61929 14.5 4.5 13.3807 4.5 12C4.5 10.6193 5.61929 9.5 7 9.5C8.38072 9.5 9.5 10.6193 9.5 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 6.5L9.5 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 17.5L9.5 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.5 18.5C19.5 19.8807 18.3807 21 17 21C15.6193 21 14.5 19.8807 14.5 18.5C14.5 17.1193 15.6193 16 17 16C18.3807 16 19.5 17.1193 19.5 18.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.5 5.5C19.5 6.88072 18.3807 8 17 8C15.6193 8 14.5 6.88072 14.5 5.5C14.5 4.11929 15.6193 3 17 3C18.3807 3 19.5 4.11929 19.5 5.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'shield' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.4668 20.8194C11.7881 21.0602 12.2119 21.0602 12.5332 20.8194C14.1681 19.5943 19 15.5871 19 11.0173V6.08705C19 5.8213 18.8023 5.59878 18.5427 5.57234C16.5452 5.36888 14.6279 4.66603 12.9613 3.52622L12.3511 3.10893C12.1388 2.96369 11.8612 2.96369 11.6489 3.10893L11.0387 3.52622C9.37206 4.66603 7.45482 5.36888 5.45731 5.57234C5.1977 5.59878 5 5.8213 5 6.08705V11.0173C5 15.5871 9.8319 19.5944 11.4668 20.8194Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'shield-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.2583 11.2418L11.2923 12.4235C11.3871 12.5319 11.5581 12.5239 11.6424 12.4072L13.742 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.4668 20.8194C11.7881 21.0602 12.2119 21.0602 12.5332 20.8194C14.1681 19.5943 19 15.5871 19 11.0173V6.08705C19 5.8213 18.8023 5.59878 18.5427 5.57234C16.5452 5.36888 14.6279 4.66603 12.9613 3.52622L12.3511 3.10893C12.1388 2.96369 11.8612 2.96369 11.6489 3.10893L11.0387 3.52622C9.37206 4.66603 7.45482 5.36888 5.45731 5.57234C5.1977 5.59878 5 5.8213 5 6.08705V11.0173C5 15.5871 9.8319 19.5944 11.4668 20.8194Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'shield-crossed' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 21C12 21 19 16.4 19 11M12 21C12 21 5 16.4 5 11M12 21V3M19 11V6.15959C19 5.89869 18.8023 5.68023 18.5427 5.65427C16.5452 5.45452 14.6279 4.76447 12.9613 3.64544L12 3M19 11H5M12 3L11.0387 3.64544C9.37206 4.76447 7.45482 5.45452 5.45731 5.65427C5.1977 5.68023 5 5.89869 5 6.15959V11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'shield-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 11H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.4668 20.8194C11.7881 21.0602 12.2119 21.0602 12.5332 20.8194C14.1681 19.5943 19 15.5871 19 11.0173V6.08705C19 5.8213 18.8023 5.59878 18.5427 5.57234C16.5452 5.36888 14.6279 4.66603 12.9613 3.52622L12.3511 3.10893C12.1388 2.96369 11.8612 2.96369 11.6489 3.10893L11.0387 3.52622C9.37206 4.66603 7.45482 5.36888 5.45731 5.57234C5.1977 5.59878 5 5.8213 5 6.08705V11.0173C5 15.5871 9.8319 19.5944 11.4668 20.8194Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'shield-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.18326 15.0924C5.47758 13.8358 5 12.4547 5 11.0179V6.08726C5 5.82149 5.1977 5.59897 5.45731 5.57252C7.45482 5.36905 9.37206 4.66614 11.0387 3.52626L11.6489 3.10894C11.8612 2.96369 12.1388 2.96369 12.3511 3.10894L12.9613 3.52626C14.6279 4.66614 16.5452 5.36905 18.5427 5.57252C18.8023 5.59897 19 5.82149 19 6.08726V11.0179C19 12.4547 18.5224 13.8358 17.8167 15.0924M6.18326 15.0924C7.7214 17.8314 10.3432 19.9785 11.465 20.8194C11.7863 21.0602 12.2137 21.0602 12.535 20.8194C13.6568 19.9785 16.2786 17.8314 17.8167 15.0924M6.18326 15.0924L11.4334 11.4148C11.7747 11.1757 12.2253 11.1757 12.5666 11.4148L17.8167 15.0924" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'shield-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 11H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 9L12 13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.4668 20.8194C11.7881 21.0602 12.2119 21.0602 12.5332 20.8194C14.1681 19.5943 19 15.5871 19 11.0173V6.08705C19 5.8213 18.8023 5.59878 18.5427 5.57234C16.5452 5.36888 14.6279 4.66603 12.9613 3.52622L12.3511 3.10893C12.1388 2.96369 11.8612 2.96369 11.6489 3.10893L11.0387 3.52622C9.37206 4.66603 7.45482 5.36888 5.45731 5.57234C5.1977 5.59878 5 5.8213 5 6.08705V11.0173C5 15.5871 9.8319 19.5944 11.4668 20.8194Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'shield-slash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 21L7.27007 16.7299M21 3L18.4387 5.56129M18.4387 5.56129C18.4733 5.56512 18.508 5.56881 18.5427 5.57234C18.8023 5.59878 19 5.8213 19 6.08705V11.0173C19 15.5871 14.1681 19.5943 12.5332 20.8194C12.2119 21.0602 11.7881 21.0602 11.4668 20.8194C10.5808 20.1555 8.75601 18.6746 7.27007 16.7299M18.4387 5.56129L7.27007 16.7299M5.6461 14C5.24614 13.0514 5 12.0487 5 11.0173V6.08705C5 5.8213 5.1977 5.59878 5.45731 5.57234C7.45482 5.36888 9.37206 4.66603 11.0387 3.52622L11.6489 3.10893C11.8612 2.96369 12.1388 2.96369 12.3511 3.10893L12.9613 3.52622C13.6066 3.96753 14.2895 4.34334 15 4.65003" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'shield-two' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 21C12 21 19 16.4 19 11V6.15959C19 5.89869 18.8023 5.68023 18.5427 5.65427C16.5452 5.45452 14.6279 4.76447 12.9613 3.64544L12 3M12 21C12 21 5 16.4 5 11V6.15959C5 5.89869 5.1977 5.68023 5.45731 5.65427C7.45482 5.45452 9.37206 4.76447 11.0387 3.64544L12 3M12 21V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'shield-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.5 9.5L13.3284 12.3284" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.3284 9.5L10.5 12.3284" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.4668 20.8194C11.7881 21.0602 12.2119 21.0602 12.5332 20.8194C14.1681 19.5943 19 15.5871 19 11.0173V6.08705C19 5.8213 18.8023 5.59878 18.5427 5.57234C16.5452 5.36888 14.6279 4.66603 12.9613 3.52622L12.3511 3.10893C12.1388 2.96369 11.8612 2.96369 11.6489 3.10893L11.0387 3.52622C9.37206 4.66603 7.45482 5.36888 5.45731 5.57234C5.1977 5.59878 5 5.8213 5 6.08705V11.0173C5 15.5871 9.8319 19.5944 11.4668 20.8194Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'shooting-star' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 5.64706L9.35294 3M9.88235 9.88235L4.05882 4.05882M5.64706 12L3 9.35294M8.29412 14.6471L12.5294 12.5294L14.6471 8.29412L16.7647 12.5294L21 14.6471L16.7647 16.7647L14.6471 21L12.5294 16.7647L8.29412 14.6471Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'shopping-bag' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.93527 7H7.77296C6.70104 7 5.81137 7.81089 5.735 8.8575L5.0053 18.8575C4.92082 20.0152 5.85753 21 7.04326 21H16.9567C18.1425 21 19.0792 20.0152 18.9947 18.8575L18.265 8.85751C18.1886 7.81089 17.299 7 16.227 7H15.0647M8.93527 7V5C8.93527 3.89543 9.85002 3 10.9784 3H13.0216C14.15 3 15.0647 3.89543 15.0647 5V7M8.93527 7H15.0647" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'shuffle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.5 4H19.9118V8.44444" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4 20L19 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20 15.5V20H15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 14L19.2941 19.3333" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4 4L10 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'shuffle-alt' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19 16.7646L21 18.8823L19 20.9999" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19 3L21 5.11765L19 7.23529" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 5.11768H17.85C14.6191 5.11768 12 8.19901 12 12C12 15.801 14.6191 18.8824 17.85 18.8824H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 18.8824H6.15C9.38086 18.8824 12 15.801 12 12C12 8.19901 9.38086 5.11768 6.15 5.11768H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'sidebar' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 3.5V20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'sidebar-alt' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 3.5V20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'signal' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5 10V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.5 6V18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 3V21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.5 6V18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3.5 10V14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'signal-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 13.5V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 15V9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 13.5V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'signal-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 13.5V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 15V9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 13.5V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'signal-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 13.5V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 15V9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 13.5V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'signal-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 13.5V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 15V9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 13.5V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'signal-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 13.5V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 15V9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 13.5V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'six' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.75 7H12.5C10.4289 7 8.75 8.67893 8.75 10.75V13.875M8.75 13.875C8.75 15.6009 10.1491 17 11.875 17C13.6009 17 15 15.6009 15 13.875C15 12.1491 13.6009 11.375 11.875 11.375C10.1491 11.375 8.75 12.1491 8.75 13.875Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'six-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.5 8H12.5C10.8431 8 9.5 9.34315 9.5 11V13.5M9.5 13.5C9.5 14.8807 10.6193 16 12 16C13.3807 16 14.5 14.8807 14.5 13.5C14.5 12.1193 13.3807 11.5 12 11.5C10.6193 11.5 9.5 12.1193 9.5 13.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'six-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.5 8H12.5C10.8431 8 9.5 9.34315 9.5 11V13.5M9.5 13.5C9.5 14.8807 10.6193 16 12 16C13.3807 16 14.5 14.8807 14.5 13.5C14.5 12.1193 13.3807 11.5 12 11.5C10.6193 11.5 9.5 12.1193 9.5 13.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'six-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.5 8H12.5C10.8431 8 9.5 9.34315 9.5 11V13.5M9.5 13.5C9.5 14.8807 10.6193 16 12 16C13.3807 16 14.5 14.8807 14.5 13.5C14.5 12.1193 13.3807 11.5 12 11.5C10.6193 11.5 9.5 12.1193 9.5 13.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'six-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.5 8H12.5C10.8431 8 9.5 9.34315 9.5 11V13.5M9.5 13.5C9.5 14.8807 10.6193 16 12 16C13.3807 16 14.5 14.8807 14.5 13.5C14.5 12.1193 13.3807 11.5 12 11.5C10.6193 11.5 9.5 12.1193 9.5 13.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'six-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.5 8H12.5C10.8431 8 9.5 9.34315 9.5 11V13.5M9.5 13.5C9.5 14.8807 10.6193 16 12 16C13.3807 16 14.5 14.8807 14.5 13.5C14.5 12.1193 13.3807 11.5 12 11.5C10.6193 11.5 9.5 12.1193 9.5 13.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'six-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.5 8H12.5C10.8431 8 9.5 9.34315 9.5 11V13.5M9.5 13.5C9.5 14.8807 10.6193 16 12 16C13.3807 16 14.5 14.8807 14.5 13.5C14.5 12.1193 13.3807 11.5 12 11.5C10.6193 11.5 9.5 12.1193 9.5 13.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'skip-back' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.5 3V21M9.22609 12.7809L17.8753 19.7002C18.5301 20.2241 19.5 19.7579 19.5 18.9194V5.08063C19.5 4.24212 18.5301 3.77595 17.8753 4.29976L9.22609 11.2191C8.72568 11.6195 8.72568 12.3805 9.22609 12.7809Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'skip-forward' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19.5 3V21M14.7739 12.7809L6.1247 19.7002C5.46993 20.2241 4.5 19.7579 4.5 18.9194V5.08063C4.5 4.24212 5.46993 3.77595 6.1247 4.29976L14.7739 11.2191C15.2743 11.6195 15.2743 12.3805 14.7739 12.7809Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'slash-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 15L15 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'slash-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 15L15 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'slash-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 15L15 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'slash-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 15L15 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'slash-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 15L15 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'smile-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 15C9.85038 15.6303 10.8846 16 12 16C13.1154 16 14.1496 15.6303 15 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'smile-ghost' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 15C9.85038 15.6303 10.8846 16 12 16C13.1154 16 14.1496 15.6303 15 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 18.5615V12.0443C3 7.04928 7.02944 3 12 3C16.9706 3 21 7.04928 21 12.0443V18.5615C21 19.7226 20.0334 21.08 19 20.5608C18.1647 20.1411 16.777 20.0402 16 20.5608C15.1259 21.1464 13.8741 21.1464 13 20.5608C12.1148 19.9678 11.3511 19.9906 10.5 20.5608C9.6259 21.1464 8.3741 21.1464 7.5 20.5608C6.723 20.0402 5.83525 20.1411 5 20.5608C3.9666 21.08 3 19.7226 3 18.5615Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'smile-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 15C9.85038 15.6303 10.8846 16 12 16C13.1154 16 14.1496 15.6303 15 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'snow' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 19V5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.95312 3L11.9999 5L14.0467 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.95312 21L11.9999 19L14.0467 21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.7959 15.5L18.204 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18.9533 5.76807L18.2041 8.50012L21.0001 9.23217" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 14.7681L5.79599 15.5001L5.04681 18.2322" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.7959 8.5L18.204 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21.0001 14.7678L18.2041 15.4999L18.9533 18.2319" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.04681 5.76807L5.79599 8.50012L3 9.23217" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'sofa' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.5 18V20M16.5 18V20M4.8 9.84423C3.9 9.86491 3 10.2709 3 11V15C3 16.6569 4.20883 18 5.7 18H18.3C19.7912 18 21 16.6569 21 15V11C21 10.1881 20.1 9.82354 19.2 9.84423M4.8 9.84423C5.7 9.82354 6.6 10.1881 6.6 11C6.6 12.3627 6.82496 14 8.6 14H15.4C17.175 14 17.4 12.3627 17.4 11C17.4 10.2709 18.3 9.86491 19.2 9.84423M4.8 9.84423V7C4.8 5.34315 6.00883 4 7.5 4H16.5C17.9912 4 19.2 5.34315 19.2 7V9.84423" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'sort' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.5 7H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4.5 12H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4.5 17H8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'sparkles' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.7692 21C15.8929 16.3512 17.2565 14.9013 21 13.6364C17.0664 12.3084 15.8396 10.6969 14.7692 6.27273C13.6455 10.9216 12.282 12.3714 8.53846 13.6364C12.4674 14.9628 13.7012 16.5852 14.7692 21ZM6.46154 11.1818C6.9739 8.76207 7.96386 7.66977 9.92308 7.09091C7.96386 6.51205 6.9739 5.41975 6.46154 3C5.97132 5.31517 5.04749 6.48539 3 7.09091C4.95899 7.67026 5.94917 8.76206 6.46154 11.1818Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'speaker' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 14C9 14.7956 9.31607 15.5587 9.87868 16.1213C10.4413 16.6839 11.2044 17 12 17C12.7956 17 13.5587 16.6839 14.1213 16.1213C14.6839 15.5587 15 14.7956 15 14C15 13.2044 14.6839 12.4413 14.1213 11.8787C13.5587 11.3161 12.7956 11 12 11C11.2044 11 10.4413 11.3161 9.87868 11.8787C9.31607 12.4413 9 13.2044 9 14Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.5 7H12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 3C15.4177 3 17.1265 3 18.1883 4.31802C19.25 5.63604 19.25 7.75736 19.25 12C19.25 16.2426 19.25 18.364 18.1883 19.682C17.1265 21 15.4177 21 12 21C8.58232 21 6.87348 21 5.81174 19.682C4.75 18.364 4.75 16.2426 4.75 12C4.75 7.75736 4.75 5.63604 5.81174 4.31802C6.87348 3 8.58232 3 12 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'spinner' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 3V6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18.3658 5.63428L16.2471 7.75303" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 12H18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18.3658 18.3656L16.2471 16.2468" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 21V18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.63428 18.3656L7.75303 16.2468" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12H6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.63428 5.63428L7.75303 7.75303" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'spinner-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 3V6M12 21V18M4.20577 16.5L6.80385 15M21 12H18M16.5 19.7942L15 17.1962M3 12H6M7.5 4.20577L9 6.80385M7.5 19.7942L9 17.1962M19.7942 16.5L17.1962 15M4.20577 7.5L6.80385 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'square-dashed' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" stroke-dasharray="3.5 3.5"/>
</svg>',
                'square-half' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 3.5V20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'star' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.8541 3.50067C12.4862 2.83311 11.5138 2.83311 11.1459 3.50067C10.9456 3.86432 10.7534 4.23285 10.5695 4.60602C9.99049 5.78115 9.49447 7.00233 9.08879 8.26238C8.95002 8.69339 8.53768 8.99275 8.06577 9.00528C6.9521 9.03484 5.84047 9.12648 4.73814 9.28206C4.42331 9.32649 4.11016 9.37595 3.79877 9.43035C3.02451 9.56562 2.73398 10.4484 3.2838 10.9864C3.40922 11.1091 3.5357 11.2308 3.66323 11.3515C4.61689 12.2537 5.62918 13.0978 6.69404 13.8779C7.06131 14.1469 7.21228 14.6084 7.07191 15.0297C6.63214 16.3496 6.29178 17.713 6.05943 19.1116C6.01284 19.3921 5.97058 19.674 5.93274 19.9573C5.83193 20.7119 6.64048 21.2448 7.3423 20.885C7.59281 20.7566 7.84111 20.6247 8.08712 20.4893C9.21586 19.8679 10.2965 19.1736 11.3222 18.4128C11.7204 18.1175 12.2796 18.1175 12.6778 18.4128C13.7035 19.1736 14.7841 19.8679 15.9129 20.4893C16.1589 20.6247 16.4072 20.7566 16.6577 20.885C17.3595 21.2448 18.1681 20.7119 18.0673 19.9573C18.0294 19.674 17.9872 19.3921 17.9406 19.1116C17.7082 17.713 17.3679 16.3496 16.9281 15.0297C16.7877 14.6084 16.9387 14.1469 17.306 13.8779C18.3708 13.0978 19.3831 12.2537 20.3368 11.3515C20.4643 11.2308 20.5908 11.1091 20.7162 10.9864C21.266 10.4484 20.9755 9.56562 20.2012 9.43035C19.8898 9.37595 19.5767 9.32649 19.2619 9.28206C18.1595 9.12648 17.0479 9.03484 15.9342 9.00528C15.4623 8.99275 15.05 8.69339 14.9112 8.26237C14.5055 7.00233 14.0095 5.78115 13.4305 4.60602C13.2466 4.23285 13.0544 3.86432 12.8541 3.50067Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'stop' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6 12.5C6 9.67157 6 8.25736 6.87868 7.37868C7.75736 6.5 9.17157 6.5 12 6.5C14.8284 6.5 16.2426 6.5 17.1213 7.37868C18 8.25736 18 9.67157 18 12.5C18 15.3284 18 16.7426 17.1213 17.6213C16.2426 18.5 14.8284 18.5 12 18.5C9.17157 18.5 7.75736 18.5 6.87868 17.6213C6 16.7426 6 15.3284 6 12.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'stop-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 12C9.5 10.8215 9.5 10.2322 9.86612 9.86612C10.2322 9.5 10.8215 9.5 12 9.5C13.1785 9.5 13.7678 9.5 14.1339 9.86612C14.5 10.2322 14.5 10.8215 14.5 12C14.5 13.1785 14.5 13.7678 14.1339 14.1339C13.7678 14.5 13.1785 14.5 12 14.5C10.8215 14.5 10.2322 14.5 9.86612 14.1339C9.5 13.7678 9.5 13.1785 9.5 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'stop-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 12C9.5 10.8215 9.5 10.2322 9.86612 9.86612C10.2322 9.5 10.8215 9.5 12 9.5C13.1785 9.5 13.7678 9.5 14.1339 9.86612C14.5 10.2322 14.5 10.8215 14.5 12C14.5 13.1785 14.5 13.7678 14.1339 14.1339C13.7678 14.5 13.1785 14.5 12 14.5C10.8215 14.5 10.2322 14.5 9.86612 14.1339C9.5 13.7678 9.5 13.1785 9.5 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'stop-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 12C9.5 10.8215 9.5 10.2322 9.86612 9.86612C10.2322 9.5 10.8215 9.5 12 9.5C13.1785 9.5 13.7678 9.5 14.1339 9.86612C14.5 10.2322 14.5 10.8215 14.5 12C14.5 13.1785 14.5 13.7678 14.1339 14.1339C13.7678 14.5 13.1785 14.5 12 14.5C10.8215 14.5 10.2322 14.5 9.86612 14.1339C9.5 13.7678 9.5 13.1785 9.5 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'stop-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 12C9.5 10.8215 9.5 10.2322 9.86612 9.86612C10.2322 9.5 10.8215 9.5 12 9.5C13.1785 9.5 13.7678 9.5 14.1339 9.86612C14.5 10.2322 14.5 10.8215 14.5 12C14.5 13.1785 14.5 13.7678 14.1339 14.1339C13.7678 14.5 13.1785 14.5 12 14.5C10.8215 14.5 10.2322 14.5 9.86612 14.1339C9.5 13.7678 9.5 13.1785 9.5 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'stop-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 12C9.5 10.8215 9.5 10.2322 9.86612 9.86612C10.2322 9.5 10.8215 9.5 12 9.5C13.1785 9.5 13.7678 9.5 14.1339 9.86612C14.5 10.2322 14.5 10.8215 14.5 12C14.5 13.1785 14.5 13.7678 14.1339 14.1339C13.7678 14.5 13.1785 14.5 12 14.5C10.8215 14.5 10.2322 14.5 9.86612 14.1339C9.5 13.7678 9.5 13.1785 9.5 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'store' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19.9959 10.6211V19C19.9959 20.1046 19.1009 21 17.9969 21H6.00306C4.89906 21 4.00408 20.1046 4.00408 19V10.6211M7.5023 8.75L8.00204 3M7.5023 8.75C7.5023 11.6518 12 11.6518 12 8.75M7.5023 8.75C7.5023 11.9258 2.34736 11.2707 3.06933 8.50173L4.11399 4.49516C4.34361 3.6145 5.13856 3 6.04823 3H17.9518C18.8614 3 19.6564 3.6145 19.886 4.49516L20.9307 8.50173C21.6526 11.2707 16.4977 11.9258 16.4977 8.75M12 8.75V3M12 8.75C12 11.6518 16.4977 11.6518 16.4977 8.75M16.4977 8.75L15.998 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'subtract' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.6 4.35V3H13.8M8.4 3H10.2M4.8 3H3V4.8M3 10.2V8.4M3 13.8V15.6H4.35M10.2 15.6H8.4V16.2C8.4 17.8802 8.4 18.7202 8.72698 19.362C9.0146 19.9265 9.47354 20.3854 10.038 20.673C10.6798 21 11.5198 21 13.2 21H16.2C17.8802 21 18.7202 21 19.362 20.673C19.9265 20.3854 20.3854 19.9265 20.673 19.362C21 18.7202 21 17.8802 21 16.2V13.2C21 11.5198 21 10.6798 20.673 10.038C20.3854 9.47354 19.9265 9.0146 19.362 8.72698C18.7202 8.4 17.8802 8.4 16.2 8.4H15.6V10.2M13.8 15.6H15.6V13.8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'sun' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 3V5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 19.0039V21.0039" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5 12L3 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 12L19 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19 5L17 7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5 5L7 7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7 17L5 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18.9998 19.0001L17 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'sunrise' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.5 17.5C15.5 16.5717 15.1313 15.6815 14.4749 15.0251C13.8185 14.3687 12.9283 14 12 14C11.0717 14 10.1815 14.3687 9.52513 15.0251C8.86875 15.6815 8.5 16.5717 8.5 17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.8999 3V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.89795 11.3979L7.17595 12.6759" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 17.3999H4.8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19 17.3999H20.8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.624 12.6759L17.902 11.3979" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 21H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.2998 6.6L11.8998 3L15.4998 6.6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'sunset' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.5 17.5C15.5 16.5717 15.1313 15.6815 14.4749 15.0251C13.8185 14.3687 12.9283 14 12 14C11.0717 14 10.1815 14.3687 9.52513 15.0251C8.86875 15.6815 8.5 16.5717 8.5 17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.8999 3V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.89795 11.3979L7.17595 12.6759" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 17.3999H4.8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19 17.3999H20.8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.624 12.6759L17.902 11.3979" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 21H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.2998 7.0001L11.8998 10.6001L15.4998 7.0001" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'support' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18 6L14.4749 9.52513M6 18L9.52513 14.4749M6 6L9.52513 9.52513M18 18L14.4749 14.4749M9.52513 14.4749C8.17679 13.1265 8.17679 10.8735 9.52513 9.52513M9.52513 14.4749C10.8735 15.8232 13.1265 15.8232 14.4749 14.4749M14.4749 14.4749C15.8232 13.1265 15.8232 10.8735 14.4749 9.52513M14.4749 9.52513C13.1265 8.17679 10.8735 8.17679 9.52513 9.52513" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'swatches' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.5 21H18C19.6569 21 21 19.6018 21 17.8769C21 16.5687 21.1297 15.2472 19.7034 14.6243M7.98047 20.6633L18.2672 15.9943C18.9037 15.7054 19.3956 15.2141 19.7034 14.6243M12.0896 10.8372L15.1026 9.11901C16.6557 8.23335 18.6038 8.93341 19.3014 10.6278L19.8256 11.9012C20.2019 12.8152 20.1268 13.813 19.7034 14.6243M9.88182 18.3417C9.38152 20.2542 7.46235 21.3892 5.59521 20.8767C3.72808 20.3643 2.61982 18.3987 3.12011 16.4862L6.17921 5.27081C6.6323 3.60966 8.29434 2.64658 9.88929 3.12097L11.0604 3.4693C12.6748 3.94949 13.5964 5.71547 13.1047 7.38676L9.88182 18.3417Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6.49988 17L6.25739 17.854" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'table' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 3.5L9 20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 9.5H3.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'tablet' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17.7143 3H6.28571C5.02335 3 4 3.80589 4 4.8V19.2C4 20.1941 5.02335 21 6.28571 21H17.7143C18.9767 21 20 20.1941 20 19.2V4.8C20 3.80589 18.9767 3 17.7143 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.5 6H13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'tag' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.47222 5.5H14.7697C15.2914 5.5 15.7924 5.70382 16.1659 6.068L21.5156 11.284C21.9182 11.6765 21.9182 12.3235 21.5156 12.716L16.1659 17.932C15.7924 18.2962 15.2914 18.5 14.7697 18.5H4.47222C3.52253 18.5 2.25 17.9588 2.25 16.875V7.125C2.25 6.04117 3.52253 5.5 4.47222 5.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'tag-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.47222 5.5H14.7697C15.2914 5.5 15.7924 5.70382 16.1659 6.068L21.5156 11.284C21.9182 11.6765 21.9182 12.3235 21.5156 12.716L16.1659 17.932C15.7924 18.2962 15.2914 18.5 14.7697 18.5H4.47222C3.52253 18.5 2.25 17.9588 2.25 16.875V7.125C2.25 6.04117 3.52253 5.5 4.47222 5.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M6 12H11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M8.5 9.5L8.5 14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'tally-five' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M22 4L2 20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4 4V20M9.33333 4V20M14.6667 4V20M20 4V20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'tally-four' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4 4V20M9.33333 4V20M14.6667 4V20M20 4V20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'tally-one' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4 4V20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'tally-three' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4 4V20M9.33333 4V20M14.6667 4V20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'tally-two' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4 4V20M9.33333 4V20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'target' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 17.25C14.8995 17.25 17.25 14.8995 17.25 12C17.25 9.10051 14.8995 6.75 12 6.75C9.10051 6.75 6.75 9.10051 6.75 12C6.75 14.8995 9.10051 17.25 12 17.25Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 13.5C12.8284 13.5 13.5 12.8284 13.5 12C13.5 11.1716 12.8284 10.5 12 10.5C11.1716 10.5 10.5 11.1716 10.5 12C10.5 12.8284 11.1716 13.5 12 13.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'telephone' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.6 14.5215C13.205 17.0421 7.09582 10.9878 9.49995 8.45753C10.9678 6.91263 9.30963 5.14707 8.3918 3.84934C6.66924 1.41378 2.88771 4.77641 3.00256 6.91544C3.36473 13.6609 10.6615 21.6546 17.7275 20.9574C19.9381 20.7393 22.4778 16.7471 19.9423 15.2882C18.6745 14.5587 16.9342 13.1172 15.6 14.5215Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'telephone-call' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.6 14.5215C13.205 17.0421 7.09582 10.9878 9.49995 8.45753C10.9678 6.91263 9.30963 5.14707 8.3918 3.84934C6.66924 1.41378 2.88771 4.77641 3.00256 6.91544C3.36473 13.6609 10.6615 21.6546 17.7275 20.9574C19.9381 20.7393 22.4778 16.7471 19.9423 15.2882C18.6745 14.5587 16.9342 13.1172 15.6 14.5215Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 3C15.8565 3 17.637 3.7375 18.9497 5.05025C20.2625 6.36301 21 8.14348 21 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 7C14.7956 7 15.5587 7.31607 16.1213 7.87868C16.6839 8.44129 17 9.20435 17 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'telephone-forward' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.6 14.5215C13.205 17.0421 7.09582 10.9878 9.49995 8.45753C10.9678 6.91263 9.30963 5.14707 8.3918 3.84934C6.66924 1.41378 2.88771 4.77641 3.00256 6.91544C3.36473 13.6609 10.6615 21.6546 17.7275 20.9574C19.9381 20.7393 22.4778 16.7471 19.9423 15.2882C18.6745 14.5587 16.9342 13.1172 15.6 14.5215Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 5.5L21.4286 5.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19 3L21.5 5.5L19 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'telephone-in' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.6 14.5215C13.205 17.0421 7.09582 10.9878 9.49995 8.45753C10.9678 6.91263 9.30963 5.14707 8.3918 3.84934C6.66924 1.41378 2.88771 4.77641 3.00256 6.91544C3.36473 13.6609 10.6615 21.6546 17.7275 20.9574C19.9381 20.7393 22.4778 16.7471 19.9423 15.2882C18.6745 14.5587 16.9342 13.1172 15.6 14.5215Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 3L16 7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.5 7.5L16 7.5L16 4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'telephone-missed' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.6 14.5215C13.205 17.0421 7.09582 10.9878 9.49995 8.45753C10.9678 6.91263 9.30963 5.14707 8.3918 3.84934C6.66924 1.41378 2.88771 4.77641 3.00256 6.91544C3.36473 13.6609 10.6615 21.6546 17.7275 20.9574C19.9381 20.7393 22.4778 16.7471 19.9423 15.2882C18.6745 14.5587 16.9342 13.1172 15.6 14.5215Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17 3L21 7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 3L17 7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'telephone-out' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.6 14.5215C13.205 17.0421 7.09582 10.9878 9.49995 8.45753C10.9678 6.91263 9.30963 5.14707 8.3918 3.84934C6.66924 1.41378 2.88771 4.77641 3.00256 6.91544C3.36473 13.6609 10.6615 21.6546 17.7275 20.9574C19.9381 20.7393 22.4778 16.7471 19.9423 15.2882C18.6745 14.5587 16.9342 13.1172 15.6 14.5215Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 7.5L19.5 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 3L19.5 3L19.5 6.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'telephone-slash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.6836 13.3164L21 3M10.6836 13.3164C12.2139 14.872 14.3851 15.8003 15.6002 14.5215C16.9344 13.1172 18.6747 14.5587 19.9425 15.2882C22.4781 16.7472 19.9383 20.7393 17.7277 20.9574C14.071 21.3182 10.3525 19.3515 7.56529 16.4347M10.6836 13.3164L7.56529 16.4347M3 21L7.56529 16.4347M5.5 13.8449C4.05262 11.6517 3.12603 9.21128 3.00277 6.91545C2.88792 4.77641 6.66945 1.41378 8.39201 3.84935C9.30984 5.14708 10.968 6.91263 9.50016 8.45754C9.007 8.97658 8.87206 9.6439 8.98981 10.3551" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'terminal' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8 9L11 12L8 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13 15H16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'text-align-center' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.5 6H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7 10H17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4.5 14H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7 18H17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'text-align-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.5 6H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4.5 10H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4.5 14H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4.5 18H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'text-align-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.5 6H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4.5 14H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 18H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'text-justify' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.5 6H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4.5 10H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4.5 14H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4.5 18H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'thermometer' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.155 13.8603C14.1075 13.8313 14.0685 13.7913 14.0414 13.7439C14.0143 13.6964 14 13.6432 14 13.589V4.92879C14 4.41724 13.7893 3.92665 13.4142 3.56493C13.0391 3.20321 12.5304 3 12 3C11.4695 3 10.9608 3.20321 10.5857 3.56493C10.2106 3.92665 9.99993 4.41724 9.99993 4.92879V13.589C9.99984 13.6431 9.98563 13.6962 9.95861 13.7436C9.9316 13.7909 9.89264 13.8309 9.84535 13.8599C9.25293 14.232 8.77147 14.7468 8.44855 15.3534C8.12563 15.96 7.97242 16.6373 8.00407 17.3184C8.05175 18.3251 8.50597 19.2737 9.26958 19.9616C10.0332 20.6494 11.0456 21.0217 12.0902 20.999C13.1348 20.9763 14.1287 20.5603 14.8594 19.8399C15.5901 19.1196 15.9995 18.1521 16 17.1444C16.0003 16.4922 15.8317 15.8502 15.5095 15.2766C15.1873 14.7031 14.7217 14.2163 14.155 13.8603V13.8603Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'three' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.75 9.49281C8.75 6.16906 15 6.16906 15 9.49281C15 9.49281 15 12 11.875 12C15 12 15 14.5072 15 14.5072C15 17.8309 8.75 17.8309 8.75 14.5072" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'three-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 9.99426C9.5 7.33525 14.5 7.33525 14.5 9.99426C14.5 9.99426 14.5 12 12 12C14.5 12 14.5 14.0058 14.5 14.0058C14.5 16.6648 9.5 16.6648 9.5 14.0058" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'three-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 9.99426C9.5 7.33525 14.5 7.33525 14.5 9.99426C14.5 9.99426 14.5 12 12 12C14.5 12 14.5 14.0058 14.5 14.0058C14.5 16.6648 9.5 16.6648 9.5 14.0058" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'three-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 9.99426C9.5 7.33525 14.5 7.33525 14.5 9.99426C14.5 9.99426 14.5 12 12 12C14.5 12 14.5 14.0058 14.5 14.0058C14.5 16.6648 9.5 16.6648 9.5 14.0058" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'three-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 9.99426C9.5 7.33525 14.5 7.33525 14.5 9.99426C14.5 9.99426 14.5 12 12 12C14.5 12 14.5 14.0058 14.5 14.0058C14.5 16.6648 9.5 16.6648 9.5 14.0058" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'three-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 9.99426C9.5 7.33525 14.5 7.33525 14.5 9.99426C14.5 9.99426 14.5 12 12 12C14.5 12 14.5 14.0058 14.5 14.0058C14.5 16.6648 9.5 16.6648 9.5 14.0058" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'three-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 9.99426C9.5 7.33525 14.5 7.33525 14.5 9.99426C14.5 9.99426 14.5 12 12 12C14.5 12 14.5 14.0058 14.5 14.0058C14.5 16.6648 9.5 16.6648 9.5 14.0058" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'ticket' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19 19C20.1046 19 21 18.1046 21 17V14C19.8954 14 19 13.1046 19 12C19 10.8954 19.8954 10 21 10V7C21 5.89543 20.1046 5 19 5H5C3.89543 5 3 5.89543 3 7V10C4.10457 10 5 10.8954 5 12C5 13.1046 4.10457 14 3 14V17C3 18.1046 3.89543 19 5 19H19Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 11.75L12 12.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 8L12 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 15.5L12 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'ticket-slash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 8L12 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 15.5L12 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 17V14C4.10457 14 5 13.1046 5 12C5 10.8954 4.10457 10 3 10V7C3 5.89543 3.89543 5 5 5H15M5 19H19C20.1046 19 21 18.1046 21 17V14C19.8954 14 19 13.1046 19 12C19 10.8954 19.8954 10 21 10V7C21 5.89543 20.1046 5 19 5M3 21L21 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'toggle-left' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 12C21 9.23858 18.7614 7 16 7H8C5.23858 7 3 9.23858 3 12C3 14.7614 5.23858 17 8 17H16C18.7614 17 21 14.7614 21 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5.5 12C5.5 13.3807 6.61929 14.5 8 14.5C9.38071 14.5 10.5 13.3807 10.5 12C10.5 10.6193 9.38071 9.5 8 9.5C6.61929 9.5 5.5 10.6193 5.5 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'toggle-right' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 9.23858 5.23858 7 8 7H16C18.7614 7 21 9.23858 21 12C21 14.7614 18.7614 17 16 17H8C5.23858 17 3 14.7614 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18.5 12C18.5 13.3807 17.3807 14.5 16 14.5C14.6193 14.5 13.5 13.3807 13.5 12C13.5 10.6193 14.6193 9.5 16 9.5C17.3807 9.5 18.5 10.6193 18.5 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'tool' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 7.86022C21 7.42927 20.9439 7.01143 20.8386 6.61359C20.7465 6.26546 20.3171 6.18232 20.0625 6.43696L18.3398 8.15964C17.6496 8.84983 16.5306 8.84983 15.8404 8.15964C15.1502 7.46944 15.1502 6.35042 15.8404 5.66022L17.563 3.93754C17.8177 3.68291 17.7345 3.25347 17.3864 3.16136C16.9886 3.05609 16.5707 3 16.1398 3C13.4556 3 11.2796 5.17599 11.2796 7.86022C11.2796 8.43106 11.378 8.97891 11.5588 9.48774C11.6294 9.68651 11.5895 9.91108 11.4404 10.0602L3.29979 18.2008C2.90007 18.6005 2.90007 19.2486 3.29979 19.6483L4.35168 20.7002C4.7514 21.0999 5.39948 21.0999 5.7992 20.7002L13.9398 12.5597C14.0889 12.4105 14.3135 12.3706 14.5123 12.4412C15.0211 12.622 15.5689 12.7204 16.1398 12.7204C18.824 12.7204 21 10.5444 21 7.86022Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'train' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16 18H8M16 18L18 21M16 18C17.6569 18 19 16.6569 19 15V11M8 18L6 21M8 18C6.34315 18 5 16.6569 5 15V11M8 14V15M16 14V15M5 11H12M5 11V6M12 11H19M12 11V6M19 11V6M12 6H5M12 6H19M5 6C5 4.34315 6.34315 3 8 3H16C17.6569 3 19 4.34315 19 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'trash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.28613 8.57153L7.42899 20.0001H16.5718L17.7147 8.57153" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.5 15.5V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.5 15.5V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4.57129 6.28571H9.14272M9.14272 6.28571L9.52478 4.75746C9.63607 4.3123 10.0361 4 10.4949 4H13.5048C13.9637 4 14.3636 4.3123 14.4749 4.75746L14.857 6.28571M9.14272 6.28571H14.857M14.857 6.28571H19.4284" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'tree' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 17H19L14.5 10.5H17.5L12 3L6.5 10.5H9.5L5 17H12ZM12 17V21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'trending-down' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 18H21V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 7L7.44305 12.2228C7.75365 12.5879 7.90894 12.7704 8.10137 12.8623C8.27101 12.9434 8.46005 12.9749 8.64681 12.9534C8.85867 12.9291 9.06487 12.8069 9.47727 12.5626L12.3026 10.8887C12.688 10.6604 12.8807 10.5462 13.0808 10.5188C13.2574 10.4946 13.4372 10.518 13.6017 10.5866C13.7881 10.6644 13.9451 10.8241 14.2591 11.1435L21 18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'trending-up' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 7H21V13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 18L7.44305 12.7772C7.75365 12.4121 7.90894 12.2296 8.10137 12.1377C8.27101 12.0566 8.46005 12.0251 8.64681 12.0466C8.85867 12.0709 9.06487 12.1931 9.47727 12.4374L12.3026 14.1113C12.688 14.3396 12.8807 14.4538 13.0808 14.4812C13.2574 14.5054 13.4372 14.482 13.6017 14.4134C13.7881 14.3356 13.9451 14.1759 14.2591 13.8565L21 7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'triangle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.98054 10.7615C8.60706 5.58716 9.92033 3 12 3C14.0797 3 15.3929 5.58716 18.0195 10.7615L18.3467 11.4063C20.5294 15.7061 21.6207 17.856 20.6344 19.428C19.648 21 17.2078 21 12.3273 21H11.6727C6.7922 21 4.35195 21 3.36563 19.428C2.37931 17.856 3.47062 15.7061 5.65325 11.4063L5.98054 10.7615Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'truck' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.2069 16.4545C9.2069 17.8604 8.09533 19 6.72414 19C5.35295 19 4.24138 17.8604 4.24138 16.4545M9.2069 16.4545C9.2069 15.0487 8.09533 13.9091 6.72414 13.9091C5.35295 13.9091 4.24138 15.0487 4.24138 16.4545M9.2069 16.4545H14.7931M4.24138 16.4545H3V6C3 5.44771 3.44772 5 4 5H13.7931C14.3454 5 14.7931 5.44772 14.7931 6V8.18182M20.3793 16.4545C20.3793 17.8604 19.2677 19 17.8966 19C16.5254 19 15.4138 17.8604 15.4138 16.4545M20.3793 16.4545C20.3793 15.0487 19.2677 13.9091 17.8966 13.9091C16.5254 13.9091 15.4138 15.0487 15.4138 16.4545M20.3793 16.4545H21V11.3636L18.4852 8.78535C18.1088 8.39944 17.5926 8.18182 17.0535 8.18182H14.7931M15.4138 16.4545H14.7931M14.7931 16.4545V8.18182" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'tv' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 7L18.6316 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.5265 7L5.36865 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 9.15385C3 7.96431 3.89543 7 5 7H19C20.1046 7 21 7.96431 21 9.15385V18.8462C21 20.0357 20.1046 21 19 21H12H5C3.89543 21 3 20.0357 3 18.8462V9.15385Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'two' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.75 9.92073C8.75 6.02642 14.5192 6.02642 14.5192 9.92073C14.5192 12.8607 10.7499 15.3962 8.75 17C8.75 17 12.5 16.375 15 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'two-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 10.3366C9.5 7.22114 14.1154 7.22114 14.1154 10.3366C14.1154 12.6886 11.0999 14.7169 9.5 16C9.5 16 12.5 15.5 14.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'two-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 10.3366C9.5 7.22114 14.1154 7.22114 14.1154 10.3366C14.1154 12.6886 11.0999 14.7169 9.5 16C9.5 16 12.5 15.5 14.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'two-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 10.3366C9.5 7.22114 14.1154 7.22114 14.1154 10.3366C14.1154 12.6886 11.0999 14.7169 9.5 16C9.5 16 12.5 15.5 14.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'two-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 10.3366C9.5 7.22114 14.1154 7.22114 14.1154 10.3366C14.1154 12.6886 11.0999 14.7169 9.5 16C9.5 16 12.5 15.5 14.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'two-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 10.3366C9.5 7.22114 14.1154 7.22114 14.1154 10.3366C14.1154 12.6886 11.0999 14.7169 9.5 16C9.5 16 12.5 15.5 14.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'two-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 10.3366C9.5 7.22114 14.1154 7.22114 14.1154 10.3366C14.1154 12.6886 11.0999 14.7169 9.5 16C9.5 16 12.5 15.5 14.5 16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'type-bold' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5 3H13C14.0609 3 15.0783 3.47411 15.8284 4.31802C16.5786 5.16193 17 6.30653 17 7.5C17 8.69347 16.5786 9.83807 15.8284 10.682C15.0783 11.5259 14.0609 12 13 12H5V3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M5 12H15.0385C16.2217 12 17.3565 12.4741 18.1932 13.318C19.0299 14.1619 19.5 15.3065 19.5 16.5C19.5 17.6935 19.0299 18.8381 18.1932 19.682C17.3565 20.5259 16.2217 21 15.0385 21H5V12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'type-italic' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19 3H9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 21H5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 3L10 21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'type-text' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.5294 20L7.76471 4L3 20M4.59614 14.9701H10.9333M15.1765 11.9403C16.7647 10.9328 21 9.92537 21 13.4515C21 16.9776 21 20 21 20M21 14.459C19.4118 14.9627 14.6471 14.9627 14.6471 17.9851C14.6471 21.0075 19.4118 20 21 17.4813" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'type-underline' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6 3V10.5385C6 12.2522 6.63214 13.8957 7.75736 15.1075C8.88258 16.3192 10.4087 17 12 17C13.5913 17 15.1174 16.3192 16.2426 15.1075C17.3679 13.8957 18 12.2522 18 10.5385V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M4 21H20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'umbrella' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.6364 13C13.2121 10.5758 10.7879 10.5758 8.36364 13C5.87784 10.8693 4.48579 10.8693 2 13C2 7.47715 6.47715 3 12 3C17.5228 3 22 7.47715 22 13C19.5142 10.8693 18.1222 10.8693 15.6364 13Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 11.5V18.7729C12 22.2916 6.5 22.2916 6.5 18.7729" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'undo' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.63605 18.364C7.2647 19.9927 9.5147 21 12 21C16.9706 21 21 16.9706 21 12C21 7.02945 16.9706 3 12 3C7.94209 3 5.4824 5.7045 3 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 4.5V8.5H7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'union' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 16.2V14.1C21 12.4198 21 11.5798 20.673 10.938C20.3854 10.3735 19.9265 9.9146 19.362 9.62698C18.7202 9.3 17.8802 9.3 16.2 9.3H14.7V7.8C14.7 6.11984 14.7 5.27976 14.373 4.63803C14.0854 4.07354 13.6265 3.6146 13.062 3.32698C12.4202 3 11.5802 3 9.9 3H7.8C6.11984 3 5.27976 3 4.63803 3.32698C4.07354 3.6146 3.6146 4.07354 3.32698 4.63803C3 5.27976 3 6.11984 3 7.8V9.9C3 11.5802 3 12.4202 3.32698 13.062C3.6146 13.6265 4.07354 14.0854 4.63803 14.373C5.27976 14.7 6.11984 14.7 7.8 14.7H9.3V16.2C9.3 17.8802 9.3 18.7202 9.62698 19.362C9.9146 19.9265 10.3735 20.3854 10.938 20.673C11.5798 21 12.4198 21 14.1 21H16.2C17.8802 21 18.7202 21 19.362 20.673C19.9265 20.3854 20.3854 19.9265 20.673 19.362C21 18.7202 21 17.8802 21 16.2Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'unlink' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.9883 13L19.8903 9.09801C21.327 7.66132 21.375 5.38003 19.9975 4.00253C18.62 2.62504 16.3387 2.67302 14.902 4.10969L11 8.01167" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 9H4.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 4.5V3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 15H19.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 19.5V21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13 15.9617L9.10836 19.8428C7.67553 21.2718 5.46884 21.4569 4.0264 19.9494C2.58401 18.4419 2.70043 16.3101 4.13327 14.8811L8.02491 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'upload' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4 16.0042V17C4 18.6569 5.34315 20 7 20H17C18.6569 20 20 18.6569 20 17V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 15.5V4.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.5 8L12 4.5L8.5 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'user' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="7.5" r="3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.5 20.5C19.0246 11.1667 4.97538 11.1667 4.5 20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'user-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="7.5" r="3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.5 20.5C19.0246 11.1667 4.97538 11.1667 4.5 20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.2583 18.9918L11.2923 20.1735C11.3871 20.2819 11.5581 20.2739 11.6424 20.1572L13.742 17.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'user-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="9.1001" r="2.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17 19.2001C16.6831 13.0134 7.31692 13.0134 7 19.2001" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'user-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="9.1001" r="2.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.0459 18.705C7.80177 13.1784 16.1978 13.1784 16.9536 18.705" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'user-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="7.5" r="3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.5 20.5C19.0246 11.1667 4.97538 11.1667 4.5 20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 18.5H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'user-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="9.1001" r="2.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7 19.5251V19.2001C7.31692 13.0134 16.6831 13.0134 17 19.2001V19.5251" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'user-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="7.5" r="3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.5 20.5C19.0246 11.1667 4.97538 11.1667 4.5 20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10 18.5H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 16.5L12 20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'user-settings' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="7.5" r="3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.5 20.5C19.0246 11.1667 4.97538 11.1667 4.5 20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.1917 17.5654C11.5862 17.3551 11.7834 17.25 12 17.25C12.2166 17.25 12.4138 17.3551 12.8083 17.5654L12.9417 17.6365C13.3362 17.8467 13.5334 17.9518 13.6417 18.125C13.75 18.2982 13.75 18.5084 13.75 18.9289V19.0711C13.75 19.4916 13.75 19.7018 13.6417 19.875C13.5334 20.0482 13.3362 20.1533 12.9417 20.3635L12.8083 20.4346C12.4138 20.6449 12.2166 20.75 12 20.75C11.7834 20.75 11.5862 20.6449 11.1917 20.4346L11.0583 20.3635C10.6638 20.1533 10.4666 20.0482 10.3583 19.875C10.25 19.7018 10.25 19.4916 10.25 19.0711V18.9289C10.25 18.5084 10.25 18.2982 10.3583 18.125C10.4666 17.9518 10.6638 17.8467 11.0583 17.6365L11.1917 17.5654Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'user-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="9.1001" r="2.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7 20.5001V19.2001C7.31692 13.0134 16.6831 13.0134 17 19.2001V20.5001" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'user-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="9.1001" r="2.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17 19.2001C16.6831 13.0134 7.31692 13.0134 7 19.2001" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'user-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="7.5" r="3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19.5 20.5C19.0246 11.1667 4.97538 11.1667 4.5 20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.5859 17.5L13.4144 20.3284" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M13.4144 17.5L10.5859 20.3284" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'user' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21 19.7499C21 17.66 19.3304 14.682 17 14.023M15 19.75C15 17.099 12.3137 13.75 9 13.75C5.68629 13.75 3 17.099 3 19.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="9" cy="7.25" r="3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 10.25C16.6569 10.25 18 8.90685 18 7.25C18 5.59315 16.6569 4.25 15 4.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'users-group' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17 19.5C17 17.8431 14.7614 16.5 12 16.5C9.23858 16.5 7 17.8431 7 19.5M21 16.5004C21 15.2702 19.7659 14.2129 18 13.75M3 16.5004C3 15.2702 4.2341 14.2129 6 13.75M18 9.73611C18.6137 9.18679 19 8.3885 19 7.5C19 5.84315 17.6569 4.5 16 4.5C15.2316 4.5 14.5308 4.78885 14 5.26389M6 9.73611C5.38625 9.18679 5 8.3885 5 7.5C5 5.84315 6.34315 4.5 8 4.5C8.76835 4.5 9.46924 4.78885 10 5.26389M12 13.5C10.3431 13.5 9 12.1569 9 10.5C9 8.84315 10.3431 7.5 12 7.5C13.6569 7.5 15 8.84315 15 10.5C15 12.1569 13.6569 13.5 12 13.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'video' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 15.75V8.25C3 7.14543 3.89543 6.25 5 6.25H13.5C14.6046 6.25 15.5 7.14543 15.5 8.25V15.75C15.5 16.8546 14.6046 17.75 13.5 17.75H5C3.89543 17.75 3 16.8546 3 15.75Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.1675 6.99135L16.1675 10.5536C16.0609 10.6485 16 10.7843 16 10.927V12.7049C16 12.8475 16.0609 12.9834 16.1675 13.0783L20.1675 16.6405C20.4898 16.9276 21 16.6988 21 16.2671V7.36475C21 6.9331 20.4898 6.70428 20.1675 6.99135Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'video-slash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.1675 6.99135L16.1675 10.5536C16.0609 10.6485 16 10.7843 16 10.927V12.7049C16 12.8475 16.0609 12.9834 16.1675 13.0783L20.1675 16.6405C20.4898 16.9276 21 16.6988 21 16.2671V7.36475C21 6.9331 20.4898 6.70428 20.1675 6.99135Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 15.75V8.25C3 7.14543 3.89543 6.25 5 6.25H13.5M3 21L6.25 17.75M21 3L15.5 8.5M15.5 8.5V15.75C15.5 16.8546 14.6046 17.75 13.5 17.75H6.25M15.5 8.5L6.25 17.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'volume-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13 3V21C9.5 21 6.89925 16.4195 6.89925 16.4195C6.89925 16.4195 3 17.0061 3 15.4195V8.5054C3 6.91883 6.89925 7.5054 6.89925 7.5054C6.89925 7.5054 9.5 3 13 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16.3604 12.3225L17.739 13.898C17.8654 14.0425 18.0934 14.0319 18.2058 13.8762L21.0053 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'volume-high' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13 3V21C9.5 21 6.89925 16.4195 6.89925 16.4195C6.89925 16.4195 3 17.0061 3 15.4195V8.5054C3 6.91883 6.89925 7.5054 6.89925 7.5054C6.89925 7.5054 9.5 3 13 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18.1006 19C21.9666 15.134 21.9666 8.866 18.1006 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 16C18.2092 13.7908 18.2092 10.2092 16 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'volume-low' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13 3V21C9.5 21 6.89925 16.4195 6.89925 16.4195C6.89925 16.4195 3 17.0061 3 15.4195V8.5054C3 6.91883 6.89925 7.5054 6.89925 7.5054C6.89925 7.5054 9.5 3 13 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 16C18.2092 13.7908 18.2092 10.2092 16 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'volume-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13 3V21C9.5 21 6.89925 16.4195 6.89925 16.4195C6.89925 16.4195 3 17.0061 3 15.4195V8.5054C3 6.91883 6.89925 7.5054 6.89925 7.5054C6.89925 7.5054 9.5 3 13 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 12H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'volume-none' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13 3V21C9.5 21 6.89925 16.4195 6.89925 16.4195C6.89925 16.4195 3 17.0061 3 15.4195V8.5054C3 6.91883 6.89925 7.5054 6.89925 7.5054C6.89925 7.5054 9.5 3 13 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'volume-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13 3V21C9.5 21 6.89925 16.4195 6.89925 16.4195C6.89925 16.4195 3 17.0061 3 15.4195V8.5054C3 6.91883 6.89925 7.5054 6.89925 7.5054C6.89925 7.5054 9.5 3 13 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 12H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18.5 9.5L18.5 14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'volume-slash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18.1005 19C21.8154 15.2851 21.9606 9.35224 18.536 5.46397M16 16C18.2091 13.7908 18.2091 10.2092 16 8M3 21L7.16051 16.8395M21 3L18.536 5.46397M18.536 5.46397L13 11M13 11V21C10.1539 21 7.90247 17.9713 7.16051 16.8395M13 11L7.16051 16.8395M13 7V3C9.5 3 6.89925 7.5054 6.89925 7.5054C6.89925 7.5054 3 6.91883 3 8.5054V15.4195C3 15.8095 3.23557 16.0682 3.59092 16.2366" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'volume-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13 3V21C9.5 21 6.89925 16.4195 6.89925 16.4195C6.89925 16.4195 3 17.0061 3 15.4195V8.5054C3 6.91883 6.89925 7.5054 6.89925 7.5054C6.89925 7.5054 9.5 3 13 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M17 10L21 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M21 10L17 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'watch' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.6667 7C15.351 5.62267 15.2488 3 13.3186 3H10.6814C8.75115 3 8.64897 5.62267 8.33333 7M8.33333 17C8.64897 18.3773 8.75115 21 10.6814 21H13.3186C15.2488 21 15.351 18.3773 15.6667 17M17.5 10V14C17.5 15.6569 16.2688 17 14.75 17H9.25C7.73122 17 6.5 15.6569 6.5 14V10C6.5 8.34315 7.73122 7 9.25 7H14.75C16.2688 7 17.5 8.34315 17.5 10Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 10V12.5L13.6042 13.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'webcam' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.9998 17.4C15.9763 17.4 19.1998 14.1764 19.1998 10.2C19.1998 6.22355 15.9763 3 11.9998 3C8.02335 3 4.7998 6.22355 4.7998 10.2C4.7998 14.1764 8.02335 17.4 11.9998 17.4ZM11.9998 17.4V21M7.4998 21H16.4998M14.6998 10.2C14.6998 11.6912 13.491 12.9 11.9998 12.9C10.5086 12.9 9.2998 11.6912 9.2998 10.2C9.2998 8.70883 10.5086 7.5 11.9998 7.5C13.491 7.5 14.6998 8.70883 14.6998 10.2Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'wheel' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19.7938 16.5C17.3085 20.8047 11.8042 22.2795 7.49955 19.7943M19.7938 16.5C22.2791 12.1954 20.8042 6.69109 16.4995 4.20581M19.7938 16.5L13.7316 13M7.49955 19.7943C3.19492 17.309 1.72004 11.8047 4.20532 7.50004M7.49955 19.7943L10.9995 13.7321M4.20532 7.50004C6.6906 3.1954 12.1949 1.72053 16.4995 4.20581M4.20532 7.50004L10.2675 11M16.4995 4.20581L12.9995 10.268M13.7316 13C13.1793 13.9566 11.9561 14.2844 10.9995 13.7321M13.7316 13C14.2839 12.0435 13.9561 10.8203 12.9995 10.268M10.9995 13.7321C10.043 13.1798 9.71521 11.9566 10.2675 11M10.2675 11C10.8198 10.0435 12.043 9.7157 12.9995 10.268M13.9314 11.4823L20.6928 9.67059M12.5173 13.9319L14.329 20.6933M10.0677 12.5178L3.30625 14.3295M11.4818 10.0682L9.6701 3.30674" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'wifi' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2 9.48265C7.60313 4.17262 16.3966 4.17245 22 9.48265" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19 12.8995C15.134 9.0335 8.866 9.0335 5 12.8995" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 16.1569C13.7908 13.9477 10.2092 13.9477 8 16.1569" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 19.25V18.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'wifi-check' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2 9.48259C4.80159 6.82755 8.40078 5.5 12 5.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 6.32245L16.3786 7.89803C16.505 8.04251 16.733 8.03186 16.8454 7.87622L19.6449 4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19 12.8995C15.134 9.0335 8.866 9.0335 5 12.8995" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 16.1569C13.7908 13.9477 10.2092 13.9477 8 16.1569" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 19.25V18.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'wifi-low' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16 16.1569C13.7908 13.9477 10.2092 13.9477 8 16.1569" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 19.25V18.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'wifi-medium' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19 12.8995C15.134 9.0335 8.866 9.0335 5 12.8995" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 16.1569C13.7908 13.9477 10.2092 13.9477 8 16.1569" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 19.25V18.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'wifi-minus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2 9.48259C4.80159 6.82755 8.40078 5.5 12 5.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19 12.8995C15.134 9.0335 8.866 9.0335 5 12.8995" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.5 6H20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 16.1569C13.7908 13.9477 10.2092 13.9477 8 16.1569" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 19.25V18.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'wifi-plus' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2 9.48259C4.80159 6.82755 8.40078 5.5 12 5.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19 12.8995C15.134 9.0335 8.866 9.0335 5 12.8995" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.5 6H20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18 3.5L18 8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 16.1569C13.7908 13.9477 10.2092 13.9477 8 16.1569" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 19.25V18.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'wifi-slash' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M22 9.48267C20.6545 8.20757 19.125 7.23865 17.5 6.57593" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19 12.8996C17.5785 11.4781 15.8322 10.5793 14 10.2031M5 12.8996C6.16027 11.7393 7.53689 10.9273 9 10.4635" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 19.25V18.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 21L21 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2 9.48259C4.80159 6.82755 8.40078 5.5 12 5.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 16.1569C13.7908 13.9477 10.2092 13.9477 8 16.1569" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'wifi-x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2 9.48259C4.80159 6.82755 8.40078 5.5 12 5.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 4L20 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20 4L16 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M19 12.8995C15.134 9.0335 8.866 9.0335 5 12.8995" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M16 16.1569C13.7908 13.9477 10.2092 13.9477 8 16.1569" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12 19.25V18.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'winds' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18.3249 7C21.8096 7 21.8096 12 18.3249 12H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M18.411 21C21.863 21 21.863 16 18.411 16H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M10.8716 3C14.3777 3 14.3777 8 10.8716 8H3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'wine' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.4 21H15.6M12 21V14.25M11.25 14.25H12.75C15.5114 14.25 17.75 12.0114 17.75 9.25V3.5C17.75 3.22386 17.5261 3 17.25 3H6.75C6.47386 3 6.25 3.22386 6.25 3.5V9.25C6.25 12.0114 8.48858 14.25 11.25 14.25Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'wink-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 15C9.85038 15.6303 10.8846 16 12 16C13.1154 16 14.1496 15.6303 15 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 10.5C9.16667 10.5 9.31409 10.5 9.5 10.5C9.68591 10.5 9.83333 10.5 10 10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'wink-ghost' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 15C9.85038 15.6303 10.8846 16 12 16C13.1154 16 14.1496 15.6303 15 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 18.5615V12.0443C3 7.04928 7.02944 3 12 3C16.9706 3 21 7.04928 21 12.0443V18.5615C21 19.7226 20.0334 21.08 19 20.5608C18.1647 20.1411 16.777 20.0402 16 20.5608C15.1259 21.1464 13.8741 21.1464 13 20.5608C12.1148 19.9678 11.3511 19.9906 10.5 20.5608C9.6259 21.1464 8.3741 21.1464 7.5 20.5608C6.723 20.0402 5.83525 20.1411 5 20.5608C3.9666 21.08 3 19.7226 3 18.5615Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 10.5C9.16667 10.5 9.31409 10.5 9.5 10.5C9.68591 10.5 9.83333 10.5 10 10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'wink-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9 15C9.85038 15.6303 10.8846 16 12 16C13.1154 16 14.1496 15.6303 15 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.5 10.5V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9 10.5C9.16667 10.5 9.31409 10.5 9.5 10.5C9.68591 10.5 9.83333 10.5 10 10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'wrench' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.91743 7.07607C10.091 7.25312 10.1882 7.49114 10.1882 7.73906C10.1882 7.98697 10.091 8.225 9.91743 8.40204L8.40204 9.91743C8.225 10.091 7.98697 10.1882 7.73906 10.1882C7.49114 10.1882 7.25311 10.091 7.07607 9.91743L4.52761 7.36898C4.0334 6.87477 3.20109 7.03629 3.08246 7.72507C2.97001 8.37796 2.97196 9.04918 3.09205 9.70826C3.29911 10.8447 3.84761 11.8911 4.66444 12.7079C5.48127 13.5247 6.52763 14.0732 7.66409 14.2803C8.34375 14.4041 9.03633 14.4023 9.7084 14.279C10.5272 14.1288 11.4152 14.2566 12.0039 14.8452L17.5702 20.4115C17.947 20.7883 18.458 21 18.9909 21C19.5237 21 20.0347 20.7883 20.4115 20.4115C20.7883 20.0347 21 19.5237 21 18.9909C21 18.458 20.7883 17.947 20.4115 17.5702L14.8452 12.0039C14.2566 11.4152 14.1288 10.5272 14.279 9.7084C14.4023 9.03633 14.4041 8.34375 14.2803 7.66409C14.0732 6.52763 13.5247 5.48127 12.7079 4.66444C11.8911 3.84761 10.8447 3.29911 9.70826 3.09205C9.04918 2.97196 8.37796 2.97001 7.72507 3.08246C7.03629 3.20109 6.87476 4.0334 7.36898 4.52761L9.91743 7.07607Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'x' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M18 6.00005L6 18M5.99995 6L17.9999 18" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'x-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 9.00002L9 15M8.99997 9L14.9999 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'x-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 9.00002L9 15M8.99997 9L14.9999 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'x-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15 9.00002L9 15M8.99997 9L14.9999 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'x-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 9.00002L9 15M8.99997 9L14.9999 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'x-triangle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.98054 10.7615C8.60706 5.58716 9.92033 3 12 3C14.0797 3 15.3929 5.58716 18.0195 10.7615L18.3467 11.4063C20.5294 15.7061 21.6207 17.856 20.6344 19.428C19.648 21 17.2078 21 12.3273 21H11.6727C6.7922 21 4.35195 21 3.36563 19.428C2.37931 17.856 3.47062 15.7061 5.65325 11.4063L5.98054 10.7615Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14 11.5L10 15.5M9.99998 11.5L14 15.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'x-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 9.00002L9 15M8.99997 9L14.9999 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'yen' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M17.4545 12L12 12M12 12L6.54545 12M12 12L6 3.5M12 12L18 3.5M12 12V16.25M17.4545 16.25H12M12 16.25H6.54545M12 16.25V20.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'yen-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.1818 12.5L12 12.5M12 12.5L8.81818 12.5M12 12.5L8.5 7.5M12 12.5L15.5 7.5M12 12.5V15M15.1818 15H12M12 15H8.81818M12 15V17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'yen-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.1818 12.5L12 12.5M12 12.5L8.81818 12.5M12 12.5L8.5 7.5M12 12.5L15.5 7.5M12 12.5V15M15.1818 15H12M12 15H8.81818M12 15V17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'yen-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.1818 12.5L12 12.5M12 12.5L8.81818 12.5M12 12.5L8.5 7.5M12 12.5L15.5 7.5M12 12.5V15M15.1818 15H12M12 15H8.81818M12 15V17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'yen-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.1818 12.5L12 12.5M12 12.5L8.81818 12.5M12 12.5L8.5 7.5M12 12.5L15.5 7.5M12 12.5V15M15.1818 15H12M12 15H8.81818M12 15V17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'yen-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M15.1818 12.5L12 12.5M12 12.5L8.81818 12.5M12 12.5L8.5 7.5M12 12.5L15.5 7.5M12 12.5V15M15.1818 15H12M12 15H8.81818M12 15V17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'zero' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.75 13.875V10.125C8.75 8.39911 10.1491 7 11.875 7C13.6009 7 15 8.39911 15 10.125V13.875C15 15.6009 13.6009 17 11.875 17C10.1491 17 8.75 15.6009 8.75 13.875Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'zero-circle' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.5 13.5V10.5C9.5 9.11929 10.6193 8 12 8C13.3807 8 14.5 9.11929 14.5 10.5V13.5C14.5 14.8807 13.3807 16 12 16C10.6193 16 9.5 14.8807 9.5 13.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'zero-diamond' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 13.5V10.5C9.5 9.11929 10.6193 8 12 8C13.3807 8 14.5 9.11929 14.5 10.5V13.5C14.5 14.8807 13.3807 16 12 16C10.6193 16 9.5 14.8807 9.5 13.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M2.70662 10.2953C2.48261 10.5191 2.3049 10.7848 2.18365 11.0773C2.06241 11.3698 2 11.6834 2 12C2 12.3166 2.06241 12.6302 2.18365 12.9227C2.3049 13.2152 2.48261 13.4809 2.70662 13.7047L10.2953 21.2934C10.5191 21.5174 10.7848 21.6951 11.0773 21.8163C11.3698 21.9376 11.6834 22 12 22C12.3166 22 12.6302 21.9376 12.9227 21.8163C13.2152 21.6951 13.4809 21.5174 13.7047 21.2934L21.2934 13.7047C21.5174 13.4809 21.6951 13.2152 21.8163 12.9227C21.9376 12.6302 22 12.3166 22 12C22 11.6834 21.9376 11.3698 21.8163 11.0773C21.6951 10.7848 21.5174 10.5191 21.2934 10.2953L13.7047 2.70662C13.4809 2.48261 13.2152 2.3049 12.9227 2.18365C12.6302 2.06241 12.3166 2 12 2C11.6834 2 11.3698 2.06241 11.0773 2.18365C10.7848 2.3049 10.5191 2.48261 10.2953 2.70662L2.70662 10.2953Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'zero-hexagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 13.5V10.5C9.5 9.11929 10.6193 8 12 8C13.3807 8 14.5 9.11929 14.5 10.5V13.5C14.5 14.8807 13.3807 16 12 16C10.6193 16 9.5 14.8807 9.5 13.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M20.5 15.8008V8.19922C20.4997 7.86596 20.4122 7.53865 20.2465 7.25013C20.0807 6.96161 19.8424 6.72201 19.5556 6.55538L12.9444 2.7546C12.6573 2.58781 12.3316 2.5 12 2.5C11.6684 2.5 11.3427 2.58781 11.0556 2.7546L4.44444 6.55538C4.15758 6.72201 3.91931 6.96161 3.75355 7.25013C3.58778 7.53865 3.50034 7.86596 3.5 8.19922V15.8008C3.50034 16.134 3.58778 16.4613 3.75355 16.7499C3.91931 17.0384 4.15758 17.278 4.44444 17.4446L11.0556 21.2454C11.3427 21.4122 11.6684 21.5 12 21.5C12.3316 21.5 12.6573 21.4122 12.9444 21.2454L19.5556 17.4446C19.8424 17.278 20.0807 17.0384 20.2465 16.7499C20.4122 16.4613 20.4997 16.134 20.5 15.8008Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'zero-octagon' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 13.5V10.5C9.5 9.11929 10.6193 8 12 8C13.3807 8 14.5 9.11929 14.5 10.5V13.5C14.5 14.8807 13.3807 16 12 16C10.6193 16 9.5 14.8807 9.5 13.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M7.80537 3.46863C8.15891 3.11509 8.4505 3 8.93674 3H15.0633C15.5495 3 15.8411 3.11509 16.1946 3.46863L20.5314 7.80537C20.8849 8.15891 21 8.4505 21 8.93674V15.0633C21 15.5632 20.8752 15.8508 20.5314 16.1946L16.1946 20.5314C15.8411 20.8849 15.5495 21 15.0633 21H8.93674C8.43676 21 8.14919 20.8752 7.80537 20.5314L3.46863 16.1946C3.11509 15.8411 3 15.5495 3 15.0633V8.93674C3 8.43676 3.12481 8.14919 3.46863 7.80537L7.80537 3.46863Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'zero-square' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 13.5V10.5C9.5 9.11929 10.6193 8 12 8C13.3807 8 14.5 9.11929 14.5 10.5V13.5C14.5 14.8807 13.3807 16 12 16C10.6193 16 9.5 14.8807 9.5 13.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682C3 18.364 3 16.2426 3 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
                'zero-waves' => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.5 13.5V10.5C9.5 9.11929 10.6193 8 12 8C13.3807 8 14.5 9.11929 14.5 10.5V13.5C14.5 14.8807 13.3807 16 12 16C10.6193 16 9.5 14.8807 9.5 13.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.71278 3.64026C10.2941 3.14489 10.5847 2.8972 10.8886 2.75195C11.5915 2.41602 12.4085 2.41602 13.1114 2.75195C13.4153 2.8972 13.7059 3.14489 14.2872 3.64026C14.8856 4.15023 15.4938 4.40761 16.2939 4.47146C17.0552 4.53222 17.4359 4.56259 17.7535 4.67477C18.488 4.93421 19.0658 5.51198 19.3252 6.24652C19.4374 6.5641 19.4678 6.94476 19.5285 7.70608C19.5924 8.50621 19.8498 9.11436 20.3597 9.71278C20.8551 10.2941 21.1028 10.5847 21.248 10.8886C21.584 11.5915 21.584 12.4085 21.248 13.1114C21.1028 13.4153 20.8551 13.7059 20.3597 14.2872C19.8391 14.8981 19.5911 15.5102 19.5285 16.2939C19.4678 17.0552 19.4374 17.4359 19.3252 17.7535C19.0658 18.488 18.488 19.0658 17.7535 19.3252C17.4359 19.4374 17.0552 19.4678 16.2939 19.5285C15.4938 19.5924 14.8856 19.8498 14.2872 20.3597C13.7059 20.8551 13.4153 21.1028 13.1114 21.248C12.4085 21.584 11.5915 21.584 10.8886 21.248C10.5847 21.1028 10.2941 20.8551 9.71278 20.3597C9.10185 19.8391 8.48984 19.5911 7.70608 19.5285C6.94476 19.4678 6.5641 19.4374 6.24652 19.3252C5.51198 19.0658 4.93421 18.488 4.67477 17.7535C4.56259 17.4359 4.53222 17.0552 4.47146 16.2939C4.40761 15.4938 4.15023 14.8856 3.64026 14.2872C3.14489 13.7059 2.8972 13.4153 2.75195 13.1114C2.41602 12.4085 2.41602 11.5915 2.75195 10.8886C2.8972 10.5847 3.14489 10.2941 3.64026 9.71278C4.16089 9.10185 4.40892 8.48984 4.47146 7.70608C4.53222 6.94476 4.56259 6.5641 4.67477 6.24652C4.93421 5.51198 5.51198 4.93421 6.24652 4.67477C6.5641 4.56259 6.94476 4.53222 7.70608 4.47146C8.50621 4.40761 9.11436 4.15023 9.71278 3.64026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
        );

        public static function get_array_icons()
        {
                return self::$icons;
        }

        /**
         * Get the SVG code for the specified icon
         *
         * @since 1.0.0
         *
         * @param string $icon Icon name.
         * @param string $group Icon group.
         * @param int $size The icon-size in pixels.
         *
         * @return string
         */
        public static function get_svg($icon, $class = '')
        {

                $arr = self::$icons;

                $arr = apply_filters("togo_svg_icons", $arr);

                $svg = '';

                if (array_key_exists($icon, $arr)) {
                        $repl = '<svg aria-hidden="true" role="img" focusable="false" ';

                        $svg = preg_replace('/^<svg /', $repl, trim($arr[$icon]));
                }

                return '<span class="togo-svg-icon ' . esc_attr($class) . '">' . $svg . '</span>';
        }

        /**
         * Sanitize SVG code.
         *
         * @since 1.0.0
         *
         * @param string $svg SVG code.
         *
         * @return string
         */
        public static function sanitize_svg($svg)
        {
                $allowed   = array();
                $whitelist = array(
                        'a'              => array(
                                'class',
                                'clip-path',
                                'clip-rule',
                                'fill',
                                'fill-opacity',
                                'fill-rule',
                                'filter',
                                'id',
                                'mask',
                                'opacity',
                                'stroke',
                                'stroke-dasharray',
                                'stroke-dashoffset',
                                'stroke-linecap',
                                'stroke-linejoin',
                                'stroke-miterlimit',
                                'stroke-opacity',
                                'stroke-width',
                                'style',
                                'systemLanguage',
                                'transform',
                                'href',
                                'xlink:href',
                                'xlink:title',
                        ),
                        'circle'         => array(
                                'class',
                                'clip-path',
                                'clip-rule',
                                'cx',
                                'cy',
                                'fill',
                                'fill-opacity',
                                'fill-rule',
                                'filter',
                                'id',
                                'mask',
                                'opacity',
                                'r',
                                'requiredFeatures',
                                'stroke',
                                'stroke-dasharray',
                                'stroke-dashoffset',
                                'stroke-linecap',
                                'stroke-linejoin',
                                'stroke-miterlimit',
                                'stroke-opacity',
                                'stroke-width',
                                'style',
                                'systemLanguage',
                                'transform',
                        ),
                        'clipPath'       => array('class', 'clipPathUnits', 'id'),
                        'defs'           => array(),
                        'style'          => array('type'),
                        'desc'           => array(),
                        'ellipse'        => array(
                                'class',
                                'clip-path',
                                'clip-rule',
                                'cx',
                                'cy',
                                'fill',
                                'fill-opacity',
                                'fill-rule',
                                'filter',
                                'id',
                                'mask',
                                'opacity',
                                'requiredFeatures',
                                'rx',
                                'ry',
                                'stroke',
                                'stroke-dasharray',
                                'stroke-dashoffset',
                                'stroke-linecap',
                                'stroke-linejoin',
                                'stroke-miterlimit',
                                'stroke-opacity',
                                'stroke-width',
                                'style',
                                'systemLanguage',
                                'transform',
                        ),
                        'feGaussianBlur' => array(
                                'class',
                                'color-interpolation-filters',
                                'id',
                                'requiredFeatures',
                                'stdDeviation'
                        ),
                        'filter'         => array(
                                'class',
                                'color-interpolation-filters',
                                'filterRes',
                                'filterUnits',
                                'height',
                                'id',
                                'primitiveUnits',
                                'requiredFeatures',
                                'width',
                                'x',
                                'xlink:href',
                                'y',
                        ),
                        'foreignObject'  => array(
                                'class',
                                'font-size',
                                'height',
                                'id',
                                'opacity',
                                'requiredFeatures',
                                'style',
                                'transform',
                                'width',
                                'x',
                                'y',
                        ),
                        'g'              => array(
                                'class',
                                'clip-path',
                                'clip-rule',
                                'id',
                                'display',
                                'fill',
                                'fill-opacity',
                                'fill-rule',
                                'filter',
                                'mask',
                                'opacity',
                                'requiredFeatures',
                                'stroke',
                                'stroke-dasharray',
                                'stroke-dashoffset',
                                'stroke-linecap',
                                'stroke-linejoin',
                                'stroke-miterlimit',
                                'stroke-opacity',
                                'stroke-width',
                                'style',
                                'systemLanguage',
                                'transform',
                                'font-family',
                                'font-size',
                                'font-style',
                                'font-weight',
                                'text-anchor',
                        ),
                        'image'          => array(
                                'class',
                                'clip-path',
                                'clip-rule',
                                'filter',
                                'height',
                                'id',
                                'mask',
                                'opacity',
                                'requiredFeatures',
                                'style',
                                'systemLanguage',
                                'transform',
                                'width',
                                'x',
                                'xlink:href',
                                'xlink:title',
                                'y',
                        ),
                        'line'           => array(
                                'class',
                                'clip-path',
                                'clip-rule',
                                'fill',
                                'fill-opacity',
                                'fill-rule',
                                'filter',
                                'id',
                                'marker-end',
                                'marker-mid',
                                'marker-start',
                                'mask',
                                'opacity',
                                'requiredFeatures',
                                'stroke',
                                'stroke-dasharray',
                                'stroke-dashoffset',
                                'stroke-linecap',
                                'stroke-linejoin',
                                'stroke-miterlimit',
                                'stroke-opacity',
                                'stroke-width',
                                'style',
                                'systemLanguage',
                                'transform',
                                'x1',
                                'x2',
                                'y1',
                                'y2',
                        ),
                        'linearGradient' => array(
                                'class',
                                'id',
                                'gradientTransform',
                                'gradientUnits',
                                'requiredFeatures',
                                'spreadMethod',
                                'systemLanguage',
                                'x1',
                                'x2',
                                'xlink:href',
                                'y1',
                                'y2',
                        ),
                        'marker'         => array(
                                'id',
                                'class',
                                'markerHeight',
                                'markerUnits',
                                'markerWidth',
                                'orient',
                                'preserveAspectRatio',
                                'refX',
                                'refY',
                                'systemLanguage',
                                'viewBox',
                        ),
                        'mask'           => array(
                                'class',
                                'height',
                                'id',
                                'maskContentUnits',
                                'maskUnits',
                                'width',
                                'x',
                                'y'
                        ),
                        'metadata'       => array('class', 'id'),
                        'path'           => array(
                                'class',
                                'clip-path',
                                'clip-rule',
                                'd',
                                'fill',
                                'fill-opacity',
                                'fill-rule',
                                'filter',
                                'id',
                                'marker-end',
                                'marker-mid',
                                'marker-start',
                                'mask',
                                'opacity',
                                'requiredFeatures',
                                'stroke',
                                'stroke-dasharray',
                                'stroke-dashoffset',
                                'stroke-linecap',
                                'stroke-linejoin',
                                'stroke-miterlimit',
                                'stroke-opacity',
                                'stroke-width',
                                'style',
                                'systemLanguage',
                                'transform',
                        ),
                        'pattern'        => array(
                                'class',
                                'height',
                                'id',
                                'patternContentUnits',
                                'patternTransform',
                                'patternUnits',
                                'requiredFeatures',
                                'style',
                                'systemLanguage',
                                'viewBox',
                                'width',
                                'x',
                                'xlink:href',
                                'y',
                        ),
                        'polygon'        => array(
                                'class',
                                'clip-path',
                                'clip-rule',
                                'id',
                                'fill',
                                'fill-opacity',
                                'fill-rule',
                                'filter',
                                'id',
                                'class',
                                'marker-end',
                                'marker-mid',
                                'marker-start',
                                'mask',
                                'opacity',
                                'points',
                                'requiredFeatures',
                                'stroke',
                                'stroke-dasharray',
                                'stroke-dashoffset',
                                'stroke-linecap',
                                'stroke-linejoin',
                                'stroke-miterlimit',
                                'stroke-opacity',
                                'stroke-width',
                                'style',
                                'systemLanguage',
                                'transform',
                        ),
                        'polyline'       => array(
                                'class',
                                'clip-path',
                                'clip-rule',
                                'id',
                                'fill',
                                'fill-opacity',
                                'fill-rule',
                                'filter',
                                'marker-end',
                                'marker-mid',
                                'marker-start',
                                'mask',
                                'opacity',
                                'points',
                                'requiredFeatures',
                                'stroke',
                                'stroke-dasharray',
                                'stroke-dashoffset',
                                'stroke-linecap',
                                'stroke-linejoin',
                                'stroke-miterlimit',
                                'stroke-opacity',
                                'stroke-width',
                                'style',
                                'systemLanguage',
                                'transform',
                        ),
                        'radialGradient' => array(
                                'class',
                                'cx',
                                'cy',
                                'fx',
                                'fy',
                                'gradientTransform',
                                'gradientUnits',
                                'id',
                                'r',
                                'requiredFeatures',
                                'spreadMethod',
                                'systemLanguage',
                                'xlink:href',
                        ),
                        'rect'           => array(
                                'class',
                                'clip-path',
                                'clip-rule',
                                'fill',
                                'fill-opacity',
                                'fill-rule',
                                'filter',
                                'height',
                                'id',
                                'mask',
                                'opacity',
                                'requiredFeatures',
                                'rx',
                                'ry',
                                'stroke',
                                'stroke-dasharray',
                                'stroke-dashoffset',
                                'stroke-linecap',
                                'stroke-linejoin',
                                'stroke-miterlimit',
                                'stroke-opacity',
                                'stroke-width',
                                'style',
                                'systemLanguage',
                                'transform',
                                'width',
                                'x',
                                'y',
                        ),
                        'stop'           => array(
                                'class',
                                'id',
                                'offset',
                                'requiredFeatures',
                                'stop-color',
                                'stop-opacity',
                                'style',
                                'systemLanguage',
                        ),
                        'svg'            => array(
                                'class',
                                'clip-path',
                                'clip-rule',
                                'filter',
                                'id',
                                'mask',
                                'fill',
                                'stroke',
                                'preserveaspectRatio',
                                'requiredfeatures',
                                'style',
                                'systemlanguage',
                                'viewbox',
                                'width',
                                'height',
                                'xmlns',
                                'xmlns:se',
                                'xmlns:xlink',
                                'x',
                                'y',
                                'enable-background',
                        ),
                        'switch'         => array('class', 'id', 'requiredFeatures', 'systemLanguage'),
                        'symbol'         => array(
                                'class',
                                'fill',
                                'fill-opacity',
                                'fill-rule',
                                'filter',
                                'font-family',
                                'font-size',
                                'font-style',
                                'font-weight',
                                'id',
                                'opacity',
                                'preserveAspectRatio',
                                'requiredFeatures',
                                'stroke',
                                'stroke-dasharray',
                                'stroke-dashoffset',
                                'stroke-linecap',
                                'stroke-linejoin',
                                'stroke-miterlimit',
                                'stroke-opacity',
                                'stroke-width',
                                'style',
                                'systemLanguage',
                                'transform',
                                'viewBox',
                        ),
                        'text'           => array(
                                'class',
                                'clip-path',
                                'clip-rule',
                                'fill',
                                'fill-opacity',
                                'fill-rule',
                                'filter',
                                'font-family',
                                'font-size',
                                'font-style',
                                'font-weight',
                                'id',
                                'mask',
                                'opacity',
                                'requiredFeatures',
                                'stroke',
                                'stroke-dasharray',
                                'stroke-dashoffset',
                                'stroke-linecap',
                                'stroke-linejoin',
                                'stroke-miterlimit',
                                'stroke-opacity',
                                'stroke-width',
                                'style',
                                'systemLanguage',
                                'text-anchor',
                                'transform',
                                'x',
                                'xml:space',
                                'y',
                        ),
                        'textPath'       => array(
                                'class',
                                'id',
                                'method',
                                'requiredFeatures',
                                'spacing',
                                'startOffset',
                                'style',
                                'systemLanguage',
                                'transform',
                                'xlink:href',
                        ),
                        'title'          => array(),
                        'tspan'          => array(
                                'class',
                                'clip-path',
                                'clip-rule',
                                'dx',
                                'dy',
                                'fill',
                                'fill-opacity',
                                'fill-rule',
                                'filter',
                                'font-family',
                                'font-size',
                                'font-style',
                                'font-weight',
                                'id',
                                'mask',
                                'opacity',
                                'requiredFeatures',
                                'rotate',
                                'stroke',
                                'stroke-dasharray',
                                'stroke-dashoffset',
                                'stroke-linecap',
                                'stroke-linejoin',
                                'stroke-miterlimit',
                                'stroke-opacity',
                                'stroke-width',
                                'style',
                                'systemLanguage',
                                'text-anchor',
                                'textLength',
                                'transform',
                                'x',
                                'xml:space',
                                'y',
                        ),
                        'use'            => array(
                                'class',
                                'clip-path',
                                'clip-rule',
                                'fill',
                                'fill-opacity',
                                'fill-rule',
                                'filter',
                                'height',
                                'id',
                                'mask',
                                'stroke',
                                'stroke-dasharray',
                                'stroke-dashoffset',
                                'stroke-linecap',
                                'stroke-linejoin',
                                'stroke-miterlimit',
                                'stroke-opacity',
                                'stroke-width',
                                'style',
                                'transform',
                                'width',
                                'x',
                                'xlink:href',
                                'y',
                        ),
                );

                foreach ($whitelist as $tag => $attributes) {
                        $allowed[$tag] = array();

                        foreach ($attributes as $attribute) {
                                $allowed[$tag][$attribute] = true;
                        }
                }

                return wp_kses($svg, $allowed);
        }
}
