<?php

namespace Togo_Framework\Elementor\Controls;

use Elementor\Group_Control_Base;
use Elementor\Controls_Manager;

defined('ABSPATH') || exit;

/**
 * Elementor tooltip control.
 *
 * A base control for creating tooltip control.
 *
 * @since 1.0.0
 */
class Group_Control_Tooltip extends Group_Control_Base
{

	protected static $fields;

	public static function get_type()
	{
		return 'tooltip';
	}

	protected function init_fields()
	{
		$fields = [];

		$fields['skin'] = [
			'label'   => esc_html__('Tooltip Skin', 'togo-framework'),
			'type'    => Controls_Manager::SELECT,
			'options' => [
				''        => esc_html__('Black', 'togo-framework'),
				'white'   => esc_html__('White', 'togo-framework'),
				'primary' => esc_html__('Primary', 'togo-framework'),
			],
			'default' => '',
		];

		$fields['position'] = [
			'label'   => esc_html__('Tooltip Position', 'togo-framework'),
			'type'    => Controls_Manager::SELECT,
			'options' => [
				'top'          => esc_html__('Top', 'togo-framework'),
				'right'        => esc_html__('Right', 'togo-framework'),
				'bottom'       => esc_html__('Bottom', 'togo-framework'),
				'left'         => esc_html__('Left', 'togo-framework'),
				'top-left'     => esc_html__('Top Left', 'togo-framework'),
				'top-right'    => esc_html__('Top Right', 'togo-framework'),
				'bottom-left'  => esc_html__('Bottom Left', 'togo-framework'),
				'bottom-right' => esc_html__('Bottom Right', 'togo-framework'),
			],
			'default' => 'top',
		];

		return $fields;
	}

	protected function get_default_options()
	{
		return [
			'popover' => [
				'starter_title' => _x('Tooltip', 'Tooltip Control', 'togo-framework'),
				'starter_name'  => 'enable',
				'starter_value' => 'yes',
				'settings'      => [
					'render_type' => 'template',
				],
			],
		];
	}
}
