<!-- Container -->
<div class="asl-p-cont asl-new-bg asl-attributes-cont">
    <div class="hide">
        <svg xmlns="http://www.w3.org/2000/svg">
            <symbol id="i-plus" viewBox="0 0 32 32" width="13" height="13" fill="none" stroke="currentcolor"
                stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                <title><?php echo esc_attr__('Add','asl_locator') ?></title>
                <path d="M16 2 L16 30 M2 16 L30 16" />
            </symbol>
            <symbol id="i-trash" viewBox="0 0 32 32" fill="none" stroke="currentcolor" stroke-linecap="round"
                stroke-linejoin="round" stroke-width="2">>
                <title><?php echo esc_attr__('Trash','asl_locator') ?></title>
                <path
                    d="M28 6 L6 6 8 30 24 30 26 6 4 6 M16 12 L16 24 M21 12 L20 24 M11 12 L12 24 M12 6 L13 2 19 2 20 6" />
            </symbol>
            <symbol id="i-edit" fill="currentColor" viewBox="0 0 17 17">
                <title><?php echo esc_attr__('Edit','asl_locator') ?></title>
                <path
                    d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z" />
                <path fill-rule="evenodd"
                    d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z" />
            </symbol>
            <svg id="i-alert" viewBox="0 0 32 32" width="13" height="13" fill="none" stroke="currentcolor"
                stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                <title><?php echo esc_attr__('Warning','asl_locator') ?></title>
                <path d="M16 3 L30 29 2 29 Z M16 11 L16 19 M16 23 L16 25" />
            </svg>
        </svg>
    </div>
    <div class="container">
        <div class="row asl-inner-cont">
            <div class="col-md-12 ">

                <div class="asl-tabs mb-4 mt-4 ">
                    <div class="card p-0">
                        <div class="card-title">
                            <div class="flex-grow-1">
                                <h3 class="mb-2">
                                    <?php echo esc_attr__('Manage Attributes','asl_locator') ?>
                                </h3>
                                <p class="card-text mb-0">
                                    <?php echo esc_attr__('Add and manage extra features for stores.','asl_locator') ?>
                                </p>
                            </div>
                            <?php echo \AgileStoreLocator\Helper::getLangControl(); ?>
                        </div>
                    </div>
                    <div class="asl-tabs-body p-4">
                        <ul class="nav nav-pills justify-content-center">
                            <?php 
                     $counter = 1;
                     $ddl_controls = \AgileStoreLocator\Model\Attribute::get_controls();
                     foreach($ddl_controls as $control_key => $control_page):
                     ?>
                            <li class="rounded <?php echo ($counter == 1 ) ? 'active' : '' ?>"><a data-toggle="pill"
                                    href="#<?php echo $control_key ?>_tab"><?php echo asl_esc_lbl("manage"); ?>
                                    <?php echo $control_page['label']; ?></a>
                            </li>
                            <?php 
                     $counter++;
                     endforeach; 
                     ?>

                        </ul>
                        <div class="tab-content">
                            <?php 
                        $counter = 1;
                        $ddl_controls = \AgileStoreLocator\Model\Attribute::get_controls();
                        foreach($ddl_controls as $control_key => $control_page):
                     ?>
                            <div id="<?php echo $control_key ?>_tab"
                                class="tab-pane in <?php echo ($counter == 1 ) ? 'active' : '' ?>">
                                <div class="asl-attr-tab" data-tab-single="<?php echo $control_page['label'] ?>"
                                    data-tab-plural="<?php echo $control_page['plural'] ?>"
                                    data-tab-name="<?php echo $control_key ?>"
                                    data-tab-title="<?php echo $control_page['field'] ?>">
                                    <div class="asl-attr-listing">
                                        <div class="row pb-3">
                                            <div class="col-md-12 ">
                                                <button type="button" id="btn-asl-delete-all"
                                                    class="btn btn-danger btn-asl-delete-all mrg-r-10">
                                                    <i>
                                                        <svg width="13" height="13">
                                                            <use xlink:href="#i-trash"></use>
                                                        </svg>
                                                    </i>
                                                    <?php echo esc_attr__('Delete Selected','asl_locator') ?>
                                                </button>
                                                <button type="button" id="btn-asl-new-attr"
                                                    class="btn btn-success btn-asl-new-attr">
                                                    <i>
                                                        <svg style="margin-top:-3px;"  width="13" height="13">
                                                            <use xlink:href="#i-plus"></use>
                                                        </svg>
                                                    </i>
                                                    <?php echo esc_attr__('Add New','asl_locator') ?>
                                                </button>
                                            </div>
                                        </div>
                                        
                                        <table class="attribute-table table">
                                            <thead>
                                                <tr>
                                                    <th align="center"><input type="text" class="form-control sl-dt-wd-250 opacity-0"/></th>
                                                    <th align="center"><input type="text" class="form-control sl-dt-wd-200"  data-id="id"  placeholder="<?php echo esc_attr__('Search ID','asl_locator') ?>" />
                                                    </th>
                                                    <th align="center"><input type="text" class="form-control sl-dt-wd-300" data-id="name" placeholder="<?php echo esc_attr__('Search Name','asl_locator') ?>" />
                                                    </th>
                                                    <th align="center"><input type="text" class="form-control sl-dt-wd-250 opacity-0"/></th>
                                                    <th align="center"><input type="text" class="form-control sl-dt-wd-250 opacity-0"/></th>
                                                    <th align="center"><input type="text" class="form-control sl-dt-wd-250 opacity-0"/></th>
                                                </tr>
                                                <tr>
                                                    <th class=" sl-dt-wd-250"><a
                                                            class="select-all"><?php echo esc_attr__('Select All','asl_locator') ?></a>
                                                    </th>
                                                    <th align="center"><?php echo esc_attr__('ID','asl_locator') ?></th>
                                                    <th align="center"><?php echo esc_attr__('Name','asl_locator') ?>
                                                    </th>
                                                    <th align="center"><?php echo esc_attr__('Order','asl_locator') ?>
                                                    </th>
                                                    <th  class=" sl-dt-wd-200" align="center">
                                                        <?php echo esc_attr__('Created On','asl_locator') ?></th>
                                                    <th class="text-center">
                                                        <?php echo esc_attr__('Action','asl_locator') ?>&nbsp;</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <?php
                     $counter++; 
                     endforeach; 
                     ?>

                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>
</div>
<!-- asl-cont end-->
<!-- SCRIPTS -->
<hr>
<!-- SCRIPTS -->
<script type="text/javascript">
window.addEventListener("load", function() {
    asl_engine.pages.manage_attribute();
});
</script>
