<?php

$default_country = (isset($all_configs['default_country']))? $all_configs['default_country']: 'null';

?>
<section class="asl-cont asl-store-form">
    <div class="hide">
        <svg xmlns="http://www.w3.org/2000/svg">
            <symbol id="i-trash" viewBox="0 0 32 32" width="16" height="16" fill="none" stroke="currentcolor"
                stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                <title><?php echo esc_attr__('Trash','asl_locator') ?></title>
                <path
                    d="M28 6 L6 6 8 30 24 30 26 6 4 6 M16 12 L16 24 M21 12 L20 24 M11 12 L12 24 M12 6 L13 2 19 2 20 6" />
            </symbol>
            <symbol id="i-clock" viewBox="0 0 32 32" width="20" height="18" fill="none" stroke="currentcolor"
                stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                <circle cx="16" cy="16" r="14" />
                <path d="M16 8 L16 16 20 20" />
            </symbol>
            <symbol id="i-plus" viewBox="0 0 32 32" width="16" height="16" fill="none" stroke="currentcolor"
                stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                <title><?php echo esc_attr__('Add','asl_locator') ?></title>
                <path d="M16 2 L16 30 M2 16 L30 16" />
            </symbol>
            <symbol id="i-chevron-top" viewBox="0 0 32 32" width="13" height="13" fill="none" stroke="currentcolor"
                stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                <path d="M30 20 L16 8 2 20" />
            </symbol>
            <symbol id="i-chevron-bottom" viewBox="0 0 32 32" width="13" height="13" fill="none" stroke="currentcolor"
                stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                <path d="M30 12 L16 24 2 12" />
            </symbol>
        </svg>
    </div>
    <div class="sl-container">
        <div class="sl-row">
            <!-- Section Titile -->
            <div class="pol-md-12">
                <h1 class="section-title"><?php echo asl_esc_lbl('reg_store') ?></h1>
                <p><?php echo asl_esc_lbl('reg_store_ins') ?></p>
            </div>
        </div>
        <div class="sl-row">
            <div class="pol-md-12">
                <div id="sl-frm" class="asl-form sl-row" role="form" aria-label="store-registration-form">
                    <div class="pol-md-12">
                        <h2 class="sl-sub-title"><?php echo asl_esc_lbl('reg_store_info') ?></h2>
                    </div>
                    <!-- Name -->
                    <div class="pol-md-6 sl-field-title">
                        <div class="sl-form-group sl-group">
                            <label class="control-label" for="sl-title"><?php echo asl_esc_lbl('reg_company') ?></label>
                            <input class="form-control" id="sl-title" type="text" maxlength="255" name="title" required
                                data-pristine-required-message="Please choose a username">
                            <div class="help-block with-errors"></div>
                        </div>
                    </div>
                    <div class="pol-md-6 sl-field-desc">
                        <div class="sl-form-group sl-group">
                            <label class="control-label"
                                for="sl-description"><?php echo asl_esc_lbl('reg_name') ?></label>
                            <input class="form-control" id="sl-description" type="text" maxlength="255"
                                name="description" required>
                            <div class="help-block with-errors"></div>
                        </div>
                    </div>
                    <div class="pol-md-6 sl-field-url">
                        <div class="sl-form-group sl-group">
                            <label class="control-label"
                                for="sl-website"><?php echo asl_esc_lbl('reg_web_url') ?></label>
                            <input class="form-control" id="sl-website" type="text" maxlength="255" name="website">
                            <div class="help-block with-errors"></div>
                        </div>
                    </div>
                    <div class="pol-md-6 sl-field-phone">
                        <div class="sl-form-group sl-group">
                            <label class="control-label" for="sl-phone"><?php echo asl_esc_lbl('phone') ?></label>
                            <input class="form-control" id="sl-phone" type="text" maxlength="255" name="phone">
                            <div class="help-block with-errors"></div>
                        </div>
                    </div>
                    <div class="pol-md-6 sl-field-fax">
                        <div class="sl-form-group sl-group">
                            <label class="control-label" for="sl-fax"><?php echo asl_esc_lbl('fax') ?></label>
                            <input class="form-control" id="sl-fax" type="text" maxlength="255" name="fax">
                            <div class="help-block with-errors"></div>
                        </div>
                    </div>
                    <div class="pol-md-6 sl-field-email">
                        <div class="sl-form-group sl-group">
                            <label class="control-label" for="sl-email"><?php echo asl_esc_lbl('email') ?></label>
                            <input class="form-control" pattern="[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}"
                                id="sl-email" type="email" maxlength="255" name="email">
                            <div class="help-block with-errors"><?php echo asl_esc_lbl('reg_email_cor') ?></div>
                        </div>
                    </div>
                    <div class="pol-md-6 sl-field-categories">
                        <div class="sl-form-group sl-form-ddl sl-group">
                            <label for="sl-categories"
                                class="control-label"><?php echo asl_esc_lbl('categories_tab') ?></label>
                            <select class="form-control custom-select" id="sl-categories" multiple="multiple">
                                <?php foreach($all_categories as $category): ?>
                                <option value="<?php echo esc_attr($category->id) ?>">
                                    <?php echo esc_attr($category->category_name) ?></option>
                                <?php endforeach ?>
                            </select>
                            <div class="help-block with-errors"></div>
                        </div>
                    </div>
                    <div id="sl-grp-brand" class="pol-md-6 sl-field-brand">
                        <div class="sl-form-group sl-form-ddl sl-group">
                            <label for="sl-brand" class="control-label"><?php echo asl_esc_lbl('reg_brands') ?></label>
                            <select class="form-control custom-select" id="sl-brand" multiple="multiple">
                                <?php foreach($all_brand as $brand): ?>
                                <option value="<?php echo esc_attr($brand->id) ?>"><?php echo esc_attr($brand->name) ?>
                                </option>
                                <?php endforeach ?>
                            </select>
                            <div class="help-block with-errors"></div>
                        </div>
                    </div>
                    <div id="sl-grp-special" class="pol-md-6 sl-field-special">
                        <div class="sl-form-group sl-form-ddl sl-group">
                            <label for="sl-special"
                                class="control-label"><?php echo asl_esc_lbl('reg_specialities') ?></label>
                            <select class="form-control custom-select" id="sl-special" multiple="multiple">
                                <?php foreach($all_special as $special): ?>
                                <option value="<?php echo esc_attr($special->id) ?>">
                                    <?php echo esc_attr($special->name) ?></option>
                                <?php endforeach ?>
                            </select>
                            <div class="help-block with-errors"></div>
                        </div>
                    </div>
                    <div class="pol-md-12">
                        <h3 class="sl-sub-title"><?php echo asl_esc_lbl('reg_add_loc') ?></h3>
                    </div>
                    <div id="sl-grp-street" class="pol-md-6 sl-field-street">
                        <div class="sl-form-group sl-group">
                            <label class="control-label" for="sl-street"><?php echo asl_esc_lbl('reg_street') ?></label>
                            <input class="form-control" id="sl-street" type="text" maxlength="255" name="street">
                            <div class="help-block with-errors"></div>
                        </div>
                    </div>
                    <div id="sl-grp-city" class="pol-md-6 sl-field-city">
                        <div class="sl-form-group sl-group">
                            <label class="control-label" for="sl-city"><?php echo asl_esc_lbl('label_city') ?></label>
                            <input class="form-control" id="sl-city" type="text" maxlength="255" required name="city">
                            <div class="help-block with-errors"></div>
                        </div>
                    </div>
                    <div id="sl-grp-state" class="pol-md-6 sl-field-state">
                        <div class="sl-form-group sl-group">
                            <label class="control-label" for="sl-state"><?php echo asl_esc_lbl('label_state') ?></label>
                            <input class="form-control" id="sl-state" type="text" required maxlength="255" name="state">
                            <div class="help-block with-errors"></div>
                        </div>
                    </div>
                    <div id="sl-grp-postal_code" class="pol-md-6 sl-field-postal_code">
                        <div class="sl-form-group sl-group">
                            <label class="control-label"
                                for="sl-postal_code"><?php echo asl_esc_lbl('reg_post_code') ?></label>
                            <input class="form-control" id="sl-postal_code" type="text" maxlength="255" required
                                name="postal_code">
                            <div class="help-block with-errors"></div>
                        </div>
                    </div>
                    <div id="sl-grp-country" class="pol-md-6 sl-field-country">
                        <div class="sl-form-group sl-form-ddl sl-group">
                            <label class="control-label"
                                for="sl-country"><?php echo asl_esc_lbl('label_country') ?></label>
                            <select class="form-control custom-select" id="sl-country" required name="country">
                                <option value=""><?php echo asl_esc_lbl('select_country') ?></option>
                                <?php foreach($countries as $country): ?>
                                <option
                                    <?php if($default_country && $default_country == $country->id) echo 'selected' ?>
                                    value="<?php echo esc_attr($country->id) ?>">
                                    <?php echo esc_attr($country->country) ?></option>
                                <?php endforeach ?>
                            </select>
                            <div class="help-block with-errors"></div>
                        </div>
                    </div>
                    <?php if($all_configs['map'] != '0'): ?>
                    <div class="pol-md-12">
                        <div id="asl-register-map" class="asl-register-map"></div>
                    </div>
                    <?php endif; ?>
                    <div id="sl-grp-lat" class="pol-md-6 d-none">
                        <div class="sl-form-group sl-group">
                            <label class="control-label" for="sl-lat"><?php echo asl_esc_lbl('reg_lat') ?></label>
                            <input class="form-control" id="sl-lat" type="text" maxlength="255" name="lat">
                            <div class="help-block with-errors"></div>
                        </div>
                    </div>
                    <div id="sl-grp-lng" class="pol-md-6 d-none">
                        <div class="sl-form-group sl-group">
                            <label class="control-label" for="sl-lng"><?php echo asl_esc_lbl('store_schedule') ?></label>
                            <input class="form-control" id="sl-lng" type="text" maxlength="255" name="lng">
                            <div class="help-block with-errors"></div>
                        </div>
                    </div>
                    <div class="pol-md-12 sl-field-hours">
                        <div class="sl-row">
                            <div class="pol-md-12">
                                <div
                                    class="sl-form-group sl-group d-md-flex justify-content-between align-items-center">
                                    <h3 class="sl-sub-title"><?php echo asl_esc_lbl('store_schedule') ?>
                                    </h3>
                                    <a id="asl-time-cp" class="btn btn-dark"
                                        title="<?php echo esc_attr__('Copy/Paste Monday Timing','asl_locator') ?>">
                                        <i class="me-2">
                                            <svg width="16" height="17">
                                                <use xlink:href="#i-plus"></use>
                                            </svg>
                                        </i><?php echo asl_esc_lbl('same_everyday') ?>
                                    </a>
                                </div>
                            </div>
                            <div class="pol-md-12">
                                <div class="table-responsive">
                                    <table class="table  asl-time-details table-striped">
                                        <tbody>
                                            <?php
                                            $asl_day_keys = array('mon', 'tue', 'wed', 'thu', 'fri', 'sat', 'sun');
                                            foreach ($asl_day_keys as $index => $day_key):
                                                $start_id = 'asl-starting-time-' . ($index + 1);
                                                $end_id   = 'asl-ending-time-' . ($index + 1);
                                                $toggle_id = 'cmn-toggle-' . $index;
                                            ?>
                                            <tr>
                                                <td colspan="1"><span class="lbl-day"><?php echo asl_esc_lbl($day_key); ?></span>
                                                </td>
                                                <td colspan="3">
                                                    <div class="asl-all-day-times" data-day="<?php echo esc_attr($day_key); ?>">
                                                        <div class="form-group">
                                                            <div class="input-group bootstrap-asltimepicker">
                                                                <label class="sr-only control-label" for="<?php echo esc_attr($start_id); ?>"><?php echo asl_esc_lbl('starting_time'); ?></label>
                                                                <input type="text" value="9:30 AM" id="<?php echo esc_attr($start_id); ?>"
                                                                    class="form-control asl-start-time asltimepicker validate[required,funcCall[ASLmatchTime]]"
                                                                    placeholder="<?php echo asl_esc_lbl('start_time'); ?>">
                                                                <span class="input-group-append add-on"><span
                                                                        class="input-group-text">
                                                                        <svg width="20" height="18">
                                                                            <use xlink:href="#i-clock"></use>
                                                                        </svg>
                                                                    </span></span>
                                                            </div>
                                                            <div class="input-group bootstrap-asltimepicker">
                                                                <label class="sr-only control-label" for="<?php echo esc_attr($end_id); ?>"><?php echo asl_esc_lbl('ending_time'); ?></label>
                                                                <input type="text" value="6:30 PM" id="<?php echo esc_attr($end_id); ?>"
                                                                    class="form-control asl-end-time asltimepicker validate[required]"
                                                                    placeholder="<?php echo asl_esc_lbl('end_time'); ?>">
                                                                <span class="input-group-append add-on"><span
                                                                        class="input-group-text">
                                                                        <svg width="20" height="18">
                                                                            <use xlink:href="#i-clock"></use>
                                                                        </svg>
                                                                    </span></span>
                                                            </div>
                                                            <span class="add-k-delete glyp-trash text-danger">
                                                                <svg width="16" height="16">
                                                                    <use xlink:href="#i-trash"></use>
                                                                </svg>
                                                            </span>
                                                        </div>
                                                        <div class="asl-closed-lbl">
                                                            <div class="a-swith">
                                                                <input id="<?php echo esc_attr($toggle_id); ?>"
                                                                    class="cmn-toggle cmn-toggle-round" type="checkbox"
                                                                    checked="checked">
                                                                <label for="<?php echo esc_attr($toggle_id); ?>"></label>
                                                                <span><?php echo asl_esc_lbl('closed'); ?></span>
                                                                <span><?php echo asl_esc_lbl('open_24'); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="add-k-add glyp-add float-end text-primary">
                                                        <svg width="16" height="16">
                                                            <use xlink:href="#i-plus"></use>
                                                        </svg>
                                                    </span>
                                                </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="sl-grp-desc" class="pol-md-12">
                        <div class="sl-row">
                            <div class="pol-md-12">
                                <h3 class="sl-sub-title"><?php echo asl_esc_lbl('reg_add_data') ?></h3>
                            </div>
                            <?php
                      // Organize fields into sections based on their types
                      foreach ($fields as $fieldName => $fieldData) {
                          
                        $field       = new \AgileStoreLocator\Form\CustomField($fieldData);
                        $html_field  = $field->render();
                        if($html_field) {
                            echo '<div class="pol-md-6">';
                            echo $html_field;
                            echo '</div>'; 
                        }
                      }
                      ?>
                            <div class="pol-md-6 sl-field-desc-2">
                                <div class="sl-form-group sl-group">
                                    <label for="sl-description_2"
                                        class="control-label"><?php echo asl_esc_lbl('reg_add_desc') ?></label>
                                    <textarea class="form-control" rows="3" id="sl-description_2"
                                        name="description_2"></textarea>
                                    <div class="help-block with-errors"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="pol-md-12">
                        <div class="sl-form-group">
                            <div class="custom-control custom-checkbox">
                                <input class="custom-control-input" type="checkbox" value="" id="sl-agr-check" required>
                                <label class="custom-control-label" for="sl-agr-check">
                                    <?php echo asl_esc_lbl('reg_agree') ?>
                                </label>
                                <div class="invalid-feedback">
                                    <?php echo asl_esc_lbl('reg_agree2') ?></label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php               
                    if (method_exists('WPCaptcha_Functions', 'captcha_fields_print')) {
                        echo '<div class="sl-form-recaptcha mt-2">';
                        WPCaptcha_Functions::captcha_fields_print();
                        echo '</div>';
                    }
                  ?>
                    <div class="pol-md-12">
                        <div class="sl-form-group mt-3">
                            <a data-loading-text="<?php echo asl_esc_lbl('reg_registering') ?>"
                                class="btn btn-default btn-primary disabled"
                                id="sl-btn-save"><?php echo asl_esc_lbl('reg_register') ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
