<?php

$list_column = [
'md' => 12,
'lg' => 6,
'xl' => 6,
];

$map_column = [
'md' => 12,
'lg' => 6,
'xl' =>6,
];

$this->overrideColumnConfigs($all_configs, $list_column, $map_column);

list($list_class, $map_class) = $this->createColClasses($list_column, $map_column);

$geo_btn_class      = ($all_configs['geo_button'] == '1')? 'asl-geo icon-direction-outline':'icon-search';
$search_type_class  = ($all_configs['search_type'] == '1')? 'asl-search-name':'asl-search-address';
$panel_order        = (isset($all_configs['map_top']))? $all_configs['map_top']: '2';

$ddl_class_grid = ($all_configs['search_2'])? 'pol-lg-4 pol-md-6 pol-sm-12': 'pol-lg-4 pol-md-6 pol-sm-12';
$tsw_class_grid = ($all_configs['search_2'])? 'pol-lg-2 pol-md-3 pol-sm-12': 'pol-lg-2 pol-md-3 pol-sm-12';
$adv_class_grid = ($all_configs['search_2'])? 'pol-lg-8 pol-md-7': 'pol-lg-8 pol-md-7';

$ddl_class      = '';



$class = (isset($all_configs['css_class']))? ' '.$all_configs['css_class']: '';

if($all_configs['layout'] == '1') {
    $all_configs['advance_filter'] = '0';
    $class .= ' asl-adv-lay1';
}


if($all_configs['display_list'] == '0' || $all_configs['first_load'] == '3' || $all_configs['first_load'] == '4')
$class .= ' map-full';
else if($all_configs['first_load'] == '5') {
$class .= ' sl-search-only';
}

if($all_configs['pickup'] || $all_configs['ship_from'])
$class .= ' sl-pickup-tmpl';

if($all_configs['full_width'])
$class .= ' full-width';

if(isset($all_configs['full_map']))
$class .= ' map-full-width';

if($all_configs['advance_filter'] == '0')
$class .= ' no-asl-filters';

if($all_configs['advance_filter'] == '1' && $all_configs['layout'] == '1')
$class .= ' asl-adv-lay1';


//add Full height
$class .= ' '.$all_configs['full_height'];

$layout_code        = ($all_configs['layout'] == '1'  || $all_configs['layout'] == '2')? '1': '0';
$default_addr       = (isset($all_configs['default-addr']))?$all_configs['default-addr']: '';
$container_class    = (isset($all_configs['full_width']) && $all_configs['full_width'])? 'sl-container-fluid': 'sl-container';

$btn_text = ($all_configs['geo_button'] == '1')?__('Current Location','asl_locator'):__('Search Location','asl_locator');

$all_configs['ddl_max_height'] = 'none';


// Change the width of infobox
// Ensure infobox width has a sensible default when not provided or empty
$all_configs['infobox_width'] = (isset($all_configs['infobox_width']) && $all_configs['infobox_width']) ? $all_configs['infobox_width'] : '320';

// If the scroll_field is not set and not empty, default to 'state'
$all_configs['scroll_field'] = (isset($all_configs['scroll_field']) && !empty($all_configs['scroll_field']))? $all_configs['scroll_field']: 'state';
$all_configs['sort_by']      = (isset($all_configs['scroll_field']))? $all_configs['scroll_field']: 'state';

?>
<style type="text/css">
<?php echo esc_attr($css_code);

?>@media(max-width:991px) {
    #asl-storelocator.asl-cont .asl-panel {
        order: <?php echo esc_attr($panel_order);
        ?>;
    }
}
</style>
<section id="asl-storelocator" class="asl-cont asl-template-6 asl-layout-<?php echo ($all_configs['layout'] != '0')? '1': '0'; ?> asl-bg-<?php echo esc_attr($all_configs['color_scheme'].$class); ?> asl-text-<?php echo esc_attr($all_configs['font_color_scheme']) ?>">
    <div class="asl-wrapper">
        <div class="<?php echo esc_attr($container_class); ?>">
            <!-- GDPR -->
            <?php if($all_configs['gdpr'] == '1'): ?>
            <div class="sl-gdpr-cont">
                <div class="gdpr-ol"></div>
                <div class="gdpr-ol-bg">
                    <div class="gdpr-box">
                        <p><?php echo asl_esc_lbl('label_gdpr') ?></p>
                        <a class="btn btn-asl" id="sl-btn-gdpr"><?php echo asl_esc_lbl('load','asl_locator') ?></a>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <div class="sl-row">
                <div class="pol-12">
                    <div class="sl-main-cont">
                        <div id="asl-panel" class="sl-row no-gutters sl-main-row">
                            <div class="<?php echo esc_attr($map_class) ?> asl-map">
                                <div class="sl-map-image">
                                    <div id="asl-map-canv" class="asl-map-canv"></div>
                                    <?php include ASL_PLUGIN_PATH.'public/partials/_agile_modal.php'; ?>
                                </div>
                            </div>
                            <div id="asl-list" class="asl-panel <?php echo esc_attr($list_class) ?>">
                                <div class="asl-overlay" id="map-loading">
                                    <div class="white"></div>
                                    <div class="sl-loading">
                                        <i class="animate-sl-spin icon-spin3"></i>
                                        <?php echo asl_esc_lbl('loading') ?>
                                    </div>
                                </div>
                                <div class="asl-panel-inner">
                                    <!-- Parent Div -->
                                    <div class="asl-panel-top-head">
                                        <div class="sl-container">
                                            <div class="sl-row Filter_section ">
                                                <div class="pol-12 search_filter p-0">
                                                    <label id="auto-complete-search" class="mb-2"><?php echo asl_esc_lbl('search_loc') ?></label>
                                                    <div class="sl-search-group d-flex">
                                                        <i  class="icon-search" ></i>
                                                        <input type="text" value="<?php echo esc_attr($default_addr) ?>" data-submit="disable" tabindex="2"  id="auto-complete-search" placeholder="<?php echo asl_esc_lbl( 'enter_loc') ?>" class="asl-search-address form-control isp_ignore">
                                                        <button aria-label="<?php echo esc_attr($btn_text) ?>" type="button" class="span-geo"><i  class="asl-geo icon-direction-outline" aria-hidden="true"></i></button>
                                                        <button type="button" aria-label="<?php echo asl_esc_lbl('search') ?>" class="asl-search-btn"><?php echo asl_esc_lbl('search') ?></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="sl-main-cont-box">
                                        <template id="asl-scroll-chip-slider-template">
                                            <div class="sl-scroll-slider" data-chip-slider>
                                                <button class="sl-nav left is-hidden" data-left aria-label="<?php echo asl_esc_lbl('scroll_left') ?>">
                                                    <span class="icon-left-open-big" aria-hidden="true"></span>
                                                    <span class="sr-only"><?php echo asl_esc_lbl('scroll_left') ?></span>
                                                </button>
                                                <ul class="sl-scroll-track list-unstyled gap-2" data-track data-scroll-chip-list role="list" aria-label="Store navigation shortcuts" style="list-style: none; margin: 0; padding: 0; display: flex; flex-wrap: nowrap;"></ul>
                                                <button class="sl-nav right is-hidden" data-right aria-label="<?php echo asl_esc_lbl('scroll_right') ?>">
                                                    <span class="icon-right-open-big" aria-hidden="true"></span>
                                                    <span class="sr-only"><?php echo asl_esc_lbl('scroll_right') ?></span>
                                                </button>
                                            </div>
                                        </template>
                                        <div class="sl-list-wrapper">
                                            <ul id="p-statelist" class="sl-list panel-inner p-0">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <!-- No Item -->
                                <div class="sl-no-found-section d-none">
                                    <div class="sl-no-found">
                                        <div class="sl-row">
                                            <div class="pol-12">
                                                <h6><?php echo asl_esc_lbl('no_search_item') ?></h6>
                                                <p><?php echo asl_esc_lbl('no_search_item_desc') ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="directions-cont hide">
                                    <div class="agile-modal-header">
                                        <button type="button" class="close"><span aria-hidden="true">×</span></button>
                                        <h4><?php echo asl_esc_lbl('store_direc') ?></h4>
                                    </div>
                                    <div class="rendered-directions" id="asl-rendered-dir" style="direction: ltr;">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include ASL_PLUGIN_PATH.'public/partials/_lead_modal.php'; ?>
    <div id="asl-svg-icons" style="display:none;">
    <!-- 1) Ripple Pin (pin + pulsing concentric rings) -->
    <div id="asl-icon-scroll">
        <svg xmlns="http://www.w3.org/2000/svg" width="1rem" height="1rem" viewBox="0 0 24 24" aria-hidden="true">
        <!-- Outer rings (stroke follows currentColor) -->
        <g fill="none" stroke="currentColor" stroke-width="1" opacity="0.7">
            <circle cx="12" cy="21" r="3.5"/>
            <circle cx="12" cy="21" r="6.5" opacity="0.45"/>
        </g>
        <!-- Pin body -->
        <path fill="currentColor" d="M12 2a7 7 0 0 0-7 7c0 5.2 7 12 7 12s7-6.8 7-12a7 7 0 0 0-7-7z"/>
        <!-- Inner target -->
        <circle cx="12" cy="9" r="2.75" fill="#fff"/>
        <circle cx="12" cy="9" r="1.25" fill="currentColor"/>
        </svg>
    </div>
</section>
<!-- This plugin is developed by "Agile Store Locator for WordPress" https://agilestorelocator.com -->
