<?php

/**
 * AX Social Stream
 * Copyright © 2014 Axent Media LLC, All Rights Reserved.
 * https://axentmedia.com/support/
 */

// r3.9.0 < compatibility fix
if (get_option("SB_Settings_Page")) {
	if (update_option("AXS_Settings_Page", get_option("SB_Settings_Page"))) {
		delete_option("SB_Settings_Page");
	}
}
// END - r3.9.0 < compatibility fix

// Create a custom post type for Social Streams - this class deals with front-end components so checking with is_admin() is not necessary.
include( AXS_DIRNAME . '/admin/SB_Social_Boards.php' );
new AXS_Social_Boards(
    'sb_posts',          // the post type slug
    null,                // the argument array. Here null is passed because it is defined inside the class.
    AXS_FILE,             // the caller script path.
    'social-board-admin' // the text domain.
);

// Create a custom post type for themes
include( AXS_DIRNAME . '/admin/SB_Themes.php' );
new AXS_Themes(
    'sb_themes',         // the post type slug
    null,                // the argument array. Here null is passed because it is defined inside the class.
    AXS_FILE,             // the caller script path.
    'social-board-admin' // the text domain.
);

// Create a custom post type for ads
include( AXS_DIRNAME . '/admin/SB_Board_Ads.php' );
new AXS_Board_Ads(
    'sb_ads',            // the post type slug
    null,                // the argument array. Here null is passed because it is defined inside the class.
    AXS_FILE,             // the caller script path.
    'social-board-admin' // the text domain.
);

// get enabled layouts
$enabled_layouts = axs_enabled_layouts();

if ($enabled_layouts['feed']) {
    // Create widgets - this class also deals with front-end components so no need to check with is_admin().
    include( AXS_DIRNAME . '/admin/SB_Widget.php' );
    new SB_Widget( __( 'Social Stream', 'social-board-admin' ) ); // the widget title
}

// Create admin pages.
if ( is_admin() ) {
    add_action( 'admin_enqueue_scripts', 'load_admin_style' );
    
    // Create meta boxes with form fields that appear in post definition pages (where you create a post) of the given post type.
    include( AXS_DIRNAME . '/admin/SB_MetaBox_Social_Boards.php' );
    new AXS_MetaBox_Social_Boards(
        'posts_metabox',                                     // meta box ID
        __( 'Social Stream Configurations', 'social-board-admin' ), // title
        array( 'sb_posts' ),                                 // post type slugs: post, page, etc - setting multiple slugs is possible
        'normal',                                            // context (what kind of metabox this is)
        'default'                                            // priority
    );
    
    // Create meta boxes for filtering tabs
    include( AXS_DIRNAME . '/admin/SB_MetaBox_Filters.php' );
    new AXS_MetaBox_Filters(
        'sb_metabox_filters',                                     // meta box ID
        __( 'Extra Filtering Tabs', 'social-board-admin' ), // title
        array( 'sb_posts' ),                                 // post type slugs: post, page, etc - setting multiple slugs is possible
        'normal',                                            // context (what kind of metabox this is)
        'default'                                            // priority
    );
    
    // Create meta boxes for manipulation section
    include( AXS_DIRNAME . '/admin/SB_MetaBox_Social_Boards_Manipulate.php' );
    new AXS_MetaBox_Social_Boards_Limiting(
        'sb_metabox_social_boards_limiting',
        __( 'Stream Results Limiting', 'social-board-admin' ),
        array( 'sb_posts' ),
        'side',
        'default'
    );
    new AXS_MetaBox_Social_Boards_Manipulate(
        'sb_metabox_social_boards_manipulate',
        __( 'Stream Manipulation', 'social-board-admin' ),
        array( 'sb_posts' ),
        'side',
        'default'
    );
    new AXS_MetaBox_Social_Boards_Output(
        'sb_metabox_social_boards_output',
        __( 'Stream Output', 'social-board-admin' ),
        array( 'sb_posts' ),
        'side',
        'default'
    );
    
    // Create an admin sidebar in Manage Streams page
    include( AXS_DIRNAME . '/admin/SB_MetaBox_Social_Boards_Side.php' );
    new AXS_MetaBox_Social_Boards_Side(
        'sb_metabox_social_boards_side',
        __( 'Add to your website?', 'social-board-admin' ),
        array( 'sb_posts' ),
        'side',
        'default'
    );
    
    // Create Manage Ads page
    include( AXS_DIRNAME . '/admin/SB_MetaBox_Ads.php' );
    new AXS_MetaBox_Ads(
        'sb_ads_metabox',
        __( 'Ad Settings', 'social-board-admin' ),
        array( 'sb_ads' ),
        'normal',
        'default'
    );

    // Create Manage Themes page
    include( AXS_DIRNAME . '/admin/SB_MetaBox_Themes.php' );
    new AXS_MetaBox_Themes(
        'themes_metabox',
        __( 'Theme Settings', 'social-board-admin' ),
        array( 'sb_themes' ),
        'normal',
        'default'
    );

    // Import themes
    $themes = axs_getFileTitles('/themes/', false);
    unset($themes['default']);
    require 'themes/default.php';
    foreach ($themes as $theme) {
        include_once 'themes/' . $theme . '.php';
    }
    do_action('axs_themes_section');
    
    // Create an example page group and add sub-pages including a page with the slug 'sb_settings'.
    include( AXS_DIRNAME . '/admin/SB_Settings_Page.php' ); // Include the basic usage example that creates a root page and its sub-pages.
    new AXS_Settings_Page(
        null,                       // the option key
        AXS_FILE,                    // the caller script path.
        'manage_options',           // the default capability
        'social-board-admin'        // the text domain
    );
    
    // Checking for plugin updates
    axs_update_checker();
    add_action( 'in_plugin_update_message-ax-social-stream/ax-social-stream.php', 'axs_addUpgradeMessage' );
    
    // Add an admin notice if, layouts activation is not passed yet!
    $setoption = SB_AdminPageFramework::getOption( 'AXS_Settings_Page' ) ? SB_AdminPageFramework::getOption( 'AXS_Settings_Page' ) : SB_AdminPageFramework::getOption( 'SB_Settings_Page' );
    if ( empty($setoption['section_layouts']['enabled_layouts']) )
        add_action( 'admin_notices', 'axs_admin_notice' );
}

function axs_admin_notice() {
	$class = 'notice notice-warning is-dismissible';
    $message = __( 'AX Social Stream: Layouts activation setting is not passed! Please, <a href="'.admin_url( 'edit.php?post_type=sb_posts&page=sb_settings&tab=layouts' ).'">enable your required layouts.</a>', 'sample-text-domain' );

	printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), $message ); 
}

// Function for update checks
function axs_update_checker() {
    if ( class_exists( 'Puc_v4_Factory' ) ) {
		// Initializes the update checker
		$sbUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
			AXS_UPSERVER . '?action=get_metadata&slug=ax-social-stream', // Metadata URL
			plugin_dir_path( dirname( __FILE__ ) ) . 'ax-social-stream.php', // Full path to the main plugin file
			'ax-social-stream' // Plugin slug. Usually it's the same as the name of the directory
		);
		// Add the license key to query arguments
		$sbUpdateChecker->addQueryArgFilter('axs_filter_update_checks');
	}
}

// Function for filtering update checks
function axs_filter_update_checks($queryArgs) {
    $license_key = axs_license_key();
    if ( ! empty($license_key) ) {
        $queryArgs['license_key'] = $license_key;
    }
    return $queryArgs;
}

function axs_license_key() {
    $settings = SB_AdminPageFramework::getOption( 'AXS_Settings_Page' ) ? SB_AdminPageFramework::getOption( 'AXS_Settings_Page' ) : SB_AdminPageFramework::getOption( 'SB_Settings_Page' );
    return $settings['section_licensing']['license_key'] ?? '';
}

// Shows message on WP plugins page with a link for updating from server
function axs_addUpgradeMessage() {
    $license_key = axs_license_key();
    if ( empty($license_key) ) {
		$url = esc_url( admin_url( 'edit.php?post_type=sb_posts&page=sb_settings&tab=licensing' ) );
		$redirect = sprintf( '<a href="%s" target="_blank">%s</a>', $url, __( 'settings', 'social-board-admin' ) );

		echo sprintf( ' ' . __( 'To receive automatic updates, license activation is required. Please visit %s to activate your plugin.', 'social-board-admin' ), $redirect );
	}
}

// load admin side stylesheets
function load_admin_style() {
    $SCRIPT_DEBUG = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG && file_exists( AXS_DIRNAME . '/public/src' );
    $src = $SCRIPT_DEBUG ? 'src/' : '';
    $min = $SCRIPT_DEBUG ? '' : '.min';
    wp_enqueue_style( 'social-board-admin', plugins_url( 'public/' . $src . 'css/admin-styles' . $min . '.css', AXS_FILE ), false, AXS_VERSION );
}

// grab the posts with type Social Streams
function axs_getPostTitles( $sPostTypeSlug ) {
    $_aArgs = array(
        'post_type' => $sPostTypeSlug,
    	'orderby' => 'ID',
    	'order' => 'ASC',
        'posts_per_page' => 999999
    );
    $_oResults    = new WP_Query( $_aArgs );
    $_aPostTitles = array();
    foreach( $_oResults->posts as $_oPost ) {
        $_aPostTitles[$_oPost->ID] = $_oPost->post_title;
    }
    if ( empty($_aPostTitles) ) {
        $sPostLabel = ($sPostTypeSlug == 'sb_posts') ? 'Social Stream' : 'Theme';
        $_aPostTitles[''] = '-- There is no '.$sPostLabel.' created --';
    }
    return $_aPostTitles;
}

// grab the layout files
function axs_getFileTitles( $path = '/themes/', $includeCustomThemes = true, $pathAsTitle = false ) {
    $_aFileTitles = array();
    
    // read the main layout folder
    $_aFileTitles = axs_getFiles( AXS_DIRNAME . $path, $pathAsTitle );
    
    // read/create extra layout folder
    if ($includeCustomThemes === true) {
        $upload_dir = wp_upload_dir();
        $layouts_path = $upload_dir['basedir'].'/ax-social-stream/themes';
        if ( ! file_exists($layouts_path) ) {
            wp_mkdir_p($layouts_path);
        } else {
            $_aFileTitles = array_merge( $_aFileTitles, axs_getFiles($layouts_path, $pathAsTitle ) );
        }
    }

    if ( empty($_aFileTitles) ) {
        $_aFileTitles[''] = '-- There is no layout created --';
    }
    return $_aFileTitles;
}

// grab the files
function axs_getFiles($path, $pathAsTitle = false) {
    if ( ! is_dir($path) )
        return false;

	$files = array();
    if ( $handle = opendir($path) ) {
        while ( false !== $file = readdir($handle) ) {
            if ( $file == '.' || $file == '..' || $file == 'slide' )
                continue;
            $path2 = $path . '/' . $file;
            if ( is_dir($path2) ) {
                $files += axs_getFiles($path2, $pathAsTitle);
            } else {
                $finfo = pathinfo($file);
                if (isset($finfo['extension']) ) {
                    if ($finfo['extension'] == 'php')
                        $files[$finfo['filename']] = ($pathAsTitle === true) ? $path2 : $finfo['filename'];
                }
            }
        }
        closedir($handle);
    }
    return $files;
}
