<?php

/**
 * AX Social Stream 3.4.8
 * Copyright 2017 Axent Media (support@axentmedia.com)
 */

// create a custom post type for Social Streams results limiting options
class AXS_MetaBox_Social_Boards_Limiting extends SB_AdminPageFramework_MetaBox {

    /*
     * ( optional ) Use the setUp() method to define settings of this meta box.
     */
    public function setUp() {
        /*
         * ( optional ) Adds setting fields into the meta box.
         */
        $this->addSettingFields(
            array(
                'field_id' => 'limiting',
                'title' => __( 'Results Limiting Definition', 'social-board-admin' ),
                'description' => __( 'If "Based on recentness" is enabled, the number of results you get on social stream for each feed is based on the most recentness of that feed and for the total number of results you get, the Stream Settings > Results Limit value will be used.
                    <br>If "Custom feed result" is enabled, the custom result limit which is separately defined for each feed will be used.', 'social-board-admin' ),
                'type' => 'radio',
                'default' => 'recent',
                'label' => array(
                    'recent' => 'Based on recentness',
                    'custom' => 'Custom feed result'
                )
            )
        );
    }
}

// create a custom post type for Social Streams manipulation options
class AXS_MetaBox_Social_Boards_Manipulate extends SB_AdminPageFramework_MetaBox {

    /*
     * ( optional ) Use the setUp() method to define settings of this meta box.
     */
    public function setUp() {
        $this->oProp->bShowDebugInfo = false;
        
        /*
         * ( optional ) Adds setting fields into the meta box.
         */
        $this->addSettingFields(
			array(
				'field_id' => 'filter_out',
				'title' => __( 'Filter Out', 'social-board-admin' ),
				'type' => 'text',
				'repeatable' => true,
				'description' => __( 'Remove any contents which are including these phrases or hashtags of your social stream.', 'social-board-admin' ),
				'attributes' => array(
					'style' => "max-width: 180px;"
				)
			),
			array(
				'field_id' => 'filter_in',
				'title' => __( 'Filter In', 'social-board-admin' ),
				'type' => 'text',
				'repeatable' => true,
				'description' => __( 'Displaying only the contents which are including these phrases or hashtags on your social stream.', 'social-board-admin' ),
				'attributes' => array(
					'style' => "max-width: 180px;"
				)
			),
            array(
                'field_id' => 'pins',
                'title' => __( 'Pinned items', 'social-board-admin' ),
                'type' => 'text',
                'repeatable' => true,
                'description' => __( 'This section will allow you to pin/stick an item on top of the Social Stream. Enter the links of social items that you are going to pin on top of the Social Stream - Each link in a new line.', 'social-board-admin' ),
                'attributes' => array(
                    'style' => "max-width: 180px;"
                )
            ),
            array(
                'field_id' => 'remove',
                'title' => __( 'Remove items', 'social-board-admin' ),
                'type' => 'text',
                'repeatable' => true,
                'description' => __( 'Enter the links of social items that you are going to remove from the Social Stream - Each link in a new line.', 'social-board-admin' ),
                'attributes' => array(
                    'style' => "max-width: 180px;"
                )
            )
        );
    }
    
    public function do_AXS_MetaBox_Social_Boards_Manipulate() { // do_{instantiated class name}
        echo '<a href="'. AXS_DOCS . '#manipulation" target="_blank">Read the documentation</a> for more details.';
    }
}

// create a custom post type for Social Streams output options
class AXS_MetaBox_Social_Boards_Output extends SB_AdminPageFramework_MetaBox {

    /*
     * ( optional ) Use the setUp() method to define settings of this meta box.
     */
    public function setUp() {
        /*
         * ( optional ) Adds setting fields into the meta box.
         */
        $this->addSettingFields(
            array(
                'field_id'      => 'output',
                'title'         => __( 'Item output parts', 'social-board-admin' ),
                'type'          => 'checkbox',
                'label'         => array(
                    'title' => __( 'Title', 'social-board-admin' ) . ' (' . __( 'Feed item title', 'social-board-admin' ) . ')',
                    'thumb' => __( 'Thumbnail', 'social-board-admin' ) . ' (' . __( 'Display thumbnail - if available', 'social-board-admin' ) . ')',
                    'text' => __( 'Text', 'social-board-admin' ) . ' (' . __( 'Post text', 'social-board-admin' ) . ')',
                    'comments' => __( 'Comments', 'social-board-admin' ) . ' (' . __( 'Display post comments', 'social-board-admin' ) . ')',
                    'likes' => __( 'Likes', 'social-board-admin' ) . ' (' . __( 'Display post likes', 'social-board-admin' ) . ')',
                    'user' => __( 'User', 'social-board-admin' ) . ' (' . __( 'Display user info', 'social-board-admin' ) . ')',
                    'share' => __( 'Share', 'social-board-admin' ) . ' (' . __( 'Include sharing links', 'social-board-admin' ) . ')',
                    'info' => __( 'Info', 'social-board-admin' ) . ' (' . __( 'Feed item icon & date', 'social-board-admin' ) . ')',
                    'stat' => __( 'Stat', 'social-board-admin' ) . ' (' . __( 'Display stat block', 'social-board-admin' ) . ')',
                    'meta' => __( 'Meta', 'social-board-admin' ) . ' (' . __( 'Feed meta data', 'social-board-admin' ) . ')',
                    'tags' => __( 'Tags', 'social-board-admin' ) . ' (' . __( 'Feed item tags', 'social-board-admin' ) . ')'
                ),
                'default' => array(
                    'title' => true,
                    'thumb' => true,
                    'text' => true,
                    'comments' => true,
                    'likes' => true,
                    'user' => true,
                    'share' => true,
                    'info' => true,
                    'stat' => true,
                    'meta' => true,
                    'tags' => false
                ),
                'description'   => __( 'Select the content blocks that you want to be included in each item on the Social Stream. Each social network may have different type of content blocks available.', 'social-board-admin' ),
                'after_label'   => '<br />',
                'show_debug_info' => false
            )
        );
    }
}
