<?php

/**
 * AX Social Stream
 * Copyright 2014-2019 Axent Media (support@axentmedia.com)
 */

// create Social Stream post type
class AXS_Social_Boards extends SB_AdminPageFramework_PostType {
    
    public function start() {
        
        $this->setPostTypeArgs(
            array(
                'labels' => array(
                    'name'               => 'Social Streams',
                    'all_items'          => __( 'Manage Streams', 'social-board-admin' ),
                    'singular_name'      => 'Social Stream',
                    'add_new'            => __( 'Add New Stream', 'social-board-admin' ),
                    'add_new_item'       => __( 'Add New Social Stream', 'social-board-admin' ),
                    'edit'               => __( 'Edit', 'social-board-admin' ),
                    'edit_item'          => __( 'Edit Social Stream', 'social-board-admin' ),
                    'new_item'           => __( 'New Social Stream', 'social-board-admin' ),
                    'view'               => __( 'View', 'social-board-admin' ),
                    'view_item'          => __( 'View Social Stream', 'social-board-admin' ),
                    'search_items'       => __( 'Search Social Stream', 'social-board-admin' ),
                    'not_found'          => __( 'No Social Stream found', 'social-board-admin' ),
                    'not_found_in_trash' => __( 'No Social Stream found in Trash', 'social-board-admin' ),
                    'parent'             => __( 'Parent Social Stream', 'social-board-admin' ),
                    'plugin_listing_table_title_cell_link' => __( 'Social Streams', 'social-board-admin' ),
                ),
                'public'            => false,
                'rewrite'           => false,
                'menu_position'     => 80,
                'supports'          => array( 'title' ), // e.g. array( 'title', 'editor', 'comments', 'thumbnail' ),
                'taxonomies'        => array( '' ),
                'has_archive'       => false,
                'show_admin_column' => true, // this is for custom taxonomies to automatically add the column in the listing table.
                'show_ui'           => true,
                'show_in_nav_menus' => true,
                'menu_icon'         => $this->oProp->bIsAdmin ? plugins_url( 'public/img/menu-icon.png', AXS_FILE ) : null, // do not call the function in the front-end.
                // ( framework specific key ) this sets the screen icon for the post type for WordPress v3.7.1 or below.
                'screen_icon' => dirname( AXS_FILE  ) . '/public/img/screen-icon.png', // a file path can be passed instead of a url, plugins_url( 'asset/image/wp-logo_32x32.png', AXS_FILE )
                'exclude_from_search' => true
            )
        );
    }
    
    /**
     * Automatically called with the 'wp_loaded' hook.
     */
    public function setUp() {
        $this->oProp->bShowDebugInfo = false;
        $this->oProp->aFooterInfo['sRight'] = '';
        
        if ( $this->oProp->bIsAdmin ) {
            $this->setAutoSave( false );
            $this->setAuthorTableFilter( true );
        }
    }
    
    /*
     * Built-in callback methods
     */
    public function columns_sb_posts( $aHeaderColumns ) { // columns_{post type slug}
        return array_merge(
            $aHeaderColumns,
            array(
                'cb'                => '<input type="checkbox" />', // Checkbox for bulk actions.
                'title'             => __( 'Name', 'admin-page-framework' ), // Post title. Includes "edit", "quick edit", "trash" and "view" links. If $mode (set from $_REQUEST['mode']) is 'excerpt', a post excerpt is included between the title and links.
                'author'            => __( 'Author', 'admin-page-framework' ), // Post author.
                'date'              => __( 'Date', 'admin-page-framework' ), // The date and publish status of the post.
                'shortcodes'        => __( 'Shortcodes' )
            )
        );
    }
    
    public function cell_sb_posts_shortcodes( $sCell, $iPostID ) { // cell_{post type}_{column key}
        return '<strong>' . __( 'Masonry Shortcode' ) . ':</strong> ' . sprintf( '[social_board id="%1$s" type="masonry"]', $iPostID )
            . '<br><strong>' . __( 'Timeline' ) . ':</strong> ' . sprintf( __( '[social_board id="%1$s" type="timeline"]', 'social-board-admin' ), $iPostID )
            . '<br><strong>' . __( 'Rotating Feed' ) . ':</strong> ' . sprintf( __( '[social_board id="%1$s" type="feed"]', 'social-board-admin' ), $iPostID )
            . '<br><strong>' . __( 'Carousel' ) . ':</strong> ' . sprintf( __( '[social_board id="%1$s" type="carousel"]', 'social-board-admin' ), $iPostID )
            . '<br><strong>' . __( 'Grid' ) . ':</strong> ' . sprintf( __( '[social_board id="%1$s" type="grid"]', 'social-board-admin' ), $iPostID );
    }
}
