<?php
/**
 * AX Social Stream
 * Copyright 2014 Axent Media <support@axentmedia.com>
 */

class AXS_MetaBox_Brick extends SB_AdminPageFramework_MetaBox {
  public $sSectionID  = 'brick_section';

	public function setUp() {
    $this->oProp->bShowDebugInfo = false;
    
    $themedefaults = [
      'social_colors' => [
        0 => '#305790',
        '#06d0fe',
        '#2E4E65',
        '#2d6eae',
        '#cb1218',
        '#ff0185',
        '#295477',
        '#b80000',
        '#00a0dc',
        '#495d51',
        '#d78b2d',
        '#ff3300',
        '#4c75a3',
        '#39a97b',
		'#0073aa'
      ]
    ];

    $this->addSettingSections(
      array(
        'section_id'        => $this->sSectionID,
        'title'             => __( 'General Options', 'admin-page-framework-loader' )
      )
    );

    $this->addSettingFields(
        $this->sSectionID, // the target section ID
        array( // Multiple Color Pickers
            'field_id' => 'social_colors',
            'title' => __( 'Social Networks Color', 'social-board-admin' ),
            'type' => 'color',
            'label' => __( 'Facebook', 'social-board-admin' ),
            'default' => $themedefaults['social_colors'][0],
            'description' => __( 'Here you can change the background colors used for each social network. To change one of the network colors, click on the relevant colored box and a colorpicker should be appeared. Then select the new color and click elsewhere on the screen to close the colorpicker widget. The colored box should now be updated with the new color.', 'social-board-admin' ),
            'delimiter' => '<br />',
            array(
                'label' => __( 'Twitter', 'social-board-admin' ),
                'default' => $themedefaults['social_colors'][1]
            ),
            array(
                'label' => __( 'Tumblr', 'social-board-admin' ),
                'default' => $themedefaults['social_colors'][2]
            ),
            array(
                'label' => __( 'Delicious', 'social-board-admin' ),
                'default' => $themedefaults['social_colors'][3]
            ),
            array(
                'label' => __( 'Pinterest', 'social-board-admin' ),
                'default' => $themedefaults['social_colors'][4]
            ),
            array(
                'label' => __( 'Flickr', 'social-board-admin' ),
                'default' => $themedefaults['social_colors'][5]
            ),
            array(
                'label' => __( 'Instagram', 'social-board-admin' ),
                'default' => $themedefaults['social_colors'][6]
            ),
            array(
                'label' => __( 'YouTube', 'social-board-admin' ),
                'default' => $themedefaults['social_colors'][7]
            ),
            array(
                'label' => __( 'Vimeo', 'social-board-admin' ),
                'default' => $themedefaults['social_colors'][8]
            ),
            array(
                'label' => __( 'Deviantart', 'social-board-admin' ),
                'default' => $themedefaults['social_colors'][9]
            ),
            array(
                'label' => __( 'RSS', 'social-board-admin' ),
                'default' => $themedefaults['social_colors'][10]
            ),
            array(
                'label' => __( 'SoundCloud', 'social-board-admin' ),
                'default' => $themedefaults['social_colors'][11]
            ),
            array(
                'label' => __( 'VK', 'social-board-admin' ),
                'default' => $themedefaults['social_colors'][12]
            ),
			array(
				'label' => __( 'Vine', 'social-board-admin' ),
				'default' => $themedefaults['social_colors'][13] ?? ""
			),
			array(
				'label' => __( 'WordPress', 'social-board-admin' ),
				'default' => $themedefaults['social_colors'][14] ?? ''
			),
			array(
				'label' => __( 'TikTok', 'social-board-admin' ),
				'default' => $themedefaults['social_colors'][15] ?? ""
			)
        )
      );
    
    $this->addSettingSections(
      array(
        'section_id' => $this->sSectionID . '_grid',
        'section_tab_slug' => 'tabbed_sections',
        'title' => __( 'Grid', 'admin-page-framework-demo' ),
        'description' => __( 'These options are only dedicated to Grid display mode.', 'admin-page-framework-demo' ),
        'show_debug_info' => false
      )
    );

    $sections = array('wall', 'timeline', 'feed', 'feed_sticky', 'feed_carousel', 'grid');
    foreach ($sections as $section_id) {
      $section_id_n = $this->sSectionID . '_' . $section_id;
      if ($section_id == 'grid') {
        $this->addSettingFields(
          $section_id_n,
          array(
            'section_id' => $section_id_n,
            'field_id' => 'skin',
            'type' => 'select',
            'title' => __( 'Skin', 'social-board-admin' ),
            'label' => array(
              'light' => __( 'Light', 'social-board-admin' ),
              'dark' => __( 'Dark', 'social-board-admin' )
            ),
            'default' => 'light',
            'attributes' => array(
              'select' => array(
                'style' => "width: 150px;"
              )
            )
          )
        );
      }
    }
	}
}

add_action('axs_themes_section', 'axs_themes_section_brick');
function axs_themes_section_brick() {
	$a = new AXS_MetaBox_Brick(
		'axs_metabox_brick',
		__( 'Brick Theme Settings', 'admin-page-framework-loader' ),
		array( 'sb_themes' ),
		'normal',
		'default'
	);
}
