<?php
/**
 * AX Social Stream
 * Copyright 2014 Axent Media <support@axentmedia.com>
 */

// create a custom post type for Social Streams manipulation options
class AXS_MetaBox_Default extends SB_AdminPageFramework_MetaBox {

	public $sSectionID  = 'default_section';

	/*
	 * ( optional ) Use the setUp() method to define settings of this meta box.
	 */
	public function setUp() {
		$this->oProp->bShowDebugInfo = false;
		$sections = array('wall', 'timeline', 'feed', 'feed_sticky', 'feed_carousel');

		$themedefaults = [
			'font_size' => 11,
			'social_colors' => [
				0 => '#305790',
				1 => '#06d0fe',
				2 => '#2E4E65',
				3 => '#2d6eae',
				4 => '#cb1218',
				5 => '#ff0185',
				6 => '#295477',
				7 => '#b80000',
				8 => '#00a0dc',
				9 => '#495d51',
				10 => '#d78b2d',
				11 => '#ff3300',
				12 => '#4c75a3',
				13 => '#39a97b',
				14 => '#0073aa',
				15 => '#0073aa'
			]
		];
		$themedefaults['social_icons'] = array_fill(0, 17, '');
		$themedefaults['type_icons'] = array_fill(0, 10, '');

		foreach ($sections as $section_id) {
			$themedefaults[$section_id] = [
				'title_background_color' => ($section_id == 'feed_sticky') ? '#F3F3F3' : 'transparent',
				'title_color' => ($section_id == 'feed_sticky') ? '#FFFFFF' : 'transparent',
				'opener_image' => '',
				'background_color' => ($section_id == 'feed_sticky') ? '#FFFFFF' : 'transparent',
				'border_color' => ($section_id == 'feed_sticky') ? '#545454' : 'transparent',
				'border_size' => ($section_id == 'feed_sticky') ? 3 : 1,
				'border_radius' => 7,
				'background_image' => '',
				'font_color' => 'transparent',
				'link_color' => 'transparent',
				'item_background_color' => ($section_id == 'feed_sticky') ? '#FFFFFF' : 'transparent',
				'item_border_color' => ($section_id == 'feed_sticky') ? '#545454' : 'transparent',
				'item_border_size' => ($section_id == 'feed_sticky') ? 3 : 1
			];
		}

		if ( isset($_GET['post']) ) {
			if ( $theme = axs_options($_GET['post']) ) {
				if ( empty( $theme[$theme['layout'] . "_section"]) )
					$themedefaults = $theme;

				foreach ($sections as $section_id) {
					if ( empty($theme[$theme['layout'] . "_section_$section_id"]) )
						$themedefaults[$section_id] = $theme["section_$section_id"] ?? '';
				}
			}
		}

		$this->addSettingSections(
			array(
				'section_id'        => $this->sSectionID,
				'title'             => __( 'General Options', 'admin-page-framework-loader' )
			)
		);

		$this->addSettingFields(
			$this->sSectionID, // the target section ID
			array(
				'field_id'      => 'show_labels',
				'title'         => __( 'Displaying labels', 'social-board-admin' ),
				'type'          => 'checkbox',
				'label'         => array(
					'posted' => __( 'Posted', 'social-board-admin' ),
					'tags' => __( 'Tags', 'social-board-admin' ),
					'comments' => ucfirst( __( 'comments', 'social-board-admin' ) ),
					'likes' => ucfirst( __( 'likes', 'social-board-admin' ) ),
					'retweets' => ucfirst( __( 'retweets', 'social-board-admin' ) ),
					'repin' => ucfirst( __( 'repin', 'social-board-admin' ) )
				),
				'default' => array(
					'posted' => true,
					'tags' => true,
					'comments' => true,
					'likes' => true,
					'retweets' => true,
					'repin' => true
				),
				'description'   => __( 'Show/Hide labels on items.', 'social-board-admin' )
			),
			array( // Size
				'field_id'      => 'font_size',
				'title'         => __( 'Font Size', 'social-board-admin' ),
				'description'   => __( 'In order to set a font size <code>(in px)</code> for the Social Stream.', 'social-board-admin' ),
				'type'          => 'number',
				'default'       => $themedefaults['font_size'] ?? ""
			),
			array(
				'field_id' => 'hover_effect',
				'type' => 'select',
				'title' => __( 'Image Hover effect', 'social-board-admin' ),
				'label' => array(
					'' => __( 'No Effect', 'social-board-admin' ),
					'zoomin' => __( 'Zoom-in', 'social-board-admin' ),
					'zoomout' => __( 'Zoom-out', 'social-board-admin' ),
					'slide' => __( 'Slide', 'social-board-admin' ),
					'rotate' => __( 'Rotate', 'social-board-admin' ),
					'grayscale' => __( 'Gray Scale', 'social-board-admin' ),
					'shine' => __( 'Shine', 'social-board-admin' )
				),
				'default' => 'zoomin',
				'attributes' => array(
					'select' => array(
						'style' => "width: 150px;"
					)
				)
			),
			array( // Multiple Color Pickers
				'field_id' => 'social_colors',
				'title' => __( 'Social Networks Color', 'social-board-admin' ),
				'type' => 'color',
				'label' => __( 'Facebook', 'social-board-admin' ),
				'default' => $themedefaults['social_colors'][0] ?? "",
				'description' => __( 'Here you can change the background colors used for each social network. To change one of the network colors, click on the relevant colored box and a colorpicker should be appeared. Then select the new color and click elsewhere on the screen to close the colorpicker widget. The colored box should now be updated with the new color.', 'social-board-admin' ),
				'delimiter' => '<br />',
				array(
					'label' => __( 'Twitter', 'social-board-admin' ),
					'default' => $themedefaults['social_colors'][1] ?? ""
				),
				array(
					'label' => __( 'Tumblr', 'social-board-admin' ),
					'default' => $themedefaults['social_colors'][2] ?? ""
				),
				array(
					'label' => __( 'Delicious', 'social-board-admin' ),
					'default' => $themedefaults['social_colors'][3] ?? ""
				),
				array(
					'label' => __( 'Pinterest', 'social-board-admin' ),
					'default' => $themedefaults['social_colors'][4] ?? ""
				),
				array(
					'label' => __( 'Flickr', 'social-board-admin' ),
					'default' => $themedefaults['social_colors'][5] ?? ""
				),
				array(
					'label' => __( 'Instagram', 'social-board-admin' ),
					'default' => $themedefaults['social_colors'][6] ?? ""
				),
				array(
					'label' => __( 'YouTube', 'social-board-admin' ),
					'default' => $themedefaults['social_colors'][7] ?? ""
				),
				array(
					'label' => __( 'Vimeo', 'social-board-admin' ),
					'default' => $themedefaults['social_colors'][8] ?? ""
				),
				array(
					'label' => __( 'Deviantart', 'social-board-admin' ),
					'default' => $themedefaults['social_colors'][9] ?? ""
				),
				array(
					'label' => __( 'RSS', 'social-board-admin' ),
					'default' => $themedefaults['social_colors'][10] ?? ""
				),
				array(
					'label' => __( 'SoundCloud', 'social-board-admin' ),
					'default' => $themedefaults['social_colors'][11] ?? ""
				),
				array(
					'label' => __( 'VK', 'social-board-admin' ),
					'default' => $themedefaults['social_colors'][12] ?? ""
				),
				array(
					'label' => __( 'Vine', 'social-board-admin' ),
					'default' => $themedefaults['social_colors'][13] ?? ""
				),
				array(
					'label' => __( 'WordPress', 'social-board-admin' ),
					'default' => $themedefaults['social_colors'][14] ?? ""
				),
				array(
					'label' => __( 'TikTok', 'social-board-admin' ),
					'default' => $themedefaults['social_colors'][15] ?? ""
				)
			),
			array( // Image Selector
				'field_id' => 'social_icons',
				'title' => __( 'Social Networks Icons', 'social-board-admin' ),
				'type' => 'image',
				'label' => __( 'Facebook', 'social-board-admin' ),
				'default' => $themedefaults['social_icons'][0] ?? "",
				'allow_external_source' => false,
				'attributes'    => array(
					'style' => 'max-width:200px;',
					'preview' => array(
						'style' => 'max-width:100px;' // determines the size of the preview image. // margin-left: auto; margin-right: auto; will make the image in the center.
					)
				),
				array(
					'label' => __( 'Twitter', 'social-board-admin' ),
					'default' => $themedefaults['social_icons'][1] ?? "",
					'allow_external_source' => true
				),
				array(
					'label' => __( 'Tumblr', 'social-board-admin' ),
					'default' => $themedefaults['social_icons'][2] ?? ""
				),
				array(
					'label' => __( 'Delicious', 'social-board-admin' ),
					'default' => $themedefaults['social_icons'][3] ?? ""
				),
				array(
					'label' => __( 'Pinterest', 'social-board-admin' ),
					'default' => $themedefaults['social_icons'][4] ?? ""
				),
				array(
					'label' => __( 'Flickr', 'social-board-admin' ),
					'default' => $themedefaults['social_icons'][5] ?? ""
				),
				array(
					'label' => __( 'Instagram', 'social-board-admin' ),
					'default' => $themedefaults['social_icons'][6] ?? ""
				),
				array(
					'label' => __( 'YouTube', 'social-board-admin' ),
					'default' => $themedefaults['social_icons'][7] ?? ""
				),
				array(
					'label' => __( 'Vimeo', 'social-board-admin' ),
					'default' => $themedefaults['social_icons'][8] ?? ""
				),
				array(
					'label' => __( 'Deviantart', 'social-board-admin' ),
					'default' => $themedefaults['social_icons'][9] ?? ""
				),
				array(
					'label' => __( 'RSS', 'social-board-admin' ),
					'default' => $themedefaults['social_icons'][10] ?? ""
				),
				array(
					'label' => __( 'SoundCloud', 'social-board-admin' ),
					'default' => $themedefaults['social_icons'][11] ?? ""
				),
				array(
					'label' => __( 'VK', 'social-board-admin' ),
					'default' => $themedefaults['social_icons'][12] ?? ""
				),
				array(
					'label' => __( 'Vine', 'social-board-admin' ),
					'default' => $themedefaults['social_icons'][13] ?? ""
				),
				array(
					'label' => __( 'WordPress', 'social-board-admin' ),
					'default' => $themedefaults['social_icons'][14] ?? ""
				),
				array(
					'label' => __( 'TikTok', 'social-board-admin' ),
					'default' => $themedefaults['social_icons'][15] ?? ""
				),
				'description'   => __( 'Here you can change the icon used for each social network. To change one of the network icons, enter the direct url of the icon file or click on the relevant "Select Image" button and an "Upload Image" window should now appear.', 'social-board-admin' )
			),
			array( // Image Selector
				'field_id' => 'type_icons',
				'title' => __( 'Post Type Icons', 'social-board-admin' ),
				'type' => 'image',
				'label' => __( 'Note', 'social-board-admin' ),
				'default' => $themedefaults['type_icons'][0] ?? "",
				'allow_external_source' => false,
				'attributes'    => array(
					'style' => 'max-width:200px;',
					'preview' => array(
						'style' => 'max-width:100px;' // determines the size of the preview image. // margin-left: auto; margin-right: auto; will make the image in the center.
					)
				),
				array(
					'label' => __( 'Article', 'social-board-admin' ),
					'default' => $themedefaults['type_icons'][1] ?? ""
				),
				array(
					'label' => __( 'Quote', 'social-board-admin' ),
					'default' => $themedefaults['type_icons'][2] ?? ""
				),
				array(
					'label' => __( 'Link', 'social-board-admin' ),
					'default' => $themedefaults['type_icons'][3] ?? ""
				),
				array(
					'label' => __( 'Image', 'social-board-admin' ),
					'default' => $themedefaults['type_icons'][4] ?? ""
				),
				array(
					'label' => __( 'Camera', 'social-board-admin' ),
					'default' => $themedefaults['type_icons'][5] ?? ""
				),
				array(
					'label' => __( 'Video', 'social-board-admin' ),
					'default' => $themedefaults['type_icons'][6] ?? ""
				),
				array(
					'label' => __( 'Audio', 'social-board-admin' ),
					'default' => $themedefaults['type_icons'][7] ?? ""
				),
				array(
					'label' => __( 'Like', 'social-board-admin' ),
					'default' => $themedefaults['type_icons'][8] ?? ""
				),
				array(
					'label' => __( 'Comment', 'social-board-admin' ),
					'default' => $themedefaults['type_icons'][9] ?? ""
				),
				'description'   => __( 'Here you can change the icon used for each post type. To change one of the type icons, enter the direct url of the icon file or click on the relevant "Select Image" button and an "Upload Image" window should now appear.', 'social-board-admin' )
			)
		);

		$this->addSettingSections(
			array(
				'section_id' => $this->sSectionID . '_wall',
				'section_tab_slug' => 'tabbed_sections',
				'title' => __( 'Masonry Options', 'admin-page-framework-demo' ),
				'description' => __( 'These options are only dedicated to the Masonry display mode.', 'admin-page-framework-demo' ),
				'show_debug_info' => false
			),
			array(
				'section_id' => $this->sSectionID . '_timeline',
				'title' => __( 'Timeline', 'admin-page-framework-demo' ),
				'description' => __( 'These options are only dedicated to the Timeline display mode.', 'admin-page-framework-demo' ),
				'show_debug_info' => false
			),
			array(
				'section_id' => $this->sSectionID . '_feed',
				'title' => __( 'Normal Feed', 'admin-page-framework-demo' ),
				'description' => __( 'These options are only dedicated to Normal Rotating Feed display mode.', 'admin-page-framework-demo' ),
				'show_debug_info' => false
			),
			array(
				'section_id' => $this->sSectionID . '_feed_sticky',
				'title' => __( 'Sticky Feed', 'admin-page-framework-demo' ),
				'description' => __( 'These options are only dedicated to Sticky Rotating Feed display mode.', 'admin-page-framework-demo' ),
				'show_debug_info' => false
			),
			array(
				'section_id' => $this->sSectionID . '_feed_carousel',
				'title' => __( 'Carousel Feed', 'admin-page-framework-demo' ),
				'description' => __( 'These options are only dedicated to Carousel Feed display mode.', 'admin-page-framework-demo' ),
				'show_debug_info' => false
			)
		);

		foreach ($sections as $section_id) {
			$section_id_n = $this->sSectionID . '_' . $section_id;

			if ($section_id == 'feed' || $section_id == 'feed_sticky') {
				$this->addSettingFields(
					array (
						'section_id'  => $section_id_n,
						'field_id'    => 'title_background_color',
						'type'        => 'color',
						'title'       => __( 'Header Background Color', 'social-board-admin' ),
						'default'     => $themedefaults[$section_id]['title_background_color'] ?? "",
						'description' => __( 'Select the new background color of the Social Stream Title and then click elsewhere on the screen to close the colorpicker widget.', 'social-board-admin' )
					),
					array (
						'section_id'  => $section_id_n,
						'field_id'    => 'title_color',
						'type'        => 'color',
						'title'       => __( 'Title Font Color', 'social-board-admin' ),
						'default'     => $themedefaults[$section_id]['title_color'] ?? "",
						'description' => __( 'Select the new font color of the Social Stream Title and then click elsewhere on the screen to close the colorpicker widget.', 'social-board-admin' )
					)
				);
			}

			if ($section_id == 'section_feed_sticky') {
				$this->addSettingFields(
					array(
						'field_id'    => 'opener_image',
						'type'        => 'image',
						'title'       => __( 'Block Opener Image', 'social-board-admin' ),
						'default'     => $themedefaults[$section_id]['opener_image'] ?? "",
						'allow_external_source' => false,
						'attributes'  => array(
							'preview' => array(
								'style' => 'max-width:100px;' // determines the size of the preview image. // margin-left: auto; margin-right: auto; will make the image in the center.
							)
						),
						'description' => __( 'To change the block opener icon, enter the direct url of the image file or click on the relevant "Select Image" button and an "Upload Image" window should now appear.', 'social-board-admin' )
					)
				);
			}

			if ($section_id == 'feed_carousel') {
				$this->addSettingFields([
					'section_id' => $section_id_n,
					'field_id'      => 'cs_item_padding',
					'title'         => __( 'Item Gap', 'social-board-admin' ),
					'description'   => __( 'In order to set a padding/gap <code>(in px)</code> between the carousel items.', 'social-board-admin' ),
					'type'          => 'number',
					'default'       => 2
				]);
			}

			$this->addSettingFields(
				array(
					'section_id' => $section_id_n,
					'field_id' => 'background_color',
					'type' => 'color',
					'title' => __( 'Body Background Color', 'social-board-admin' ),
					'default'     => $themedefaults[$section_id]['background_color'] ?? "",
					'description' => __( 'Select the new background color of the Social Stream and then click elsewhere on the screen to close the colorpicker widget.', 'social-board-admin' ),
				),
				array(
					'field_id'      => 'border_color',
					'type'          => 'color',
					'title'         => __( 'Body Border Color', 'social-board-admin' ),
					'default'       => $themedefaults[$section_id]['border_color'] ?? "",
					'description'   => __( 'Select the new border color of the Social Stream and then click elsewhere on the screen to close the colorpicker widget.', 'social-board-admin' ),
				),
				array(
					'field_id'      => 'border_size',
					'title'         => __( 'Body Border Size', 'social-board-admin' ),
					'description'   => __( 'In order to set a border size <code>(in px)</code> for the Social Stream.', 'social-board-admin' ),
					'type'          => 'number',
					'default'       => $themedefaults[$section_id]['border_size'] ?? "",
				),
				array(
					'field_id'      => 'border_radius',
					'title'         => __( 'Body Border Radius', 'social-board-admin' ),
					'description'   => __( 'In order to set a border radius <code>(in px)</code> for the Social Stream.', 'social-board-admin' ),
					'type'          => 'number',
					'default'       => $themedefaults[$section_id]['border_radius'] ?? ""
				),
				array(
					'field_id'    => 'background_image',
					'type'        => 'image',
					'title'       => __( 'Body Background Image', 'social-board-admin' ),
					'default'     => $themedefaults[$section_id]['background_image'] ?? "",
					'allow_external_source' => false,
					'attributes'  => array(
						'preview' => array(
							'style' => 'max-width:100px;' // determines the size of the preview image. // margin-left: auto; margin-right: auto; will make the image in the center.
						),
					),
					'description' => __( 'In order to set a background image for the Social Stream, enter the direct url of the image file or click on the relevant "Select Image" button and an "Upload Image" window should now appear.', 'social-board-admin' )
				),
				array (
					'field_id' => 'font_color',
					'type' => 'color',
					'title' => __( 'Font Color', 'social-board-admin' ),
					'default' => $themedefaults[$section_id]['font_color'] ?? "",
					'description' => __( 'Select the new font color for the feed item and then click elsewhere on the screen to close the colorpicker widget.', 'social-board-admin' )
				),
				array (
					'field_id' => 'link_color',
					'type' => 'color',
					'title' => __( 'Link Color', 'social-board-admin' ),
					'default' => $themedefaults[$section_id]['link_color'] ?? "",
					'description' => __( 'Select the new color for the feed item\' links and then click elsewhere on the screen to close the colorpicker widget.', 'social-board-admin' )
				),
				array (
					'field_id' => 'item_background_color',
					'type' => 'color',
					'title' => __( 'Item Background Color', 'social-board-admin' ),
					'default'       => $themedefaults[$section_id]['item_background_color'] ?? "",
					'description' => __( 'Select the new background color for the feed item and then click elsewhere on the screen to close the colorpicker widget.', 'social-board-admin' ),
				),
				array (
					'field_id'      => 'item_border_color',
					'type'          => 'color',
					'title'         => __( 'Item Border Color', 'social-board-admin' ),
					'default'       => $themedefaults[$section_id]['item_border_color'] ?? "",
					'description'   => __( 'Select the new border color for the feed item and then click elsewhere on the screen to close the colorpicker widget.', 'social-board-admin' ),
				),
				array(
					'field_id'      => 'item_border_size',
					'title'         => __( 'Item Border Size', 'social-board-admin' ),
					'description'   => __( 'In order to set a border size <code>(in px)</code> for the feed item.', 'social-board-admin' ),
					'type'          => 'number',
					'default'       => $themedefaults[$section_id]['item_border_size'] ?? ""
				)
			);
		}
	}
}
add_action('axs_themes_section', 'axs_themes_section_default');
function axs_themes_section_default() {
	new AXS_MetaBox_Default(
		'axs_metabox_default',  // meta box ID - can be null. If null is passed, the ID gets automatically generated and the class name with all lower case characters will be applied.
		__( 'Default Theme Settings', 'admin-page-framework-loader' ), // title
		array( 'sb_themes' ),                               // post type slugs: post, page, etc.
		'normal',                                           // context (what kind of metabox this is)
		'default'                                           // priority
	);
}