<?php
/**
 * AX Social Stream
 * Copyright 2014-2019 Axent Media <axentmedia@gmail.com>
 */

class AXS_MetaBox_Hero extends SB_AdminPageFramework_MetaBox {
  public $sSectionID  = 'hero_section';

	public function setUp() {
    $this->oProp->bShowDebugInfo = false;
    
    $this->addSettingSections(
      array(
        'section_id' => $this->sSectionID . '_feed_carousel',
        'section_tab_slug' => 'tabbed_sections',
        'title' => __( 'Carousel Feed', 'admin-page-framework-demo' ),
        'description' => __( 'These options are only dedicated to Carousel Feed display mode.', 'admin-page-framework-demo' ),
        'show_debug_info' => false
      )
    );

    $sections = array('wall', 'timeline', 'feed', 'feed_sticky', 'feed_carousel');
    foreach ($sections as $section_id) {
      $section_id_n = $this->sSectionID . '_' . $section_id;
      if ($section_id == 'feed_carousel') {
        $this->addSettingFields(
          $section_id_n,
          array(
            'section_id' => $section_id_n,
            'field_id' => 'skin',
            'type' => 'select',
            'title' => __( 'Skin', 'social-board-admin' ),
            'label' => array(
              'light' => __( 'Light', 'social-board-admin' ),
              'dark' => __( 'Dark', 'social-board-admin' )
            ),
            'default' => 'dark',
            'attributes' => array(
              'select' => array(
                'style' => "width: 150px;"
              )
            )
          ),
          array(
            'field_id' => 'hover_effect',
            'type' => 'select',
            'title' => __( 'Hover effect', 'social-board-admin' ),
            'label' => array(
              '' => __( 'No Effect', 'social-board-admin' ),
              'rotate' => __( 'Rotate', 'social-board-admin' ),
              'zoomout' => __( 'Zoom-out', 'social-board-admin' ),
              'zoomin' => __( 'Zoom-in', 'social-board-admin' ),
			  'slide' => __( 'Slide', 'social-board-admin' )
            ),
            'default' => 'rotate',
            'attributes' => array(
              'select' => array(
                'style' => "width: 150px;"
              )
            )
          )
        );
      }
    }
	}
}

add_action('axs_themes_section', 'axs_themes_section_hero');
function axs_themes_section_hero() {
	new AXS_MetaBox_Hero(
		'axs_metabox_hero',
		__( 'Hero Theme Settings', 'admin-page-framework-loader' ),
		array( 'sb_themes' ),
		'normal',
		'default'
	);
}
