<?php
/**
 * AX Social Stream
 * Copyright 2014 Axent Media (support@axentmedia.com)
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Elementor_AX_Social_Stream_Extension {
	private static $_instance = null;
	
    public static function instance() {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
	}
	
    public function __construct() {
		add_action( 'init', [ $this, 'init' ] );
	}
	
    public function init() {
        // Add Plugin actions
        add_action( 'elementor/widgets/widgets_registered', [ $this, 'init_widgets' ] );
	}

    public function init_widgets() {
        // Include Widget files
        require_once( __DIR__ . '/widgets.php' );

        // Register widget
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor_AX_Social_Stream_Widget() );
    }
}

Elementor_AX_Social_Stream_Extension::instance();
