<?php

/**
 * AX Social Stream
 * Copyright 2014 Axent Media (support@axentmedia.com)
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class AXS_VCExtendAddon {
    function __construct() {
        // We safely integrate with VC with this hook
        add_action( 'vc_before_init', array( $this, 'integrateWithVC' ) );
    }

    public function integrateWithVC() {

        $items = array();
        $choices = array();
        
        // get sb items
        $items = axs_getPostTitles('sb_posts');
        
        foreach ($items as $itemKey => $itemValue) {
            $choices[$itemValue] = $itemKey;
        }
        
        if ( empty( $choices ) ) {
            $choices[] = array( __( 'No Social Stream items available.', 'social-board-admin' ) => '' );
        }
        
        // Lets call vc_map function to "register" our custom shortcode within Visual Composer interface.
        vc_map( array(
            "name" => __("Social Stream", 'social-board-admin'),
            "description" => __("Adds a Social Stream into your page", 'social-board-admin'),
            "base" => "social_board",
            "class" => "",
            "controls" => "full",
            "icon" => "sb-icon32",
            "category" => __('Social', 'social-board-admin'),
            "params" => array(
                array(
                  "type" => "dropdown",
                  "heading" => __('Social Stream', 'social-board-admin'),
                  "param_name" => "id",
                  "value" => $choices,
                  "admin_label" => true,
                  "description" => __("Select a previously created Social Stream.", "social-board-admin")
                ),
                array(
                  "type" => "dropdown",
                  "heading" => __('Display Mode', 'social-board-admin'),
                  "param_name" => "type",
                  "value" => array(
                      __("Select", 'social-board-admin') => '',
                      __("Masonry", 'social-board-admin') => 'wall',
                      __("Timeline", 'social-board-admin') => 'timeline',
                      __('Rotating Feed', 'social-board-admin') => 'feed',
                      __('Carousel', 'social-board-admin') => 'carousel',
                      __('Grid', 'social-board-admin') => 'grid',
                  ),
                  "description" => __("There are multiple display modes for different situations. Select the one that best suits your needs.", "social-board-admin"),
                )
            )
        ) );
    }
}

// Finally initialize code
new AXS_VCExtendAddon();
