<?php
/*
 * Admin Page Framework v3.9.1 by Michael Uno
 * Compiled with Admin Page Framework Compiler <https://github.com/michaeluno/social-board-admin-compiler>
 * <https://en.michaeluno.jp/social-board-admin>
 * Copyright (c) 2013-2022, Michael Uno; Licensed under MIT <https://opensource.org/licenses/MIT>
 */

abstract class SB_AdminPageFramework_PageMetaBox_Model extends SB_AdminPageFramework_PageMetaBox_Router {
    public function _replyToSetUpValidationHooks($oScreen)
    {
        foreach ($this->oProp->aPageSlugs as $_sIndexOrPageSlug => $_asTabArrayOrPageSlug) {
            if (is_scalar($_asTabArrayOrPageSlug)) {
                $_sPageSlug = $_asTabArrayOrPageSlug;
                add_filter("validation_saved_options_without_dynamic_elements_{$_sPageSlug}", array( $this, '_replyToFilterPageOptionsWODynamicElements' ), 10, 2);
                add_filter("validation_{$_sPageSlug}", array( $this, '_replyToValidateOptions' ), 10, 4);
                add_filter("options_update_status_{$_sPageSlug}", array( $this, '_replyToModifyOptionsUpdateStatus' ));
                continue;
            }
            $_sPageSlug = $_sIndexOrPageSlug;
            $_aTabs = $_asTabArrayOrPageSlug;
            foreach ($_aTabs as $_sTabSlug) {
                add_filter("validation_{$_sPageSlug}_{$_sTabSlug}", array( $this, '_replyToValidateOptions' ), 10, 4);
                add_filter("validation_saved_options_without_dynamic_elements_{$_sPageSlug}_{$_sTabSlug}", array( $this, '_replyToFilterPageOptionsWODynamicElements' ), 10, 2);
                add_filter("options_update_status_{$_sPageSlug}_{$_sTabSlug}", array( $this, '_replyToModifyOptionsUpdateStatus' ));
            }
        }
    }
    public function _replyToRegisterMetaBoxes($sPageHook='')
    {
        foreach ($this->oProp->aPageSlugs as $_sKey => $_asPage) {
            if (is_string($_asPage)) {
                $this->_registerMetaBox($_asPage);
                continue;
            }
            $this->_registerMetaBoxes($_sKey, $_asPage);
        }
    }
    private function _registerMetaBoxes($sPageSlug, $asPage)
    {
        foreach ($this->oUtil->getAsArray($asPage) as $_sTabSlug) {
            if (! $this->oProp->isCurrentTab($_sTabSlug)) {
                continue;
            }
            $this->_registerMetaBox($sPageSlug);
        }
    }
    private function _registerMetaBox($sPageSlug)
    {
        add_meta_box($this->oProp->sMetaBoxID, $this->oProp->sTitle, array( $this, '_replyToPrintMetaBoxContents' ), $this->oProp->_getScreenIDOfPage($sPageSlug), $this->oProp->sContext, $this->oProp->sPriority, null);
    }
    public function _replyToFilterPageOptions($aPageOptions)
    {
        return $aPageOptions;
    }
    public function _replyToFilterPageOptionsWODynamicElements($aOptionsWODynamicElements, $oFactory)
    {
        return $this->oForm->dropRepeatableElements($aOptionsWODynamicElements);
    }
    public function _replyToValidateOptions($aNewPageOptions, $aOldPageOptions, $oAdminPage, $aSubmitInfo)
    {
        $_aNewMetaBoxInputs = $this->oForm->getSubmittedData($this->oForm->getHTTPRequestSanitized($_POST));
        $_aOldMetaBoxInputs = $this->oUtil->castArrayContents($this->oForm->getDataStructureFromAddedFieldsets(), $aOldPageOptions);
        $_aNewMetaBoxInputsRaw = $_aNewMetaBoxInputs;
        $_aNewMetaBoxInputs = call_user_func_array(array( $this, 'validate' ), array( $_aNewMetaBoxInputs, $_aOldMetaBoxInputs, $this, $aSubmitInfo ));
        $_aNewMetaBoxInputs = $this->oUtil->addAndApplyFilters($this, "validation_{$this->oProp->sClassName}", $_aNewMetaBoxInputs, $_aOldMetaBoxInputs, $this, $aSubmitInfo);
        $_aNewMetaBoxInputs = $this->oForm->getInputsUnset($_aNewMetaBoxInputs, $this->oProp->sStructureType);
        if ($this->hasFieldError()) {
            $this->setLastInputs($_aNewMetaBoxInputsRaw);
        }
        return $this->oUtil->uniteArrays($_aNewMetaBoxInputs, $aNewPageOptions);
    }
    public function _replyToModifyOptionsUpdateStatus($aStatus)
    {
        if (! $this->hasFieldError()) {
            return $aStatus;
        }
        return array( 'field_errors' => true ) + $this->oUtil->getAsArray($aStatus);
    }
    public function _replyToGetSavedFormData()
    {
        $_aPageOptions = isset($this->oProp->oAdminPage->oProp) ? $this->oProp->oAdminPage->oProp->aOptions : array();
        $_aPageOptions = $this->oUtil->addAndApplyFilter($this, 'options_' . $this->oProp->sClassName, $_aPageOptions);
        return $this->oUtil->castArrayContents($this->oForm->getDataStructureFromAddedFieldsets(), $_aPageOptions);
    }
    private function _getPageMetaBoxOptionsFromPageOptions(array $aPageOptions, array $aFieldsets)
    {
        $_aOptions = array();
        foreach ($aFieldsets as $_sSectionID => $_aFieldsets) {
            if ('_default' === $_sSectionID) {
                foreach ($_aFieldsets as $_aField) {
                    if (array_key_exists($_aField[ 'field_id' ], $aPageOptions)) {
                        $_aOptions[ $_aField[ 'field_id' ] ] = $aPageOptions[ $_aField[ 'field_id' ] ];
                    }
                }
            }
            if (array_key_exists($_sSectionID, $aPageOptions)) {
                $_aOptions[ $_sSectionID ] = $aPageOptions[ $_sSectionID ];
            }
        }
        return $_aOptions;
    }
}
