<?php

namespace AXS_AX_SOCIAL\TIKTOK;

class AXS_Tiktok {
	public $cache, $forceCrawl, $debug_log;
	public $settings;

    function __construct() {
      $this->settings = get_option("AXS_Settings_Page") ? get_option("AXS_Settings_Page") : get_option("SB_Settings_Page");
    }

	public function get_apis() {
		return !empty($this->settings['section_tiktok']) ? $this->settings['section_tiktok'] : null;
	}

	public function get_token($id) {
		$apis = $this->get_apis();

		if ( empty( $apis ) ) {
			return;
		}

		if ( empty( $apis['tiktok_accounts'] ) ) {
			return;
		}

		$accounts = $apis['tiktok_accounts'];

		$account = false;
		foreach ( $accounts as $k => $v ) {
			if ( $k == $id ) {
				$account = $v;
			}
		}

		if ( empty( $account ) ) {
			return;
		}
		$token = $account['access_token'];

		$is_expired = time() > $account['updated_at'] + $account['expires_in'] - 3600;
		// 3600 = 1 hour is left to expire
		if ($is_expired) {
			$our_app = $apis['tiktok_app'];
			$token = $this->refresh_token( $account, $our_app );
		}

		return $token;
	}
	
	public function get_user_data($id) {
		$apis = $this->get_apis();

		if ( empty( $apis ) ) {
			return;
		}

		if ( empty( $apis['tiktok_accounts'] ) ) {
			return;
		}

		$accounts = $apis['tiktok_accounts'];

		$account = false;
		foreach ( $accounts as $k => $v ) {
			if ( $k == $id ) {
				$account = $v;
			}
		}

		if ( empty( $account ) ) {
			return;
		}
		
		$avatar = (isset($account['avatar_url_100']) && !empty($account['avatar_url_100'])) ? $account['avatar_url_100'] : $account['avatar_url'];

		return array(
			'display_name' => $account['display_name'],
			'avatar' => $avatar,
		);
	}

	public function refresh_token( $account, $our_app ) {
		if ( empty( $account['refresh_token'] ) ) {
			return;
		}

		$body = array(
			'tiktok_refresh' => 'refresh',
			'tiktok_refresh_token'   => $account['refresh_token']
		);

		if ($our_app == 'no') {
			$body['tiktok_api_key']    = $account['client_key'];
			$body['tiktok_api_secret'] = $account['client_secret'];
		}

		$get_token = wp_remote_post( 'https://axentmedia.com/tiktok-access-token/', array(
			'method'  => 'POST',
			'body' 	  => $body,
			'headers' => array(
				'Cache-Control' => 'no-cache'
			),
			'timeout' => 30
			)
		);

		if ( is_wp_error( $get_token ) ) {
			$error_message = $get_token->get_error_message();
			axs_log( 'TikTok error: '.$error_message );
		} else {
			$response_code = wp_remote_retrieve_response_code( $get_token );
			if ( ! $response_code == 200 ) {
				axs_log( 'TikTok error: '.$get_token['response']['message'] );
			} else {
				$res_body = json_decode($get_token['body']);
				if ( isset($res_body->access_token) ) {
					// Update token
					$setoptions = $this->settings;
					$setoptions['section_tiktok']['tiktok_accounts'][$res_body->open_id]['access_token']       = $res_body->access_token;
					$setoptions['section_tiktok']['tiktok_accounts'][$res_body->open_id]['expires_in'] 				 = $res_body->expires_in;
					$setoptions['section_tiktok']['tiktok_accounts'][$res_body->open_id]['updated_at'] 			   = time();
					$setoptions['section_tiktok']['tiktok_accounts'][$res_body->open_id]['refresh_token']      = $res_body->refresh_token;
					$setoptions['section_tiktok']['tiktok_accounts'][$res_body->open_id]['refresh_expires_in'] = $res_body->refresh_expires_in;
					update_option("AXS_Settings_Page", $setoptions);

					return $res_body->access_token;
				} else {
					axs_log( 'TikTok error: '.$res_body->message );
				}
			}
		}

		return;
	}
}