<?php
/**
 * AX Social Stream
 * Copyright © 2014 Axent Media LLC, All Rights Reserved.
 * https://axentmedia.com/support/
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class AXS_Default_Layout extends AXS_Layout {
	function __construct() {
        add_filter( 'axs_supported_layouts_default', function() {
			return ['wall', 'timeline', 'feed', 'carousel'];
        });
        // If using the same theme for different streams on the same page
        if ( ! has_filter( 'axs_inline_styles_default' )  ) {
            add_filter( 'axs_inline_styles_default', array( $this, 'axs_inline_styles_callback'), 10, 1 );
            add_filter( 'axs_create_item_default', array( $this, 'axs_create_item_callback'), 10, 6 );
            add_filter( 'axs_create_ad_default', array( $this, 'axs_create_ad_callback'), 10, 4 );
            add_filter( 'axs_create_slideitem_default', array( $this, 'axs_create_slideitem_callback'), 10, 5 );
        }
    }

    function show_labels() {
        $show_labels = ! empty($this->themedefoption['show_labels']) ? $this->themedefoption['show_labels']
        : array(
            'posted' => true,
            'tags' => true,
            'comments' => true,
            'likes' => true,
            'retweets' => true,
            'repin' => true
        );
        return $show_labels;
    }

    function axs_create_item_callback( $feed_class, $param, $attr = array(), $sbi = 0, $i = 0, $ifeed = 0 ) {
        $filtername = ' '.$feed_class.'-'.$i.'-'.$ifeed;
        $playstate = (isset($param['play']) && !empty($param['play'])) ? '<div class="sb-playstate"></div>' : '';
		$datasize = (isset($param['size']) && !empty($param['size'])) ? ' data-size="' . $param['size'] . '"' : '';
        $imglayout = (isset($attr['layout_image']) && !empty($attr['layout_image'])) ? ' sb-'.$attr['layout_image'] : '';
		$imgAlt = $this->axs_create_alt($feed_class, $param);

        $show_labels = $this->show_labels();
        
        $item_data_link = (isset($param['url']) && !empty($param['url'])) ? 'data-link="'.$param['url'].'"' : '';
		$item_data_is_lightbox = ( isset($param['iframe']) && !empty($param['iframe']) && in_array($param['iframe'], ['icbox', 'iframe']) ) ? ' data-lightbox="true"' : ' data-lightbox="false"';

        $noclass = array();
        if ( empty($this->output['info']) ) {
            $noclass[] = ' sb-nofooter';
		}
        if ( empty($param['thumb']) || empty($this->output['thumb']))
            $noclass[] = ' sb-nothumb';
        if ( count($noclass) > 1 ) {
            $noclass = array();
            $noclass[] = ' sb-noft';
        }
        $no_inner = (array_sum($this->output) == 1 AND ! empty($this->output['thumb']) AND empty($attr['carousel']) ) ? true : false;
        if ($no_inner) {
            $noclass[] = ' sb-noinner';
		}

        $no_meta = ( ! empty($param['meta']) && (!empty($this->output['comments']) || !empty($this->output['likes'])) ) ? false : true;
        if ($no_meta)
            $noclass[] = ' sb-nometa';

        $inner = '<div class="sb-container'.$imglayout.( implode('', $noclass) ).'">';

		$thumb_media_class = '';
		if ( isset($this->themedefoption['hover_effect']) && $hover_effect = $this->themedefoption['hover_effect']) {
			$thumb_media_class .= " sb-$hover_effect";
		}
		if ($child_medias = $this->axs_create_child_items($param,$sbi)) {
			$inner .= $child_medias;
			$thumb_media_class .= " sb-child-media-true";
		}
        
        $thumb = $sbthumb = '';
		if (isset($attr['carousel']) && !empty($attr['carousel'])) {
            $cropclass = 'sb-crop';
            if (isset($param['iframe']) && !empty($param['iframe']))
                $cropclass .= ' '.$param['iframe'];
            if (isset($param['thumb']) && !empty($param['thumb']) && isset($this->output['thumb']) && !empty($this->output['thumb'])) {
				$aurl = $param['thumburl'] ?? ($param['url'] ?? '');
				if (isset($param['object']) && $attr['lightboxtype'] == 'media') {
					$aurl32 = sprintf("%u", crc32($aurl) );
					$aurl = "#$aurl32";
					$thumb .= '
					<div style="display: none">
						<div class="sb-object" id="'.$aurl32.'">
							' . $param['object'] . '
						</div>
					</div>';
				}
                $sbimg = (isset($attr['lazyload']) && !empty($attr['lazyload'])) ? 'data-lazy="' . htmlspecialchars($param['thumb']) . '"' : 'src="' . htmlspecialchars($param['thumb']) . '"';
				$thumb .= '<a class="'.$cropclass.'" href="' . $aurl . '"'.$datasize.$this->target.'><img class="sb-img" '.$sbimg.' alt="'.$imgAlt.'">'.$playstate.'</a>';
            } else {
                $user_title = $param['user']['title'] ?? $param['user']['name'];
                $cropclass .= ' sb-userimg';
                if (!empty($param['user']['image']) && empty($this->output['thumb'])) {
                    $thumb .= '<div class="'.$cropclass.'"><img class="sb-img" src="' . $param['user']['image'] . '" alt="'.$user_title.'"><br /><span>'.$user_title.'</span></div>';
                }
            }
            if (isset($thumb) && !empty($thumb))
                $sbthumb .= '
                <div class="sb-thumb'.($thumb_media_class ?? '').'">
                    ' . $thumb . '
                </div>';
        } else {
            if (isset($param['thumb']) && !empty($param['thumb']) && isset($this->output['thumb']) && !empty($this->output['thumb'])) {
				$aurl = $param['thumburl'] ?? ($param['url'] ?? '');
				$aurl = htmlspecialchars($aurl);
				if (isset($param['object']) && !empty($param['object']) && isset($attr['lightboxtype']) && $attr['lightboxtype'] == 'media') {
					$aurl32 = sprintf("%u", crc32($aurl) );
					$aurl = "#$aurl32";
					$sbthumb .= '
					<div style="display: none">
						<span class="sb-object" id="'.$aurl32.'">
							' . $param['object'] . '
						</span>
					</div>';
                }
                $sbimg = (isset($attr['lazyload']) && !empty($attr['lazyload'])) ? 'data-original="' . htmlspecialchars($param['thumb']) . '" src="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAwIiBoZWlnaHQ9IjIwMCIgdmlld0JveD0iLTQzIC00MyAxMjQgMTI0IiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHN0cm9rZT0iI2ZmZiI+ICAgIDxnIGZpbGw9Im5vbmUiIGZpbGwtcnVsZT0iZXZlbm9kZCI+ICAgICAgICA8ZyB0cmFuc2Zvcm09InRyYW5zbGF0ZSgxIDEpIiBzdHJva2Utd2lkdGg9IjIiPiAgICAgICAgICAgIDxjaXJjbGUgc3Ryb2tlLW9wYWNpdHk9Ii41IiBjeD0iMTgiIGN5PSIxOCIgcj0iMTgiLz4gICAgICAgICAgICA8cGF0aCBkPSJNMzYgMThjMC05Ljk0LTguMDYtMTgtMTgtMTgiPiAgICAgICAgICAgICAgICA8YW5pbWF0ZVRyYW5zZm9ybSAgICAgICAgICAgICAgICAgICAgYXR0cmlidXRlTmFtZT0idHJhbnNmb3JtIiAgICAgICAgICAgICAgICAgICAgdHlwZT0icm90YXRlIiAgICAgICAgICAgICAgICAgICAgZnJvbT0iMCAxOCAxOCIgICAgICAgICAgICAgICAgICAgIHRvPSIzNjAgMTggMTgiICAgICAgICAgICAgICAgICAgICBkdXI9IjFzIiAgICAgICAgICAgICAgICAgICAgcmVwZWF0Q291bnQ9ImluZGVmaW5pdGUiLz4gICAgICAgICAgICA8L3BhdGg+ICAgICAgICA8L2c+ICAgIDwvZz48L3N2Zz4="' : 'src="' . htmlspecialchars($param['thumb']) . '"';
                $sbthumb .= '
                <div class="sb-thumb'.($thumb_media_class ?? '').'">
                    <a href="' . $aurl . '" class="'.($param['iframe'] ?? '').'"'.$datasize.$this->target.'><img class="sb-img" '.$sbimg.' alt="'.$imgAlt.'">'.$playstate.'</a>
                </div>';
            }
        }
        
        if (isset($sbthumb) && !empty($sbthumb) && isset($attr['layout_image']) && $attr['layout_image'] == 'imgexpand') {
            $inner .= $sbthumb;
            $userclass = ' sb-usermini';
        }
        
        $idstr = ' id="'.$sbi.'"';
        if (isset($attr['lightboxtype']) && $attr['lightboxtype'] == 'slideshow') {
            $inline = ' data-href="#inline_'.$sbi.'"';
            $sbinline = ' sb-inline';
        } else {
            $inline = $sbinline = '';
        }
        
        if ( ! $no_inner)
            $inner .= '
            <div class="sb-inner">';

        if (isset($param['user']) && !empty($param['user']) && isset($attr['userinfo']) && $attr['userinfo'] == 'top') {
            if (isset($param['user']['title']) && !empty($param['user']['title']) && isset($param['user']['name']) && !empty($param['user']['name'])) {
                $user_title = $param['user']['title'] ?? '';
                $user_text = ( isset($param['user']['url']) && !empty($param['user']['url']) ) ? '<a href="' . ($param['user']['url'] ?? '') . '"'.$this->target.'>' . ($param['user']['name'] ?? '') . '</a>' : ($param['user']['name'] ?? '');
            } else {
                $user_title = $param['user']['name'] ?? '';
                if (isset($param['user']['status']) && !empty($param['user']['status']))
                    $user_text = ( isset($param['url']) && !empty($param['url']) ) ? '<a href="' . $param['url'] . '"'.$this->target.'>' . $param['user']['status'] . '</a>' : $param['user']['status'];
                else
                    $user_title_style = ' style="padding-top: 5px"';
            }
            if (isset($this->output['user']) && !empty($this->output['user'])) {
                $inner .= '
                <div class="sb-user'.($userclass ?? '').'">';
                if (isset($param['user']['image']) && !empty($param['user']['image'])) {
                    $user_image = ( isset($param['user']['url']) && !empty($param['user']['url']) ) ? '<a href="' . $param['user']['url'] . '"'.$this->target.'><img class="sb-img" alt="' . ($param['user']['name'] ?? '') . '" src="' . $param['user']['image'] . '"></a>' : '<img class="sb-img" alt="' . ($param['user']['name'] ?? '') . '" src="' . $param['user']['image'] . '">';
                    $inner .= '
    				<div class="sb-uthumb">'.$user_image.'</div>';
                } else {
                    $no_thumb_class = ' sb-nouthumb';
                }
                if ($user_title || !empty($user_text)) {
                    $user_title_linked = ( isset($param['user']['url']) && !empty($param['user']['url']) ) ? '<a href="' . $param['user']['url'] . '"'.$this->target.'>'.$user_title.'</a>' : $user_title;
                    $inner .= '
                        <div class="sb-uinfo'.($no_thumb_class ?? '').'">';
                    if ($user_title)
                        $inner .= '<div class="sb-utitle"'.($user_title_style ?? '').'>' . $user_title_linked . '</div>';
                    if (isset($user_text) && !empty($user_text))
                        $inner .= '<div class="sb-uname">' . $user_text . '</div>';
                    $inner .= '
                        </div>';
                }
                $inner .= '
                </div>';
            }
        }
        
        if (isset($param['title']) && !empty($param['title']) && isset($this->output['title']) && !empty($this->output['title']) && empty($attr['carousel'])) {
            $inner .= '
            <span class="sb-title">
                ' . $param['title'] . '
            </span>';
        }
        
        if (isset($sbthumb) && !empty($sbthumb) && isset($attr['layout_image']) && $attr['layout_image'] == 'imgnormal') {
            $inner .= $sbthumb;
        }
        
        if ( (isset($param['text']) && !empty($param['text']) && isset($this->output['text']) && !empty($this->output['text'])) || (isset($attr['carousel']) && !empty($attr['carousel'])) ) {
            $expandclass = (empty($thumb)) ? ' sb-expand' : '';
            
            if (isset($param['title']) && !empty($param['title']) && isset($this->output['title']) && !empty($this->output['title']) && isset($attr['carousel']) && !empty($attr['carousel'])) {
                $inner_title = '
                <span class="sb-title">
                    ' . $param['title'] . '
                </span>';
            } else {
                $expandclass .= ' sb-notitle';
            }
            
            $inner .= '<span class="sb-text'.$expandclass.'">'.($inner_title ?? '');
            $inner .= $param['text'];
            $inner .= '</span>';
        }
        
        if (empty($attr['carousel'])) {
            if (isset($param['tags']) && !empty($param['tags']) && isset($this->output['tags']) && !empty($this->output['tags']))
                $inner .= '
                <span class="sb-text">
                    ' . (isset($show_labels['tags']) && !empty($show_labels['tags']) ? '<strong>'.__( 'Tags', 'social-board' ).': </strong>' : '') . $param['tags'] . '
                </span>';
        }

        // comments/likes block
        if ( ! $no_meta ) {
            $ticons = ['likes' => 'star', 'comments' => 'comments', 'retweets' => 'retweet'];
            $tlabels = ['secs' => 'secs', 'mins' => 'mins'];
            $mc = 0;
            $inner .= '
            <span class="sb-metadata">';
            if ( ! empty($param['meta']) && (!empty($this->output['comments']) || !empty($this->output['likes'])) ) {
                foreach ($param['meta'] as $key => $meta) {
                    if ( ! empty($meta['total']) ) {
                        if ($mc == 0 ) {
                            $inner .= '<span class="sb-meta">';
                            $mc = 1;
                        }
                        if ( intval($meta['total']['count']) > 0 ) {
                            $inner .= '
                                <span class="'.$key.'">'
                                . ( isset($meta['total']['url']) ? '<a href="' . $meta['total']['url'] . '"'.$this->target.'>' : '') . '
                                    <i class="sb-bico sb-'.(!empty($meta['total']['class']) ? $meta['total']['class'] : $ticons[$key]).'"></i> ' . countFormatter($meta['total']['count']) . (!empty($tlabels[$key]) ? ' ' . $tlabels[$key] : (!empty($show_labels[$key]) ? ' ' . ucfirst( __( $key, 'social-board' ) ) : '') )
                                . ( isset($meta['total']['url']) ? '</a>' : '') . '
                                </span>';
                        }
                    }
                    if ( ! empty($meta['data']) && empty($attr['carousel']) ) {
                        if ($mc == 1) {
                            $inner .= '</span>';
                            $mc = 0;
                        }
                        if ( $key == 'comments' && isset($this->output['comments']) && !empty($this->output['comments']) ) {
                            if ($meta['data'] == 'fetch') {
                                $inner .= '
                                <div class="sb-fetchcomments" data-nonce="'.wp_create_nonce( 'fetchcomments' ).'" data-id="'.$param['id'].'" data-link="'.$param['url'].'" data-feed="'.$feed_class.'-'.$i.'-'.$ifeed.'">
                                    <a href="javascript:void(0)" class="sb-triggercomments">'. __( 'Show Comments', 'social-board' ) .'</a>
                                </div>';
                            } else {
                                $inner .= '
                                <div class="sb-fetchcomments">
                                    '.$meta['data'].'
                                </div>';
                            }
                        } elseif ( $key == 'likes' && isset($this->output['likes']) && !empty($this->output['likes']) ) {
                            $inner .= '
                            <span class="sb-meta item-likes">
                                ' . $meta['data'] . '
                            </span>';
                        } else {
                            $inner .= $meta['data'];
                        }
                    }
                }
                if ($mc == 1) {
                    $inner .= '</span>';
                    $mc = 0;
                }
            }
            $inner .= '
            </span>';
        }
        // END: comments/likes block

        $us = '';
        if ( isset($param['url']) && !empty($param['url']) && isset($this->output['share']) && !empty($this->output['share']) ) {
            if (isset($param['share']) && !empty($param['share']))
                $us .= $param['share'];
            else {
            $sharetitle = urlencode( strip_tags($param['title'] ?? '') );
            $us .= '
                <span class="sb-share">
                    <a class="sb-facebook sb-hover" href="https://www.facebook.com/sharer.php?u=' . urlencode($param['url']) . '&t=' . ($sharetitle ?? '') . '"'.$this->target.'>
                        <i class="sb-sicon sb-facebook"></i>
                    </a>
                    <a class="sb-twitter sb-hover" href="https://twitter.com/intent/tweet?url=' . urlencode($param['url']) . '&text=' . ($sharetitle ?? '') . '"'.$this->target.'>
                        <i class="sb-sicon sb-twitter"></i>
                    </a>
                    <a class="sb-pinterest sb-hover" href="//pinterest.com/pin/create/link/?url=' . urlencode($param['url']) . '&description=' . ($sharetitle ?? '') . '"'.$this->target.'>
                        <i class="sb-sicon sb-pinterest"></i>
                    </a>
                    <a class="sb-linkedin sb-hover" href="https://www.linkedin.com/shareArticle?mini=true&url=' . urlencode($param['url']) . '&title=' . ($sharetitle ?? '') . '"'.$this->target.'>
                        <i class="sb-sicon sb-linkedin"></i>
                    </a>
                </span>';
            }
        }
        if ( isset($param['user']) && !empty($param['user']) && isset($this->output['user']) && !empty($this->output['user']) && isset($attr['userinfo']) && $attr['userinfo'] == 'bottom' && isset($param['user']['name']) && !empty($param['user']['name']) ) {
            $user_text = ( isset($param['user']['url']) && !empty($param['user']['url']) ) ? '<a href="' . $param['user']['url'] . '"'.$this->target.'>' . ($param['user']['name'] ?? '') . '</a>' : ($param['user']['name'] ?? '');
            $us .= '
            <span class="sb-user-foot">
                <i class="sb-bico sb-user-foot"></i> ' . $user_text . '
            </span>';
        }
        if (isset($us) && !empty($us))
            $inner .= '
            <div class="sb-info">
                ' . $us . '
            </div>';

        if ( ! $no_inner)
            $inner .= '
            </div>';
        
        if ( $attr['type'] == 'timeline' ) {
            $icon = ( isset($param['icon'][1]) && !empty($param['icon'][1]) ) ? '<img class="sb-img" src="'.$param['icon'][1].'" style="vertical-align:middle" alt="icon">' : '<i class="sb-icon sb-' . $feed_class . '"></i>';
            $out = '
          <div class="timeline-row"'.$idstr.'>
            <div class="timeline-time">
              <small>'. axs_i18n_date( $param['date'], get_option( 'date_format' ) ) .'</small>'. axs_i18n_date( $param['date'], get_option( 'time_format' ) ) .'
            </div>
            <div class="timeline-icon">
              <div class="bg-' . $feed_class . '">
                ' . $icon . '
              </div>
            </div>
            <div class="timeline-content">
              <div class="panel-body sb-item sb-' . $feed_class . $filtername . $sbinline.'"'.$inline.' '.$item_data_link.$item_data_is_lightbox.'>
              ' . $inner . '
              </div>
            </div>
          </div>
        </div>' . "\n";
        } else {
            $icon = ( isset($param['icon'][0]) && !empty($param['icon'][0]) ) ? '<img class="sb-img" src="'.$param['icon'][0].'" style="vertical-align:middle" alt="icon">' : '<i class="sb-icon sb-' . $feed_class . '"></i>';
            $tag = ( $attr['type'] != 'feed' || !empty($attr['carousel']) ) ? 'div' : 'li';
            
            $out1 = '
            <'.$tag.' class="sb-item sb-' . $feed_class . $filtername . $sbinline.'"'.$idstr.$inline.' '.$item_data_link.$item_data_is_lightbox.'>
                ' . $inner;
            if ( $param['date'] && !empty($this->output['info']) ) {
            $out1 .= '
                <div class="sb-footer bg-' . $feed_class . '">
                    ' . $icon . '
                    <a href="' . ($param['url'] ?? '') . '"'.$this->target.'>'. (!empty($show_labels['posted']) ? __( 'Posted', 'social-board' ) . ': ' : '') . axs_friendly_date($param['date'], $this->attr['dateformat']) . '</a>
                </div>';
			}
            $out1 .= '
            </div>
            </'.$tag.'>' . "\n";
            
            $out = (isset($attr['carousel']) && !empty($attr['carousel'])) ? '<li>'.$out1.'</li>' : $out1;
        }
        return $out;
    }

	function axs_create_ad_callback($adgrid, $adstyle, $adcontent, $ad) {
        if ($ad['ad_type'] == 'text') {
            $adinnerstyle = '';
            if (isset($ad['ad_border_size']) && !empty($ad['ad_border_size'])) {
                $border_radius = 5+$ad['ad_border_size']-1;
                $adinnerstyle .= 'border-radius: '.$border_radius.'px;-moz-border-radius: '.$border_radius.'px;-webkit-border-radius: '.$border_radius.'px;';
            }
            $adinnerstyle .= 'background-color: transparent !important;';
            $adcontent = '<div class="sb-inner"'.(isset($adinnerstyle) && !empty($adinnerstyle) ? ' style="'.$adinnerstyle.'"' : '').'>'.$adcontent.'</div>';
        }
        if ( ( $this->type == 'timeline' ) ) {
            $adout = '
            <div class="timeline-row">
                <div class="timeline-icon">
                  <div class="bg-ad">
                    <i class="sb-bico sb-wico sb-star"></i>
                  </div>
                </div>
                <div class="timeline-content">
                  <div class="panel-body sb-item sb-advert">
                    <div class="sb-container"'.(isset($adstyle) && !empty($adstyle) ? ' style="'.$adstyle.'"' : '').'>';
                    $adout .= $adcontent;
                    $adout .= '
                    </div>
                  </div>
                </div>
            </div>' . "\n";
        } else {
            $adout = '
            <div class="sb-item sb-advert'.( empty($this->attr['carousel']) ? $adgrid : '').'">
                <div class="sb-container"'.(isset($adstyle) && !empty($adstyle) ? ' style="'.$adstyle.'"' : '').'>';
                $adout .= $adcontent;
                $adout .= '
                </div>
            </div>' . "\n";
        }

		return $adout;
	}

    function axs_create_colors( $dotboard ) {
        $social_colors = $this->themedefoption['social_colors'];
        $style = array();
        foreach ($social_colors as $colorKey => $colorVal) {
            if ( is_array($this->feed_keys[$colorKey]) ) {
                $feedname = key($this->feed_keys[$colorKey]);
                if (isset($colorVal) && !empty($colorVal) && $colorVal != 'transparent') {
                    $style[$dotboard.' .bg-'.$feedname][] = 'background-color:'.$colorVal.' !important';
                    
                    if (isset($this->attr['lightboxtype']) && $this->attr['lightboxtype'] == 'slideshow')
                        $style['.sb-slide-icon.sb-'.$feedname][] = 'background-color: '.$colorVal.' !important';
                        
                    $dotfilter = ( $this->type == 'wall' ) ? str_replace(array('timeline', '.sboard'), array('sb', ''), $dotboard) : $dotboard;
                    if (empty($this->attr['carousel']))
                        $style[$dotfilter.' .sb-'.$feedname.'.sb-hover:hover, '.$dotfilter.' .sb-'.$feedname.'.active'][] = 'background-color: '.$colorVal.' !important;border-color: '.$colorVal.' !important;color: #fff !important';
                    
                    // set colors for tabs
                    if (isset($this->attr['tabable']) && !empty($this->attr['tabable'])) {
                        $style["$dotboard.tabable .sb-tabs .sticky .".$feedname.":hover, $dotboard.tabable .sb-tabs .sticky .".$feedname.".active"][] = 'background-color: '.$colorVal;
                    }
                }
            }
        }
        
        // set item background color
        if ( isset($this->themetypeoption['item_background_color']) && !empty($this->themetypeoption['item_background_color']) ) {
            if ( $this->themetypeoption['item_background_color'] != 'transparent') {
                $style["$dotboard .sb-item .sb-container .sb-inner"][] = 'background-color: '.$this->themetypeoption['item_background_color'];
            }
        }
        
        // set item border
        if ( isset($this->themetypeoption['item_border_size']) && $border_size = $this->themetypeoption['item_border_size'] ) {
            if ( $border_size > 1 ) {
                $border_radius = 3+$border_size-1;
                $style["$dotboard .sb-item .sb-container"][] = 'border-radius: '.$border_radius.'px;-moz-border-radius: '.$border_radius.'px;-webkit-border-radius: '.$border_radius.'px';
            }
        }
        if ( isset($this->themetypeoption['item_border_color']) && !empty($this->themetypeoption['item_border_color']) ) {
            if ( $this->themetypeoption['item_border_color'] != 'transparent') {
                $dontbordersize = true;
                $style["$dotboard .sb-item .sb-container"][] = 'border: '.($this->themetypeoption['item_border_size'] ?? '').'px solid '.$this->themetypeoption['item_border_color'];
                $style["$dotboard .sb-item .sb-container"][] = 'background-color: '.$this->themetypeoption['item_border_color'];
            }
        }
        if ( isset($this->themetypeoption['item_border_size']) && !empty($this->themetypeoption['item_border_size']) && empty($dontbordersize) ) {
            $style["$dotboard .sb-item .sb-container"][] = 'border-width: '.($this->themetypeoption['item_border_size'] ?? '').'px';
        }
        
        return $style;
    }

	function axs_inline_styles_callback( $args ) {
        extract($args);

        if (isset($this->themedefoption['social_colors']) && !empty($this->themedefoption['social_colors'])) {
            $style = $this->axs_create_colors($dotboard);
        }

        $dotboard .= '.sb-' . $this->layout;
        if ( isset($this->themedefoption['font_size']) && $font_size = $this->themedefoption['font_size'] ) {
            $style["$dotboard, $dotboard a"][] = 'font-size: '.$font_size.'px';
            $style["$dotboard .sb-heading"][] = 'font-size: '.($font_size+1).'px !important';
        }
        
        if ( $is_feed && isset($this->themetypeoption['title_background_color']) && !empty($this->themetypeoption['title_background_color']) )
        if ( $this->themetypeoption['title_background_color'] != 'transparent') {
            $style["$dotboard .sb-heading, $dotboard .sb-opener"][] = 'background-color: '.$this->themetypeoption['title_background_color'].' !important';
        }
        if ( $is_feed && isset($this->themetypeoption['title_color']) && !empty($this->themetypeoption['title_color']) )
        if ( $this->themetypeoption['title_color'] != 'transparent')
            $style["$dotboard .sb-heading"][] = 'color: '.$this->themetypeoption['title_color'];

        if ( $is_feed ) {
            if (isset($this->attr['carousel']) && !empty($this->attr['carousel']))
                $csskey = "$dotboard .ax-slider";
            else
                $csskey = "$dotboard .sb-content, $dotboard .toolbar";
        } else
            $csskey = '#sb_'.$label;
            
        if ( isset($this->themetypeoption['background_color']) && !empty($this->themetypeoption['background_color']) ) {
            if ( $this->themetypeoption['background_color'] != 'transparent') {
                $bgexist = true;
                $style[$csskey][] = 'background-color: '.$this->themetypeoption['background_color'];
            }
        }
        
        if ( $is_timeline )
            $fontcsskey = "$dotboard .timeline-row";
        else
            $fontcsskey = "$dotboard .sb-item";
            
        if (isset($this->themetypeoption['font_color']) && !empty($this->themetypeoption['font_color']))
        if ($this->themetypeoption['font_color'] != 'transparent') {
            $rgbColorVal = axs_hex2rgb($this->themetypeoption['font_color']); // returns the rgb values separated by commas
            
            if ( $is_timeline ) {
                $style["$dotboard .timeline-row small"][] = 'color: '.$this->themetypeoption['font_color'];
            }
            
            $style["$fontcsskey .sb-title a"][] = 'color: '.$this->themetypeoption['font_color'];
            $style["$fontcsskey"][] = 'color: rgba('.$rgbColorVal.', 0.8)';
        }
        if (isset($this->themetypeoption['link_color']) && !empty($this->themetypeoption['link_color']))
        if ($this->themetypeoption['link_color'] != 'transparent') {
            $rgbColorVal = axs_hex2rgb($this->themetypeoption['link_color']); // returns the rgb values separated by commas
            $style["$fontcsskey a"][] = 'color: '.$this->themetypeoption['link_color'];
            $style["$fontcsskey a:visited"][] = 'color: rgba('.$rgbColorVal.', 0.8)';
        }

        if ( isset($this->themetypeoption['background_image']) && !empty($this->themetypeoption['background_image']) ) {
            $bgexist = true;
            $cssbgkey = $csskey;
            if ( $is_feed )
                $cssbgkey = "$dotboard .sb-content";
            $style[$cssbgkey][] = 'background-image: url('.$this->themetypeoption['background_image'].');background-repeat: repeat';
        }

    	// set block border
        if ( isset($this->themetypeoption['border_color']) && !empty($this->themetypeoption['border_color']) ) {
            if ( $this->themetypeoption['border_color'] != 'transparent') {
                $bgexist = true;
                if ( $is_feed ) {
                    $style[$dotboard.' .toolbar'][] = 'border-top: 0 !important';
                }
                $style[$csskey][] = 'border: '.($this->themetypeoption['border_size'] ?? '').'px solid '.$this->themetypeoption['border_color'];
            }
        } else {
            if (isset($this->attr['carousel']) && !empty($this->attr['carousel']))
                $style[$dotboard.' .sb-content'][] = 'padding: 10px 0 5px 0';
        }

        if (isset($this->attr['carousel']) && !empty($this->attr['carousel'])) {
            if ( isset($this->themetypeoption['cs_item_padding']) && $this->themetypeoption['cs_item_padding'] != '' ) {
                $style[$dotboard.' .slick-slide > div'][] = 'padding: '.$this->themetypeoption['cs_item_padding'].'px;';
            }
        }
        
        // set block padding if required
        if (isset($bgexist) && !empty($bgexist)) {
            $border_radius = $this->themetypeoption['border_radius'] ?? '';
            if ( ! $is_feed ) {
                if ($border_radius == '')
                    $border_radius = 7;
            }
            if ($border_radius != '') {
                $radius = 'border-radius: '.$border_radius.'px;-moz-border-radius: '.$border_radius.'px;-webkit-border-radius: '.$border_radius.'px';
                if ( ! $is_feed ) {
                    $style['#sb_'.$label][] = $radius;
                } else {
                    if (isset($this->attr['carousel']) && !empty($this->attr['carousel'])) {
                        $style[$csskey][] = $radius;
                    } else {
                        if ($location == 'bottom') {
                            $radiusval = ': '.$border_radius.'px '.$border_radius.'px 0 0;';
                            $style["$dotboard .sb-content, $dotboard.sb-widget, $dotboard .sb-heading"][] = 'border-radius'.$radiusval.'-moz-border-radius'.$radiusval.'-webkit-border-radius'.$radiusval;
                        } else {
                            $style["$dotboard .sb-content, $dotboard.sb-widget"][] = $radius;
                            $style[$dotboard.' .toolbar'][] = 'border-radius: 0 0 '.$border_radius.'px '.$border_radius.'px;-moz-border-radius: 0 0 '.$border_radius.'px '.$border_radius.'px;-webkit-border-radius: 0 0 '.$border_radius.'px '.$border_radius.'px';
                        }
                    }
                }
            }
            if ( $is_wall )
                $style['#sb_'.$label][] = 'padding: 10px';
            elseif (isset($this->attr['carousel']) && !empty($this->attr['carousel']))
                $style[$csskey][] = 'padding: 10px';
        }

        if (isset($this->attr['carousel']) && !empty($this->attr['carousel'])) {
            $style["$dotboard.sb-carousel .sb-item .sb-thumb"][] = 'height: '.$this->attr['cs_height']['thumb'].'px';
            $style["$dotboard.sb-carousel .sb-item .sb-inner .sb-text"][] = 'height: '.$this->attr['cs_height']['text'].'px';
            $sb_expand_size = $this->attr['cs_height']['thumb'] + $this->attr['cs_height']['text'] - 30;
            $style["$dotboard.sb-carousel .sb-item .sb-inner .sb-text.sb-expand"][] = 'height: '.$sb_expand_size.'px';
            $style["$dotboard.sb-carousel .sb-item .sb-inner .sb-metadata"][] = 'height: '.$this->attr['cs_height']['meta'].'px';
            $sb_nometa_size = $this->attr['cs_height']['text'] + $this->attr['cs_height']['meta'];
            $style["$dotboard.sb-carousel .sb-item .sb-nometa .sb-inner .sb-text"][] = 'height: '.$sb_nometa_size.'px';
            $style["$dotboard.sb-carousel .sb-item .sb-nometa .sb-inner .sb-text.sb-expand"][] = 'height: '.($sb_expand_size + $this->attr['cs_height']['meta']).'px';
        }

        return $style;
    }

    function axs_create_slideitem_callback( $feed_class, $param, $sbi = 0, $i = 0, $ifeed = 0 ) {
        $iconSocial = ( isset($param['icon'][0]) && !empty($param['icon'][0]) ) ? '<img src="'.$param['icon'][0].'" class="sb-img origin-flag" style="vertical-align:middle" alt="icon">' : '<span class="sb-slide-icon sb-' . $feed_class . '"><i class="sb-micon sb-' . $feed_class . '"></i></span>';
        $user_title = $param['user']['title'] ?? ($param['user']['name'] ?? '');
        
        $show_labels = $this->show_labels();

		$item_data_link = (isset($param['url']) && !empty($param['url'])) ? 'data-link="'.$param['url'].'"' : '';
		$item_data_is_lightbox = ( isset($param['iframe']) && !empty($param['iframe']) && in_array($param['iframe'], ['icbox', 'iframe']) ) ? ' data-lightbox="true"' : ' data-lightbox="false"';

		$innerthumb = '';
        if (isset($param['object']) && !empty($param['object']) && isset($this->output['thumb']) && !empty($this->output['thumb'])) {
            $object = str_replace( array("\r\n","\r","\t","\n"), '', $param['object'] );
            $object = htmlentities($object, ENT_QUOTES);
            $thumbdata = ' data-type="object" data-media="' . $object . '" data-size="' . ($param['size'] ?? '') . '"';
            $innerthumb .= '
            <span class="sb-thumb sb-object"></span>';
        }
        elseif (isset($param['thumb']) && !empty($param['thumb']) && isset($this->output['thumb']) && !empty($this->output['thumb'])) {
            $thumb = htmlspecialchars($param['thumb']);
            $thumbdata = ' data-type="' . (!empty($param['play']) ? 'video' : 'image') . '" data-media="' . $thumb . '" data-size="' . ($param['size'] ?? '') . '"';
            $innerthumb .= '
            <div class="sb-thumb"></div>';
        } else {
            $nothumb = ' sb-nothumb';
        }

        $inner = '
            <div class="sb-inner"'.($thumbdata ?? '').'>' . $innerthumb;
            
        $inner .= '
                <div class="sb-body'.($nothumb ?? '').'">
					<div class="sb-scroll'.($nothumb ?? '').'">';
		if ( ! empty($this->output['info']) ) {
			$inner .= ($iconSocial ?? '');
		}
        if (isset($param['user']) && !empty($param['user'])) {
            if (isset($param['user']['title']) && !empty($param['user']['title']) && isset($param['user']['name']) && !empty($param['user']['name'])) {
                $user_title = $param['user']['title'] ?? '';
                $user_text = ( isset($param['user']['url']) && !empty($param['user']['url']) ) ? '<a href="' . $param['user']['url'] . '"'.$this->target.'>' . $param['user']['name'] . '</a>' : $param['user']['name'];
            } else {
                $user_title = $param['user']['name'] ?? '';
                if (isset($param['user']['status']) && !empty($param['user']['status']))
                    $user_text = ( isset($param['url']) && !empty($param['url']) ) ? '<a href="' . $param['url'] . '"'.$this->target.'>' . $param['user']['status'] . '</a>' : $param['user']['status'];
                else
                    $user_title_style = ' style="padding-top: 5px"';
            }

            $user_inner = '';
            if (isset($param['user']['image']) && !empty($param['user']['image'])) {
                $user_image = ( isset($param['user']['url']) && !empty($param['user']['url']) ) ? '<a href="' . $param['user']['url'] . '"'.$this->target.'><img class="sb-img" alt="' . $param['user']['name'] . '" src="' . $param['user']['image'] . '"></a>' : '<img class="sb-img" alt="' . $param['user']['name'] . '" src="' . $param['user']['image'] . '">';
                $user_inner .= '
                <div class="sb-uthumb">'.$user_image.'</div>';
            } else {
                $no_thumb_class = ' sb-nouthumb';
            }
            
            if ($user_title || !empty($user_text)) {
                $user_title_linked = ( isset($param['user']['url']) && !empty($param['user']['url']) ) ? '<a href="' . $param['user']['url'] . '"'.$this->target.'>'.$user_title.'</a>' : $user_title;
                $user_inner .= '
                    <div class="sb-uinfo'.($no_thumb_class ?? '').'">';
                if ($user_title)
                    $user_inner .= '<div class="sb-utitle"'.($user_title_style ?? '').'>' . $user_title_linked . '</div>';
                if (isset($user_text) && !empty($user_text) && $user_title)
                    $user_inner .= '<div class="name">' . $user_text . '</div>';
                $user_inner .= '
                    </div>';
            }
            
            if ( isset($this->output['user']) && !empty($this->output['user']) && ($user_title || !empty($user_image)) ) {
                $inner .= '
                <div class="sb-user">';
                $inner .= $user_inner;
                $inner .= '
                </div>';
            }
        }
        
        if (isset($param['title']) && !empty($param['title']) && isset($this->output['title']) && !empty($this->output['title'])) {
            $inner .= '
            <span class="sb-title">
                ' . $param['title'] . '
            </span>';
        }

        if ( isset($param['text']) && !empty($param['text']) && isset($this->output['text']) && !empty($this->output['text']) ) {
            $inner .= '<span class="sb-text">';
            $inner .= $param['text'] ?? '';
            $inner .= '</span>';
        }
        
        if (isset($param['tags']) && !empty($param['tags']) && isset($this->output['tags']) && !empty($this->output['tags'])) {
            $inner .= '
            <span class="sb-text">
                ' . (isset($show_labels['tags']) && !empty($show_labels['tags']) ? '<strong>'.__( 'Tags', 'social-board' ).': </strong>' : '') . $param['tags'] . '
            </span>';
        }
        
        // comments/likes block
        $no_meta = ( ! empty($param['meta']) && (!empty($this->output['comments']) || !empty($this->output['likes'])) ) ? false : true;
        if ( ! $no_meta ) {
            $ticons = ['likes' => 'star', 'comments' => 'comments', 'retweets' => 'retweet'];
            $tlabels = ['secs' => 'secs', 'mins' => 'mins'];
            $mc = 0;
            $inner .= '
            <span class="sb-metadata">';
            if ( ! empty($param['meta']) && (!empty($this->output['comments']) || !empty($this->output['likes'])) ) {
                foreach ($param['meta'] as $key => $meta) {
                    if ( ! empty($meta['total']) ) {
                        if ($mc == 0 ) {
                            $inner .= '<span class="sb-meta">';
                            $mc = 1;
                        }
                        if (isset($meta['total']['count']) && !empty($meta['total']['count'])) {
                            $inner .= '
                                <span class="'.$key.'">'
                                . ( isset($meta['total']['url']) ? '<a href="' . $meta['total']['url'] . '"'.$this->target.'>' : '') . '
                                    <i class="sb-bico sb-'.(isset($meta['total']['class']) && !empty($meta['total']['class']) ? $meta['total']['class'] : $ticons[$key]).'"></i> ' . countFormatter($meta['total']['count']) . (isset($tlabels[$key]) && !empty($tlabels[$key]) ? ' ' . $tlabels[$key] : (isset($show_labels[$key]) && !empty($show_labels[$key]) ? ' ' . ucfirst( __( $key, 'social-board' ) ) : '') )
                                . ( isset($meta['total']['url']) ? '</a>' : '') . '
                                </span>';
                        }
                    }
                    if ( ! empty($meta['data']) && empty($this->attr['carousel']) ) {
                        if ($mc == 1) {
                            $inner .= '</span>';
                            $mc = 0;
                        }
                        if ( $key == 'comments' && isset($this->output['comments']) && !empty($this->output['comments']) ) {
                            if ($meta['data'] == 'fetch') {
                                $inner .= '
                                <div class="sb-fetchcomments" data-nonce="'.wp_create_nonce( 'fetchcomments' ).'" data-id="'.$param['id'].'" data-link="'.$param['url'].'" data-feed="'.$feed_class.'-'.$i.'-'.$ifeed.'">
                                    <a href="javascript:void(0)" class="sb-triggercomments">'. __( 'Show Comments', 'social-board' ) .'</a>
                                </div>';
                            } else {
                                $inner .= '
                                <div class="sb-fetchcomments">
                                    '.$meta['data'].'
                                </div>';
                            }
                        } elseif ( $key == 'likes' && isset($this->output['likes']) && !empty($this->output['likes']) ) {
                            $inner .= '
                            <span class="sb-meta item-likes">
                                ' . $meta['data'] . '
                            </span>';
                        } else {
                            $inner .= $meta['data'];
                        }
                    }
                }
                if ($mc == 1) {
                    $inner .= '</span>';
                    $mc = 0;
                }
            }
            $inner .= '
            </span>';
        }
        // END: comments/likes block
        
        $us = '';
        if ( isset($param['url']) && !empty($param['url']) && isset($this->output['share']) && !empty($this->output['share']) ) {
            if (isset($param['share']) && !empty($param['share']))
                $us .= $param['share'];
            else {
                $sharetitle = urlencode( strip_tags($param['title'] ?? '') );
                $sharemedia = urlencode( $param['thumb'] ?? '' );
                $us .= '
                <span class="sb-share">
                    <a class="sb-facebook sb-hover" href="https://www.facebook.com/sharer.php?u=' . urlencode($param['url']) . '&amp;t=' . ($sharetitle ?? '') . '"'.$this->target.'>
                        <i class="sb-sicon sb-facebook"></i>
                    </a>
                    <a class="sb-twitter sb-hover" href="https://twitter.com/share?url=' . urlencode($param['url']) . '&amp;text=' . ($sharetitle ?? '') . '"'.$this->target.'>
                        <i class="sb-sicon sb-twitter"></i>
                    </a>
                    <a class="sb-pinterest sb-hover" href="//pinterest.com/pin/create/link/?url=' . urlencode($param['url']) . '&amp;description=' . ($sharetitle ?? '') . '&amp;media=' . ($sharemedia ?? '') . '"'.$this->target.'>
                        <i class="sb-sicon sb-pinterest"></i>
                    </a>
                    <a class="sb-linkedin sb-hover" href="https://www.linkedin.com/shareArticle?mini=true&amp;url=' . urlencode($param['url']) . '&amp;title=' . ($sharetitle ?? '') . '"'.$this->target.'>
                        <i class="sb-sicon sb-linkedin"></i>
                    </a>
                </span>';
            }
        }
        
        $inner .= '</div>';
		if ( $param['date'] && isset($this->output['info']) && !empty($this->output['info']) ) {
        $inner .= '
            <div class="sb-slide-footer">
				<div class="sb-slide-foot">
                ' . $us . '
                <a href="' . ($param['url'] ?? '') . '"'.$this->target.'>'. (isset($show_labels['posted']) && !empty($show_labels['posted']) ? __( 'Posted', 'social-board' ) . ': ' : '') . axs_friendly_date($param['date'], $this->attr['dateformat']) . '</a>
				</div>
            </div>';
		}
        $inner .= '
            </div>
        </div>';
        
        $tag = 'div';
        $out1 = '
        <div class="sboard sb-slide sb-modern" id="inline_'.$sbi.'">
            <'.$tag.' class="sb-item sb-' . $feed_class . '" '.$item_data_link.$item_data_is_lightbox.'>
                ' . $inner;
            $out1 .= '
            </'.$tag.'>
        </div>' . "\n";
        $out = $out1;
        
        return $out;
    }

	function axs_add_scripts_callback( $args ) {
		
	}
}
