<?php

/**
 * AX Social Stream
 * Copyright © 2014 Axent Media LLC, All Rights Reserved.
 * https://axentmedia.com/support/
 */

class AXS_Modern_Layout extends AXS_Default_Layout {
	function __construct() {
        add_filter( 'axs_supported_layouts_modern', function() {
			return ['wall', 'timeline', 'feed', 'carousel'];
        });
        // If using the same theme for different streams on the same page
        if ( ! has_filter( 'axs_inline_styles_modern' )  ) {
            add_filter( 'axs_inline_styles_modern', array( $this, 'axs_inline_styles_callback'), 10, 1 );
            add_filter( 'axs_create_item_modern', array( $this, 'axs_create_item_callback'), 10, 6 );
            add_filter( 'axs_create_ad_modern', array( $this, 'axs_create_ad_callback'), 10, 4 );
        }
    }

    function axs_create_item_callback( $feed_class, $param, $attr = array(), $sbi = 0, $i = 0, $ifeed = 0 ) {
        $filtername = ' '.$feed_class.'-'.$i.'-'.$ifeed;
        $iconSocial = ( isset($param['icon'][0]) && ! empty($param['icon'][0]) ) ? '<img src="'.$param['icon'][0].'" class="sb-img origin-flag" style="vertical-align:middle" alt="icon">' : '<span class="origin-flag sb-' . $feed_class . '"><i class="sb-icon sb-' . $feed_class . '"></i></span>';
        $playstate = (isset($param['play']) && ! empty($param['play'])) ? '<div class="sb-playstate"></div>' : '';
        $user_title = (isset($param['user']['title']) && ! empty($param['user']['title'])) ? $param['user']['title'] : ($param['user']['name'] ?? '');
        $imglayout = (isset($attr['layout_image']) && ! empty($attr['layout_image'])) ? ' sb-'.$attr['layout_image'] : '';
        $datasize = (isset($param['size']) && ! empty($param['size'])) ? ' data-size="' . $param['size'] . '"' : '';
        $imgAlt = $this->axs_create_alt($feed_class, $param);

        $show_labels = $this->show_labels();
		
		$item_data_link = isset($param['url']) ? 'data-link="'.$param['url'].'"' : '';
		$item_data_is_lightbox = (isset($param['iframe']) && !empty($param['iframe']) && in_array($param['iframe'],['icbox','iframe'])) ? ' data-lightbox="true"' : ' data-lightbox="false"';
		
        $noclass = array();
        if ( empty($this->output['info']))
            $noclass[] = ' sb-nofooter';
        if ( empty($param['thumb']) || empty($this->output['thumb']))
            $noclass[] = ' sb-nothumb';
        if ( count($noclass) > 1 ) {
            $noclass = array();
            $noclass[] = ' sb-noft';
        }

        $no_inner = ( array_sum((array) $this->output) == 1 AND !empty($this->output['thumb']) AND empty($attr['carousel']) ) ? true : false;
        if ($no_inner) {
            $noclass[] = ' sb-noinner';
		}

        $no_meta = ( ! empty($param['meta']) && (!empty($this->output['comments']) || !empty($this->output['likes'])) ) ? false : true;
        if ($no_meta) {
            $noclass[] = ' sb-nometa';
		}

        $inner = '<div class="sb-container'.$imglayout.( implode('', $noclass) ).'">';
		if ( ! empty($this->output['info']) ) {
			$inner .= $iconSocial;
		}
        
		$thumb_media_class = '';
		if ( isset($this->themedefoption['hover_effect']) && $hover_effect = $this->themedefoption['hover_effect']) {
			$thumb_media_class .= " sb-$hover_effect";
		}
		if ($child_medias = $this->axs_create_child_items($param,$sbi)) {
			$inner .= $child_medias;
			$thumb_media_class .= " sb-child-media-true";
		}
		
        $thumb = $sbthumb = '';
        if (isset($attr['carousel']) && ! empty($attr['carousel'])) {
			$cropclass = 'sb-crop';
			if (isset($param['iframe']) && ! empty($param['iframe']))
				$cropclass .= ' '.$param['iframe'];
			if (isset($param['thumb']) && ! empty($param['thumb']) && isset($this->output['thumb']) && ! empty($this->output['thumb'])) {
				$aurl = $param['thumburl'] ?? ($param['url'] ?? '');
				if (isset($param['object']) && ! empty($param['object']) && isset($attr['lightboxtype']) && $attr['lightboxtype'] == 'media') {
					$aurl32 = sprintf("%u", crc32($aurl) );
					$aurl = "#$aurl32";
					$thumb .= '
					<div style="display: none">
						<div class="sb-object" id="'.$aurl32.'">
							' . $param['object'] . '
						</div>
					</div>';
				}
                $sbimg = (isset($attr['lazyload']) && ! empty($attr['lazyload'])) ? 'data-lazy="' . htmlspecialchars($param['thumb']) . '"' : 'src="' . htmlspecialchars($param['thumb']) . '"';
				$thumb .= '<a class="'.$cropclass.'" href="' . $aurl . '"'.$datasize.$this->target.'><img class="sb-img" '.$sbimg.' alt="'.$imgAlt.'">'.$playstate.'</a>';
			} else {
                $cropclass .= ' sb-userimg';
                if (isset($param['user']['image']) && ! empty($param['user']['image']) && empty($this->output['thumb'])) {
					$thumb = '<div class="'.$cropclass.'"><img class="sb-img" src="' . $param['user']['image'] . '" alt="'.$user_title.'"><br /><span>'.$user_title.'</span></div>';
				}
			}
			if (isset($thumb) && ! empty($thumb))
			$sbthumb .= '
			<div class="sb-thumb'.($thumb_media_class ?? '').'">
				' . $thumb . '
			</div>';
        } else {
            if (isset($param['thumb']) && ! empty($param['thumb']) && isset($this->output['thumb']) && ! empty($this->output['thumb'])) {
				$aurl = ( isset( $param['thumburl'] ) && !empty( $param['thumburl'] ) ) ? htmlspecialchars( $param['thumburl'] ) : htmlspecialchars( $param['url'] );
				
				if (isset($param['object']) && ! empty($param['object']) && isset($attr['lightboxtype']) && $attr['lightboxtype'] == 'media') {
					$aurl32 = sprintf("%u", crc32($aurl) );
					$aurl = "#$aurl32";
					$sbthumb .= '
					<div style="display: none">
						<span class="sb-object" id="'.$aurl32.'">
							' . $param['object'] . '
						</span>
					</div>';
				}
                $sbimg = (isset($attr['lazyload']) && ! empty($attr['lazyload'])) ? 'data-original="' . htmlspecialchars($param['thumb']) . '" src="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAwIiBoZWlnaHQ9IjIwMCIgdmlld0JveD0iLTQzIC00MyAxMjQgMTI0IiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHN0cm9rZT0iI2ZmZiI+ICAgIDxnIGZpbGw9Im5vbmUiIGZpbGwtcnVsZT0iZXZlbm9kZCI+ICAgICAgICA8ZyB0cmFuc2Zvcm09InRyYW5zbGF0ZSgxIDEpIiBzdHJva2Utd2lkdGg9IjIiPiAgICAgICAgICAgIDxjaXJjbGUgc3Ryb2tlLW9wYWNpdHk9Ii41IiBjeD0iMTgiIGN5PSIxOCIgcj0iMTgiLz4gICAgICAgICAgICA8cGF0aCBkPSJNMzYgMThjMC05Ljk0LTguMDYtMTgtMTgtMTgiPiAgICAgICAgICAgICAgICA8YW5pbWF0ZVRyYW5zZm9ybSAgICAgICAgICAgICAgICAgICAgYXR0cmlidXRlTmFtZT0idHJhbnNmb3JtIiAgICAgICAgICAgICAgICAgICAgdHlwZT0icm90YXRlIiAgICAgICAgICAgICAgICAgICAgZnJvbT0iMCAxOCAxOCIgICAgICAgICAgICAgICAgICAgIHRvPSIzNjAgMTggMTgiICAgICAgICAgICAgICAgICAgICBkdXI9IjFzIiAgICAgICAgICAgICAgICAgICAgcmVwZWF0Q291bnQ9ImluZGVmaW5pdGUiLz4gICAgICAgICAgICA8L3BhdGg+ICAgICAgICA8L2c+ICAgIDwvZz48L3N2Zz4="' : 'src="' . htmlspecialchars($param['thumb']) . '"';
                $sbthumb .= '
                <div class="sb-thumb'.($thumb_media_class ?? '').'">
                    <a href="' . $aurl . '" class="'.($param['iframe'] ?? '').'"'.$datasize.$this->target.'><img class="sb-img" '.$sbimg.' alt="'.$imgAlt.'">'.$playstate.'</a>
                </div>';
            } else {
                if (isset($attr['carousel']) && ! empty($attr['carousel']) && isset($param['user']['image']) && ! empty($param['user']['image']) && isset($attr['userinfo']) && $attr['userinfo'] == 'bottom') {
                    $cropclass = 'sb-crop sb-userimg';
                    $thumb = '<div class="'.$cropclass.'"><img class="sb-img" src="' . $param['user']['image'] . '" alt="'.$user_title.'"><br /><span>'.$user_title.'</span></div>';
                    $sbthumb .= '
                    <div class="sb-thumb'.($thumb_media_class ?? '').'">
                        ' . $thumb . '
                    </div>';
                }
            }
        }
        
        if (isset($sbthumb) && ! empty($sbthumb) && isset($attr['layout_image']) && $attr['layout_image'] == 'imgexpand') {
            $inner .= $sbthumb;
            $userclass = ' sb-usermini';
        }
        
        $idstr = ' id="'.$sbi.'"';
        if (isset($attr['lightboxtype']) && $attr['lightboxtype'] == 'slideshow') {
            $inline = ' data-href="#inline_'.$sbi.'"';
            $sbinline = ' sb-inline';
        } else {
            $inline = $sbinline = '';
        }
        
        if ( ! $no_inner)
            $inner .= '
            <div class="sb-inner">';
            
        if (isset($param['user']) && ! empty($param['user']) && isset($attr['userinfo']) && $attr['userinfo'] == 'top') {
            if (isset($param['user']['title']) && ! empty($param['user']['title']) && isset($param['user']['name']) && ! empty($param['user']['name'])) {
                $user_title = $param['user']['title'];
                $user_text = ( isset($param['user']['url']) && ! empty($param['user']['url']) ) ? '<a href="' . $param['user']['url'] . '"'.$this->target.'>' . $param['user']['name'] . '</a>' : $param['user']['name'];
            } else {
                $user_title = $param['user']['name'] ?? '';
                if (isset($param['user']['status']) && ! empty($param['user']['status']))
                    $user_text = ( isset($param['url']) && ! empty($param['url']) ) ? '<a href="' . $param['url'] . '"'.$this->target.'>' . $param['user']['status'] . '</a>' : $param['user']['status'];
                else
                    $user_title_style = ' style="padding-top: 5px"';
            }

            $user_inner = '';
            if (isset($param['user']['image']) && ! empty($param['user']['image'])) {
                $user_image = ( isset($param['user']['url']) && ! empty($param['user']['url']) ) ? '<a href="' . $param['user']['url'] . '"'.$this->target.'><img class="sb-img" alt="' . $param['user']['name'] . '" src="' . $param['user']['image'] . '"></a>' : '<img class="sb-img" alt="' . $param['user']['name'] . '" src="' . $param['user']['image'] . '">';
                $user_inner .= '
                <div class="sb-uthumb">'.$user_image.'</div>';
            } else {
                $no_thumb_class = ' sb-nouthumb';
            }

            if ($user_title || !empty($user_text)) {
                $user_title_linked = ( isset($param['user']['url']) && ! empty($param['user']['url']) ) ? '<a href="' . $param['user']['url'] . '"'.$this->target.'>'.$user_title.'</a>' : $user_title;
                $user_inner .= '
                    <div class="sb-uinfo'.($no_thumb_class ?? '').'">';
                if ($user_title)
                    $user_inner .= '<div class="sb-utitle"'.($user_title_style ?? '').'>' . $user_title_linked . '</div>';
                if (isset($user_text) && ! empty($user_text) && $user_title)
                    $user_inner .= '<div class="sb-uname">' . $user_text . '</div>';
                $user_inner .= '
                    </div>';
            }

            if ( !empty($this->output['user']) && ( $user_title || !empty($user_image) ) ) {
                $inner .= '
                <div class="sb-user'.($userclass ?? '').'">';
                $inner .= $user_inner;
                $inner .= '
                </div>';
            }
        }
        
        if ( !empty($param['title']) && !empty($this->output['title']) && empty($attr['carousel']) ) {
            $inner .= '
            <span class="sb-title">
                ' . $param['title'] . '
            </span>';
        }

        if (isset($sbthumb) && ! empty($sbthumb) && isset($attr['layout_image']) && $attr['layout_image'] == 'imgnormal') {
            $inner .= $sbthumb;
        }
        
        if ( ( !empty($param['text']) && !empty($this->output['text']) ) || !empty($attr['carousel']) ) {
            $expandclass = (empty($thumb)) ? ' sb-expand' : '';

            if ( !empty($param['title']) && !empty($this->output['title']) && !empty($attr['carousel'])) {
                $inner_title = '
                <span class="sb-title">
                    ' . $param['title'] . '
                </span>';
            } else {
                $expandclass .= ' sb-notitle';
            }
            
			if ( !empty($this->output['text']) || !empty($this->output['title']) ) {
				$inner .= '<span class="sb-text'.$expandclass.'">';
				if ( !empty($this->output['title']) )
					$inner .= ($inner_title ?? '');
				if ( !empty($this->output['text']) )
					$inner .= $param['text'] ?? '';
				$inner .= '</span>';
			}
        }
        
        if (empty($attr['carousel'])) {
            if ( !empty($param['tags']) && !empty($this->output['tags']) ) {
                $inner .= '
                <span class="sb-text">
                    ' . (isset($show_labels['tags']) && ! empty($show_labels['tags']) ? '<strong>'.__( 'Tags', 'social-board' ).': </strong>' : '') . $param['tags'] . '
                </span>';
            }
        }

        // comments/likes block
        if ( ! $no_meta ) {
            $ticons = ['likes' => 'star', 'comments' => 'comments', 'retweets' => 'retweet'];
            $tlabels = ['secs' => 'secs', 'mins' => 'mins'];
            $mc = 0;
            $inner .= '
            <span class="sb-metadata">';
            if ( ! empty($param['meta']) && (!empty($this->output['comments']) || !empty($this->output['likes'])) ) {
                foreach ($param['meta'] as $key => $meta) {
                    if ( ! empty($meta['total']) ) {
                        if ($mc == 0 ) {
                            $inner .= '<span class="sb-meta">';
                            $mc = 1;
                        }
                        if ( intval($meta['total']['count']) > 0 ) {
                            $inner .= '
                                <span class="'.$key.'">'
                                . ( isset($meta['total']['url']) ? '<a href="' . $meta['total']['url'] . '"'.$this->target.'>' : '') . '
                                    <i class="sb-bico sb-'.(!empty($meta['total']['class']) ? $meta['total']['class'] : $ticons[$key]).'"></i> ' . countFormatter($meta['total']['count']) . (!empty($tlabels[$key]) ? ' ' . $tlabels[$key] : (!empty($show_labels[$key]) ? ' ' . ucfirst( __( $key, 'social-board' ) ) : '') )
                                . ( isset($meta['total']['url']) ? '</a>' : '') . '
                                </span>';
                        }
                    }
                    if ( ! empty($meta['data']) && empty($attr['carousel']) ) {
                        if ($mc == 1) {
                            $inner .= '</span>';
                            $mc = 0;
                        }
                        if ( $key == 'comments' && isset($this->output['comments']) && ! empty($this->output['comments']) ) {
                            if ($meta['data'] == 'fetch') {
                                $inner .= '
                                <div class="sb-fetchcomments" data-nonce="'.wp_create_nonce( 'fetchcomments' ).'" data-id="'.$param['id'].'" data-link="'.$param['url'].'" data-feed="'.$feed_class.'-'.$i.'-'.$ifeed.'">
                                    <a href="javascript:void(0)" class="sb-triggercomments">'. __( 'Show Comments', 'social-board' ) .'</a>
                                </div>';
                            } else {
                                $inner .= '
                                <div class="sb-fetchcomments">
                                    '.$meta['data'].'
                                </div>';
                            }
                        } elseif ( $key == 'likes' && isset($this->output['likes']) && ! empty($this->output['likes']) ) {
                            $inner .= '
                            <span class="sb-meta item-likes">
                                ' . $meta['data'] . '
                            </span>';
                        } else {
                            $inner .= $meta['data'];
                        }
                    }
                }
                if ($mc == 1) {
                    $inner .= '</span>';
                    $mc = 0;
                }
            }
            $inner .= '
            </span>';
        }
        // END: comments/likes block
        
        $us = '';
        if ( isset($param['user']) && ! empty($param['user']) && isset($this->output['user']) && ! empty($this->output['user']) && isset($attr['userinfo']) && $attr['userinfo'] == 'bottom' && isset($param['user']['name']) && ! empty($param['user']['name']) ) {
            $user_text = ( isset($param['user']['url']) && ! empty($param['user']['url']) ) ? '<a href="' . $param['user']['url'] . '"'.$this->target.'>' . $param['user']['name'] . '</a>' : $param['user']['name'];
            $us .= '
            <span class="sb-user-foot">
                <i class="sb-bico sb-user-foot"></i> ' . $user_text . '
            </span>';
        }
        if ( isset($param['url']) && ! empty($param['url']) && isset($this->output['share']) && ! empty($this->output['share']) ) {
            if (isset($param['share']) && ! empty($param['share']))
                $us .= $param['share'];
            else {
                $sharetitle = urlencode( strip_tags($param['title'] ?? '') );
                $sharemedia = urlencode( $param['thumb'] ?? '' );
                $us .= '
                <span class="sb-share">
                    <a class="sb-facebook sb-hover" href="https://www.facebook.com/sharer.php?u=' . urlencode($param['url']) . '&amp;t=' . ($sharetitle ?? '') . '"'.$this->target.'>
                        <i class="sb-sicon sb-facebook"></i>
                    </a>
                    <a class="sb-twitter sb-hover" href="https://twitter.com/intent/tweet?url=' . urlencode($param['url']) . '&amp;text=' . ($sharetitle ?? '') . '"'.$this->target.'>
                        <i class="sb-sicon sb-twitter"></i>
                    </a>
                    <a class="sb-pinterest sb-hover" href="//pinterest.com/pin/create/link/?url=' . urlencode($param['url']) . '&amp;description=' . ($sharetitle ?? '') . '&amp;media=' . ($sharemedia ?? '') . '"'.$this->target.'>
                        <i class="sb-sicon sb-pinterest"></i>
                    </a>
                    <a class="sb-linkedin sb-hover" href="https://www.linkedin.com/shareArticle?mini=true&amp;url=' . urlencode($param['url']) . '&amp;title=' . ($sharetitle ?? '') . '"'.$this->target.'>
                        <i class="sb-sicon sb-linkedin"></i>
                    </a>
                </span>';
            }
        }
        if (isset($us) && ! empty($us))
            $inner .= '
            <div class="sb-info">
                ' . $us . '
            </div>';

        if ( ! $no_inner)
            $inner .= '
            </div>';
        
        if ( $attr['type'] == 'timeline' ) {
            $icon = ( isset($param['icon'][1]) && ! empty($param['icon'][1]) ) ? '<img class="sb-img" src="'.$param['icon'][1].'" style="vertical-align:middle" alt="">' : '<i class="sb-bico sb-wico sb-' . $param['type'] . '"></i>';
            $out = '
            <div class="timeline-row"'.$idstr.'>
                <div class="timeline-time">
                    <small>'. axs_i18n_date( $param['date'], get_option( 'date_format' ) ) .'</small>'. axs_i18n_date( $param['date'], get_option( 'time_format' ) ) .'
                </div>
                <div class="timeline-icon">
                    <div class="bg-' . $feed_class . '">
                        ' . $icon . '
                    </div>
                </div>
                    <div class="timeline-content">
                        <div class="panel-body sb-item sb-' . $feed_class . $filtername . $sbinline.'"'.$inline.' '.$item_data_link.$item_data_is_lightbox.'>
                        ' . $inner . '
                        </div>
                    </div>
                </div>
            </div>' . "\n";
        } else {
            $iconType = ( isset($param['icon'][1]) && ! empty($param['icon'][1]) ) ? '<img class="sb-img" src="'.$param['icon'][1].'" style="vertical-align:middle" alt="icon">' : '<i class="sb-bico sb-' . $param['type'] . '" title="' . ucfirst($param['type']) . '"></i>';
            $tag = ( $attr['type'] != 'feed' || !empty($attr['carousel']) ) ? 'div' : 'li';
            $out1 = '
            <'.$tag.' class="sb-item sb-' . $feed_class . $filtername . $sbinline.'"'.$idstr.$inline.' '.$item_data_link.$item_data_is_lightbox.'>
                ' . $inner;
            if ($param['date'] && isset($this->output['info']) && ! empty($this->output['info']))
            $out1 .= '
                <div class="sb-foot">
                    <div class="sb-footer">
                        ' . $iconType . '
                        <a href="' . ($param['url'] ?? '') . '"'.$this->target.'>'. (!empty($show_labels['posted']) ? __( 'Posted', 'social-board' ) . ': ' : '') . axs_friendly_date($param['date'], $this->attr['dateformat']) . '</a>
                    </div>
                </div>';
            $out1 .= '
            </div>
            </'.$tag.'>' . "\n";
            
            $out = (isset($attr['carousel']) && ! empty($attr['carousel'])) ? '<li>'.$out1.'</li>' : $out1;
        }
        return $out;
    }

    function axs_create_colors( $dotboard ) {
        $social_colors = $this->themedefoption['social_colors'];
		$style = array();
        foreach ($social_colors as $colorKey => $colorVal) {
            if ( is_array($this->feed_keys[$colorKey]) ) {
                $feedname = key($this->feed_keys[$colorKey]);
                if (isset($colorVal) && ! empty($colorVal) && $colorVal != 'transparent') {
                    // set colors for networks
                    $rgbColorVal = axs_hex2rgb($colorVal);
                    $style[$dotboard.' .origin-flag.sb-'.$feedname][] = 'background-color: rgba('.$rgbColorVal.', 0.8) !important';
                    $style[$dotboard.' .origin-flag.sb-'.$feedname.':after'][] = 'border-left: 8px solid rgba('.$rgbColorVal.', 1) !important';
                    
                    if (isset($this->attr['lightboxtype']) && $this->attr['lightboxtype'] == 'slideshow')
                        $style['.sb-slide-icon.sb-'.$feedname][] = 'background-color: '.$colorVal.' !important';
                    
                    if ( $this->type == 'timeline' )
                        $style[$dotboard.' .bg-'.$feedname][] = 'background-color: rgba('.$rgbColorVal.', 0.8) !important';

                    $dotfilter = ( $this->type == 'wall' ) ? str_replace(array('timeline', '.sboard'), array('sb', ''), $dotboard) : $dotboard;
                    if (empty($this->attr['carousel']))
                        $style[$dotfilter.' .sb-'.$feedname.'.sb-hover:hover, '.$dotfilter.' .sb-'.$feedname.'.active'][] = 'background-color: '.$colorVal.' !important;border-color: '.$colorVal.' !important;color: #fff !important';
                    
                    // set colors for tabs
                    if (isset($this->attr['tabable']) && ! empty($this->attr['tabable'])) {
                        if (isset($this->attr['position']) && $this->attr['position'] == 'normal')
                            $style["$dotboard.tabable .sb-tabs .sticky .".$feedname.":hover, $dotboard.tabable .sb-tabs .sticky .".$feedname.".active"][] = 'border-bottom-color: '.$colorVal;
                        else
                            $style["$dotboard.tabable .sb-tabs .sticky .".$feedname.":hover, $dotboard.tabable .sb-tabs .sticky .".$feedname.".active"][] = 'background-color: '.$colorVal;
                    }
                }
            }
        }
        
        // set item background color
        if ( isset($this->themetypeoption['item_background_color']) && ! empty($this->themetypeoption['item_background_color']) ) {
            if ( $this->themetypeoption['item_background_color'] != 'transparent') {
                $css_bg_color = ($this->type != 'timeline') ? "$dotboard .sb-item .sb-container .sb-inner, $dotboard .sb-item .sb-foot" : "$dotboard .sb-item .sb-container";
				$style[$css_bg_color][] = 'background-color: '.$this->themetypeoption['item_background_color'];
				if ($this->type == 'timeline') {
					$style["$dotboard .sb-item .sb-container .sb-inner"][] = 'background-color: transparent';
				}
            }
        }
        
        // set item border
        if ( isset($this->themetypeoption['item_border_size']) && $border_size = $this->themetypeoption['item_border_size'] ) {
            if ( $border_size > 1 ) {
                $border_radius = 5+$border_size-1;
                $style["$dotboard .sb-item .sb-container"][] = 'border-radius: '.$border_radius.'px;-moz-border-radius: '.$border_radius.'px;-webkit-border-radius: '.$border_radius.'px';
                $style["$dotboard.sb-modern .origin-flag"][] = 'margin-right: -8px';
            }
        }
        if ( isset($this->themetypeoption['item_border_color']) && ! empty($this->themetypeoption['item_border_color']) ) {
            if ( $this->themetypeoption['item_border_color'] != 'transparent') {
                $dontbordersize = true;
                $style["$dotboard .sb-item .sb-container"][] = 'border: '.($this->themetypeoption['item_border_size'] ?? '').'px solid '.$this->themetypeoption['item_border_color'];
            }
        }
        if ( isset($this->themetypeoption['item_border_size']) && ! empty($this->themetypeoption['item_border_size']) && empty($dontbordersize) ) {
            $style["$dotboard .sb-item .sb-container"][] = 'border-width: '.$this->themetypeoption['item_border_size'].'px';
        }
        
        // set footer color
        if ( isset($this->themetypeoption['font_color']) && ! empty($this->themetypeoption['font_color']) && $this->themetypeoption['font_color'] != 'transparent') {
            $font_rgbColorVal = axs_hex2rgb($this->themetypeoption['font_color']);
            $style[$dotboard.'.sb-modern .sb-item .sb-footer a'][] = 'color: rgba('.$font_rgbColorVal.', 0.8) !important';
        }
        
        return $style;
    }
}
