<?php
namespace BooklyPackages\Backend\Components\Dialogs\Appointment\AttachPackage;

use Bookly\Lib as BooklyLib;
use BooklyPackages\Lib;

class Ajax extends BooklyLib\Base\Ajax
{
    /**
     * @inheritDoc
     */
    protected static function permissions()
    {
        return array( '_default' => 'supervisor' );
    }

    /**
     * Get customer packages.
     */
    public static function getCustomerPackages()
    {
        $service = self::parameter( 'service' );
        $staff = self::parameter( 'staff' );
        $location = self::parameter( 'location' );
        $customer = self::parameter( 'customer' );

        $response = array( 'success' => true, 'customer_packages' => array(), 'package_services' => array() );

        if ( $service && $staff && $customer ) {
            // Customer packages

            $busy_statuses = BooklyLib\Proxy\CustomStatuses::prepareBusyStatuses( array(
                BooklyLib\Entities\CustomerAppointment::STATUS_DONE,
                BooklyLib\Entities\CustomerAppointment::STATUS_PENDING,
                BooklyLib\Entities\CustomerAppointment::STATUS_APPROVED,
            ) );
            $query = Lib\Entities\Package::query( 'p' )
                ->select( 'p.id, CONCAT(s.title, " (", COUNT(DISTINCT(ca.id)), "/", s.package_size, ")") AS title' )
                ->leftJoin( 'SubService', 'ss', 'ss.service_id = p.service_id', '\Bookly\Lib\Entities' )
                ->leftJoin( 'Service', 's', 's.id = p.service_id', '\Bookly\Lib\Entities' )
                ->leftJoin( 'CustomerAppointment', 'ca', 'ca.package_id = p.id', '\Bookly\Lib\Entities' )
                ->where( 'ss.sub_service_id', $service )
                ->whereRaw( '(p.staff_id = "%s" OR p.staff_id IS NULL)', array( $staff ) )
                ->where( 'p.customer_id', $customer )
                ->whereRaw( sprintf( 'ca.status IS NULL OR ca.status IN ("%s")', implode( ', ', array_fill( 0, count( $busy_statuses ), '%s' ) ) ), $busy_statuses )
                ->groupBy( 'p.id' );
            if ( $location ) {
                $query->where( 'location_id', $location );
            }
            $response['customer_packages'] = $query->fetchArray();

            // Package services
            $query = BooklyLib\Entities\StaffService::query( 'sts' )
                ->select( 's.id, s.title AS title' )
                ->leftJoin( 'SubService', 'ss', 'ss.service_id = sts.service_id', '\Bookly\Lib\Entities' )
                ->leftJoin( 'Service', 's', 's.id = sts.service_id', '\Bookly\Lib\Entities' )
                ->where( 'ss.sub_service_id', $service )
                ->where( 'sts.staff_id', $staff );
            if ( $location ) {
                $query->whereRaw( '(sts.location_id = "%s" OR sts.location_id IS NULL)', array( $location ) );
            }
            $response['package_services'] = $query->fetchArray();
        }

        wp_send_json( $response );
    }
}