<?php
namespace BooklyPackages\Backend\Components\Dialogs\Appointment\AttachPackage;

use Bookly\Lib as BooklyLib;

class Dialog extends BooklyLib\Base\Component
{
    public static function render()
    {
        self::enqueueScripts( array(
            'module' => array( 'js/attach-package.js' => array( 'bookly-backend-globals' ), ),
        ) );

        wp_localize_script( 'bookly-attach-package.js', 'BooklyL10nAttachPackageDialog', array(
            'taxes_included' => get_option( 'bookly_taxes_in_price' ) == 'included',
            'package_for' => get_user_meta( get_current_user_id(), 'bookly_attach_package_for', true ) ?: 'current',
            'l10n' => array(
                'attach_package' => __( 'Attach package', 'bookly' ),
                'attach_to_package' => __( 'Attach to package', 'bookly' ),
                'create_package' => __( 'Create package', 'bookly' ),
                'select_package' => __( 'Select package', 'bookly' ),
                'no_packages' => __( 'No packages available', 'bookly' ),
                'apply' => __( 'Apply', 'bookly' ),
                'cancel' => __( 'Cancel', 'bookly' ),
            )
        ) );
    }
}