<?php
namespace BooklyPackages\Backend\Components\Dialogs\Service\Edit\ProxyProviders;

use Bookly\Lib as BooklyLib;
use Bookly\Backend\Components\Dialogs\Service\Edit\Proxy;

class Shared extends Proxy\Shared
{
    /**
     * @inheritDoc
     */
    public static function enqueueAssetsForServices()
    {
        self::enqueueScripts( array(
            'module' => array( 'js/packages.js' => array( 'jquery' ), ),
        ) );
    }

    /**
     * @inheritDoc
     */
    public static function prepareUpdateService( array $data )
    {
        if ( $data['type'] == BooklyLib\Entities\Service::TYPE_PACKAGE ) {
            if ( array_key_exists( 'sub_services', $data ) && is_array( $data['sub_services'] ) && count( $data['sub_services'] ) == 1 && $data['sub_services'][0] > 0 ) {
                // Update SubService.
                $rows = BooklyLib\Entities\SubService::query()->where( 'service_id', $data['id'] )->fetchArray();
                if ( count( $rows ) != 1 ) {
                    BooklyLib\Entities\SubService::query()->delete()->where( 'service_id', $data['id'] )->execute();
                    $sub_service = new BooklyLib\Entities\SubService();
                    $sub_service
                        ->setServiceId( $data['id'] )
                        ->setSubServiceId( $data['sub_services'][0] )
                        ->setPosition( 0 )
                        ->save();
                } else {
                    if ( $rows[0]['sub_service_id'] != $data['sub_services'][0] ) {
                        $sub_service = new BooklyLib\Entities\SubService( $rows[0] );
                        $sub_service
                            ->setSubServiceId( $data['sub_services'][0] )
                            ->save();
                    }
                }
                // Copy needful information from SubService.
                $sub_service_entity    = BooklyLib\Entities\Service::find( $data['sub_services'][0] );
                $data['category_id']   = $sub_service_entity->getCategoryId();
                $data['duration']      = $sub_service_entity->getDuration();
                $data['capacity_min']  = $sub_service_entity->getCapacityMin();
                $data['capacity_max']  = $sub_service_entity->getCapacityMax();
                $data['padding_left']  = $sub_service_entity->getPaddingLeft();
                $data['padding_right'] = $sub_service_entity->getPaddingRight();
            }
        } elseif ( $data['type'] == BooklyLib\Entities\Service::TYPE_SIMPLE ) {
            $rows = BooklyLib\Entities\Service::query( 's' )
                ->innerJoin( 'SubService', 'ss', 'ss.service_id = s.id' )
                ->where( 's.type', BooklyLib\Entities\Service::TYPE_PACKAGE )
                ->where( 'ss.sub_service_id', $data['id'] )
                ->fetchArray();
            foreach ( $rows as $row ) {
                $service = new BooklyLib\Entities\Service( $row );
                $service
                    ->setCategoryId( $data['category_id'] )
                    ->setDuration( $data['duration'] )
                    ->setCapacityMin( $data['capacity_min'] )
                    ->setCapacityMax( $data['capacity_max'] )
                    ->setPaddingLeft( $data['padding_left'] )
                    ->setPaddingRight( $data['padding_right'] )
                    ->save();
            }
        }

        return $data;
    }

    /**
     * @inheritDoc
     */
    public static function updateService( array $alert, BooklyLib\Entities\Service $service, array $parameters )
    {
        $staff_ids = isset( $parameters['staff_ids'] ) ? $parameters['staff_ids'] : array();
        $update_staff = isset( $parameters['update_staff'] ) && $parameters['update_staff'];
        // Update package records when simple service has been updated.
        if ( $service->getType() === BooklyLib\Entities\Service::TYPE_SIMPLE ) {
            $packages_ids = BooklyLib\Entities\SubService::query()
                ->where( 'sub_service_id', $service->getId() )
                ->fetchCol( 'service_id' );
            // Delete staff-services for all packages related to simple service.
            BooklyLib\Entities\StaffService::query()
                ->delete()
                ->whereIn( 'service_id', $packages_ids )
                ->whereNotIn( 'staff_id', $staff_ids )
                ->execute();
            if ( $update_staff ) {
                // Update capacity for all packages related to simple service.
                BooklyLib\Entities\StaffService::query()
                    ->update()
                    ->set( 'capacity_min', $parameters['capacity_min'] )
                    ->set( 'capacity_max', $parameters['capacity_max'] )
                    ->whereIn( 'service_id', $packages_ids )
                    ->execute();
            }
        }

        // Update package staff services.
        // Update simple service when related package service has been updated.
        if ( $service->getType() === BooklyLib\Entities\Service::TYPE_PACKAGE ) {
            // Update price & capacity for existing package's staff services.
            if ( $update_staff ) {
                BooklyLib\Entities\StaffService::query()
                    ->update()
                    ->set( 'price', $parameters['price'] )
                    ->where( 'service_id', $service->getId() )
                    ->execute();
            }
            $sub_service = current( $service->getSubServices() );
            if ( $sub_service ) {
                // Create staff services for package.
                $existing_staff_ids = BooklyLib\Entities\StaffService::query()
                    ->where( 'service_id', $service->getId() )
                    ->fetchCol( 'staff_id' );
                foreach ( $staff_ids as $staff_id ) {
                    $staff_sub_service = new BooklyLib\Entities\StaffService();
                    $staff_sub_service->loadBy( array( 'service_id' => $sub_service->getId(), 'staff_id' => $staff_id ) );
                    $staff_service = new BooklyLib\Entities\StaffService();
                    if ( in_array( $staff_id, $existing_staff_ids ) ) {
                        $staff_service->loadBy( array( 'staff_id' => $staff_id, 'service_id' => $service->getId() ) );
                    }
                    $staff_service
                        ->setStaffId( $staff_id )
                        ->setServiceId( $service->getId() )
                        ->setCapacityMin( $staff_sub_service->isLoaded() ? $staff_sub_service->getCapacityMin() : $sub_service->getCapacityMin() )
                        ->setCapacityMax( $staff_sub_service->isLoaded() ? $staff_sub_service->getCapacityMax() : $sub_service->getCapacityMax() );
                    if ( $update_staff || ! in_array( $staff_id, $existing_staff_ids ) ) {
                        $staff_service->setPrice( $parameters['price'] );
                    }
                    $staff_service->save();
                }
                // Create staff services for sub service.
                $new_staff_ids = BooklyLib\Entities\StaffService::query()
                    ->where( 'service_id', $sub_service->getId() )
                    ->fetchColDiff( 'staff_id', $staff_ids );
                foreach ( $new_staff_ids as $staff_id ) {
                    $staff_service = new BooklyLib\Entities\StaffService();
                    $staff_service->setStaffId( $staff_id )
                        ->setServiceId( $sub_service->getId() )
                        ->setPrice( $sub_service->getPrice() )
                        ->setCapacityMin( $sub_service->getCapacityMin() )
                        ->setCapacityMax( $sub_service->getCapacityMax() )
                        ->save();
                }
            } else {
                BooklyLib\Entities\StaffService::query()->delete()->where( 'service_id', $service->getId() )->execute();
            }
        }

        return $alert;
    }
}