<?php
namespace BooklyPackages\Backend\Modules\Services\ProxyProviders;

use Bookly\Lib as BooklyLib;
use Bookly\Backend\Modules\Services\Proxy;

class Shared extends Proxy\Shared
{
    /**
     * @inheritDoc
     */
    public static function prepareServiceIcons( $icons )
    {
        $icons[ BooklyLib\Entities\Service::TYPE_PACKAGE ] = 'far fa-calendar-alt';

        return $icons;
    }

    /**
     * @inheritDoc
     */
    public static function prepareServiceTypes( $types )
    {
        $types[ BooklyLib\Entities\Service::TYPE_PACKAGE ] = __( 'Package', 'bookly' );

        return $types;
    }

    /**
     * Delete records for packages if service has been deleted
     *
     * @param BooklyLib\Entities\Service $service
     */
    public static function serviceDeleted( $service )
    {
        if ( $service->getType() == BooklyLib\Entities\Service::TYPE_SIMPLE ) {
            $packages = BooklyLib\Entities\SubService::query( 'ss' )
                ->select( 's.id' )
                ->innerJoin( 'Service', 's', 'ss.service_id = s.id' )
                ->where( 'ss.sub_service_id', $service->getId() )
                ->where( 's.type', BooklyLib\Entities\Service::TYPE_PACKAGE )
                ->fetchArray();
            // Delete packages & staff-services related to service.
            BooklyLib\Entities\Service::query()
                ->delete()
                ->whereIn( 'id', array_map( function ( $packages ) { return $packages['id']; }, $packages ) )
                ->execute();
        }
    }
}