<?php defined( 'ABSPATH' ) || exit; // Exit if accessed directly
use Bookly\Backend\Components\Settings\Selects;
?>
<div class="card bookly-collapse-with-arrow">
    <div class="card-header d-flex align-items-center">
        <a href="#bookly_add-pkg" class="ml-2 bookly-collapsed" role="button" data-toggle="bookly-collapse" aria-expanded="false">
            <?php _e( 'Packages', 'bookly' ) ?>
        </a>
    </div>
    <div id="bookly_add-pkg" class="bookly-collapse">
        <div class="card-body pb-0">
            <?php
            Selects::renderSingle( 'bookly_packages_show_without_payments', __( 'Show packages without payments in a packages list', 'bookly' ), __( 'If enabled, packages without attached payments will be displayed for customers in a packages list', 'bookly' ) );
            Selects::renderSingle( 'bookly_packages_show_with_payments', __( 'Show packages with payments', 'bookly' ), __( 'If enabled, only packages with attached payments in "Completed" status will be displayed for customers in a packages list', 'bookly' ), array( array( 'completed', __( 'With completed payments only', 'bookly' ) ), array( 'any', __( 'Any', 'bookly' ) ) ) );
            ?>
        </div>
    </div>
</div>