<?php
namespace BooklyPackages\Frontend\Modules\CustomerPackages;

use Bookly\Lib as BooklyLib;

class ShortCode extends BooklyLib\Base\ShortCode
{
    public static $code = 'bookly-packages-list';

    /**
     * Link styles.
     */
    public static function linkStyles()
    {
        self::enqueueStyles( array(
            'bookly' => array( 'backend/resources/css/fontawesome-all.min.css' => array( 'bookly-backend-globals' ) ),
            'module' => array( 'css/customer-packages.css' => array( 'bookly-bootstrap.min.css' ) )
        ) );
    }

    /**
     * Link scripts.
     */
    public static function linkScripts()
    {
        self::enqueueScripts( array(
            'bookly' => array( 'backend/resources/js/range-tools.js' => array( 'bookly-backend-globals' ) ),
            'module' => array( 'js/customer-packages.js' => array( 'bookly-range-tools.js' ) ),
        ) );

        wp_localize_script( 'bookly-customer-packages.js', 'BooklyCustomerPackagesL10n', array(
            'zeroRecords' => __( 'No packages for selected period and criteria.', 'bookly' ),
            'scheduleAppointments' => __( 'Package schedule', 'bookly' ),
            'processing' => __( 'Processing', 'bookly' ) . '…',
            'emptyTable' => __( 'No data available in table', 'bookly' ),
            'loadingRecords' => __( 'Loading...', 'bookly' ),
            'useClientTimeZone' => BooklyLib\Config::useClientTimeZone(),
        ) );
    }

    /**
     * @return string
     */
    public static function render()
    {
        // Disable caching.
        BooklyLib\Utils\Common::noCache();

        $customer = new BooklyLib\Entities\Customer();
        $customer->loadBy( array( 'wp_user_id' => get_current_user_id() ) );
        if ( $customer->getId() ) {
            // Prepare URL for AJAX requests.
            $ajax_url = admin_url( 'admin-ajax.php' );

            $form_id = uniqid();

            return self::renderTemplate( 'short_code', compact( 'ajax_url', 'customer', 'form_id' ), false );
        }

        return self::renderTemplate( 'permission', array(), false );
    }
}