(function($) {
    window.booklyCustomerPackages = function(Options) {
        let $container = $('.bookly-js-customer-packages-' + Options.form_id);
        if (!$container.length) {
            return;
        }
        let $packages_list = $('#bookly-packages-list', $container);

        /**
         * Init DataTables.
         */
        var dt = $packages_list.DataTable({
            order: [[1, 'desc']],
            info: false,
            lengthChange: false,
            pageLength: 25,
            pagingType: 'numbers',
            searching: false,
            processing: true,
            responsive: true,
            serverSide: true,
            ajax: {
                url: Options.ajaxurl,
                type: 'POST',
                data: function(d) {
                    return $.extend({action: 'bookly_packages_get_packages', csrf_token: BooklyL10nGlobal.csrf_token}, {
                        filter: {}
                    }, d);
                }
            },
            columns: [
                {data: 'package.title', responsivePriority: 1, render: $.fn.dataTable.render.text()},
                {data: 'created_at', responsivePriority: 2, render: $.fn.dataTable.render.text()},
                {data: 'expires', responsivePriority: 2, orderable: false, render: $.fn.dataTable.render.text()},
                {data: 'staff.name', responsivePriority: 3, render: $.fn.dataTable.render.text()},
                {data: 'service.title', responsivePriority: 2, render: $.fn.dataTable.render.text()},
                {data: 'package.size', responsivePriority: 3, render: $.fn.dataTable.render.text()},
                {
                    data: null,
                    responsivePriority: 1,
                    orderable: false,
                    render: function(data, type, row, meta) {
                        return '<button type="button" class="btn btn-default bookly-js-edit-package-schedule" title="' + BooklyCustomerPackagesL10n.scheduleAppointments + '"><i class="far fa-fw fa-calendar-alt"></button>';
                    }
                }
            ],
            language: {
                zeroRecords: BooklyCustomerPackagesL10n.zeroRecords,
                processing: BooklyCustomerPackagesL10n.processing,
                emptyTable: BooklyCustomerPackagesL10n.emptyTable,
                loadingRecords: BooklyCustomerPackagesL10n.loadingRecords
            },
            layout: {
                bottomStart: 'paging',
                bottomEnd: null
            }
        });

        $packages_list.on('click', 'button.bookly-js-edit-package-schedule', function() {
            $(document.body).trigger('bookly_packages.schedule_dialog', [dt.row($(this).closest('td')).data().id, function(event) {
                dt.ajax.reload(null, false);
            }, null, BooklyCustomerPackagesL10n.useClientTimeZone != '1']);
        });
    }
})(jQuery);