<?php
namespace BooklyPackages\Frontend\Modules\ModernBookingForm\ProxyProviders;

use Bookly\Lib as BooklyLib;
use Bookly\Frontend\Modules\ModernBookingForm\Proxy;
use BooklyPackages\Lib\Entities\Package;

class Shared extends Proxy\Shared
{
    /**
     * @inerhitDoc
     */
    public static function prepareFormOptions( array $bookly_options )
    {
        $bookly_options['packages'] = self::getPackages();
        foreach ( $bookly_options['packages'] as $id => $package ) {
            $bookly_options['complex_services'][ $id ] = array(
                $package['service_id'],
            );
        }

        return $bookly_options;
    }

    /**
     * @inerhitDoc
     */
    public static function prepareAppearance( array $bookly_options )
    {
        $bookly_options['sell_packages'] = true;
        $bookly_options['hidden_packages'] = array();
        $bookly_options['l10n']['package'] = __( 'Package', 'bookly' );
        $bookly_options['l10n']['package_booking_completed'] = __( 'Your package has been created.', 'bookly' );

        array_splice( $bookly_options['services_fields_order'], 1, 0, 'package' );

        return $bookly_options;
    }

    /**
     * @inerhitDoc
     */
    public static function prepareAppearanceData( array $bookly_options )
    {
        $packages = array();
        $rows = BooklyLib\Entities\Service::query( 's' )->select( 's.id, s.title' )->where( 'type', BooklyLib\Entities\Service::TYPE_PACKAGE )->sortBy( 's.position' )->fetchArray();
        foreach ( $rows as $row ) {
            $packages[] = array( 'id' => $row['id'], 'title' => $row['title'] === '' ? __( 'Untitled', 'bookly' ) : BooklyLib\Utils\Common::getTranslatedString( 'service_' . $row['id'], $row['title'] ) );
        }

        $bookly_options['packages'] = $packages;
        $bookly_options['fields']['display_packages'] = __( 'Display packages', 'bookly' );
        $bookly_options['fields']['hidden_packages'] = __( 'Hidden packages', 'bookly' );
        $bookly_options['package_fields']['package'] = __( 'Package info', 'bookly' );
        $bookly_options['l10n']['package_card']['title'] = 'Crown and bridge x10';
        $bookly_options['l10n']['package_card']['service_title'] = 'Crown and bridge';

        return $bookly_options;
    }

    /**
     * @return array
     */
    private static function getPackages()
    {
        $result = array();

        $query = BooklyLib\Entities\StaffService::query( 'ss' )
            ->select( 's.id, subs.sub_service_id, st.id as staff_id, s.title, ss.price as staff_price, sub.title as sub_service_title, s.price, s.attachment_id, s.package_size, s.package_life_time, s.position' )
            ->innerJoin( 'SubService', 'subs', 'subs.service_id = ss.service_id' )
            ->innerJoin( 'Service', 's', 'ss.service_id = s.id' )
            ->innerJoin( 'Service', 'sub', 'subs.sub_service_id = sub.id' )
            ->leftJoin( 'Staff', 'st', 'st.id = ss.staff_id' )
            ->where( 's.type', BooklyLib\Entities\Service::TYPE_PACKAGE )
            ->where( 's.visibility', 'public' )
            ->where( 'st.visibility', 'public' )
            ->sortBy( 's.position' );

        $query = BooklyLib\Proxy\Locations::prepareStaffServiceQuery( $query );

        if ( ! BooklyLib\Proxy\Locations::servicesPerLocationAllowed() ) {
            $query
                ->addSelect( 'ss.location_id' )
                ->where( 'ss.location_id', null );
        }

        foreach ( $query->fetchArray() as $package ) {
            if ( ! isset( $result[ $package['id'] ] ) ) {
                $result[ $package['id'] ] = array(
                    'package_id' => $package['id'],
                    'service_id' => $package['sub_service_id'],
                    'package_name' => BooklyLib\Utils\Common::getTranslatedString( 'service_' . $package['id'], $package['title'] ),
                    'package_image' => BooklyLib\Utils\Common::getAttachmentUrl( $package['attachment_id'] ),
                    'service_name' => BooklyLib\Utils\Common::getTranslatedString( 'service_' . $package['sub_service_id'], $package['sub_service_title'] ),
                    'staff_settings' => array(),
                    'price' => $package['price'],
                    'package_size' => $package['package_size'],
                    'life_time' => $package['package_life_time'],
                    'pos' => (int) $package['position'],
                );
            }
            if ( ! isset( $result[ $package['id'] ]['staff_settings'] ) ) {
                $result[ $package['id'] ]['staff_settings'] = array();
            }
            $result[ $package['id'] ]['staff_settings'][ $package['staff_id'] ]['locations'][ $package['location_id'] ?: 0 ] = array( 'price' => $package['staff_price'] );
        }

        return array_values( $result );
    }


    /**
     * @inerhitDoc
     */
    public static function prepareBookingResults( $data, $order )
    {
        if (
            Package::query()->where( 'order_id', $order->getId() )
                ->count() > 0
        ) {
            $data['packages'] = true;
        }

        return $data;
    }
}