<?php
namespace BooklyPackages\Lib\DataHolders\Booking;

use Bookly\Lib as BooklyLib;
use Bookly\Lib\DataHolders\Booking\Item;
use BooklyPackages\Lib\Entities;

class Package extends Item
{
    protected $type = Item::TYPE_PACKAGE;

    /** @var Entities\Package */
    protected $package;
    /** @var BooklyLib\Entities\Service */
    protected $service;
    /** @var BooklyLib\Entities\Staff */
    protected $staff;
    /** @var BooklyLib\Entities\StaffService */
    protected $staff_service;

    /**
     * @return Entities\Package
     */
    public function getPackage()
    {
        return $this->package;
    }

    /**
     * @param Entities\Package $package
     * @return $this
     */
    public function setPackage( $package )
    {
        $this->package = $package;

        return $this;
    }

    public function getAppointment()
    {
    }

    public function getCA()
    {
    }

    public function getDeposit()
    {
        if ( ! $this->staff_service ) {
            if ( $this->getStaff() ) {
                $this->staff_service = new BooklyLib\Entities\StaffService();
                $this->staff_service->loadBy(
                    array(
                        'staff_id' => $this->getStaff()->getId(),
                        'service_id' => $this->getService()->getId(),
                        'location_id' => BooklyLib\Proxy\Locations::prepareStaffLocationId( $this->package->getLocationId(), $this->getStaff()->getId() ) ?: null,
                    ) );
            } else {
                return '100%';
            }
        }

        return $this->staff_service->getDeposit();
    }

    public function getExtras()
    {
        return array();
    }

    public function getService()
    {
        if ( ! $this->service ) {
            $this->service = BooklyLib\Entities\Service::find( $this->package->getServiceId() );
        }

        return $this->service;
    }

    public function getServiceDuration()
    {
        return $this->getService()->getDuration();
    }

    public function getServicePrice()
    {
        if ( $this->getService()->getId() ) {
            if ( ! $this->staff_service ) {
                if ( $this->getStaff() ) {
                    $this->staff_service = new BooklyLib\Entities\StaffService();
                    $this->staff_service->loadBy(
                        array(
                            'staff_id' => $this->getStaff()->getId(),
                            'service_id' => $this->getService()->getId(),
                            'location_id' => BooklyLib\Proxy\Locations::prepareStaffLocationId( $this->package->getLocationId(), $this->getStaff()->getId() ) ?: null,
                        ) );
                } else {
                    return $this->getService()->getPrice();
                }
            }
        }

        return $this->staff_service->getPrice();
    }

    public function getStaff()
    {
        if ( ! $this->staff ) {
            $this->staff = BooklyLib\Entities\Staff::find( $this->package->getStaffId() );
        }

        return $this->staff;
    }

    public function getTax()
    {
        if ( ! $this->tax ) {
            $rates = BooklyLib\Proxy\Taxes::getServiceTaxRates();
            if ( $rates ) {
                $this->tax = BooklyLib\Proxy\Taxes::calculateTax( $this->getTotalPrice(), $rates[ $this->getService()->getId() ] );
            }
        }

        return $this->tax;
    }

    public function getServiceTax()
    {
        if ( ! $this->tax ) {
            $rates = BooklyLib\Proxy\Taxes::getServiceTaxRates();
            if ( $rates ) {
                $price = $this->getServicePrice();
                $nop = 1;

                $this->tax = BooklyLib\Proxy\Taxes::calculateTax( $price * $nop, $rates[ $this->getService()->getId() ] );
            }
        }

        return $this->tax;
    }

    public function getTotalEnd()
    {
    }

    public function getTotalPrice()
    {
        $price = $this->getServicePrice();
        $nop = 1;

        $price = BooklyLib\Proxy\ServiceExtras::prepareServicePrice( $price * $nop, $price, $nop, array() );

        return BooklyLib\Proxy\Discounts::prepareServicePrice( $price, $this->getService()->getId(), $nop );
    }

    public function getItems()
    {
        return array( $this );
    }

    public function setStatus( $status )
    {
    }

    public function getLocationId()
    {
        return $this->package->getLocationId();
    }
}