<?php
namespace BooklyPackages\Lib\ProxyProviders;

use Bookly\Lib as BooklyLib;
use Bookly\Lib\Entities\CustomerAppointment;
use BooklyPackages\Backend\Modules\Packages\Page;
use BooklyPackages\Lib;
use BooklyPackages\Lib\DataHolders\Booking;

class Local extends BooklyLib\Proxy\Packages
{
    /**
     * @inheritDoc
     */
    public static function addBooklyMenuItem()
    {
        $packages = __( 'Packages', 'bookly' );

        add_submenu_page( 'bookly-menu', $packages, $packages, 'read',
            Page::pageSlug(), function () { Page::render(); } );
    }

    /**
     * @inheritDoc
     */
    public static function getPackageExpireDate( $package_id )
    {
        $package = new Lib\Entities\Package();
        $package->load( $package_id );
        if ( $package->isLoaded() ) {
            return $package->getExpiredDate();
        }

        return null;
    }

    /**
     * @inheritDoc
     */
    public static function sendNotifications( Booking\Package $item )
    {
        Lib\Notifications\Package\Sender::send( $item->getPackage() );
    }

    /**
     * @inheritDoc
     */
    public static function attachPackages( CustomerAppointment $ca, $data, $staff_id, $location_id )
    {
        if ( isset( $data['package_action'] ) ) {
            switch ( $data['package_action'] ) {
                case 'create':
                    $package = new Lib\Entities\Package();
                    $package
                        ->setCustomerId( $ca->getCustomerId() )
                        ->setServiceId( $data['package_action_id'] )
                        ->setStaffId( $staff_id )
                        ->setLocationId( $location_id )
                        ->save();
                    $ca->setPackageId( $package->getId() )->save();
                    break;
                case 'attach':
                    $ca->setPackageId( $data['package_action_id'] )->save();
                    break;
            }
        }
    }
}