<?php
namespace BooklyPackages\Lib\ProxyProviders;

use Bookly\Lib as BooklyLib;
use Bookly\Lib\Entities\Notification;
use BooklyPackages\Lib\DataHolders\Booking;
use BooklyPackages\Lib\Entities;

class Shared extends BooklyLib\Proxy\Shared
{
    /**
     * @inheritDoc
     */
    public static function prepareNotificationTitles( array $titles )
    {
        $titles[ Notification::TYPE_NEW_PACKAGE ]     = __( 'Notification about new package creation', 'bookly' );
        $titles[ Notification::TYPE_PACKAGE_DELETED ] = __( 'Notification about package deletion', 'bookly' );

        return $titles;
    }

    /**
     * @inheritDoc
     */
    public static function prepareNotificationTypes( array $types, $gateway )
    {
        $types[] = Notification::TYPE_NEW_PACKAGE;
        $types[] = Notification::TYPE_PACKAGE_DELETED;

        return $types;
    }

    /**
     * @inheritDoc
     */
    public static function prepareTableColumns( $columns, $table )
    {
        if ( $table == BooklyLib\Utils\Tables::PACKAGES ) {
            $columns = array_merge( $columns, array(
                'id' => esc_html_x( 'No.', 'number', 'bookly' ),
                'created_at' => esc_html__( 'Creation date', 'bookly' ),
                'staff_name' => esc_html( BooklyLib\Utils\Common::getTranslatedOption( 'bookly_l10n_label_employee' ) ),
                'customer_full_name' => esc_html__( 'Customer name', 'bookly' ),
                'customer_phone' => esc_html__( 'Customer phone', 'bookly' ),
                'customer_email' => esc_html__( 'Customer email', 'bookly' ),
                'package_title' => esc_html__( 'Package', 'bookly' ),
                'service_title' => esc_html( BooklyLib\Utils\Common::getTranslatedOption( 'bookly_l10n_label_service' ) ),
                'package_size' => esc_html__( 'Quantity', 'bookly' ),
                'payment' => esc_html__( 'Payment', 'bookly' ),
            ) );
        }

        return $columns;
    }

    /**
     * @inheritDoc
     */
    public static function unpaidPayments( $payment_ids )
    {
        Entities\Package::query()
            ->delete()
            ->whereIn( 'payment_id', $payment_ids )
            ->execute();
    }

    /**
     * @return BooklyLib\DataHolders\Booking\Order|null
     */
    public static function addItemsInOrder( $order, $order_id )
    {
        $pkg_order = self::createOrder( $order_id );
        if ( $pkg_order ) {
            if ( $order ) {
                foreach ( $pkg_order->getItems() as $position => $item ) {
                    $order->addItem( 'pkg_' . $position, $item );
                }
            } else {
                $order = $pkg_order;
            }
        }

        return $order;
    }

    /**
     * @param string $order_id
     * @return BooklyLib\DataHolders\Booking\Order|null
     */
    protected static function createOrder( $order_id )
    {
        $order = null;
        /** @var Entities\Package[] $pkg_list */
        $pkg_list = Entities\Package::query()->where( 'order_id', $order_id )->find();
        if ( $pkg_list ) {
            $payment_id = $pkg_list[0]->getPaymentId();
            $customer = BooklyLib\Entities\Customer::find( $pkg_list[0]->getCustomerId() );
            $order = BooklyLib\DataHolders\Booking\Order::create( $customer );
            if ( $payment_id ) {
                $order->setPayment( BooklyLib\Entities\Payment::find( $payment_id ) );
            }
            $order->setOrderId( $pkg_list[0]->getOrderId() );
            $item_key = 0;
            foreach ( $pkg_list as $package ) {
                $item = new Booking\Package();
                $item->setPackage( $package );
                $order->addItem( $item_key++, $item );
            }
        }

        return $order;
    }
}