<?php defined( 'ABSPATH' ) || exit; // Exit if accessed directly
use Bookly\Lib;
/**
 * @var array $service
 */
?>
<div class="form-group bookly-js-service bookly-js-service-simple">
    <div class="form-group"><label><?php esc_html_e( 'Time step settings', 'bookly' ) ?></label>
        <div class="custom-control custom-radio">
            <input type="radio" id="bookly-time-step-required" name="time_requirements" value="<?php echo Lib\Entities\Service::START_TIME_REQUIRED ?>"<?php checked( Lib\Entities\Service::START_TIME_REQUIRED == $service['time_requirements'] ) ?> class="custom-control-input" />
            <label for="bookly-time-step-required" class="custom-control-label"><?php esc_html_e( 'Required', 'bookly' ) ?></label>
        </div>
        <div class="custom-control custom-radio">
            <input type="radio" id="bookly-time-step-optional" name="time_requirements" value="<?php echo Lib\Entities\Service::START_TIME_OPTIONAL ?>"<?php checked( Lib\Entities\Service::START_TIME_OPTIONAL == $service['time_requirements'] ) ?> class="custom-control-input" />
            <label for="bookly-time-step-optional" class="custom-control-label"><?php esc_html_e( 'Optional', 'bookly' ) ?></label>
        </div>
        <div class="custom-control custom-radio">
            <input type="radio" id="bookly-time-step-off" name="time_requirements" value="<?php echo Lib\Entities\Service::START_TIME_OFF ?>"<?php checked( Lib\Entities\Service::START_TIME_OFF == $service['time_requirements'] ) ?> class="custom-control-input" />
            <label for="bookly-time-step-off" class="custom-control-label"><?php esc_html_e( 'OFF', 'bookly' ) ?></label>
        </div>
        <small class="form-text text-muted"><?php esc_html_e( 'This setting allows to display the step of selecting an appointment time, hide it and create a task without due time, or display the time step, but allow a customer to skip it.', 'bookly' ) ?></small>
    </div>
</div>