<?php
namespace BooklyTasks\Backend\Modules\Staff\ProxyProviders;

use Bookly\Lib as BooklyLib;
use Bookly\Backend\Modules\Appointments\Page;
use Bookly\Backend\Modules\Staff\Proxy;

class Shared extends Proxy\Shared
{
    /**
     * @inheritDoc
     */
    public static function getAffectedAppointmentsFilter( $filter_url, array $staff_ids )
    {
        if( ! $filter_url ) {
            $row = BooklyLib\Entities\CustomerAppointment::query( 'ca' )
                ->select( 'a.staff_id' )
                ->leftJoin( 'Appointment', 'a', 'a.id = ca.appointment_id' )
                ->whereIn( 'a.staff_id', $staff_ids )
                ->where( 'a.start_date', null )
                ->whereIn( 'ca.status', BooklyLib\Proxy\CustomStatuses::prepareBusyStatuses( array(
                    BooklyLib\Entities\CustomerAppointment::STATUS_PENDING,
                    BooklyLib\Entities\CustomerAppointment::STATUS_APPROVED,
                ) ) )
                ->limit( 1 )
                ->fetchRow();
            if ( $row ) {
                $filter_url = sprintf( '%s#staff=%d&tasks',
                    BooklyLib\Utils\Common::escAdminUrl( Page::pageSlug() ),
                    $row['staff_id'] );
            }
        }

        return $filter_url;
    }
}