<?php
namespace BooklyTasks\Frontend\Modules\Booking\ProxyProviders;

use Bookly\Lib as BooklyLib;
use BooklyPro\Lib as BooklyProLib;
use Bookly\Frontend\Modules\Booking\Proxy;

class Local extends Proxy\Tasks
{
    /**
     * @inheritDoc
     */
    public static function renderSkipButton( BooklyLib\UserBookingData $userData )
    {
        $services = array();
        foreach ( $userData->chain->getItemsData() as $item ) {
            $services[] = $item['service_id'];
        }

        $time_requirements = BooklyLib\Entities\Service::query()
            ->whereIn( 'id', $services )
            ->fetchCol( 'time_requirements' );

        if ( ! in_array( BooklyLib\Entities\Service::START_TIME_REQUIRED, $time_requirements ) ) {
            self::renderTemplate( 'skip_button' );
        }
    }

    /**
     * @inheritDoc
     */
    public static function prepareUserData( BooklyLib\UserBookingData $userData )
    {
        $slots = $userData->getSlots();
        // Check if slots corresponds to chain items (in case select slot for usual service click back and select task)
        if ( $slots ) {
            $only_tasks = true;
            foreach ( $userData->chain->getItems() as $item ) {
                $service = $item->getService();
                if ( $service->getTimeRequirements() === BooklyLib\Entities\Service::START_TIME_REQUIRED || $service->withSubServices() ) {
                    $only_tasks = false;
                    break;
                }
            }
            if ( $only_tasks ) {
                foreach ( $userData->chain->getItems() as $index => $item ) {
                    if ( ! isset( $slots[ $index ] ) || $slots[ $index ][0] !== $item->getServiceId() ) {
                        $userData->setSlots( array() );
                        break;
                    }
                }
            }
        }
        if ( ! $userData->getSlots() ) {
            $slots = array();
            foreach ( $userData->chain->getItemsData() as $item ) {
                $service = BooklyLib\Entities\Service::find( $item['service_id'] );
                if ( $service->withSubServices() ) {
                    $services = $service->getSubServices();
                } else {
                    $services = array( $service );
                }
                foreach ( $services as $service ) {
                    $service_id = $service->getId();
                    if ( count( $item['staff_ids'] ) > 1 ) {
                        $staff_id = $item['staff_ids']['0'];

                        switch ( $service->getStaffPreference() ) {
                            case BooklyLib\Entities\Service::PREFERRED_MOST_EXPENSIVE:
                                $max_price = BooklyLib\Entities\StaffService::query( 'ss' )
                                    ->where( 'service_id', $service_id )
                                    ->fetchVar( 'MAX(price) AS max_price' );

                                $staff = BooklyLib\Entities\StaffService::query( 'ss' )
                                    ->select( 'staff_id' )
                                    ->where( 'service_id', $service_id )
                                    ->where( 'price', $max_price )
                                    ->fetchArray();

                                $staff_id = $staff ? $staff[ array_rand( $staff ) ]['staff_id'] : $staff_id;
                                break;
                            case BooklyLib\Entities\Service::PREFERRED_LEAST_EXPENSIVE:
                                $min_price = BooklyLib\Entities\StaffService::query( 'ss' )
                                    ->where( 'service_id', $service_id )
                                    ->fetchVar( 'MIN(price) AS min_price' );

                                $staff = BooklyLib\Entities\StaffService::query( 'ss' )
                                    ->select( 'staff_id' )
                                    ->where( 'service_id', $service_id )
                                    ->where( 'price', $min_price )
                                    ->fetchArray();

                                $staff_id = $staff ? $staff[ array_rand( $staff ) ]['staff_id'] : $staff_id;
                                break;
                            case BooklyLib\Entities\Service::PREFERRED_MOST_OCCUPIED:
                                $staff = BooklyLib\Entities\Appointment::query( 'a' )
                                    ->select( 'staff_id' )
                                    ->whereIn( 'staff_id', $item['staff_ids'] )
                                    ->whereGt( 'start_date', current_time( 'Y-m-d 00:00:00' ) )
                                    ->whereLt( 'start_date', current_time( 'Y-m-d 23:59:59' ) )
                                    ->groupBy( 'staff_id' )
                                    ->sortBy( 'COUNT(a.id)' )
                                    ->order( 'ASC' )
                                    ->limit( 1 )
                                    ->fetchRow();
                                $staff_id = $staff ? $staff['staff_id'] : $item['staff_ids'][ array_rand( $item['staff_ids'] ) ];
                                break;
                            case BooklyLib\Entities\Service::PREFERRED_LEAST_OCCUPIED:
                                $staffs = BooklyLib\Entities\Appointment::query( 'a' )
                                    ->select( 'staff_id, COUNT(a.id) AS cnt' )
                                    ->whereIn( 'staff_id', $item['staff_ids'] )
                                    ->whereGt( 'start_date', current_time( 'Y-m-d 00:00:00' ) )
                                    ->whereLt( 'start_date', current_time( 'Y-m-d 23:59:59' ) )
                                    ->groupBy( 'staff_id' )
                                    ->sortBy( 'cnt' )
                                    ->order( 'DESC' )
                                    ->fetchArray();
                                if ( count( $staffs ) == count( $item['staff_ids'] ) ) {
                                    $staff_id = $staffs[0]['staff_id'];
                                } else {
                                    $staff_ids = array_diff( $item['staff_ids'], array_map( function( $staff ) { return $staff['staff_id']; }, $staffs ) );
                                    $staff_id = $staff_ids[ array_rand( $staff_ids ) ];
                                }
                                break;
                            case BooklyLib\Entities\Service::PREFERRED_ORDER:
                                $staff = BooklyProLib\Entities\StaffPreferenceOrder::query( 'spo' )
                                    ->select( 'staff_id' )
                                    ->where( 'service_id', $service_id )
                                    ->whereIn( 'staff_id', $item['staff_ids'] )
                                    ->sortBy( 'position' )
                                    ->order( 'ASC' )
                                    ->limit( 1 )
                                    ->fetchRow();
                                $staff_id = $staff ? $staff['staff_id'] : $item['staff_ids'][ array_rand( $item['staff_ids'] ) ];
                                break;
                            default:
                                $staff_id = $item['staff_ids'][ array_rand( $item['staff_ids'] ) ];
                                break;
                        }
                        $slot = array( $service_id, $staff_id, null, $item['location_id'] );
                    } else {
                        $slot = array( $service_id, $item['staff_ids']['0'], null, $item['location_id'] );
                    }
                    // Time step has been skipped, slots will be cloned according to quantity
                    for ( $i = 0; $i < $item['quantity']; $i++ ) {
                        $slots[] = $slot;
                    }
                }
            }
            $userData->setSlots( $slots );
        }

        return $userData;
    }
}