<?php
namespace BooklyTasks\Frontend\Modules\Booking\ProxyProviders;

use Bookly\Lib as BooklyLib;
use Bookly\Frontend\Modules\Booking\Proxy;

class Shared extends Proxy\Shared
{
    /**
     * @inheritDoc
     */
    public static function booklyFormOptions( array $bookly_options )
    {
        if ( $bookly_options['skip_steps']['time'] == 0 ) {
            if ( $bookly_options['form_attributes']['hide_services'] ) {
                // Case when service is hidden on bookly form
                // if for simple service time step requirements are off
                // we need to skip step time.
                // For Compound & Collaborative no changes
                $defaults = BooklyLib\Session::getFormVar( $bookly_options['form_id'], 'defaults' );
                if ( $defaults['service_id'] ) {
                    $service = BooklyLib\Entities\Service::find( $defaults['service_id'] );
                    switch ( $service->getType() ) {
                        case BooklyLib\Entities\Service::TYPE_COMPOUND:
                        case BooklyLib\Entities\Service::TYPE_COLLABORATIVE:
                            // no changes, time step is not skipped.
                            break;
                        case BooklyLib\Entities\Service::TYPE_SIMPLE:
                            $bookly_options['skip_steps']['time'] = (int) ( $service->getTimeRequirements() == BooklyLib\Entities\Service::START_TIME_OFF || get_option( 'bookly_tasks_show_time_step' ) === '0' );
                            break;
                        case BooklyLib\Entities\Service::TYPE_PACKAGE:
                        default:
                    }
                }

                // If skip step time we can skit step repeat
                if ( $bookly_options['skip_steps']['time'] ) {
                    $bookly_options['skip_steps']['repeat'] = 1;
                }
            }
        }

        return $bookly_options;
    }
}