<?php
namespace BooklyTasks\Lib;

use Bookly\Lib as BooklyLib;

class Installer extends Base\Installer
{
    /** @var array */
    protected $notifications = array();

    /**
     * Constructor.
     */
    public function __construct()
    {
        // Notifications email & sms.
        $default_settings = json_decode( '{"status":"any","option":2,"services":{"any":"any","ids":[]},"offset_hours":2,"perform":"before","at_hour":9,"before_at_hour":18,"offset_before_hours":-24,"offset_bidirectional_hours":0}', true );
        $default_settings['option'] = 1;
        $default_settings['status'] = 'done';
        $settings = json_encode( $default_settings );
        $this->notifications[] = array(
            'gateway'     => 'email',
            'type'        => 'ca_status_changed',
            'name'        => __( 'Your task is done', 'bookly' ),
            'subject'     => __( 'Your task is done', 'bookly' ),
            'message'     => __( "Dear {client_name}.\n\nYour task {service_name} has been done.\n\nThank you for choosing our company.\n\n{company_name}\n{company_phone}\n{company_website}", 'bookly' ),
            'to_customer' => 1,
            'settings'    => $settings,
        );
        $this->notifications[] = array(
            'gateway'     => 'email',
            'type'        => 'ca_status_changed',
            'name'        => __( 'Task is done', 'bookly' ),
            'subject'     => __( 'Task is done', 'bookly' ),
            'message'     => __( "Hello.\n\nThe following task has been done.\n\nService: {service_name}\n\nClient name: {client_name}\n\nClient phone: {client_phone}\n\nClient email: {client_email}", 'bookly' ),
            'to_staff'    => 1,
            'settings'    => $settings,
        );
        $this->notifications[] = array(
            'gateway'     => 'sms',
            'type'        => 'ca_status_changed',
            'name'        => __( 'Your task is done', 'bookly' ),
            'subject'     => __( 'Your task is done', 'bookly' ),
            'message'     => __( "Dear {client_name}.\nYour task {service_name} has been done.\nThank you for choosing our company.\n{company_name}\n{company_phone}\n{company_website}", 'bookly' ),
            'to_customer' => 1,
            'settings'    => $settings,
        );
        $this->notifications[] = array(
            'gateway'     => 'sms',
            'type'        => 'ca_status_changed',
            'name'        => __( 'Task is done', 'bookly' ),
            'subject'     => __( 'Task is done', 'bookly' ),
            'message'     => __( "Hello.\nThe following task has been done.\nService: {service_name}\nClient name: {client_name}\nClient phone: {client_phone}\nClient email: {client_email}", 'bookly' ),
            'to_staff'    => 1,
            'settings'    => $settings,
        );

        $this->options = array(
            'bookly_l10n_button_skip_time_step' => __( 'Skip', 'bookly' ),
            'bookly_tasks_show_time_step' => '1',
            'bookly_appointment_status_done_color' => '#dddddd',
        );
    }

    public function loadData()
    {
        parent::loadData();

        // Insert notifications.
        foreach ( $this->notifications as $data ) {
            $notification = new BooklyLib\Entities\Notification();
            $notification->setFields( $data )->save();
        }
    }
}