<?php
namespace BooklyTasks\Lib;

use Bookly\Lib as BooklyLib;

class Updater extends BooklyLib\Base\Updater
{
    public function update_2_5()
    {
        $new_pc_key = 'bookly_tasks_purchase_code';
        $old_pc_key = 'bookly_tasks_envato_purchase_code';
        $current_pc = get_option( $old_pc_key, 'missing' );
        if ( $current_pc === 'missing' ) {
            add_option( $new_pc_key, '' );
        } else {
            if ( $current_pc ) {
                add_option( $new_pc_key, $current_pc );
            }
            delete_option( $old_pc_key );
        }
    }

    public function update_2_0()
    {
        add_option( 'bookly_tasks_show_time_step', '1' );
        add_option( 'bookly_appointment_status_done_color', '#dddddd' );
    }
}