<?php
namespace BooklyTasks\Lib\ProxyProviders;

use BooklyTasks\Lib;
use Bookly\Lib as BooklyLib;

class Shared extends BooklyLib\Proxy\Shared
{
    /**
     * @param BooklyLib\Query $query
     *
     * @return BooklyLib\Query
     */
    public static function prepareCaSeStQuery( BooklyLib\Query $query )
    {
        return $query->addSelect( 's.time_requirements' );
    }

    /**
     * @inheritDoc
     */
    public static function prepareCategoryService( array $result, array $row )
    {
        $result['services'][ $row['id'] ]['time_requirements'] = $row['time_requirements'];

        return $result;
    }

    /**
     * @inheritDoc
     */
    public static function prepareColorsStatuses( array $statuses )
    {
        $statuses['done'] = get_option( 'bookly_appointment_status_done_color' );

        return $statuses;
    }
}