<?php defined( 'ABSPATH' ) || exit; // Exit if accessed directly ?>
<div class="form-group">
    <label><?php esc_html_e( 'Waiting list limit', 'bookly' ) ?></label>
    <div class="custom-control custom-radio">
        <input type="radio" id="bookly-wl-limit-0" name="waiting_list_limit" value="0"<?php checked( $service['waiting_list_capacity'] === null ) ?> class="custom-control-input"/>
        <label for="bookly-wl-limit-0" class="custom-control-label"><?php esc_html_e( 'No limit', 'bookly' ) ?></label>
    </div>
    <div class="custom-control custom-radio">
        <input type="radio" id="bookly-wl-limit-1" name="waiting_list_limit" value="1"<?php checked( $service['waiting_list_capacity'] !== null ) ?> class="custom-control-input"/>
        <label for="bookly-wl-limit-1" class="custom-control-label"><?php esc_html_e( 'Custom', 'bookly' ) ?></label>
    </div>
    <small class="form-text text-muted"><?php esc_html_e( 'Set the limit of customers that can be added to waiting list.', 'bookly' ) ?></small>
</div>
<div class="form-group border-left ml-4 pl-3"<?php if ( $service['waiting_list_capacity'] === null ) : ?> style="display: none;"<?php endif ?>>
    <label for="bookly_waiting_list_capacity"><?php esc_html_e( 'Limit', 'bookly' ) ?></label>
    <input id="bookly_waiting_list_capacity" class="form-control bookly-js-wl-capacity" type="number" min="1" step="1" name="waiting_list_capacity" value="<?php echo esc_attr( $service['waiting_list_capacity'] ) ?>" data-default="<?php echo esc_attr( $service['waiting_list_capacity'] ) ?>"/>
    <small class="form-text text-muted"><?php esc_html_e( 'Set 0 to disable waiting list for this service or set the required value.', 'bookly' ) ?></small>
</div>