<?php
namespace BooklyWaitingList\Backend\Modules\Appearance\ProxyProviders;

use Bookly\Backend\Modules\Appearance\Proxy;

class Shared extends Proxy\Shared
{
    /**
     * @inheritDoc
     */
    public static function prepareOptions( array $options_to_save, array $options )
    {
        return array_merge( $options_to_save, array_intersect_key( $options, array_flip( array(
            'bookly_waiting_list_enabled',
            'bookly_l10n_info_time_step_waiting_list',
        ) ) ) );
    }

    /**
     * @inheritDoc
     */
    public static function renderTimeStepSettings()
    {
        self::renderTemplate( 'show_waiting_list' );
    }
}