<?php
namespace BooklyWaitingList\Backend\Modules\Notifications\ProxyProviders;

use Bookly\Backend\Modules\Notifications\Proxy;

class Shared extends Proxy\Shared
{
    /**
     * @inheritDoc
     */
    public static function prepareNotificationCodes( array $codes, $type )
    {
        $codes['waiting_list'] = array(
            'appointment_waiting_list' => array( 'description' => __( 'Waiting list of appointment', 'bookly' ), 'if' => true ),
        );
        $codes['free_place'] = array(
            'appointment_booking_url' => array( 'description' => __( 'URL of booking the appointment from the waiting list', 'bookly' ) ),
        );

        return $codes;
    }

    /**
     * @inheritDoc
     */
    public static function buildNotificationCodesList( array $codes, $notification_type, array $codes_data )
    {
        switch ( $notification_type ) {
            case 'staff_waiting_list':
                $codes = array_merge(
                    $codes_data['waiting_list'],
                    $codes_data['appointment'],
                    $codes_data['category'],
                    $codes_data['service'],
                    $codes_data['staff'],
                    $codes_data['company']
                );
                break;
            case 'free_place_waiting_list':
                $codes = array_merge(
                    $codes_data['appointment'],
                    $codes_data['category'],
                    $codes_data['company'],
                    $codes_data['customer'],
                    $codes_data['customer_timezone'],
                    $codes_data['service'],
                    $codes_data['staff'],
                    $codes_data['free_place']
                );
                break;
        }

        return $codes;
    }
}