<?php defined( 'ABSPATH' ) || exit; // Exit if accessed directly
use Bookly\Backend\Components\Settings\Selects;
?>
<div class="card bookly-collapse-with-arrow">
    <div class="card-header d-flex align-items-center">
        <a href="#bookly_add-waiting-list" class="ml-2 bookly-collapsed" role="button" data-toggle="bookly-collapse" aria-expanded="false">
            <?php _e( 'Waiting List', 'bookly' ) ?>
        </a>
    </div>
    <div id="bookly_add-waiting-list" class="bookly-collapse">
        <div class="card-body pb-0">
            <?php Selects::renderSingle( 'bookly_waiting_list_despite_capacity', __( 'Add customers to the waiting list despite the capacity value', 'bookly' ), __( 'If enabled and someone is already on the waiting list, all other customers will be placed on the waiting list. If disabled, free places will be available for booking on the front-end if the number of persons matches the remaining places in appointment.', 'bookly' ) ); ?>
        </div>
    </div>
</div>