<?php
namespace BooklyWaitingList\Lib;

use Bookly\Lib as BooklyLib;

class Installer extends Base\Installer
{
    /** @var array */
    protected $notifications = array();

    /**
     * Constructor.
     */
    public function __construct()
    {
        // Notifications email & sms.
        $default_settings = json_decode( '{"status":"any","option":2,"services":{"any":"any","ids":[]},"offset_hours":2,"perform":"before","at_hour":9,"before_at_hour":18,"offset_before_hours":-24,"offset_bidirectional_hours":0}', true );
        $settings = $default_settings;
        $settings['status'] = 'waitlisted';
        $this->notifications[] = array(
            'gateway' => 'email',
            'type' => 'new_booking',
            'name' => __( 'Notification to customer about placing on waiting list', 'bookly' ),
            'subject' => __( 'You have been added to waiting list for appointment', 'bookly' ),
            'message' => __( "Dear {client_name}.\n\nThis is a confirmation that you have been added to the waiting list for {service_name} on {appointment_date} at {appointment_time}.\n\nThank you for choosing our company.\n\n{company_name}\n{company_phone}\n{company_website}", 'bookly' ),
            'active' => 1,
            'to_customer' => 1,
            'settings' => $settings,
        );
        $settings = $default_settings;
        $settings['status'] = 'waitlisted';
        $this->notifications[] = array(
            'gateway' => 'email',
            'type' => 'new_booking',
            'name' => __( 'Notification to staff member about placing on waiting list', 'bookly' ),
            'subject' => __( 'New waiting list information', 'bookly' ),
            'message' => __( "Hello.\n\nYou have new customer in the waiting list.\n\nService: {service_name}\nDate: {appointment_date}\nTime: {appointment_time}\nClient name: {client_name}\nClient phone: {client_phone}\nClient email: {client_email}", 'bookly' ),
            'active' => 1,
            'to_staff' => 1,
            'settings' => $settings,
        );
        $this->notifications[] = array(
            'gateway' => 'email',
            'type' => 'staff_waiting_list',
            'name' => __( 'Notification to staff member to set appointment from waiting list', 'bookly' ),
            'subject' => __( 'Set appointment from waiting list', 'bookly' ),
            'message' => __( "Dear {staff_name},\n\nThe time slot on {appointment_date} at {appointment_time} for {service_name} is now available for booking. Please see the list of customers on the waiting list and make a new appointment.\n\n{appointment_waiting_list}", 'bookly' ),
            'active' => 1,
            'to_staff' => 1,
            'settings' => $default_settings,
        );
        $settings = $default_settings;
        $settings['status'] = 'waitlisted';
        $this->notifications[] = array(
            'gateway' => 'sms',
            'type' => 'new_booking',
            'name' => __( 'Notification to customer about placing on waiting list', 'bookly' ),
            'subject' => __( 'You have been added to waiting list for appointment', 'bookly' ),
            'message' => __( "Dear {client_name}.\nThis is a confirmation that you have been added to the waiting list for {service_name} on {appointment_date} at {appointment_time}.\nThank you for choosing our company.\n{company_name}\n{company_phone}\n{company_website}", 'bookly' ),
            'active' => 1,
            'to_customer' => 1,
            'settings' => $settings,
        );
        $settings = $default_settings;
        $settings['status'] = 'waitlisted';
        $this->notifications[] = array(
            'gateway' => 'sms',
            'type' => 'new_booking',
            'name' => __( 'Notification to staff member about placing on waiting list', 'bookly' ),
            'subject' => __( 'New waiting list information', 'bookly' ),
            'message' => __( "Hello.\nYou have new customer in the waiting list.\nService: {service_name}\nDate: {appointment_date}\nTime: {appointment_time}\nClient name: {client_name}\nClient phone: {client_phone}\nClient email: {client_email}", 'bookly' ),
            'active' => 1,
            'to_staff' => 1,
            'settings' => $settings,
        );
        $this->notifications[] = array(
            'gateway' => 'sms',
            'type' => 'staff_waiting_list',
            'name' => __( 'Notification to staff member to set appointment from waiting list', 'bookly' ),
            'subject' => __( 'Set appointment from waiting list', 'bookly' ),
            'message' => __( "Dear {staff_name},\nThe time slot on {appointment_date} at {appointment_time} for {service_name} is now available for booking. Please see the list of customers on the waiting list and make a new appointment.\n{appointment_waiting_list}", 'bookly' ),
            'active' => 1,
            'to_staff' => 1,
            'settings' => $default_settings,
        );
        $this->notifications[] = array(
            'gateway' => 'email',
            'type' => 'free_place_waiting_list',
            'name' => __( 'Notification to customer to set appointment from waiting list', 'bookly' ),
            'subject' => __( 'The time slot from the waiting list is now available', 'bookly' ),
            'message' => __( "Dear {client_name},\n\nThe time slot on {appointment_date} at {appointment_time} for {service_name} is now available for booking. Please use the link below to approve this appointment: {appointment_booking_url}. Please note that the availability of the requested timeslot is not guaranteed, because this message is sent out to all customers in the appointment waitlist.", 'bookly' ),
            'active' => 1,
            'to_customer' => 1,
            'settings' => array(),
        );
        $this->notifications[] = array(
            'gateway' => 'sms',
            'type' => 'free_place_waiting_list',
            'name' => __( 'Notification to customer to set appointment from waiting list', 'bookly' ),
            'message' => __( "Dear {client_name},\n\nThe time slot on {appointment_date} at {appointment_time} for {service_name} is now available for booking. Please use the link below to approve this appointment: {appointment_booking_url}. Please note that the availability of the requested timeslot is not guaranteed, because this message is sent out to all customers in the appointment waitlist.", 'bookly' ),
            'active' => 1,
            'to_customer' => 1,
            'settings' => array(),
        );

        $this->options = array(
            // Appearance.
            'bookly_waiting_list_enabled' => '1',
            'bookly_waiting_list_despite_capacity' => '0',
            'bookly_l10n_info_time_step_waiting_list' => __( 'To join the waiting list for a busy time slot, please select a slot marked with "(N)", where N is a number of customers on the waiting list.', 'bookly' ),
            'bookly_appointment_status_waitlisted_color' => '#a3a3a3',
            'bookly_url_confirm_from_waitlisted_page_url' => home_url(),
            'bookly_url_confirm_from_waitlisted_denied_page_url' => home_url(),
        );
    }

    /**
     * @inheritDoc
     */
    public function loadData()
    {
        parent::loadData();

        // Insert notifications.
        foreach ( $this->notifications as $data ) {
            $notification = new BooklyLib\Entities\Notification();
            $notification->setFields( $data )->save();
        }
    }
}