<?php
namespace BooklyWaitingList\Lib;

use Bookly\Lib;

class Updater extends Lib\Base\Updater
{
    public function update_3_7()
    {
        $new_pc_key = 'bookly_waiting_list_purchase_code';
        $old_pc_key = 'bookly_waiting_list_envato_purchase_code';
        $current_pc = get_option( $old_pc_key, 'missing' );
        if ( $current_pc === 'missing' ) {
            add_option( $new_pc_key, '' );
        } else {
            if ( $current_pc ) {
                add_option( $new_pc_key, $current_pc );
            }
            delete_option( $old_pc_key );
        }
    }

    public function update_2_4()
    {
        $this->addNotifications( array(
            array(
                'gateway' => 'email',
                'type' => 'free_place_waiting_list',
                'name' => __( 'Notification to customer to set appointment from waiting list', 'bookly' ),
                'subject' => __( 'The time slot from the waiting list is now available.', 'bookly' ),
                'message' => __( "Dear {client_name},\n\nThe time slot on {appointment_date} at {appointment_time} for {service_name} is now available for booking. Please use the link below to approve this appointment: {appointment_booking_url}. Please note that the availability of the requested timeslot is not guaranteed, because this message is sent out to all customers in the appointment waitlist.", 'bookly' ),
                'active' => 0,
                'to_customer' => 1,
                'settings' => '[]',
            ),
            array(
                'gateway' => 'sms',
                'type' => 'free_place_waiting_list',
                'name' => __( 'Notification to customer to set appointment from waiting list', 'bookly' ),
                'message' => __( "Dear {client_name},\n\nThe time slot on {appointment_date} at {appointment_time} for {service_name} is now available for booking. Please use the link below to approve this appointment: {appointment_booking_url}. Please note that the availability of the requested timeslot is not guaranteed, because this message is sent out to all customers in the appointment waitlist.", 'bookly' ),
                'active' => 0,
                'to_customer' => 1,
                'settings' => '[]',
            ), )
        );
        add_option( 'bookly_url_confirm_from_waitlisted_page_url', home_url() );
        add_option( 'bookly_url_confirm_from_waitlisted_denied_page_url', home_url() );
    }

    public function update_2_3()
    {
        add_option( 'bookly_appointment_status_waitlisted_color', '#a3a3a3' );
    }

    public function update_2_2()
    {
        add_option( 'bookly_waiting_list_despite_capacity', '0' );
    }

    public function update_1_5()
    {
        /** @global \wpdb $wpdb */
        global $wpdb;

        $self = $this;
        $notifications_table  = $this->getTableName( 'bookly_notifications' );
        $notifications = array(
            'client_waitlisted_appointment' => array( 'type' => 'new_booking', 'name' => __( 'Notification to customer about placing on waiting list', 'bookly' ) ),
            'staff_waiting_list'            => array( 'type' => 'staff_waiting_list', 'name' => __( 'Notification to staff member to set appointment from waiting list', 'bookly' ) ),
            'staff_waitlisted_appointment'  => array( 'type' => 'new_booking', 'name' => __( 'Notification to staff member about placing on waiting list', 'bookly' ) ),
        );

        // Set name
        $disposable_options[] = $this->disposable( __FUNCTION__ . '-1', function () use ( $self, $wpdb, $notifications_table, $notifications ) {
            if ( ! $self->existsColumn( 'bookly_notifications', 'name' ) ) {
                $self->alterTables( array(
                    'bookly_notifications' => array(
                        'ALTER TABLE `%s` ADD COLUMN `name` VARCHAR(255) NOT NULL DEFAULT "" AFTER `active`',
                    ),
                ) );
            }
            $update_name = 'UPDATE `' . $notifications_table . '` SET `name` = %s WHERE `type` = %s AND name = \'\'';
            foreach ( $notifications as $type => $value ) {
                $wpdb->query( $wpdb->prepare( $update_name, $value['name'], $type ) );
                switch ( substr( $type, 0, 6 ) ) {
                    case 'staff_':
                        $wpdb->query( sprintf( 'UPDATE `%s` SET `to_staff` = 1 WHERE `type` = "%s"', $notifications_table, $type ) );
                        break;
                    case 'client':
                        $wpdb->query( sprintf( 'UPDATE `%s` SET `to_customer` = 1 WHERE `type` = "%s"', $notifications_table, $type ) );
                        break;
                }
            }
        } );

        // WPML
        $disposable_options[] = $this->disposable( __FUNCTION__ . '-2', function () use ( $self, $wpdb, $notifications_table, $notifications ) {
            $records = $wpdb->get_results( $wpdb->prepare( 'SELECT id, `type`, `gateway` FROM `' . $notifications_table . '` WHERE COALESCE( `settings`, \'[]\' ) = \'[]\' AND `type` IN (' . implode( ', ', array_fill( 0, count( $notifications ), '%s' ) ) . ')', array_keys( $notifications ) ), ARRAY_A );
            $strings = array();
            foreach ( $records as $record ) {
                $type = $record['type'];
                if ( isset( $notifications[ $type ]['type'] ) && $type != $notifications[ $type ]['type'] ) {
                    $key   = sprintf( '%s_%s_%d', $record['gateway'], $type, $record['id'] );
                    $value = sprintf( '%s_%s_%d', $record['gateway'], $notifications[ $type ]['type'], $record['id'] );
                    $strings[ $key ] = $value;
                    if ( $record['gateway'] == 'email' ) {
                        $strings[ $key . '_subject' ] = $value . '_subject';
                    }
                }
            }
            $self->renameL10nStrings( $strings, false );
        } );

        // Add settings for notifications
        $disposable_options[] = $this->disposable( __FUNCTION__ . '-3', function () use ( $wpdb, $notifications_table, $notifications ) {
            $combined_notifications = get_option( 'bookly_cst_combined_notifications', 'missing' );
            if ( $combined_notifications === 'missing' ) {
                $combined_notifications = (bool) $wpdb->query( 'SELECT 1 FROM `' . $notifications_table . '` WHERE `type` = \'new_booking_combined\' AND `active` = 1 LIMIT 1' );
            }
            $combined_notifications_disabled = (int) ! $combined_notifications;
            $insert_from_select  = 'INSERT INTO `' . $notifications_table . '` (`gateway`, `name`, `subject`, `message`, `to_staff`, `to_customer`, `to_admin`, `attach_ics`, `attach_invoice`, `active`,  `settings`, `type`) 
                SELECT `gateway`, `name`, `subject`, `message`, `to_staff`, `to_customer`, `to_admin`, `attach_ics`, `attach_invoice`, %d, %s, %s
                  FROM `' . $notifications_table . '` WHERE id = %d';
            $update_settings     = 'UPDATE `' . $notifications_table . '` SET `type` = %s, `settings`= %s, `active` = %d WHERE id = %d';
            $default_settings    = json_decode( '{"status":"any","option":2,"services":{"any":"any","ids":[]},"offset_hours":2,"perform":"before","at_hour":9,"before_at_hour":18,"offset_before_hours":-24,"offset_bidirectional_hours":0}', true );
            $records = $wpdb->get_results( $wpdb->prepare( 'SELECT id, `type`, `gateway`, `message`, `subject`, `active`, `settings` FROM `' . $notifications_table . '` WHERE `type` IN (' . implode( ', ', array_fill( 0, count( $notifications ), '%s' ) ) . ')', array_keys( $notifications ) ), ARRAY_A );
            foreach ( $records as $record ) {
                if ( ! isset( $notifications[ $record['type'] ]['type'] ) ) {
                    continue;
                }

                $clone_type = null;
                $new_type   = $notifications[ $record['type'] ]['type'];
                $new_active = $record['active'];
                $settings   = $default_settings;
                switch ( $record['type'] ) {
                    case 'client_waitlisted_appointment':
                        $settings['status'] = 'waitlisted';
                        $clone_type = ( $combined_notifications_disabled && $record['active'] ) ? 'ca_status_changed' : null;
                        $new_active = $combined_notifications_disabled ? $record['active'] : 0;
                        break;
                    case 'staff_waiting_list':
                        break;
                    case 'staff_waitlisted_appointment':
                        $settings['status'] = 'waitlisted';
                        $clone_type = $record['active'] ? 'ca_status_changed' : null;
                        break;
                }
                if ( $clone_type ) {
                    $wpdb->query( $wpdb->prepare( $insert_from_select, $new_active, json_encode( $settings ), $clone_type, $record['id'] ) );
                    $name = sprintf( '%s_%s_%d', $record['gateway'], $clone_type, $wpdb->insert_id );
                    do_action( 'wpml_register_single_string', 'bookly', $name, $record['message'] );
                    if ( $record['gateway'] == 'email' ) {
                        do_action( 'wpml_register_single_string', 'bookly', $name . '_subject', $record['subject'] );
                    }
                }
                $wpdb->query( $wpdb->prepare( $update_settings, $new_type, json_encode( $settings ), $new_active, $record['id'] ) );
            }
        } );

        foreach ( $disposable_options as $option_name ) {
            delete_option( $option_name );
        }
    }

    public function update_1_1()
    {
        $this->addL10nOptions( array(
            'bookly_l10n_info_time_step_waiting_list' => __( 'To join the waiting list for a busy time slot, please select a slot marked with "(N)", where N is a number of customers on the waiting list.', 'bookly' )
        ) );
    }
}