<?php
namespace BooklyWaitingList\Lib\Notifications\Assets\Test\ProxyProviders;

use Bookly\Lib\Notifications\Assets\Test\Codes;
use Bookly\Lib\Notifications\Assets\Test\Proxy;
use Bookly\Lib\Utils;

abstract class Shared extends Proxy\Shared
{
    /**
     * @inheritDoc
     */
    public static function prepareReplaceCodes( array $replace_codes, Codes $codes, $format )
    {
        $list = array(
            array(
                $codes->getOrder()->getCustomer()->getFullName(),
                $codes->getOrder()->getCustomer()->getEmail(),
                $codes->getOrder()->getCustomer()->getPhone(),
                'abctokenabcd',
            ),
            array(
                'Customer Name',
                'test@test.com',
                $codes->getOrder()->getCustomer()->getPhone() . '0',
                'cbatokendcba',
            ),
        );
        $waiting_list = '';
        foreach ( $list as $row ) {
            $row[3] = admin_url( 'admin-ajax.php?action=bookly_approve_appointment&token=' . urlencode( Utils\Common::xorEncrypt( $row[3], 'approve' ) ) );
            if ( $format == 'html' ) {
                $row[3] = sprintf( '<a href="%s">%s</a>', $row[3], __( 'Set appointment', 'bookly' ) );
                $waiting_list .= '<tr><td>' . implode( '</td><td>', $row ) . '</td></tr>';
            } else {
                $waiting_list .= implode( ' ', $row ) . PHP_EOL;
            }
        }
        if ( $format == 'html' ) {
            $replace_codes['appointment_waiting_list'] = '<table>' . $waiting_list . '</table>';
        } else {
            $replace_codes['appointment_waiting_list'] = $waiting_list ;
        }

        return $replace_codes;
    }
}