<?php
namespace BooklyWaitingList\Lib\Notifications\Test;

use Bookly\Lib\DataHolders\Booking\Order;
use Bookly\Lib\Entities\Appointment;
use Bookly\Lib\Entities\Customer;
use Bookly\Lib\Entities\CustomerAppointment;
use Bookly\Lib\Entities\Notification;
use Bookly\Lib\Entities\Service;
use Bookly\Lib\Entities\Staff;
use Bookly\Lib\Notifications\Base;
use BooklyPro\Lib\Notifications\Assets;
use Bookly\Lib\DataHolders\Booking\Simple;
use Bookly\Lib\Notifications\Assets\Test;

abstract class Sender extends Base\Sender
{
    public static function send( $to_email, Notification $notification, $codes, $attachments, $reply_to, $send_as, $from )
    {
        $customer = new Customer();
        if ( $notification->getType() === Notification::TYPE_FREE_PLACE_WAITING_LIST ||
            $notification->getType() === Notification::TYPE_STAFF_WAITING_LIST
        ) {
            $customer
                ->setCountry( 'Country' )
                ->setState( 'State' )
                ->setPostcode( '12345' )
                ->setCity( 'City' )
                ->setFullName( 'First_name Last_name' )
                ->setFirstName( 'First_name' )
                ->setLastName( 'Last_name' )
                ->setPhone( '+123456789' )
                ->setEmail( 'email@test.test' )
                ->setAdditionalAddress( '2a' )
                ->setBirthday( '2000-01-01' )
                ->setNotes( 'Note' )
                ->setStreet( 'Street' )
                ->setStreetNumber( '12' );

            $order = new Order( $customer );
            /** @var Service $service */
            $service = Service::query()->findOne();
            $service->setTitle( 'Service Name' );
            /** @var Staff $staff */
            $staff = Staff::query()->findOne();
            $staff->setFullName( 'Staff Name' );
            $appointment = new Appointment();
            $start = date_create()->modify( '7 days' )->setTime( 8, 0, 0 );
            $appointment
                ->setService( $service )
                ->setInternalNote( 'Internal note' )
                ->setCreatedAt( $start->format( 'Y-m-d H:i:s' ) )
                ->setCreatedFrom( 'backend' )
                ->setStaff( $staff )
                ->setService( $service )
                ->setStartDate( $start->format( 'Y-m-d H:i:s' ) )
                ->setEndDate( $start->modify( $service->getDuration() . ' sec' )->format( 'Y-m-d H:i:s' ) );
            $ca = new CustomerAppointment();
            $ca->setNotes( 'Notes' )
                ->setNumberOfPersons( '1' )
                ->setStatus( CustomerAppointment::STATUS_APPROVED )
                ->setToken( 'nice-token' )
                ->setAppointment( $appointment );

            $simple = Simple::create( $ca );
            $simple
                ->setService( $service )
                ->setStaff( $staff )
                ->setAppointment( $appointment )
                ->setStatus( CustomerAppointment::STATUS_APPROVED );

            $order->addItem( 0, $simple );

            $codes = new Test\Codes( $order );

            switch ( $notification->getType() ) {
                case Notification::TYPE_FREE_PLACE_WAITING_LIST:
                    if ( $notification->getToCustomer() ) {
                        static::_sendEmailTo(
                            self::RECIPIENT_CLIENT,
                            $to_email,
                            $notification,
                            $codes,
                            $attachments,
                            $reply_to,
                            $send_as,
                            $from
                        );
                    }
                    break;
                case Notification::TYPE_STAFF_WAITING_LIST:
                    static::_sendEmailTo(
                        self::RECIPIENT_STAFF,
                        $to_email,
                        $notification,
                        $codes,
                        $attachments,
                        $reply_to,
                        $send_as,
                        $from
                    );
                    break;
            }
        }


    }
}