<?php
namespace BooklyWaitingList\Lib\Notifications\WaitingList;

use Bookly\Lib\DataHolders\Booking as DataHolders;
use Bookly\Lib\Entities\Appointment;
use Bookly\Lib\Entities\Customer;
use Bookly\Lib\Entities\CustomerAppointment;
use Bookly\Lib\Entities\Staff;
use Bookly\Lib\Notifications\Assets\Item;
use Bookly\Lib\Notifications\Base;
use Bookly\Backend\Components\Dialogs\Queue\NotificationList;
use BooklyWaitingList\Lib\Notifications\Assets\WaitingList\Codes;

abstract class Sender extends Base\Sender
{
    /**
     * Send combined notifications to staff, admin and custom.
     *
     * @param Appointment $appointment
     * @param NotificationList|null  $queue
     */
    public static function send( Appointment $appointment, $queue = null )
    {
        $codes = new Codes( $appointment );

        if ( ! empty ( $codes->waiting_list ) ) {
            $notifications = static::getNotifications( 'staff_waiting_list' );

            // Notify staff and/or administrators.
            foreach ( $notifications['staff'] as $notification ) {
                static::sendToStaff( $codes->getItem()->getStaff(), $notification, $codes, null, null, $queue );
                static::sendToAdmins( $notification, $codes, null, null, $queue );
                static::sendToCustom( $notification, $codes, null, null, $queue );
            }
        }
    }

    /**
     * Send notifications about free place
     *
     * @param CustomerAppointment $ca
     * @param NotificationList|null $queue
     */
    public static function sendFreePlace( CustomerAppointment $ca, $queue = null )
    {
        $notifications = static::getNotifications( 'free_place_waiting_list' );
        if( $notifications['client'] || $notifications['staff'] ) {
            $item = DataHolders\Item::collect( $ca );
            $codes = new Item\Codes( DataHolders\Order::createFromItem( $item ) );
            if ( $notifications['client'] ) {
                $customer = Customer::find( $ca->getCustomerId() );
                $codes->prepareForItem( $item, 'client' );
                foreach ( $notifications['client'] as $notification ) {
                    static::sendToClient( $customer, $notification, $codes, null, $queue );
                }
            }
            if ( $notifications['staff'] ) {
                $staff = Staff::find( $item->getAppointment()->getStaffId() );
                // Notify staff and/or administrators.
                foreach ( $notifications['staff'] as $notification ) {
                    foreach ( $item->getItems() as $i ) {
                        $codes->prepareForItem( $i, 'staff' );
                        static::sendToStaff( $staff, $notification, $codes, null, null, $queue );
                        static::sendToAdmins( $notification, $codes, null, null, $queue );
                        static::sendToCustom( $notification, $codes, null, null, $queue );
                    }
                }
            }
        }
    }
}