<?php
namespace BooklyWaitingList\Lib\ProxyProviders;

use Bookly\Lib as BooklyLib;
use Bookly\Lib\Entities\Notification;

class Shared extends BooklyLib\Proxy\Shared
{
    /**
     * @inheritDoc
     */
    public static function prepareNotificationTitles( array $titles )
    {
        $titles[ Notification::TYPE_STAFF_WAITING_LIST ] = __( 'Notification for staff member to set up appointment from waiting list', 'bookly' );
        $titles[ Notification::TYPE_FREE_PLACE_WAITING_LIST ] = __( 'Notification to customer to set appointment from waiting list', 'bookly' );

        return $titles;
    }

    /**
     * @inheritDoc
     */
    public static function prepareNotificationTypes( array $types, $gateway )
    {
        $types[] = Notification::TYPE_STAFF_WAITING_LIST;
        $types[] = Notification::TYPE_FREE_PLACE_WAITING_LIST;

        return $types;
    }

    /**
     * @inheritDoc
     */
    public static function prepareColorsStatuses( array $statuses )
    {
        $statuses['waitlisted'] = get_option( 'bookly_appointment_status_waitlisted_color' );

        return $statuses;
    }
}