<?php

if ( !defined( 'ABSPATH' ) ) {
	exit();
}

function cryptoniq_coin_txs_trx( $wallet = '', $amount = '', $id = '', $print = '' )
{
    $request = cryptoniq_remote_get( 'TRX', $wallet );
    
    $output = array( 'found' => 0 );

	if ( is_wp_error( $request ) || wp_remote_retrieve_response_code( $request ) !== 200 ) {
		print_r( json_encode( $output ) );
		
		return;
	}
    
    $body = wp_remote_retrieve_body( $request );
	$content = json_decode( $body, true );
    
	$empty = 0;
	
	$order = wc_get_order( $id );
	if ( empty( $order ) || $order->get_status() == 'failed' || $order->get_status() == 'cancelled' ) {
		return; 
	}
			
	// time props
	$time_start = get_post_meta( $id, 'cryptoniq_time_start', true );
	$time_counter = 60 * 60 * 3;
	$time_end = $time_start + $time_counter;
	
	date_default_timezone_set('UTC');
	$time_current = time();
		   
	// amount make 8 numbers after digit
	$amount = str_replace( ',', '', $amount );
	$amount = number_format( (float) $amount, 6, '.', '' );
		
	$txs = $content['data'];
	
	if ( is_array( $txs ) ) {
		foreach ( $txs as $tx ) {
		    $tx_amount = number_format( (float) $tx['amount'] / 1000000, 6, '.', '' );
		    
			if ( !empty( $tx['contractData']['to_address'] ) && $tx['contractData']['to_address'] === $wallet && (float) $tx_amount === (float) $amount ) {
				$output = array(
					'found' => 1,
					'tx' => $tx['hash'],
					'conf' => 0,
					'completed' => 0,
					'expire' => 0,
					'amount' => $amount
				);
			
				// check it time expired
				if ( $time_current > $time_end || cryptoniq_check_txid( $tx['hash'], $id ) == 1 ) {
					if ( $time_current > $time_end ) {
						// time left
						$output['expire'] = 1;
								
						// update status
						Cryptoniq_AJAX::order_status_update( $id, 'failed' );								
					} elseif ( cryptoniq_check_txid( $tx['hash'], $id ) == 1 ) {
						// old transaction
						$output['expire'] = -1;								
					}			
				} else {
					if ( $tx['confirmed'] === true || $tx['confirmed'] === false ) {
						// update tx meta field
						cryptoniq_tx_data_update( $tx['hash'], $id );						
					}
					
					if ( $tx['confirmed'] === true ) {						
						$output['conf'] = 1;
						$output['completed'] = 1;
								
						// update status
						Cryptoniq_AJAX::order_status_update( $id );

						$output['status'] = 1;
						$output['redirect'] = apply_filters( 'woocommerce_checkout_no_payment_needed_redirect', $order->get_checkout_order_received_url(), $order );
					}
				}								
			}
		}
	}
		
	if ( $time_current > $time_end && $output['found'] != 1 ) {
		// time left
		$output['expire'] = 1;
								
		// update status
		Cryptoniq_AJAX::order_status_update( $id, 'failed' );					
	}
		
	if ( $print != 'no' ) {
		print_r( json_encode( $output ) );
	}
}