<?php

if ( !defined( 'ABSPATH' ) ) {
	exit();
}

function cryptoniq_get_currency_prices() {
	$license = get_option( 'cryptoniq_license' );
	$key = '';
	
	if ( $license && is_array( $license ) ) {
		if ( $license['key'] ) {
			$key = '?key=' . $license['key'];
		}
	}
	
	$url = 'https://api.cryptoniq.io/currencies' . $key;
    $request = wp_remote_get( $url );
		
	if( is_wp_error( $request ) ) {
		return false; 
	}

	$body = wp_remote_retrieve_body( $request );
	$coinslist = json_decode( $body, true );
	
	if ( !is_array( $coinslist ) || !array_key_exists( 'EUR', $coinslist ) ) {
		return false;
	}	
	
	return $coinslist;
}

function cryptoniq_get_coin_prices() {
	$license = get_option( 'cryptoniq_license' );
	$key = '';
	
	if ( $license && is_array( $license ) ) {
		if ( $license['key'] ) {
			$key = '?key=' . $license['key'];
		}
	}
	
	$url = 'https://api.cryptoniq.io/prices' . $key;
	$request = wp_remote_get( $url );
	
	if( is_wp_error( $request ) ) {
		return false; 
	}

	$body = wp_remote_retrieve_body( $request );
	$pricelist = json_decode( $body, true );
	
	if ( !is_array( $pricelist ) || !array_key_exists( 'BTC', $pricelist ) ) {
		return false;
	}
		
	return $pricelist;
}
	
function cryptoniq_get_price( $coin = 'BTC', $amount = '', $currency = '', $random = 'no' ) {
	if ( $amount == 0 ) {
		return '0.00000000';
	}
		
	$base_currency = get_woocommerce_currency();
	$currency_prices = get_option( 'cryptoniq_currency_prices' );
	$coin_prices = get_option( 'cryptoniq_coin_prices' );
		
	if ( $currency && array_key_exists( $currency, $currency_prices ) ) {
		$amount = $amount / $currency_prices[$currency];
	} elseif ( $base_currency && $base_currency != 'USD' && $base_currency != 'BTC' && array_key_exists( $base_currency, $currency_prices ) ) {
		$amount = $amount / $currency_prices[$base_currency];
	}
	
	if ( !empty( $coin ) && ( $coin == 'BTC' || $coin == 'ETH' || $coin == 'LTC' || $coin == 'BCH' || $coin == 'TRX' || $coin == 'DOGE' ) ) {
    	if ( $base_currency === 'BTC' ) {
        	$price = $amount;
        } else {
			$price = (float) $amount / (float) $coin_prices[$coin];
        }
	} else {
		return;
	}
	
	if ( $coin == 'TRX' ) {
		$round_length = 1000000;
	} else {
		$round_length = 100000000;		
	}
	
	// Calc Formula		
	$extra_random_number = ( $random == 'yes' ) ? rand( 100, 999 ) / $round_length : 0;
    
    if ( $base_currency === 'BTC' ) {
		$coins_num = $price;
    } else {
    	$coins_num = (float) $price + (float) $extra_random_number;
    }
	
	if ( $coin == 'TRX' ) {
		$coins_num = number_format( (float) $coins_num, 6, '.', '' );		
	} else {
		$coins_num = number_format( (float) $coins_num, 8, '.', '' );
	}
	
	return $coins_num;
}