<?php
if (!defined('ABSPATH')) {
    exit;
}


function celp_cleanOldData()
{
    $cache = get_transient('celp_coin_pairs_housecleaning', false);
    if ($cache === false) {
        $exchanges_pair = new CELP_Exchanges_Pairs();
        $exchanges_pair->clear_old_exchanges_pair();
        set_transient('celp_coin_pairs_housecleaning', "Last run: " . date('Y-M-d H:I'), DAY_IN_SECONDS);
    }
}
// Function to get the CoinGecko API key
function get_coingecko_api_key_celp() {
    $api_option = get_option("openexchange-api-settings");
    $api_key =(isset($api_option['coingecko_api'])) ? $api_option['coingecko_api'] : ""; // Default API key
    $api_key = apply_filters('coingecko_api_key', $api_key);
    return $api_key;
}

function celp_load_assets($page = '')
{
    // Loading only required css and js files
    //loading assets

    wp_enqueue_style('celp-styles', CELP_URL . 'assets/css/celp-styles.css', null, CELP_VERSION);
    wp_enqueue_style('cmc-icons', CELP_URL . 'assets/css/cmc-icons.min.css', null, CELP_VERSION);
    wp_enqueue_style('cmc-bootstrap', CELP_URL . 'assets/css/bootstrap.min.css', null, CELP_VERSION);
    wp_enqueue_script('celp-tabel-sort', CELP_URL . 'assets/js/tablesort.min.js', array('jquery', 'cmc-datatables'), CELP_VERSION, false);

    wp_enqueue_script('cmc-datatables', CELP_URL . 'assets/js/jquery.dataTables.min.js', null, CELP_VERSION);
    wp_enqueue_script('cmc-custom-fixed-col', CELP_URL . 'assets/js/tableHeadFixer.js', array('jquery', 'cmc-datatables'), CELP_VERSION, true);
    wp_enqueue_script('numeraljs', CELP_URL . 'assets/js/numeral.min.js', array('jquery'), CELP_VERSION, false);
    if ($page === "coin_single") {
        wp_enqueue_script('celp-coin-ex-list', CELP_URL . 'assets/js/celp-coin-ex-list.js', array('jquery', 'cmc-datatables'), CELP_VERSION, false);
        wp_localize_script(
            'celp-coin-ex-list',
            'ajax_object',
            array('ajax_url' => admin_url('admin-ajax.php'), 'nonce' => wp_create_nonce('celp-ex-list'))
        );
    } else if ($page == "ex_single") {

        wp_enqueue_script('celp-advance-tabs', CELP_URL . 'assets/js/celp-advanced-tab.js', array('jquery', 'cmc-datatables', 'celp-ex-pairs'), CELP_VERSION, false);
        wp_localize_script(
            'celp-advance-tabs',
            'ajax_object',
            array('ajax_url' => admin_url('admin-ajax.php'), 'nonce' => wp_create_nonce('celp-ex-list'))
        );

        wp_enqueue_script('celp-ex-pairs', CELP_URL . 'assets/js/celp-ex-pairs.js', array('jquery', 'cmc-datatables'), CELP_VERSION, false);
        wp_localize_script(
            'celp-ex-pairs',
            'ajax_object',
            array('ajax_url' => admin_url('admin-ajax.php'), 'nonce' => wp_create_nonce('celp-ex-list'))
        );
    } else {
        wp_enqueue_script('celp-dt-absolute', CELP_URL . 'assets/js/absolute.js', array('jquery', 'cmc-datatables'), CELP_VERSION);
        wp_enqueue_script('celp-ex-list', CELP_URL . 'assets/js/celp-ex-list.js', array('jquery', 'cmc-datatables'), CELP_VERSION, false);
        wp_localize_script(
            'celp-ex-list',
            'ajax_object',
            array('ajax_url' => admin_url('admin-ajax.php'), 'nonce' => wp_create_nonce('celp-ex-list'))
        );
    }
}

function celp_get_all_exchanges()
{
    $db_data = new CELP_Exchanges();
    $resluts = $db_data->get_all_exchanges();
    $arr = array();
    if (gettype($resluts) == 'array') {
        foreach ($resluts as $key => $index) {
            $arr[] = $index;
        }
        return $arr;
    } else {
        return false;
    }
}

/**
 * Fetching Exchange id from coin market cap to display exchange list in setting panel
 */
function celp_get_exchange_id_api_data()
{
    $e_list = array();
    $e_list_api_response = celpobjecttoarray(celp_get_all_exchanges());
    //$e_list_api_response==array();

    if (!empty($e_list_api_response) && is_array($e_list_api_response)) {
        foreach ($e_list_api_response as $e_api_response => $index) {
            $e_list[$index['ex_id']] = $index['name'];

        }
        return $e_list;
    } else {
        return false;
    }
}

// converting object to array
function celpobjectToArray($d)
{
    if (is_object($d)) {
        // Gets the properties of the given object
        // with get_object_vars function
        $d = get_object_vars($d);
    }

    if (is_array($d)) {
        /*
         * Return array converted to object
         * Using __FUNCTION__ (Magic constant)
         * for recursive call
         */
        return array_map(__FUNCTION__, $d);
    } else {
        // Return array
        return $d;
    }
}

function celp_format_number($number)
{
    $decimalplaces = 2;
    $decimalcharacter = '.';
    $thousandseparater = ',';
    if ($number < 0.50) {
        $decimalplaces = 6;
    }
    return number_format($number, $decimalplaces, $decimalcharacter, $thousandseparater);
}

// get affilite links
function get_custom_content($ex_id)
{

    $args = array(
        'post_type' => 'celp',
        'meta_query' => array(
            array(
                'key' => 'custom_ex_id',
                'value' => $ex_id,
            ),
        ));

    $content = array();
    $postslist = get_posts($args);
    if ($postslist) {
        foreach ($postslist as $post) {
            setup_postdata($post);
            $post_id = $post->ID;
            $formatted_content = celp_get_wysiwyg_output('custom_description', $post_id);
            $content['desc'] = $formatted_content;
            $content['affiliate_link'] = get_post_meta($post_id, 'affiliate_link', true);
        }

        return $content;
    } else {
        return false;
    }

}

// get all custom affilate links
function get_all_affilate_links()
{
    $args = array(
        'post_type' => 'celp',
        'numberposts' => '-1',
    );
    $content = array();
    $postslist = get_posts($args);
    if ($postslist) {
        foreach ($postslist as $post) {
            setup_postdata($post);
            $post_id = $post->ID;
            $ex_id = get_post_meta($post_id, 'custom_ex_id', true);
            $content[$ex_id]['affiliate_link'] = get_post_meta($post_id, 'affiliate_link', true);
        }
        return $content;
    } else {
        return false;
    }
}

function celp_get_wysiwyg_output($meta_key, $post_id = 0)
{
    global $wp_embed;

    $post_id = $post_id ? $post_id : get_the_id();

    $content = get_post_meta($post_id, $meta_key, 1);
    $content = $wp_embed->autoembed($content);
    $content = $wp_embed->run_shortcode($content);
    $content = wpautop($content);
    $content = do_shortcode($content);

    return $content;
}

// currencies symbol
function celp_fiat_cur_symbol($name)
{
    $cc = strtoupper($name);
    $currency = array(
        "USD" => "&#36;", //U.S. Dollar
        "AUD" => "&#36;", //Australian Dollar
        "BRL" => "R&#36;", //Brazilian Real
        "CAD" => "C&#36;", //Canadian Dollar
        "CZK" => "K&#269;", //Czech Koruna
        "DKK" => "kr", //Danish Krone
        "EUR" => "&euro;", //Euro
        "HKD" => "&dollar;", //Hong Kong Dollar
        "HUF" => "Ft", //Hungarian Forint
        "ILS" => "&#x20aa;", //Israeli New Sheqel

        "INR" => "&#8377;", //Indian Rupee
        "JPY" => "&yen;", //Japanese Yen
        "MYR" => "RM", //Malaysian Ringgit
        "MXN" => "&#36;", //Mexican Peso
        "NOK" => "kr", //Norwegian Krone
        "NZD" => "&#36;", //New Zealand Dollar
        "PHP" => "&#x20b1;", //Philippine Peso
        "PLN" => "&#122;&#322;", //Polish Zloty
        "GBP" => "&pound;", //Pound Sterling
        "SEK" => "kr", //Swedish Krona

        "CHF" => "Fr ", //Swiss Franc
        "TWD" => "NT&#36;", //Taiwan New Dollar
        "THB" => "&#3647;", //Thai Baht
        "TRY" => "&#8378;", //Turkish Lira

        "CNY" => "&yen;", //China Yuan Renminbi
        'KRW' => "&#8361;", //Korea (South) Won
        'RUB' => "&#8381;", //Russia Ruble
        'SGD' => "S&dollar;", //Singapore Dollar
        'CLP' => "&dollar;", //Chile Peso
        'IDR' => "Rp ", //Indonesia Rupiah
        'PKR' => "₨ ", //Pakistan Rupee
        'ZAR' => "R ", //South Africa Rand
        'BTC' => '&#579;',
    );

    if (array_key_exists($cc, $currency)) {
        return $currency[$cc];
    }
}

// date formating
function get_timeago($ptime)
{
    $estimate_time = time() - $ptime;

    if ($estimate_time < 1) {
        return __('less than 1 second ago', 'celp');
    }

    $condition = array(
        12 * 30 * 24 * 60 * 60 => __('year ', 'celp'),
        24 * 60 * 60 => __('day', 'celp'),
        60 * 60 + 60 * 60 => __('hours ago', 'celp'),
        60 * 60 => __('hour ago', 'celp'),
        60 + 60 => __('minutes ago', 'celp'),
        60 => __('minute ago', 'celp'),
        1 + 1 => __('seconds ago', 'celp'),
        1 => __('second ago', 'celp'),

    );

    foreach ($condition as $secs => $str) {
        $d = $estimate_time / $secs;
        if ($d >= 1) {
            $r = round($d);
            return $r . ' ' . $str;
        }
    }
}

function celp_selected_currency()
{
    $currency = array();
    if (celp_get_option('fiat_currency')) {
        $selected_currency = celp_get_option('fiat_currency');
        $all_prices = CELP_api_data::celp_usd_conversions('all');
        $currency_price = $all_prices[$selected_currency];
    } else {
        $selected_currency = "USD";
        $all_prices = CELP_api_data::celp_usd_conversions('all');
        $currency_price = $all_prices[$selected_currency];
    }

    $currency['c_name'] = $selected_currency;
    $currency['c_price'] = $currency_price;
    return $currency;
}

/*--------------------------------------------------------------|
|                                                                  |
|  Find exchange by id                                            |
|   check for both 'enable' and 'disable' exchanges             |
|---------------------------------------------------------------|
 */
function celp_get_exchange_by_id($ex_id = null)
{
    $DB = new CELP_Exchanges();
    $exchange = $DB->get_exchanges(array('ex_id' => $ex_id, 'exchange_status' => 'enable'));
    if ($exchange != null) {
        return $exchange;
    } else {
        $exchange = $DB->get_exchanges(array('ex_id' => $ex_id, 'exchange_status' => 'disable'));
        if ($exchange != null) {
            // return the exchange as a single array
            return $exchange;
        }
    }
}

/*-----------------------------------------------------------------------|
|    Fetch all custom exchange description created at admin dashboard     |
|------------------------------------------------------------------------|
 */
function celp_fetch_custom_exchanges()
{

    $custom_ex = array(
        'post_type' => 'celp',
        'posts_per_page' => '-1',
    );
    $exists = new WP_Query($custom_ex);
    $already_exists = array();
    while ($exists->have_posts()) {
        $exists->the_post();
        $ex_id = get_post_meta(get_the_ID(), 'custom_ex_id', true);
        $already_exists[] = $ex_id;
    }
    wp_reset_postdata();
    return $already_exists;
}

function celp_get_single_page_id()
{

    $fresh_install = get_option('celpt-new-install');
    if ($fresh_install == false) {
        $get_type = celp_get_option('exchanges_single_page');
        $design = (isset($get_type)&&!empty($get_type)) ? $get_type : 'advance-design';
        $page_id = ($design == "advance-design") ? get_option('celp-advance-tabs-page-id') : get_option('ex-single-page-id');
        return $page_id;
    } else {
        $get_type = celp_get_option('exchanges_single_page');
        $design = !empty($get_type) ? $get_type : 'advance-design';
        $page_id = ($design == "advance-design") ? get_option('celp-advance-tabs-page-id') : get_option('ex-single-page-id');
        return $page_id;
    }
}

function celp_get_exchange_logo($ex_id)
{
    global $wpdb;
    $ex_table = $wpdb->base_prefix . 'celp_exchanges';
    $query = $wpdb->prepare("SELECT extra_data FROM {$ex_table} WHERE ex_id = %s", $ex_id);
    $response = $wpdb->get_results($query);
    $logo = '';

    if (!empty($response)) {
        $data = celpobjectToArray($response[0]);
        $logo_data = json_decode($data['extra_data'], true);
        $logo = isset($logo_data['logo']) ? $logo_data['logo'] : '';
    }

    return $logo;
}
function celp_check_required_settings()
{
    // Don't run any database update if transient is saved (even if expired)
    $fresh_install = get_option('celpt-new-install');
    $get_license = get_option('celp_license_registration');
    $purchased_code = isset($get_license["celp-purchase-code"]) ? $get_license["celp-purchase-code"] : '';
    $api_option = get_option("openexchange-api-settings");
    $coingecko_api_key = get_coingecko_api_key_celp();
    $coingecko_api_key = ($fresh_install) ? $coingecko_api_key : 'true';
    if (!empty($purchased_code) && !empty($coingecko_api_key)) {
        return true;
    } else {
        return false;
    }
}
function celp_track_coingecko_api_hit()
{
    $api_hits = get_option('cmc_coingecko_api_hits');
    if ($api_hits === false) {
        // Option doesn't exist, so initialize it with a value of 0
        add_option('cmc_coingecko_api_hits', 0);
    }
    $api_hits = (int) $api_hits + 1; // Increment the value by 1
    update_option('cmc_coingecko_api_hits', $api_hits);
}

/**
 * This function is useful for getting exid from old to new.
 *
 */
function celp_get_new_exchange_id($ex_id)
{
    $updated_exchanges = array(
        "zb-com" => "zb",
        "waves-dex" => "waves",
        "tux-exchange" => "tux_exchange",
        "trade-satoshi" => "trade_satoshi",
        "tradeogre" => "trade_ogre",
        "token-store" => "thetokenstore",
        "stocks-exchange" => "stocks_exchange",
        "southxchange" => "south_xchange",
        "radar-relay" => "radar_relay",
        "neraexpro" => "neraex",
        "negocie-coins" => "negociecoins",
        "mercado-bitcoin" => "mercado_bitcoin",
        "lykke-exchange" => "lykke",
        "litebit" => "litebiteu",
        "kyber-network" => "kyber_network",
        "instant-bitex" => "instantbitex",
        "infinitycoin-exchange" => "infinity_coin",
        "gate-io" => "gate",
        "fexpro" => "fex",
        "cryptobridge" => "crypto_bridge",
        "coinexchange" => "coin_exchange",
        "coinegg" => "coin_egg",
        "cex-io" => "cex",
        "c-cex" => "ccex",
        "c-patex" => "c_patex",
        "bx-thailand" => "bx_thailand",
        "btc-markets" => "btcmarkets",
        "btc-trade-ua" => "btc_trade_ua",
        "btc-alpha" => "btc_alpha",
        "bits-blockchain" => "bits_blockchain",
        "bancor-network" => "bancor",
    );

    if (array_key_exists($ex_id, $updated_exchanges)) {
        return $updated_exchanges[$ex_id];
    } else {
        return $ex_id;
    }
}

/**
 * Wrapper function around cmb2_get_option
 * @since  0.1.0
 * @param  string $key     Options array key
 * @param  mixed  $default Optional default value
 * @return mixed           Option value
 */
function celp_get_option($key = '', $default = false)
{
    if (function_exists('cmb2_get_option')) {
        // Use cmb2_get_option as it passes through some key filters.
        return cmb2_get_option('celp_options', $key, $default);
    }

    // Fallback to get_option if CMB2 is not loaded yet.
    $opts = get_option('celp_options', $default);

    $val = $default;

    if ('all' == $key) {
        $val = $opts;
    } elseif (is_array($opts) && array_key_exists($key, $opts) && false !== $opts[$key]) {
        $val = $opts[$key];
    }

    return $val;
}
function celp_get_api_end_point()
{
    // Get coingecko api end point

    $api_option = get_option("openexchange-api-settings");
    $endpoint = (isset($api_option['api_end_point'])) ? $api_option['api_end_point'] : "free";
    if ($endpoint == "pro") {
        return "https://pro-api.coingecko.com/api/v3/";
    } else {
        return "https://api.coingecko.com/api/v3/";
    }

}
function celp_get_api_key_end_point()
{
    // Get coingecko api end point

    $api_option = get_option("openexchange-api-settings");
    $endpoint = (isset($api_option['api_end_point'])) ? $api_option['api_end_point'] : "free";
    if ($endpoint == "pro") {
        return "X-Cg-Pro-Api-Key";
    } else {
        return "x_cg_demo_api_key";
    }

}
function celp_check_api_errors($api_data)
{
    // Get coingecko api end point
    $error_codes = [429, 10006, 403];
    if (isset($api_data['response']['code']) && in_array($api_data['response']['code'], $error_codes)) {
        return true;
    } else {
        return false;
    }

}

function decentralized_coin_array()
{
    $decentralized = array(
        "Uniswap (v3)", "Curve (Ethereum)", "DODO", "PancakeSwap (v2)", "Uniswap (Polygon)",
        "Uniswap (v2)", "Uniswap (Arbitrum One)", "SUN.io", "Sushiswap", "Quipuswap",
        "Uniswap (Optimism)", "Jupiter", "Osmosis", "THORSwap", "Orca", "Shibaswap", "Quickswap",
        "Dodo (Polygon)", "Dodo (BSC)", "Serum DEX", "Raydium", "Biswap", "Trader Joe", "Idex", "Sushiswap (Arbitrum One)",
        "Kyberswap Elastic (Polygon)", "ZigZag (Arbitrum)", "Saber", "Velodrome Finance", "Bancor (V2)", "Platypus Finance", "SpookySwap", "Mdex", "
        WOOFi", "LFGswap", "VVS Finance", "Mango Markets", "Maiar", "Katana", "Hermes Protocol", "4swap", "TempleDAO", "Helix", "MMFinance (Cronos)", "
        Ref Finance", "Bancor (V2)", "Tinyman", "Pangolin", "Dodo (Arbitrum)", "Mdex BSC", "Beethoven X", "Curve (Arbitrum)", "Curve (Avalanche)",
        "Curve (Polygon)", "Bancor (V3)", "Balancer (v1)", "ApeSwap", "MMFinance (Polygon)", "Nomiswap", "ZigZag (zkSync v1)", "OpenOcean", "Kwenta",
        "Sushiswap (Polygon POS)", "KnightSwap", "Trisolaris", "StellaSwap", "Beamswap", "Acala Swap", "Curve (Fantom)", "SpiritSwap", "Bisq", "
        Netswap", "Balancer (Polygon)", "Terraswap", "Energiswap", "Loopring AMM", "Sushiswap (Avalanche)", "Clipper (Ethereum)", "BabySwap", "Dfyn", "
        Yoshi.exchange (Fantom)", "Dystopia", "MojitoSwap", "Curve (Xdai)", "FlatQube", "Solarbeam", "Tomb Swap (Fantom)", "ApeSwap (Polygon)",
        "Kyberswap Elastic (Arbitrum)", "Polkaswap", "Sundaeswap", "Step Exchange", "Swop.Fi", "DOOAR (BSC)", "Kujira Fin", "Defi Kingdoms (Crystalvale)",
        "SpiritSwap (V2)", "Clipper (Polygon)", "UniWswap", "Saros Finance", "Solidly", "Balancer (Arbitrum)", "Sifchain", "DeFi Swap", "Tethys Finance",
        "KyberSwap Elastic (Ethereum)", "Claimswap", "Kava Swap", "OpenLeverage", "Crescent", "Clipper (Optimism)", "Powswap", "KyberSwap Classic (Polygon)", "
        Binance DEX (Mini)", "Swapr (Xdai)", "Defi Kingdoms", "WanSwap", "Balanced Network", "Kaidex", "Kyberswap Elastic (Optimism)", "WagyuSwap", "Loopring", "
        Karura Swap", "Quickswap (Dogechain)", "Diffusion Finance", "Curve (Optimism)", "LIF3", "ZilSwap", "CherrySwap", "RadioShack (Polygon)",
        "KyberSwap Classic (BSC)", "ProtoFi", "Ubeswap", "KibbleSwap", "ALEX", "Mimo", "StellarTerm", "ViteX", "Jswap", "ArthSwap", "DAO Swap", "Planet Finance", "LeonicornSwap", "Yokaiswap", "
        Pangolin (Songbird)", "Capricorn", "
        Swappi", "Loop Markets", "Elk Finance (Polygon)", "Makiswap", "Sphynx (Brise)", "
        SharkSwap", "DFX", "KyberSwap Classic (Ethereum)", "Cronaswap", "SecretSwap", "SWYCH", "
        Elk Finance (BSC)", "Baryon Network", "Voltage Finance", "
        RadioShack (BSC)", "Dark KnightSwap", "Yoshi.exchange (BSC)", "Hebeswap", "ComethSwap", "
        Tranquil Finance", "
        Honeyswap", "
        Polycat Finance", "Swapr (Arbitrum)", "Sushiswap (Arbitrum Nova)", "
        Luaswap", "Swapr (Ethereum)", "1inch Liquidity Protocol", "DefiPlaza", "DOOAR (Ethereum)", "
        Siennaswap", "
        Muesliswap", "Bakeryswap", "Muesliswap (Milkada)", "Sushiswap (Harmony)", "
        Tetuswap", "
        KyberSwap Classic (Avalanche)", "Kuswap", "Nexus Mutual", "
        Prism Protocol", "
        Hydra DEX", "Sushiswap (xDai)", "
        RadioShack (Ethereum)", "
        Crodex", "Glide Finance", "
        Sushiswap (BSC)", "
        Pegasys", "
        RCP Swap", "DFX (Polygon)", "
        Spartan Protocol", "Wigoswap", "Elk Finance (Avalanche)", "
        Yodeswap", "
        Demex", "Sushiswap (Fantom)", "
        Voltswap (Meter)", "
        Zenlink (Moonbeam)", "Wannaswap", "Oolongswap", "
        ZipSwap", "
        KDSwap", "DogeSwap", "Zenlink (Moonriver)", "RadioShack (Avalanche)", "Soulswap", "Acsi Finance", "
        Solarflare", "
        Sphynx Swap (BSC)", "NearPAD", "
        Mars Ecosystem", "
        Impossible Finance", "
        Julswap", "Fraxswap (Ethereum)", "OccamX", "
        Excalibur", "Newdex", "
        Kaidex V3", "
        Sushiswap Celo", "MilkySwap", "Zappy", "Kyberswap Elastic (BSC)", "EvmoSwap", "
        Dexalot", "
        Zenlink (Astar)", "
        PolyDEX", "NachoSwap", "
        Honeyswap (Polygon)", "
        Benswap", "
        Rhino.fi", "Paintswap", "
        Huckleberry", "Lydia Finance", "HakuSwap", "
        OmniDex", "Cronus Finance", "
        FuzzSwap", "
        TangoSwap", "Aave", "ViperSwap", "
        PolyZap", "Elk Finance (Ethereum)", "Fairyswap", "Morpheus Swap", "
        Firebird Finance (Polygon)", "AutoShark Finance", "
        Concave", "Fx Swap", "
        PhotonSwap (Cronos)", "
        Greenhouse", "vSwap BSC", "
        Spice Trade (Avalanche)", "Verse DEX", "
        DuckyDeFi", "Levinswap (xDai)", "
        Terraformer", "SakeSwap", "Tropical Finance", "
        Baguette", "
        OpenSwap", "
        AuroraSwap", "
        Amaterasu Finance", "Astroport (Classic)", "Thorus", "
        PuddingSwap", "
        Nash", "Unicly", "1BCH", "
        PinkSwap", "Elk Finance (Telos)", "
        Algebra finance", "Dogeshrek", "EmpireDEX (BSC)", "EmpireDEX (Cronos)", "
        PolkaEx (Shiden)", "
        0x Protocol", "
        Balancer (v2)", "
        Tokenlon", "WaultSwap Polygon", "PhotonSwap (Kava)", "TokenSets", "
        OasisDEX", "KyberSwap Classic (Fantom)", "dYdX", "
        Binance DEX", "
        Orderbook.io", "1inch Liquidity Protocol (BSC)", "Clipper (Moonbeam)", "
        Mistswap", "JetSwap", "
        Kyberswap Elastic (Fantom)", "ShibSwap", "
        Tenderswap", "
        BossSwap", "
        Step Finance", "
        Crema Finance", "0x Protocol", "XCAD DEX",

    );
    return $decentralized;
}

function centralized_coin_array()
{
    $centralized_array = array("Binance", "Coinbase Exchange", "
    KuCoin", "OKX", "FTX", "
    Gate.io", "Bybit", "
    Huobi Global", "
    Kraken", "
    Binance US", "Crypto.com Exchange", "FTX.US", "AscendEX (BitMax)", "Bitfinex", "
    Gemini", "
    MEXC Global", "Dex-Trade", "AAX", "
    XT.COM", "
    Bitrue", "BKEX", "
    BitMart", "
    LBank", "Digifinex", "
    BingX", "Coinsbit", "BigONE", "
    P2B", "WhiteBIT", "BTCEX", "Coinstore", "
    LATOKEN", "
    Bitget", "
    FTX TR", "Phemex", "
    BTSE", "Bullish", "Bitforex", "Hotbit", "
    Bit.com", "Bitstamp", "
    BtcTurk PRO", "WOO Network", "EXMO", "
    Poloniex", "
    bitFlyer", "
    Okcoin", "Bitso", "
    KickEX", "
    Cryptology", "
    Bitkub", "
    Bitbank", "
    CoinEx", "Blockchain.com", "Coinfield", "
    Luno", "
    Max Maicoin", "Emirex", "BitMEX", "Coinmetro", "Delta Exchange", "
    Upbit", "Bibox", "
    FMFW.io", "
    Tidex", "
    Bithumb", "
    Currency.com", "Coinone", "Paribu", "
    Coincheck", "
    Bilaxy", "ExMarkets", "Tokpie", "
    Bittrex", "Nominex", "BitBNS", "
    BTCBOX", "
    Indodax", "
    GMO Japan", "Bitazza", "Independent Reserve", "
    BitoPro", "Korbit", "CEX.IO", "
    Bitpanda Pro", "BTCMarkets", "Zaif", "
    Coinlist", "
    Foxbit", "
    NiceHash", "
    HitBTC", "
    ProBit Global", "
    Catex", "
    Bitvavo", "
    FinexBox", "
    BitGlobal", "Bitexen", "
    Omgfin", "STEX", "
    TokoCrypto", "
    Kanga", "
    ZBX", "
    Bitci", "NovaDAX", "WazirX", "Mercado Bitcoin", "
    Coinzoom", "Kuna Exchange", "
    Bitubu Exchange", "
    CoinDCX", "TheRockTrading", "
    ChainEX", "
    BTCSquare", "
    CoinTiger", "Vindax", "
    BitGlobal", "Tokenize", "B2BX", "
    Stormgain", "Liquid", "CoinJar Exchange", "
    Huobi Japan", "ZebPay", "Bitbuy", "
    Waves.Exchange", "
    Bitlo", "
    Globe", "
    Birake", "
    Flybit", "
    Lykke", "BTC Trade UA", "
    BuyUcoin", "
    qTrade", "BitHash", "Chiliz", "
    CITEX", "
    Dcoin", "
    Biconomy", "YoBit", "BTC-Alpha", "Oceanex", "
    Changelly PRO", "
    Mercatox", "
    AlterDice", "
    FatBTC", "Txbit", "
    Resfinex", "
    Zonda", "
    GoPax", "
    BitStorage", "
    Coindeal", "Narkasa", "
    TradeOgre", "
    Bitsten", "
    Graviex", "
    Aprobit", "
    SouthXchange", "Probit (Korea)", "BITEXBOOK", "
    Bgogo", "
    Koinbazar", "
    Bitoffer", "
    BiONE", "Huobi Korea", "Bitexlive", "
    C-Patex", "
    CoinMargin", "
    Nami.Exchange", "
    CBX", "Satang Pro", "
    itBit", "
    Graviex", "Freiexchange", "
    Hanbitco", "
    Azbit", "
    BITFRONT", "
    CREX24", "SafeTrade", "
    BTX", "
    Unnamed", "
    Altmarkets", "
    CoinEgg", "
    BitOnBay", "
    Yunex.io", "LocalTrade", "Upbit Indonesia", "
    AEX", "
    Bitinka.com", "
    ABCC", "
    LCX Exchange", "
    Powertrade", "
    AltcoinTrader", "
    Zipmex", "
    Bitfex", "Paymium", "Btc Exchange", "
    Zebitex", "Bit2c", "
    SINEGY", "Coingi", "
    Beaxy", "
    Coinfalcon", "
    Velic", "
    BW.com", "
    GDAC", "TOKOK", "
    ZBG", "
    Negociecoins", "
    Tokenomy", "
    eToro", "CoinBene", "BitKonan", "
    C-CEX", "
    Ovex", "
    Decoin", "
    GokuMarket", "
    EQONEX", "Paritex", "
    BTCC", "
    Purcow");

    return $centralized_array;
}

function celp_coin_array($coin_id, $flip = false)
{
    $coin_list = array(

        'btc-bitcoin' => 'bitcoin',
        'eth-ethereum' => 'ethereum',
        'usdt-tether' => 'tether',
        'usdc-usd-coin' => 'usd-coin',
        'bnb-binance-coin' => 'binancecoin',
        'busd-binance-usd' => 'binance-usd',
        'xrp-xrp' => 'ripple',
        'ada-cardano' => 'cardano',
        'sol-solana' => 'solana',
        'doge-dogecoin' => 'dogecoin',
        'dot-polkadot' => 'polkadot',
        'shib-shiba-inu' => 'shiba-inu',
        'dai-dai' => 'dai',
        'steth-lido-staked-ether' => 'staked-ether',
        'matic-polygon' => 'matic-network',
        'trx-tron' => 'tron',
        'avax-avalanche' => 'avalanche-2',
        'wbtc-wrapped-bitcoin' => 'wrapped-bitcoin',
        'leo-leo-token' => 'leo-token',
        'etc-ethereum-classic' => 'ethereum-classic',
        'okb-okb' => 'okb',
        'ltc-litecoin' => 'litecoin',
        'ftt-ftx-token' => 'ftx-token',
        'atom-cosmos' => 'cosmos',
        'link-chainlink' => 'chainlink',
        'cro-cryptocom-chain' => 'crypto-com-chain',
        'near-near-protocol' => 'near',
        'uni-uniswap' => 'uniswap',
        'xlm-stellar' => 'stellar',
        'xmr-monero' => 'monero',
        'bch-bitcoin-cash' => 'bitcoin-cash',
        'algo-algorand' => 'algorand',
        'flow-flow' => 'flow',
        'xrd-radix' => 'radix',
        'arb-arbitrum' => 'arbitrum',
        'xcn-chain' => 'chain-2',
        'vet-vechain' => 'vechain',
        'icp-internet-computer' => 'internet-computer',
        'fil-filecoin' => 'filecoin',
        'eos-eos' => 'eos',
        'snx-synthetix-network-token' => 'synthetix-network-token',
        'frax-frax' => 'frax',
        'ape-apecoin' => 'apecoin',
        'hbar-hedera-hashgraph' => 'hedera-hashgraph',
        'sand-the-sandbox' => 'the-sandbox',
        'mana-decentraland' => 'decentraland',
        'xtz-tezos' => 'tezos',
        'toncoin-the-open-network' => 'the-open-network',
        'qnt-quant' => 'quant-network',
        'axs-axie-infinity' => 'axie-infinity',
        'egld-elrond' => 'elrond-erd-2',
        'chz-chiliz' => 'chiliz',
        'aave-new' => 'aave',
        'theta-theta-token' => 'theta-token',
        'lend-ethlend' => 'ethlend',
        'tusd-trueusd' => 'true-usd',
        'bsv-bitcoin-sv' => 'bitcoin-cash-sv',
        'usdp-paxos-standard-token' => 'paxos-standard',
        'ldo-lido-dao' => 'lido-dao',
        'kcs-kucoin-token' => 'kucoin-shares',
        'btt-bittorrent' => 'bittorrent',
        'zec-zcash' => 'zcash',
        'hbtc-huobi-btc' => 'huobi-btc',
        'miota-iota' => 'iota',
        'ht-huobi-token' => 'huobi-token',
        'grt-the-graph' => 'the-graph',
        'hnt-helium' => 'helium',
        'usdd-usdd' => 'usdd',
        'klay-klaytn' => 'klay-token',
        'xec-ecash' => 'ecash',
        'ftm-fantom' => 'fantom',
        'mkr-maker' => 'maker',
        'usdn-neutrino-usd' => 'neutrino',
        'neo-neo' => 'neo',
        'gt-gatechain-token' => 'gatechain-token',
        'paxg-pax-gold' => 'pax-gold',
        'rune-thorchain' => 'thorchain',
        'bit-bitdao' => 'bitdao',
        'wbt-whitebit' => 'whitebit',
        'ceth-compound-ether' => 'compound-ether',
        'ar-arweave' => 'arweave',
        'rlb-rollbit-coin' => 'rollbit-coin',
        'mura-murasaki' => 'murasaki',
        'zil-zilliqa' => 'zilliqa',
        'usx-dforce-usd' => 'token-dforce-usd',
        'flr-flare-network' => 'flare-network',
        'cusdc-compound-usd-coin' => 'compound-usd-coin',
        'nxm-nexum' => 'nxm',
        'mask-mask-network' => 'mask-network',
        'dfi-defi-chain' => 'defichain',
        'nvir-nvirworld' => 'nvirworld',
        'phb-red-pulse-phoenix' => 'red-pulse',
        'wemix-wemix-token' => 'wemix-token',
        'plt-poollottofinance' => 'poollotto-finance',
        'blur-blur' => 'blur',
        'bdx-beldex' => 'beldex',
        'astr-astar' => 'astar',
        'azero-aleph-zero' => 'aleph-zero',
        'ethw-ethereum-pow' => 'ethereum-pow-iou',
        'okt-okc-token' => 'oec-token',
        'floki-floki-inu' => 'floki',
        'cake-pancakeswap' => 'pancakeswap-token',
        'nexo-nexo' => 'nexo',
        'bat-basic-attention-token' => 'basic-attention-token',
        'amp-amp' => 'amp-token',
        'dash-dash' => 'dash',
        'stx-stacks' => 'blockstack',
        'enj-enjin-coin' => 'enjincoin',
        'waves-waves' => 'waves',
        'lrc-loopring' => 'loopring',
        'xaut-tether-gold' => 'tether-gold',
        'kava-kava' => 'kava',
        'btg-bitcoin-gold' => 'bitcoin-gold',
        'gmt-gomining-token' => 'stepn',
        'crv-curve-dao-token' => 'curve-dao-token',
        'ksm-kusama' => 'kusama',
        'xem-nem' => 'nem',
        'dcr-decred' => 'decred',
        'twt-trust-wallet-token' => 'trust-wallet-token',
        'gno-gnosis' => 'gnosis',
        'mina-mina-protocol' => 'mina-protocol',
        '1inch-1inch' => '1inch',
        'gala-gala' => 'gala',
        'fxs-frax-share' => 'frax-share',
        'xdc-xdc-network' => 'xdce-crowd-sale',
        'celo-celo' => 'celo',
        'cel-celsius' => 'celsius-degree-token',
        'hot-holo' => 'holotoken',
        'tfuel-theta-fuel' => 'theta-fuel',
        'rpl-rocket-pool' => 'rocket-pool',
        'cvx-convex-finance' => 'convex-finance',
        'rvn-ravencoin' => 'ravencoin',
        'qtum-qtum' => 'qtum',
        'rose-oasis-network' => 'oasis-network',
        'comp-compound' => 'compound-governance-token',
        'gusd-gemini-dollar' => 'gemini-dollar',
        'kda-kadena' => 'kadena',
        'ens-ethereum-name-service' => 'ethereum-name-service',
        'iost-iost' => 'iostoken',
        'iotx-iotex' => 'iotex',
        'ankr-ankr-network' => 'ankr',
        'srm-serum' => 'serum',
        'safemoon-safemoon' => 'safemoon',
        'yfi-yearnfinance' => 'yearn-finance',
        'lpt-livepeer' => 'livepeer',
        'zel-zelcash' => 'zelcash',
        'zrx-0x' => '0x',
        'omg-omg-network' => 'omisego',
        'ust-terrausd' => 'terrausd',
        'one-harmony' => 'harmony',
        'jst-just' => 'just',
        'glm-golem' => 'golem',
        'rsr-reserve-rights' => 'reserve-rights-token',
        'audio-audius' => 'audius',
        'luna-terra-v2' => 'terra-luna-2',
        'luna-terra' => 'terra-luna',
        'syn-synapse' => 'synapse-2',
        'op-optimism' => 'optimism',
        'sfm-safemoon' => 'safemoon-2',
        'icx-icon' => 'icon',
        'ssv-ssv-network' => 'ssv-network',
        'glmr-moonbeam' => 'moonbeam',
        'id-spaceid' => 'spaceid-id',
        'ron-ronin-token' => 'ronin',
        'magic-magic-arbitrum' => 'magic',
        'bico-biconomy' => 'biconomy',
        'multi-multichain' => 'multichain',
        'gns-gains-network' => 'gains-network',
        'omi-ecomi' => 'ecomi',
        'krd-krypton-dao' => 'krypton-dao',
        'eurt-tether-eurt' => 'tether-eurt',
        'lyxe-lukso-token' => 'lukso-token',
        'elg-escoin-token' => 'escoin-token',
        'dao-dao-maker-token' => 'dao-maker',
        'gfarm2-gains-v2' => 'gains-farm',
        'bone-bone-shibaswap' => 'bone-shibaswap',
        'cvxcrv-convex-crv' => 'convex-crv',
        'ont-ontology' => 'ontology',
        'wax-wax' => 'wax',
        'bal-balancer' => 'balancer',
        'sushi-sushi' => 'sushi',
        'nu-nucypher' => 'nucypher',
        'scrt-secret' => 'secret',
        'sc-siacoin' => 'siacoin',
        'hive-hive' => 'hive',
        'dydx-dydx' => 'dydx',
        'zen-horizen' => 'zencash',
        'mc-merit-circle' => 'merit-circle',
        'babydoge-baby-doge-coin' => 'baby-doge-coin',
        'dag-constellation' => 'constellation-labs',
        'lusd-liquity-usd' => 'liquity-usd',
        'knc-kyber-network' => 'kyber-network-crystal',
        'xch-chia-' => 'chia',
        'alusd-alchemixusd' => 'alchemix-usd',
        'uma-uma' => 'uma',
        'efyt-ergo' => 'ergo',
        'sxp-swipe' => 'swipe',
        'ewt-energy-web-token' => 'energy-web-token',
        'skl-skale' => 'skale',
        'mxc-machine-xchange-coin' => 'mxc',
        'woo-wootrade' => 'woo-network',
        'poly-polymath' => 'polymath',
        'cspr-casper-network' => 'casper-network',
        'nft-apenft' => 'apenft',
        'chsb-swissborg' => 'swissborg',
        'ethos-ethos' => 'ethos',
        'dgb-digibyte' => 'digibyte',
        'elon-dogelon-mars' => 'dogelon-mars',
        'slp-smooth-love-potion' => 'smooth-love-potion',
        'lsk-lisk' => 'lisk',
        'pla-playdapp' => 'playdapp',
        'rndr-render-token' => 'render-token',
        'fei-fei-protocol' => 'fei-usd',
        'fx-function-x' => 'fx-coin',
        'spell-spell-token' => 'spell-token',
        'cet-coinex-token' => 'coinex-token',
        'ckb-nervos-network' => 'nervos-network',
        'nest-nest-protocol' => 'nest',
        'eurs-stasis-eurs' => 'stasis-eurs',
        'raca-radio-caca' => 'radio-caca',
        'ren-republic-protocol' => 'republic-protocol',
        'people-constitutiondao' => 'constitutiondao-wormhole',
        'xno-nano' => 'nano',
        'win-winklink' => 'wink',
        'cvc-civic' => 'civic',
        'orbs-orbs' => 'orbs',
        'cfx-conflux-network' => 'conflux-token',
        'med-medibloc-qrc20' => 'medibloc',
        'pltc-platoncoin' => 'platoncoin',
        'snt-status' => 'status',
        'inj-injective-protocol' => 'injective-protocol',
        'titan-titanswap' => 'titanswap',
        'ardr-ardor' => 'ardor',
        'nmr-numeraire' => 'numeraire',
        'celr-celer-network' => 'celer-network',
        'api3-api3' => 'api3',
        'prom-prometeus' => 'prometeus',
        'tribe-tribe' => 'tribe-2',
        'coti-coti' => 'coti',
        'mx-mx-token' => 'mx-token',
        'tel-telcoin' => 'telcoin',
        'dka-dkargo' => 'dkargo',
        'btse-btse-token' => 'btse-token',
        'xyo-xyo-network' => 'xyo-network',
        'chr-chromia' => 'chromaway',
        'bsw-biswap' => 'biswap',
        'ygg-yield-guild-games' => 'yield-guild-games',
        'mbox-mobox' => 'mobox',
        'rlc-iexec-rlc' => 'iexec-rlc',
        'trb-tellor' => 'tellor',
        'bnt-bancor' => 'bancor',
        'uos-ultra' => 'ultra',
        'exrd-e-radix' => 'e-radix',
        'powr-power-ledger' => 'power-ledger',
        'sys-syscoin' => 'syscoin',
        'dent-dent' => 'dent',
        'steem-steem' => 'steem',
        'wrx-wazirx' => 'wazirx',
        'rad-radicle' => 'radicle',
        'hxro-hxro' => 'hxro',
        'susd-susd' => 'nusd',
        'keep-keep-network' => 'keep-network',
        'ogn-origin-protocol' => 'origin-protocol',
        'ray-raydium' => 'raydium',
        'strax-stratis' => 'stratis',
        'vtho-vethor-token' => 'vethor-token',
        'req-request-network' => 'request-network',
        'c98-coin98' => 'coin98',
        'fun-funfair' => 'funfair',
        'trac-origintrail' => 'origintrail',
        'rev-revain' => 'revain',
        'arrr-pirate' => 'pirate-chain',
        'husd-husd' => 'husd',
        'xido-xido-finance' => 'xido-finance',
        'storj-storj' => 'storj',
        'aurora-aurora' => 'aurora-near',
        'veri-veritaseum' => 'veritaseum',
        'rbn-ribbon-finance' => 'ribbon-finance',
        'maid-maidsafecoin' => 'maidsafecoin',
        'xmon-xmon' => 'xmon',
        'ufo-ufo-gaming' => 'ufo-gaming',
        'mtl-metal' => 'metal',
        'stpt-stpt' => 'stp-network',
        'cdt-blox' => 'blox',
        'tlm-alien-worlds' => 'alien-worlds',
        'reef-reef' => 'reef',
        'ctc-creditcoin' => 'creditcoin-2',
        'ads-adshares' => 'adshares',
        'mdx-mdex' => 'mdex',
        'qkc-quarkchain' => 'quarkchain',
        'ark-ark' => 'ark',
        'stormx-stormx' => 'storm',
        'sfund-seedifyfund' => 'seedify-fund',
        'renbtc-renbtc' => 'renbtc',
        'xvs-venus' => 'venus',
        'ocean-ocean-protocol' => 'ocean-protocol',
        'ach-alchemy-pay' => 'alchemy-pay',
        'movr-moonriver' => 'moonriver',
        'elf-aelf' => 'aelf',
        'nkn-nkn' => 'nkn',
        'klv-klever' => 'klever',
        'iq-everipedia' => 'everipedia',
        'meta-metadium' => 'metadium',
        'strk-strike' => 'strike',
        'ant-aragon' => 'aragon',
        'deso-decentralized-social' => 'deso',
        'santos-santos-fc-fan-token' => 'santos-fc-fan-token',
        'asd-ascendex-token' => 'asd',
        'badger-badger' => 'badger-dao',
        'xsgd-xsgd' => 'xsgd',
        'rep-augur' => 'augur',
        'fetch-ai' => 'fetch-ai',
        'ilv-illuvium' => 'illuvium',
        'core-cvaultfinance' => 'cvault-finance',
        'akt-akash-network' => 'akash-network',
        'utk-utrust' => 'utrust',
        'rif-rif-token' => 'rif-token',
        'tlos-telos' => 'telos',
        'wmt-world-mobile-token' => 'world-mobile-token',
        'mft-hifi-finance' => 'mainframe',
        'tt-thunder-token' => 'thunder-token',
        'cusd-celo-dollar' => 'celo-dollar',
        'band-band-protocol' => 'band-protocol',
        'dusk-dusk-network' => 'dusk-network',
        'aergo-aergo' => 'aergo',
        'ampl-ampleforth' => 'ampleforth',
        'vra-verasity' => 'verasity',
        'kp3r-keep3rv1' => 'keep3rv1',
        'xvg-verge' => 'verge',
        'pols-polkastarter' => 'polkastarter',
        'ousd-origin-dollar' => 'origin-dollar',
        'perp-perpetual-protocol' => 'perpetual-protocol',
        'mngo-mango-markets' => 'mango-markets',
        'wozx-efforce' => 'wozx',
        'aleph-alephim' => 'aleph',
        'dero-dero' => 'dero',
        'agix-singularitynet' => 'singularitynet',
        'hero-metahero' => 'metahero',
        'sero-super-zero' => 'super-zero',
        'divi-divi' => 'divi',
        'idex-idex' => 'aurora-dao',
        'wnxm-wrapped-nxm' => 'wrapped-nxm',
        'hunt-hunt' => 'hunt-token',
        'tomo-tomochain' => 'tomochain',
        'cocos-cocos-bcx' => 'cocos-bcx',
        'ava-travala' => 'travala',
        'etn-electroneum' => 'electroneum',
        'eps-ellipsis' => 'ellipsis',
        'forth-ampleforth-governance-token' => 'ampleforth-governance-token',
        'xpr-proton' => 'proton',
        'usdk-usdk' => 'usdk',
        'pha-phala-network' => 'pha',
        'rise-everrise' => 'everrise',
        'jasmy-jasmycoin' => 'jasmycoin',
        'pro-propy' => 'propy',
        'orn-orion-protocol' => 'orion-protocol',
        'cult-cult-dao' => 'cult-dao',
        'cre-carry' => 'carry',
        'super-superfarm' => 'superfarm',
        'alpaca-alpaca-finance' => 'alpaca-finance',
        'starl-starlink' => 'starlink',
        'xcad-xcad-network' => 'xcad-network',
        'lazio-lazio-fan-token' => 'lazio-fan-token',
        'wan-wanchain' => 'wanchain',
        'hydra-hydra' => 'hydra',
        'ela-elastos' => 'elastos',
        'aioz-aioz-network' => 'aioz-network',
        'time-chronotech' => 'chronobank',
        'blz-bluzelle' => 'bluzelle',
        'yfii-dfimoney' => 'yfii-finance',
        'kmd-komodo' => 'komodo',
        'bmx-bitmart-token' => 'bitmart-token',
        'alcx-alchemix' => 'alchemix',
        'mln-enzyme' => 'melon',
        'samo-samoyedcoin' => 'samoyedcoin',
        'arpa-arpa-chain' => 'arpa-chain',
        'lcx-lcx' => 'lcx',
        'gas-gas' => 'gas',
        'moc-mossland' => 'mossland',
        'onit-onbuff' => 'onbuff',
        'dnt-district0x' => 'district0x',
        'aqt-alpha-quark-token' => 'alpha-quark-token',
        'rfr-refereum' => 'refereum',
        'ramp-ramp' => 'ramp',
        'lto-lto-network' => 'lto-network',
        'rei-rei-network' => 'rei-network',
        'sbd-steem-dollars' => 'steem-dollars',
        'hns-handshake' => 'handshake',
        'dpi-defi-pulse-index' => 'defipulse-index',
        'atolo-rizon' => 'rizon',
        'bifi-beefyfinance' => 'beefy-finance',
        'ceur-celo-euro' => 'celo-euro',
        'kar-karura' => 'karura',
        'fct-firmachain' => 'firmachain',
        'qrdo-qredo' => 'qredo',
        'pre-presearch' => 'presearch',
        'noia-syntropy' => 'noia-network',
        'dia-dia' => 'dia-data',
        'soul-phantasma' => 'phantasma',
        'quick-quickswap' => 'quickswap',
        'lever-leverfi' => 'lever',
        'bcd-bitcoin-diamond' => 'bitcoin-diamond',
        'ae-aeternity' => 'aeternity',
        'rook-rook' => 'rook',
        'htr-hathor-network' => 'hathor',
        'dep-deapcoin' => 'deapcoin',
        'coval-circuits-of-value' => 'circuits-of-value',
        'anc-anchor-protocol' => 'anchor-protocol',
        'rsv-reserve' => 'reserve',
        'map-map-protocol' => 'marcopolo',
        'hoo-hoo-token' => 'hoo-token',
        'cxo-cargox' => 'cargox',
        'farm-harvest-finance' => 'harvest-finance',
        'bts-bitshares' => 'bitshares',
        'fio-fio-protocol' => 'fio-protocol',
        'iris-irisnet' => 'iris-network',
        'lit-litentry' => 'litentry',
        'agld-adventure-gold' => 'adventure-gold',
        'grs-groestlcoin' => 'groestlcoin',
        'fox-fox-token' => 'shapeshift-fox-token',
        'ubt-unibright' => 'unibright',
        'grg-rigo-token' => 'rigoblock',
        'imgnai-imgnai' => 'imgnai',
        'whale-whale' => 'whale',
        'exd-exorde' => 'exorde',
        'astra-astra-dao' => 'astra-dao',
        'poolx-poolz-finance' => 'poolz-finance-2',
        'bct-toucan-protocol-base-carbon-tonne' => 'toucan-protocol-base-carbon-tonne',
        'mintme-com-coin' => 'webchain',
        'rari-rarible' => 'rarible',
        'key-selfkey' => 'selfkey',
        'ern-ethernity-chain' => 'ethernity-chain',
        'sps-splintershards' => 'splinterlands',
        'mir-mir-coin' => 'mir-coin',
        'aog-smartofgiving' => 'smartofgiving',
        'om-mantra-dao' => 'mantra-dao',
        'apm-apm-coin' => 'apm-coin',
        'ctxc-cortex' => 'cortex',
        'hoge-hoge-finance' => 'hoge-finance',
        'firo-firo' => 'zcoin',
        'cos-contentos' => 'contentos',
        'qom-shiba-predator' => 'shiba-predator',
        'mv-gensokishi-metaverse' => 'gensokishis-metaverse',
        'nct-polyswarm' => 'polyswarm',
        'solve-solve' => 'solve-care',
        'aion-aion' => 'aion',
        'mix-mixmarvel' => 'mixmarvel',
        'wild-wilder-world' => 'wilder-world',
        'chess-tranchess' => 'tranchess',
        'adx-adex' => 'adx-net',
        'nwc-newscryptoio' => 'newscrypto-coin',
        'upp-sentinel-protocol' => 'sentinel-protocol',
        'ali-ailink-token' => 'alethea-artificial-liquid-intelligence-token',
        'gene-genopets' => 'genopets',
        'kin-kin' => 'kin',
        'toke-tokemak' => 'tokemak',
        'stc-student-coin' => 'starcoin',
        'ddx-derivadao' => 'derivadao',
        'beam-beam' => 'beam',
        'nuls-nuls' => 'nuls',
        'prq-parsiq' => 'parsiq',
        'vai-vai' => 'vai',
        'hi-hi-dollar' => 'hi-dollar',
        'tnb-time-new-bank' => 'time-new-bank',
        'apx-apollox-token' => 'apollox-2',
        'idrt-rupiah-token' => 'rupiah-token',
        'axel-axel' => 'axel',
        'snm-sonm' => 'sonm',
        'swap-trustswap' => 'trustswap',
        'mith-mithril' => 'mithril',
        'ult-ultiledger' => 'ultiledger',
        'mbl-moviebloc' => 'moviebloc',
        'sos-opendao' => 'opendao',
        'wxt-wirex-token' => 'wirex',
        'mona-monacoin' => 'monacoin',
        'snl-sport-and-leisure' => 'sport-and-leisure',
        'wtc-waltonchain' => 'waltonchain',
        'troy-troy' => 'troy',
        'hex-hex' => 'hex',
        'mct-metacraft' => 'myconstant',
        'la-latoken' => 'latoken',
        'pac-paccoin' => 'paccoin',
        'zb-zb' => 'zb-token',
        'safe-safe' => 'safe-coin-2',
        'asm-assemble-protocol' => 'assemble-protocol',
        'egg-nestree' => 'waves-ducks',
        'tnt-tierion' => 'tierion',
        'snn-sechain' => 'sechain',
        'hyn-hyperion' => 'hyperion',
        'eum-elitium' => 'elitium',
        'clt-coinloan' => 'coinloan',
        'orc-orbit-chain' => 'orclands-metaverse',
        'ong-ong' => 'somee-social-old',
        'data-streamr-datacoin' => 'streamr-datacoin',
        'alt-alitas' => 'alt-estate',
        'btcb-binance-bitcoin' => 'bitcoinbrand',
        'con-conun' => 'paycon-token',
        'loom-loom-network' => 'loom-network-new',
        'pit-pitbull' => 'pitbull',
        'best-bitpanda-ecosystem-token' => 'bitpanda-ecosystem-token',
        'wbnb-wrapped-bnb' => 'wbnb',
        'bnx-binaryx' => 'binaryx',
        'cfg-centrifuge' => 'centrifuge',
        'xym-symbol' => 'symbol',
        'hedg-hedgetrade' => 'hedgetrade',
        'cennz-centrality' => 'centrality',
        'frts-fruits' => 'fruits',
        'aht-ahatoken' => 'ahatoken',
        'burger-burger-swap' => 'burger-swap',
        'btrst-braintrust' => 'braintrust',
        'ccxx-counosx' => 'counosx',
        'mines-of-dalarnia-dar' => 'mines-of-dalarnia',
        'porto-fc-porto' => 'fc-porto',
        'wrapped-terra' => 'luna-terra',
        'ihc-inflation-hedging-coin' => 'inflation-hedging-coin',
        'bnana-banana-token' => 'banana-token',
        'btcv-bitcoin-vault' => 'bitcoinv',
        'dx-dxchain-token' => 'dxchain',
        'bora-bora' => 'bora',
        'cbk-cobak-token' => 'cobak-token',
        'msb-misbloc' => 'misbloc',
        'xdag-dagger-by-xdag' => 'dagger',
        'plc-platincoin' => 'platincoin',
        'locus-locus-chain' => 'locus-chain',
        'brg-bridge-oracle' => 'bridge-oracle',
        'seele-seele' => 'seele',
        'osmo-osmosis' => 'osmosis',
        'gnt-golem-network-tokens' => 'golem-network-tokens',
        'hsr-hshare' => 'hsr',
        'nxt-nxt' => 'nxt',
        'cro-crypto-com-coin' => 'crypto-com-coin',
        'fct-factom' => 'fct',
        'crpt-crypterium' => 'crypterium',
        'rfox-redfox-labs' => 'red-fox-labs',
        'ong-ontology-gas' => 'ontology-gas',
        'dgd-digixdao' => 'digixdao',
        'npxs-pundi-x' => 'pundi-x',
        'eurs-stasis-euro' => 'stasis-euro',
        'part-particl' => 'particl',
        'burst-burst' => 'burst',
        'stx-stox' => 'stox',
        'nxs-nexus' => 'nexus',
        'nlg-gulden' => 'gulden',
        'game-gamecredits' => 'gamecredits',
        'nav-nav-coin' => 'nav-coin',
        'block-blocknet' => 'blocknet',
        'nas-nebulas' => 'nebulas',
        'ntk-neurotoken' => 'neurotoken',
        'lun-lunyr' => 'lunyr',
        'skl-skale-network' => 'skale-network',
        'uno-unobtanium' => 'unobtanium',
        'mof-molecular-future' => 'molecular-future',
        'awc-atomic-wallet-coin' => 'atomic-wallet-coin',
        'cmct-crowd-machine' => 'crowd-machine',
        'gbx-gobyte' => 'gbx',
        'ruff-ruff' => 'ruff',
        'ost-simple-token' => 'simple-token',
        'xcp-counterparty' => 'counterparty',
        'plu-pluton' => 'pluton',
        'dadi-dadi' => 'dadi',
        'pay-tenx' => 'tenx',
        'emc-emercoin' => 'emercoin',
        'int-intchain' => 'intchain',
        'sphtx-sophiatx' => 'sphtx',
        'ATP-atlas-protocol' => 'atlas-protocol',
        'cnd-cindicator' => 'cindicator',
        'srn-sirin-labs-token' => 'sirin-labs-token',
        'cloak-cloakcoin' => 'cloakcoin',
        'mth-monetha' => 'monetha',
        'arn-aeron' => 'aeron',
        'fair-faircoin' => 'faircoin',
        'poly-polymath-network' => 'polymath-network',
        'hpb-high-performance-blockchain' => 'high-performance-blockchain',
        'ink-ink' => 'ink',
        'tcc-the-champcoin' => 'the-champcoin',
        'zer-zero' => 'zero',
        'amb-ambrosus' => 'ambrosus',
        'sur-suretly' => 'suretly',
        'oph-ophircoin' => 'ophircoin',
        'bznt-bezant' => 'bezant',
        'chx-own' => 'own',
        'c20-crypto20' => 'c20',
        'smt-smartmesh' => 'smartmesh',
        'bkx-bankex' => 'bankex',
        'via-viacoin' => 'viacoin',
        'moon-mooncoin' => 'mooncoin',
        'dmt-dmarket' => 'dmarket',
        'flare-flare-finance' => 'flare-finance',
        'wgr-wagerr' => 'wagerr',
        'xnk-ink-protocol' => 'ink-protocol',
        'xas-asch' => 'asch',
        'bot-bodhi' => 'bodhi',
        'kick-kicktoken' => 'kicktoken',
        'lkk-lykke' => 'lykke',
        'dgtx-digitex-futures' => 'digitex-futures',
        'fund-unification' => 'unification',
        'nebl-neblio' => 'neblio',
        'drt-domraider' => 'drt',
        'tusc-the-ultimate-source-coin' => 'original-crypto-coin',
        'atl-atlant' => 'atlant',
        'lst-lendroid-support-token' => 'lendroid-support-token',
        'btt-blocktrade-token' => 'blocktrade-token',
        'amm-micromoney' => 'micromoney',
        'cl-coinlancer' => 'coinlancer',
        'xhv-haven-protocol' => 'haven-protocol',
        'eac-earthcoin' => 'earthcoin',
        'hmq-humaniq' => 'humaniq',
        'mue-monetaryunit' => 'monetaryunit',
        'onion-deeponion' => 'deeponion',
        'atn-atn' => 'atn',
        'ocl-oceanlab' => 'oceanlab',
        'ssss-sharechain' => 'sharechain',
        'loc-lockchain' => 'lockchain',
        'drgn-dragonchain' => 'dragonchain',
        'grid-grid' => 'grid+',
        'cob-cobinhood' => 'cobinhood',
        'qvt-qvolta' => 'qvolta',
        'fair-faireum' => 'faireum',
        'dime-dimecoin' => 'dimecoin',
        'emc2-einsteinium' => 'einsteinium',
        'dlt-agrello-delta' => 'agrello-delta',
        'zrc-zrcoin' => 'zrcoin',
        'pcn-peepcoin' => 'peepcoin',
        'appc-appcoins' => 'appcoins',
        'read-read' => 'read',
        'real-real' => 'real',
        'daps-daps' => 'daps-token',
        'hyc-hycon' => 'hycon',
        'brd-bread' => 'bread',
        'gla-gladius-token' => 'gladius-token',
        'inv-invacio' => 'invacio',
        'xmc-monero-classic' => 'monero-classic',
        'wct-waves-community-token' => 'wct',
        'flash-flash' => 'flash',
        'eplus-epluscoin' => 'epluscoin',
        'vites-vites' => 'vites',
        'oc-oceancoin' => 'oceancoin',
        'linda-linda' => 'linda',
        'sky-skycoin' => 'skycoin',
        'chat-chatcoin' => 'chatcoin',
        'smc-smartcoin' => 'smartcoin',
        'leo-leocoin' => 'leocoin',
        'sphr-sphere' => 'sphr',
        'true-truechain' => 'truechain',
        'hand-showhand' => 'showhand',
        'abt-arcblock' => 'arcblock',
        'qrl-quantum-resistant-ledger' => 'quantum-resistant-ledger',
        'crd-cryptal-dash' => 'cryptal-dash',
        'mbc-microbitcoin' => 'microbitcoin',
        'dbc-deepbrain-chain' => 'deepbrain-chain',
        'polis-polis' => 'polis',
        'atmos-atmos' => 'atmos',
        'trxc-tronclassic' => 'tronclassic',
        'ucash-u-cash' => 'u.cash',
        'jnt-jibrel-network' => 'jnt',
        'xpm-primecoin' => 'primecoin',
        'stm-streamity' => 'streamity',
        'plt-polybius' => 'polybius',
        'lcp-litecoin-plus' => 'litecoin-plus',
        'prg-paragon' => 'prg',
        'unity-supernet' => 'supernet-unity',
        'hive-hive-project' => 'hive-project',
        'nug-nuggets' => 'nuggets',
        'cann-cannabiscoin' => 'cannabiscoin',
        'bolt-bolt' => 'bolt',
        'foam-foam' => 'foam',
        'qube-qube' => 'qube',
        'spk-sparks' => 'sparks',
        'bbb-bigbom' => 'bigbom',
        'xtz-elastic' => 'elastic',
        'bez-bezop' => 'bezop',
        'gup-guppy' => 'gup',
        'krb-karbo' => 'karbo',
        'card-cardstack' => 'cardstack',
        'vib-viberate' => 'viberate',
        'inn-innova' => 'innova',
        'fsn-fusion' => 'fusion',
        'ipc-ipchain' => 'ipchain',
        'sim-simmitri' => 'simmitri',
        'bank-bankcoin' => 'bankcoin',
        'met-metronome' => 'metronome',
        'snc-suncontract' => 'suncontract',
        'ori-origami' => 'origami',
        'kore-korecoin' => 'korecoin',
        'xlr-solaris' => 'solaris',
        'clam-clams' => 'clams',
        'mdx-mediex' => 'mediex',
        'zcl-zclassic' => 'zclassic',
        'civ-civitas' => 'civitas',
        'mci-musiconomi' => 'musiconomi',
        'sft-safex-token' => 'safex-token',
        'sig-spectiv' => 'spectiv',
        'defi-piedao' => 'piedao-defi',
        'cato-cato-coin' => 'catocoin',
        'neos-neoscoin' => 'neos',
        'func-funcoin' => 'funcoin',
        'note-dnotes' => 'dnotes',
        'xspec-spectrecoin' => 'spectrecoin',
        'gat-gatcoin' => 'gatcoin',
        'src-securecoin' => 'securecoin',
        'brad-bradbury' => 'bradbury',
        'orox-cointorox' => 'cointorox',
        'bis-bismuth' => 'bismuth',
        'evi-evimeria' => 'evimeria',
        'gmng-gaming-coin' => 'gaming-coin',
        'iflt-inflationcoin' => 'inflationcoin',
        'mfg-syncfab' => 'syncfab',
        'btm-bitmark' => 'bitmark',
        'dgc-digitalcoin' => 'digitalcoin',
        'cmc-commercium' => 'commercium',
        'cure-curecoin' => 'curecoin',
        'lgo-lgo-token' => 'lgo-token',
        'cpex-apex-network' => 'apex-network',
        'hush-hush' => 'hush',
        'pond-marlin' => 'marlin',
        'etbs-ethbits' => 'ethbits',
        'ppc-peercoin' => 'peercoin',
        'goose-goose-q' => 'goose-q',
        'gam-gambit' => 'gambit',
        'ufr-upfiring' => 'upfiring',
        'loki-loki-network' => 'loki-network',
        'el-elcoin' => 'elcoin',
        'fjc-fujicoin' => 'fjc',
        'hana-hanacoin' => 'hanacoin',
        'inn-innovative-bioresearch' => 'innovative-bioresearch',
        'egc-evergreencoin' => 'evergreencoin',
        'bbp-biblepay' => 'biblepay',
        'mkt-mktcoin' => 'mktcoin',
        'sfn-safron' => 'safron',
        'wsote-soteria' => 'soteria',
        'efx-effect-ai' => 'effect-ai',
        'rare-rare-pepe-party' => 'rare-pepe-party',
        'scap-safecapital' => 'safecapital',
        'bela-belacoin' => 'bela',
        'tns-transcodium' => 'transcodium',
        'mcoc-monacocoin' => 'monacocoin',
        'cope-cointelescope' => 'cointelescope',
        'wrc-worldcore' => 'worldcore',
        'dth-dether' => 'dether',
        'arg-argentum' => 'argentum',
        'cre-cybereits' => 'cybereits',
        'hedg-hedge-trade' => 'hedge-trade',
        'gp-goldpieces' => 'goldpieces',
        'dov-dovu' => 'dovu',
        'cas-cashaa' => 'cashaa',
        'dtc-datacoin' => 'datacoin',
        'cfl-cryptoflow' => 'cryptoflow',
        'wage-digiwage' => 'digiwage',
        'bird-birdchain' => 'birdchain',
        'ok-okcash' => 'okcash',
        '1x2-1x2-coin' => '1x2-coin',
        'bet-dao-casino' => 'dao-casino',
        'saave-saave' => 'saave',
        'eosd-eos-dao' => 'eos-dao',
        'wicc-waykichain' => 'waykichain',
        'nms-numus' => 'numus',
        'mds-medishares' => 'medishares',
        'ish-intersolar-holding' => 'intersolar-holding',
        'hdg-hedge' => 'hedge',
        'phx-red-pulse-phoenix' => 'red-pulse-phoenix',
        'cv2-colossuscoin-v2' => 'colossuscoin-v2',
        'true-true-chain' => 'true-chain',
        'pai-project-pai' => 'project-pai',
        'cmdx-coindom' => 'coindom',
        'eve-devery' => 'devery',
        'me-all-me' => 'all.me',
        'cet-cetuscoin' => 'cetuscoin',
        'bitz-bitz' => 'bitz',
        'zet-zetacoin' => 'zet',
        'dct-decent' => 'decent',
        'unify-unify' => 'unify',
        'dcn-decenturion' => 'decenturion',
        'wap-wapcoin' => 'wapcoin',
        'rex-rex' => 'rex',
        'knd-kanadecoin' => 'kanadecoin',
        'oxo-ox-fina' => 'ox-fina',
        'ccrb-cryptocarbon' => 'cryptocarbon',
        'dav-dav' => 'dav',
        'ary-block-array' => 'block-array',
        'dtx-databroker-dao' => 'databroker-dao',
        'plr-pillar' => 'pillar',
        'zen-zen-protocol' => 'zen-protocol',
        'unrc-universalroyalcoin' => 'universalroyalcoin',
        'ore-galactrum' => 'galactrum',
        'hbt-hubii-network' => 'hubii-network',
        'dsla-stacktical' => 'stacktical',
        'omni-omni' => 'omni',
        'brzc-breezecoin' => 'breezecoin',
        'rex-imbrex' => 'imbrex',
        'adi-aditus' => 'aditus',
        'qyn-qyno' => 'qyno',
        'pfr-payfair' => 'payfair',
        'cvcoin-curriculum-vitae' => 'curriculum-vitae',
        'mac-machinecoin' => 'machinecoin',
        'stu-bitjob' => 'bitjob',
        'ctic2-coimatic-2' => 'coimatic-2',
        'idex-index-chain' => 'index-chain',
        'smart-smartup' => 'smartup',
        'crd-cryptaldash' => 'cryptaldash',
        'wsatp-wearesatoshi' => 'wearesatoshi',
        'stc-coinstarter' => 'coinstarter',
        'btdx-bitcloud' => 'bitcloud',
        'ukg-unikoin-gold' => 'unikoin-gold',
        'ltp-lifetoken' => 'lifetoken',
        'diw-diw-token' => 'diw-token',
        'taj-tajcoin' => 'tajcoin',
        'arcade-arcade-token' => 'arcade-token',
        'soar-soarcoin' => 'soarcoin',
        'prn-protean' => 'protean',
        'zpt-zeepin' => 'zeepin',
        'pass-blockpass' => 'blockpass',
        'bether-bethereum' => 'bethereum',
        'vee-blockv' => 'blockv',
        'cbc-cashbet-coin' => 'cashbet-coin',
        'boom-boom-token' => 'boom-token',
        'xbl-billionaire-token' => 'billionaire-token',
        'cym-cybermusic' => 'cybermusic',
        'acc-accelerator-network' => 'accelerator-network',
        'qbt-qbao' => 'qbao',
        'adb-adbank' => 'adbank',
        'kobo-kobocoin' => 'kobocoin',
        'xpy-paycoin2' => 'paycoin2',
        'eosdac-eos-dac' => 'eos-dac',
        'rcn-rcoin' => 'rcoin',
        'ccco-cryptocore' => 'cryptocore',
        'bbo-bigbom-eco' => 'bigbom-eco',
        'xet-eternal-token' => 'eternal-token',
        'payc-paycoinly' => 'paycoinly',
        'toa-toacoin' => 'toacoin',
        'mad-mad-network' => 'mad-network',
        'pcoin-pioneer-coin' => 'pioneer-coin',
        'tky-thekey' => 'thekey',
        'pmnt-paymon' => 'paymon',
        'stp-stashpay' => 'stashpay',
        'eauric-eauric' => 'eauric',
        'dpy-delphy' => 'delphy',
        'yup-crowdholding' => 'crowdholding',
        'atb-atbcoin' => 'atbcoin',
        'fab-fabric-token' => 'fabric-token',
        'rns-renos' => 'renos',
        'funk-the-cypherfunks' => 'the-cypherfunks',
        'turbo-turbo' => 'turbo',
        'ixc-ixcoin' => 'ixcoin',
        'dmb-digital-money-bits' => 'digital-money-bits',
        'hub-hubi' => 'hubi',
        'dac-davinci-coin' => 'davinci-coin',
        'etl-eth-limited' => 'eth-limited',
        'apex-cpapex' => 'apex',
        'dgtx-digitex-futures-exchange' => 'digitex-futures-exchange',
        'smly-smileycoin' => 'smileycoin',
        'ssc-selfsell' => 'selfsell',
        'aka-akroma' => 'akroma',
        'cav-cavatcoin' => 'cavatcoin',
        'xgcs-xgalaxy' => 'xgalaxy',
        'crb-creditbit' => 'creditbit',
        'start-startcoin' => 'startcoin',
        'spc-spotcoin' => 'spotcoin',
        'bctr-bitcratic-revenue' => 'bitcratic-revenue',
        'ncc-neurochain' => 'neurochain',
        'bcpt-blockmason-credit-protocol' => 'blockmason-credit-protocol',
        'ctl-citadel' => 'citadel',
        'sct-soma' => 'soma',
        'USDS-stableusd' => 'stableusd',
        'btn-bitnewchain' => 'bitnewchain',
        'nmc-namecoin' => 'namecoin',
        'vips-vipstarcoin' => 'vipstarcoin',
        'adb-adbank-tokens' => 'adbank-tokens',
        'ncash-nucleus-vision' => 'nucleus-vision',
        'gze-gazecoin' => 'gazecoin',
        'xuc-exchange-union' => 'exchange-union',
        'bloc-bloc-money' => 'bloc.money',
        'lnd-lendingblock' => 'lendingblock',
        'hxx-hexx' => 'hexx',
        'goat-goat-cash' => 'goat-cash',
        'crd-crowd-one' => 'crowd-one',
        'infx-influxcoin' => 'influxcoin',
        'flc-flowchaincoin' => 'flowchaincoin',
        'obs-orbis' => 'orbis',
        'bon-bonpay' => 'bonpay',
        'krl-kryll' => 'kryll',
        'vxv-vectorspaceai' => 'vectorspaceai',
        'vex-vexanium' => 'vexanium',
        'richx-richcoin' => 'richcoin',
        'kgo-kiwigo' => 'kiwigo',
        'fluz-fluz-fluz' => 'fluz-fluz',
        'BLX-blockchain-index' => 'blockchain-index',
        'bcr-blacer-coin' => 'blacer-coin',
        'apl-apollocurrency' => 'apollocurrency',
        'elon-elon-diamond' => 'elon-diamond',
        'xla-ripple-alpha' => 'ripple-alpha',
        'hgt-hellogold' => 'hellogold',
        'cvc-cvc-token' => 'cvc-token',
        'lrm-liquid-regenerative-medicine-coin' => 'liquid-regenerative-medicine-coin',
        'pol-proof-of-liquidity' => 'proof-of-liquidity',
        'bots-bottos' => 'bottos',
        'bdl-bitdeal' => 'bitdeal',
        'nzl-zealium' => 'zealium',
        'tip-tipbotcoin' => 'tipbotcoin',
        'xqr-qredit' => 'qredit',
        'crox-cointorox-token' => 'cointorox-token',
        'polk-polkamonster' => 'polkamonster',
        'dapp-digital-assets-power-play' => 'digital-assets-power-play',
        'fyooz-fyooz' => 'fyooz',
        'xwc-whitecoin' => 'whitecoin',
        'rock2-ice-rock-mining' => 'ice-rock-mining',
        'hive-hiveterminal-token' => 'hiveterminal-token',
        'fum-fidelium' => 'fidelium',
        'bee-bee-coin' => 'bee-coin',
        'dla-dolla' => 'dolla',
        'btw-bitwhite' => 'bitwhite',
        'lym-lympo' => 'lympo',
        'mbgl-mobit-global' => 'mobit-global',
        'xsm-spectrum-cash' => 'spectrum-cash',
        'fota-fortuna' => 'fota',
        'tol-tolar' => 'tolar',
        'hpot-hash-pot' => 'hash-pot',
        'aco-alphacon' => 'alphacon',
        'thc-the-hempcoin' => 'the-hempcoin',
        'medic-mediccoin' => 'mediccoin',
        'seed-livetree-aitv' => 'livetree-aitv',
        'lky-linkey' => 'linkey',
        'xbt-beatcoin' => 'beatcoin',
        'etk-energi-token' => 'energi-token',
        'tbc-tbcoin' => 'tbcoin',
        'xmo-monero-original' => 'monero-original',
        'pbt-primalbase-token' => 'primalbase-token',
        'mb8-mb8-coin' => 'mb8-coin',
        'flash-flashcoin' => 'flashcoin',
        'stream-streamit-coin' => 'streamit-coin',
        'arion-arion' => 'arion',
        'bet-bet-king' => 'bet-king',
        'sprts-sprouts' => 'sprouts',
        'gch-galaxycash' => 'galaxycash',
        'bcn-bytecoin-bcn' => 'bytecoin-bcn',
        'icnq-iconiq-lab-token' => 'iconiq-lab-token',
        'unc-unicoin' => 'unicoin',
        'sign-signaturechain' => 'signaturechain',
        'mar-marijuanacoin' => 'marijuanacoin',
        'rega-regacoin' => 'regacoin',
        'dbix-dubaicoin' => 'dubaicoin-dbix',
        'send-social-send' => 'social-send',
        'xor-oracolxor' => 'oracolxor',
        'mic-mindexcoin' => 'mindexcoin',
        'kwh-kwhcoin' => 'kwhcoin',
        'net-nimiq-network' => 'nimiq-network',
        'lpc-lightpaycoin' => 'lightpaycoin',
        'bm-bitcomo' => 'bitcomo',
        'imt-moneytoken' => 'moneytoken',
        'tdt-tidebit' => 'tidebit',
        'rise-rise-protocol' => 'rise-protocol',
        'xkilo-kiloample' => 'kiloample',
        'ges-galaxy-esolutions' => 'galaxy-esolutions',
        'dagt-digital-asset-guarantee-token' => 'digital-asset-guarantee-token',
        'tch-tiger-cash' => 'tiger-cash',
        'btcred-bitcoin-red' => 'bitcoin-red',
        'onl-on.live' => 'on.live',
        'stac-startercoin' => 'startercoin',
        'ttt-tap-coin' => 'tap-coin',
        'shmn-stronghands-masternode' => 'stronghands-masternode',
        'stmx-stormx' => 'stormx',
        'pnt-penta' => 'penta',
        'lnc-blocklancer' => 'blocklancer',
        'mir-mirai' => 'mirai',
        'avalon-avalon' => 'avalon',
        'pin-pinmo' => 'pinmo',
        'hyt-horyoutoken' => 'horyoutoken',
        'oreo-oreo' => 'oreo',
        'flixx-flixxo' => 'flixxo',
        'tic-compasscoin' => 'compasscoin',
        'rte-rate3' => 'rate3',
        'bln-bolenum' => 'bolenum',
        'tok-tokok' => 'tokok',
        'ieh-infinity-esaham' => 'infinity-esaham',
        'zcr-zcore' => 'zcore',
        'hsc-hashcoin' => 'hashcoin',
        'wtt-giga-watt-token' => 'giga-watt-token',
        'hb-heartbout' => 'heartbout',
        'dp-digitalprice' => 'digitalprice',
        'audax-audax' => 'audax',
        'xot-internet-of-things' => 'internet-of-things',
        'fst-fastcoin' => 'fastcoin',
        'safe-safecoin' => 'safecoin',
        'gmx-goldmaxcoin' => 'goldmaxcoin',
        'gmx-gmx' => 'gmx',
        'iov-carlive-chain' => 'carlive-chain',
        'ul-chain' => 'uselink-chain',
        'gth-gath3r' => 'gath3r',
        'btct-bitcoin-token' => 'bitcoin-token',
        'hp-healing-plus' => 'healing-plus',
        'fmt-fundamenta' => 'fundamenta',
        'fti-fanstime' => 'fanstime',
        'acc-acchain' => 'acchain',
        'abt-allbit-token' => 'allbit-token',
        'mne-minereum' => 'minereum',
        'datx-datx' => 'datx',
        'tft-triforce-tokens' => 'triforce-tokens',
        'next-next-exchange' => 'next.exchange',
        'cor-corion' => 'corion',
        'xen-xenixcoin' => 'xenixcoin',
        'wtc-wtc-coin' => 'wtc-coin',
        'vivo-vivo' => 'vivo',
        'mon-moneta' => 'moneta',
        'sign-signaturecoin' => 'signaturecoin',
        'cou-couchain' => 'couchain',
        'zap-zap' => 'zap',
        'jin-jin-coin' => 'jin-coin',
        'luna-luna-coin' => 'luna-coin',
        'dex-dex' => 'dex',
        'greit-global-reits' => 'global-reits',
        'lif-winding-tree' => 'winding-tree',
        'lno-livenodes' => 'livenodes',
        'veo-amoveo' => 'amoveo',
        'cit-crypto-invest-token' => 'crypto-invest-token',
        'btca-bitair' => 'bitair',
        'cat-bitclave' => 'bitclave',
        'lnc-linker-coin' => 'linker-coin',
        'scs-speedcash' => 'speedcash',
        'ent-entcash' => 'entcash',
        'genes-genes-chain' => 'genes-chain',
        'elix-elixir' => 'elixir',
        'rupx-rupaya' => 'rupaya',
        'amlt-amlt' => 'amlt',
        'ssto-assetto' => 'assetto',
        'swth-switcheo' => 'switcheo',
        'hnc-helleniccoin' => 'helleniccoin',
        'soc-all-sports' => 'all-sports',
        'usdx-dollars' => 'dollars',
        'cdn-canada-ecoin' => 'canada-ecoin',
        'eost-eos-trust' => 'eos-trust',
        'faith-faithcoin' => 'faithcoin',
        'nbr-niobio-cash' => 'niobio-cash',
        'payx-paypex' => 'paypex',
        'cob-cobrabytes' => 'cobrabytes',
        'maza-mazacoin' => 'maza',
        'shard-shard' => 'shard',
        'adc-audiocoin' => 'audiocoin',
        'mcash-mcashchain' => 'mcashchain',
        'insn-insanecoin' => 'insanecoin-insn',
        'telos-transcendence-blockchain' => 'transcendence-blockchain',
        'torch-torch' => 'torch',
        'cyber-cybercoin' => 'cybercoin',
        'vers-versess-coin' => 'versess-coin',
        'arco-aquariuscoin' => 'aquariuscoin',
        'trt-translatix' => 'translatix',
        'min-mindol' => 'mindol',
        'lap-luna-coin-plus' => 'luna-coin-plus',
        'nex-nash-exchange' => 'nash-exchange',
        'smart-smartcash' => 'smartcash',
        'zfl-zuflo-coin' => 'zuflo-coin',
        'xbx-bitex-global-xbx-coin' => 'bitex-global-xbx-coin',
        'rmc-russian-mining-coin' => 'russian-mining-coin',
        'tec-te-coin' => 'te-coin',
        'slt-smartland' => 'smartland',
        'skb-sakura-bloom' => 'sakura-bloom',
        'oryx-oryxcoin' => 'oryxcoin',
        'fxe-futurexe' => 'futurexe',
        'tic-trueinvestmentcoin' => 'trueinvestmentcoin',
        'emrals-emrals' => 'emrals',
        'vtor-vtorrent' => 'vtorrent',
        'jet-jetcoin' => 'jetcoin',
        'bxk-bitbook-gambling' => 'bitbook-gambling',
        'kurt-kurrent' => 'kurrent',
        'cnmc-cryptonodes' => 'cryptonodes',
        'gqtn-galleon-quest' => 'galleon-quest',
        'ric-riecoin' => 'riecoin',
        'rmt-sureremit' => 'sureremit',
        'lgc-logiscoin' => 'logiscoin',
        'ign-ignite' => 'ignite',
        'space-spacecoin' => 'spacecoin',
        'paq-paquarium' => 'paquarium',
        'cfun-cfun' => 'cfun',
        'azar-azart' => 'azart',
        'blk-blink' => 'blink',
        'of-ofcoin-2-0' => 'ofcoin-2-0',
        'croat-croat' => 'croat',
        'i0c-i0coin' => 'i0coin',
        'icr-intercrone' => 'intercrone',
        'pylnt-pylon-network' => 'pylon-network',
        'gb-goldblocks' => 'goldblocks',
        'adv-adv-coin' => 'adv-coin',
        'cof-coffeecoin' => 'coffeecoin',
        'gmt-mercury-protocol' => 'mercury-protocol',
        'ezw-ezoow' => 'ezoow',
        'bxt-bittokens' => 'bittokens',
        'pix-lampix' => 'pix',
        'crave-crave' => 'crave',
        'hero-sovereign-hero' => 'sovereign-hero',
        'lxt-litex' => 'litex',
        'rvt-rivetz' => 'rivetz',
        'swftc-swftcoin' => 'swftcoin',
        'gmb-gmb' => 'gmb',
        'man-matrix-ai-network' => 'matrix-ai-network',
        'levo-levocoin' => 'levocoin',
        'svd-savedroid' => 'savedroid',
        'pkn-pennykoin' => 'pennykoin',
        'xtp-tap' => 'tap',
        'golf-golfcoin' => 'golfcoin',
        'bion-biido' => 'biido',
        'fbc-fibrecoin' => 'fibrecoin',
        'abbc-alibabacoin' => 'alibabacoin',
        'trio-tripio' => 'tripio',
        'sloth-slothcoin' => 'slothcoin',
        'kub-bitkub-coin' => 'bitkub-coin',
        'udoo-howdoo' => 'howdoo',
        'aex-aeriumx' => 'aeriumx',
        'gun-guncoin' => 'guncoin',
        'francs-francs' => 'francs',
        'post-postcoin' => 'postcoin',
        'zba-zoomba' => 'zoomba',
        'kush-kushcoin' => 'kushcoin',
        'hit-hit' => 'hit',
        'tor-torcoin-tor' => 'torcoin-tor',
        'cms-cryptomillionslotto' => 'cryptomillionslotto',
        'mozo-mozo-token' => 'mozo-token',
        'tgo-tingocoin' => 'tingocoin',
        'inc-influence-chain' => 'influence-chain',
        'kyan-kyanite' => 'kyanite',
        'unit-universal-currency' => 'universal-currency',
        'hlx-helex-token' => 'helex-token',
        'wc-wincoin' => 'wincoin',
        'bitcf-first-bitcoin-capital' => 'first-bitcoin-capital',
        'smc-salemcash' => 'salemcash',
        'pcm-procom' => 'procom',
        'ix-x-block' => 'x-block',
        'kyf-kryptofranc' => 'kryptofranc',
        'drg-dragon-coin' => 'dragon-coin',
        'msp-mothership' => 'mothership',
        'btm-bytom' => 'bytom',
        'cqt-covalent' => 'covalent',
        'dpc-digitalpriceclassic' => 'digitalpriceclassic',
        'shx-stronghold-token' => 'stronghold-token',
        'gup-matchpool' => 'matchpool',
        'boinc-boinc' => 'boinc',
        'bdg-bitdegree' => 'bitdegree',
        'psk-pool-of-stake' => 'pool-of-stake',
        'sigma-sigmacoin' => 'sigmacoin',
        'hst-decision-token' => 'decision-token',
        'gcc-global-cryptocurrency' => 'global-cryptocurrency',
        'cpay-cryptopay' => 'cryptopay',
        'bsm-bitsum' => 'bitsum',
        'pasc-pascalcoin' => 'pascalcoin',
        'esn-ethersocial' => 'ethersocial',
        'dtrc-datarius-credit' => 'datarius-credit',
        'sta-starta' => 'starta',
        'xid-sphre-air' => 'sphre-air',
        'flg-folgory-coin' => 'folgory-coin',
        'uuu-u-network' => 'u-network',
        'klks-kalkulus' => 'kalkulus',
        'arms-2acoin' => '2acoin',
        'pan-panther' => 'panther',
        'incx-international-cryptox' => 'international-cryptox',
        'grc-gridcoin' => 'gridcoin',
        'neu-neumark' => 'neumark',
        'plc-polcoin' => 'polcoin',
        'boli-bolivarcoin' => 'bolivarcoin',
        'dgt-digital-rupees' => 'digital-rupees',
        'xtl-stellite' => 'stellite',
        'dev-deviantcoin' => 'deviantcoin',
        'snek-sosnovkino' => 'sosnovkino',
        'taas-taas' => 'taas',
        'reap-reapchain' => 'reapchain',
        'get-get-protocol' => 'get-token',
        'onx-onix' => 'onix',
        'gre-greencoin' => 'greencoin',
        'lyfe-lyfe' => 'lyfe',
        'pla-playchip' => 'playchip',
        'esp-espers' => 'espers',
        'edrc-edrcoin' => 'edrcoin',
        'art-maecenas' => 'maecenas',
        'oct-oraclechain' => 'oraclechain',
        'dmc-dynamiccoin' => 'dynamiccoin',
        'xnn-xenon' => 'xenon',
        'shop-shopin' => 'shopin',
        'nxc-nexium' => 'nexium',
        'ent-eternity' => 'eternity',
        'guess-peerguess' => 'peerguess',
        'face-faceter' => 'faceter',
        'fdx-fidentiax' => 'fidentiax',
        'kbc-karatgold-coin' => 'karatgold-coin',
        'vault-the-vault' => 'the-vault',
        'toc-touchcon' => 'touchcon',
        'nobl-noblecoin' => 'noblecoin',
        'xpax-bitnation' => 'bitnation',
        'wish-mywish' => 'mywish',
        'val-valorbit' => 'valorbit',
        'xin-infinity-economics' => 'infinity-economics',
        'xnv-nerva' => 'nerva',
        'mxm-maximine-coin' => 'maximine-coin',
        'lina-lina' => 'lina',
        'mbc-minebee' => 'minebee',
        'void-void' => 'void',
        'nobs-no-bs-crypto' => 'no-bs-crypto',
        'gsc-global-social-chain' => 'global-social-chain',
        'bpro-bitcloud-pro' => 'bitcloud-pro',
        'mvc-maverick-chain' => 'maverick-chain',
        'fxc-flexacoin' => 'flexacoin',
        'vctr-vectrum' => 'vectrum',
        'ect-eurocoinpay' => 'eurocoinpay',
        'ledu-education-ecosystem' => 'education-ecosystem',
        'dbc-datablockchain' => 'datablockchain',
        'wow-wowbit' => 'wowbit',
        'type-typerium' => 'typerium',
        'wys-wys-coin' => 'wys-coin',
        'ucash-ucash' => 'ucash',
        'opt-opt' => 'optimus-chain',
        'aias-aiascoin' => 'aiascoin',
        'nbx-netbox-coin' => 'netbox-coin',
        'dad-dad' => 'dad',
        'whale-whalecoin' => 'whalecoin',
        'mtc-docademic' => 'docademic',
        'sins-safeinsure' => 'safeinsure',
        'pi-picoin' => 'picoin',
        'tell-tellurion' => 'tellurion',
        'lit-lifetioncoin' => 'lifetioncoin',
        'osmiumcoin-osmiumcoin' => 'osmiumcoin',
        'pulse-pulse' => 'pulse',
        'let-linkeye' => 'linkeye',
        'cwxt-cryptoworldx-token' => 'cryptoworldx-token',
        'wix-wixlar' => 'wixlar',
        'acmc-acmecoin' => 'acmecoin',
        'knc-kingn-coin' => 'kingn-coin',
        'sld-solidified' => 'solidified',
        'ptn-palletone' => 'palletone',
        'pxc-pixie-coin' => 'pixie-coin',
        'btr-bitether' => 'bitether',
        'karma-karma' => 'karma',
        'phm-phytium' => 'phytium',
        'evr-everus' => 'everus',
        'tau-lamden' => 'lamden',
        'iop-internet-of-people' => 'internet-of-people',
        'sds-alchemint' => 'alchemint',
        'npxsnm-pundi-x-nem' => 'pundi-x-nem',
        'cs-credits' => 'credits',
        'qcx-quickx-protocol' => 'quickx-protocol',
        'icob-icobid' => 'icobid',
        'brat-brat' => 'brat',
        'top-topchain' => 'topchain',
        'xrt-robonomics-network' => 'robonomics-network',
        'inx-infinity-x-infinity' => 'inx',
        'urf-universal-rocket-fuel' => 'urf',
        'shft-shift' => 'shft',
        'btb-bitbar' => 'btb',
        'c2-coin' => 'c2',
        'zpr-zper' => 'zpr',
        'medibit-medi' => 'medibit',
        'ftn-futurepia' => 'ftn',
        '1st-first-blood' => '1st',
        'paisa-paisacoin' => 'paisa',
        'gym-gymrewards' => 'gym',
        'mda-moeda-loyalty-points' => 'moeda-loyalty-points',
        'csc-casinoCoin' => 'csc',
        'lepen-letitride' => 'lepen',
        'egt-egretia' => 'egt',
        'nvc-novacoin' => 'nvc',
        'orb-orbitcoin' => 'orb',
        'emb-embercoin' => 'emb',
        'fxt-fuzex' => 'fxt',
        'thrt-thorecoin' => 'thrt',
        'blu-bluecoin' => 'blu',
        'wmgo-wavesgo' => 'wmgo',
        'btrn-bitron' => 'btrn',
        'kb3-b3coin' => 'kb3',
        'coin-coincoin' => 'coin',
        'virta-unique-coin' => 'virta-unique-coin',
        'adk-aidos-kuneen' => 'adk',
        'plc-pluscoin' => 'plc',
        'ltb-litebar' => 'ltb',
        'dax-daxxcoin' => 'dax',
        'ftc-feathercoin' => 'feathercoin',
        'xtd-trustdex-token' => 'xtd',
        'btcd-bitcoin-dark' => 'btcd',
        'acm-actinium' => 'acm',
        'bitc-bitcoin-classic' => 'bitc',
        'bpc-bitpark-coin' => 'bpc',
        'bq-boscoin' => 'bq',
        'exc-excaliburcoin' => 'exc',
        'ess-essentia' => 'essentia',
        'mnx-minexcoin' => 'mnx',
        'bxb-bitbook-gambling' => 'bxb',
        'b3-b3coin' => 'b3',
        '2give-2give' => '2give',
        'pink-pinkcoin' => 'pink',
        'evx-everex' => 'evx',
        'deex-deex' => 'deex',
        'bvc-beavercoin' => 'bvc',
        'adz-adzcoin' => 'adz',
        'log-woodcoin' => 'log',
        'crc-chronocoin' => 'crc',
        'uni-unibright' => 'uni',
        'techno-techno' => 'techno',
        'grlc-garlicoin' => 'garlicoin',
        'eltcoin-eltcoin' => 'eltcoin',
        'reth-rocket-pool-eth' => 'rocket-pool-eth',
        'xbs-bitstake' => 'xbs',
        'cv-carvertical' => 'carvertical',
        'tfd-terrafirmacoin' => 'tfd',
        'vrs-veros' => 'vrs',
        'wmc-win-coin' => 'wmc',
        'nio-autonio' => 'nio',
        'lot-plotx' => 'lot',
        'glt-globaltoken' => 'glt',
        'ins-insolar' => 'ins',
        'blk-blackcoin' => 'blackcoin',
        'tri-trias-token' => 'tri',
        'pond-pond-coin' => 'pond',
        'gdao-governor-dao' => 'governor-dao',
        'yop-yield-optimization-platform' => 'yield-optimization-platform',
        'uni3l-uniswap-3x-long' => 'uni3-3x-long-uniswap-token',
        'nxct-x-chain' => 'xchain-token',
        'eth-testnet-ropsten' => 'ropsten-eth',
        'astax-ape-stax' => 'ape-stax',
        'dq-quick-dragon' => 'dragons-quick',
        'cpu-cpuchain' => 'cpuchain',
        'eth-testnet-rinkeby' => 'rinkeby-eth',
        'filp-huobi-fil' => 'huobi-fil',
        'ice-popsicle-finance' => 'ice-token',
        '50c-50cent' => '50cent',
        'leth-long-eth' => 'long-eth',
        'combo-furucombo' => 'furucombo',
        'mrc-meritcoins' => 'meritcoins',
        'tdx-tidex-token' => 'tidex-token',
        'bord-bordapp' => 'bordapp',
        'bith-bithachi' => 'bithachi',
        'poc-poc-chain' => 'poc-chain',
        'limon-limon-group' => 'limon-group',
        'dfb-defi-box' => 'defi-box',
        'xtt-theta-token' => 'xtheta-token',
        'hex-hex-money' => 'hex-money',
        'dis-tosdis-finance' => 'tosdis-finance',
        'pearl-pearl-finance' => 'pearl-finance',
        'raze-raze-network' => 'raze-network',
        'mist-mist' => 'mist',
        'tkx-tokenize-xchange' => 'tokenize-xchange',
        'pte-pocketec' => 'pocketec',
        'fire-firebird-finance' => 'firebird-finance',
        'foc-focv' => 'focv',
        'png-pangolin' => 'pangolin',
        'fyn-fyn-protocol' => 'fyn-protocol',
        'glc-goldcoin' => 'goldcoin',
        'nar-nar-token' => 'nar-token',
        'earnx-earnx' => 'earnx',
        'bifi-bifi' => 'bifi',
        'btu-btu-protocol' => 'btu-protocol',
        'waultx-wault-finance' => 'wault-finance-old',
        'cpt-cryptaur' => 'cryptaur',
        'vancat-vancat' => 'vancat',
        'rcn-ripio-credit-network' => 'ripio-credit-network',
        'itc-itc' => 'itc',
        'trbt-tribute' => 'tribute',
        'baz-bazooka-token' => 'bazooka-token',
        'mdt-measurable-data-token' => 'measurable-data-token',
        'sun-sun-token' => 'sun-token',
        'apt-aptos' => 'aptos',
        'mnt-mantle' => 'mantle',
        'kas-kaspa' => 'kaspa',
        'bgb-bitget-token' => 'bitget-token',
        'pepe-pepe' => 'pepe',
        'sui-sui' => 'sui',
        'polyx-polymesh' => 'polymesh',
        'wld-worldcoin' => 'worldcoin-wld',
        'sei-sei' => 'sei-network',
        'ftn-fasttoken' => 'fasttoken',
        'canto-canto' => 'canto',
        'bitcoin-harrypotterobamasonic10inu-eth' => 'harrypotterobamasonic10in',
        'btcb-bitcoin-avalanche-bridged-btcb' => 'bitcoin-avalanche-bridged-btc-b',
        'stsol-lido-staked-sol' => 'lido-staked-sol',
        'ico-axelar' => 'axelar',
        'tomi-tominet' => 'tominet',
        'wbeth-wrapped-beacon-eth' => 'wrapped-beacon-eth',
        'ctsi-cartesi' => 'cartesi',
        'pundix-pundi-x' => 'pundi-x-2',
        'pyusd-paypal-usd' => 'paypal-usd',
        'fdusd-first-digital-usd' => 'first-digital-usd',
        'cbeth-coinbase-wrapped-staked-eth' => 'coinbase-wrapped-staked-eth',
        'wcfg-wrapped-centrifuge' => 'wrapped-centrifuge',
        'seth2-seth2' => 'seth2',
        'gat-gameai' => 'gameai',
        'kuji-kujira' => 'kujira',
        'lqty-liquity' => 'liquity',
        'frxeth-frax-ether' => 'frax-ether',
        'olympus-olympus' => 'olympus',
        'cwbtc-cwbtc' => 'compound-wrapped-btc',
        'edu-open-campus' => 'edu-coin',
        'flr-flare' => 'flare-networks',
        'eusd-eusd' => 'eusd-new',
        'pendle-pendle' => 'pendle',
        '0x0-0x0ai-ai-smart-contract' => '0x0-ai-ai-smart-contract',
        'stg-stargatetoken' => 'stargate-finance',
        'pyr-vulcan-forged' => 'vulcan-forged',
        'dexe-dexe' => 'dexe',
        'mlk-milk-alliance' => 'milk-alliance',
        'rdnt-radiant-capital' => 'radiant-capital',
        'mvl-mass-vehicle-ledger' => 'mass-vehicle-ledger',
        'savax-benqi-liquid-staked-avax' => 'benqi-liquid-staked-avax',
        'acs-access-protocol' => 'access-protocol',
        'sdex-smardex' => 'smardex',
        'nym-nym' => 'nym',
        'dodo-dodo' => 'dodo',
        'cyber-cyberconnect' => 'cyberconnect',
        'naka-nakamoto-games' => 'nakamoto-games',
        'dnx-dynex' => 'dynex',
        'mrs-metars-genesis' => 'metars-genesis',
        'gal-galxe' => 'project-galaxy',
        'hifi-hifi-finance' => 'hifi-finance',
        'sweat-sweat-economy' => 'sweatcoin',
        'sgb-songbird' => 'songbird',
        'mbx-marblex' => 'marblex',
        'hook-hooked-protocol' => 'hooked-protocol',
        'astra-astrafer' => 'astrafer',
        'hft1-hashflow' => 'hashflow',
        'gods-gods-unchained' => 'gods-unchained',
        'ton-tokamak-network' => 'tokamak-network',
        'ever-everscale' => 'everscale',
        'unibot-unibot' => 'unibot',
        'eul-euler' => 'euler',
        'euroc-euro-coin' => 'euro-coin',
        'nxra-allianceblock-nexera' => 'allianceblock-nexera',
        'bfc-bifrost' => 'bifrost',
        'dext-dextools' => 'dextools',
        'temple-templedao' => 'temple',
        'vita-vitadao' => 'vitadao',
        'ghst-aavegotchi' => 'aavegotchi',
        'vrsc-verus-coin' => 'verus-coin',
        'oas-oasys' => 'oasys',
        'solo-sologenic' => 'solo-coin',
        'efi-efinity' => 'efinity',
        'caw-a-hunters-dream' => 'a-hunters-dream',
        'col-clash-of-lilliput' => 'clash-of-lilliput',
        'ccd-concordium' => 'concordium',
        'pokt-pocket-network' => 'pocket-network',
        'rss3-rss3' => 'rss3',
        'chng-chainge-finance' => 'chainge-finance',
        'mtrg-meter-governance' => 'meter',
        'bel-bella-protocol' => 'bella-protocol',
        'bake-bakeryswap' => 'bakerytoken',
        'sdao-singularitydao' => 'singularitydao',
        'gfal-games-for-a-living' => 'games-for-a-living',
        'ata-automata' => 'automata',
        'lat-platon-network' => 'platon-network',
        'polis-star-atlas-dao' => 'star-atlas-dao',
        'evmos-evmos' => 'evmos',
        'rare-superrare' => 'superrare',
        'tbtc-tbtc' => 'tbtc',
        'gel-gelato' => 'gelato',
        'orca-orca' => 'orca',
        'myria-myria' => 'myria',
        'hez-hermez-network' => 'hermez-network-token',
        'cweb-coinweb' => 'coinweb',
        'boba-boba-network' => 'boba-network',
        'dock-dock' => 'dock',
        'lon-tokenlon' => 'tokenlon',
        'del-decimal' => 'decimal',
        'ecox-ecox' => 'ecox',
        'uwu-uwu-lend' => 'uwu-lend',
        'nrv-nerve-finance' => 'nerve-finance',
        'ult-shardus' => 'shardus',
        'qark-qanplatform' => 'qanplatform',
        'bld-agoric' => 'agoric',
        'pol-polygon-ecosystem-token' => 'polygon-ecosystem-token',
        'bond-barnbridge' => 'barnbridge',
        'oxt-orchid-protocol' => 'orchid-protocol',
        'lina-linear' => 'linear',
        'wsc-worldtatecoin' => 'the-world-state',
        'olas-autonolas' => 'autonolas',
        'vega-vega-protocol' => 'vega-protocol',
        'flm-flamingo-finance' => 'flamingo-finance',
        'ator-airtor-protocol' => 'airtor-protocol',
        'heart-humans' => 'humans-ai',
        'alpha-alpha-finance' => 'alpha-finance',
        'arkm-arkham' => 'arkham',
        'ox-open-exchange-token' => 'open-exchange-token',
        'ctk-shentu' => 'certik',
        'auction-bounce' => 'auction',
        '10set-tenset' => 'tenset',
        'alice-my-neighbor-alice' => 'my-neighbor-alice',
        'token-tokenfi' => 'tokenfi',
        'gtc-gitcoin' => 'gitcoin',
        'bzr-bazaars' => 'bazaars',
        'flex-flex-coin' => 'flex-coin',
        'mts-metis' => 'metis-token',
        'crx-core' => 'coredaoorg',
        'opm-saitama' => 'saitama-inu',
        'fidu-fidu' => 'fidu',
        'pcx-chainx' => 'chainx',
        'prime-echelon-prime' => 'echelon-prime',
        'strd-stride' => 'stride',
        'stbt-short-term-t-bill-token' => 'short-term-t-bill-token',
        'sid-space-id' => 'space-id',
        'ordi-ordi' => 'ordinals',
        'aca-acala' => 'acala',
        'paal-paal-ai' => 'paal-ai',
        'mrph-morpheusnetwork' => 'morpheus-network',
        'wsm-wall-street-memes' => 'wall-street-memes',
        'uqc-uquid-coin' => 'uquid-coin',
        'fort-forta' => 'forta',
        'aura-aura-finance' => 'aura-finance',
        'ladys-milady-meme-coin' => 'milady-meme-coin',
        'kwenta-kwenta' => 'kwenta',
        'route-router-protocol' => 'route',
        'zcx-unizen' => 'unizen',
        'h2o3-h2o-dao' => 'h2o-dao',
        'premia-premia' => 'premia',
        'xprt-persistence' => 'persistence',
        'jpeg-jpeg39d' => 'jpeg-d',
        'alu-altura' => 'altura',
        'bfic-bficoin' => 'bficoin',
        'gog-guild-of-guardians' => 'guild-of-guardians',
        'dione-dione' => 'dione',
        'loka-league-of-kingdoms' => 'league-of-kingdoms',
        'kai-kardiachain' => 'kardiachain',
        'kishu-kishu-inu' => 'kishu-inu',
        'tvk-the-virtua-kolect' => 'the-virtua-kolect',
        'dpx-dopex' => 'dopex',
        'amb-airdao' => 'amber',
        'bar-fc-barcelona-fan-token' => 'fc-barcelona-fan-token',
        'bonk-bonk' => 'bonk',
        'fpis-frax-price-index-share' => 'frax-price-index-share',
        'ntx-nunet' => 'nunet',
        'zbc-zebec-protocol' => 'zebec-protocol',
        'gafi-gamefi' => 'gamefi',
        'qi-benqi' => 'benqi',
        'wrld-nft-worlds' => 'nft-worlds',
        'btrfly-redacted' => 'redacted',
        'bad-bad-idea-ai' => 'bad-idea-ai',
        'inst-instadapp' => 'instadapp',
        'pts-petals' => 'petals',
        'wing-wing-finance' => 'wing-finance',
        'psp-paraswap' => 'paraswap',
        'gbex-globiance-exchange' => 'globiance-exchange',
        'psg-paris-saint-germain-fan-token' => 'paris-saint-germain-fan-token',
        'swise-stakewise' => 'stakewise',
        'og-og-fan-token' => 'og-fan-token',
        'mlt-media-licensing-token' => 'media-licensing-token',
        'voxel-voxies' => 'voxies',
        'fold-manifold-finance' => 'manifold-finance',
        'tara-taraxa' => 'taraxa',
        'fida-bonfida' => 'bonfida',
        'gto-gifto' => 'gifto',
        'strx-strikex' => 'strikecoin',
        'bzz-bzz' => 'swarm-bzz',
        'velo-velo' => 'velo',
        'derc-derace' => 'derace',
        'volt-volt-inu' => 'volt-inu-2',
        'srx-storx' => 'storx',
        'caps-ternoa' => 'coin-capsule',
        'vro-veraone' => 'veraone',
        'tko-tokocrypto' => 'tokocrypto',
        'u-unidef' => 'unidef',
        'ico-findora' => 'findora',
        'uft-unilend-finance' => 'unlend-finance',
        'pivx-pivx' => 'pivx',
        'mimatic-mimatic' => 'mimatic',
        'kilt-kilt-protocol' => 'kilt-protocol',
        'gfi-goldfinch' => 'goldfinch',
        'hvh-havah' => 'havah',
        'xels-xels' => 'xels',
        'gmm-gamium' => 'gamium',
        'nexa-nexa' => 'nexacoin',
        'vr-victoria-vr' => 'victoria-vr',
        'aury-aurory' => 'aurory',
        'tkp-tokpie' => 'tokpie',
        'hc-hypercash' => 'hshare',
        'ecoin-ecoin' => 'ecoin-2',
        'bitci-bitcicoin' => 'bitcicoin',
        'b2m-bit2me' => 'bit2me',
        'fine-refinable' => 'refinable',
        'uxp-uxd-protocol' => 'uxd-protocol-token',
        'mnde-marinade' => 'marinade',
        'gpx-gpex' => 'gpex',
        'lyra-lyra-finance' => 'lyra-finance',
        'sb-snowbank' => 'snowbank',
        'aurabal-aura-bal' => 'aura-bal',
        'mog-mog-coin' => 'mog-coin',
        'rfox-rfox' => 'redfox-labs-2',
        'bsn-boson-protocol' => 'boson-protocol',
        'vsc-vyvo-smart-chain' => 'vyvo-smart-chain',
        'opul-opuloustoken-via-chainportio' => 'opulous',
        'tonic-tectonic' => 'tectonic',
        'vext-veloce' => 'veloce-vext',
        'veed-veed' => 'veed',
        'vlx-velas' => 'velas',
        'tet-tectum' => 'tectum',
        'bigtime-big-time' => 'big-time',
        'planeteer-planeteer-social' => 'planeteer-social',
        'shia-shia1' => 'shiba-saga',
        'election-real-smurf-cat' => 'real-smurf-cat',
        'ico-cere-network' => 'cere-network',
        'gho-gho' => 'gho',
        'osak-osaka-protocol' => 'osaka-protocol',
        'adco-advertise-coin' => 'advertise-coin',
        'vcnt-vicicoin' => 'vicicoin',
        'aidoge-arbdoge-ai' => 'arbdoge-ai',
        'sd-stader' => 'stader',
        'mim-magic-internet-money' => 'magic-internet-money',
        'rly-rally' => 'rally-2',
        'hard-kava-lend' => 'kava-lend',
        'ico-sommelier' => 'sommelier',
        'ageur-ageur' => 'ageur',
        'phx-phoenix' => 'phoenix-global',
        'bean-bean' => 'bean',
        'seth-seth' => 'seth',
        'cot-cosplay-token' => 'cosplay-token-2',
        'dg-degate' => 'degate',
        'thor-thorswap' => 'thorswap',
        'city-manchester-city-fan-token' => 'manchester-city-fan-token',
        'copi-cornucopias' => 'cornucopias',
        'cast-castello-coin' => 'castello-coin',
        'bmex-bitmex' => 'bitmex-token',
        'rmrk-rmrk' => 'rmrk',
        'meld-meld' => 'meld-2',
        'alpine-alpine-f1-team-fan-token' => 'alpine-f1-team-fan-token',
        'guildfi-guildfi' => 'guildfi',
        'rbls-rebel-bots' => 'rebel-bots',
        'hera-hera-finance' => 'hera-finance',
        'mtd-minted' => 'minted',
        'dxd-dxdao' => 'dxdao',
        'bzrx-bzx-protocol' => 'bzx-protocol',
        'tmg-t-mac-dao' => 't-mac-dao',
        'mex-xexchange' => 'maiar-dex',
        'f-frontier' => 'frontier-token',
        'optimusai-optimus-ai' => 'optimus-ai',
        'moon-moon-ordinals' => 'moon-ordinals',
        'banana-banana-gun' => 'banana-gun',
        'gxs-gxchain' => 'gxchain',
        'xsushi-xsushi' => 'xsushi',
        'propc-propchain' => 'propchain',
        'gzone-gamezone' => 'gamezone',
        'fis-stafi' => 'stafi',
        '00-00-token' => 'zer0zer0',
        'vxv-vectorspace-ai' => 'vectorspace',
        'dextf-dextf' => 'dextf',
        'ast-airswap' => 'airswap',
        'for-fortube' => 'force-protocol',
        'sa-superalgos' => 'saito',
        'tsuka-dejitaru-tsuka' => 'dejitaru-tsuka',
        'bwo-battle-world' => 'battle-world',
        'sn-spacen' => 'spacen',
        'cyce-crypto-carbon-energy' => 'crypto-carbon-energy-2',
        'dc-dogechain-token' => 'dogechain',
        'ejs-enjinstarter' => 'enjinstarter',
        'oax-oax' => 'openanx',
        'tdrop-thetadrop' => 'thetadrop',
        'dmtr-dimitra' => 'dimitra',
        'itheum-itheum' => 'itheum',
        'sdn-shiden-network' => 'shiden',
        'dimo-dimo' => 'dimo',
        'grail-camelot-token' => 'camelot-token',
        'gami-gami-world' => 'gami-world',
        'juv-juventus-fan-token' => 'juventus-fan-token',
        'hopr-hopr' => 'hopr',
        'zgd-zambesigold' => 'zambesigold',
        'torn-tornado-cash' => 'tornado-cash',
        'num-numbers-protocol' => 'numbers-protocol',
        'botto-botto' => 'botto',
        'tama-tamadoge' => 'tamadoge',
        'rxd-radiant' => 'radiant',
        'area-areon-network' => 'areon-network',
        'talk-talken' => 'talken',
        'sph-spheroid-universe' => 'spheroid-universe',
        'dmd-diamond' => 'diamond',
        'acm-ac-milan-fan-token' => 'ac-milan-fan-token',
        'wojak-wojak' => 'wojak',
        'isk-iskra-token' => 'iskra-token',
        'vsta-vesta-finance' => 'vesta-finance',
        'nfai-not-financial-advice' => 'not-financial-advice',
        'cph-cypherium' => 'cypherium',
        'gulf-gulfcoin' => 'gulfcoin-2',
        'cvp-powerpool-concentrated-voting-power' => 'concentrated-voting-power',
        'sauce-saucerswap' => 'saucerswap',
        'zano-zano' => 'zano',
        'nim-nimiq' => 'nimiq-2',
        'rvst-revest-finance' => 'revest-finance',
        'val-validity' => 'radium',
        'pnk-kleros' => 'kleros',
        'stos-stratos' => 'stratos',
        'sclp-scallop' => 'scallop',
        'qtcon-quiztok' => 'quiztok',
        'gxa-galaxia' => 'galaxia',
        'gbyte-obyte' => 'byteball',
        'amo-amo-coin' => 'amo',
        'cube-somnium-space-cubes' => 'somnium-space-cubes',
        'kata-katana-inu' => 'katana-inu',
        'shi-shina-inu' => 'shina-inu',
        'oct-octopus-network' => 'octopus-network',
        'pnt-pnetwork' => 'pnetwork',
        'wait-hourglass' => 'hourglass',
        'cap-cap' => 'cap',
        'cgo-comtech-gold' => 'comtech-gold',
        'bscpad-bscpad' => 'bscpad',
        'inter-inter-milan-fan-token' => 'inter-milan-fan-token',
        'rvp-revolution-populi' => 'revolution-populi',
        'pros-prosper' => 'prosper',
        'crts-cratos' => 'cratos',
        'grv-grovecoin' => 'grove',
        'atm-atletico-madrid-fan-token' => 'atletico-madrid',
        'pkf-firebird' => 'polkafoundry',
        'swash-swash' => 'swash',
        'zks-zkspace' => 'zkspace',
        'math-math' => 'math',
        'alph-alephium' => 'alephium',
        'trac-trac-ordinals' => 'trac',
        'kalm-kalm' => 'kalmar',
        'gal-galatasaray-fan-token' => 'galatasaray-fan-token',
        'xen-xen-crypto' => 'xen-crypto',
        'acx-across-protocol' => 'across-protocol',
        'vela-vela-token' => 'vela-token',
        'sov-sovryn' => 'sovryn',
        'buy-buyingcom' => 'buying',
        'afc2-arsenal-fan-token' => 'arsenal-fan-token',
        'btr-bitrue-coin' => 'bitrue-token',
        'winr-winr-protocol' => 'winr-protocol',
        'ovr-ovr' => 'ovr',
        'arg-argentine-football-association-fan-token' => 'argentine-football-association-fan-token',
        'mengo-flamengo-fan-token' => 'flamengo-fan-token',
        'strp-strips-finance' => 'strips-finance',
        'hkn-hacken' => 'hackenai',
        'pinksale-pinksale' => 'pinksale',
        'sdt-stake-dao' => 'stake-dao',
        'uxd-uxd-stablecoin' => 'uxd-stablecoin',
        'cheq-cheqd-network' => 'cheqd-network',
        'btcp-bitcoin-pro' => 'bitcoin-pro',
        'hdx-hydradx' => 'hydradx',
        'cby-carbify' => 'carbify',
        'cgpt-chaingpt-bsc' => 'chaingpt',
        'pnb-pink-bnb' => 'pink-bnb',
        'cate-catecoin' => 'catecoin',
        'eva-evadore' => 'evadore',
        'mute-mute' => 'mute',
        'lbr-lybra' => 'lybra-finance',
        'ichi-ichi' => 'ichi-farm',
        'nodl-nodle-network' => 'nodle-network',
        'ethm-ethereum-meta' => 'ethereum-meta',
        'rbx-rabbitx' => 'rabbitx',
        'bitrock-bitrock' => 'bitrock',
        'peusd-peg-eusd' => 'peg-eusd',
        'aa-alva' => 'alva',
        'tryb-bilira' => 'bilira',
        'ads-alkimi' => 'alkimi',
        'octa-octaspace' => 'octaspace',
        'hdn-hydranet' => 'hydranet',
        'dome-everdome' => 'everdome',
        'trc-metatrace' => 'metatrace',
        'qash-qash' => 'qash',
        'yusd-yusd-stablecoin' => 'yusd-stablecoin',
        'rail-railgun' => 'railgun',
        'yoshi-yoshiexchange' => 'yoshi-exchange',
        'bigsb-bigshortbets' => 'bigshortbets',
        'silo-silo-finance' => 'silo-finance',
        'bnbx-stader-bnbx' => 'stader-bnbx',
        'cuni-cuni' => 'compound-uniswap',
        'pepe-20-pepe-20' => 'pepe-2-0',
        'ycc-yuan-chain-coin' => 'yuan-chain-coin',
        'blid-bolide' => 'bolide',
        'plex-plex' => 'plex',
        'gyen-gyen' => 'gyen',
        'dg-decentral-games' => 'decentral-games',
        'yve-crvdao-vecrv-dao-yvault' => 'vecrv-dao-yvault',
        'thales-thales' => 'thales',
        'koin-koinos' => 'koinos',
        'era-era-swap' => 'era-swap-token',
        'masq-masq' => 'masq',
        'cow-cow-protocol' => 'cow-protocol',
        'dop-d-drops' => 'd-drops',
        'iceth-interest-compounding-eth-index' => 'interest-compounding-eth-index',
        'usdx-usdx' => 'usdx',
        'blusd-boosted-lusd' => 'boosted-lusd',
        'indy-indigo-dao-governance-token' => 'indigo-dao-governance-token',
        'stfx-stfx' => 'stfx',
        'r-r' => 'r',
        'tenet-tenet' => 'tenet-1b000f7b-59cb-4e06-89ce-d62b32d362b9',
        'avinoc-avinoc' => 'avinoc',
        'shdw-shadow-token' => 'genesysgo-shadow',
        'crm-cream' => 'cream-2',
        'bcn-bytecoin' => 'bytecoin',
        'skey-skey-network' => 'skey-network',
        'bax-babb' => 'babb',
        'squidgrow-squidgrow' => 'squidgrow',
        'revv-revv' => 'revv',
        'jesus-jesus-coin' => 'jesus-coin',
        'nftx-nftx' => 'nftx',
        'kan-bitkan' => 'kan',
        'srlty-saitarealty' => 'saitarealty',
        'klt-kamaleont' => 'kamaleont',
        'obsr-observer' => 'observer-coin',
        'undead-undead-blocks' => 'undead-blocks',
        'mars-mars-protocol' => 'mars-protocol-a7fcbcfb-fd61-4017-92f0-7ee9f9cc6da3',
        'atpay-atpay' => 'atpay',
        'push-ethereum-push-notification-service-epns' => 'ethereum-push-notification-service',
        'moon-rcryptocurrency-moons' => 'moon',
        'jewel-defi-kingdoms' => 'defi-kingdoms',
        'vinu-vita-inu' => 'vita-inu',
        'btc2-bitcoin-2' => 'bitcoin-2',
        'aura-aura-network' => 'aura-network',
        'dlc-diamond-launch' => 'diamond-launch',
        'gpcx-good-person-coin' => 'good-person-coin',
        'sphere-sphere-finance' => 'sphere-finance',
        'dino-dinolfg' => 'dinolfg',
        'lbt-law-blocks' => 'law-blocks',
        'pip-pip-sol' => 'pip',
        'hapi-hapi' => 'hapi',
        'jones-jones-dao' => 'jones-dao',
        'snfts-seedify-nft-space' => 'snfts-seedify-nft-space',
        'rae-receive-access-ecosystem' => 'rae-token',
        'xdefi-xdefi' => 'xdefi',
        'taki-taki' => 'taki',
        'agi-delysium' => 'delysium',
        'mgp-magpie' => 'magpie',
        'lcr-lucro' => 'lucro',
        'mdao-marsdao' => 'marsdao',
        'spa-sperax' => 'sperax',
        'catgirl-catgirl' => 'catgirl',
        'xava-avalaunch' => 'avalaunch',
        'skeb-skeb' => 'skeb',
        'lm-leisuremeta' => 'leisuremeta',
        'epic-epic-cash' => 'epic-cash',
        'el-elysia' => 'elysia',
        'wiken-project-with' => 'project-with',
        'cpool-clearpool' => 'clearpool',
        'avt-aventus' => 'aventus',
        'tone-te-food' => 'te-food',
        'bepro-bet-protocol' => 'bepro-network',
        'polydoge-polydoge' => 'polydoge',
        'orb-orbcity' => 'klaycity-orb',
        'cell-cellframe' => 'cellframe',
        'gari-gari-network' => 'gari-network',
        'rjv-rejuveai' => 'rejuve-ai',
        'qsp-quantstamp' => 'quantstamp',
        'bst-blocksquare' => 'blocksquare',
        'go-gochain' => 'gochain',
        'x-xerc-20' => 'x-2',
        'rai-rai-reflex-index' => 'rai',
        'impt-impt' => 'impt',
        'sipher-sipher' => 'sipher',
        'pola-polaris-share' => 'polaris-share',
        'scp-scprime' => 'siaprime-coin',
        'pdex-polkadex' => 'polkadex',
        'radar-dappradar' => 'dappradar',
        'paw-pawswap' => 'pawswap',
        'fevr-realfevr' => 'realfevr',
        'ling-lingose' => 'lingose',
        'lovely-lovely-inu-finance' => 'lovely-inu-finance',
        'cly-colony' => 'colony',
        'wombat-wombat' => 'wombat',
        'slim-solanium' => 'solanium',
        'block-blockasset' => 'blockasset',
        'epik-epik-prime' => 'epik-prime',
        'boo-spookyswap' => 'spookyswap',
        'bob4-bob-token' => 'bob-token',
        'kasta-kasta' => 'kasta',
        'sfd-safedeal' => 'safe-deal',
        'mtv-multivac' => 'multivac',
        'ooe-openocean' => 'openocean',
        'gamma1-gamma-strategies' => 'gamma-strategies',
        'fyn1-affyn' => 'affyn',
        'shiryo-inu-shiryo' => 'shiryo-inu',
        'pzp-playzap' => 'playzap',
        'tra-trabzonspor-fan-token' => 'trabzonspor-fan-token',
        'ntvrk-netvrk' => 'netvrk',
        'verse-verse-token' => 'verse-bitcoin',
        'cbx-cropbytes' => 'cropbytes',
        'trvl-trvl' => 'dtravel',
        'muse-muse' => 'muse-2',
        'myst-mysterium' => 'mysterium',
        'smt-swarm-markets' => 'swarm-markets',
        'sylo-sylo' => 'sylo',
        'pnp-penpie' => 'penpie',
        'neer-metaversenetwork-pioneer' => 'metaverse-network-pioneer',
        'gddy-giddy' => 'giddy',
        'senate-senate' => 'senate',
        'sccp-sc-corinthians-fan-token' => 's-c-corinthians-fan-token',
        'efc-everton-fan-token' => 'everton-fan-token',
        'ignis-ignis' => 'ignis',
        'kunci-kunci-coin' => 'kunci-coin',
        'raini-raini' => 'rainicorn',
        'floor-floordao' => 'floordao',
        'ban-banano' => 'banano',
        'dvf-rhinofi' => 'rhinofi',
        'sftmx-stader-sftmx' => 'stader-sftmx',
        'pbx-paribus' => 'paribus',
        'step-step-finance' => 'step-finance',
        'vina-vicuna' => 'vicuna',
        'xna-neurai' => 'neurai',
        'x2y2-x2y2token' => 'x2y2',
        'wit-witnet' => 'witnet',
        'zig-zignaly' => 'zignaly',
        'bazed-bazed-games' => 'bazed-games',
        'hanu-hanu-yokia' => 'hanu-yokia',
        'poof-poof-token' => 'poof-token',
        'index-index-cooperative' => 'index-cooperative',
        'pdt-paragonsdao' => 'paragonsdao',
        'igu-iguverse-igu' => 'iguverse-igu',
        'ete-etherempires' => 'etherempires',
        'manc-mancium' => 'mancium',
        'xpx-proximax' => 'proximax',
        'dog-the-doge-nft' => 'the-doge-nft',
        'gq-galactic-quadrant' => 'outer-ring',
        'mevfree-mevfree' => 'mevfree',
        'zcn-0chain' => '0chain',
        'hmx-hmx' => 'hmx',
        'xrp-harrypotterobamapacman8inu' => 'harrypotterobamapacman8inu',
        'ern-ethos-reserve-note' => 'ethos-reserve-note',
        'lss-lossless' => 'lossless',
        'mimo-mimo-governance' => 'mimo-parallel-governance-token',
        'omikami-amaterasu-omikami' => 'amaterasu-omikami',
        'aimbot-aimbot' => 'aimbot',
        'bcb-blockchain-bets' => 'blockchain-bets',
        'neox-neoxa' => 'neoxa',
        'knight-citadao' => 'citadao',
        'txau-tgold' => 'tgold',
        'xki-ki' => 'ki',
        'aria20-arianee' => 'arianee',
        'per-per-project' => 'per-project',
        'steamx-steam-exchange' => 'steam-exchange',
        'tpad-trustpad' => 'trustpad',
        'dehub-dehub' => 'dehub',
        'ald-aladdin-dao' => 'aladdin-dao',
        'brick-rfortnitebr-bricks' => 'brick',
        'kitty-kitty-inu' => 'kitty-inu',
        'sis-symbiosis' => 'symbiosis-finance',
        'bsgg-betswapgg' => 'betswap-gg',
        'rbif-robo-inu' => 'robo-inu-finance',
        'pstake-pstake-finance' => 'pstake-finance',
        'gearbox-gearbox' => 'gearbox',
        'alot-dexalot' => 'dexalot',
        'brwl-blockchain-brawlers' => 'blockchain-brawlers',
        'boot-bostrom' => 'bostrom',
        'fer-ferro' => 'ferro',
        'zz-zigzag' => 'zigzag-2',
        'peel-meta-apes-peel' => 'meta-apes-peel',
        'ipor-ipor' => 'ipor',
        'sdl-stakelink' => 'stake-link',
        'csix-carbon-browser' => 'carbon-browser',
        'bzet-bzetcoin' => 'bzetcoin',
        'nex-nash' => 'neon-exchange',
        'soph-sophiaverse' => 'sophiaverse',
        'scs-solcasino-token' => 'solcasino-token',
        'mnta-mantadao' => 'mantadao',
        'klima-klimadao' => 'klima-dao',
        'dvpn-sentinel' => 'sentinel',
        'kmon-kryptomon' => 'kryptomon',
        'spank-spankchain' => 'spankchain',
        'wagmi5-wagmi' => 'wagmi-2',
        'dvi-dvision-network' => 'dvision-network',
        'deus-deus-finance' => 'deus-finance-2',
        'bdp-big-data-protocol' => 'big-data-protocol',
        'suku-suku' => 'suku',
        'dafi-dafi-protocol' => 'dafi-protocol',
        'zyn-zynecoin' => 'zynecoin',
        'cetus-cetus-protocol' => 'cetus-protocol',
        'shft-shyft-network' => 'shyft-network-2',
        'ghx-gamercoin' => 'gamercoin',
        'pai-parrot-usd' => 'parrot-usd',
        'lcs-localcoinswap' => 'localcoinswap',
        'nrg-energi' => 'energi',
        'oni-onino' => 'oni-token',
        'vtc-vertcoin' => 'vertcoin',
        'sani-sanin-inu' => 'sanin-inu',
        'lit-timeless' => 'timeless',
        'occ-occamfi' => 'occamfi',
        'salt-salt' => 'salt',
        'trade-polytrade' => 'polytrade',
        'umb-umbrella-network' => 'umbrella-network',
        'mcrt-magiccraft' => 'magiccraft',
        'jmpt-jumptoken' => 'jumptoken',
        'berry-berry' => 'berry',
        'meme-meme-brc-20' => 'meme-brc-20',
        'dark-dark-frontiers' => 'dark-frontiers',
        'por-portugal-national-team-fan-token' => 'portugal-national-team-fan-token',
        'pkoin-pocketcoin' => 'pocketcoin',
        'stima-stima' => 'stima',
        'dose-dose' => 'dose-token',
        'wallet-ambire-wallet' => 'ambire-wallet',
        'gny-gny' => 'gny',
        'crp-crypton' => 'utopia',
        'bump-bumper' => 'bumper',
        'amkt-alongside-crypto-market-index' => 'alongside-crypto-market-index',
        'gpt-cryptogpt-token' => 'cryptogpt-token',
        'ydf-yieldification' => 'yieldification',
        'hop-hop-protocol' => 'hop-protocol',
        'lvl-level' => 'level',
        'mars4-mars4' => 'mars4',
        'walv-alvey-chain' => 'alvey-chain',
        'pli-plugin' => 'plugin',
        'kine-kine-protocol' => 'kine-protocol',
        'lime-ime-lab' => 'ime-lab',
        'jam-geojam' => 'geojam',
        'grin-grin' => 'grin',
        'pika-pika-protocol' => 'pika-protocol',
        'signa-signa' => 'signum',
        'ping-sonar' => 'sonar',
        'dbi-don39t-buy-inu' => 'don-t-buy-inu',
        'frm-ferrum-network' => 'ferrum-network',
        'polk-polkamarkets' => 'polkamarkets',
        'defx-definity' => 'definity',
        'nht-neighbourhoods' => 'neighbourhoods',
        'chain-chain-games' => 'chain-games',
        'dcb-decubate' => 'decubate',
        'pswap-polkaswap' => 'polkaswap',
        'witch-witch-token' => 'witch-token',
        'paint-murall' => 'paint',
        'moov-dotmoovs' => 'dotmoovs',
        'geeq-geeq' => 'geeq',
        'dfx-dfx-finance' => 'dfx-finance',
        'pxp-pointpay' => 'pointpay',
        'nvt-nervenetwork' => 'nervenetwork',
        'ibat-battle-infinity' => 'battle-infinity',
        'prism-prism' => 'prism',
        'kma-calamari-network' => 'calamari-network',
        'dfyn-dfyn-network' => 'dfyn-network',
        'insur-insurace' => 'insurace',
        'tig-tigris' => 'tigris',
        'wom-wombat-exchange' => 'wombat-exchange',
        'sha-safe-haven' => 'safe-haven',
        'paid-paid-network' => 'paid-network',
        'gcr-global-coin-research' => 'global-coin-research',
        'oxy-oxygen' => 'oxygen',
        'rdt-ridotto' => 'ridotto',
        'tch-tigercash' => 'tigercash',
        'lcc-litecoin-cash' => 'litecoin-cash',
        'xep-electra-protocol' => 'electra-protocol',
        'pnd-pandacoin' => 'pandacoin',
        '42-42-coin' => '42-coin',
        'marsh-unmarshal' => 'unmarshal',
        'sauber-alfa-romeo-racing-orlen-fan-token' => 'alfa-romeo-racing-orlen-fan-token',
        'lzm-loungem' => 'loungem',
        'edge-edge' => 'edge',
        'rwn-rowan-coin' => 'rowan-coin',
        'conx-connex' => 'connex',
        'bmc-bountymarketcap' => 'bountymarketcap',
        'vsp-vesper-finance' => 'vesper-finance',
        'fore-fore-protocol' => 'fore-protocol',
        'jgn-juggernaut7492' => 'juggernaut',
        'btc2x-fli-btc-2x-flexible-leverage-index' => 'btc-2x-flexible-leverage-index',
        'fast1-podfast' => 'podfast',
        'mps-mt-pelerin-shares' => 'mt-pelerin-shares',
        'ocd-on-chain-dynamics' => 'on-chain-dynamics',
        'gswift-gameswift' => 'gameswift',
        'temp-tempus' => 'tempus',
        'nlc-nelore-coin' => 'nelore-coin',
        'ncr-neos-credits' => 'neos-credits',
        'sama-exosama-network' => 'exosama-network',
        'seur-seur' => 'seur',
        'xtm-torum-bsc' => 'torum',
        'rtm-raptoreum' => 'raptoreum',
        'mona-monavale' => 'monavale',
        'next-connext-eth' => 'connext',
        'ghny-grizzly-honey' => 'grizzly-honey',
        'xed-exeedme-erc-20' => 'exeedme',
        'dxgm-dexgame' => 'dex-game',
        'hipp-el-hippo' => 'el-hippo',
        'shibdoge-shibadoge' => 'shibadoge',
        'mobi-mobius' => 'mobius',
        'vfox-vfox' => 'vfox',
        'ico-eco' => 'eco',
        'ggp-gogopool' => 'gogopool',
        'refund-refund' => 'refund',
        'ain-ai-network' => 'ai-network',
        'bank-bankless-dao' => 'bankless-dao',
        'lua-lua-swap' => 'lua-token',
        'gains-gains' => 'gains',
        'ooks-onooks' => 'onooks',
        'zpay-zoidpay' => 'zoid-pay',
        'adapad-adapad' => 'adapad',
        'you-youves-you-governance' => 'youves-you-governance',
        'factr-defactor' => 'defactor',
        'stax-stablexswap' => 'stablexswap',
        'spe-saveplanetearth' => 'saveplanetearth',
        'btcmt-minto' => 'minto',
        'lords-lords' => 'lords',
        'wampl-wrapped-ampleforth' => 'wrapped-ampleforth',
        'toshi-toshi' => 'toshi',
        'grumpy-grumpy-cat' => 'grumpy-cat-2c33af8d-87a8-4154-b004-0686166bdc45',
        'doga-dogami' => 'dogami',
        'xia-xi' => 'xi-token',
        'digits-digits-dao' => 'digits-dao',
        'nmkr-nmkr' => 'nft-maker',
        'jkl-jackal-protocol' => 'jackal-protocol',
        'wsi-wesendit' => 'wesendit',
        'chi-xaya' => 'chimaera',
        'djed-djed' => 'djed',
        'cyber-cyberpunk-city' => 'cyberpunk-city',
        'haven-haven' => 'haven',
        'dio-decimated' => 'decimated',
        'usk-usk' => 'usk',
        'oto-otocash' => 'otocash',
        'ash-ashswap' => 'ashswap',
        'uw3s-utility-web3shot' => 'utility-web3shot',
        'nom-onomy-protocol' => 'onomy-protocol',
        'thl-thala' => 'thala',
        'zbit-zbit-ordinals' => 'zbit-ordinals',
        'zmn-zmine' => 'zmine',
        'nls-nolus' => 'nolus',
        'like-likecoin' => 'likecoin',
        'gw-gyrowin' => 'gyrowin',
        'civ-civilization' => 'civilization',
        'mitx-morpheus-labs' => 'morpheus-labs',
        'gbpt-poundtoken' => 'poundtoken',
        'dyp-defi-yield-protocol' => 'defi-yield-protocol',
        'xend-xend-finance' => 'xend-finance',
        'dogegf-dogegf' => 'dogegf',
        'btcst-btc-standard-hashrate-token' => 'btc-standard-hashrate-token',
        'psl-pastel' => 'pastel',
        'gswap-gameswap' => 'gameswap-org',
        'sfi-saffronfinance' => 'saffron-finance',
        'k21-k21' => 'k21',
        'par-parallel' => 'par-stablecoin',
        'plastik-plastiks' => 'plastiks',
        'clo-callisto-network' => 'callisto',
        'nsfw-pleasure-coin' => 'pleasure-coin',
        'pet-battle-pets' => 'battle-pets',
        'cummies-cumrocket' => 'cumrocket',
        'hbb-hubble' => 'hubble',
        'gleec-gleec-coin' => 'gleec-coin',
        'mnft-mongol-nft' => 'mongol-nft',
        'polypad-polypad' => 'polypad',
        'lamb-lambda' => 'lambda',
        'cmos-coinmerge-os' => 'coinmerge-os',
        'pbr-polkabridge' => 'polkabridge',
        'safemars-safemars' => 'safemars',
        'cdt-checkdot' => 'checkdot',
        'shill-shill-token' => 'shill-token',
        'aimx-aimedis-new' => 'aimedis-new',
        'mod-modefi' => 'modefi',
        'olt-oneledger' => 'one-ledger',
        'mm-million' => 'million',
        'dpay-devour' => 'devour-2',
        'pls-plutusdao' => 'plutusdao',
        'vidya-vidya' => 'vidya',
        'boring-boringdao' => 'boringdao',
        'mint-mint-club' => 'mint-club',
        'loa-league-of-ancients' => 'league-of-ancients',
        'revu-revuto' => 'revuto',
        'ref-ref-finance' => 'ref-finance',
        'monsta-cake-monster' => 'cake-monster',
        'lode-lodestar' => 'lodestar',
        'woof-woofworkio' => 'woofwork-io',
        'trcl-treecle' => 'treecle',
        'hzn-horizon-protocol' => 'horizon-protocol',
        'vcf-valencia-cf-fan-token' => 'valencia-cf-fan-token',
        'ucx-ucx' => 'ucx',
        'pool-pooltogether' => 'pooltogether',
        'was-wasder' => 'wasder',
        'ixs-ix-swap' => 'ix-swap',
        'welt-fabwelt' => 'fabwelt',
        'nals-nals' => 'nals',
        'elmo-elmoerc' => 'elmoerc',
        'flame-firestarter' => 'firestarter',
        'gmee-gamee' => 'gamee',
        'cirus-cirus' => 'cirus',
        'dpet-my-defi-pet' => 'my-defi-pet',
        'wow-wownero' => 'wownero',
        'credi-credefi' => 'credefi',
        'razor-razor-network' => 'razor-network',
        'pmon-polychain-monsters' => 'polychain-monsters',
        'layer-unilayer' => 'unilayer',
        'nftb-nftb' => 'nftb',
        'maps-maps' => 'maps',
        'lana-lanacoin' => 'lanacoin',
        'perc-perion' => 'perion',
        'rbw-rainbow-token' => 'rainbow-token-2',
        'intr-interlay' => 'interlay',
        'mir-mirror-protocol' => 'mirror-protocol',
        'planets-planetwatch' => 'planetwatch',
        'bbs3-bbs-network' => 'bbs-network',
        'cgg-chain-guardians' => 'chain-guardians',
        'lbl-label-foundation' => 'label-foundation',
        'vlxpad-velaspad' => 'velaspad',
        'traxx-traxx' => 'traxx',
        'fcl-fractal' => 'fractal',
        'galo-clube-atltico-mineiro-fan-token' => 'clube-atletico-mineiro-fan-token',
        'chrp-chirpley' => 'chirpley',
        'donut-donut' => 'donut',
        'c3-charli3' => 'charli3',
        'gfi-gravity-finance' => 'gravity-finance',
        'mcontent-mcontent' => 'mcontent',
        'grain-granary' => 'granary',
        'kingshib-king-shiba' => 'king-shiba',
        'defit-digital-fitness' => 'defit',
        'cct-carbon-credit' => 'carbon-credit',
        'the-thena' => 'thena',
        'theo-theopetra' => 'theopetra',
        'xft-offshift' => 'offshift',
        'tshare-tomb-shares' => 'tomb-shares',
        'april-april' => 'april',
        'handy-handy' => 'handy',
        'path-pathdao' => 'pathdao',
        'airi-airight' => 'airight',
        'bao-bao-finance' => 'bao-finance',
        'dfl-defi-land' => 'defi-land',
        'hxd-honeyland' => 'honeyland-honey',
        'vc6-vinuchain' => 'vinuchain',
        'fluid-fluid' => 'fluid-2',
        'croc-crocbot' => 'crocbot',
        'bs-blacksmith-token' => 'blacksmith-token',
        'beai-benft-solutions' => 'benft-solutions',
        'kat-kambria' => 'kambria',
        'anymtlx-mtlx-erc20' => 'mettalex',
        'asia-asia-coin' => 'asia-coin',
        'wagiebot-wagie-bot' => 'wagie-bot',
        'ethereum-harrypottertrumphomersimpson777inu' => 'harrypottertrumphomersimpson777inu',
        'qr-qrolli' => 'qrolli',
        'wdzoo-degenzoo' => 'degen-zoo',
        'mnr-mineral' => 'mineral',
        'raven-raven-protocol' => 'raven-protocol',
        'scar-velhallaio' => 'velhalla',
        'jup-jupiter' => 'jupiter',
        'loot-lootbot' => 'lootbot',
        'prtc-protectorate-protocol' => 'protectorate-protocol',
        'ngc-naga' => 'naga',
        'xaur-xaurum' => 'xaurum',
        'tomb-tomb' => 'tomb',
        'yak-yield-yak' => 'yield-yak',
        'tkn-monolith' => 'tokencard',
        'mchc-mch-coin' => 'mch-coin',
        'crowd-crowdswap' => 'crowdswap',
        'aero-aerodrome-finance' => 'aerodrome-finance',
        'nmx-nominex' => 'nominex',
        'friend-friend-room' => 'friend-room',
        'pika-pikaboss' => 'pikaboss',
        'solid-solidly' => 'solidlydex',
        'spc-spectra' => 'apwine',
        'usdp-usdp-stablecoin' => 'usdp',
        'buy-burency' => 'burency',
        'tht-thought' => 'thought',
        'nftbs-nftbooks' => 'nftbooks',
        'quartz-sandclock' => 'sandclock',
        'kiba-kiba-inu' => 'kiba-inu',
        'mvpad-metavpad' => 'metavpad',
        'wnk-winkies' => 'the-winkyverse',
        'gene-genomesdao' => 'genomesdao',
        'qi-qi-dao' => 'qi-dao',
        'para-para' => 'paratoken-2',
        'gol-gold' => 'gold-2',
        'alchemist-alchemist' => 'alchemist',
        'bets-betswirl' => 'betswirl',
        'honey-hivemapper' => 'hivemapper',
        'croid-cronos-id' => 'cronos-id',
        'mmy-mummy-finance' => 'mummy-finance',
        'xchf-cryptofranc' => 'cryptofranc',
        'euroe-euroe-stablecoin' => 'euroe-stablecoin',
        'koy-koyo' => 'koyo-6e93c7c7-03a3-4475-86a1-f0bc80ee09d6',
        'reuni-reunit-wallet' => 'reunit-wallet',
        'whee-whee' => 'whee',
        'ut-ulord' => 'ulord',
        'cncl-the-ordinals-council' => 'cncl',
        'eqx-eqifi' => 'eqifi',
        'dragonking-dragonking-bsc' => 'dragonking',
        'xrune-thorstarter' => 'thorstarter',
        'rbc-rubic' => 'rubic',
        'cti-clintex-cti' => 'clintex-cti',
        'deri-deri-protocol' => 'deri-protocol',
        'pickle-pickle-finance' => 'pickle-finance',
        'wom-wom-protocol' => 'wom-token',
        'babyshib2-baby-shiba-inu' => 'baby-shiba-inu-erc',
        'mtrm-materium' => 'materium',
        'd2t-dash-2-trade' => 'dash-2-trade',
        'lgcy-lgcy-network' => 'lgcy-network',
        'vent-vent-finance' => 'vent-finance',
        'bcdt-evidenz' => 'blockchain-certified-data-token',
        'white-whiteheart' => 'whiteheart',
        'lith-lithium-finance' => 'lithium-finance',
        'flut-flute' => 'flute',
        'wsb-wallstreetbets-dapp' => 'wall-street-bets-dapp',
        'news-publish' => 'publish',
        'adax-adax' => 'adax',
        'bsx-basilisk' => 'basilisk',
        'liq-liquidus' => 'liquidus',
        'auto-auto' => 'auto',
        'excc-exchangecoin' => 'exchangecoin',
        'ddim-duckdaodime' => 'duckdaodime',
        'suter-suterusu' => 'suterusu',
        'ice-decentral-games-ice' => 'decentral-games-ice',
        'wam-wam' => 'wam',
        'bit-biconomy-exchange-token' => 'biconomy-exchange-token',
        'ppt-populous' => 'populous',
        'pepe-pepe-ordinals' => 'pepebrc',
        'juld-julswap' => 'julswap',
        'breed-breederdao' => 'breederdao',
        'edg-edgeware' => 'edgeware',
        'id-everest' => 'everid',
        'hibs-hiblocks' => 'hiblocks',
        'shroom-niftyx-protocol' => 'shroom-finance',
        'ufi-purefi' => 'purefi',
        'sbr-saber' => 'saber',
        'fara-faraland' => 'faraland',
        'pooh-pooh' => 'pooh',
        'maha-mahadao' => 'mahadao',
        'dingo-dingocoin' => 'dingocoin',
        'shopx-splyt' => 'splyt',
        'xsp-xswap-protocol' => 'xswap-protocol',
        'polx-polylastic' => 'polylastic',
        'am-aston-martin-cognizant-fan-token' => 'aston-martin-cognizant-fan-token',
        'ryo-ryo-currency' => 'ryo',
        'roco-roco-finance' => 'roco-finance',
        'ait-aichain' => 'aichain',
        'trl-triall' => 'triall',
        'kom-kommunitas' => 'kommunitas',
        'dec-decentr' => 'decentr',
        'han-hanchain' => 'hanchain',
        'xwin-xwin-finance' => 'xwin-finance',
        'savg-savage' => 'savage',
        'diver-divergence-protocol' => 'divergence-protocol',
        'zee-zeroswap' => 'zeroswap',
        'dashd-dash-diamond' => 'dash-diamond',
        'strong-strong' => 'strong',
        'cah-moon-tropica' => 'moon-tropica',
        'peak-peakdefi' => 'marketpeak',
        'quidd-quidd' => 'quidd',
        'spi-shoppingio' => 'shopping-io-token',
        'dogo-dogemongo' => 'dogemon-go',
        'banana-banana' => 'banana',
        'pex-peardao' => 'peardao',
        'xy-xy-finance' => 'xy-finance',
        'pinu-piccolo-inu' => 'piccolo-inu',
        'acs-acryptos' => 'acryptos',
        'paper-dope-wars-paper' => 'dope-wars-paper',
        'dcn-dentacoin' => 'dentacoin',
        'conv-convergence' => 'convergence',
        '0xbtc-0xbitcoin' => 'oxbitcoin',
        'dnxc-dinox' => 'dinox',
        'mooi-mooi-network' => 'mooi-network',
        'ari10-ari10' => 'ari10',
        'tronpad-tronpad' => 'tronpad',
        'ybo-young-boys-fan-token' => 'young-boys-fan-token',
        'tower-tower' => 'tower',
        'wliti-wliti' => 'wliti',
        'jet-jet' => 'jet',
        'ghost-ghost' => 'ghost-by-mcafee',
        'blank-blockwallet' => 'blank',
        'dacxi-dacxi' => 'dacxi',
        'trubgr-trubadger' => 'trubadger',
        'bcube-b-cubeai' => 'b-cube-ai',
        'ctg-city-tycoon-games' => 'city-tycoon-games',
        'obot-obortech' => 'obortech',
        'standard-stakeborg-dao' => 'stakeborg-dao',
        'yon-yesorno' => 'yesorno',
        'xpnet-xp-network' => 'xp-network',
        'lqdr-liquiddriver' => 'liquiddriver',
        'belt-belt' => 'belt',
        'hyve-hyve' => 'hyve',
        'ibs-ibs' => 'ibs',
        'polc-polkacity' => 'polka-city',
        'dobo-dogebonk1' => 'dogebonk',
        'move-mover' => 'holyheld-2',
        'ibfk-istanbul-baakehir-fan-token' => 'istanbul-basaksehir-fan-token',
        'idna-idena' => 'idena',
        'erowan-sifchain' => 'sifchain',
        'zik-ziktalk' => 'zik-token',
        'pineowl-pineapple-owl' => 'pineapple-owl',
        'archi-archi-token' => 'archi-token',
        'naos-naos-finance' => 'naos-finance',
        'vnxau-vnx-gold' => 'vnx-gold',
        'islami-islamicoin' => 'islamicoin',
        'collab-collabland' => 'collab-land',
        'moda-moda-dao' => 'moda-dao',
        'geni-genius' => 'genius',
        'iux-geniux' => 'geniux',
        'gaia1-gaia-everworld' => 'gaia-everworld',
        'rvc-revenue-coin' => 'revenue-coin',
        'acn-acorn-protocol' => 'acorn-protocol',
        'zero-zeroliquid' => 'zeroliquid',
        'hoshi-dejitaru-hoshi' => 'dejitaru-hoshi',
        'act-achain' => 'achain',
        'sashimi-sashimi' => 'sashimi',
        'kat-karat' => 'karat',
        'dax-daex' => 'daex',
        'rsc-researchcoin' => 'researchcoin',
        'mega-megaton-finance' => 'megaton-finance',
        '1art-artwallet' => '1art',
        'bft4-brazil-national-football-team-fan-token' => 'brazil-fan-token',
        'etp-metaverse-etp' => 'metaverse-etp',
        'nolo-yolonolo' => 'yolonolo',
        'aag-aag' => 'aag-ventures',
        'kale-bluelight' => 'bluelight',
        'spex-speciex' => 'speciex',
        'cnfi-connect-financial' => 'connect-financial',
        'ccv2-cryptocart-v2' => 'cryptocart',
        'txag-tsilver' => 'tsilver',
        'elk-elk-finance' => 'elk-finance',
        'sntr-silent-notary' => 'silent-notary',
        'box-defibox' => 'defibox',
        'btsg-bitsong' => 'bitsong',
        'jur-jur' => 'jur',
        'klee-kleekai' => 'kleekai',
        'uwl-uniwhales' => 'uniwhales',
        'depay-depay' => 'depay',
        'media-media-network' => 'media-network',
        'cwt-crosswallet' => 'crosswallet',
        'nfd-feisty-doge-nft' => 'feisty-doge-nft',
        'mia-miamicoin' => 'miamicoin',
        'zoo-zookeeper' => 'zookeeper',
        'tcr-tracer-dao' => 'tracer-dao',
        'tem-templar-dao' => 'templardao',
        'quad-quadency' => 'quadency',
        'lit-lit' => 'lit',
        'newo-new-order' => 'new-order',
        'gton-graviton' => 'graviton',
        'phonon-phonon-dao' => 'phonon-dao',
        'ertha-ertha' => 'ertha',
        'gm-gm' => 'gm',
        'rendoge-rendoge' => 'rendoge',
        'navi-natus-vincere-fan-token' => 'natus-vincere-fan-token',
        'pal-paladin' => 'paladin',
        'apollo-apollo' => 'apollo',
        'ape-ape-finance' => 'ape-finance',
        'radio-radioshack' => 'radioshack',
        'mvd-metavault-dao' => 'metavault-dao',
        'xdb-digitalbits' => 'digitalbits',
        'itp-interport-token' => 'interport-token',
        'y2k-y2k' => 'y2k',
        'hsuite-hbarsuite' => 'hsuite',
        'libre-libre' => 'libre',
        'move-bluemove' => 'bluemove',
        'plq-planq' => 'planq',
        'pumlx-pumlx' => 'pumlx',
        'moz-mozaic' => 'mozaic',
        'orpo-orpo' => 'orpo',
        'xing-xing' => 'xing',
        'zat-zkapes-token' => 'zkapes-token',
        'xcash-x-cash' => 'x-cash',
        'akro-akropolis' => 'akropolis',
        'thn-throne' => 'throne',
        'kono-konomi-network' => 'konomi-network',
        'realm-realm' => 'realm',
        'rbd-rubidium' => 'rubidium',
        'smi-safemoon-inu' => 'safemoon-inu',
        'roush-roush-fenway-racing-fan-token' => 'roush-fenway-racing-fan-token',
        'btcz-bitcoinz' => 'bitcoinz',
        'primal-primal' => 'primal-b3099cd0-995a-4311-80d5-9c133153b38e',
        'drk-draken' => 'draken',
        'nord-nord-finance' => 'nord-finance',
        'afr-afreum' => 'afreum',
        'mph-88mph' => '88mph',
        'dps-deepspace' => 'deepspace',
        'ttk-the-three-kingdoms' => 'the-three-kingdoms',
        'gai-generaitiv' => 'generaitiv',
        'tidal-tidal-finance' => 'tidal-finance',
        'd-denarius' => 'denarius',
        'ztg-zeitgeist' => 'zeitgeist',
        'ppay-plasma-finance' => 'plasma-finance',
        'fst-futureswap' => 'futureswap',
        'xor-sora' => 'sora',
        'piza-piza-ordinals' => 'pizabrc',
        'nabox-nabox' => 'nabox',
        'cope-cope' => 'cope',
        'degen-degenreborn' => 'degenreborn',
        'kuma-kuma-inu' => 'kuma-inu',
        'ptp-platypus-finance' => 'platypus-finance',
        'like-only1' => 'only1',
        'gomt-gomeat' => 'gomeat',
        'rin-aldrin' => 'aldrin',
        'oja-ojamu' => 'ojamu',
        'oggy1-oggy-inu' => 'oggy-inu',
        'coc-coin-of-the-champions' => 'coin-of-the-champions',
        'wnt-wicrypt' => 'wicrypt',
        'plot-plotx' => 'plotx',
        'jam-tunefm' => 'tune-fm',
        'kint-kintsugi' => 'kintsugi',
        'dweb-decentraweb' => 'decentraweb',
        'must-must' => 'must',
        'blxm-bloxmove' => 'bloxmove-erc20',
        'zillionxo-zillion-aakar-xo' => 'zillion-aakar-xo',
        '1flr-flare-token' => 'flare-token',
        'wmx-wombex' => 'wombex',
        'keke-kek' => 'kek',
        'opium-opium' => 'opium',
        'adm-adamant-messenger' => 'adamant-messenger',
        'pgx-pegaxy-stone' => 'pegaxy-stone',
        'ccx-conceal' => 'conceal',
        'slrs-solrise-finance' => 'solrise-finance',
        'matter-antimatter' => 'antimatter',
        'pilot-unipilot' => 'unipilot',
        'bsk-bitcoinstaking' => 'bitcoinpos',
        'game-gamestarter' => 'gamestarter',
        'pxc-phoenixcoin' => 'phoenixcoin',
        'woop-woonkly-power' => 'woonkly-power',
        'navi-atlas-navi' => 'atlas-navi',
        'bcmc-blockchain-monster-hunt' => 'blockchain-monster-hunt',
        'vxl-voxel-x-network' => 'voxel-x-network',
        'txa-txa' => 'txa',
        'cofi-cofix' => 'cofix',
        'tyrant-fable-of-the-dragon' => 'fable-of-the-dragon',
        'ethpad-ethpad' => 'ethpad',
        'gnd-gnd-protocol' => 'gnd-protocol',
        'sg-socialgood' => 'social-good-project',
        'four-fourcoin' => 'fourcoin',
        'clh-cleardao' => 'cleardao',
        'slcl-solcial' => 'solcial',
        'bird-birdmoney' => 'bird-money',
        'mint-public-mint' => 'public-mint',
        'bgvt-bit-game-verse-token' => 'bit-game-verse-token',
        'aart-allart' => 'all-art',
        'yec-ycash' => 'ycash',
        'bpro-bprotocol' => 'b-protocol',
        'nftart-nft-art-finance' => 'nft-art-finance',
        'vcg-vcgamers' => 'vcgamers',
        'vab-vabble' => 'vabble',
        'xcur-curate' => 'curate',
        'maro-maro' => 'ttc-protocol',
        'dop-drops-ownership-power' => 'drops-ownership-power',
        'bull7-bullieverse' => 'bullieverse',
        'xct-citadelone' => 'citadel-one',
        'tyrion-tyrionfinance' => 'tyrion-finance',
        'noisegpt-noisegpt' => 'noisegpt',
        'rating-dprating' => 'dprating',
        'ten-tokenomy' => 'tokenomy',
        'stacks-stacks' => 'stacks',
        'hola-hola-token' => 'hola-token',
        'mane-mane' => 'mane',
        'eng-enigma' => 'enigma',
        'sfil-filecoin-standard-full-hashrate' => 'filecoin-standard-full-hashrate',
        'pepes-mcpepes' => 'mcpepe-s',
        'froggy-froggy' => 'froggy',
        'enq-enecuum' => 'enq-enecuum',
        'quicki-quick-intel' => 'quick-intel',
        'npc-non-playable-coin' => 'non-playable-coin',
        'fakeai-deepfakeai' => 'deepfakeai',
        'turbos-turbos-finance' => 'turbos-finance',
        'kit-dexkit' => 'dexkit',
        'fund-teh-fund' => 'teh-fund',
        'ionx-charged-particles' => 'charged-particles',
        'mtvt-metaverser' => 'metaverser',
        'pirb-pirb' => 'pirb',
        'lotty-lotty' => 'lotty',
        'bir-birake' => 'birake',
        'fyp-flypme' => 'flypme',
        'abl-airbloc' => 'airbloc-protocol',
        'fhm-fantohm' => 'fantohm',
        'dnt-definder-network' => 'smartlands',
        'swag-swag-finance' => 'swag-finance',
        'gfly-battlefly' => 'battlefly',
        'cai-colony-avalanche-index' => 'colony-avalanche-index',
        'xmx-xmax' => 'xmax',
        'hoa-hex-orange-address' => 'hex-orange-address',
        'ufo-uniform-fiscal-object' => 'ufocoin',
        'pact-impactmarket' => 'impactmarket',
        'mork-mork' => 'mork',
        'epk-epik-protocol' => 'epik-protocol',
        'unic-unicly' => 'unicly',
        'yup-yup' => 'yup',
        'zwap-zilswap' => 'zilswap',
        'b20-b20' => 'b20',
        'oil-oiler' => 'oiler',
        'snp-synapse-network' => 'synapse-network',
        'pika-pika' => 'pikachu',
        'kccpad-kccpad' => 'kccpad',
        'smbr-sombra' => 'sombra-network',
        'unv-unvest' => 'unvest',
        'gamma-green-planet' => 'green-planet',
        'wegro-wegro' => 'wegro',
        'usv-atlas-usv' => 'atlas-usv',
        'tho-thorus' => 'thorus',
        'haus-daohaus' => 'daohaus',
        'aurora-aurora-chain' => 'aurora',
        'os-ethereans' => 'ethereans',
        'ubxt-upbots' => 'upbots',
        'vis-envision' => 'envision',
        'kok-kok' => 'kok',
        'funex-funex' => 'funex',
        'gob-goons-of-balatroon' => 'goons-of-balatroon',
        'zyx-zyx' => 'zyx',
        'dsm-desmos' => 'desmos',
        'ube-ubeswap' => 'ubeswap',
        'hnst-honest' => 'honest-mining',
        'net-next' => 'nextexchange',
        'mare-mare-finance' => 'mare-finance',
        'pivn-pivn' => 'pivn',
        'pry-perpy-finance' => 'perpy-finance',
        'rssc-rssc' => 'rssc',
        'iqn-iqeon' => 'iqeon',
        'euno-euno' => 'euno',
        'yon-hummus' => 'hummus',
        'svy-savvy' => 'savvy-defi',
        'edg-edgeless' => 'edgeless',
        'wsg-wall-street-games' => 'wall-street-games',
        'pln-pollen' => 'pollen',
        'cramer-cramer-coin' => 'cramer-coin',
        'port-port-finance' => 'port-finance',
        'tpro-tpro' => 'tpro',
        'spore-spore' => 'spore',
        'fly-franklin' => 'franklin',
        'minds-minds' => 'minds',
        'mefa-metaverse-face' => 'metaverse-face',
        'rfuel-riodefi' => 'rio-defi',
        'pbtc35a-pbtc35a' => 'pbtc35a',
        'tia-tia' => 'tia',
        'nftd-nftrade' => 'nftrade',
        'sensi-sensi' => 'sensi',
        'unistake-unistake' => 'unistake',
        'octo-octofi' => 'octofi',
        'che-cherryswap' => 'cherryswap',
        'pkr-polker' => 'polker',
        'catheon-catheon-gaming' => 'catheon-gaming',
        'mass-mass' => 'mass',
        'trava-trava-finance' => 'trava-finance',
        'nitro-nitro-league' => 'nitro-league',
        'dlta-deltatheta' => 'delta-theta',
        'bmon-binamon' => 'binamon',
        'skill-cryptoblades' => 'cryptoblades',
        'spo-spores-network' => 'spores-network',
        'efx-effect-network' => 'effect-network',
        'bsty-globalboost-y' => 'globalboost',
        'ad-adreward' => 'adreward',
        'slice-tranche-finance' => 'tranche-finance',
        'pym-playermon' => 'playermon',
        'aur-auroracoin' => 'auroracoin',
        'free-freerossdao' => 'freerossdao',
        'dzg-dinamo-zagreb-fan-token' => 'dinamo-zagreb-fan-token',
        'tyc-tycoon' => 'tycoon',
        'ceres-ceres' => 'ceres',
        'satt-satt' => 'satt',
        'veil-veil' => 'veil',
        'fts-footballstars' => 'footballstars',
        'ace-acent' => 'acent',
        'html-htmlcoin' => 'htmlcoin',
        'zoon-cryptozoon' => 'cryptozoon',
        'rite-ritestream' => 'ritestream',
        'allin-all-in' => 'all-in',
        'brn-brn-metaverse' => 'brn-metaverse',
        'hakka-hakka-finance' => 'hakka-finance',
        'kif-kittenfinance' => 'kittenfinance',
        'cali-calicoin' => 'calicoin',
        'albt-allianceblock' => 'allianceblock',
        'hgold-hollygold' => 'hollygold',
        'dcau-dragon-crypto-aurum' => 'dragon-crypto-aurum',
        'vtx-vector-finance' => 'vector-finance',
        'qrk-quark' => 'quark',
        '1earth-earthfund' => 'earthfund',
        'toko-tokoin' => 'toko',
        'neobot-neobot' => 'neobot',
        'vision-apyvision' => 'apy-vision',
        'glch-glitch-protocol' => 'glitch-protocol',
        'ram-ramses-exchange' => 'ramses-exchange',
        'trace-trace-network-labs' => 'trace-network-labs',
        'drf-derify-protocol' => 'derify-protocol',
        'fodl-fodl-finance' => 'fodl-finance',
        'acsi-acryptosi' => 'acryptosi',
        'elfi-elyfi' => 'elyfi',
        'base-base-protocol' => 'base-protocol',
        'mts-metastrike' => 'metastrike',
        'vrx-verox' => 'verox',
        'spirit-spiritswap' => 'spiritswap',
        'blt-bloom' => 'bloom',
        'kmc-kitsumon' => 'kitsumon',
        'guild-blockchainspace' => 'blockchainspace',
        'kripto-kripto' => 'kripto',
        'balpha-balpha' => 'balpha',
        'kicks-getkicks' => 'getkicks',
        'santa-santa-coin' => 'santa-coin-2',
        'sumo-sumokoin' => 'sumokoin',
        'ico-kattana' => 'kattana',
        'mota-motacoin' => 'motacoin',
        'ferma-ferma' => 'ferma',
        'tab-tabank' => 'tabank',
        'bxx-baanx' => 'baanx',
        'ngm-e-money' => 'e-money',
        'ubq-ubiq' => 'ubiq',
        'kampay-kampay' => 'kampay',
        'ocn-odyssey' => 'odyssey',
        'avi-aviator' => 'aviator',
        'kcn-kylacoin' => 'kylacoin',
        'mewc-meowcoin' => 'meowcoin',
        'bft-bnktothefuture' => 'bnktothefuture',
        'kibshi-kiboshib' => 'kiboshib',
        'zix-coinzix-token' => 'coinzix-token',
        'ort-okratech' => 'okratech-token',
        'endcex-endpoint-cex-fan-token' => 'endpoint-cex-fan-token',
        'itgr-integral1132' => 'integral',
        'cat-cat' => 'cat-cat-token',
        'shezmu-shezmu' => 'shezmu',
        'pirate-piratecash' => 'piratecash',
        'ava-ava' => 'avatly',
        'uniq-uniqly' => 'uniqly',
        'cpc-cpchain' => 'cpchain',
        'scrl-wizarre-scroll' => 'wizarre-scroll',
        'phtr-phuture' => 'phuture',
        'meowl-meowl' => 'meowl',
        'mmo-mad-meerkat-optimizer' => 'mad-meerkat-optimizer',
        'gse-gsenetwork' => 'gsenetwork',
        'nftl-nftlaunch' => 'nftlaunch',
        'ptm-potentiam' => 'potentiam',
        'arcona-arcona' => 'arcona',
        'vbk-veriblock' => 'veriblock',
        'cards-cardstarter' => 'cardstarter',
        'sov-shiboriginalvision' => 'shib-original-vision',
        'uncl-uncl' => 'uncl',
        'ptoy-patientory' => 'patientory',
        'abr-allbridge' => 'allbridge',
        'blx-blocx' => 'blocx-3',
        'primate-primate' => 'primate',
        'revo-revomon' => 'revomon-2',
        'led-ledgis' => 'ledgis',
        'qrx-quiverx' => 'quiverx',
        'pussy-pussy-financial' => 'pussy-financial',
        'nft-nft-protocol' => 'nft-protocol',
        'jack-jackpot' => 'jackpot',
        'pin-public-index-network' => 'public-index-network',
        'treat-treatdao' => 'treatdao-v2',
        'dxl-dexlab' => 'dexlab',
        'rhythm-rhythm' => 'rhythm',
        'ekta-ekta' => 'ekta-2',
        'polar-polar-sync' => 'polar-sync',
        'dmagic-dark-magic' => 'dark-magic',
        'xnl-chronicle' => 'chronicle',
        'verse-shibaverse' => 'shibaverse',
        'nftl-nifty-league' => 'nifty-league',
        'pawth-pawthereum' => 'pawthereum',
        'lnr-lunar' => 'lunar-2',
        'mgh-metagamehub-dao' => 'metagamehub-dao',
        'ixo-ixo' => 'ixo',
        'drug-dopewarz' => 'dopewarz',
        'pop-popcorn' => 'popcorn',
        'coc-cocktailbarfinance' => 'cocktailbar',
        'nett-netswap' => 'netswap',
        'hdao-humandao' => 'humandao',
        'stake-stake' => 'xdai-stake',
        'sku-sakura' => 'sakura',
        'portx-chainport' => 'chainport',
        'krypto-kryptonite' => 'kryptonite',
        'mstr-monsterra' => 'monsterra',
        'azzr-azzure' => 'aezora',
        'myc-mycelium' => 'mycelium',
        'chai-chai' => 'chai',
        'eeur-e-money-eur' => 'e-money-eur',
        'fls-flits' => 'flits',
        'duckies-yellow-duckies' => 'duckies',
        'wynd-wynd' => 'wynd',
        'kwai-kwai' => 'kwai',
        'igg-ig-gold' => 'ig-gold',
        'aipad-aipad' => 'aipad',
        'mpx-morphex' => 'mpx',
        'opct-opacity' => 'opacity',
        'zoomer-zoomer' => 'zoomer',
        'byld-byld' => 'byld',
        'cat-cyber-arena' => 'cyber-arena',
        'asap-asap-sniper-bot' => 'asap-sniper-bot',
        'mef-frenbot' => 'frenbot',
        'movez-movez' => 'movez',
        'hget-hedget' => 'hedget',
        'dogira-dogira' => 'dogira',
        'lkr-lokr' => 'lokr',
        'stnd-standard-protocol' => 'standard-protocol',
        'brkl-brokoli' => 'brokoli',
        'astro-astroport' => 'astroport',
        'apl-apollon-limassol-fan-token' => 'apollon-limassol',
        'sheesha-sheesha-finance-erc20' => 'sheesha-finance-erc20',
        'dough-piedao-dough-v2' => 'piedao-dough-v2',
        'bright-bright-union' => 'bright-union',
        'shred-shredn' => 'shredn',
        'swop-swop' => 'swop',
        'wndr-wonderman-nation' => 'wonderman-nation',
        'rain-rainmaker-games' => 'rainmaker-games',
        'gth-gather' => 'gather',
        'sean-starfish-finance' => 'starfish-finance',
        'obx-openblox' => 'openblox',
        'play-herocoin' => 'herocoin',
        'hunny-hunny-finance' => 'pancake-hunny',
        'zodi-zodium' => 'zodium',
        'cre8-creaticles' => 'creaticles',
        'roy-crypto-royale' => 'crypto-royale',
        'pma-pumapay' => 'pumapay',
        'bnsd-bnsd-finance' => 'bnsd-finance',
        'bank-bank-ordinals' => 'bankbrc',
        'peri-peri-finance' => 'peri-finance',
        'crbn-carbon' => 'carbon',
        'dawn-dawn-protocol' => 'dawn-protocol',
        'arx-arcs' => 'arcs',
        'ps1-polysports' => 'polysports',
        'catpay-catpay' => 'catpay',
        'nyzo-nyzo' => 'nyzo',
        'shik-shikoku' => 'shikoku',
        'fabric-metafabric' => 'metafabric',
        'cai-club-atletico-independiente-fan-token' => 'club-atletico-independiente',
        'ivn-investin' => 'investin',
        'gnx-genaro-network' => 'genaro-network',
        'teer-integritee' => 'integritee',
        'gdoge-golden-doge' => 'golden-doge',
        'udo-unido' => 'unido-ep',
        'sunny-sunny-aggregator' => 'sunny-aggregator',
        'cpd-coinspaid' => 'coinspaid',
        'zefu-zenfuse' => 'zenfuse',
        'gltr-gax-liquidity-token-reward' => 'gax-liquidity-token-reward',
        'yeti-yeti-finance' => 'yeti-finance',
        'dev-dev-protocol' => 'dev-protocol',
        'life-life-crypto' => 'life-crypto',
        'fame-fantom-maker' => 'fantom-maker',
        'one-civfund-stone' => 'civfund-stone',
        'xio-blockzero-labs' => 'xio',
        'if-impossible-finance' => 'impossible-finance',
        'exm-exmo-coin' => 'exmo-coin',
        'husky-husky-avax' => 'husky-avax',
        'don-don-key' => 'don-key',
        'vatreni-croatian-ff-fan-token' => 'croatian-ff-fan-token',
        'ducker-duckereum' => 'duckereum',
        'ptf-powertrade-fuel' => 'powertrade-fuel',
        'sarco-sarcophagus' => 'sarcophagus',
        'bmi-bridge-mutual' => 'bridge-mutual',
        'bfly-butterfly-protocol' => 'butterfly-protocol-2',
        'babi-babylons' => 'babylons',
        'nbs-new-bitshares' => 'new-bitshares',
        'urqa-ureeqa' => 'ureeqa',
        'swrv-swerve' => 'swerve-dao',
        'etho-ethoprotocol' => 'ether-1',
        'shi-shirtum' => 'shirtum',
        'mfg-smart-mfg' => 'smart-mfg',
        'nation-nation3' => 'nation3',
        'tube-bittube' => 'bittube',
        'swingby-swingby' => 'swingby',
        'tnd-tenderfi' => 'tender-fi',
        'starship-starship' => 'starship',
        'lev-levante-ud-fan-token' => 'levante-ud-fan-token',
        'kft-knit-finance' => 'knit-finance',
        'egg-goose-finance' => 'goose-finance',
        'gst-gunstar-metaverse' => 'gunstar-metaverse',
        'maki-makiswap' => 'makiswap',
        'dogec-dogecash' => 'dogecash',
        'crvy-curve-inu' => 'curve-inu',
        'propel-propel' => 'propel-token',
        'arbot-alpha-radar-bot' => 'alpha-radar-bot',
        'pak-pakcoin' => 'pakcoin',
        'snet-snetwork' => 'snetwork',
        'wico-wecoin' => 'wecoin',
        'tflow-tradeflow' => 'tradeflow',
        'gysr-geyser' => 'geyser',
        'wojack269-wojak-269' => 'wojak-2-69',
        'ius-iustitia-coin' => 'iustitia-coin',
        'enter-enter' => 'enter',
        'elec-electrifyasia' => 'electrify-asia',
        'tct-tokenclub' => 'tokenclub',
        'ddd-scryinfo' => 'scry-info',
        'ddos-disbalancer' => 'disbalancer',
        'mt-mytoken' => 'mytoken',
        'hit-hitchain' => 'hitchain',
        'xeq-equilibria' => 'triton',
        'moond-moonsdust' => 'moonsdust',
        'valas-valas-finance' => 'valas-finance',
        '0xmr-0xmonero' => '0xmonero',
        'zero-0exchange' => 'zero-exchange',
        'blitz-blitz-labs' => 'blitz-labs',
        'utu-utu-coin' => 'utu-coin',
        'cub-cub-finance' => 'cub-finance',
        'mooned-moonedge' => 'moonedge',
        'shizu-shih-tzu' => 'shih-tzu',
        'shak-shakita-inu' => 'shakita-inu',
        'her-herity-network' => 'herity-network',
        'vibe-vibe' => 'vibe',
        'trc-terracoin' => 'terracoin',
        'ktlyo-katalyo' => 'katalyo',
        'edda-eddaswap' => 'eddaswap',
        'ppblz-pepemon-pepeballs' => 'pepemon-pepeballs',
        'fnt-falcon-project' => 'falcon-token',
        'vrn-varen' => 'varen',
        'odin-odin-protocol' => 'odin-protocol',
        'luchow-lunachow' => 'lunachow',
        'hnd-hundred-finance' => 'hundred-finance',
        'celt-celestial' => 'celestial',
        'radar-radar' => 'radar',
        'gaze-gazetv' => 'gazetv',
        'hotcross-hot-cross' => 'hot-cross',
        'desu-dexsport' => 'dexsport',
        'fsw-falconswap' => 'fsw-token',
        'robot-robot' => 'robot',
        'gg-gg' => 'gg-token',
        'hyper-hyperchainx' => 'hyperchainx',
        'filda-filda' => 'filda',
        'spell-spellfire' => 'spellfire',
        'bog-bogged-finance' => 'bogged-finance',
        'skuy-sekuya' => 'sekuya',
        'xkawa-kawakami' => 'kawakami',
        'ruby-ruby' => 'ruby',
        'oks-oikos' => 'oikos',
        'four-4thpillar-technologies' => 'the-4th-pillar',
        'wave-wavelength' => 'wavelength',
        'equal-equalizer-dex' => 'equalizer-dex',
        'neu-neutra-finance' => 'neutra-finance',
        'zyb-zyberswap' => 'zyberswap',
        'ixi-ixian' => 'ixicash',
        'volt-voltage-finance' => 'fusefi',
        'cmst-composite' => 'composite',
        'flow-velocimeter-flow' => 'velocimeter-flow',
        'space-spacefi' => 'spacefi-zksync',
        'lunes-lunes' => 'lunes',
        'vdl-vidulum' => 'vidulum',
        'arbi-arbipad' => 'arbipad',
        'szab-szab' => 'szab',
        'insc-insc' => 'insc',
        'maxi-maxi-ordinals' => 'maxi-ordinals',
        'grum-grumpy' => 'grumpy',
        'shib-niccagewaluigielmo42069inu' => 'niccagewaluigielmo42069inu',
        'wpr-wepower' => 'wepower',
        'cjpy-convertible-jpy-token' => 'convertible-jpy-token',
        'cag-change' => 'change',
        'emd-emerald-crypto' => 'emerald-crypto',
        'xbc-bitcoin-plus' => 'bitcoin-plus',
        'metal-drunk-robots' => 'drunk-robots',
        'algoblk-algoblocks' => 'algoblocks',
        'crw-crown' => 'crown',
        'naft-nafter' => 'nafter',
        'msr-masari' => 'masari',
        'hams-hamsters' => 'hamsters',
        'pinkm-pinkmoon' => 'pinkmoon',
        'orion-orion-money' => 'orion-money',
        'share-seigniorage-shares' => 'seigniorage-shares',
        'drc-digital-reserve-currency' => 'digital-reserve-currency',
        'apy-apyfinance' => 'apy-finance',
        'drac-drac-ordinals' => 'drac-ordinals',
        'helmet-helmet-insure' => 'helmet-insure',
        'alpa-alpaca-city' => 'alpaca',
        'klo-kalao' => 'kalao',
        'snk-snook' => 'snook',
        'gof-golff' => 'golff',
        'fyd-fydcoin' => 'fydcoin',
        'ai-flourishing-ai' => 'flourishing-ai-token',
        'evereth-evereth' => 'evereth',
        'kacy-kassandra' => 'kassandra',
        'mojo-mojito' => 'mojito',
        'cot-cotrader' => 'cotrader',
        'dfy-defi-for-you' => 'defi-for-you',
        'pacoca-pacoca' => 'pacoca',
        'gmat-gowithmi' => 'gowithmi',
        'dis-tosdis' => 'tosdis',
        'moca-museum-of-crypto-art' => 'museum-of-crypto-art',
        'cfi-cyberfi' => 'cyberfi',
        'gio-graviocoin' => 'graviocoin',
        'nrfb-nurifootball' => 'nurifootball',
        'cheems-cheems' => 'cheems',
        'phnx-phoenixdao' => 'phoenixdao',
        'inuko-inuko-finance' => 'inuko-finance',
        'tkb-tokenbot' => 'tokenbot',
        'bezoge-bezoge-earth' => 'bezoge-earth',
        'rfi-reflectfinance' => 'reflect-finance',
        'ares-ares-protocol' => 'ares-protocol',
        'glb-golden-ball' => 'golden-ball',
        'eland-etherland' => 'etherland',
        'bni-bitindi-chain' => 'bitindi-chain',
        'inxt-internxt' => 'internxt',
        'mofi-mobifi' => 'mobifi',
        'bzn-benzene' => 'benzene',
        'taste-tastenft' => 'tastenft',
        'metadoge-meta-doge' => 'meta-doge',
        'xmy-myriad' => 'myriadcoin',
        'sphri-spherium' => 'spherium',
        'stak-jigstack' => 'jigstack',
        'trade-unitrade' => 'unitrade',
        'mudol2-hero-blaze-three-kingdoms' => 'hero-blaze-three-kingdoms',
        'husl-the-husl' => 'the-husl',
        'mnst-moonstarter' => 'moonstarter',
        'pwar-polkawar' => 'polkawar',
        'fpft-peruvian-national-football-team-fan-token' => 'peruvian-national-football-team-fan-token',
        'bolt-boltbot' => 'boltbot',
        'eved-evedo' => 'evedo',
        'gas-gas-dao' => 'gas-dao',
        'mscp-moonscape' => 'moonscape',
        'fiwa-defi-warrior' => 'defi-warrior',
        'cook-cook' => 'cook',
        'cleg-chain-of-legends' => 'chain-of-legends',
        'upi-pawtocol' => 'pawtocol',
        'chad-chad-coin' => 'chad-coin',
        '8pay-8pay' => '8pay',
        'poli-polinate' => 'polinate',
        'tank-cryptotanks' => 'cryptotanks',
        'mer-mercurial' => 'mercurial',
        'yield-yield-protocol' => 'yield-protocol',
        'crp-cropperfinance' => 'cropperfinance',
        'axis-axis-defi' => 'axis-defi',
        'bry-berry-data' => 'berry-data',
        'prare-polkarare' => 'polkarare',
        'zuki-zuki-moba' => 'zuki-moba',
        'cau-canxium' => 'canxium',
        'gaj-gaj-finance' => 'gaj',
        'cns-centric-swap' => 'centric-cash',
        'tenfi-ten' => 'ten',
        'noot-noot-ordinals' => 'noot-ordinals',
        'bao-bao-finance-v2' => 'bao-finance-v2',
        'agb-agbcoin' => 'apes-go-bananas',
        'scream-scream' => 'scream',
        'zdex-zeedex' => 'zeedex',
        'bls-metacourt' => 'blocsport-one',
        'fuel-etherparty' => 'etherparty',
        'lsd-lsd-coin' => 'lsdx-finance',
        'zsc-zeusshield' => 'zeusshield',
        'eft-eternalflow' => 'eternalflow',
        'zat-zeusaitrading' => 'zeusaitrading',
        'box-contentbox' => 'contentbox',
        'cnns-cnns' => 'cnns',
        'mtn-medicalchain' => 'medicalchain',
        'mbd-mbd-financials' => 'mbd-financials',
        'kt-kingdomx' => 'kingdomx',
        'plx-parallax' => 'parallax',
        'bpriva-priva' => 'privapp-network',
        'dos-dos-network' => 'dos-network',
        'corgi-corgicoin' => 'corgicoin',
        'eosdac-eosdac' => 'eosdac',
        'skm-skrumble-network' => 'skrumble-network',
        'nux-peanut-bep-20' => 'peanut',
        'kol-kollect' => 'kollect',
        'cofi-coinfi' => 'coinfi',
        'bcdn-blockcdn' => 'blockcdn',
        'xdn-digitalnote' => 'digitalnote',
        'nfts-nft-stars' => 'nft-stars',
        'lqt-lifty' => 'liquidifty',
        'fusion-fusionbot' => 'fusionbot',
        'lead-lead' => 'lead-token',
        'linu-luna-inu' => 'luna-inu',
        'ap-appleswap-ai' => 'appleswap-ai',
        'dvt-devault' => 'devault',
        'ecoin-ecoin-finance' => 'ecoin-finance',
        'rainbow-rainbowtoken' => 'rainbowtoken',
        'soul-soul-swap' => 'soul-swap',
        'tanks-tanks' => 'tanks',
        'merge-merge' => 'merge',
        'vvt-versoview' => 'versoview',
        'mfi-marginswap' => 'marginswap',
        'skull-skull' => 'skull',
        'kangal-kangal' => 'kangal',
        'ebox-ethbox-token' => 'ebox',
        'astro-astrotools' => 'astrotools',
        'bull-bull-coin' => 'bull-coin',
        'n1-nftify' => 'nftify',
        'travel-travel-care' => 'travel-care-2',
        'cato-cato' => 'cato',
        'unt-unity-network' => 'unity-network',
        'gnun-golden-inu' => 'golden-inu',
        'rft-rangers-fan-token' => 'rangers-fan-token',
        'angel-polylauncher' => 'polylauncher',
        'sata-signata' => 'signata',
        'entr-enterdao' => 'enterdao',
        'anchor-anchorswap' => 'anchorswap',
        'ac-acoconut' => 'acoconut',
        'foxgirl-foxgirl' => 'foxgirl',
        'pnl-true-pnl' => 'true-pnl',
        'cabo-catbonk' => 'catbonk',
        'msu-metasoccer' => 'metasoccer',
        'gogo-gogocoin' => 'gogocoin',
        'fight-crypto-fight-club' => 'crypto-fight-club',
        'hbot-hummingbot' => 'hummingbot',
        'gcoin-galaxy-fight-club' => 'galaxy-fight-club',
        'mevr-metaverse-vr' => 'metaverse-vr',
        'krida-krida-fans' => 'krida-fans',
        'poseidon-poseidon' => 'poseidon-2',
        'ply-playnity-token-wormhole' => 'playnity',
        'eft-energyfi' => 'energyfi',
        'ib-iron-bank' => 'iron-bank',
        'wzrd-wizardia' => 'wizardia',
        'soy-soy-finance' => 'soy-finance',
        'mca-movecash' => 'movecash',
        'dcar-dragon-crypto-argenti' => 'dragon-crypto-argenti',
        'power-unipower' => 'unipower',
        'hami-hamachi-finance' => 'hamachi-finance',
        'par-parachute' => 'parachute',
        'rare-superrarebears-rare' => 'superrarebears-rare',
        'swift-swiftcash' => 'swiftcash',
        'urd-urdex-finance' => 'urdex-finance',
        'ird-iridium' => 'iridium',
        'biso-biso' => 'biso',
        'n286-n286' => 'n286',
        'xfl-xfl' => 'xfl-token',
        'dackie-dackieswap' => 'dackieswap',
        'abn-antofy' => 'antofy',
        'tern-ternio' => 'ternio',
        'niox-autonio' => 'autonio',
        'ong-someesocial' => 'somee-social',
        'btcs-bitcoin-scrypt' => 'bitcoin-scrypt',
        'nlc2-nolimitcoin' => 'nolimitcoin',

    );

    if ($flip == true) {
        $fliped_array = array_flip($coin_list);
        return (isset($fliped_array[$coin_id])) ? $fliped_array[$coin_id] : null;
    } else {
        return (isset($coin_list[$coin_id])) ? $coin_list[$coin_id] : null;

    }

}

function celp_exchange_array($coin_id, $flip = false)
{
    $coin_list = array(
        "binance" => "binance",
        "bybit_spot" => "bybit-spot",
        "okex" => "okx",
        "gdax" => "coinbase",
        "kraken" => "kraken",
        "kucoin" => "kucoin",
        "crypto_com" => "cryptocom-exchange",
        "bitfinex" => "bitfinex",
        "binance_us" => "binance-us",
        "bitmart" => "bitmart",
        "mxc" => "MEXC",
        "bingx" => "bingx",
        "bitget" => "bitget",
        "bitstamp" => "bitstamp",
        "gemini" => "gemini",
        "okcoin" => "okcoin-international",
        "whitebit" => "whitebit",
        "latoken" => "latoken",
        "lbank" => "lbank",
        "digifinex" => "digifinex",
        "bitrue" => "bitrue",
        "upbit" => "upbit",
        "p2pb2b" => "p2b",
        "coinsbit" => "coinsbit",
        "phemex" => "phemex",
        "dextrade" => "dex-trade",
        "exmo" => "exmo",
        "fastex" => "fastex",
        "bitso" => "bitso",
        "bitkub" => "bitkub",
        "c_patex" => "c-patex",
        "cryptology" => "cryptology",
        "bitbank" => "bitbank",
        "indodax" => "indodax",
        "valr" => "valr",
        "nice_hash" => "nicehash",
        "pionex" => "pionex",
        "deepcoin" => "deepcoin",
        "cointr" => "cointradecx",
        "xt" => "xt",
        "btse" => "btse",
        "bitmax" => "ascendex",
        "bigone" => "bigone",
        "paribu" => "paribu",
        "probit" => "probit-exchange",
        "btcturk" => "btcturk",
        "bitflyer" => "bitflyer",
        "coincheck" => "coincheck",
        "coinex" => "coinex",
        "bitopro" => "bitopro",
        "independent_reserve" => "independent-reserve",
        "luno" => "luno",
        "finexbox" => "finexbox",
        "cex" => "cex",
        "btcmarkets" => "btcmarkets",
        "kuna" => "kuna",
        "emirex" => "emirex",
        "coin_metro" => "coinmetro",
        "bithumb" => "bithumb",
        "uniswap_v3_arbitrum" => "uniswap-arbitrum",
        "fameex" => "fameex",
        "uniswap_v2" => "uniswap-v2",
        "azbit" => "azbit",
        "bitvavo" => "bitvavo",
        "uniswap_v3_polygon_pos" => "uniswap-polygon-network",
        "coinone" => "coinone",
        "pancakeswap_new" => "pancakeswap-v2",
        "bitcoin_com" => "fmfwio",
        "uniswap_v3_optimism" => "uniswap-optimism",
        "sushiswap" => "sushiswap",
        "balancer" => "balancer-v2",
        "kanga" => "kanga-exchange",
        "korbit" => "korbit",
        "itbit" => "itbit",
        "bitstorage" => "bitstorage",
        "coinjar" => "coinjar-exchange",
        "wazirx" => "wazirx",
        "lcx" => "lcx-exchange",
        "coindcx" => "coindcx",
        "zaif" => "zaif",
        "blockchain_com" => "blockchainio",
        "nash" => "nash",
        "deversifi" => "deversifi",
        "bitforex" => "bitforex",
        "citex" => "citex",
        "quickswap_v3" => "quickswap-v3",
        "orca" => "orca-dex",
        "pancakeswap-v3-ethereum" => "pancakeswap_ethereum",
        "tokpie" => "tokpie",
        "gopax" => "gopax",
        "btcbox" => "btcbox",
        "bisq" => "bisq",
        "quickswap" => "quickswap",
        "catex" => "catex",
        "tarmex" => "tarmex",
        "tokenize" => "tokenize",
        "pangolin" => "pangolin",
        "sushiswap_arbitrum" => "sushiswap-arbitrum",
        "fraxswap_ethereum" => "fraxswap",
        "sushiswap_polygon_pos" => "sushiswap-polygon-network",
        "netswap" => "netswap",
        "uniswap_v3_celo" => "uniswap-v3",
        "tomb_swap_fantom" => "tomb-swap",
        "cherryswap" => "cherryswap",
        "stellaswap" => "stellaswap",
        "wanswap" => "wanswap",
        "tethys" => "tethys-finance",
        "spiritswap" => "spiritswap",
        "bakeryswap" => "bakeryswap",
        "paintswap" => "paintswap",
        "traderjoe-v2-arbitrum" => "trader-joe-v2-arbitrum",
        "apeswap_telos" => "apeswap",
        "beethoven_x_optimism" => "beethoven-x",
        "chiliz" => "chiliz",
        "hitbtc" => "hitbtc",

        "novadax" => "novadax",
        "bitbns" => "bitbns",
        "bitpanda" => "bitpanda-pro",
        "klayswap" => "klayswap",
        "zebpay" => "zebpay",
        "oceanex" => "oceanex",
        "idex" => "idex",
        "btc_trade_ua" => "btc-trade-ua",
        "solidly" => "solidly",
        "energiswap" => "energiswap",
        "bw" => "bw",
        "yobit" => "yobit",
        "cointiger" => "cointiger",
        "bitexlive" => "bitexlive",
        "bilaxy" => "bilaxy",
        "bit_com" => "bitcom-futures",
        "bitbay" => "zonda",
        "vindax" => "vindax",
        "fatbtc" => "fatbtc",
        "bancor" => "bancor-network",
        "narkasa" => "narkasa",
        "paymium" => "paymium",
        "loopring" => "loopring",
        "mdex" => "mdex",
        "honeyswap" => "honeyswap",
        "graviex" => "graviex",
        "curve_polygon" => "curve-finance-polygon-network",
        "freiexchange" => "freiexchange",
        "birake" => "birake",
        "lydia_finance" => "lydia-finance",
        "btc_alpha" => "btc-alpha",
        "mercatox" => "mercatox",
        "zigzag" => "zigzag",
        "kickex" => "kickex",
        "bitsten" => "bitsten",
        "dcoin" => "dcoin",
        'gate' => 'gateio',
        'mxc' => 'mexc',
        'coinw' => 'coinw',
        'coinstore' => 'coinstore',
        'xeggex' => 'xeggex',
        'bitmex_spot' => 'bitmex',
        'toobit' => 'toobit',
        'biconomy' => 'biconomy',
        'cex' => 'cexio',
        'pancakeswap-v3-bsc' => 'pancakeswap-v3-bsc',
        'camelot-v3' => 'camelot-v3',
        'pulsex' => 'pulsex',
        'mercado_bitcoin' => 'mercado-bitcoin',
        'foxbit' => 'foxbit',
        'icrypex' => 'icrypex',
        'pancakeswap-v3-ethereum' => 'pancakeswap-v3-ethereum',
        'traderjoe' => 'trader-joe',
        'maverick_protocol' => 'maverick-protocol',
        'uniswap-v3-base' => 'uniswap-v3-base',
        'balancer_arbitrum' => 'balancer-v2-arbitrum',
        'currency' => 'currency-com',
        'camelot' => 'camelot',
        'equalizer' => 'equalizer',
        'pulsex-v2' => 'pulsex-v2',
        'apeswap_bsc' => 'apeswap',
        'uniswap_v3_celo' => 'uniswap-v3-celo',
        'one_inch_liquidity_protocol' => '1inch-liquidity-protocol',
        'swapbased' => 'swapbased',
        'verse' => 'verse',
        'baseswap' => 'baseswap',
        'bydfi' => 'bydfi',
        'trade_ogre' => 'tradeogre',
        'changelly' => 'changelly-pro',
        'ramses' => 'ramses',
        'south_xchange' => 'southxchange',
        'bit_com' => 'bit',
        'dfyn' => 'dfyn',
        'localtrade' => 'localtrade',
        'degate' => 'degate',
        'beethovenx' => 'beethoven-x',
        'icecreamswap-core' => 'icecreamswap-core',
    );

    if ($flip == true) {
        $fliped_array = array_flip($coin_list);
        return (isset($fliped_array[$coin_id])) ? $fliped_array[$coin_id] : null;
    } else {
        return (isset($coin_list[$coin_id])) ? $coin_list[$coin_id] : null;

    }

}

function celp_getDecimalPart($number)
{
    // Extract the decimal part of the number
    $decimalPart = fmod($number, 1);

    // Convert the decimal part to an integer (remove the leading "0.")
    $decimalString = substr(strrchr($decimalPart, '.'), 1);

    // Get the first digit after the decimal point
    $firstDigit = isset($decimalString[0]) ? intval($decimalString[0]) : 0;

    return $firstDigit;
}

function celp_get_user_info() {

    global $wpdb;

    // Server and WP environment details
    $server_info = [
        'server_software'        => isset($_SERVER['SERVER_SOFTWARE']) ? sanitize_text_field($_SERVER['SERVER_SOFTWARE']) : 'N/A',
        'mysql_version'          => $wpdb ? sanitize_text_field($wpdb->get_var("SELECT VERSION()")) : 'N/A',
        'php_version'            => sanitize_text_field(phpversion() ?: 'N/A'),
        'wp_version'             => sanitize_text_field(get_bloginfo('version') ?: 'N/A'),
        'wp_debug'               => (defined('WP_DEBUG') && WP_DEBUG) ? 'Enabled' : 'Disabled',
        'wp_memory_limit'        => sanitize_text_field(ini_get('memory_limit') ?: 'N/A'),
        'wp_max_upload_size'     => sanitize_text_field(ini_get('upload_max_filesize') ?: 'N/A'),
        'wp_permalink_structure' => sanitize_text_field(get_option('permalink_structure') ?: 'Default'),
        'wp_multisite'           => is_multisite() ? 'Enabled' : 'Disabled',
        'wp_language'            => sanitize_text_field(get_option('WPLANG') ?: get_locale()),
        'wp_prefix'              => isset($wpdb->prefix) ? sanitize_key($wpdb->prefix) : 'N/A',
    ];

    // Theme details
    $theme = wp_get_theme();

    $theme_data = [
        'name'      => sanitize_text_field($theme->get('Name')),
        'version'   => sanitize_text_field($theme->get('Version')),
        'theme_uri' => esc_url($theme->get('ThemeURI')),
    ];

    // Ensure plugin functions are loaded
    if ( ! function_exists('get_plugins') ) {

        require_once ABSPATH . 'wp-admin/includes/plugin.php';
    }

    // Active plugins details
    $active_plugins = get_option('active_plugins', []);
    $plugin_data = [];

    foreach ( $active_plugins as $plugin_path ) {

        $plugin_info = get_plugin_data(WP_PLUGIN_DIR . '/' . sanitize_text_field($plugin_path));
        $author_url = ( isset( $plugin_info['AuthorURI'] ) && !empty( $plugin_info['AuthorURI'] ) ) ? esc_url( $plugin_info['AuthorURI'] ) : 'N/A';
        $plugin_url = ( isset( $plugin_info['PluginURI'] ) && !empty( $plugin_info['PluginURI'] ) ) ? esc_url( $plugin_info['PluginURI'] ) : 'N/A';

        $plugin_data[] = [

            'name'       => sanitize_text_field($plugin_info['Name']),
            'version'    => sanitize_text_field($plugin_info['Version']),
            'plugin_uri' => !empty($plugin_url) ? $plugin_url : $author_url,
        ];
    }

    return [
        'server_info'   => $server_info,
        'extra_details' => [
            'wp_theme'       => $theme_data,
            'active_plugins' => $plugin_data,
        ],
    ];

}